import logging
import traceback
from functools import wraps

from typing import Callable, Any


def _try_except() -> Callable:
    def decorate(func: Callable) -> Callable:

        @wraps(func)
        def wrapper(*args, **kwargs) -> Any:
            try:
                return func(*args, **kwargs)
            except (Exception,):
                traceback.print_exc()

        return wrapper

    return decorate
