import typing
from typing import ForwardRef
import PySide2.QtCore
import PySide2.QtGui
import shiboken2.Shiboken
from __future__ import annotations
import axipy.cpp_core_dp
import typing
QJsonValue = typing.Any

__all__ = ['CalcCartesian', 'CalcMode', 'CalcModeDefault', 'CalcModeLast', 'CalcOnEllipsoid', 'CalcOnSphere', 'Core', 'DefaultKeys', 'DefaultSettingsList', 'ProgressHandler', 'ShadowFloatFormatter', 'ShadowForeignKeyManager', 'ShadowIO', 'ShadowInformation', 'ShadowPluginManager', 'ShadowProgressHandler', 'ShadowSettings', 'ShadowTabFile', 'ShadowTask', 'ShadowTaskManager', 'StateObserver', 'Task', 'TaskProgressHandler', 'ValueObserver', 'defaultFilePath', 'defaultInterfaceTheme', 'defaultPathLocation', 'defaultTypeInterface', 'detectDefaultPythonFont', 'findCalcMode', 'isWaylandPlatform', 'isX11Platform', 'loadCodecFromJson', 'loadPointFromJson', 'loadQRectFFromJson', 'loadQSizeFromJson', 'loadQTransformFromJson', 'prefixCacheDir', 'runInNewThread', 'runInThread', 'saveCodecToJson', 'saveLineToJson', 'saveLineToJsonEmbedded', 'savePointToJson', 'savePolylineToJson', 'savePolylineToJsonEmbedded', 'saveQRectFToJson', 'saveQSizeToJson', 'saveQTransfomToJson', 'titanInterfaceStyle', 'toCalcMode', 'underWayland']
class CalcMode(shiboken2.Shiboken.Enum):
    CalcCartesian: typing.ClassVar[CalcMode]  # value = axipy.cpp_core_core.CalcMode.CalcCartesian
    CalcModeDefault: typing.ClassVar[CalcMode]  # value = axipy.cpp_core_core.CalcMode.CalcModeDefault
    CalcModeLast: typing.ClassVar[CalcMode]  # value = axipy.cpp_core_core.CalcMode.CalcModeLast
    CalcOnEllipsoid: typing.ClassVar[CalcMode]  # value = axipy.cpp_core_core.CalcMode.CalcOnEllipsoid
    CalcOnSphere: typing.ClassVar[CalcMode]  # value = axipy.cpp_core_core.CalcMode.CalcOnSphere
    values: typing.ClassVar[dict]  # value = {'CalcCartesian': axipy.cpp_core_core.CalcMode.CalcCartesian, 'CalcOnSphere': axipy.cpp_core_core.CalcMode.CalcOnSphere, 'CalcOnEllipsoid': axipy.cpp_core_core.CalcMode.CalcOnEllipsoid, 'CalcModeLast': axipy.cpp_core_core.CalcMode.CalcModeLast, 'CalcModeDefault': axipy.cpp_core_core.CalcMode.CalcModeDefault}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class Core(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def businessLogicContext() -> PySide2.QtCore.QObject:
        ...
    @staticmethod
    def businessLogicThread() -> PySide2.QtCore.QThread:
        ...
    @staticmethod
    def findService(*args, **kwargs):
        ...
    @staticmethod
    def gdalDebug(*args, **kwargs):
        ...
    @staticmethod
    def gdalError(*args, **kwargs):
        ...
    @staticmethod
    def info(*args, **kwargs):
        ...
    @staticmethod
    def registerService(*args, **kwargs):
        ...
    @staticmethod
    def serviceOperationMessage(*args, **kwargs):
        ...
    @staticmethod
    def warning(*args, **kwargs):
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def initCoordSysFactory(self) -> None:
        ...
    def initDependencies(self) -> None:
        ...
    def initLogger(self) -> None:
        ...
    def initProtection(self) -> None:
        ...
    def initialize(self) -> None:
        ...
    def installTranslators(self) -> None:
        ...
    def loadPlugins(self) -> None:
        ...
    def processEnvironment(self) -> PySide2.QtCore.QProcessEnvironment:
        ...
    def registerDataProviders(self) -> None:
        ...
    def translationLanguage(self) -> str:
        ...
    def translationLocale(self) -> PySide2.QtCore.QLocale:
        ...
class DefaultKeys(shiboken2.Shiboken.Object):
    class Key(shiboken2.Shiboken.Enum):
        ActiveMapView: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.ActiveMapView
        ActiveTableView: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.ActiveTableView
        ActiveView: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.ActiveView
        Count: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.Count
        Editable: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.Editable
        HasTables: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.HasTables
        Selection: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.Selection
        SelectionEditable: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.SelectionEditable
        SelectionEditableIsSame: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.SelectionEditableIsSame
        values: typing.ClassVar[dict]  # value = {'Selection': axipy.cpp_core_core.DefaultKeys.Key.Selection, 'Editable': axipy.cpp_core_core.DefaultKeys.Key.Editable, 'SelectionEditable': axipy.cpp_core_core.DefaultKeys.Key.SelectionEditable, 'SelectionEditableIsSame': axipy.cpp_core_core.DefaultKeys.Key.SelectionEditableIsSame, 'ActiveView': axipy.cpp_core_core.DefaultKeys.Key.ActiveView, 'ActiveMapView': axipy.cpp_core_core.DefaultKeys.Key.ActiveMapView, 'ActiveTableView': axipy.cpp_core_core.DefaultKeys.Key.ActiveTableView, 'HasTables': axipy.cpp_core_core.DefaultKeys.Key.HasTables, 'Count': axipy.cpp_core_core.DefaultKeys.Key.Count}
        @staticmethod
        def __new__(type, *args, **kwargs):
            """
            Create and return a new object.  See help(type) for accurate signature.
            """
        @staticmethod
        def __reduce__(*args, **kwargs):
            ...
        def __add__(self, value):
            """
            Return self+value.
            """
        def __and__(self, value):
            """
            Return self&value.
            """
        def __bool__(self):
            """
            self != 0
            """
        def __eq__(self, value):
            """
            Return self==value.
            """
        def __ge__(self, value):
            """
            Return self>=value.
            """
        def __gt__(self, value):
            """
            Return self>value.
            """
        def __hash__(self):
            """
            Return hash(self).
            """
        def __index__(self):
            """
            Return self converted to an integer, if self is suitable for use as an index into a list.
            """
        def __int__(self):
            """
            int(self)
            """
        def __le__(self, value):
            """
            Return self<=value.
            """
        def __lt__(self, value):
            """
            Return self<value.
            """
        def __mul__(self, value):
            """
            Return self*value.
            """
        def __ne__(self, value):
            """
            Return self!=value.
            """
        def __or__(self, value):
            """
            Return self|value.
            """
        def __pos__(self):
            """
            +self
            """
        def __radd__(self, value):
            """
            Return value+self.
            """
        def __rand__(self, value):
            """
            Return value&self.
            """
        def __repr__(self):
            """
            Return repr(self).
            """
        def __rmul__(self, value):
            """
            Return value*self.
            """
        def __ror__(self, value):
            """
            Return value|self.
            """
        def __rsub__(self, value):
            """
            Return value-self.
            """
        def __rxor__(self, value):
            """
            Return value^self.
            """
        def __str__(self):
            """
            Return str(self).
            """
        def __sub__(self, value):
            """
            Return self-value.
            """
        def __xor__(self, value):
            """
            Return self^value.
            """
    ActiveMapView: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.ActiveMapView
    ActiveTableView: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.ActiveTableView
    ActiveView: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.ActiveView
    Count: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.Count
    Editable: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.Editable
    HasTables: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.HasTables
    Selection: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.Selection
    SelectionEditable: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.SelectionEditable
    SelectionEditableIsSame: typing.ClassVar[DefaultKeys.Key]  # value = axipy.cpp_core_core.DefaultKeys.Key.SelectionEditableIsSame
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def names() -> typing.List[str]:
        ...
class DefaultSettingsList(shiboken2.Shiboken.Object):
    class Key(shiboken2.Shiboken.Enum):
        BrushCatalog: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.BrushCatalog
        BrushCatalogDefault: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.BrushCatalogDefault
        ColorForm: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorForm
        ColorHistory: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorHistory
        ColorNameEditFormat: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorNameEditFormat
        ColorNameEditSpace: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorNameEditSpace
        ColorNameHintFormat: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorNameHintFormat
        ColorPopupMode: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorPopupMode
        ColorPopupSize: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorPopupSize
        ColorPopupTab: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorPopupTab
        ColorSpec: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorSpec
        ColorTransform: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorTransform
        ConfirmNetworkAccess: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ConfirmNetworkAccess
        CreateTabAfterOpen: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.CreateTabAfterOpen
        DefaultCoordSystem: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.DefaultCoordSystem
        DefaultPathCache: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.DefaultPathCache
        DisableTabCompression: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.DisableTabCompression
        DistancePrecision: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.DistancePrecision
        DrawCoordSysBounds: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.DrawCoordSysBounds
        EditCentroidColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.EditCentroidColor
        EditNodeColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.EditNodeColor
        EditNodeSize: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.EditNodeSize
        EditResizePolicy: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.EditResizePolicy
        EditRotationPolicy: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.EditRotationPolicy
        EditSelectionColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.EditSelectionColor
        EnableSmartTabs: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.EnableSmartTabs
        FloatPrecision: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.FloatPrecision
        InterfaceTheme: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.InterfaceTheme
        IsMacWarningShown: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.IsMacWarningShown
        LastEditedPalette: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastEditedPalette
        LastNameFilter: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastNameFilter
        LastOpenImagePath: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastOpenImagePath
        LastOpenPath: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastOpenPath
        LastOpenedFan: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastOpenedFan
        LastOpenedPalette: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastOpenedPalette
        LastPathPython: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastPathPython
        LastPathWorkspace: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastPathWorkspace
        LastSavePath: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastSavePath
        LegendBackgroundColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LegendBackgroundColor
        LoadLastWorkspace: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LoadLastWorkspace
        LogLevel: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LogLevel
        MapBackgroundColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.MapBackgroundColor
        MeshSizeLayout: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.MeshSizeLayout
        MeshSizeLegend: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.MeshSizeLegend
        MinTabVersion: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.MinTabVersion
        NearlyGeometriesTopology: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.NearlyGeometriesTopology
        NodesUpdateMode: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.NodesUpdateMode
        PaletteDisplayMode: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PaletteDisplayMode
        PalettesDisplayMode: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PalettesDisplayMode
        PathsType: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PathsType
        PenCatalog: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PenCatalog
        PenCatalogDefault: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PenCatalogDefault
        PercentToShowMapView: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PercentToShowMapView
        PhysicalScreenSize: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PhysicalScreenSize
        PreferApplicationGrabber: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PreferApplicationGrabber
        PreserveScaleMap: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PreserveScaleMap
        PythonEditorFindOptions: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorFindOptions
        PythonEditorFontFamily: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorFontFamily
        PythonEditorFontSize: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorFontSize
        PythonEditorRecentFind: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorRecentFind
        PythonEditorRecentLimit: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorRecentLimit
        PythonEditorRecentReplace: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorRecentReplace
        PythonEditorShowWhiteSpaces: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorShowWhiteSpaces
        RasterTransformFormLastValues: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.RasterTransformFormLastValues
        ReadOnlyInformationTool: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ReadOnlyInformationTool
        RenameDataObjectFromTab: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.RenameDataObjectFromTab
        ReportBackgroundColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ReportBackgroundColor
        RibbonCaptionVisibility: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.RibbonCaptionVisibility
        RotateMapSize: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.RotateMapSize
        RulerColorLine: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.RulerColorLine
        RulerModeSpherical: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.RulerModeSpherical
        SaveAsToOriginalFileFolder: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SaveAsToOriginalFileFolder
        SelectByInformationTool: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SelectByInformationTool
        SensitiveMouse: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SensitiveMouse
        SettingsCount: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SettingsCount
        Shortcuts: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.Shortcuts
        ShowColorMenuMarker: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowColorMenuMarker
        ShowDegreeTypeNumeric: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowDegreeTypeNumeric
        ShowDrawingToolTip: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowDrawingToolTip
        ShowMapScaleBar: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowMapScaleBar
        ShowMeshLayout: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowMeshLayout
        ShowMeshLegend: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowMeshLegend
        ShowScrollOnMapView: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowScrollOnMapView
        ShowSplashScreen: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowSplashScreen
        SilentCloseMapWithThematic: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SilentCloseMapWithThematic
        SilentCloseNonEmptyReport: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SilentCloseNonEmptyReport
        SilentCloseWidget: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SilentCloseWidget
        SimpleCloseDialog: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SimpleCloseDialog
        SnapSensitiveRadius: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SnapSensitiveRadius
        SnapToGuidelinesLayout: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SnapToGuidelinesLayout
        SnapToGuidelinesLegend: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SnapToGuidelinesLegend
        SnapToMeshLayout: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SnapToMeshLayout
        SnapToMeshLegend: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SnapToMeshLegend
        SqlFormLastValues: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SqlFormLastValues
        SqlTreePopupWidth: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SqlTreePopupWidth
        StorePassword: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.StorePassword
        SymbolCatalog: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SymbolCatalog
        SymbolCatalogDefault: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SymbolCatalogDefault
        TableHeaderColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.TableHeaderColor
        TableHeaderFont: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.TableHeaderFont
        TableTextColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.TableTextColor
        TableTextFont: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.TableTextFont
        TableUniqueValuesLimit: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.TableUniqueValuesLimit
        TitanInterfaceStyle: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.TitanInterfaceStyle
        UseAntialiasing: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.UseAntialiasing
        UseLastSelectedFilter: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.UseLastSelectedFilter
        UseNativeColorDialog: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.UseNativeColorDialog
        UseNativeFileDialog: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.UseNativeFileDialog
        UserDataPaths: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.UserDataPaths
        UsingTypeInterface: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.UsingTypeInterface
        values: typing.ClassVar[dict]  # value = {'SnapSensitiveRadius': axipy.cpp_core_core.DefaultSettingsList.Key.SnapSensitiveRadius, 'SilentCloseWidget': axipy.cpp_core_core.DefaultSettingsList.Key.SilentCloseWidget, 'SilentCloseNonEmptyReport': axipy.cpp_core_core.DefaultSettingsList.Key.SilentCloseNonEmptyReport, 'SilentCloseMapWithThematic': axipy.cpp_core_core.DefaultSettingsList.Key.SilentCloseMapWithThematic, 'EditNodeColor': axipy.cpp_core_core.DefaultSettingsList.Key.EditNodeColor, 'EditCentroidColor': axipy.cpp_core_core.DefaultSettingsList.Key.EditCentroidColor, 'EditSelectionColor': axipy.cpp_core_core.DefaultSettingsList.Key.EditSelectionColor, 'EditNodeSize': axipy.cpp_core_core.DefaultSettingsList.Key.EditNodeSize, 'EditRotationPolicy': axipy.cpp_core_core.DefaultSettingsList.Key.EditRotationPolicy, 'EditResizePolicy': axipy.cpp_core_core.DefaultSettingsList.Key.EditResizePolicy, 'NearlyGeometriesTopology': axipy.cpp_core_core.DefaultSettingsList.Key.NearlyGeometriesTopology, 'NodesUpdateMode': axipy.cpp_core_core.DefaultSettingsList.Key.NodesUpdateMode, 'ShowDrawingToolTip': axipy.cpp_core_core.DefaultSettingsList.Key.ShowDrawingToolTip, 'FloatPrecision': axipy.cpp_core_core.DefaultSettingsList.Key.FloatPrecision, 'SensitiveMouse': axipy.cpp_core_core.DefaultSettingsList.Key.SensitiveMouse, 'ShowSplashScreen': axipy.cpp_core_core.DefaultSettingsList.Key.ShowSplashScreen, 'CreateTabAfterOpen': axipy.cpp_core_core.DefaultSettingsList.Key.CreateTabAfterOpen, 'UseNativeFileDialog': axipy.cpp_core_core.DefaultSettingsList.Key.UseNativeFileDialog, 'UseNativeColorDialog': axipy.cpp_core_core.DefaultSettingsList.Key.UseNativeColorDialog, 'RenameDataObjectFromTab': axipy.cpp_core_core.DefaultSettingsList.Key.RenameDataObjectFromTab, 'ShowDegreeTypeNumeric': axipy.cpp_core_core.DefaultSettingsList.Key.ShowDegreeTypeNumeric, 'RulerModeSpherical': axipy.cpp_core_core.DefaultSettingsList.Key.RulerModeSpherical, 'RulerColorLine': axipy.cpp_core_core.DefaultSettingsList.Key.RulerColorLine, 'UseAntialiasing': axipy.cpp_core_core.DefaultSettingsList.Key.UseAntialiasing, 'SimpleCloseDialog': axipy.cpp_core_core.DefaultSettingsList.Key.SimpleCloseDialog, 'PreserveScaleMap': axipy.cpp_core_core.DefaultSettingsList.Key.PreserveScaleMap, 'ShowMapScaleBar': axipy.cpp_core_core.DefaultSettingsList.Key.ShowMapScaleBar, 'ShowScrollOnMapView': axipy.cpp_core_core.DefaultSettingsList.Key.ShowScrollOnMapView, 'LoadLastWorkspace': axipy.cpp_core_core.DefaultSettingsList.Key.LoadLastWorkspace, 'UseLastSelectedFilter': axipy.cpp_core_core.DefaultSettingsList.Key.UseLastSelectedFilter, 'SelectByInformationTool': axipy.cpp_core_core.DefaultSettingsList.Key.SelectByInformationTool, 'ReadOnlyInformationTool': axipy.cpp_core_core.DefaultSettingsList.Key.ReadOnlyInformationTool, 'SaveAsToOriginalFileFolder': axipy.cpp_core_core.DefaultSettingsList.Key.SaveAsToOriginalFileFolder, 'PathsType': axipy.cpp_core_core.DefaultSettingsList.Key.PathsType, 'ShowMeshLayout': axipy.cpp_core_core.DefaultSettingsList.Key.ShowMeshLayout, 'MeshSizeLayout': axipy.cpp_core_core.DefaultSettingsList.Key.MeshSizeLayout, 'SnapToMeshLayout': axipy.cpp_core_core.DefaultSettingsList.Key.SnapToMeshLayout, 'ShowMeshLegend': axipy.cpp_core_core.DefaultSettingsList.Key.ShowMeshLegend, 'MeshSizeLegend': axipy.cpp_core_core.DefaultSettingsList.Key.MeshSizeLegend, 'SnapToMeshLegend': axipy.cpp_core_core.DefaultSettingsList.Key.SnapToMeshLegend, 'PythonEditorFontFamily': axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorFontFamily, 'PythonEditorFontSize': axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorFontSize, 'PythonEditorShowWhiteSpaces': axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorShowWhiteSpaces, 'PythonEditorRecentLimit': axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorRecentLimit, 'PythonEditorRecentFind': axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorRecentFind, 'PythonEditorRecentReplace': axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorRecentReplace, 'PythonEditorFindOptions': axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorFindOptions, 'RibbonCaptionVisibility': axipy.cpp_core_core.DefaultSettingsList.Key.RibbonCaptionVisibility, 'SqlFormLastValues': axipy.cpp_core_core.DefaultSettingsList.Key.SqlFormLastValues, 'RasterTransformFormLastValues': axipy.cpp_core_core.DefaultSettingsList.Key.RasterTransformFormLastValues, 'DrawCoordSysBounds': axipy.cpp_core_core.DefaultSettingsList.Key.DrawCoordSysBounds, 'IsMacWarningShown': axipy.cpp_core_core.DefaultSettingsList.Key.IsMacWarningShown, 'UsingTypeInterface': axipy.cpp_core_core.DefaultSettingsList.Key.UsingTypeInterface, 'TitanInterfaceStyle': axipy.cpp_core_core.DefaultSettingsList.Key.TitanInterfaceStyle, 'PercentToShowMapView': axipy.cpp_core_core.DefaultSettingsList.Key.PercentToShowMapView, 'LastSavePath': axipy.cpp_core_core.DefaultSettingsList.Key.LastSavePath, 'LastOpenPath': axipy.cpp_core_core.DefaultSettingsList.Key.LastOpenPath, 'LastPathWorkspace': axipy.cpp_core_core.DefaultSettingsList.Key.LastPathWorkspace, 'LastOpenImagePath': axipy.cpp_core_core.DefaultSettingsList.Key.LastOpenImagePath, 'LastPathPython': axipy.cpp_core_core.DefaultSettingsList.Key.LastPathPython, 'DefaultPathCache': axipy.cpp_core_core.DefaultSettingsList.Key.DefaultPathCache, 'UserDataPaths': axipy.cpp_core_core.DefaultSettingsList.Key.UserDataPaths, 'LastNameFilter': axipy.cpp_core_core.DefaultSettingsList.Key.LastNameFilter, 'Shortcuts': axipy.cpp_core_core.DefaultSettingsList.Key.Shortcuts, 'EnableSmartTabs': axipy.cpp_core_core.DefaultSettingsList.Key.EnableSmartTabs, 'DistancePrecision': axipy.cpp_core_core.DefaultSettingsList.Key.DistancePrecision, 'PhysicalScreenSize': axipy.cpp_core_core.DefaultSettingsList.Key.PhysicalScreenSize, 'SqlTreePopupWidth': axipy.cpp_core_core.DefaultSettingsList.Key.SqlTreePopupWidth, 'ColorPopupSize': axipy.cpp_core_core.DefaultSettingsList.Key.ColorPopupSize, 'RotateMapSize': axipy.cpp_core_core.DefaultSettingsList.Key.RotateMapSize, 'ColorHistory': axipy.cpp_core_core.DefaultSettingsList.Key.ColorHistory, 'LastOpenedPalette': axipy.cpp_core_core.DefaultSettingsList.Key.LastOpenedPalette, 'LastOpenedFan': axipy.cpp_core_core.DefaultSettingsList.Key.LastOpenedFan, 'LastEditedPalette': axipy.cpp_core_core.DefaultSettingsList.Key.LastEditedPalette, 'ColorPopupMode': axipy.cpp_core_core.DefaultSettingsList.Key.ColorPopupMode, 'ColorPopupTab': axipy.cpp_core_core.DefaultSettingsList.Key.ColorPopupTab, 'ColorNameHintFormat': axipy.cpp_core_core.DefaultSettingsList.Key.ColorNameHintFormat, 'ColorNameEditFormat': axipy.cpp_core_core.DefaultSettingsList.Key.ColorNameEditFormat, 'ColorNameEditSpace': axipy.cpp_core_core.DefaultSettingsList.Key.ColorNameEditSpace, 'PaletteDisplayMode': axipy.cpp_core_core.DefaultSettingsList.Key.PaletteDisplayMode, 'PalettesDisplayMode': axipy.cpp_core_core.DefaultSettingsList.Key.PalettesDisplayMode, 'ColorForm': axipy.cpp_core_core.DefaultSettingsList.Key.ColorForm, 'ColorTransform': axipy.cpp_core_core.DefaultSettingsList.Key.ColorTransform, 'ColorSpec': axipy.cpp_core_core.DefaultSettingsList.Key.ColorSpec, 'ShowColorMenuMarker': axipy.cpp_core_core.DefaultSettingsList.Key.ShowColorMenuMarker, 'PreferApplicationGrabber': axipy.cpp_core_core.DefaultSettingsList.Key.PreferApplicationGrabber, 'InterfaceTheme': axipy.cpp_core_core.DefaultSettingsList.Key.InterfaceTheme, 'MapBackgroundColor': axipy.cpp_core_core.DefaultSettingsList.Key.MapBackgroundColor, 'LegendBackgroundColor': axipy.cpp_core_core.DefaultSettingsList.Key.LegendBackgroundColor, 'ReportBackgroundColor': axipy.cpp_core_core.DefaultSettingsList.Key.ReportBackgroundColor, 'StorePassword': axipy.cpp_core_core.DefaultSettingsList.Key.StorePassword, 'SnapToGuidelinesLegend': axipy.cpp_core_core.DefaultSettingsList.Key.SnapToGuidelinesLegend, 'SnapToGuidelinesLayout': axipy.cpp_core_core.DefaultSettingsList.Key.SnapToGuidelinesLayout, 'TableUniqueValuesLimit': axipy.cpp_core_core.DefaultSettingsList.Key.TableUniqueValuesLimit, 'DisableTabCompression': axipy.cpp_core_core.DefaultSettingsList.Key.DisableTabCompression, 'MinTabVersion': axipy.cpp_core_core.DefaultSettingsList.Key.MinTabVersion, 'LogLevel': axipy.cpp_core_core.DefaultSettingsList.Key.LogLevel, 'TableTextFont': axipy.cpp_core_core.DefaultSettingsList.Key.TableTextFont, 'TableTextColor': axipy.cpp_core_core.DefaultSettingsList.Key.TableTextColor, 'TableHeaderFont': axipy.cpp_core_core.DefaultSettingsList.Key.TableHeaderFont, 'TableHeaderColor': axipy.cpp_core_core.DefaultSettingsList.Key.TableHeaderColor, 'DefaultCoordSystem': axipy.cpp_core_core.DefaultSettingsList.Key.DefaultCoordSystem, 'PenCatalog': axipy.cpp_core_core.DefaultSettingsList.Key.PenCatalog, 'BrushCatalog': axipy.cpp_core_core.DefaultSettingsList.Key.BrushCatalog, 'SymbolCatalog': axipy.cpp_core_core.DefaultSettingsList.Key.SymbolCatalog, 'PenCatalogDefault': axipy.cpp_core_core.DefaultSettingsList.Key.PenCatalogDefault, 'BrushCatalogDefault': axipy.cpp_core_core.DefaultSettingsList.Key.BrushCatalogDefault, 'SymbolCatalogDefault': axipy.cpp_core_core.DefaultSettingsList.Key.SymbolCatalogDefault, 'ConfirmNetworkAccess': axipy.cpp_core_core.DefaultSettingsList.Key.ConfirmNetworkAccess, 'SettingsCount': axipy.cpp_core_core.DefaultSettingsList.Key.SettingsCount}
        @staticmethod
        def __new__(type, *args, **kwargs):
            """
            Create and return a new object.  See help(type) for accurate signature.
            """
        @staticmethod
        def __reduce__(*args, **kwargs):
            ...
        def __add__(self, value):
            """
            Return self+value.
            """
        def __and__(self, value):
            """
            Return self&value.
            """
        def __bool__(self):
            """
            self != 0
            """
        def __eq__(self, value):
            """
            Return self==value.
            """
        def __ge__(self, value):
            """
            Return self>=value.
            """
        def __gt__(self, value):
            """
            Return self>value.
            """
        def __hash__(self):
            """
            Return hash(self).
            """
        def __index__(self):
            """
            Return self converted to an integer, if self is suitable for use as an index into a list.
            """
        def __int__(self):
            """
            int(self)
            """
        def __le__(self, value):
            """
            Return self<=value.
            """
        def __lt__(self, value):
            """
            Return self<value.
            """
        def __mul__(self, value):
            """
            Return self*value.
            """
        def __ne__(self, value):
            """
            Return self!=value.
            """
        def __or__(self, value):
            """
            Return self|value.
            """
        def __pos__(self):
            """
            +self
            """
        def __radd__(self, value):
            """
            Return value+self.
            """
        def __rand__(self, value):
            """
            Return value&self.
            """
        def __repr__(self):
            """
            Return repr(self).
            """
        def __rmul__(self, value):
            """
            Return value*self.
            """
        def __ror__(self, value):
            """
            Return value|self.
            """
        def __rsub__(self, value):
            """
            Return value-self.
            """
        def __rxor__(self, value):
            """
            Return value^self.
            """
        def __str__(self):
            """
            Return str(self).
            """
        def __sub__(self, value):
            """
            Return self-value.
            """
        def __xor__(self, value):
            """
            Return self^value.
            """
    BrushCatalog: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.BrushCatalog
    BrushCatalogDefault: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.BrushCatalogDefault
    ColorForm: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorForm
    ColorHistory: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorHistory
    ColorNameEditFormat: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorNameEditFormat
    ColorNameEditSpace: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorNameEditSpace
    ColorNameHintFormat: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorNameHintFormat
    ColorPopupMode: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorPopupMode
    ColorPopupSize: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorPopupSize
    ColorPopupTab: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorPopupTab
    ColorSpec: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorSpec
    ColorTransform: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ColorTransform
    ConfirmNetworkAccess: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ConfirmNetworkAccess
    CreateTabAfterOpen: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.CreateTabAfterOpen
    DefaultCoordSystem: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.DefaultCoordSystem
    DefaultPathCache: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.DefaultPathCache
    DisableTabCompression: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.DisableTabCompression
    DistancePrecision: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.DistancePrecision
    DrawCoordSysBounds: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.DrawCoordSysBounds
    EditCentroidColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.EditCentroidColor
    EditNodeColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.EditNodeColor
    EditNodeSize: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.EditNodeSize
    EditResizePolicy: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.EditResizePolicy
    EditRotationPolicy: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.EditRotationPolicy
    EditSelectionColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.EditSelectionColor
    EnableSmartTabs: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.EnableSmartTabs
    FloatPrecision: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.FloatPrecision
    InterfaceTheme: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.InterfaceTheme
    IsMacWarningShown: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.IsMacWarningShown
    LastEditedPalette: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastEditedPalette
    LastNameFilter: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastNameFilter
    LastOpenImagePath: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastOpenImagePath
    LastOpenPath: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastOpenPath
    LastOpenedFan: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastOpenedFan
    LastOpenedPalette: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastOpenedPalette
    LastPathPython: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastPathPython
    LastPathWorkspace: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastPathWorkspace
    LastSavePath: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LastSavePath
    LegendBackgroundColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LegendBackgroundColor
    LoadLastWorkspace: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LoadLastWorkspace
    LogLevel: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.LogLevel
    MapBackgroundColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.MapBackgroundColor
    MeshSizeLayout: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.MeshSizeLayout
    MeshSizeLegend: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.MeshSizeLegend
    MinTabVersion: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.MinTabVersion
    NearlyGeometriesTopology: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.NearlyGeometriesTopology
    NodesUpdateMode: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.NodesUpdateMode
    PaletteDisplayMode: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PaletteDisplayMode
    PalettesDisplayMode: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PalettesDisplayMode
    PathsType: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PathsType
    PenCatalog: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PenCatalog
    PenCatalogDefault: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PenCatalogDefault
    PercentToShowMapView: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PercentToShowMapView
    PhysicalScreenSize: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PhysicalScreenSize
    PreferApplicationGrabber: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PreferApplicationGrabber
    PreserveScaleMap: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PreserveScaleMap
    PythonEditorFindOptions: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorFindOptions
    PythonEditorFontFamily: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorFontFamily
    PythonEditorFontSize: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorFontSize
    PythonEditorRecentFind: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorRecentFind
    PythonEditorRecentLimit: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorRecentLimit
    PythonEditorRecentReplace: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorRecentReplace
    PythonEditorShowWhiteSpaces: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.PythonEditorShowWhiteSpaces
    RasterTransformFormLastValues: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.RasterTransformFormLastValues
    ReadOnlyInformationTool: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ReadOnlyInformationTool
    RenameDataObjectFromTab: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.RenameDataObjectFromTab
    ReportBackgroundColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ReportBackgroundColor
    RibbonCaptionVisibility: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.RibbonCaptionVisibility
    RotateMapSize: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.RotateMapSize
    RulerColorLine: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.RulerColorLine
    RulerModeSpherical: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.RulerModeSpherical
    SaveAsToOriginalFileFolder: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SaveAsToOriginalFileFolder
    SelectByInformationTool: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SelectByInformationTool
    SensitiveMouse: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SensitiveMouse
    SettingsCount: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SettingsCount
    Shortcuts: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.Shortcuts
    ShowColorMenuMarker: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowColorMenuMarker
    ShowDegreeTypeNumeric: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowDegreeTypeNumeric
    ShowDrawingToolTip: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowDrawingToolTip
    ShowMapScaleBar: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowMapScaleBar
    ShowMeshLayout: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowMeshLayout
    ShowMeshLegend: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowMeshLegend
    ShowScrollOnMapView: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowScrollOnMapView
    ShowSplashScreen: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.ShowSplashScreen
    SilentCloseMapWithThematic: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SilentCloseMapWithThematic
    SilentCloseNonEmptyReport: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SilentCloseNonEmptyReport
    SilentCloseWidget: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SilentCloseWidget
    SimpleCloseDialog: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SimpleCloseDialog
    SnapSensitiveRadius: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SnapSensitiveRadius
    SnapToGuidelinesLayout: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SnapToGuidelinesLayout
    SnapToGuidelinesLegend: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SnapToGuidelinesLegend
    SnapToMeshLayout: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SnapToMeshLayout
    SnapToMeshLegend: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SnapToMeshLegend
    SqlFormLastValues: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SqlFormLastValues
    SqlTreePopupWidth: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SqlTreePopupWidth
    StorePassword: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.StorePassword
    SymbolCatalog: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SymbolCatalog
    SymbolCatalogDefault: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.SymbolCatalogDefault
    TableHeaderColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.TableHeaderColor
    TableHeaderFont: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.TableHeaderFont
    TableTextColor: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.TableTextColor
    TableTextFont: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.TableTextFont
    TableUniqueValuesLimit: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.TableUniqueValuesLimit
    TitanInterfaceStyle: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.TitanInterfaceStyle
    UseAntialiasing: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.UseAntialiasing
    UseLastSelectedFilter: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.UseLastSelectedFilter
    UseNativeColorDialog: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.UseNativeColorDialog
    UseNativeFileDialog: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.UseNativeFileDialog
    UserDataPaths: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.UserDataPaths
    UsingTypeInterface: typing.ClassVar[DefaultSettingsList.Key]  # value = axipy.cpp_core_core.DefaultSettingsList.Key.UsingTypeInterface
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def isDeprecated(key: DefaultSettingsList.Key) -> bool:
        ...
    def at(self, key: DefaultSettingsList.Key) -> typing.Any:
        ...
    def name(self, key: DefaultSettingsList.Key) -> str:
        ...
class ProgressHandler(PySide2.QtCore.QObject):
    class ExtraData(shiboken2.Shiboken.Enum):
        Default: typing.ClassVar[ProgressHandler.ExtraData]  # value = axipy.cpp_core_core.ProgressHandler.ExtraData.Default
        GuiResponsibility: typing.ClassVar[ProgressHandler.ExtraData]  # value = axipy.cpp_core_core.ProgressHandler.ExtraData.GuiResponsibility
        values: typing.ClassVar[dict]  # value = {'Default': axipy.cpp_core_core.ProgressHandler.ExtraData.Default, 'GuiResponsibility': axipy.cpp_core_core.ProgressHandler.ExtraData.GuiResponsibility}
        @staticmethod
        def __new__(type, *args, **kwargs):
            """
            Create and return a new object.  See help(type) for accurate signature.
            """
        @staticmethod
        def __reduce__(*args, **kwargs):
            ...
        def __add__(self, value):
            """
            Return self+value.
            """
        def __and__(self, value):
            """
            Return self&value.
            """
        def __bool__(self):
            """
            self != 0
            """
        def __eq__(self, value):
            """
            Return self==value.
            """
        def __ge__(self, value):
            """
            Return self>=value.
            """
        def __gt__(self, value):
            """
            Return self>value.
            """
        def __hash__(self):
            """
            Return hash(self).
            """
        def __index__(self):
            """
            Return self converted to an integer, if self is suitable for use as an index into a list.
            """
        def __int__(self):
            """
            int(self)
            """
        def __le__(self, value):
            """
            Return self<=value.
            """
        def __lt__(self, value):
            """
            Return self<value.
            """
        def __mul__(self, value):
            """
            Return self*value.
            """
        def __ne__(self, value):
            """
            Return self!=value.
            """
        def __or__(self, value):
            """
            Return self|value.
            """
        def __pos__(self):
            """
            +self
            """
        def __radd__(self, value):
            """
            Return value+self.
            """
        def __rand__(self, value):
            """
            Return value&self.
            """
        def __repr__(self):
            """
            Return repr(self).
            """
        def __rmul__(self, value):
            """
            Return value*self.
            """
        def __ror__(self, value):
            """
            Return value|self.
            """
        def __rsub__(self, value):
            """
            Return value-self.
            """
        def __rxor__(self, value):
            """
            Return value^self.
            """
        def __str__(self):
            """
            Return str(self).
            """
        def __sub__(self, value):
            """
            Return self-value.
            """
        def __xor__(self, value):
            """
            Return self^value.
            """
    Default: typing.ClassVar[ProgressHandler.ExtraData]  # value = axipy.cpp_core_core.ProgressHandler.ExtraData.Default
    GuiResponsibility: typing.ClassVar[ProgressHandler.ExtraData]  # value = axipy.cpp_core_core.ProgressHandler.ExtraData.GuiResponsibility
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    cancelMethodChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def cancelRequest(*args, **kwargs):
        ...
    cancelableFlagChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    canceled: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def error(*args, **kwargs):
        ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def hideProgress(*args, **kwargs):
        ...
    messageChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    paused: typing.ClassVar[PySide2.QtCore.Signal] = ...
    progressRangeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    progressValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    progressValueIncreased: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def showProgressByRequest(*args, **kwargs):
        ...
    started: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def successful(*args, **kwargs):
        ...
    windowTitleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def cancel(self) -> None:
        ...
    def disableCancelable(self) -> None:
        ...
    def enableCancelable(self) -> None:
        ...
    def finish(self) -> None:
        ...
    def id(self) -> PySide2.QtCore.QUuid:
        ...
    def invokeType(self) -> PySide2.QtCore.Qt.ConnectionType:
        ...
    def isCanceled(self) -> bool:
        ...
    def isDeleted(self) -> bool:
        ...
    def isFinished(self) -> bool:
        ...
    def isRunning(self) -> bool:
        ...
    def progress(self) -> float:
        ...
    def sendCancel(self) -> None:
        ...
    def setFinalProgress(self) -> None:
        ...
    def setIgnoreFinal(self, ignore: bool = True) -> None:
        ...
    def setInvokeType(self, connectionType: PySide2.QtCore.Qt.ConnectionType) -> None:
        ...
    def setMessage(self, title: str) -> None:
        ...
    def setProgress(self, value: float) -> None:
        ...
    def setWindowTitle(self, title: str) -> None:
        ...
    def stopTaskWithEvents(self) -> None:
        ...
    def stopTaskWithoutEvents(self) -> None:
        ...
    def waitForFinished(self, flags: PySide2.QtCore.QEventLoop.ProcessEventsFlags = ...) -> None:
        ...
class ShadowFloatFormatter(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def float_ceil(value: float, precision: int) -> float:
        ...
    @staticmethod
    def float_floor(value: float, precision: int) -> float:
        ...
    @staticmethod
    def float_round(value: float, precision: int) -> float:
        ...
    @staticmethod
    def float_round_signific(value: float, precision: int) -> float:
        ...
    @staticmethod
    def float_to_str(value: float, use_delimeter: bool, precision: int) -> str:
        ...
    @staticmethod
    def to_localized_string(value: float, locale: PySide2.QtCore.QLocale = {}) -> str:
        ...
    @staticmethod
    def to_localized_string_round(value: float, precision: int, locale: PySide2.QtCore.QLocale = {}) -> str:
        ...
class ShadowForeignKeyManager(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def descriptRegistered(self) -> typing.List[typing.Dict[str, QJsonValue]]:
        ...
    def registerRelation(self, base: typing.Dict[str, QJsonValue], foreign: typing.Dict[str, QJsonValue], relation: typing.Dict[str, QJsonValue]) -> None:
        ...
    def unregisterRelation(self, base: typing.Dict[str, QJsonValue], foreign: typing.Dict[str, QJsonValue]) -> None:
        ...
class ShadowIO(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def checkQuery(self, queryText: str, tables: typing.Sequence[axipy.cpp_core_dp.ShadowDataObject], dialect: str) -> typing.Tuple[bool, str]:
        ...
    def create(self, definition: typing.Dict[str, QJsonValue]) -> axipy.cpp_core_dp.ShadowDataObject:
        ...
    def currentSqlDialect(self) -> str:
        ...
    def findProviderToOpen(self, definition: typing.Dict[str, QJsonValue]) -> str:
        ...
    def mapinfo_mapcatalog(self, definition: typing.Dict[str, QJsonValue]) -> axipy.cpp_core_dp.ShadowMapinfoMapcatalog:
        ...
    def open(self, definition: typing.Dict[str, QJsonValue], ignoreNonRegisterRaster: bool = False) -> axipy.cpp_core_dp.ShadowDataObject:
        ...
    def openfile(self, filepath: str, dataobject: str = {}, provider: str = {}) -> axipy.cpp_core_dp.ShadowDataObject:
        ...
    def providers(self) -> typing.List[str]:
        ...
    def providersInfo(self) -> typing.Dict[str, str]:
        ...
    def query(self, queryText: str, tables: typing.Sequence[axipy.cpp_core_dp.ShadowDataObject], dialect: str) -> axipy.cpp_core_dp.ShadowQueryTable:
        ...
    def read_contents(self, definition: typing.Dict[str, QJsonValue]) -> typing.List[str]:
        ...
    def setDefaultCatalog(self, catalog: axipy.cpp_core_dp.ShadowDataCatalog) -> None:
        ...
class ShadowInformation(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def compareVersion(major: int, minor: int, patch: int) -> int:
        ...
    @staticmethod
    def currentVersion() -> int:
        ...
    @staticmethod
    def currentVersionFullString() -> str:
        ...
    @staticmethod
    def currentVersionString() -> str:
        ...
class ShadowPluginManager(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    loaded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    unloaded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def isLoaded(self, id: str) -> bool:
        ...
    def load(self, id: str) -> bool:
        ...
    def metadata(self) -> typing.List[typing.Dict[str, QJsonValue]]:
        ...
    def unload(self, id: str) -> None:
        ...
    def userPluginPaths(self) -> typing.List[str]:
        ...
class ShadowProgressHandler(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    range_changed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_progress_max(self) -> float:
        ...
    def get_progress_min(self) -> float:
        ...
    def get_progress_range(self) -> typing.List[float]:
        ...
    def prepare_to_write_changes(self) -> None:
        ...
    def set_progress_max(self, max: float) -> None:
        ...
    def set_progress_min(self, min: float) -> None:
        ...
    def set_progress_range(self, min: float, max: float) -> None:
        ...
    def shadow(self) -> ProgressHandler:
        ...
class ShadowSettings(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def default_value(key: DefaultSettingsList.Key) -> typing.Any:
        ...
    @staticmethod
    def set_value(key: DefaultSettingsList.Key, value: typing.Any) -> None:
        ...
    @staticmethod
    def value(key: DefaultSettingsList.Key) -> typing.Any:
        ...
class ShadowTabFile(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def generateTab(self, dataObject: axipy.cpp_core_dp.ShadowDataObject, fi_out: PySide2.QtCore.QFileInfo, params: typing.Dict[str, QJsonValue]) -> bool:
        ...
    def suggestTabName(self, dataObject: axipy.cpp_core_dp.ShadowDataObject) -> str:
        ...
class ShadowTask(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def init_progress_handler(self, shadowPh: ShadowProgressHandler) -> None:
        ...
    def moveTaskToThread(self, thread: PySide2.QtCore.QThread) -> None:
        ...
    def run_internally(self) -> None:
        ...
    def start(self) -> None:
        ...
class ShadowTaskManager(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def gui_object(self) -> PySide2.QtCore.QObject:
        ...
    def run_in_gui(self, task: ShadowTask) -> None:
        ...
    def start_task(self, task: ShadowTask) -> None:
        ...
class StateObserver(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def create(self, name: str, initValue: typing.Any = {}) -> ValueObserver:
        ...
    def find(self, name: str) -> ValueObserver:
        ...
    def get(self, name: str) -> ValueObserver:
        ...
    def keys(self) -> typing.List[str]:
        ...
    def remove(self, name: str) -> bool:
        ...
class Task(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def canCancel(self) -> bool:
        ...
    def canPause(self) -> bool:
        ...
    def cancel(self) -> None:
        ...
    def cancelRequested(self) -> bool:
        ...
    def continueWork(self) -> None:
        ...
    def enterCancelledState(self) -> None:
        ...
    def enterFinishedState(self) -> None:
        ...
    def enterPausedState(self) -> None:
        ...
    def enterSuccessfulState(self) -> None:
        ...
    def enterWaitingState(self) -> None:
        ...
    def isCancelled(self) -> bool:
        ...
    def isFinished(self) -> bool:
        ...
    def isPaused(self) -> bool:
        ...
    def isRunning(self) -> bool:
        ...
    def isSuccessful(self) -> bool:
        ...
    def isWaiting(self) -> bool:
        ...
    def moveTaskToThread(self, thread: PySide2.QtCore.QThread) -> None:
        ...
    def onCancelRequested(self) -> None:
        ...
    def onContinue(self) -> None:
        ...
    def onPauseRequested(self) -> None:
        ...
    def onStart(self) -> None:
        ...
    def pause(self) -> None:
        ...
    def pauseRequested(self) -> bool:
        ...
    def start(self) -> None:
        ...
class TaskProgressHandler(ProgressHandler):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    cancelMethodChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def cancelRequest(*args, **kwargs):
        ...
    cancelableFlagChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    canceled: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def error(*args, **kwargs):
        ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def hideProgress(*args, **kwargs):
        ...
    messageChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    paused: typing.ClassVar[PySide2.QtCore.Signal] = ...
    progressRangeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    progressValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    progressValueIncreased: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def showProgressByRequest(*args, **kwargs):
        ...
    started: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def successful(*args, **kwargs):
        ...
    windowTitleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def cancel(self) -> None:
        ...
class ValueObserver(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    changed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __call__(self) -> typing.Any:
        """
        Call self as a function.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def setValue(self, value: typing.Any) -> None:
        ...
    def value(self) -> typing.Any:
        ...
def defaultFilePath(d: PySide2.QtCore.QDir, path: str) -> str:
    ...
def defaultInterfaceTheme() -> str:
    ...
def defaultPathLocation() -> str:
    ...
def defaultTypeInterface() -> str:
    ...
def detectDefaultPythonFont() -> str:
    ...
def findCalcMode(modeName: str) -> CalcMode:
    ...
def isWaylandPlatform() -> bool:
    ...
def isX11Platform() -> bool:
    ...
def loadCodecFromJson(value: QJsonValue) -> PySide2.QtCore.QTextCodec:
    ...
def loadPointFromJson(value: QJsonValue) -> PySide2.QtCore.QPointF:
    ...
def loadQRectFFromJson(value: QJsonValue) -> PySide2.QtCore.QRectF:
    ...
def loadQSizeFromJson(value: QJsonValue) -> PySide2.QtCore.QSize:
    ...
def loadQTransformFromJson(value: QJsonValue) -> PySide2.QtGui.QTransform:
    ...
def prefixCacheDir() -> str:
    ...
def runInNewThread(worker: Task) -> None:
    ...
def runInThread(worker: Task, thread: PySide2.QtCore.QThread) -> None:
    ...
def saveCodecToJson(codec: PySide2.QtCore.QTextCodec) -> QJsonValue:
    ...
def saveLineToJson(line: PySide2.QtCore.QLineF) -> QJsonValue:
    ...
def saveLineToJsonEmbedded(line: PySide2.QtCore.QLineF) -> QJsonValue:
    ...
def savePointToJson(point: PySide2.QtCore.QPointF) -> QJsonValue:
    ...
def savePolylineToJson(polyline: typing.List[PySide2.QtCore.QPointF]) -> QJsonValue:
    ...
def savePolylineToJsonEmbedded(polyline: typing.List[PySide2.QtCore.QPointF]) -> QJsonValue:
    ...
def saveQRectFToJson(rect: PySide2.QtCore.QRectF) -> QJsonValue:
    ...
def saveQSizeToJson(size: PySide2.QtCore.QSize) -> QJsonValue:
    ...
def saveQTransfomToJson(transform: PySide2.QtGui.QTransform) -> QJsonValue:
    ...
def titanInterfaceStyle() -> str:
    ...
def toCalcMode(mode: int) -> CalcMode:
    ...
def underWayland() -> bool:
    ...
CalcCartesian: CalcMode  # value = axipy.cpp_core_core.CalcMode.CalcCartesian
CalcModeDefault: CalcMode  # value = axipy.cpp_core_core.CalcMode.CalcModeDefault
CalcModeLast: CalcMode  # value = axipy.cpp_core_core.CalcMode.CalcModeLast
CalcOnEllipsoid: CalcMode  # value = axipy.cpp_core_core.CalcMode.CalcOnEllipsoid
CalcOnSphere: CalcMode  # value = axipy.cpp_core_core.CalcMode.CalcOnSphere
