from abc import ABC, abstractmethod
from pathlib import Path
from typing import List

from .dependency import Dependencies

__all__: List[str] = [
    "InstallError",
    "DependencyInstaller",
    "Dependencies",
]


class InstallError(RuntimeError):
    pass


class DependencyInstaller(ABC):
    @abstractmethod
    def install(self, dependency: Dependencies, dependencies_destination: Path) -> None:
        """Installs dependencies."""
        pass
