from typing import overload
import PySide2.QtCore
import PySide2.QtGui
import shiboken2
import typing
T = typing.TypeVar('T')

class QAbstractButton(QWidget):
    clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    released: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    toggled: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def animateClick(self, msec: int = ...) -> None: ...
    def autoExclusive(self) -> bool: ...
    def autoRepeat(self) -> bool: ...
    def autoRepeatDelay(self) -> int: ...
    def autoRepeatInterval(self) -> int: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent) -> None: ...
    def checkStateSet(self) -> None: ...
    def click(self) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, e: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, e: PySide2.QtGui.QFocusEvent) -> None: ...
    def group(self) -> QButtonGroup: ...
    def hitButton(self, pos: PySide2.QtCore.QPoint) -> bool: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isDown(self) -> bool: ...
    def keyPressEvent(self, e: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, e: PySide2.QtGui.QKeyEvent) -> None: ...
    def mouseMoveEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def nextCheckState(self) -> None: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def setAutoExclusive(self, arg__1: bool) -> None: ...
    def setAutoRepeat(self, arg__1: bool) -> None: ...
    def setAutoRepeatDelay(self, arg__1: int) -> None: ...
    def setAutoRepeatInterval(self, arg__1: int) -> None: ...
    def setCheckable(self, arg__1: bool) -> None: ...
    def setChecked(self, arg__1: bool) -> None: ...
    def setDown(self, arg__1: bool) -> None: ...
    def setIcon(self, icon: PySide2.QtGui.QIcon) -> None: ...
    def setIconSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setShortcut(self, key: typing.Union[PySide2.QtGui.QKeySequence,str]) -> None: ...
    def setText(self, text: str) -> None: ...
    def shortcut(self) -> PySide2.QtGui.QKeySequence: ...
    def text(self) -> str: ...
    def timerEvent(self, e: PySide2.QtCore.QTimerEvent) -> None: ...
    def toggle(self) -> None: ...

class QAbstractGraphicsShapeItem(QGraphicsItem):
    def __init__(self, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    def brush(self) -> PySide2.QtGui.QBrush: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def pen(self) -> PySide2.QtGui.QPen: ...
    def setBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
    def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...

class QAbstractItemDelegate(PySide2.QtCore.QObject):
    class EndEditHint:
        EditNextItem: typing.ClassVar[QAbstractItemDelegate.EndEditHint] = ...
        EditPreviousItem: typing.ClassVar[QAbstractItemDelegate.EndEditHint] = ...
        NoHint: typing.ClassVar[QAbstractItemDelegate.EndEditHint] = ...
        RevertModelCache: typing.ClassVar[QAbstractItemDelegate.EndEditHint] = ...
        SubmitModelCache: typing.ClassVar[QAbstractItemDelegate.EndEditHint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractItemDelegate.EndEditHint: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractItemDelegate.EndEditHint: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractItemDelegate.EndEditHint: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractItemDelegate.EndEditHint: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractItemDelegate.EndEditHint: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractItemDelegate.EndEditHint: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractItemDelegate.EndEditHint: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractItemDelegate.EndEditHint: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractItemDelegate.EndEditHint: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractItemDelegate.EndEditHint: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractItemDelegate.EndEditHint: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractItemDelegate.EndEditHint: ...
    EditNextItem: typing.ClassVar[QAbstractItemDelegate.EndEditHint] = ...
    EditPreviousItem: typing.ClassVar[QAbstractItemDelegate.EndEditHint] = ...
    NoHint: typing.ClassVar[QAbstractItemDelegate.EndEditHint] = ...
    RevertModelCache: typing.ClassVar[QAbstractItemDelegate.EndEditHint] = ...
    SubmitModelCache: typing.ClassVar[QAbstractItemDelegate.EndEditHint] = ...
    closeEditor: typing.ClassVar[PySide2.QtCore.Signal] = ...
    commitData: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sizeHintChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def createEditor(self, parent: typing.Union[QWidget,None], option: QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> QWidget: ...
    def destroyEditor(self, editor: QWidget, index: PySide2.QtCore.QModelIndex) -> None: ...
    def editorEvent(self, event: PySide2.QtCore.QEvent, model: PySide2.QtCore.QAbstractItemModel, option: QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @classmethod
    def elidedText(cls, fontMetrics: PySide2.QtGui.QFontMetrics, width: int, mode: PySide2.QtCore.Qt.TextElideMode, text: str) -> str: ...
    def helpEvent(self, event: PySide2.QtGui.QHelpEvent, view: QAbstractItemView, option: QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> None: ...
    def paintingRoles(self) -> typing.List[int]: ...
    def setEditorData(self, editor: QWidget, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setModelData(self, editor: QWidget, model: PySide2.QtCore.QAbstractItemModel, index: PySide2.QtCore.QModelIndex) -> None: ...
    def sizeHint(self, option: QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def updateEditorGeometry(self, editor: QWidget, option: QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> None: ...

class QAbstractItemView(QAbstractScrollArea):
    class CursorAction:
        MoveDown: typing.ClassVar[QAbstractItemView.CursorAction] = ...
        MoveEnd: typing.ClassVar[QAbstractItemView.CursorAction] = ...
        MoveHome: typing.ClassVar[QAbstractItemView.CursorAction] = ...
        MoveLeft: typing.ClassVar[QAbstractItemView.CursorAction] = ...
        MoveNext: typing.ClassVar[QAbstractItemView.CursorAction] = ...
        MovePageDown: typing.ClassVar[QAbstractItemView.CursorAction] = ...
        MovePageUp: typing.ClassVar[QAbstractItemView.CursorAction] = ...
        MovePrevious: typing.ClassVar[QAbstractItemView.CursorAction] = ...
        MoveRight: typing.ClassVar[QAbstractItemView.CursorAction] = ...
        MoveUp: typing.ClassVar[QAbstractItemView.CursorAction] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractItemView.CursorAction: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractItemView.CursorAction: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractItemView.CursorAction: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractItemView.CursorAction: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractItemView.CursorAction: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractItemView.CursorAction: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractItemView.CursorAction: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractItemView.CursorAction: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractItemView.CursorAction: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractItemView.CursorAction: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractItemView.CursorAction: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractItemView.CursorAction: ...

    class DragDropMode:
        DragDrop: typing.ClassVar[QAbstractItemView.DragDropMode] = ...
        DragOnly: typing.ClassVar[QAbstractItemView.DragDropMode] = ...
        DropOnly: typing.ClassVar[QAbstractItemView.DragDropMode] = ...
        InternalMove: typing.ClassVar[QAbstractItemView.DragDropMode] = ...
        NoDragDrop: typing.ClassVar[QAbstractItemView.DragDropMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractItemView.DragDropMode: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractItemView.DragDropMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractItemView.DragDropMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractItemView.DragDropMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractItemView.DragDropMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractItemView.DragDropMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractItemView.DragDropMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractItemView.DragDropMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractItemView.DragDropMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractItemView.DragDropMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractItemView.DragDropMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractItemView.DragDropMode: ...

    class DropIndicatorPosition:
        AboveItem: typing.ClassVar[QAbstractItemView.DropIndicatorPosition] = ...
        BelowItem: typing.ClassVar[QAbstractItemView.DropIndicatorPosition] = ...
        OnItem: typing.ClassVar[QAbstractItemView.DropIndicatorPosition] = ...
        OnViewport: typing.ClassVar[QAbstractItemView.DropIndicatorPosition] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractItemView.DropIndicatorPosition: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractItemView.DropIndicatorPosition: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractItemView.DropIndicatorPosition: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractItemView.DropIndicatorPosition: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractItemView.DropIndicatorPosition: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractItemView.DropIndicatorPosition: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractItemView.DropIndicatorPosition: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractItemView.DropIndicatorPosition: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractItemView.DropIndicatorPosition: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractItemView.DropIndicatorPosition: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractItemView.DropIndicatorPosition: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractItemView.DropIndicatorPosition: ...

    class EditTrigger:
        AllEditTriggers: typing.ClassVar[QAbstractItemView.EditTrigger] = ...
        AnyKeyPressed: typing.ClassVar[QAbstractItemView.EditTrigger] = ...
        CurrentChanged: typing.ClassVar[QAbstractItemView.EditTrigger] = ...
        DoubleClicked: typing.ClassVar[QAbstractItemView.EditTrigger] = ...
        EditKeyPressed: typing.ClassVar[QAbstractItemView.EditTrigger] = ...
        NoEditTriggers: typing.ClassVar[QAbstractItemView.EditTrigger] = ...
        SelectedClicked: typing.ClassVar[QAbstractItemView.EditTrigger] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractItemView.EditTriggers: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QAbstractItemView.EditTriggers: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractItemView.EditTriggers: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractItemView.EditTriggers: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractItemView.EditTriggers: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractItemView.EditTriggers: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractItemView.EditTriggers: ...

    class EditTriggers:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractItemView.EditTriggers: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QAbstractItemView.EditTriggers: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractItemView.EditTriggers: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractItemView.EditTriggers: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractItemView.EditTriggers: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractItemView.EditTriggers: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractItemView.EditTriggers: ...

    class ScrollHint:
        EnsureVisible: typing.ClassVar[QAbstractItemView.ScrollHint] = ...
        PositionAtBottom: typing.ClassVar[QAbstractItemView.ScrollHint] = ...
        PositionAtCenter: typing.ClassVar[QAbstractItemView.ScrollHint] = ...
        PositionAtTop: typing.ClassVar[QAbstractItemView.ScrollHint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollHint: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollHint: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollHint: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollHint: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollHint: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollHint: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollHint: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollHint: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollHint: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollHint: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollHint: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollHint: ...

    class ScrollMode:
        ScrollPerItem: typing.ClassVar[QAbstractItemView.ScrollMode] = ...
        ScrollPerPixel: typing.ClassVar[QAbstractItemView.ScrollMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollMode: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractItemView.ScrollMode: ...

    class SelectionBehavior:
        SelectColumns: typing.ClassVar[QAbstractItemView.SelectionBehavior] = ...
        SelectItems: typing.ClassVar[QAbstractItemView.SelectionBehavior] = ...
        SelectRows: typing.ClassVar[QAbstractItemView.SelectionBehavior] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionBehavior: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionBehavior: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionBehavior: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionBehavior: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionBehavior: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionBehavior: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionBehavior: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionBehavior: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionBehavior: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionBehavior: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionBehavior: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionBehavior: ...

    class SelectionMode:
        ContiguousSelection: typing.ClassVar[QAbstractItemView.SelectionMode] = ...
        ExtendedSelection: typing.ClassVar[QAbstractItemView.SelectionMode] = ...
        MultiSelection: typing.ClassVar[QAbstractItemView.SelectionMode] = ...
        NoSelection: typing.ClassVar[QAbstractItemView.SelectionMode] = ...
        SingleSelection: typing.ClassVar[QAbstractItemView.SelectionMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionMode: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractItemView.SelectionMode: ...

    class State:
        AnimatingState: typing.ClassVar[QAbstractItemView.State] = ...
        CollapsingState: typing.ClassVar[QAbstractItemView.State] = ...
        DragSelectingState: typing.ClassVar[QAbstractItemView.State] = ...
        DraggingState: typing.ClassVar[QAbstractItemView.State] = ...
        EditingState: typing.ClassVar[QAbstractItemView.State] = ...
        ExpandingState: typing.ClassVar[QAbstractItemView.State] = ...
        NoState: typing.ClassVar[QAbstractItemView.State] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractItemView.State: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractItemView.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractItemView.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractItemView.State: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractItemView.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractItemView.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractItemView.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractItemView.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractItemView.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractItemView.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractItemView.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractItemView.State: ...
    AboveItem: typing.ClassVar[QAbstractItemView.DropIndicatorPosition] = ...
    AllEditTriggers: typing.ClassVar[QAbstractItemView.EditTrigger] = ...
    AnimatingState: typing.ClassVar[QAbstractItemView.State] = ...
    AnyKeyPressed: typing.ClassVar[QAbstractItemView.EditTrigger] = ...
    BelowItem: typing.ClassVar[QAbstractItemView.DropIndicatorPosition] = ...
    CollapsingState: typing.ClassVar[QAbstractItemView.State] = ...
    ContiguousSelection: typing.ClassVar[QAbstractItemView.SelectionMode] = ...
    CurrentChanged: typing.ClassVar[QAbstractItemView.EditTrigger] = ...
    DoubleClicked: typing.ClassVar[QAbstractItemView.EditTrigger] = ...
    DragDrop: typing.ClassVar[QAbstractItemView.DragDropMode] = ...
    DragOnly: typing.ClassVar[QAbstractItemView.DragDropMode] = ...
    DragSelectingState: typing.ClassVar[QAbstractItemView.State] = ...
    DraggingState: typing.ClassVar[QAbstractItemView.State] = ...
    DropOnly: typing.ClassVar[QAbstractItemView.DragDropMode] = ...
    EditKeyPressed: typing.ClassVar[QAbstractItemView.EditTrigger] = ...
    EditingState: typing.ClassVar[QAbstractItemView.State] = ...
    EnsureVisible: typing.ClassVar[QAbstractItemView.ScrollHint] = ...
    ExpandingState: typing.ClassVar[QAbstractItemView.State] = ...
    ExtendedSelection: typing.ClassVar[QAbstractItemView.SelectionMode] = ...
    InternalMove: typing.ClassVar[QAbstractItemView.DragDropMode] = ...
    MoveDown: typing.ClassVar[QAbstractItemView.CursorAction] = ...
    MoveEnd: typing.ClassVar[QAbstractItemView.CursorAction] = ...
    MoveHome: typing.ClassVar[QAbstractItemView.CursorAction] = ...
    MoveLeft: typing.ClassVar[QAbstractItemView.CursorAction] = ...
    MoveNext: typing.ClassVar[QAbstractItemView.CursorAction] = ...
    MovePageDown: typing.ClassVar[QAbstractItemView.CursorAction] = ...
    MovePageUp: typing.ClassVar[QAbstractItemView.CursorAction] = ...
    MovePrevious: typing.ClassVar[QAbstractItemView.CursorAction] = ...
    MoveRight: typing.ClassVar[QAbstractItemView.CursorAction] = ...
    MoveUp: typing.ClassVar[QAbstractItemView.CursorAction] = ...
    MultiSelection: typing.ClassVar[QAbstractItemView.SelectionMode] = ...
    NoDragDrop: typing.ClassVar[QAbstractItemView.DragDropMode] = ...
    NoEditTriggers: typing.ClassVar[QAbstractItemView.EditTrigger] = ...
    NoSelection: typing.ClassVar[QAbstractItemView.SelectionMode] = ...
    NoState: typing.ClassVar[QAbstractItemView.State] = ...
    OnItem: typing.ClassVar[QAbstractItemView.DropIndicatorPosition] = ...
    OnViewport: typing.ClassVar[QAbstractItemView.DropIndicatorPosition] = ...
    PositionAtBottom: typing.ClassVar[QAbstractItemView.ScrollHint] = ...
    PositionAtCenter: typing.ClassVar[QAbstractItemView.ScrollHint] = ...
    PositionAtTop: typing.ClassVar[QAbstractItemView.ScrollHint] = ...
    ScrollPerItem: typing.ClassVar[QAbstractItemView.ScrollMode] = ...
    ScrollPerPixel: typing.ClassVar[QAbstractItemView.ScrollMode] = ...
    SelectColumns: typing.ClassVar[QAbstractItemView.SelectionBehavior] = ...
    SelectItems: typing.ClassVar[QAbstractItemView.SelectionBehavior] = ...
    SelectRows: typing.ClassVar[QAbstractItemView.SelectionBehavior] = ...
    SelectedClicked: typing.ClassVar[QAbstractItemView.EditTrigger] = ...
    SingleSelection: typing.ClassVar[QAbstractItemView.SelectionMode] = ...
    activated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    doubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    entered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    iconSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    viewportEntered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QAbstractScrollArea.Shadow = ..., frameShape: QAbstractScrollArea.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QAbstractScrollArea.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def alternatingRowColors(self) -> bool: ...
    def autoScrollMargin(self) -> int: ...
    def clearSelection(self) -> None: ...
    def closeEditor(self, editor: QWidget, hint: QAbstractItemDelegate.EndEditHint) -> None: ...
    def closePersistentEditor(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def commitData(self, editor: QWidget) -> None: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, previous: PySide2.QtCore.QModelIndex) -> None: ...
    def currentIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def dataChanged(self, topLeft: PySide2.QtCore.QModelIndex, bottomRight: PySide2.QtCore.QModelIndex, roles: typing.List[int] = ...) -> None: ...
    def defaultDropAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def dirtyRegionOffset(self) -> PySide2.QtCore.QPoint: ...
    def doAutoScroll(self) -> None: ...
    def doItemsLayout(self) -> None: ...
    def dragDropMode(self) -> QAbstractItemView.DragDropMode: ...
    def dragDropOverwriteMode(self) -> bool: ...
    def dragEnabled(self) -> bool: ...
    def dragEnterEvent(self, event: PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, event: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent) -> None: ...
    def dropIndicatorPosition(self) -> QAbstractItemView.DropIndicatorPosition: ...
    @overload
    def edit(self, index: PySide2.QtCore.QModelIndex, trigger: QAbstractItemView.EditTrigger, event: PySide2.QtCore.QEvent) -> bool: ...
    @overload
    def edit(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def editTriggers(self) -> typing.Union[QAbstractItemView.EditTriggers,QAbstractItemView.EditTrigger]: ...
    def editorDestroyed(self, editor: PySide2.QtCore.QObject) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def executeDelayedItemsLayout(self) -> None: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def hasAutoScroll(self) -> bool: ...
    def horizontalOffset(self) -> int: ...
    def horizontalScrollMode(self) -> QAbstractItemView.ScrollMode: ...
    def horizontalScrollbarAction(self, action: int) -> None: ...
    def horizontalScrollbarValueChanged(self, value: int) -> None: ...
    def horizontalStepsPerItem(self) -> int: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def indexAt(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def indexWidget(self, index: PySide2.QtCore.QModelIndex) -> QWidget: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isPersistentEditorOpen(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @overload
    def itemDelegate(self, index: PySide2.QtCore.QModelIndex) -> QAbstractItemDelegate: ...
    @overload
    def itemDelegate(self) -> QAbstractItemDelegate: ...
    def itemDelegateForColumn(self, column: int) -> QAbstractItemDelegate: ...
    def itemDelegateForRow(self, row: int) -> QAbstractItemDelegate: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyboardSearch(self, search: str) -> None: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, cursorAction: QAbstractItemView.CursorAction, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> PySide2.QtCore.QModelIndex: ...
    def openPersistentEditor(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def reset(self) -> None: ...
    def resetHorizontalScrollMode(self) -> None: ...
    def resetVerticalScrollMode(self) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def rootIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def rowsAboutToBeRemoved(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int) -> None: ...
    def rowsInserted(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int) -> None: ...
    def scheduleDelayedItemsLayout(self) -> None: ...
    def scrollDirtyRegion(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: QAbstractItemView.ScrollHint = ...) -> None: ...
    def scrollToBottom(self) -> None: ...
    def scrollToTop(self) -> None: ...
    def selectAll(self) -> None: ...
    def selectedIndexes(self) -> typing.List[PySide2.QtCore.QModelIndex]: ...
    def selectionBehavior(self) -> QAbstractItemView.SelectionBehavior: ...
    def selectionChanged(self, selected: PySide2.QtCore.QItemSelection, deselected: PySide2.QtCore.QItemSelection) -> None: ...
    def selectionCommand(self, index: PySide2.QtCore.QModelIndex, event: typing.Union[PySide2.QtCore.QEvent,None] = ...) -> typing.Union[PySide2.QtCore.QItemSelectionModel.SelectionFlags,PySide2.QtCore.QItemSelectionModel.SelectionFlag]: ...
    def selectionMode(self) -> QAbstractItemView.SelectionMode: ...
    def selectionModel(self) -> PySide2.QtCore.QItemSelectionModel: ...
    def setAlternatingRowColors(self, enable: bool) -> None: ...
    def setAutoScroll(self, enable: bool) -> None: ...
    def setAutoScrollMargin(self, margin: int) -> None: ...
    def setCurrentIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setDefaultDropAction(self, dropAction: PySide2.QtCore.Qt.DropAction) -> None: ...
    def setDirtyRegion(self, region: PySide2.QtGui.QRegion) -> None: ...
    def setDragDropMode(self, behavior: QAbstractItemView.DragDropMode) -> None: ...
    def setDragDropOverwriteMode(self, overwrite: bool) -> None: ...
    def setDragEnabled(self, enable: bool) -> None: ...
    def setDropIndicatorShown(self, enable: bool) -> None: ...
    def setEditTriggers(self, triggers: typing.Union[QAbstractItemView.EditTriggers,QAbstractItemView.EditTrigger]) -> None: ...
    def setHorizontalScrollMode(self, mode: QAbstractItemView.ScrollMode) -> None: ...
    def setHorizontalStepsPerItem(self, steps: int) -> None: ...
    def setIconSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setIndexWidget(self, index: PySide2.QtCore.QModelIndex, widget: QWidget) -> None: ...
    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None: ...
    def setItemDelegateForColumn(self, column: int, delegate: QAbstractItemDelegate) -> None: ...
    def setItemDelegateForRow(self, row: int, delegate: QAbstractItemDelegate) -> None: ...
    def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setSelection(self, rect: PySide2.QtCore.QRect, command: typing.Union[PySide2.QtCore.QItemSelectionModel.SelectionFlags,PySide2.QtCore.QItemSelectionModel.SelectionFlag]) -> None: ...
    def setSelectionBehavior(self, behavior: QAbstractItemView.SelectionBehavior) -> None: ...
    def setSelectionMode(self, mode: QAbstractItemView.SelectionMode) -> None: ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel) -> None: ...
    def setState(self, state: QAbstractItemView.State) -> None: ...
    def setTabKeyNavigation(self, enable: bool) -> None: ...
    def setTextElideMode(self, mode: PySide2.QtCore.Qt.TextElideMode) -> None: ...
    def setVerticalScrollMode(self, mode: QAbstractItemView.ScrollMode) -> None: ...
    def setVerticalStepsPerItem(self, steps: int) -> None: ...
    def showDropIndicator(self) -> bool: ...
    def sizeHintForColumn(self, column: int) -> int: ...
    def sizeHintForIndex(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def sizeHintForRow(self, row: int) -> int: ...
    def startAutoScroll(self) -> None: ...
    def startDrag(self, supportedActions: typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction]) -> None: ...
    def state(self) -> QAbstractItemView.State: ...
    def stopAutoScroll(self) -> None: ...
    def tabKeyNavigation(self) -> bool: ...
    def textElideMode(self) -> PySide2.QtCore.Qt.TextElideMode: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent) -> None: ...
    @overload
    def update(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    @overload
    def update(self) -> None: ...
    def updateEditorData(self) -> None: ...
    def updateEditorGeometries(self) -> None: ...
    def updateGeometries(self) -> None: ...
    def verticalOffset(self) -> int: ...
    def verticalScrollMode(self) -> QAbstractItemView.ScrollMode: ...
    def verticalScrollbarAction(self, action: int) -> None: ...
    def verticalScrollbarValueChanged(self, value: int) -> None: ...
    def verticalStepsPerItem(self) -> int: ...
    def viewOptions(self) -> QStyleOptionViewItem: ...
    def viewportEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...

class QAbstractScrollArea(QFrame):
    class SizeAdjustPolicy:
        AdjustIgnored: typing.ClassVar[QAbstractScrollArea.SizeAdjustPolicy] = ...
        AdjustToContents: typing.ClassVar[QAbstractScrollArea.SizeAdjustPolicy] = ...
        AdjustToContentsOnFirstShow: typing.ClassVar[QAbstractScrollArea.SizeAdjustPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractScrollArea.SizeAdjustPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractScrollArea.SizeAdjustPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractScrollArea.SizeAdjustPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractScrollArea.SizeAdjustPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractScrollArea.SizeAdjustPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractScrollArea.SizeAdjustPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractScrollArea.SizeAdjustPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractScrollArea.SizeAdjustPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractScrollArea.SizeAdjustPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractScrollArea.SizeAdjustPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractScrollArea.SizeAdjustPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractScrollArea.SizeAdjustPolicy: ...
    AdjustIgnored: typing.ClassVar[QAbstractScrollArea.SizeAdjustPolicy] = ...
    AdjustToContents: typing.ClassVar[QAbstractScrollArea.SizeAdjustPolicy] = ...
    AdjustToContentsOnFirstShow: typing.ClassVar[QAbstractScrollArea.SizeAdjustPolicy] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QAbstractScrollArea.Shadow = ..., frameShape: QAbstractScrollArea.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QAbstractScrollArea.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def addScrollBarWidget(self, widget: QWidget, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def contextMenuEvent(self, arg__1: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def cornerWidget(self) -> QWidget: ...
    def dragEnterEvent(self, arg__1: PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, arg__1: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, arg__1: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, arg__1: PySide2.QtGui.QDropEvent) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def horizontalScrollBar(self) -> QScrollBar: ...
    def horizontalScrollBarPolicy(self) -> PySide2.QtCore.Qt.ScrollBarPolicy: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def maximumViewportSize(self) -> PySide2.QtCore.QSize: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def scrollBarWidgets(self, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> typing.List[QWidget]: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def setCornerWidget(self, widget: QWidget) -> None: ...
    def setHorizontalScrollBar(self, scrollbar: QScrollBar) -> None: ...
    def setHorizontalScrollBarPolicy(self, arg__1: PySide2.QtCore.Qt.ScrollBarPolicy) -> None: ...
    def setSizeAdjustPolicy(self, policy: QAbstractScrollArea.SizeAdjustPolicy) -> None: ...
    def setVerticalScrollBar(self, scrollbar: QScrollBar) -> None: ...
    def setVerticalScrollBarPolicy(self, arg__1: PySide2.QtCore.Qt.ScrollBarPolicy) -> None: ...
    def setViewport(self, widget: QWidget) -> None: ...
    @overload
    def setViewportMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @overload
    def setViewportMargins(self, margins: PySide2.QtCore.QMargins) -> None: ...
    def setupViewport(self, viewport: QWidget) -> None: ...
    def sizeAdjustPolicy(self) -> QAbstractScrollArea.SizeAdjustPolicy: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def verticalScrollBar(self) -> QScrollBar: ...
    def verticalScrollBarPolicy(self) -> PySide2.QtCore.Qt.ScrollBarPolicy: ...
    def viewport(self) -> QWidget: ...
    def viewportEvent(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def viewportMargins(self) -> PySide2.QtCore.QMargins: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def wheelEvent(self, arg__1: PySide2.QtGui.QWheelEvent) -> None: ...

class QAbstractSlider(QWidget):
    class SliderAction:
        SliderMove: typing.ClassVar[QAbstractSlider.SliderAction] = ...
        SliderNoAction: typing.ClassVar[QAbstractSlider.SliderAction] = ...
        SliderPageStepAdd: typing.ClassVar[QAbstractSlider.SliderAction] = ...
        SliderPageStepSub: typing.ClassVar[QAbstractSlider.SliderAction] = ...
        SliderSingleStepAdd: typing.ClassVar[QAbstractSlider.SliderAction] = ...
        SliderSingleStepSub: typing.ClassVar[QAbstractSlider.SliderAction] = ...
        SliderToMaximum: typing.ClassVar[QAbstractSlider.SliderAction] = ...
        SliderToMinimum: typing.ClassVar[QAbstractSlider.SliderAction] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderAction: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderAction: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderAction: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderAction: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderAction: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderAction: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderAction: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderAction: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderAction: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderAction: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderAction: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderAction: ...

    class SliderChange:
        SliderOrientationChange: typing.ClassVar[QAbstractSlider.SliderChange] = ...
        SliderRangeChange: typing.ClassVar[QAbstractSlider.SliderChange] = ...
        SliderStepsChange: typing.ClassVar[QAbstractSlider.SliderChange] = ...
        SliderValueChange: typing.ClassVar[QAbstractSlider.SliderChange] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderChange: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderChange: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderChange: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderChange: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderChange: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderChange: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderChange: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderChange: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderChange: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderChange: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderChange: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSlider.SliderChange: ...
    SliderMove: typing.ClassVar[QAbstractSlider.SliderAction] = ...
    SliderNoAction: typing.ClassVar[QAbstractSlider.SliderAction] = ...
    SliderOrientationChange: typing.ClassVar[QAbstractSlider.SliderChange] = ...
    SliderPageStepAdd: typing.ClassVar[QAbstractSlider.SliderAction] = ...
    SliderPageStepSub: typing.ClassVar[QAbstractSlider.SliderAction] = ...
    SliderRangeChange: typing.ClassVar[QAbstractSlider.SliderChange] = ...
    SliderSingleStepAdd: typing.ClassVar[QAbstractSlider.SliderAction] = ...
    SliderSingleStepSub: typing.ClassVar[QAbstractSlider.SliderAction] = ...
    SliderStepsChange: typing.ClassVar[QAbstractSlider.SliderChange] = ...
    SliderToMaximum: typing.ClassVar[QAbstractSlider.SliderAction] = ...
    SliderToMinimum: typing.ClassVar[QAbstractSlider.SliderAction] = ...
    SliderValueChange: typing.ClassVar[QAbstractSlider.SliderChange] = ...
    actionTriggered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    rangeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sliderMoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sliderPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sliderReleased: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., actionTriggered: typing.Callable = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., invertedAppearance: bool = ..., invertedControls: bool = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximum: int = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimum: int = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., pageStep: int = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rangeChanged: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., singleStep: int = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., sliderDown: bool = ..., sliderMoved: typing.Callable = ..., sliderPosition: int = ..., sliderPressed: typing.Callable = ..., sliderReleased: typing.Callable = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., tracking: bool = ..., updatesEnabled: bool = ..., value: int = ..., valueChanged: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def hasTracking(self) -> bool: ...
    def invertedAppearance(self) -> bool: ...
    def invertedControls(self) -> bool: ...
    def isSliderDown(self) -> bool: ...
    def keyPressEvent(self, ev: PySide2.QtGui.QKeyEvent) -> None: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def pageStep(self) -> int: ...
    def repeatAction(self) -> QAbstractSlider.SliderAction: ...
    def setInvertedAppearance(self, arg__1: bool) -> None: ...
    def setInvertedControls(self, arg__1: bool) -> None: ...
    def setMaximum(self, arg__1: int) -> None: ...
    def setMinimum(self, arg__1: int) -> None: ...
    def setOrientation(self, arg__1: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setPageStep(self, arg__1: int) -> None: ...
    def setRange(self, min: int, max: int) -> None: ...
    def setRepeatAction(self, action: QAbstractSlider.SliderAction, thresholdTime: int = ..., repeatTime: int = ...) -> None: ...
    def setSingleStep(self, arg__1: int) -> None: ...
    def setSliderDown(self, arg__1: bool) -> None: ...
    def setSliderPosition(self, arg__1: int) -> None: ...
    def setTracking(self, enable: bool) -> None: ...
    def setValue(self, arg__1: int) -> None: ...
    def singleStep(self) -> int: ...
    def sliderChange(self, change: QAbstractSlider.SliderChange) -> None: ...
    def sliderPosition(self) -> int: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent) -> None: ...
    def triggerAction(self, action: QAbstractSlider.SliderAction) -> None: ...
    def value(self) -> int: ...
    def wheelEvent(self, e: PySide2.QtGui.QWheelEvent) -> None: ...

class QAbstractSpinBox(QWidget):
    class ButtonSymbols:
        NoButtons: typing.ClassVar[QAbstractSpinBox.ButtonSymbols] = ...
        PlusMinus: typing.ClassVar[QAbstractSpinBox.ButtonSymbols] = ...
        UpDownArrows: typing.ClassVar[QAbstractSpinBox.ButtonSymbols] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractSpinBox.ButtonSymbols: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSpinBox.ButtonSymbols: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractSpinBox.ButtonSymbols: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSpinBox.ButtonSymbols: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractSpinBox.ButtonSymbols: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSpinBox.ButtonSymbols: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractSpinBox.ButtonSymbols: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSpinBox.ButtonSymbols: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractSpinBox.ButtonSymbols: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSpinBox.ButtonSymbols: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractSpinBox.ButtonSymbols: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSpinBox.ButtonSymbols: ...

    class CorrectionMode:
        CorrectToNearestValue: typing.ClassVar[QAbstractSpinBox.CorrectionMode] = ...
        CorrectToPreviousValue: typing.ClassVar[QAbstractSpinBox.CorrectionMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractSpinBox.CorrectionMode: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSpinBox.CorrectionMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractSpinBox.CorrectionMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSpinBox.CorrectionMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractSpinBox.CorrectionMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSpinBox.CorrectionMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractSpinBox.CorrectionMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSpinBox.CorrectionMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractSpinBox.CorrectionMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSpinBox.CorrectionMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractSpinBox.CorrectionMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSpinBox.CorrectionMode: ...

    class StepEnabled:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepEnabled: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QAbstractSpinBox.StepEnabled: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepEnabled: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepEnabled: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepEnabled: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepEnabled: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepEnabled: ...

    class StepEnabledFlag:
        StepDownEnabled: typing.ClassVar[QAbstractSpinBox.StepEnabledFlag] = ...
        StepNone: typing.ClassVar[QAbstractSpinBox.StepEnabledFlag] = ...
        StepUpEnabled: typing.ClassVar[QAbstractSpinBox.StepEnabledFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepEnabled: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QAbstractSpinBox.StepEnabled: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepEnabled: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepEnabled: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepEnabled: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepEnabled: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepEnabled: ...

    class StepType:
        AdaptiveDecimalStepType: typing.ClassVar[QAbstractSpinBox.StepType] = ...
        DefaultStepType: typing.ClassVar[QAbstractSpinBox.StepType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepType: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepType: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepType: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepType: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepType: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSpinBox.StepType: ...
    AdaptiveDecimalStepType: typing.ClassVar[QAbstractSpinBox.StepType] = ...
    CorrectToNearestValue: typing.ClassVar[QAbstractSpinBox.CorrectionMode] = ...
    CorrectToPreviousValue: typing.ClassVar[QAbstractSpinBox.CorrectionMode] = ...
    DefaultStepType: typing.ClassVar[QAbstractSpinBox.StepType] = ...
    NoButtons: typing.ClassVar[QAbstractSpinBox.ButtonSymbols] = ...
    PlusMinus: typing.ClassVar[QAbstractSpinBox.ButtonSymbols] = ...
    StepDownEnabled: typing.ClassVar[QAbstractSpinBox.StepEnabledFlag] = ...
    StepNone: typing.ClassVar[QAbstractSpinBox.StepEnabledFlag] = ...
    StepUpEnabled: typing.ClassVar[QAbstractSpinBox.StepEnabledFlag] = ...
    UpDownArrows: typing.ClassVar[QAbstractSpinBox.ButtonSymbols] = ...
    editingFinished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., accelerated: bool = ..., acceptDrops: bool = ..., acceptableInput: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., buttonSymbols: QAbstractSpinBox.ButtonSymbols = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., correctionMode: QAbstractSpinBox.CorrectionMode = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., editingFinished: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frame: bool = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., keyboardTracking: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., showGroupSeparator: bool = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., specialValueText: str = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wrapping: bool = ..., x: int = ..., y: int = ...) -> None: ...
    def alignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def buttonSymbols(self) -> QAbstractSpinBox.ButtonSymbols: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent) -> None: ...
    def contextMenuEvent(self, event: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def correctionMode(self) -> QAbstractSpinBox.CorrectionMode: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def fixup(self, input: str) -> None: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def hasAcceptableInput(self) -> bool: ...
    def hasFrame(self) -> bool: ...
    def hideEvent(self, event: PySide2.QtGui.QHideEvent) -> None: ...
    def initStyleOption(self, option: QStyleOptionSpinBox) -> None: ...
    def inputMethodQuery(self, arg__1: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def interpretText(self) -> None: ...
    def isAccelerated(self) -> bool: ...
    def isGroupSeparatorShown(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyboardTracking(self) -> bool: ...
    def lineEdit(self) -> QLineEdit: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def selectAll(self) -> None: ...
    def setAccelerated(self, on: bool) -> None: ...
    def setAlignment(self, flag: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setButtonSymbols(self, bs: QAbstractSpinBox.ButtonSymbols) -> None: ...
    def setCorrectionMode(self, cm: QAbstractSpinBox.CorrectionMode) -> None: ...
    def setFrame(self, arg__1: bool) -> None: ...
    def setGroupSeparatorShown(self, shown: bool) -> None: ...
    def setKeyboardTracking(self, kt: bool) -> None: ...
    def setLineEdit(self, edit: QLineEdit) -> None: ...
    def setReadOnly(self, r: bool) -> None: ...
    def setSpecialValueText(self, txt: str) -> None: ...
    def setWrapping(self, w: bool) -> None: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def specialValueText(self) -> str: ...
    def stepBy(self, steps: int) -> None: ...
    def stepDown(self) -> None: ...
    def stepEnabled(self) -> typing.Union[QAbstractSpinBox.StepEnabled,QAbstractSpinBox.StepEnabledFlag]: ...
    def stepUp(self) -> None: ...
    def text(self) -> str: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent) -> None: ...
    def validate(self, input: str, pos: int) -> PySide2.QtGui.QValidator.State: ...
    def wheelEvent(self, event: PySide2.QtGui.QWheelEvent) -> None: ...
    def wrapping(self) -> bool: ...

class QAccessibleWidget(PySide2.QtGui.QAccessibleObject):
    def __init__(self, o: QWidget, r: PySide2.QtGui.QAccessible.Role = ..., name: str = ...) -> None: ...
    def actionNames(self) -> typing.List[str]: ...
    def addControllingSignal(self, signal: str) -> None: ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def child(self, index: int) -> PySide2.QtGui.QAccessibleInterface: ...
    def childCount(self) -> int: ...
    def doAction(self, actionName: str) -> None: ...
    def focusChild(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def foregroundColor(self) -> PySide2.QtGui.QColor: ...
    def indexOfChild(self, child: PySide2.QtGui.QAccessibleInterface) -> int: ...
    def interface_cast(self, t: PySide2.QtGui.QAccessible.InterfaceType) -> int: ...
    def isValid(self) -> bool: ...
    def keyBindingsForAction(self, actionName: str) -> typing.List[str]: ...
    def parent(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def parentObject(self) -> PySide2.QtCore.QObject: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def relations(self, match: typing.Union[PySide2.QtGui.QAccessible.Relation,PySide2.QtGui.QAccessible.RelationFlag] = ...) -> typing.List[typing.Tuple[PySide2.QtGui.QAccessibleInterface,PySide2.QtGui.QAccessible.Relation]]: ...
    def role(self) -> PySide2.QtGui.QAccessible.Role: ...
    def state(self) -> PySide2.QtGui.QAccessible.State: ...
    def text(self, t: PySide2.QtGui.QAccessible.Text) -> str: ...
    def widget(self) -> QWidget: ...
    def window(self) -> PySide2.QtGui.QWindow: ...

class QAction(PySide2.QtCore.QObject):
    class ActionEvent:
        Hover: typing.ClassVar[QAction.ActionEvent] = ...
        Trigger: typing.ClassVar[QAction.ActionEvent] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAction.ActionEvent: ...
        def __and__(self, other: typing.SupportsInt) -> QAction.ActionEvent: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAction.ActionEvent: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAction.ActionEvent: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAction.ActionEvent: ...
        def __rand__(self, other: typing.SupportsInt) -> QAction.ActionEvent: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAction.ActionEvent: ...
        def __ror__(self, other: typing.SupportsInt) -> QAction.ActionEvent: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAction.ActionEvent: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAction.ActionEvent: ...
        def __sub__(self, other: typing.SupportsInt) -> QAction.ActionEvent: ...
        def __xor__(self, other: typing.SupportsInt) -> QAction.ActionEvent: ...

    class MenuRole:
        AboutQtRole: typing.ClassVar[QAction.MenuRole] = ...
        AboutRole: typing.ClassVar[QAction.MenuRole] = ...
        ApplicationSpecificRole: typing.ClassVar[QAction.MenuRole] = ...
        NoRole: typing.ClassVar[QAction.MenuRole] = ...
        PreferencesRole: typing.ClassVar[QAction.MenuRole] = ...
        QuitRole: typing.ClassVar[QAction.MenuRole] = ...
        TextHeuristicRole: typing.ClassVar[QAction.MenuRole] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAction.MenuRole: ...
        def __and__(self, other: typing.SupportsInt) -> QAction.MenuRole: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAction.MenuRole: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAction.MenuRole: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAction.MenuRole: ...
        def __rand__(self, other: typing.SupportsInt) -> QAction.MenuRole: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAction.MenuRole: ...
        def __ror__(self, other: typing.SupportsInt) -> QAction.MenuRole: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAction.MenuRole: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAction.MenuRole: ...
        def __sub__(self, other: typing.SupportsInt) -> QAction.MenuRole: ...
        def __xor__(self, other: typing.SupportsInt) -> QAction.MenuRole: ...

    class Priority:
        HighPriority: typing.ClassVar[QAction.Priority] = ...
        LowPriority: typing.ClassVar[QAction.Priority] = ...
        NormalPriority: typing.ClassVar[QAction.Priority] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAction.Priority: ...
        def __and__(self, other: typing.SupportsInt) -> QAction.Priority: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAction.Priority: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAction.Priority: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAction.Priority: ...
        def __rand__(self, other: typing.SupportsInt) -> QAction.Priority: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAction.Priority: ...
        def __ror__(self, other: typing.SupportsInt) -> QAction.Priority: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAction.Priority: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAction.Priority: ...
        def __sub__(self, other: typing.SupportsInt) -> QAction.Priority: ...
        def __xor__(self, other: typing.SupportsInt) -> QAction.Priority: ...
    AboutQtRole: typing.ClassVar[QAction.MenuRole] = ...
    AboutRole: typing.ClassVar[QAction.MenuRole] = ...
    ApplicationSpecificRole: typing.ClassVar[QAction.MenuRole] = ...
    HighPriority: typing.ClassVar[QAction.Priority] = ...
    Hover: typing.ClassVar[QAction.ActionEvent] = ...
    LowPriority: typing.ClassVar[QAction.Priority] = ...
    NoRole: typing.ClassVar[QAction.MenuRole] = ...
    NormalPriority: typing.ClassVar[QAction.Priority] = ...
    PreferencesRole: typing.ClassVar[QAction.MenuRole] = ...
    QuitRole: typing.ClassVar[QAction.MenuRole] = ...
    TextHeuristicRole: typing.ClassVar[QAction.MenuRole] = ...
    Trigger: typing.ClassVar[QAction.ActionEvent] = ...
    changed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    toggled: typing.ClassVar[PySide2.QtCore.Signal] = ...
    triggered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., autoRepeat: bool = ..., changed: typing.Callable = ..., checkable: bool = ..., checked: bool = ..., destroyed: typing.Callable = ..., enabled: bool = ..., font: PySide2.QtGui.QFont = ..., hovered: typing.Callable = ..., iconText: str = ..., iconVisibleInMenu: bool = ..., menuRole: QAction.MenuRole = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., priority: QAction.Priority = ..., shortcut: typing.Union[PySide2.QtGui.QKeySequence,str] = ..., shortcutContext: PySide2.QtCore.Qt.ShortcutContext = ..., shortcutVisibleInContextMenu: bool = ..., statusTip: str = ..., toggled: typing.Callable = ..., toolTip: str = ..., triggered: typing.Callable = ..., visible: bool = ..., whatsThis: str = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., autoRepeat: bool = ..., changed: typing.Callable = ..., checkable: bool = ..., checked: bool = ..., destroyed: typing.Callable = ..., enabled: bool = ..., font: PySide2.QtGui.QFont = ..., hovered: typing.Callable = ..., icon: PySide2.QtGui.QIcon = ..., iconText: str = ..., iconVisibleInMenu: bool = ..., menuRole: QAction.MenuRole = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., priority: QAction.Priority = ..., shortcut: typing.Union[PySide2.QtGui.QKeySequence,str] = ..., shortcutContext: PySide2.QtCore.Qt.ShortcutContext = ..., shortcutVisibleInContextMenu: bool = ..., statusTip: str = ..., toggled: typing.Callable = ..., toolTip: str = ..., triggered: typing.Callable = ..., visible: bool = ..., whatsThis: str = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., autoRepeat: bool = ..., changed: typing.Callable = ..., checkable: bool = ..., checked: bool = ..., destroyed: typing.Callable = ..., enabled: bool = ..., font: PySide2.QtGui.QFont = ..., hovered: typing.Callable = ..., icon: PySide2.QtGui.QIcon = ..., iconText: str = ..., iconVisibleInMenu: bool = ..., menuRole: QAction.MenuRole = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., priority: QAction.Priority = ..., shortcut: typing.Union[PySide2.QtGui.QKeySequence,str] = ..., shortcutContext: PySide2.QtCore.Qt.ShortcutContext = ..., shortcutVisibleInContextMenu: bool = ..., statusTip: str = ..., text: str = ..., toggled: typing.Callable = ..., toolTip: str = ..., triggered: typing.Callable = ..., visible: bool = ..., whatsThis: str = ...) -> None: ...
    def actionGroup(self) -> QActionGroup: ...
    def activate(self, event: QAction.ActionEvent) -> None: ...
    def associatedGraphicsWidgets(self) -> typing.List[QGraphicsWidget]: ...
    def associatedWidgets(self) -> typing.List[QWidget]: ...
    def autoRepeat(self) -> bool: ...
    def data(self) -> typing.Any: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def hover(self) -> None: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def iconText(self) -> str: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isIconVisibleInMenu(self) -> bool: ...
    def isSeparator(self) -> bool: ...
    def isShortcutVisibleInContextMenu(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def menu(self) -> QMenu: ...
    def menuRole(self) -> QAction.MenuRole: ...
    def parentWidget(self) -> QWidget: ...
    def priority(self) -> QAction.Priority: ...
    def setActionGroup(self, group: QActionGroup) -> None: ...
    def setAutoRepeat(self, arg__1: bool) -> None: ...
    def setCheckable(self, arg__1: bool) -> None: ...
    def setChecked(self, arg__1: bool) -> None: ...
    def setData(self, var: typing.Any) -> None: ...
    def setDisabled(self, b: bool) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
    def setIcon(self, icon: PySide2.QtGui.QIcon) -> None: ...
    def setIconText(self, text: str) -> None: ...
    def setIconVisibleInMenu(self, visible: bool) -> None: ...
    def setMenu(self, menu: QMenu) -> None: ...
    def setMenuRole(self, menuRole: QAction.MenuRole) -> None: ...
    def setPriority(self, priority: QAction.Priority) -> None: ...
    def setSeparator(self, b: bool) -> None: ...
    def setShortcut(self, shortcut: typing.Union[PySide2.QtGui.QKeySequence,str]) -> None: ...
    def setShortcutContext(self, context: PySide2.QtCore.Qt.ShortcutContext) -> None: ...
    def setShortcutVisibleInContextMenu(self, show: bool) -> None: ...
    @overload
    def setShortcuts(self, arg__1: PySide2.QtGui.QKeySequence.StandardKey) -> None: ...
    @overload
    def setShortcuts(self, shortcuts: typing.Iterable[PySide2.QtGui.QKeySequence]) -> None: ...
    def setStatusTip(self, statusTip: str) -> None: ...
    def setText(self, text: str) -> None: ...
    def setToolTip(self, tip: str) -> None: ...
    def setVisible(self, arg__1: bool) -> None: ...
    def setWhatsThis(self, what: str) -> None: ...
    def shortcut(self) -> PySide2.QtGui.QKeySequence: ...
    def shortcutContext(self) -> PySide2.QtCore.Qt.ShortcutContext: ...
    def shortcuts(self) -> typing.List[PySide2.QtGui.QKeySequence]: ...
    def showStatusText(self, widget: typing.Union[QWidget,None] = ...) -> bool: ...
    def statusTip(self) -> str: ...
    def text(self) -> str: ...
    def toggle(self) -> None: ...
    def toolTip(self) -> str: ...
    def trigger(self) -> None: ...
    def whatsThis(self) -> str: ...

class QActionGroup(PySide2.QtCore.QObject):
    class ExclusionPolicy:
        Exclusive: typing.ClassVar[QActionGroup.ExclusionPolicy] = ...
        ExclusiveOptional: typing.ClassVar[QActionGroup.ExclusionPolicy] = ...
        None_: typing.ClassVar[QActionGroup.ExclusionPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QActionGroup.ExclusionPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QActionGroup.ExclusionPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QActionGroup.ExclusionPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QActionGroup.ExclusionPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QActionGroup.ExclusionPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QActionGroup.ExclusionPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QActionGroup.ExclusionPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QActionGroup.ExclusionPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QActionGroup.ExclusionPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QActionGroup.ExclusionPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QActionGroup.ExclusionPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QActionGroup.ExclusionPolicy: ...
    hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    triggered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None], destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def actions(self) -> typing.List[QAction]: ...
    @overload
    def addAction(self, icon: PySide2.QtGui.QIcon, text: str) -> QAction: ...
    @overload
    def addAction(self, a: QAction) -> QAction: ...
    @overload
    def addAction(self, text: str) -> QAction: ...
    def checkedAction(self) -> QAction: ...
    def exclusionPolicy(self) -> QActionGroup.ExclusionPolicy: ...
    def isEnabled(self) -> bool: ...
    def isExclusive(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def removeAction(self, a: QAction) -> None: ...
    def setDisabled(self, b: bool) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setExclusionPolicy(self, policy: QActionGroup.ExclusionPolicy) -> None: ...
    def setExclusive(self, arg__1: bool) -> None: ...
    def setVisible(self, arg__1: bool) -> None: ...

class QApplication(PySide2.QtGui.QGuiApplication):
    class ColorSpec:
        CustomColor: typing.ClassVar[QApplication.ColorSpec] = ...
        ManyColor: typing.ClassVar[QApplication.ColorSpec] = ...
        NormalColor: typing.ClassVar[QApplication.ColorSpec] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QApplication.ColorSpec: ...
        def __and__(self, other: typing.SupportsInt) -> QApplication.ColorSpec: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QApplication.ColorSpec: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QApplication.ColorSpec: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QApplication.ColorSpec: ...
        def __rand__(self, other: typing.SupportsInt) -> QApplication.ColorSpec: ...
        def __rmul__(self, other: typing.SupportsInt) -> QApplication.ColorSpec: ...
        def __ror__(self, other: typing.SupportsInt) -> QApplication.ColorSpec: ...
        def __rsub__(self, other: typing.SupportsInt) -> QApplication.ColorSpec: ...
        def __rxor__(self, other: typing.SupportsInt) -> QApplication.ColorSpec: ...
        def __sub__(self, other: typing.SupportsInt) -> QApplication.ColorSpec: ...
        def __xor__(self, other: typing.SupportsInt) -> QApplication.ColorSpec: ...
    CustomColor: typing.ClassVar[QApplication.ColorSpec] = ...
    ManyColor: typing.ClassVar[QApplication.ColorSpec] = ...
    NormalColor: typing.ClassVar[QApplication.ColorSpec] = ...
    focusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, arg__1: typing.Iterable[str], destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @classmethod
    def aboutQt(cls) -> None: ...
    @classmethod
    def activeModalWidget(cls) -> QWidget: ...
    @classmethod
    def activePopupWidget(cls) -> QWidget: ...
    @classmethod
    def activeWindow(cls) -> QWidget: ...
    @classmethod
    def alert(cls, widget: QWidget, duration: int = ...) -> None: ...
    @classmethod
    def allWidgets(cls) -> typing.List[QWidget]: ...
    def autoSipEnabled(self) -> bool: ...
    @classmethod
    def beep(cls) -> None: ...
    @classmethod
    def closeAllWindows(cls) -> None: ...
    @classmethod
    def colorSpec(cls) -> int: ...
    @classmethod
    def cursorFlashTime(cls) -> int: ...
    @classmethod
    def desktop(cls) -> QDesktopWidget: ...
    @classmethod
    def doubleClickInterval(cls) -> int: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    @classmethod
    def exec_(cls) -> int: ...
    @classmethod
    def focusWidget(cls) -> QWidget: ...
    @overload
    @classmethod
    def font(cls, arg__1: QWidget) -> PySide2.QtGui.QFont: ...
    @overload
    @classmethod
    def font(cls, className: bytes) -> PySide2.QtGui.QFont: ...
    @overload
    @classmethod
    def font(cls) -> PySide2.QtGui.QFont: ...
    @classmethod
    def fontMetrics(cls) -> PySide2.QtGui.QFontMetrics: ...
    @classmethod
    def globalStrut(cls) -> PySide2.QtCore.QSize: ...
    @classmethod
    def isEffectEnabled(cls, arg__1: PySide2.QtCore.Qt.UIEffect) -> bool: ...
    @classmethod
    def keyboardInputInterval(cls) -> int: ...
    def notify(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    @overload
    @classmethod
    def palette(cls, arg__1: QWidget) -> PySide2.QtGui.QPalette: ...
    @overload
    @classmethod
    def palette(cls, className: bytes) -> PySide2.QtGui.QPalette: ...
    @overload
    @classmethod
    def palette(cls) -> PySide2.QtGui.QPalette: ...
    @classmethod
    def setActiveWindow(cls, act: QWidget) -> None: ...
    def setAutoSipEnabled(self, enabled: bool) -> None: ...
    @classmethod
    def setColorSpec(cls, arg__1: int) -> None: ...
    @classmethod
    def setCursorFlashTime(cls, arg__1: int) -> None: ...
    @classmethod
    def setDoubleClickInterval(cls, arg__1: int) -> None: ...
    @classmethod
    def setEffectEnabled(cls, arg__1: PySide2.QtCore.Qt.UIEffect, enable: bool = ...) -> None: ...
    @classmethod
    def setFont(cls, arg__1: PySide2.QtGui.QFont, className: typing.Union[bytes,None] = ...) -> None: ...
    @classmethod
    def setGlobalStrut(cls, arg__1: PySide2.QtCore.QSize) -> None: ...
    @classmethod
    def setKeyboardInputInterval(cls, arg__1: int) -> None: ...
    @overload
    @classmethod
    def setPalette(cls, arg__1: PySide2.QtGui.QPalette, className: typing.Union[bytes,None] = ...) -> None: ...
    @overload
    @classmethod
    def setPalette(cls, pal: PySide2.QtGui.QPalette) -> None: ...
    @classmethod
    def setStartDragDistance(cls, l: int) -> None: ...
    @classmethod
    def setStartDragTime(cls, ms: int) -> None: ...
    @overload
    @classmethod
    def setStyle(cls, arg__1: QStyle) -> None: ...
    @overload
    @classmethod
    def setStyle(cls, arg__1: str) -> QStyle: ...
    def setStyleSheet(self, sheet: str) -> None: ...
    @classmethod
    def setWheelScrollLines(cls, arg__1: int) -> None: ...
    @classmethod
    def setWindowIcon(cls, icon: PySide2.QtGui.QIcon) -> None: ...
    @classmethod
    def startDragDistance(cls) -> int: ...
    @classmethod
    def startDragTime(cls) -> int: ...
    @classmethod
    def style(cls) -> QStyle: ...
    def styleSheet(self) -> str: ...
    @overload
    @classmethod
    def topLevelAt(cls, x: int, y: int) -> QWidget: ...
    @overload
    @classmethod
    def topLevelAt(cls, p: PySide2.QtCore.QPoint) -> QWidget: ...
    @classmethod
    def topLevelWidgets(cls) -> typing.List[QWidget]: ...
    @classmethod
    def wheelScrollLines(cls) -> int: ...
    @overload
    @classmethod
    def widgetAt(cls, x: int, y: int) -> QWidget: ...
    @overload
    @classmethod
    def widgetAt(cls, p: PySide2.QtCore.QPoint) -> QWidget: ...
    @classmethod
    def windowIcon(cls) -> PySide2.QtGui.QIcon: ...

class QBoxLayout(QLayout):
    class Direction:
        BottomToTop: typing.ClassVar[QBoxLayout.Direction] = ...
        Down: typing.ClassVar[QBoxLayout.Direction] = ...
        LeftToRight: typing.ClassVar[QBoxLayout.Direction] = ...
        RightToLeft: typing.ClassVar[QBoxLayout.Direction] = ...
        TopToBottom: typing.ClassVar[QBoxLayout.Direction] = ...
        Up: typing.ClassVar[QBoxLayout.Direction] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QBoxLayout.Direction: ...
        def __and__(self, other: typing.SupportsInt) -> QBoxLayout.Direction: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QBoxLayout.Direction: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QBoxLayout.Direction: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QBoxLayout.Direction: ...
        def __rand__(self, other: typing.SupportsInt) -> QBoxLayout.Direction: ...
        def __rmul__(self, other: typing.SupportsInt) -> QBoxLayout.Direction: ...
        def __ror__(self, other: typing.SupportsInt) -> QBoxLayout.Direction: ...
        def __rsub__(self, other: typing.SupportsInt) -> QBoxLayout.Direction: ...
        def __rxor__(self, other: typing.SupportsInt) -> QBoxLayout.Direction: ...
        def __sub__(self, other: typing.SupportsInt) -> QBoxLayout.Direction: ...
        def __xor__(self, other: typing.SupportsInt) -> QBoxLayout.Direction: ...
    BottomToTop: typing.ClassVar[QBoxLayout.Direction] = ...
    Down: typing.ClassVar[QBoxLayout.Direction] = ...
    LeftToRight: typing.ClassVar[QBoxLayout.Direction] = ...
    RightToLeft: typing.ClassVar[QBoxLayout.Direction] = ...
    TopToBottom: typing.ClassVar[QBoxLayout.Direction] = ...
    Up: typing.ClassVar[QBoxLayout.Direction] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, arg__1: QBoxLayout.Direction, parent: typing.Union[QWidget,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def addItem(self, arg__1: QLayoutItem) -> None: ...
    def addLayout(self, layout: QLayout, stretch: int = ...) -> None: ...
    def addSpacerItem(self, spacerItem: QSpacerItem) -> None: ...
    def addSpacing(self, size: int) -> None: ...
    def addStretch(self, stretch: int = ...) -> None: ...
    def addStrut(self, arg__1: int) -> None: ...
    @overload
    def addWidget(self, arg__1: QWidget, stretch: int = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    @overload
    def addWidget(self, w: QWidget) -> None: ...
    def count(self) -> int: ...
    def direction(self) -> QBoxLayout.Direction: ...
    def expandingDirections(self) -> typing.Union[PySide2.QtCore.Qt.Orientations,PySide2.QtCore.Qt.Orientation]: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def insertItem(self, index: int, arg__2: QLayoutItem) -> None: ...
    def insertLayout(self, index: int, layout: QLayout, stretch: int = ...) -> None: ...
    def insertSpacerItem(self, index: int, spacerItem: QSpacerItem) -> None: ...
    def insertSpacing(self, index: int, size: int) -> None: ...
    def insertStretch(self, index: int, stretch: int = ...) -> None: ...
    def insertWidget(self, index: int, widget: QWidget, stretch: int = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    def invalidate(self) -> None: ...
    def itemAt(self, arg__1: int) -> QLayoutItem: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setDirection(self, arg__1: QBoxLayout.Direction) -> None: ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    def setSpacing(self, spacing: int) -> None: ...
    def setStretch(self, index: int, stretch: int) -> None: ...
    @overload
    def setStretchFactor(self, l: QLayout, stretch: int) -> bool: ...
    @overload
    def setStretchFactor(self, w: QWidget, stretch: int) -> bool: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def stretch(self, index: int) -> int: ...
    def takeAt(self, arg__1: int) -> QLayoutItem: ...

class QButtonGroup(PySide2.QtCore.QObject):
    buttonClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    buttonPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    buttonReleased: typing.ClassVar[PySide2.QtCore.Signal] = ...
    buttonToggled: typing.ClassVar[PySide2.QtCore.Signal] = ...
    idClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    idPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    idReleased: typing.ClassVar[PySide2.QtCore.Signal] = ...
    idToggled: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., buttonClicked: typing.Callable = ..., buttonPressed: typing.Callable = ..., buttonReleased: typing.Callable = ..., buttonToggled: typing.Callable = ..., destroyed: typing.Callable = ..., exclusive: bool = ..., idClicked: typing.Callable = ..., idPressed: typing.Callable = ..., idReleased: typing.Callable = ..., idToggled: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def addButton(self, arg__1: QAbstractButton, id: int = ...) -> None: ...
    def button(self, id: int) -> QAbstractButton: ...
    def buttons(self) -> typing.List[QAbstractButton]: ...
    def checkedButton(self) -> QAbstractButton: ...
    def checkedId(self) -> int: ...
    def exclusive(self) -> bool: ...
    def id(self, button: QAbstractButton) -> int: ...
    def removeButton(self, arg__1: QAbstractButton) -> None: ...
    def setExclusive(self, arg__1: bool) -> None: ...
    def setId(self, button: QAbstractButton, id: int) -> None: ...

class QCalendarWidget(QWidget):
    class HorizontalHeaderFormat:
        LongDayNames: typing.ClassVar[QCalendarWidget.HorizontalHeaderFormat] = ...
        NoHorizontalHeader: typing.ClassVar[QCalendarWidget.HorizontalHeaderFormat] = ...
        ShortDayNames: typing.ClassVar[QCalendarWidget.HorizontalHeaderFormat] = ...
        SingleLetterDayNames: typing.ClassVar[QCalendarWidget.HorizontalHeaderFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCalendarWidget.HorizontalHeaderFormat: ...
        def __and__(self, other: typing.SupportsInt) -> QCalendarWidget.HorizontalHeaderFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCalendarWidget.HorizontalHeaderFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCalendarWidget.HorizontalHeaderFormat: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QCalendarWidget.HorizontalHeaderFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> QCalendarWidget.HorizontalHeaderFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCalendarWidget.HorizontalHeaderFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> QCalendarWidget.HorizontalHeaderFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCalendarWidget.HorizontalHeaderFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCalendarWidget.HorizontalHeaderFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> QCalendarWidget.HorizontalHeaderFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> QCalendarWidget.HorizontalHeaderFormat: ...

    class SelectionMode:
        NoSelection: typing.ClassVar[QCalendarWidget.SelectionMode] = ...
        SingleSelection: typing.ClassVar[QCalendarWidget.SelectionMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCalendarWidget.SelectionMode: ...
        def __and__(self, other: typing.SupportsInt) -> QCalendarWidget.SelectionMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCalendarWidget.SelectionMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCalendarWidget.SelectionMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QCalendarWidget.SelectionMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QCalendarWidget.SelectionMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCalendarWidget.SelectionMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QCalendarWidget.SelectionMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCalendarWidget.SelectionMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCalendarWidget.SelectionMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QCalendarWidget.SelectionMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QCalendarWidget.SelectionMode: ...

    class VerticalHeaderFormat:
        ISOWeekNumbers: typing.ClassVar[QCalendarWidget.VerticalHeaderFormat] = ...
        NoVerticalHeader: typing.ClassVar[QCalendarWidget.VerticalHeaderFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCalendarWidget.VerticalHeaderFormat: ...
        def __and__(self, other: typing.SupportsInt) -> QCalendarWidget.VerticalHeaderFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCalendarWidget.VerticalHeaderFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCalendarWidget.VerticalHeaderFormat: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QCalendarWidget.VerticalHeaderFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> QCalendarWidget.VerticalHeaderFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCalendarWidget.VerticalHeaderFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> QCalendarWidget.VerticalHeaderFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCalendarWidget.VerticalHeaderFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCalendarWidget.VerticalHeaderFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> QCalendarWidget.VerticalHeaderFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> QCalendarWidget.VerticalHeaderFormat: ...
    ISOWeekNumbers: typing.ClassVar[QCalendarWidget.VerticalHeaderFormat] = ...
    LongDayNames: typing.ClassVar[QCalendarWidget.HorizontalHeaderFormat] = ...
    NoHorizontalHeader: typing.ClassVar[QCalendarWidget.HorizontalHeaderFormat] = ...
    NoSelection: typing.ClassVar[QCalendarWidget.SelectionMode] = ...
    NoVerticalHeader: typing.ClassVar[QCalendarWidget.VerticalHeaderFormat] = ...
    ShortDayNames: typing.ClassVar[QCalendarWidget.HorizontalHeaderFormat] = ...
    SingleLetterDayNames: typing.ClassVar[QCalendarWidget.HorizontalHeaderFormat] = ...
    SingleSelection: typing.ClassVar[QCalendarWidget.SelectionMode] = ...
    activated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    currentPageChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    selectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., activated: typing.Callable = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., currentPageChanged: typing.Callable = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., dateEditAcceptDelay: int = ..., dateEditEnabled: bool = ..., destroyed: typing.Callable = ..., enabled: bool = ..., firstDayOfWeek: PySide2.QtCore.Qt.DayOfWeek = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., gridVisible: bool = ..., height: int = ..., horizontalHeaderFormat: QCalendarWidget.HorizontalHeaderFormat = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumDate: PySide2.QtCore.QDate = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumDate: PySide2.QtCore.QDate = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., navigationBarVisible: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., selectedDate: PySide2.QtCore.QDate = ..., selectionChanged: typing.Callable = ..., selectionMode: QCalendarWidget.SelectionMode = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., verticalHeaderFormat: QCalendarWidget.VerticalHeaderFormat = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def calendar(self) -> PySide2.QtCore.QCalendar: ...
    def dateEditAcceptDelay(self) -> int: ...
    @overload
    def dateTextFormat(self, date: PySide2.QtCore.QDate) -> PySide2.QtGui.QTextCharFormat: ...
    @overload
    def dateTextFormat(self) -> typing.Dict[PySide2.QtCore.QDate,PySide2.QtGui.QTextCharFormat]: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, watched: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def firstDayOfWeek(self) -> PySide2.QtCore.Qt.DayOfWeek: ...
    def headerTextFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def horizontalHeaderFormat(self) -> QCalendarWidget.HorizontalHeaderFormat: ...
    def isDateEditEnabled(self) -> bool: ...
    def isGridVisible(self) -> bool: ...
    def isNavigationBarVisible(self) -> bool: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def maximumDate(self) -> PySide2.QtCore.QDate: ...
    def minimumDate(self) -> PySide2.QtCore.QDate: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def monthShown(self) -> int: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintCell(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, date: PySide2.QtCore.QDate) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def selectedDate(self) -> PySide2.QtCore.QDate: ...
    def selectionMode(self) -> QCalendarWidget.SelectionMode: ...
    def setCalendar(self, calendar: PySide2.QtCore.QCalendar) -> None: ...
    def setCurrentPage(self, year: int, month: int) -> None: ...
    def setDateEditAcceptDelay(self, delay: int) -> None: ...
    def setDateEditEnabled(self, enable: bool) -> None: ...
    def setDateRange(self, min: PySide2.QtCore.QDate, max: PySide2.QtCore.QDate) -> None: ...
    def setDateTextFormat(self, date: PySide2.QtCore.QDate, format: PySide2.QtGui.QTextCharFormat) -> None: ...
    def setFirstDayOfWeek(self, dayOfWeek: PySide2.QtCore.Qt.DayOfWeek) -> None: ...
    def setGridVisible(self, show: bool) -> None: ...
    def setHeaderTextFormat(self, format: PySide2.QtGui.QTextCharFormat) -> None: ...
    def setHorizontalHeaderFormat(self, format: QCalendarWidget.HorizontalHeaderFormat) -> None: ...
    def setMaximumDate(self, date: PySide2.QtCore.QDate) -> None: ...
    def setMinimumDate(self, date: PySide2.QtCore.QDate) -> None: ...
    def setNavigationBarVisible(self, visible: bool) -> None: ...
    def setSelectedDate(self, date: PySide2.QtCore.QDate) -> None: ...
    def setSelectionMode(self, mode: QCalendarWidget.SelectionMode) -> None: ...
    def setVerticalHeaderFormat(self, format: QCalendarWidget.VerticalHeaderFormat) -> None: ...
    def setWeekdayTextFormat(self, dayOfWeek: PySide2.QtCore.Qt.DayOfWeek, format: PySide2.QtGui.QTextCharFormat) -> None: ...
    def showNextMonth(self) -> None: ...
    def showNextYear(self) -> None: ...
    def showPreviousMonth(self) -> None: ...
    def showPreviousYear(self) -> None: ...
    def showSelectedDate(self) -> None: ...
    def showToday(self) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def updateCell(self, date: PySide2.QtCore.QDate) -> None: ...
    def updateCells(self) -> None: ...
    def verticalHeaderFormat(self) -> QCalendarWidget.VerticalHeaderFormat: ...
    def weekdayTextFormat(self, dayOfWeek: PySide2.QtCore.Qt.DayOfWeek) -> PySide2.QtGui.QTextCharFormat: ...
    def yearShown(self) -> int: ...

class QCheckBox(QAbstractButton):
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, text: str, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoExclusive: bool = ..., autoFillBackground: bool = ..., autoRepeat: bool = ..., autoRepeatDelay: int = ..., autoRepeatInterval: int = ..., baseSize: PySide2.QtCore.QSize = ..., checkable: bool = ..., checked: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., down: bool = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., icon: PySide2.QtGui.QIcon = ..., iconSize: PySide2.QtCore.QSize = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., released: typing.Callable = ..., shortcut: typing.Union[PySide2.QtGui.QKeySequence,str] = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., stateChanged: typing.Callable = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toggled: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., tristate: bool = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoExclusive: bool = ..., autoFillBackground: bool = ..., autoRepeat: bool = ..., autoRepeatDelay: int = ..., autoRepeatInterval: int = ..., baseSize: PySide2.QtCore.QSize = ..., checkable: bool = ..., checked: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., down: bool = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., icon: PySide2.QtGui.QIcon = ..., iconSize: PySide2.QtCore.QSize = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., released: typing.Callable = ..., shortcut: typing.Union[PySide2.QtGui.QKeySequence,str] = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., stateChanged: typing.Callable = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., toggled: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., tristate: bool = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def checkState(self) -> PySide2.QtCore.Qt.CheckState: ...
    def checkStateSet(self) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def hitButton(self, pos: PySide2.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, option: QStyleOptionButton) -> None: ...
    def isTristate(self) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def nextCheckState(self) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def setCheckState(self, state: PySide2.QtCore.Qt.CheckState) -> None: ...
    def setTristate(self, y: bool = ...) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...

class QColorDialog(QDialog):
    class ColorDialogOption:
        DontUseNativeDialog: typing.ClassVar[QColorDialog.ColorDialogOption] = ...
        NoButtons: typing.ClassVar[QColorDialog.ColorDialogOption] = ...
        ShowAlphaChannel: typing.ClassVar[QColorDialog.ColorDialogOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QColorDialog.ColorDialogOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QColorDialog.ColorDialogOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QColorDialog.ColorDialogOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QColorDialog.ColorDialogOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QColorDialog.ColorDialogOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QColorDialog.ColorDialogOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QColorDialog.ColorDialogOptions: ...

    class ColorDialogOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QColorDialog.ColorDialogOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QColorDialog.ColorDialogOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QColorDialog.ColorDialogOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QColorDialog.ColorDialogOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QColorDialog.ColorDialogOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QColorDialog.ColorDialogOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QColorDialog.ColorDialogOptions: ...
    DontUseNativeDialog: typing.ClassVar[QColorDialog.ColorDialogOption] = ...
    NoButtons: typing.ClassVar[QColorDialog.ColorDialogOption] = ...
    ShowAlphaChannel: typing.ClassVar[QColorDialog.ColorDialogOption] = ...
    colorSelected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    currentColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, initial: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int], parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., colorSelected: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., currentColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., currentColorChanged: typing.Callable = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., options: typing.Union[QColorDialog.ColorDialogOptions,QColorDialog.ColorDialogOption] = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., colorSelected: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., currentColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., currentColorChanged: typing.Callable = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., options: typing.Union[QColorDialog.ColorDialogOptions,QColorDialog.ColorDialogOption] = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def currentColor(self) -> PySide2.QtGui.QColor: ...
    @classmethod
    def customColor(cls, index: int) -> PySide2.QtGui.QColor: ...
    @classmethod
    def customCount(cls) -> int: ...
    def done(self, result: int) -> None: ...
    @classmethod
    def getColor(cls, initial: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., parent: typing.Union[QWidget,None] = ..., title: str = ..., options: typing.Union[QColorDialog.ColorDialogOptions,QColorDialog.ColorDialogOption] = ...) -> PySide2.QtGui.QColor: ...
    @overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    @overload
    def open(self) -> None: ...
    def options(self) -> typing.Union[QColorDialog.ColorDialogOptions,QColorDialog.ColorDialogOption]: ...
    def selectedColor(self) -> PySide2.QtGui.QColor: ...
    def setCurrentColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @classmethod
    def setCustomColor(cls, index: int, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setOption(self, option: QColorDialog.ColorDialogOption, on: bool = ...) -> None: ...
    def setOptions(self, options: typing.Union[QColorDialog.ColorDialogOptions,QColorDialog.ColorDialogOption]) -> None: ...
    @classmethod
    def setStandardColor(cls, index: int, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    @classmethod
    def standardColor(cls, index: int) -> PySide2.QtGui.QColor: ...
    def testOption(self, option: QColorDialog.ColorDialogOption) -> bool: ...

class QColormap(shiboken2.Object):
    class Mode:
        Direct: typing.ClassVar[QColormap.Mode] = ...
        Gray: typing.ClassVar[QColormap.Mode] = ...
        Indexed: typing.ClassVar[QColormap.Mode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QColormap.Mode: ...
        def __and__(self, other: typing.SupportsInt) -> QColormap.Mode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QColormap.Mode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QColormap.Mode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QColormap.Mode: ...
        def __rand__(self, other: typing.SupportsInt) -> QColormap.Mode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QColormap.Mode: ...
        def __ror__(self, other: typing.SupportsInt) -> QColormap.Mode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QColormap.Mode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QColormap.Mode: ...
        def __sub__(self, other: typing.SupportsInt) -> QColormap.Mode: ...
        def __xor__(self, other: typing.SupportsInt) -> QColormap.Mode: ...
    Direct: typing.ClassVar[QColormap.Mode] = ...
    Gray: typing.ClassVar[QColormap.Mode] = ...
    Indexed: typing.ClassVar[QColormap.Mode] = ...
    def __init__(self, colormap: QColormap) -> None: ...
    @classmethod
    def cleanup(cls) -> None: ...
    def colorAt(self, pixel: int) -> PySide2.QtGui.QColor: ...
    def colormap(self) -> typing.List[PySide2.QtGui.QColor]: ...
    def depth(self) -> int: ...
    @classmethod
    def initialize(cls) -> None: ...
    @classmethod
    def instance(cls, screen: int = ...) -> QColormap: ...
    def mode(self) -> QColormap.Mode: ...
    def pixel(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> int: ...
    def size(self) -> int: ...
    def __copy__(self) -> None: ...

class QColumnView(QAbstractItemView):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    updatePreviewWidget: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., activated: typing.Callable = ..., alternatingRowColors: bool = ..., autoFillBackground: bool = ..., autoScroll: bool = ..., autoScrollMargin: int = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., defaultDropAction: PySide2.QtCore.Qt.DropAction = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., dragDropMode: QColumnView.DragDropMode = ..., dragDropOverwriteMode: bool = ..., dragEnabled: bool = ..., editTriggers: QColumnView.EditTriggers = ..., enabled: bool = ..., entered: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QColumnView.Shadow = ..., frameShape: QColumnView.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., horizontalScrollMode: QColumnView.ScrollMode = ..., iconSize: PySide2.QtCore.QSize = ..., iconSizeChanged: typing.Callable = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., resizeGripsVisible: bool = ..., selectionBehavior: QColumnView.SelectionBehavior = ..., selectionMode: QColumnView.SelectionMode = ..., showDropIndicator: bool = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QColumnView.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabKeyNavigation: bool = ..., tabletTracking: bool = ..., textElideMode: PySide2.QtCore.Qt.TextElideMode = ..., toolTip: str = ..., toolTipDuration: int = ..., updatePreviewWidget: typing.Callable = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., verticalScrollMode: QColumnView.ScrollMode = ..., viewportEntered: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def columnWidths(self) -> typing.List[int]: ...
    def createColumn(self, rootIndex: PySide2.QtCore.QModelIndex) -> QAbstractItemView: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, previous: PySide2.QtCore.QModelIndex) -> None: ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def initializeColumn(self, column: QAbstractItemView) -> None: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def moveCursor(self, cursorAction: QAbstractItemView.CursorAction, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> PySide2.QtCore.QModelIndex: ...
    def previewWidget(self) -> QWidget: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def resizeGripsVisible(self) -> bool: ...
    def rowsInserted(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectAll(self) -> None: ...
    def setColumnWidths(self, list: typing.Iterable[int]) -> None: ...
    def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
    def setPreviewWidget(self, widget: QWidget) -> None: ...
    def setResizeGripsVisible(self, visible: bool) -> None: ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setSelection(self, rect: PySide2.QtCore.QRect, command: typing.Union[PySide2.QtCore.QItemSelectionModel.SelectionFlags,PySide2.QtCore.QItemSelectionModel.SelectionFlag]) -> None: ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def verticalOffset(self) -> int: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...

class QComboBox(QWidget):
    class InsertPolicy:
        InsertAfterCurrent: typing.ClassVar[QComboBox.InsertPolicy] = ...
        InsertAlphabetically: typing.ClassVar[QComboBox.InsertPolicy] = ...
        InsertAtBottom: typing.ClassVar[QComboBox.InsertPolicy] = ...
        InsertAtCurrent: typing.ClassVar[QComboBox.InsertPolicy] = ...
        InsertAtTop: typing.ClassVar[QComboBox.InsertPolicy] = ...
        InsertBeforeCurrent: typing.ClassVar[QComboBox.InsertPolicy] = ...
        NoInsert: typing.ClassVar[QComboBox.InsertPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QComboBox.InsertPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QComboBox.InsertPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QComboBox.InsertPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QComboBox.InsertPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QComboBox.InsertPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QComboBox.InsertPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QComboBox.InsertPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QComboBox.InsertPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QComboBox.InsertPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QComboBox.InsertPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QComboBox.InsertPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QComboBox.InsertPolicy: ...

    class SizeAdjustPolicy:
        AdjustToContents: typing.ClassVar[QComboBox.SizeAdjustPolicy] = ...
        AdjustToContentsOnFirstShow: typing.ClassVar[QComboBox.SizeAdjustPolicy] = ...
        AdjustToMinimumContentsLength: typing.ClassVar[QComboBox.SizeAdjustPolicy] = ...
        AdjustToMinimumContentsLengthWithIcon: typing.ClassVar[QComboBox.SizeAdjustPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QComboBox.SizeAdjustPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QComboBox.SizeAdjustPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QComboBox.SizeAdjustPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QComboBox.SizeAdjustPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QComboBox.SizeAdjustPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QComboBox.SizeAdjustPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QComboBox.SizeAdjustPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QComboBox.SizeAdjustPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QComboBox.SizeAdjustPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QComboBox.SizeAdjustPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QComboBox.SizeAdjustPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QComboBox.SizeAdjustPolicy: ...
    AdjustToContents: typing.ClassVar[QComboBox.SizeAdjustPolicy] = ...
    AdjustToContentsOnFirstShow: typing.ClassVar[QComboBox.SizeAdjustPolicy] = ...
    AdjustToMinimumContentsLength: typing.ClassVar[QComboBox.SizeAdjustPolicy] = ...
    AdjustToMinimumContentsLengthWithIcon: typing.ClassVar[QComboBox.SizeAdjustPolicy] = ...
    InsertAfterCurrent: typing.ClassVar[QComboBox.InsertPolicy] = ...
    InsertAlphabetically: typing.ClassVar[QComboBox.InsertPolicy] = ...
    InsertAtBottom: typing.ClassVar[QComboBox.InsertPolicy] = ...
    InsertAtCurrent: typing.ClassVar[QComboBox.InsertPolicy] = ...
    InsertAtTop: typing.ClassVar[QComboBox.InsertPolicy] = ...
    InsertBeforeCurrent: typing.ClassVar[QComboBox.InsertPolicy] = ...
    NoInsert: typing.ClassVar[QComboBox.InsertPolicy] = ...
    activated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    currentIndexChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    currentTextChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    editTextChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    highlighted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    textActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    textHighlighted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., activated: typing.Callable = ..., autoCompletion: bool = ..., autoCompletionCaseSensitivity: PySide2.QtCore.Qt.CaseSensitivity = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., count: int = ..., currentData: object = ..., currentIndex: int = ..., currentIndexChanged: typing.Callable = ..., currentText: str = ..., currentTextChanged: typing.Callable = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., duplicatesEnabled: bool = ..., editTextChanged: typing.Callable = ..., editable: bool = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frame: bool = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., highlighted: typing.Callable = ..., iconSize: PySide2.QtCore.QSize = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., insertPolicy: QComboBox.InsertPolicy = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maxCount: int = ..., maxVisibleItems: int = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumContentsLength: int = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., modelColumn: int = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., placeholderText: str = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QComboBox.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., textActivated: typing.Callable = ..., textHighlighted: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def addItem(self, icon: PySide2.QtGui.QIcon, text: str, userData: typing.Any = ...) -> None: ...
    @overload
    def addItem(self, text: str, userData: typing.Any = ...) -> None: ...
    def addItems(self, texts: typing.Iterable[str]) -> None: ...
    def autoCompletion(self) -> bool: ...
    def autoCompletionCaseSensitivity(self) -> PySide2.QtCore.Qt.CaseSensitivity: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def clearEditText(self) -> None: ...
    def completer(self) -> QCompleter: ...
    def contextMenuEvent(self, e: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def count(self) -> int: ...
    def currentData(self, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def currentIndex(self) -> int: ...
    def currentText(self) -> str: ...
    def duplicatesEnabled(self) -> bool: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def findData(self, data: typing.Any, role: PySide2.QtCore.Qt.ItemDataRole = ..., flags: typing.Union[PySide2.QtCore.Qt.MatchFlags,PySide2.QtCore.Qt.MatchFlag] = ...) -> int: ...
    def findText(self, text: str, flags: typing.Union[PySide2.QtCore.Qt.MatchFlags,PySide2.QtCore.Qt.MatchFlag] = ...) -> int: ...
    def focusInEvent(self, e: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, e: PySide2.QtGui.QFocusEvent) -> None: ...
    def hasFrame(self) -> bool: ...
    def hideEvent(self, e: PySide2.QtGui.QHideEvent) -> None: ...
    def hidePopup(self) -> None: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def initStyleOption(self, option: QStyleOptionComboBox) -> None: ...
    def inputMethodEvent(self, arg__1: PySide2.QtGui.QInputMethodEvent) -> None: ...
    @overload
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery, argument: typing.Any) -> typing.Any: ...
    @overload
    def inputMethodQuery(self, arg__1: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @overload
    def insertItem(self, index: int, icon: PySide2.QtGui.QIcon, text: str, userData: typing.Any = ...) -> None: ...
    @overload
    def insertItem(self, index: int, text: str, userData: typing.Any = ...) -> None: ...
    def insertItems(self, index: int, texts: typing.Iterable[str]) -> None: ...
    def insertPolicy(self) -> QComboBox.InsertPolicy: ...
    def insertSeparator(self, index: int) -> None: ...
    def isEditable(self) -> bool: ...
    def itemData(self, index: int, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def itemDelegate(self) -> QAbstractItemDelegate: ...
    def itemIcon(self, index: int) -> PySide2.QtGui.QIcon: ...
    def itemText(self, index: int) -> str: ...
    def keyPressEvent(self, e: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, e: PySide2.QtGui.QKeyEvent) -> None: ...
    def lineEdit(self) -> QLineEdit: ...
    def maxCount(self) -> int: ...
    def maxVisibleItems(self) -> int: ...
    def minimumContentsLength(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def modelColumn(self) -> int: ...
    def mousePressEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def placeholderText(self) -> str: ...
    def removeItem(self, index: int) -> None: ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent) -> None: ...
    def rootModelIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def setAutoCompletion(self, enable: bool) -> None: ...
    def setAutoCompletionCaseSensitivity(self, sensitivity: PySide2.QtCore.Qt.CaseSensitivity) -> None: ...
    def setCompleter(self, c: QCompleter) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentText(self, text: str) -> None: ...
    def setDuplicatesEnabled(self, enable: bool) -> None: ...
    def setEditText(self, text: str) -> None: ...
    def setEditable(self, editable: bool) -> None: ...
    def setFrame(self, arg__1: bool) -> None: ...
    def setIconSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setInsertPolicy(self, policy: QComboBox.InsertPolicy) -> None: ...
    def setItemData(self, index: int, value: typing.Any, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> None: ...
    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None: ...
    def setItemIcon(self, index: int, icon: PySide2.QtGui.QIcon) -> None: ...
    def setItemText(self, index: int, text: str) -> None: ...
    def setLineEdit(self, edit: QLineEdit) -> None: ...
    def setMaxCount(self, max: int) -> None: ...
    def setMaxVisibleItems(self, maxItems: int) -> None: ...
    def setMinimumContentsLength(self, characters: int) -> None: ...
    def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
    def setModelColumn(self, visibleColumn: int) -> None: ...
    def setPlaceholderText(self, placeholderText: str) -> None: ...
    def setRootModelIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setSizeAdjustPolicy(self, policy: QComboBox.SizeAdjustPolicy) -> None: ...
    def setValidator(self, v: PySide2.QtGui.QValidator) -> None: ...
    def setView(self, itemView: QAbstractItemView) -> None: ...
    def showEvent(self, e: PySide2.QtGui.QShowEvent) -> None: ...
    def showPopup(self) -> None: ...
    def sizeAdjustPolicy(self) -> QComboBox.SizeAdjustPolicy: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def validator(self) -> PySide2.QtGui.QValidator: ...
    def view(self) -> QAbstractItemView: ...
    def wheelEvent(self, e: PySide2.QtGui.QWheelEvent) -> None: ...

class QCommandLinkButton(QPushButton):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, text: str, description: str, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoDefault: bool = ..., autoExclusive: bool = ..., autoFillBackground: bool = ..., autoRepeat: bool = ..., autoRepeatDelay: int = ..., autoRepeatInterval: int = ..., baseSize: PySide2.QtCore.QSize = ..., checkable: bool = ..., checked: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., default: bool = ..., destroyed: typing.Callable = ..., down: bool = ..., enabled: bool = ..., flat: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., icon: PySide2.QtGui.QIcon = ..., iconSize: PySide2.QtCore.QSize = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., released: typing.Callable = ..., shortcut: typing.Union[PySide2.QtGui.QKeySequence,str] = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toggled: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoDefault: bool = ..., autoExclusive: bool = ..., autoFillBackground: bool = ..., autoRepeat: bool = ..., autoRepeatDelay: int = ..., autoRepeatInterval: int = ..., baseSize: PySide2.QtCore.QSize = ..., checkable: bool = ..., checked: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., default: bool = ..., description: str = ..., destroyed: typing.Callable = ..., down: bool = ..., enabled: bool = ..., flat: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., icon: PySide2.QtGui.QIcon = ..., iconSize: PySide2.QtCore.QSize = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., released: typing.Callable = ..., shortcut: typing.Union[PySide2.QtGui.QKeySequence,str] = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toggled: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoDefault: bool = ..., autoExclusive: bool = ..., autoFillBackground: bool = ..., autoRepeat: bool = ..., autoRepeatDelay: int = ..., autoRepeatInterval: int = ..., baseSize: PySide2.QtCore.QSize = ..., checkable: bool = ..., checked: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., default: bool = ..., description: str = ..., destroyed: typing.Callable = ..., down: bool = ..., enabled: bool = ..., flat: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., icon: PySide2.QtGui.QIcon = ..., iconSize: PySide2.QtCore.QSize = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., released: typing.Callable = ..., shortcut: typing.Union[PySide2.QtGui.QKeySequence,str] = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., toggled: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def description(self) -> str: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def setDescription(self, description: str) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...

class QCommonStyle(QStyle):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def drawComplexControl(self, cc: QStyle.ComplexControl, opt: QStyleOptionComplex, p: PySide2.QtGui.QPainter, w: typing.Union[QWidget,None] = ...) -> None: ...
    def drawControl(self, element: QStyle.ControlElement, opt: QStyleOption, p: PySide2.QtGui.QPainter, w: typing.Union[QWidget,None] = ...) -> None: ...
    def drawPrimitive(self, pe: QStyle.PrimitiveElement, opt: QStyleOption, p: PySide2.QtGui.QPainter, w: typing.Union[QWidget,None] = ...) -> None: ...
    def generatedIconPixmap(self, iconMode: PySide2.QtGui.QIcon.Mode, pixmap: PySide2.QtGui.QPixmap, opt: QStyleOption) -> PySide2.QtGui.QPixmap: ...
    def hitTestComplexControl(self, cc: QStyle.ComplexControl, opt: QStyleOptionComplex, pt: PySide2.QtCore.QPoint, w: typing.Union[QWidget,None] = ...) -> QStyle.SubControl: ...
    def layoutSpacing(self, control1: QSizePolicy.ControlType, control2: QSizePolicy.ControlType, orientation: PySide2.QtCore.Qt.Orientation, option: typing.Union[QStyleOption,None] = ..., widget: typing.Union[QWidget,None] = ...) -> int: ...
    def pixelMetric(self, m: QStyle.PixelMetric, opt: typing.Union[QStyleOption,None] = ..., widget: typing.Union[QWidget,None] = ...) -> int: ...
    @overload
    def polish(self, app: QApplication) -> None: ...
    @overload
    def polish(self, application: QApplication) -> None: ...
    @overload
    def polish(self, arg__1: PySide2.QtGui.QPalette) -> None: ...
    @overload
    def polish(self, widget: QWidget) -> None: ...
    def sizeFromContents(self, ct: QStyle.ContentsType, opt: QStyleOption, contentsSize: PySide2.QtCore.QSize, widget: typing.Union[QWidget,None] = ...) -> PySide2.QtCore.QSize: ...
    def standardIcon(self, standardIcon: QStyle.StandardPixmap, opt: typing.Union[QStyleOption,None] = ..., widget: typing.Union[QWidget,None] = ...) -> PySide2.QtGui.QIcon: ...
    def standardPixmap(self, sp: QStyle.StandardPixmap, opt: typing.Union[QStyleOption,None] = ..., widget: typing.Union[QWidget,None] = ...) -> PySide2.QtGui.QPixmap: ...
    def styleHint(self, sh: QStyle.StyleHint, opt: typing.Union[QStyleOption,None] = ..., w: typing.Union[QWidget,None] = ..., shret: typing.Union[QStyleHintReturn,None] = ...) -> int: ...
    def subControlRect(self, cc: QStyle.ComplexControl, opt: QStyleOptionComplex, sc: QStyle.SubControl, w: typing.Union[QWidget,None] = ...) -> PySide2.QtCore.QRect: ...
    def subElementRect(self, r: QStyle.SubElement, opt: QStyleOption, widget: typing.Union[QWidget,None] = ...) -> PySide2.QtCore.QRect: ...
    @overload
    def unpolish(self, application: QApplication) -> None: ...
    @overload
    def unpolish(self, widget: QWidget) -> None: ...

class QCompleter(PySide2.QtCore.QObject):
    class CompletionMode:
        InlineCompletion: typing.ClassVar[QCompleter.CompletionMode] = ...
        PopupCompletion: typing.ClassVar[QCompleter.CompletionMode] = ...
        UnfilteredPopupCompletion: typing.ClassVar[QCompleter.CompletionMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCompleter.CompletionMode: ...
        def __and__(self, other: typing.SupportsInt) -> QCompleter.CompletionMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCompleter.CompletionMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCompleter.CompletionMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QCompleter.CompletionMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QCompleter.CompletionMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCompleter.CompletionMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QCompleter.CompletionMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCompleter.CompletionMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCompleter.CompletionMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QCompleter.CompletionMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QCompleter.CompletionMode: ...

    class ModelSorting:
        CaseInsensitivelySortedModel: typing.ClassVar[QCompleter.ModelSorting] = ...
        CaseSensitivelySortedModel: typing.ClassVar[QCompleter.ModelSorting] = ...
        UnsortedModel: typing.ClassVar[QCompleter.ModelSorting] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCompleter.ModelSorting: ...
        def __and__(self, other: typing.SupportsInt) -> QCompleter.ModelSorting: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCompleter.ModelSorting: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCompleter.ModelSorting: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QCompleter.ModelSorting: ...
        def __rand__(self, other: typing.SupportsInt) -> QCompleter.ModelSorting: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCompleter.ModelSorting: ...
        def __ror__(self, other: typing.SupportsInt) -> QCompleter.ModelSorting: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCompleter.ModelSorting: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCompleter.ModelSorting: ...
        def __sub__(self, other: typing.SupportsInt) -> QCompleter.ModelSorting: ...
        def __xor__(self, other: typing.SupportsInt) -> QCompleter.ModelSorting: ...
    CaseInsensitivelySortedModel: typing.ClassVar[QCompleter.ModelSorting] = ...
    CaseSensitivelySortedModel: typing.ClassVar[QCompleter.ModelSorting] = ...
    InlineCompletion: typing.ClassVar[QCompleter.CompletionMode] = ...
    PopupCompletion: typing.ClassVar[QCompleter.CompletionMode] = ...
    UnfilteredPopupCompletion: typing.ClassVar[QCompleter.CompletionMode] = ...
    UnsortedModel: typing.ClassVar[QCompleter.ModelSorting] = ...
    activated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    highlighted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, completions: typing.Iterable[str], parent: typing.Union[PySide2.QtCore.QObject,None] = ..., activated: typing.Callable = ..., caseSensitivity: PySide2.QtCore.Qt.CaseSensitivity = ..., completionColumn: int = ..., completionMode: QCompleter.CompletionMode = ..., completionPrefix: str = ..., completionRole: int = ..., destroyed: typing.Callable = ..., filterMode: typing.Union[PySide2.QtCore.Qt.MatchFlags,PySide2.QtCore.Qt.MatchFlag] = ..., highlighted: typing.Callable = ..., maxVisibleItems: int = ..., modelSorting: QCompleter.ModelSorting = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., wrapAround: bool = ...) -> None: ...
    @overload
    def __init__(self, model: PySide2.QtCore.QAbstractItemModel, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., activated: typing.Callable = ..., caseSensitivity: PySide2.QtCore.Qt.CaseSensitivity = ..., completionColumn: int = ..., completionMode: QCompleter.CompletionMode = ..., completionPrefix: str = ..., completionRole: int = ..., destroyed: typing.Callable = ..., filterMode: typing.Union[PySide2.QtCore.Qt.MatchFlags,PySide2.QtCore.Qt.MatchFlag] = ..., highlighted: typing.Callable = ..., maxVisibleItems: int = ..., modelSorting: QCompleter.ModelSorting = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., wrapAround: bool = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., activated: typing.Callable = ..., caseSensitivity: PySide2.QtCore.Qt.CaseSensitivity = ..., completionColumn: int = ..., completionMode: QCompleter.CompletionMode = ..., completionPrefix: str = ..., completionRole: int = ..., destroyed: typing.Callable = ..., filterMode: typing.Union[PySide2.QtCore.Qt.MatchFlags,PySide2.QtCore.Qt.MatchFlag] = ..., highlighted: typing.Callable = ..., maxVisibleItems: int = ..., modelSorting: QCompleter.ModelSorting = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., wrapAround: bool = ...) -> None: ...
    def caseSensitivity(self) -> PySide2.QtCore.Qt.CaseSensitivity: ...
    def complete(self, rect: PySide2.QtCore.QRect = ...) -> None: ...
    def completionColumn(self) -> int: ...
    def completionCount(self) -> int: ...
    def completionMode(self) -> QCompleter.CompletionMode: ...
    def completionModel(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def completionPrefix(self) -> str: ...
    def completionRole(self) -> int: ...
    def currentCompletion(self) -> str: ...
    def currentIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def currentRow(self) -> int: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, o: PySide2.QtCore.QObject, e: PySide2.QtCore.QEvent) -> bool: ...
    def filterMode(self) -> typing.Union[PySide2.QtCore.Qt.MatchFlags,PySide2.QtCore.Qt.MatchFlag]: ...
    def maxVisibleItems(self) -> int: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def modelSorting(self) -> QCompleter.ModelSorting: ...
    def pathFromIndex(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def popup(self) -> QAbstractItemView: ...
    def setCaseSensitivity(self, caseSensitivity: PySide2.QtCore.Qt.CaseSensitivity) -> None: ...
    def setCompletionColumn(self, column: int) -> None: ...
    def setCompletionMode(self, mode: QCompleter.CompletionMode) -> None: ...
    def setCompletionPrefix(self, prefix: str) -> None: ...
    def setCompletionRole(self, role: PySide2.QtCore.Qt.ItemDataRole) -> None: ...
    def setCurrentRow(self, row: int) -> bool: ...
    def setFilterMode(self, filterMode: typing.Union[PySide2.QtCore.Qt.MatchFlags,PySide2.QtCore.Qt.MatchFlag]) -> None: ...
    def setMaxVisibleItems(self, maxItems: int) -> None: ...
    def setModel(self, c: PySide2.QtCore.QAbstractItemModel) -> None: ...
    def setModelSorting(self, sorting: QCompleter.ModelSorting) -> None: ...
    def setPopup(self, popup: QAbstractItemView) -> None: ...
    def setWidget(self, widget: QWidget) -> None: ...
    def setWrapAround(self, wrap: bool) -> None: ...
    def splitPath(self, path: str) -> typing.List[str]: ...
    def widget(self) -> QWidget: ...
    def wrapAround(self) -> bool: ...

class QDataWidgetMapper(PySide2.QtCore.QObject):
    class SubmitPolicy:
        AutoSubmit: typing.ClassVar[QDataWidgetMapper.SubmitPolicy] = ...
        ManualSubmit: typing.ClassVar[QDataWidgetMapper.SubmitPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDataWidgetMapper.SubmitPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QDataWidgetMapper.SubmitPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDataWidgetMapper.SubmitPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDataWidgetMapper.SubmitPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QDataWidgetMapper.SubmitPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QDataWidgetMapper.SubmitPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDataWidgetMapper.SubmitPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QDataWidgetMapper.SubmitPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDataWidgetMapper.SubmitPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDataWidgetMapper.SubmitPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QDataWidgetMapper.SubmitPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QDataWidgetMapper.SubmitPolicy: ...
    AutoSubmit: typing.ClassVar[QDataWidgetMapper.SubmitPolicy] = ...
    ManualSubmit: typing.ClassVar[QDataWidgetMapper.SubmitPolicy] = ...
    currentIndexChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., currentIndex: int = ..., currentIndexChanged: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., submitPolicy: QDataWidgetMapper.SubmitPolicy = ...) -> None: ...
    @overload
    def addMapping(self, widget: QWidget, section: int, propertyName: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    @overload
    def addMapping(self, widget: QWidget, section: int) -> None: ...
    def clearMapping(self) -> None: ...
    def currentIndex(self) -> int: ...
    def itemDelegate(self) -> QAbstractItemDelegate: ...
    def mappedPropertyName(self, widget: QWidget) -> PySide2.QtCore.QByteArray: ...
    def mappedSection(self, widget: QWidget) -> int: ...
    def mappedWidgetAt(self, section: int) -> QWidget: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def removeMapping(self, widget: QWidget) -> None: ...
    def revert(self) -> None: ...
    def rootIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentModelIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None: ...
    def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
    def setOrientation(self, aOrientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setSubmitPolicy(self, policy: QDataWidgetMapper.SubmitPolicy) -> None: ...
    def submit(self) -> bool: ...
    def submitPolicy(self) -> QDataWidgetMapper.SubmitPolicy: ...
    def toFirst(self) -> None: ...
    def toLast(self) -> None: ...
    def toNext(self) -> None: ...
    def toPrevious(self) -> None: ...

class QDateEdit(QDateTimeEdit):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    userDateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, date: PySide2.QtCore.QDate, parent: typing.Union[QWidget,None] = ..., accelerated: bool = ..., acceptDrops: bool = ..., acceptableInput: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., buttonSymbols: QDateEdit.ButtonSymbols = ..., calendarPopup: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., correctionMode: QDateEdit.CorrectionMode = ..., currentSection: QDateEdit.Section = ..., currentSectionIndex: int = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., dateChanged: typing.Callable = ..., dateTime: PySide2.QtCore.QDateTime = ..., dateTimeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., displayFormat: str = ..., displayedSections: QDateEdit.Sections = ..., editingFinished: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frame: bool = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., keyboardTracking: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumDate: PySide2.QtCore.QDate = ..., maximumDateTime: PySide2.QtCore.QDateTime = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumTime: PySide2.QtCore.QTime = ..., maximumWidth: int = ..., minimized: bool = ..., minimumDate: PySide2.QtCore.QDate = ..., minimumDateTime: PySide2.QtCore.QDateTime = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumTime: PySide2.QtCore.QTime = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., sectionCount: int = ..., showGroupSeparator: bool = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., specialValueText: str = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., time: PySide2.QtCore.QTime = ..., timeChanged: typing.Callable = ..., timeSpec: PySide2.QtCore.Qt.TimeSpec = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., userDateChanged: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wrapping: bool = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., accelerated: bool = ..., acceptDrops: bool = ..., acceptableInput: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., buttonSymbols: QDateEdit.ButtonSymbols = ..., calendarPopup: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., correctionMode: QDateEdit.CorrectionMode = ..., currentSection: QDateEdit.Section = ..., currentSectionIndex: int = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., date: PySide2.QtCore.QDate = ..., dateChanged: typing.Callable = ..., dateTime: PySide2.QtCore.QDateTime = ..., dateTimeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., displayFormat: str = ..., displayedSections: QDateEdit.Sections = ..., editingFinished: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frame: bool = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., keyboardTracking: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumDate: PySide2.QtCore.QDate = ..., maximumDateTime: PySide2.QtCore.QDateTime = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumTime: PySide2.QtCore.QTime = ..., maximumWidth: int = ..., minimized: bool = ..., minimumDate: PySide2.QtCore.QDate = ..., minimumDateTime: PySide2.QtCore.QDateTime = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumTime: PySide2.QtCore.QTime = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., sectionCount: int = ..., showGroupSeparator: bool = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., specialValueText: str = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., time: PySide2.QtCore.QTime = ..., timeChanged: typing.Callable = ..., timeSpec: PySide2.QtCore.Qt.TimeSpec = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., userDateChanged: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wrapping: bool = ..., x: int = ..., y: int = ...) -> None: ...

class QDateTimeEdit(QAbstractSpinBox):
    class Section:
        AmPmSection: typing.ClassVar[QDateTimeEdit.Section] = ...
        DateSections_Mask: typing.ClassVar[QDateTimeEdit.Section] = ...
        DaySection: typing.ClassVar[QDateTimeEdit.Section] = ...
        HourSection: typing.ClassVar[QDateTimeEdit.Section] = ...
        MSecSection: typing.ClassVar[QDateTimeEdit.Section] = ...
        MinuteSection: typing.ClassVar[QDateTimeEdit.Section] = ...
        MonthSection: typing.ClassVar[QDateTimeEdit.Section] = ...
        NoSection: typing.ClassVar[QDateTimeEdit.Section] = ...
        SecondSection: typing.ClassVar[QDateTimeEdit.Section] = ...
        TimeSections_Mask: typing.ClassVar[QDateTimeEdit.Section] = ...
        YearSection: typing.ClassVar[QDateTimeEdit.Section] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QDateTimeEdit.Sections: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QDateTimeEdit.Sections: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDateTimeEdit.Sections: ...
        def __rand__(self, other: typing.SupportsInt) -> QDateTimeEdit.Sections: ...
        def __ror__(self, other: typing.SupportsInt) -> QDateTimeEdit.Sections: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDateTimeEdit.Sections: ...
        def __xor__(self, other: typing.SupportsInt) -> QDateTimeEdit.Sections: ...

    class Sections:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QDateTimeEdit.Sections: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QDateTimeEdit.Sections: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDateTimeEdit.Sections: ...
        def __rand__(self, other: typing.SupportsInt) -> QDateTimeEdit.Sections: ...
        def __ror__(self, other: typing.SupportsInt) -> QDateTimeEdit.Sections: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDateTimeEdit.Sections: ...
        def __xor__(self, other: typing.SupportsInt) -> QDateTimeEdit.Sections: ...
    AmPmSection: typing.ClassVar[QDateTimeEdit.Section] = ...
    DateSections_Mask: typing.ClassVar[QDateTimeEdit.Section] = ...
    DaySection: typing.ClassVar[QDateTimeEdit.Section] = ...
    HourSection: typing.ClassVar[QDateTimeEdit.Section] = ...
    MSecSection: typing.ClassVar[QDateTimeEdit.Section] = ...
    MinuteSection: typing.ClassVar[QDateTimeEdit.Section] = ...
    MonthSection: typing.ClassVar[QDateTimeEdit.Section] = ...
    NoSection: typing.ClassVar[QDateTimeEdit.Section] = ...
    SecondSection: typing.ClassVar[QDateTimeEdit.Section] = ...
    TimeSections_Mask: typing.ClassVar[QDateTimeEdit.Section] = ...
    YearSection: typing.ClassVar[QDateTimeEdit.Section] = ...
    dateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    dateTimeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    timeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, val: typing.Any, parserType: type, parent: typing.Union[QWidget,None] = ..., accelerated: bool = ..., acceptDrops: bool = ..., acceptableInput: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., buttonSymbols: QDateTimeEdit.ButtonSymbols = ..., calendarPopup: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., correctionMode: QDateTimeEdit.CorrectionMode = ..., currentSection: QDateTimeEdit.Section = ..., currentSectionIndex: int = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., date: PySide2.QtCore.QDate = ..., dateChanged: typing.Callable = ..., dateTime: PySide2.QtCore.QDateTime = ..., dateTimeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., displayFormat: str = ..., displayedSections: typing.Union[QDateTimeEdit.Sections,QDateTimeEdit.Section] = ..., editingFinished: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frame: bool = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., keyboardTracking: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumDate: PySide2.QtCore.QDate = ..., maximumDateTime: PySide2.QtCore.QDateTime = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumTime: PySide2.QtCore.QTime = ..., maximumWidth: int = ..., minimized: bool = ..., minimumDate: PySide2.QtCore.QDate = ..., minimumDateTime: PySide2.QtCore.QDateTime = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumTime: PySide2.QtCore.QTime = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., sectionCount: int = ..., showGroupSeparator: bool = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., specialValueText: str = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., time: PySide2.QtCore.QTime = ..., timeChanged: typing.Callable = ..., timeSpec: PySide2.QtCore.Qt.TimeSpec = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wrapping: bool = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, d: PySide2.QtCore.QDate, parent: typing.Union[QWidget,None] = ..., accelerated: bool = ..., acceptDrops: bool = ..., acceptableInput: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., buttonSymbols: QDateTimeEdit.ButtonSymbols = ..., calendarPopup: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., correctionMode: QDateTimeEdit.CorrectionMode = ..., currentSection: QDateTimeEdit.Section = ..., currentSectionIndex: int = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., date: PySide2.QtCore.QDate = ..., dateChanged: typing.Callable = ..., dateTime: PySide2.QtCore.QDateTime = ..., dateTimeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., displayFormat: str = ..., displayedSections: typing.Union[QDateTimeEdit.Sections,QDateTimeEdit.Section] = ..., editingFinished: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frame: bool = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., keyboardTracking: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumDate: PySide2.QtCore.QDate = ..., maximumDateTime: PySide2.QtCore.QDateTime = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumTime: PySide2.QtCore.QTime = ..., maximumWidth: int = ..., minimized: bool = ..., minimumDate: PySide2.QtCore.QDate = ..., minimumDateTime: PySide2.QtCore.QDateTime = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumTime: PySide2.QtCore.QTime = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., sectionCount: int = ..., showGroupSeparator: bool = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., specialValueText: str = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., time: PySide2.QtCore.QTime = ..., timeChanged: typing.Callable = ..., timeSpec: PySide2.QtCore.Qt.TimeSpec = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wrapping: bool = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, dt: PySide2.QtCore.QDateTime, parent: typing.Union[QWidget,None] = ..., accelerated: bool = ..., acceptDrops: bool = ..., acceptableInput: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., buttonSymbols: QDateTimeEdit.ButtonSymbols = ..., calendarPopup: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., correctionMode: QDateTimeEdit.CorrectionMode = ..., currentSection: QDateTimeEdit.Section = ..., currentSectionIndex: int = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., date: PySide2.QtCore.QDate = ..., dateChanged: typing.Callable = ..., dateTime: PySide2.QtCore.QDateTime = ..., dateTimeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., displayFormat: str = ..., displayedSections: typing.Union[QDateTimeEdit.Sections,QDateTimeEdit.Section] = ..., editingFinished: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frame: bool = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., keyboardTracking: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumDate: PySide2.QtCore.QDate = ..., maximumDateTime: PySide2.QtCore.QDateTime = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumTime: PySide2.QtCore.QTime = ..., maximumWidth: int = ..., minimized: bool = ..., minimumDate: PySide2.QtCore.QDate = ..., minimumDateTime: PySide2.QtCore.QDateTime = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumTime: PySide2.QtCore.QTime = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., sectionCount: int = ..., showGroupSeparator: bool = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., specialValueText: str = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., time: PySide2.QtCore.QTime = ..., timeChanged: typing.Callable = ..., timeSpec: PySide2.QtCore.Qt.TimeSpec = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wrapping: bool = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, t: PySide2.QtCore.QTime, parent: typing.Union[QWidget,None] = ..., accelerated: bool = ..., acceptDrops: bool = ..., acceptableInput: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., buttonSymbols: QDateTimeEdit.ButtonSymbols = ..., calendarPopup: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., correctionMode: QDateTimeEdit.CorrectionMode = ..., currentSection: QDateTimeEdit.Section = ..., currentSectionIndex: int = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., date: PySide2.QtCore.QDate = ..., dateChanged: typing.Callable = ..., dateTime: PySide2.QtCore.QDateTime = ..., dateTimeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., displayFormat: str = ..., displayedSections: typing.Union[QDateTimeEdit.Sections,QDateTimeEdit.Section] = ..., editingFinished: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frame: bool = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., keyboardTracking: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumDate: PySide2.QtCore.QDate = ..., maximumDateTime: PySide2.QtCore.QDateTime = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumTime: PySide2.QtCore.QTime = ..., maximumWidth: int = ..., minimized: bool = ..., minimumDate: PySide2.QtCore.QDate = ..., minimumDateTime: PySide2.QtCore.QDateTime = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumTime: PySide2.QtCore.QTime = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., sectionCount: int = ..., showGroupSeparator: bool = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., specialValueText: str = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., time: PySide2.QtCore.QTime = ..., timeChanged: typing.Callable = ..., timeSpec: PySide2.QtCore.Qt.TimeSpec = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wrapping: bool = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., accelerated: bool = ..., acceptDrops: bool = ..., acceptableInput: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., buttonSymbols: QDateTimeEdit.ButtonSymbols = ..., calendarPopup: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., correctionMode: QDateTimeEdit.CorrectionMode = ..., currentSection: QDateTimeEdit.Section = ..., currentSectionIndex: int = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., date: PySide2.QtCore.QDate = ..., dateChanged: typing.Callable = ..., dateTime: PySide2.QtCore.QDateTime = ..., dateTimeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., displayFormat: str = ..., displayedSections: typing.Union[QDateTimeEdit.Sections,QDateTimeEdit.Section] = ..., editingFinished: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frame: bool = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., keyboardTracking: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumDate: PySide2.QtCore.QDate = ..., maximumDateTime: PySide2.QtCore.QDateTime = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumTime: PySide2.QtCore.QTime = ..., maximumWidth: int = ..., minimized: bool = ..., minimumDate: PySide2.QtCore.QDate = ..., minimumDateTime: PySide2.QtCore.QDateTime = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumTime: PySide2.QtCore.QTime = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., sectionCount: int = ..., showGroupSeparator: bool = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., specialValueText: str = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., time: PySide2.QtCore.QTime = ..., timeChanged: typing.Callable = ..., timeSpec: PySide2.QtCore.Qt.TimeSpec = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wrapping: bool = ..., x: int = ..., y: int = ...) -> None: ...
    def calendar(self) -> PySide2.QtCore.QCalendar: ...
    def calendarPopup(self) -> bool: ...
    def calendarWidget(self) -> QCalendarWidget: ...
    def clear(self) -> None: ...
    def clearMaximumDate(self) -> None: ...
    def clearMaximumDateTime(self) -> None: ...
    def clearMaximumTime(self) -> None: ...
    def clearMinimumDate(self) -> None: ...
    def clearMinimumDateTime(self) -> None: ...
    def clearMinimumTime(self) -> None: ...
    def currentSection(self) -> QDateTimeEdit.Section: ...
    def currentSectionIndex(self) -> int: ...
    def date(self) -> PySide2.QtCore.QDate: ...
    def dateTime(self) -> PySide2.QtCore.QDateTime: ...
    def dateTimeFromText(self, text: str) -> PySide2.QtCore.QDateTime: ...
    def displayFormat(self) -> str: ...
    def displayedSections(self) -> typing.Union[QDateTimeEdit.Sections,QDateTimeEdit.Section]: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def fixup(self, input: str) -> None: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def initStyleOption(self, option: QStyleOptionSpinBox) -> None: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def maximumDate(self) -> PySide2.QtCore.QDate: ...
    def maximumDateTime(self) -> PySide2.QtCore.QDateTime: ...
    def maximumTime(self) -> PySide2.QtCore.QTime: ...
    def minimumDate(self) -> PySide2.QtCore.QDate: ...
    def minimumDateTime(self) -> PySide2.QtCore.QDateTime: ...
    def minimumTime(self) -> PySide2.QtCore.QTime: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    def sectionAt(self, index: int) -> QDateTimeEdit.Section: ...
    def sectionCount(self) -> int: ...
    def sectionText(self, section: QDateTimeEdit.Section) -> str: ...
    def setCalendar(self, calendar: PySide2.QtCore.QCalendar) -> None: ...
    def setCalendarPopup(self, enable: bool) -> None: ...
    def setCalendarWidget(self, calendarWidget: QCalendarWidget) -> None: ...
    def setCurrentSection(self, section: QDateTimeEdit.Section) -> None: ...
    def setCurrentSectionIndex(self, index: int) -> None: ...
    def setDate(self, date: PySide2.QtCore.QDate) -> None: ...
    def setDateRange(self, min: PySide2.QtCore.QDate, max: PySide2.QtCore.QDate) -> None: ...
    def setDateTime(self, dateTime: PySide2.QtCore.QDateTime) -> None: ...
    def setDateTimeRange(self, min: PySide2.QtCore.QDateTime, max: PySide2.QtCore.QDateTime) -> None: ...
    def setDisplayFormat(self, format: str) -> None: ...
    def setMaximumDate(self, max: PySide2.QtCore.QDate) -> None: ...
    def setMaximumDateTime(self, dt: PySide2.QtCore.QDateTime) -> None: ...
    def setMaximumTime(self, max: PySide2.QtCore.QTime) -> None: ...
    def setMinimumDate(self, min: PySide2.QtCore.QDate) -> None: ...
    def setMinimumDateTime(self, dt: PySide2.QtCore.QDateTime) -> None: ...
    def setMinimumTime(self, min: PySide2.QtCore.QTime) -> None: ...
    def setSelectedSection(self, section: QDateTimeEdit.Section) -> None: ...
    def setTime(self, time: PySide2.QtCore.QTime) -> None: ...
    def setTimeRange(self, min: PySide2.QtCore.QTime, max: PySide2.QtCore.QTime) -> None: ...
    def setTimeSpec(self, spec: PySide2.QtCore.Qt.TimeSpec) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def stepBy(self, steps: int) -> None: ...
    def stepEnabled(self) -> typing.Union[QAbstractSpinBox.StepEnabled,QAbstractSpinBox.StepEnabledFlag]: ...
    def textFromDateTime(self, dt: PySide2.QtCore.QDateTime) -> str: ...
    def time(self) -> PySide2.QtCore.QTime: ...
    def timeSpec(self) -> PySide2.QtCore.Qt.TimeSpec: ...
    def validate(self, input: str, pos: int) -> PySide2.QtGui.QValidator.State: ...
    def wheelEvent(self, event: PySide2.QtGui.QWheelEvent) -> None: ...

class QDesktopWidget(QWidget):
    primaryScreenChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    resized: typing.ClassVar[PySide2.QtCore.Signal] = ...
    screenCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    workAreaResized: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., primaryScreen: int = ..., primaryScreenChanged: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., resized: typing.Callable = ..., screenCount: int = ..., screenCountChanged: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., virtualDesktop: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., workAreaResized: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def availableGeometry(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QRect: ...
    @overload
    def availableGeometry(self, screen: int = ...) -> PySide2.QtCore.QRect: ...
    @overload
    def availableGeometry(self, widget: QWidget) -> PySide2.QtCore.QRect: ...
    def isVirtualDesktop(self) -> bool: ...
    def numScreens(self) -> int: ...
    def primaryScreen(self) -> int: ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent) -> None: ...
    @overload
    def screen(self, screen: int = ...) -> QWidget: ...
    @overload
    def screen(self) -> PySide2.QtGui.QScreen: ...
    def screenCount(self) -> int: ...
    @overload
    def screenGeometry(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QRect: ...
    @overload
    def screenGeometry(self, screen: int = ...) -> PySide2.QtCore.QRect: ...
    @overload
    def screenGeometry(self, widget: QWidget) -> PySide2.QtCore.QRect: ...
    @overload
    def screenNumber(self, arg__1: PySide2.QtCore.QPoint) -> int: ...
    @overload
    def screenNumber(self, widget: typing.Union[QWidget,None] = ...) -> int: ...

class QDial(QAbstractSlider):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., actionTriggered: typing.Callable = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., invertedAppearance: bool = ..., invertedControls: bool = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximum: int = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimum: int = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., notchSize: int = ..., notchTarget: float = ..., notchesVisible: bool = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., pageStep: int = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rangeChanged: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., singleStep: int = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., sliderDown: bool = ..., sliderMoved: typing.Callable = ..., sliderPosition: int = ..., sliderPressed: typing.Callable = ..., sliderReleased: typing.Callable = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., tracking: bool = ..., updatesEnabled: bool = ..., value: int = ..., valueChanged: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wrapping: bool = ..., x: int = ..., y: int = ...) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: QStyleOptionSlider) -> None: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, me: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, me: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, me: PySide2.QtGui.QMouseEvent) -> None: ...
    def notchSize(self) -> int: ...
    def notchTarget(self) -> float: ...
    def notchesVisible(self) -> bool: ...
    def paintEvent(self, pe: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, re: PySide2.QtGui.QResizeEvent) -> None: ...
    def setNotchTarget(self, target: float) -> None: ...
    def setNotchesVisible(self, visible: bool) -> None: ...
    def setWrapping(self, on: bool) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sliderChange(self, change: QAbstractSlider.SliderChange) -> None: ...
    def wrapping(self) -> bool: ...

class QDialog(QWidget):
    class DialogCode:
        Accepted: typing.ClassVar[QDialog.DialogCode] = ...
        Rejected: typing.ClassVar[QDialog.DialogCode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDialog.DialogCode: ...
        def __and__(self, other: typing.SupportsInt) -> QDialog.DialogCode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDialog.DialogCode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDialog.DialogCode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QDialog.DialogCode: ...
        def __rand__(self, other: typing.SupportsInt) -> QDialog.DialogCode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDialog.DialogCode: ...
        def __ror__(self, other: typing.SupportsInt) -> QDialog.DialogCode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDialog.DialogCode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDialog.DialogCode: ...
        def __sub__(self, other: typing.SupportsInt) -> QDialog.DialogCode: ...
        def __xor__(self, other: typing.SupportsInt) -> QDialog.DialogCode: ...
    Accepted: typing.ClassVar[QDialog.DialogCode] = ...
    Rejected: typing.ClassVar[QDialog.DialogCode] = ...
    accepted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    rejected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., f: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def accept(self) -> None: ...
    def adjustPosition(self, arg__1: QWidget) -> None: ...
    def closeEvent(self, arg__1: PySide2.QtGui.QCloseEvent) -> None: ...
    def contextMenuEvent(self, arg__1: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def done(self, arg__1: int) -> None: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def exec(self, *args, **kwargs) -> typing.Any: ...
    def exec_(self) -> int: ...
    def extension(self) -> QWidget: ...
    def isSizeGripEnabled(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def open(self) -> None: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def reject(self) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def result(self) -> int: ...
    def setExtension(self, extension: QWidget) -> None: ...
    def setModal(self, modal: bool) -> None: ...
    def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setResult(self, r: int) -> None: ...
    def setSizeGripEnabled(self, arg__1: bool) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent) -> None: ...
    def showExtension(self, arg__1: bool) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...

class QDialogButtonBox(QWidget):
    class ButtonLayout:
        AndroidLayout: typing.ClassVar[QDialogButtonBox.ButtonLayout] = ...
        GnomeLayout: typing.ClassVar[QDialogButtonBox.ButtonLayout] = ...
        KdeLayout: typing.ClassVar[QDialogButtonBox.ButtonLayout] = ...
        MacLayout: typing.ClassVar[QDialogButtonBox.ButtonLayout] = ...
        WinLayout: typing.ClassVar[QDialogButtonBox.ButtonLayout] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonLayout: ...
        def __and__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonLayout: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonLayout: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonLayout: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonLayout: ...
        def __rand__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonLayout: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonLayout: ...
        def __ror__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonLayout: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonLayout: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonLayout: ...
        def __sub__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonLayout: ...
        def __xor__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonLayout: ...

    class ButtonRole:
        AcceptRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
        ActionRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
        ApplyRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
        DestructiveRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
        HelpRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
        InvalidRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
        NRoles: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
        NoRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
        RejectRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
        ResetRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
        YesRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonRole: ...
        def __and__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonRole: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonRole: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonRole: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonRole: ...
        def __rand__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonRole: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonRole: ...
        def __ror__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonRole: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonRole: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonRole: ...
        def __sub__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonRole: ...
        def __xor__(self, other: typing.SupportsInt) -> QDialogButtonBox.ButtonRole: ...

    class StandardButton:
        Abort: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        Apply: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        Cancel: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        Close: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        Discard: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        FirstButton: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        Help: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        Ignore: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        LastButton: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        No: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        NoButton: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        NoToAll: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        Ok: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        Open: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        Reset: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        RestoreDefaults: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        Retry: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        Save: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        SaveAll: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        Yes: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        YesToAll: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QDialogButtonBox.StandardButtons: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QDialogButtonBox.StandardButtons: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDialogButtonBox.StandardButtons: ...
        def __rand__(self, other: typing.SupportsInt) -> QDialogButtonBox.StandardButtons: ...
        def __ror__(self, other: typing.SupportsInt) -> QDialogButtonBox.StandardButtons: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDialogButtonBox.StandardButtons: ...
        def __xor__(self, other: typing.SupportsInt) -> QDialogButtonBox.StandardButtons: ...

    class StandardButtons:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QDialogButtonBox.StandardButtons: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QDialogButtonBox.StandardButtons: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDialogButtonBox.StandardButtons: ...
        def __rand__(self, other: typing.SupportsInt) -> QDialogButtonBox.StandardButtons: ...
        def __ror__(self, other: typing.SupportsInt) -> QDialogButtonBox.StandardButtons: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDialogButtonBox.StandardButtons: ...
        def __xor__(self, other: typing.SupportsInt) -> QDialogButtonBox.StandardButtons: ...
    Abort: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    AcceptRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
    ActionRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
    AndroidLayout: typing.ClassVar[QDialogButtonBox.ButtonLayout] = ...
    Apply: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    ApplyRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
    Cancel: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    Close: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    DestructiveRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
    Discard: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    FirstButton: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    GnomeLayout: typing.ClassVar[QDialogButtonBox.ButtonLayout] = ...
    Help: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    HelpRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
    Ignore: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    InvalidRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
    KdeLayout: typing.ClassVar[QDialogButtonBox.ButtonLayout] = ...
    LastButton: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    MacLayout: typing.ClassVar[QDialogButtonBox.ButtonLayout] = ...
    NRoles: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
    No: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    NoButton: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    NoRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
    NoToAll: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    Ok: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    Open: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    RejectRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
    Reset: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    ResetRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
    RestoreDefaults: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    Retry: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    Save: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    SaveAll: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    WinLayout: typing.ClassVar[QDialogButtonBox.ButtonLayout] = ...
    Yes: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    YesRole: typing.ClassVar[QDialogButtonBox.ButtonRole] = ...
    YesToAll: typing.ClassVar[QDialogButtonBox.StandardButton] = ...
    accepted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    helpRequested: typing.ClassVar[PySide2.QtCore.Signal] = ...
    rejected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, buttons: typing.Union[QDialogButtonBox.StandardButtons,QDialogButtonBox.StandardButton], orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., centerButtons: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., helpRequested: typing.Callable = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., standardButtons: typing.Union[QDialogButtonBox.StandardButtons,QDialogButtonBox.StandardButton] = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, buttons: typing.Union[QDialogButtonBox.StandardButtons,QDialogButtonBox.StandardButton], parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., centerButtons: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., helpRequested: typing.Callable = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., standardButtons: typing.Union[QDialogButtonBox.StandardButtons,QDialogButtonBox.StandardButton] = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., centerButtons: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., helpRequested: typing.Callable = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., standardButtons: typing.Union[QDialogButtonBox.StandardButtons,QDialogButtonBox.StandardButton] = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., centerButtons: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., helpRequested: typing.Callable = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., standardButtons: typing.Union[QDialogButtonBox.StandardButtons,QDialogButtonBox.StandardButton] = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def addButton(self, button: QAbstractButton, role: QDialogButtonBox.ButtonRole) -> None: ...
    @overload
    def addButton(self, text: str, role: QDialogButtonBox.ButtonRole) -> QPushButton: ...
    @overload
    def addButton(self, button: QDialogButtonBox.StandardButton) -> QPushButton: ...
    def button(self, which: QDialogButtonBox.StandardButton) -> QPushButton: ...
    def buttonRole(self, button: QAbstractButton) -> QDialogButtonBox.ButtonRole: ...
    def buttons(self) -> typing.List[QAbstractButton]: ...
    def centerButtons(self) -> bool: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def removeButton(self, button: QAbstractButton) -> None: ...
    def setCenterButtons(self, center: bool) -> None: ...
    def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setStandardButtons(self, buttons: typing.Union[QDialogButtonBox.StandardButtons,QDialogButtonBox.StandardButton]) -> None: ...
    def standardButton(self, button: QAbstractButton) -> QDialogButtonBox.StandardButton: ...
    def standardButtons(self) -> typing.Union[QDialogButtonBox.StandardButtons,QDialogButtonBox.StandardButton]: ...

class QDirModel(PySide2.QtCore.QAbstractItemModel):
    class Roles:
        FileIconRole: typing.ClassVar[QDirModel.Roles] = ...
        FileNameRole: typing.ClassVar[QDirModel.Roles] = ...
        FilePathRole: typing.ClassVar[QDirModel.Roles] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDirModel.Roles: ...
        def __and__(self, other: typing.SupportsInt) -> QDirModel.Roles: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDirModel.Roles: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDirModel.Roles: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QDirModel.Roles: ...
        def __rand__(self, other: typing.SupportsInt) -> QDirModel.Roles: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDirModel.Roles: ...
        def __ror__(self, other: typing.SupportsInt) -> QDirModel.Roles: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDirModel.Roles: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDirModel.Roles: ...
        def __sub__(self, other: typing.SupportsInt) -> QDirModel.Roles: ...
        def __xor__(self, other: typing.SupportsInt) -> QDirModel.Roles: ...
    FileIconRole: typing.ClassVar[QDirModel.Roles] = ...
    FileNameRole: typing.ClassVar[QDirModel.Roles] = ...
    FilePathRole: typing.ClassVar[QDirModel.Roles] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, nameFilters: typing.Iterable[str], filters: typing.Union[PySide2.QtCore.QDir.Filters,PySide2.QtCore.QDir.Filter], sort: typing.Union[PySide2.QtCore.QDir.SortFlags,PySide2.QtCore.QDir.SortFlag], parent: typing.Union[PySide2.QtCore.QObject,None] = ..., columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., lazyChildCount: bool = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readOnly: bool = ..., resolveSymlinks: bool = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., lazyChildCount: bool = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readOnly: bool = ..., resolveSymlinks: bool = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ...) -> None: ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def fileIcon(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtGui.QIcon: ...
    def fileInfo(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QFileInfo: ...
    def fileName(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def filePath(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def filter(self) -> typing.Union[PySide2.QtCore.QDir.Filters,PySide2.QtCore.QDir.Filter]: ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> typing.Union[PySide2.QtCore.Qt.ItemFlags,PySide2.QtCore.Qt.ItemFlag]: ...
    def hasChildren(self, index: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def iconProvider(self) -> QFileIconProvider: ...
    @overload
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    @overload
    def index(self, path: str, column: int = ...) -> PySide2.QtCore.QModelIndex: ...
    def isDir(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def lazyChildCount(self) -> bool: ...
    def mimeData(self, indexes: typing.List[int]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def mkdir(self, parent: PySide2.QtCore.QModelIndex, name: str) -> PySide2.QtCore.QModelIndex: ...
    def nameFilters(self) -> typing.List[str]: ...
    @overload
    def parent(self, child: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    @overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    def refresh(self, parent: PySide2.QtCore.QModelIndex = ...) -> None: ...
    def remove(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def resolveSymlinks(self) -> bool: ...
    def rmdir(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def setData(self, index: PySide2.QtCore.QModelIndex, value: typing.Any, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> bool: ...
    def setFilter(self, filters: typing.Union[PySide2.QtCore.QDir.Filters,PySide2.QtCore.QDir.Filter]) -> None: ...
    def setIconProvider(self, provider: QFileIconProvider) -> None: ...
    def setLazyChildCount(self, enable: bool) -> None: ...
    def setNameFilters(self, filters: typing.Iterable[str]) -> None: ...
    def setReadOnly(self, enable: bool) -> None: ...
    def setResolveSymlinks(self, enable: bool) -> None: ...
    def setSorting(self, sort: typing.Union[PySide2.QtCore.QDir.SortFlags,PySide2.QtCore.QDir.SortFlag]) -> None: ...
    def sort(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...) -> None: ...
    def sorting(self) -> typing.Union[PySide2.QtCore.QDir.SortFlags,PySide2.QtCore.QDir.SortFlag]: ...
    def supportedDropActions(self) -> typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction]: ...

class QDockWidget(QWidget):
    class DockWidgetFeature:
        AllDockWidgetFeatures: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
        DockWidgetClosable: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
        DockWidgetFeatureMask: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
        DockWidgetFloatable: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
        DockWidgetMovable: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
        DockWidgetVerticalTitleBar: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
        NoDockWidgetFeatures: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
        Reserved: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QDockWidget.DockWidgetFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QDockWidget.DockWidgetFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDockWidget.DockWidgetFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QDockWidget.DockWidgetFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QDockWidget.DockWidgetFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDockWidget.DockWidgetFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QDockWidget.DockWidgetFeatures: ...

    class DockWidgetFeatures:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QDockWidget.DockWidgetFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QDockWidget.DockWidgetFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDockWidget.DockWidgetFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QDockWidget.DockWidgetFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QDockWidget.DockWidgetFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDockWidget.DockWidgetFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QDockWidget.DockWidgetFeatures: ...
    AllDockWidgetFeatures: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
    DockWidgetClosable: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
    DockWidgetFeatureMask: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
    DockWidgetFloatable: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
    DockWidgetMovable: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
    DockWidgetVerticalTitleBar: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
    NoDockWidgetFeatures: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
    Reserved: typing.ClassVar[QDockWidget.DockWidgetFeature] = ...
    allowedAreasChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    dockLocationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    featuresChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    topLevelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    visibilityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, title: str, parent: typing.Union[QWidget,None] = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., allowedAreas: typing.Union[PySide2.QtCore.Qt.DockWidgetAreas,PySide2.QtCore.Qt.DockWidgetArea] = ..., allowedAreasChanged: typing.Callable = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., dockLocationChanged: typing.Callable = ..., enabled: bool = ..., features: typing.Union[QDockWidget.DockWidgetFeatures,QDockWidget.DockWidgetFeature] = ..., featuresChanged: typing.Callable = ..., floating: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., topLevelChanged: typing.Callable = ..., updatesEnabled: bool = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., allowedAreas: typing.Union[PySide2.QtCore.Qt.DockWidgetAreas,PySide2.QtCore.Qt.DockWidgetArea] = ..., allowedAreasChanged: typing.Callable = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., dockLocationChanged: typing.Callable = ..., enabled: bool = ..., features: typing.Union[QDockWidget.DockWidgetFeatures,QDockWidget.DockWidgetFeature] = ..., featuresChanged: typing.Callable = ..., floating: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., topLevelChanged: typing.Callable = ..., updatesEnabled: bool = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def allowedAreas(self) -> typing.Union[PySide2.QtCore.Qt.DockWidgetAreas,PySide2.QtCore.Qt.DockWidgetArea]: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def features(self) -> typing.Union[QDockWidget.DockWidgetFeatures,QDockWidget.DockWidgetFeature]: ...
    def initStyleOption(self, option: QStyleOptionDockWidget) -> None: ...
    def isAreaAllowed(self, area: PySide2.QtCore.Qt.DockWidgetArea) -> bool: ...
    def isFloating(self) -> bool: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    def setAllowedAreas(self, areas: typing.Union[PySide2.QtCore.Qt.DockWidgetAreas,PySide2.QtCore.Qt.DockWidgetArea]) -> None: ...
    def setFeatures(self, features: typing.Union[QDockWidget.DockWidgetFeatures,QDockWidget.DockWidgetFeature]) -> None: ...
    def setFloating(self, floating: bool) -> None: ...
    def setTitleBarWidget(self, widget: QWidget) -> None: ...
    def setWidget(self, widget: QWidget) -> None: ...
    def titleBarWidget(self) -> QWidget: ...
    def toggleViewAction(self) -> QAction: ...
    def widget(self) -> QWidget: ...

class QDoubleSpinBox(QAbstractSpinBox):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    textChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., accelerated: bool = ..., acceptDrops: bool = ..., acceptableInput: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., buttonSymbols: QDoubleSpinBox.ButtonSymbols = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., cleanText: str = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., correctionMode: QDoubleSpinBox.CorrectionMode = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., decimals: int = ..., destroyed: typing.Callable = ..., editingFinished: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frame: bool = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., keyboardTracking: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximum: float = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimum: float = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., prefix: str = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., showGroupSeparator: bool = ..., singleStep: float = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., specialValueText: str = ..., statusTip: str = ..., stepType: QDoubleSpinBox.StepType = ..., styleSheet: str = ..., suffix: str = ..., tabletTracking: bool = ..., text: str = ..., textChanged: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., value: float = ..., valueChanged: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wrapping: bool = ..., x: int = ..., y: int = ...) -> None: ...
    def cleanText(self) -> str: ...
    def decimals(self) -> int: ...
    def fixup(self, str: str) -> None: ...
    def maximum(self) -> float: ...
    def minimum(self) -> float: ...
    def prefix(self) -> str: ...
    def setDecimals(self, prec: int) -> None: ...
    def setMaximum(self, max: float) -> None: ...
    def setMinimum(self, min: float) -> None: ...
    def setPrefix(self, prefix: str) -> None: ...
    def setRange(self, min: float, max: float) -> None: ...
    def setSingleStep(self, val: float) -> None: ...
    def setStepType(self, stepType: QAbstractSpinBox.StepType) -> None: ...
    def setSuffix(self, suffix: str) -> None: ...
    def setValue(self, val: float) -> None: ...
    def singleStep(self) -> float: ...
    def stepType(self) -> QAbstractSpinBox.StepType: ...
    def suffix(self) -> str: ...
    def textFromValue(self, val: float) -> str: ...
    def validate(self, input: str, pos: int) -> PySide2.QtGui.QValidator.State: ...
    def value(self) -> float: ...
    def valueFromText(self, text: str) -> float: ...

class QErrorMessage(QDialog):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent) -> None: ...
    def done(self, arg__1: int) -> None: ...
    @classmethod
    def qtHandler(cls) -> QErrorMessage: ...
    @overload
    def showMessage(self, message: str, type: str) -> None: ...
    @overload
    def showMessage(self, message: str) -> None: ...

class QFileDialog(QDialog):
    class AcceptMode:
        AcceptOpen: typing.ClassVar[QFileDialog.AcceptMode] = ...
        AcceptSave: typing.ClassVar[QFileDialog.AcceptMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFileDialog.AcceptMode: ...
        def __and__(self, other: typing.SupportsInt) -> QFileDialog.AcceptMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFileDialog.AcceptMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileDialog.AcceptMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFileDialog.AcceptMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileDialog.AcceptMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFileDialog.AcceptMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileDialog.AcceptMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFileDialog.AcceptMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileDialog.AcceptMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QFileDialog.AcceptMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileDialog.AcceptMode: ...

    class DialogLabel:
        Accept: typing.ClassVar[QFileDialog.DialogLabel] = ...
        FileName: typing.ClassVar[QFileDialog.DialogLabel] = ...
        FileType: typing.ClassVar[QFileDialog.DialogLabel] = ...
        LookIn: typing.ClassVar[QFileDialog.DialogLabel] = ...
        Reject: typing.ClassVar[QFileDialog.DialogLabel] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFileDialog.DialogLabel: ...
        def __and__(self, other: typing.SupportsInt) -> QFileDialog.DialogLabel: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFileDialog.DialogLabel: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileDialog.DialogLabel: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFileDialog.DialogLabel: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileDialog.DialogLabel: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFileDialog.DialogLabel: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileDialog.DialogLabel: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFileDialog.DialogLabel: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileDialog.DialogLabel: ...
        def __sub__(self, other: typing.SupportsInt) -> QFileDialog.DialogLabel: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileDialog.DialogLabel: ...

    class FileMode:
        AnyFile: typing.ClassVar[QFileDialog.FileMode] = ...
        Directory: typing.ClassVar[QFileDialog.FileMode] = ...
        DirectoryOnly: typing.ClassVar[QFileDialog.FileMode] = ...
        ExistingFile: typing.ClassVar[QFileDialog.FileMode] = ...
        ExistingFiles: typing.ClassVar[QFileDialog.FileMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFileDialog.FileMode: ...
        def __and__(self, other: typing.SupportsInt) -> QFileDialog.FileMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFileDialog.FileMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileDialog.FileMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFileDialog.FileMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileDialog.FileMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFileDialog.FileMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileDialog.FileMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFileDialog.FileMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileDialog.FileMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QFileDialog.FileMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileDialog.FileMode: ...

    class Option:
        DontConfirmOverwrite: typing.ClassVar[QFileDialog.Option] = ...
        DontResolveSymlinks: typing.ClassVar[QFileDialog.Option] = ...
        DontUseCustomDirectoryIcons: typing.ClassVar[QFileDialog.Option] = ...
        DontUseNativeDialog: typing.ClassVar[QFileDialog.Option] = ...
        DontUseSheet: typing.ClassVar[QFileDialog.Option] = ...
        HideNameFilterDetails: typing.ClassVar[QFileDialog.Option] = ...
        ReadOnly: typing.ClassVar[QFileDialog.Option] = ...
        ShowDirsOnly: typing.ClassVar[QFileDialog.Option] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QFileDialog.Options: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QFileDialog.Options: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileDialog.Options: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileDialog.Options: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileDialog.Options: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileDialog.Options: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileDialog.Options: ...

    class Options:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QFileDialog.Options: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QFileDialog.Options: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileDialog.Options: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileDialog.Options: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileDialog.Options: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileDialog.Options: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileDialog.Options: ...

    class ViewMode:
        Detail: typing.ClassVar[QFileDialog.ViewMode] = ...
        List: typing.ClassVar[QFileDialog.ViewMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFileDialog.ViewMode: ...
        def __and__(self, other: typing.SupportsInt) -> QFileDialog.ViewMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFileDialog.ViewMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileDialog.ViewMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFileDialog.ViewMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileDialog.ViewMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFileDialog.ViewMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileDialog.ViewMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFileDialog.ViewMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileDialog.ViewMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QFileDialog.ViewMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileDialog.ViewMode: ...
    Accept: typing.ClassVar[QFileDialog.DialogLabel] = ...
    AcceptOpen: typing.ClassVar[QFileDialog.AcceptMode] = ...
    AcceptSave: typing.ClassVar[QFileDialog.AcceptMode] = ...
    AnyFile: typing.ClassVar[QFileDialog.FileMode] = ...
    Detail: typing.ClassVar[QFileDialog.ViewMode] = ...
    Directory: typing.ClassVar[QFileDialog.FileMode] = ...
    DirectoryOnly: typing.ClassVar[QFileDialog.FileMode] = ...
    DontConfirmOverwrite: typing.ClassVar[QFileDialog.Option] = ...
    DontResolveSymlinks: typing.ClassVar[QFileDialog.Option] = ...
    DontUseCustomDirectoryIcons: typing.ClassVar[QFileDialog.Option] = ...
    DontUseNativeDialog: typing.ClassVar[QFileDialog.Option] = ...
    DontUseSheet: typing.ClassVar[QFileDialog.Option] = ...
    ExistingFile: typing.ClassVar[QFileDialog.FileMode] = ...
    ExistingFiles: typing.ClassVar[QFileDialog.FileMode] = ...
    FileName: typing.ClassVar[QFileDialog.DialogLabel] = ...
    FileType: typing.ClassVar[QFileDialog.DialogLabel] = ...
    HideNameFilterDetails: typing.ClassVar[QFileDialog.Option] = ...
    List: typing.ClassVar[QFileDialog.ViewMode] = ...
    LookIn: typing.ClassVar[QFileDialog.DialogLabel] = ...
    ReadOnly: typing.ClassVar[QFileDialog.Option] = ...
    Reject: typing.ClassVar[QFileDialog.DialogLabel] = ...
    ShowDirsOnly: typing.ClassVar[QFileDialog.Option] = ...
    currentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    currentUrlChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    directoryEntered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    directoryUrlEntered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    fileSelected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    filesSelected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    filterSelected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    urlSelected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    urlsSelected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., caption: str = ..., directory: str = ..., filter: str = ..., acceptDrops: bool = ..., acceptMode: QFileDialog.AcceptMode = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., confirmOverwrite: bool = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., currentChanged: typing.Callable = ..., currentUrlChanged: typing.Callable = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., defaultSuffix: str = ..., destroyed: typing.Callable = ..., directoryEntered: typing.Callable = ..., directoryUrlEntered: typing.Callable = ..., enabled: bool = ..., fileMode: QFileDialog.FileMode = ..., fileSelected: typing.Callable = ..., filesSelected: typing.Callable = ..., filterSelected: typing.Callable = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., nameFilterDetailsVisible: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., options: typing.Union[QFileDialog.Options,QFileDialog.Option] = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., resolveSymlinks: bool = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., supportedSchemes: None = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., urlSelected: typing.Callable = ..., urlsSelected: typing.Callable = ..., viewMode: QFileDialog.ViewMode = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None], f: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType], acceptDrops: bool = ..., acceptMode: QFileDialog.AcceptMode = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., confirmOverwrite: bool = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., currentChanged: typing.Callable = ..., currentUrlChanged: typing.Callable = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., defaultSuffix: str = ..., destroyed: typing.Callable = ..., directoryEntered: typing.Callable = ..., directoryUrlEntered: typing.Callable = ..., enabled: bool = ..., fileMode: QFileDialog.FileMode = ..., fileSelected: typing.Callable = ..., filesSelected: typing.Callable = ..., filterSelected: typing.Callable = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., nameFilterDetailsVisible: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., options: typing.Union[QFileDialog.Options,QFileDialog.Option] = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., resolveSymlinks: bool = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., supportedSchemes: None = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., urlSelected: typing.Callable = ..., urlsSelected: typing.Callable = ..., viewMode: QFileDialog.ViewMode = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def accept(self) -> None: ...
    def acceptMode(self) -> QFileDialog.AcceptMode: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent) -> None: ...
    def confirmOverwrite(self) -> bool: ...
    def defaultSuffix(self) -> str: ...
    def directory(self) -> PySide2.QtCore.QDir: ...
    def directoryUrl(self) -> PySide2.QtCore.QUrl: ...
    def done(self, result: int) -> None: ...
    def fileMode(self) -> QFileDialog.FileMode: ...
    def filter(self) -> typing.Union[PySide2.QtCore.QDir.Filters,PySide2.QtCore.QDir.Filter]: ...
    @classmethod
    def getExistingDirectory(cls, parent: typing.Union[QWidget,None] = ..., caption: str = ..., dir: str = ..., options: typing.Union[QFileDialog.Options,QFileDialog.Option] = ...) -> str: ...
    @classmethod
    def getExistingDirectoryUrl(cls, parent: typing.Union[QWidget,None] = ..., caption: str = ..., dir: PySide2.QtCore.QUrl = ..., options: typing.Union[QFileDialog.Options,QFileDialog.Option] = ..., supportedSchemes: typing.Iterable[str] = ...) -> PySide2.QtCore.QUrl: ...
    @classmethod
    def getOpenFileName(cls, parent: typing.Union[QWidget,None] = ..., caption: str = ..., dir: str = ..., filter: str = ..., selectedFilter: str = ..., options: typing.Union[QFileDialog.Options,QFileDialog.Option] = ...) -> typing.Tuple[str,str]: ...
    @classmethod
    def getOpenFileNames(cls, parent: typing.Union[QWidget,None] = ..., caption: str = ..., dir: str = ..., filter: str = ..., selectedFilter: str = ..., options: typing.Union[QFileDialog.Options,QFileDialog.Option] = ...) -> typing.Tuple[typing.List[str],str]: ...
    @classmethod
    def getOpenFileUrl(cls, parent: typing.Union[QWidget,None] = ..., caption: str = ..., dir: PySide2.QtCore.QUrl = ..., filter: str = ..., selectedFilter: str = ..., options: typing.Union[QFileDialog.Options,QFileDialog.Option] = ..., supportedSchemes: typing.Iterable[str] = ...) -> typing.Tuple[PySide2.QtCore.QUrl,str]: ...
    @classmethod
    def getOpenFileUrls(cls, parent: typing.Union[QWidget,None] = ..., caption: str = ..., dir: PySide2.QtCore.QUrl = ..., filter: str = ..., selectedFilter: str = ..., options: typing.Union[QFileDialog.Options,QFileDialog.Option] = ..., supportedSchemes: typing.Iterable[str] = ...) -> typing.Tuple[typing.List[PySide2.QtCore.QUrl],str]: ...
    @classmethod
    def getSaveFileName(cls, parent: typing.Union[QWidget,None] = ..., caption: str = ..., dir: str = ..., filter: str = ..., selectedFilter: str = ..., options: typing.Union[QFileDialog.Options,QFileDialog.Option] = ...) -> typing.Tuple[str,str]: ...
    @classmethod
    def getSaveFileUrl(cls, parent: typing.Union[QWidget,None] = ..., caption: str = ..., dir: PySide2.QtCore.QUrl = ..., filter: str = ..., selectedFilter: str = ..., options: typing.Union[QFileDialog.Options,QFileDialog.Option] = ..., supportedSchemes: typing.Iterable[str] = ...) -> typing.Tuple[PySide2.QtCore.QUrl,str]: ...
    def history(self) -> typing.List[str]: ...
    def iconProvider(self) -> QFileIconProvider: ...
    def isNameFilterDetailsVisible(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def itemDelegate(self) -> QAbstractItemDelegate: ...
    def labelText(self, label: QFileDialog.DialogLabel) -> str: ...
    def mimeTypeFilters(self) -> typing.List[str]: ...
    def nameFilters(self) -> typing.List[str]: ...
    @overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    @overload
    def open(self) -> None: ...
    def options(self) -> typing.Union[QFileDialog.Options,QFileDialog.Option]: ...
    def proxyModel(self) -> PySide2.QtCore.QAbstractProxyModel: ...
    def resolveSymlinks(self) -> bool: ...
    def restoreState(self, state: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> bool: ...
    @classmethod
    def saveFileContent(cls, fileContent: typing.Union[PySide2.QtCore.QByteArray,bytes], fileNameHint: str = ...) -> None: ...
    def saveState(self) -> PySide2.QtCore.QByteArray: ...
    def selectFile(self, filename: str) -> None: ...
    def selectMimeTypeFilter(self, filter: str) -> None: ...
    def selectNameFilter(self, filter: str) -> None: ...
    def selectUrl(self, url: PySide2.QtCore.QUrl) -> None: ...
    def selectedFiles(self) -> typing.List[str]: ...
    def selectedMimeTypeFilter(self) -> str: ...
    def selectedNameFilter(self) -> str: ...
    def selectedUrls(self) -> typing.List[PySide2.QtCore.QUrl]: ...
    def setAcceptMode(self, mode: QFileDialog.AcceptMode) -> None: ...
    def setConfirmOverwrite(self, enabled: bool) -> None: ...
    def setDefaultSuffix(self, suffix: str) -> None: ...
    @overload
    def setDirectory(self, directory: PySide2.QtCore.QDir) -> None: ...
    @overload
    def setDirectory(self, directory: str) -> None: ...
    def setDirectoryUrl(self, directory: PySide2.QtCore.QUrl) -> None: ...
    def setFileMode(self, mode: QFileDialog.FileMode) -> None: ...
    def setFilter(self, filters: typing.Union[PySide2.QtCore.QDir.Filters,PySide2.QtCore.QDir.Filter]) -> None: ...
    def setHistory(self, paths: typing.Iterable[str]) -> None: ...
    def setIconProvider(self, provider: QFileIconProvider) -> None: ...
    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None: ...
    def setLabelText(self, label: QFileDialog.DialogLabel, text: str) -> None: ...
    def setMimeTypeFilters(self, filters: typing.Iterable[str]) -> None: ...
    def setNameFilter(self, filter: str) -> None: ...
    def setNameFilterDetailsVisible(self, enabled: bool) -> None: ...
    def setNameFilters(self, filters: typing.Iterable[str]) -> None: ...
    def setOption(self, option: QFileDialog.Option, on: bool = ...) -> None: ...
    def setOptions(self, options: typing.Union[QFileDialog.Options,QFileDialog.Option]) -> None: ...
    def setProxyModel(self, model: PySide2.QtCore.QAbstractProxyModel) -> None: ...
    def setReadOnly(self, enabled: bool) -> None: ...
    def setResolveSymlinks(self, enabled: bool) -> None: ...
    def setSidebarUrls(self, urls: typing.Iterable[PySide2.QtCore.QUrl]) -> None: ...
    def setSupportedSchemes(self, schemes: typing.Iterable[str]) -> None: ...
    def setViewMode(self, mode: QFileDialog.ViewMode) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def sidebarUrls(self) -> typing.List[PySide2.QtCore.QUrl]: ...
    def supportedSchemes(self) -> typing.List[str]: ...
    def testOption(self, option: QFileDialog.Option) -> bool: ...
    def viewMode(self) -> QFileDialog.ViewMode: ...

class QFileIconProvider(shiboken2.Object):
    class IconType:
        Computer: typing.ClassVar[QFileIconProvider.IconType] = ...
        Desktop: typing.ClassVar[QFileIconProvider.IconType] = ...
        Drive: typing.ClassVar[QFileIconProvider.IconType] = ...
        File: typing.ClassVar[QFileIconProvider.IconType] = ...
        Folder: typing.ClassVar[QFileIconProvider.IconType] = ...
        Network: typing.ClassVar[QFileIconProvider.IconType] = ...
        Trashcan: typing.ClassVar[QFileIconProvider.IconType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFileIconProvider.IconType: ...
        def __and__(self, other: typing.SupportsInt) -> QFileIconProvider.IconType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFileIconProvider.IconType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileIconProvider.IconType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFileIconProvider.IconType: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileIconProvider.IconType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFileIconProvider.IconType: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileIconProvider.IconType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFileIconProvider.IconType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileIconProvider.IconType: ...
        def __sub__(self, other: typing.SupportsInt) -> QFileIconProvider.IconType: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileIconProvider.IconType: ...

    class Option:
        DontUseCustomDirectoryIcons: typing.ClassVar[QFileIconProvider.Option] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QFileIconProvider.Options: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QFileIconProvider.Options: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileIconProvider.Options: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileIconProvider.Options: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileIconProvider.Options: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileIconProvider.Options: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileIconProvider.Options: ...

    class Options:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QFileIconProvider.Options: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QFileIconProvider.Options: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileIconProvider.Options: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileIconProvider.Options: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileIconProvider.Options: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileIconProvider.Options: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileIconProvider.Options: ...
    Computer: typing.ClassVar[QFileIconProvider.IconType] = ...
    Desktop: typing.ClassVar[QFileIconProvider.IconType] = ...
    DontUseCustomDirectoryIcons: typing.ClassVar[QFileIconProvider.Option] = ...
    Drive: typing.ClassVar[QFileIconProvider.IconType] = ...
    File: typing.ClassVar[QFileIconProvider.IconType] = ...
    Folder: typing.ClassVar[QFileIconProvider.IconType] = ...
    Network: typing.ClassVar[QFileIconProvider.IconType] = ...
    Trashcan: typing.ClassVar[QFileIconProvider.IconType] = ...
    def __init__(self) -> None: ...
    @overload
    def icon(self, info: PySide2.QtCore.QFileInfo) -> PySide2.QtGui.QIcon: ...
    @overload
    def icon(self, type: QFileIconProvider.IconType) -> PySide2.QtGui.QIcon: ...
    def options(self) -> typing.Union[QFileIconProvider.Options,QFileIconProvider.Option]: ...
    def setOptions(self, options: typing.Union[QFileIconProvider.Options,QFileIconProvider.Option]) -> None: ...
    def type(self, info: PySide2.QtCore.QFileInfo) -> str: ...

class QFileSystemModel(PySide2.QtCore.QAbstractItemModel):
    class Option:
        DontResolveSymlinks: typing.ClassVar[QFileSystemModel.Option] = ...
        DontUseCustomDirectoryIcons: typing.ClassVar[QFileSystemModel.Option] = ...
        DontWatchForChanges: typing.ClassVar[QFileSystemModel.Option] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QFileSystemModel.Options: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QFileSystemModel.Options: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileSystemModel.Options: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileSystemModel.Options: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileSystemModel.Options: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileSystemModel.Options: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileSystemModel.Options: ...

    class Options:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QFileSystemModel.Options: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QFileSystemModel.Options: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileSystemModel.Options: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileSystemModel.Options: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileSystemModel.Options: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileSystemModel.Options: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileSystemModel.Options: ...

    class Roles:
        FileIconRole: typing.ClassVar[QFileSystemModel.Roles] = ...
        FileNameRole: typing.ClassVar[QFileSystemModel.Roles] = ...
        FilePathRole: typing.ClassVar[QFileSystemModel.Roles] = ...
        FilePermissions: typing.ClassVar[QFileSystemModel.Roles] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFileSystemModel.Roles: ...
        def __and__(self, other: typing.SupportsInt) -> QFileSystemModel.Roles: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFileSystemModel.Roles: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileSystemModel.Roles: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFileSystemModel.Roles: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileSystemModel.Roles: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFileSystemModel.Roles: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileSystemModel.Roles: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFileSystemModel.Roles: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileSystemModel.Roles: ...
        def __sub__(self, other: typing.SupportsInt) -> QFileSystemModel.Roles: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileSystemModel.Roles: ...
    DontResolveSymlinks: typing.ClassVar[QFileSystemModel.Option] = ...
    DontUseCustomDirectoryIcons: typing.ClassVar[QFileSystemModel.Option] = ...
    DontWatchForChanges: typing.ClassVar[QFileSystemModel.Option] = ...
    FileIconRole: typing.ClassVar[QFileSystemModel.Roles] = ...
    FileNameRole: typing.ClassVar[QFileSystemModel.Roles] = ...
    FilePathRole: typing.ClassVar[QFileSystemModel.Roles] = ...
    FilePermissions: typing.ClassVar[QFileSystemModel.Roles] = ...
    directoryLoaded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    fileRenamed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    rootPathChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., directoryLoaded: typing.Callable = ..., fileRenamed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., nameFilterDisables: bool = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., options: typing.Union[QFileSystemModel.Options,QFileSystemModel.Option] = ..., readOnly: bool = ..., resolveSymlinks: bool = ..., rootPathChanged: typing.Callable = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ...) -> None: ...
    def canFetchMore(self, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def fetchMore(self, parent: PySide2.QtCore.QModelIndex) -> None: ...
    def fileIcon(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtGui.QIcon: ...
    def fileInfo(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QFileInfo: ...
    def fileName(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def filePath(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def filter(self) -> typing.Union[PySide2.QtCore.QDir.Filters,PySide2.QtCore.QDir.Filter]: ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> typing.Union[PySide2.QtCore.Qt.ItemFlags,PySide2.QtCore.Qt.ItemFlag]: ...
    def hasChildren(self, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def iconProvider(self) -> QFileIconProvider: ...
    @overload
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    @overload
    def index(self, path: str, column: int = ...) -> PySide2.QtCore.QModelIndex: ...
    def isDir(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def lastModified(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QDateTime: ...
    def mimeData(self, indexes: typing.List[int]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def mkdir(self, parent: PySide2.QtCore.QModelIndex, name: str) -> PySide2.QtCore.QModelIndex: ...
    def myComputer(self, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def nameFilterDisables(self) -> bool: ...
    def nameFilters(self) -> typing.List[str]: ...
    def options(self) -> typing.Union[QFileSystemModel.Options,QFileSystemModel.Option]: ...
    @overload
    def parent(self, child: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    @overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    def remove(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def resolveSymlinks(self) -> bool: ...
    def rmdir(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def rootDirectory(self) -> PySide2.QtCore.QDir: ...
    def rootPath(self) -> str: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def setData(self, index: PySide2.QtCore.QModelIndex, value: typing.Any, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> bool: ...
    def setFilter(self, filters: typing.Union[PySide2.QtCore.QDir.Filters,PySide2.QtCore.QDir.Filter]) -> None: ...
    def setIconProvider(self, provider: QFileIconProvider) -> None: ...
    def setNameFilterDisables(self, enable: bool) -> None: ...
    def setNameFilters(self, filters: typing.Iterable[str]) -> None: ...
    def setOption(self, option: QFileSystemModel.Option, on: bool = ...) -> None: ...
    def setOptions(self, options: typing.Union[QFileSystemModel.Options,QFileSystemModel.Option]) -> None: ...
    def setReadOnly(self, enable: bool) -> None: ...
    def setResolveSymlinks(self, enable: bool) -> None: ...
    def setRootPath(self, path: str) -> PySide2.QtCore.QModelIndex: ...
    def sibling(self, row: int, column: int, idx: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def size(self, index: PySide2.QtCore.QModelIndex) -> int: ...
    def sort(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...) -> None: ...
    def supportedDropActions(self) -> typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction]: ...
    def testOption(self, option: QFileSystemModel.Option) -> bool: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent) -> None: ...
    def type(self, index: PySide2.QtCore.QModelIndex) -> str: ...

class QFocusFrame(QWidget):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: QStyleOption) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def setWidget(self, widget: QWidget) -> None: ...
    def widget(self) -> QWidget: ...

class QFontComboBox(QComboBox):
    class FontFilter:
        AllFonts: typing.ClassVar[QFontComboBox.FontFilter] = ...
        MonospacedFonts: typing.ClassVar[QFontComboBox.FontFilter] = ...
        NonScalableFonts: typing.ClassVar[QFontComboBox.FontFilter] = ...
        ProportionalFonts: typing.ClassVar[QFontComboBox.FontFilter] = ...
        ScalableFonts: typing.ClassVar[QFontComboBox.FontFilter] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QFontComboBox.FontFilters: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QFontComboBox.FontFilters: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFontComboBox.FontFilters: ...
        def __rand__(self, other: typing.SupportsInt) -> QFontComboBox.FontFilters: ...
        def __ror__(self, other: typing.SupportsInt) -> QFontComboBox.FontFilters: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFontComboBox.FontFilters: ...
        def __xor__(self, other: typing.SupportsInt) -> QFontComboBox.FontFilters: ...

    class FontFilters:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QFontComboBox.FontFilters: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QFontComboBox.FontFilters: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFontComboBox.FontFilters: ...
        def __rand__(self, other: typing.SupportsInt) -> QFontComboBox.FontFilters: ...
        def __ror__(self, other: typing.SupportsInt) -> QFontComboBox.FontFilters: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFontComboBox.FontFilters: ...
        def __xor__(self, other: typing.SupportsInt) -> QFontComboBox.FontFilters: ...
    AllFonts: typing.ClassVar[QFontComboBox.FontFilter] = ...
    MonospacedFonts: typing.ClassVar[QFontComboBox.FontFilter] = ...
    NonScalableFonts: typing.ClassVar[QFontComboBox.FontFilter] = ...
    ProportionalFonts: typing.ClassVar[QFontComboBox.FontFilter] = ...
    ScalableFonts: typing.ClassVar[QFontComboBox.FontFilter] = ...
    currentFontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., activated: typing.Callable = ..., autoCompletion: bool = ..., autoCompletionCaseSensitivity: PySide2.QtCore.Qt.CaseSensitivity = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., count: int = ..., currentData: object = ..., currentFont: PySide2.QtGui.QFont = ..., currentFontChanged: typing.Callable = ..., currentIndex: int = ..., currentIndexChanged: typing.Callable = ..., currentText: str = ..., currentTextChanged: typing.Callable = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., duplicatesEnabled: bool = ..., editTextChanged: typing.Callable = ..., editable: bool = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., fontFilters: typing.Union[QFontComboBox.FontFilters,QFontComboBox.FontFilter] = ..., frame: bool = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., highlighted: typing.Callable = ..., iconSize: PySide2.QtCore.QSize = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., insertPolicy: QFontComboBox.InsertPolicy = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maxCount: int = ..., maxVisibleItems: int = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumContentsLength: int = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., modelColumn: int = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., placeholderText: str = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QFontComboBox.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., textActivated: typing.Callable = ..., textHighlighted: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., writingSystem: typing.Any = ..., x: int = ..., y: int = ...) -> None: ...
    def currentFont(self) -> PySide2.QtGui.QFont: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def fontFilters(self) -> typing.Union[QFontComboBox.FontFilters,QFontComboBox.FontFilter]: ...
    def setCurrentFont(self, f: PySide2.QtGui.QFont) -> None: ...
    def setFontFilters(self, filters: typing.Union[QFontComboBox.FontFilters,QFontComboBox.FontFilter]) -> None: ...
    def setWritingSystem(self, arg__1: PySide2.QtGui.QFontDatabase.WritingSystem) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def writingSystem(self) -> PySide2.QtGui.QFontDatabase.WritingSystem: ...

class QFontDialog(QDialog):
    class FontDialogOption:
        DontUseNativeDialog: typing.ClassVar[QFontDialog.FontDialogOption] = ...
        MonospacedFonts: typing.ClassVar[QFontDialog.FontDialogOption] = ...
        NoButtons: typing.ClassVar[QFontDialog.FontDialogOption] = ...
        NonScalableFonts: typing.ClassVar[QFontDialog.FontDialogOption] = ...
        ProportionalFonts: typing.ClassVar[QFontDialog.FontDialogOption] = ...
        ScalableFonts: typing.ClassVar[QFontDialog.FontDialogOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QFontDialog.FontDialogOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QFontDialog.FontDialogOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFontDialog.FontDialogOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QFontDialog.FontDialogOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QFontDialog.FontDialogOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFontDialog.FontDialogOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QFontDialog.FontDialogOptions: ...

    class FontDialogOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QFontDialog.FontDialogOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QFontDialog.FontDialogOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFontDialog.FontDialogOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QFontDialog.FontDialogOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QFontDialog.FontDialogOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFontDialog.FontDialogOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QFontDialog.FontDialogOptions: ...
    DontUseNativeDialog: typing.ClassVar[QFontDialog.FontDialogOption] = ...
    MonospacedFonts: typing.ClassVar[QFontDialog.FontDialogOption] = ...
    NoButtons: typing.ClassVar[QFontDialog.FontDialogOption] = ...
    NonScalableFonts: typing.ClassVar[QFontDialog.FontDialogOption] = ...
    ProportionalFonts: typing.ClassVar[QFontDialog.FontDialogOption] = ...
    ScalableFonts: typing.ClassVar[QFontDialog.FontDialogOption] = ...
    currentFontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    fontSelected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, initial: PySide2.QtGui.QFont, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., currentFont: PySide2.QtGui.QFont = ..., currentFontChanged: typing.Callable = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., fontSelected: typing.Callable = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., options: typing.Union[QFontDialog.FontDialogOptions,QFontDialog.FontDialogOption] = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., currentFont: PySide2.QtGui.QFont = ..., currentFontChanged: typing.Callable = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., fontSelected: typing.Callable = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., options: typing.Union[QFontDialog.FontDialogOptions,QFontDialog.FontDialogOption] = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def currentFont(self) -> PySide2.QtGui.QFont: ...
    def done(self, result: int) -> None: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    @overload
    @classmethod
    def getFont(cls, initial: PySide2.QtGui.QFont, parent: typing.Union[QWidget,None] = ..., title: str = ..., options: typing.Union[QFontDialog.FontDialogOptions,QFontDialog.FontDialogOption] = ...) -> typing.Tuple[PySide2.QtGui.QFont,bool]: ...
    @overload
    @classmethod
    def getFont(cls, parent: typing.Union[QWidget,None] = ...) -> typing.Tuple[PySide2.QtGui.QFont,bool]: ...
    @overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    @overload
    def open(self) -> None: ...
    def options(self) -> typing.Union[QFontDialog.FontDialogOptions,QFontDialog.FontDialogOption]: ...
    def selectedFont(self) -> PySide2.QtGui.QFont: ...
    def setCurrentFont(self, font: PySide2.QtGui.QFont) -> None: ...
    def setOption(self, option: QFontDialog.FontDialogOption, on: bool = ...) -> None: ...
    def setOptions(self, options: typing.Union[QFontDialog.FontDialogOptions,QFontDialog.FontDialogOption]) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def testOption(self, option: QFontDialog.FontDialogOption) -> bool: ...

class QFormLayout(QLayout):
    class FieldGrowthPolicy:
        AllNonFixedFieldsGrow: typing.ClassVar[QFormLayout.FieldGrowthPolicy] = ...
        ExpandingFieldsGrow: typing.ClassVar[QFormLayout.FieldGrowthPolicy] = ...
        FieldsStayAtSizeHint: typing.ClassVar[QFormLayout.FieldGrowthPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFormLayout.FieldGrowthPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QFormLayout.FieldGrowthPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFormLayout.FieldGrowthPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFormLayout.FieldGrowthPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFormLayout.FieldGrowthPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QFormLayout.FieldGrowthPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFormLayout.FieldGrowthPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QFormLayout.FieldGrowthPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFormLayout.FieldGrowthPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFormLayout.FieldGrowthPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QFormLayout.FieldGrowthPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QFormLayout.FieldGrowthPolicy: ...

    class ItemRole:
        FieldRole: typing.ClassVar[QFormLayout.ItemRole] = ...
        LabelRole: typing.ClassVar[QFormLayout.ItemRole] = ...
        SpanningRole: typing.ClassVar[QFormLayout.ItemRole] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFormLayout.ItemRole: ...
        def __and__(self, other: typing.SupportsInt) -> QFormLayout.ItemRole: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFormLayout.ItemRole: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFormLayout.ItemRole: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFormLayout.ItemRole: ...
        def __rand__(self, other: typing.SupportsInt) -> QFormLayout.ItemRole: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFormLayout.ItemRole: ...
        def __ror__(self, other: typing.SupportsInt) -> QFormLayout.ItemRole: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFormLayout.ItemRole: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFormLayout.ItemRole: ...
        def __sub__(self, other: typing.SupportsInt) -> QFormLayout.ItemRole: ...
        def __xor__(self, other: typing.SupportsInt) -> QFormLayout.ItemRole: ...

    class RowWrapPolicy:
        DontWrapRows: typing.ClassVar[QFormLayout.RowWrapPolicy] = ...
        WrapAllRows: typing.ClassVar[QFormLayout.RowWrapPolicy] = ...
        WrapLongRows: typing.ClassVar[QFormLayout.RowWrapPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFormLayout.RowWrapPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QFormLayout.RowWrapPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFormLayout.RowWrapPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFormLayout.RowWrapPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFormLayout.RowWrapPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QFormLayout.RowWrapPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFormLayout.RowWrapPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QFormLayout.RowWrapPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFormLayout.RowWrapPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFormLayout.RowWrapPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QFormLayout.RowWrapPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QFormLayout.RowWrapPolicy: ...
    AllNonFixedFieldsGrow: typing.ClassVar[QFormLayout.FieldGrowthPolicy] = ...
    DontWrapRows: typing.ClassVar[QFormLayout.RowWrapPolicy] = ...
    ExpandingFieldsGrow: typing.ClassVar[QFormLayout.FieldGrowthPolicy] = ...
    FieldRole: typing.ClassVar[QFormLayout.ItemRole] = ...
    FieldsStayAtSizeHint: typing.ClassVar[QFormLayout.FieldGrowthPolicy] = ...
    LabelRole: typing.ClassVar[QFormLayout.ItemRole] = ...
    SpanningRole: typing.ClassVar[QFormLayout.ItemRole] = ...
    WrapAllRows: typing.ClassVar[QFormLayout.RowWrapPolicy] = ...
    WrapLongRows: typing.ClassVar[QFormLayout.RowWrapPolicy] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., destroyed: typing.Callable = ..., fieldGrowthPolicy: QFormLayout.FieldGrowthPolicy = ..., formAlignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., horizontalSpacing: int = ..., labelAlignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., margin: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowWrapPolicy: QFormLayout.RowWrapPolicy = ..., sizeConstraint: QFormLayout.SizeConstraint = ..., spacing: int = ..., verticalSpacing: int = ...) -> None: ...
    def addItem(self, item: QLayoutItem) -> None: ...
    @overload
    def addRow(self, label: QWidget, field: QLayout) -> None: ...
    @overload
    def addRow(self, label: QWidget, field: QWidget) -> None: ...
    @overload
    def addRow(self, labelText: str, field: QLayout) -> None: ...
    @overload
    def addRow(self, labelText: str, field: QWidget) -> None: ...
    @overload
    def addRow(self, layout: QLayout) -> None: ...
    @overload
    def addRow(self, widget: QWidget) -> None: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> typing.Union[PySide2.QtCore.Qt.Orientations,PySide2.QtCore.Qt.Orientation]: ...
    def fieldGrowthPolicy(self) -> QFormLayout.FieldGrowthPolicy: ...
    def formAlignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def getItemPosition(self, index: int, rolePtr: QFormLayout.ItemRole) -> int: ...
    def getLayoutPosition(self, layout: QLayout, rolePtr: QFormLayout.ItemRole) -> int: ...
    def getWidgetPosition(self, widget: QWidget, rolePtr: QFormLayout.ItemRole) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width: int) -> int: ...
    def horizontalSpacing(self) -> int: ...
    @overload
    def insertRow(self, row: int, label: QWidget, field: QLayout) -> None: ...
    @overload
    def insertRow(self, row: int, label: QWidget, field: QWidget) -> None: ...
    @overload
    def insertRow(self, row: int, labelText: str, field: QLayout) -> None: ...
    @overload
    def insertRow(self, row: int, labelText: str, field: QWidget) -> None: ...
    @overload
    def insertRow(self, row: int, layout: QLayout) -> None: ...
    @overload
    def insertRow(self, row: int, widget: QWidget) -> None: ...
    def invalidate(self) -> None: ...
    @overload
    def itemAt(self, row: int, role: QFormLayout.ItemRole) -> QLayoutItem: ...
    @overload
    def itemAt(self, index: int) -> QLayoutItem: ...
    def labelAlignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    @overload
    def labelForField(self, field: QLayout) -> QWidget: ...
    @overload
    def labelForField(self, field: QWidget) -> QWidget: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    @overload
    def removeRow(self, layout: QLayout) -> None: ...
    @overload
    def removeRow(self, row: int) -> None: ...
    @overload
    def removeRow(self, widget: QWidget) -> None: ...
    def rowCount(self) -> int: ...
    def rowWrapPolicy(self) -> QFormLayout.RowWrapPolicy: ...
    def setFieldGrowthPolicy(self, policy: QFormLayout.FieldGrowthPolicy) -> None: ...
    def setFormAlignment(self, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setGeometry(self, rect: PySide2.QtCore.QRect) -> None: ...
    def setHorizontalSpacing(self, spacing: int) -> None: ...
    def setItem(self, row: int, role: QFormLayout.ItemRole, item: QLayoutItem) -> None: ...
    def setLabelAlignment(self, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setLayout(self, row: int, role: QFormLayout.ItemRole, layout: QLayout) -> None: ...
    def setRowWrapPolicy(self, policy: QFormLayout.RowWrapPolicy) -> None: ...
    def setSpacing(self, arg__1: int) -> None: ...
    def setVerticalSpacing(self, spacing: int) -> None: ...
    def setWidget(self, row: int, role: QFormLayout.ItemRole, widget: QWidget) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def takeAt(self, index: int) -> QLayoutItem: ...
    def verticalSpacing(self) -> int: ...

class QFrame(QWidget):
    class Shadow:
        Plain: typing.ClassVar[QFrame.Shadow] = ...
        Raised: typing.ClassVar[QFrame.Shadow] = ...
        Sunken: typing.ClassVar[QFrame.Shadow] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFrame.Shadow: ...
        def __and__(self, other: typing.SupportsInt) -> QFrame.Shadow: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFrame.Shadow: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFrame.Shadow: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFrame.Shadow: ...
        def __rand__(self, other: typing.SupportsInt) -> QFrame.Shadow: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFrame.Shadow: ...
        def __ror__(self, other: typing.SupportsInt) -> QFrame.Shadow: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFrame.Shadow: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFrame.Shadow: ...
        def __sub__(self, other: typing.SupportsInt) -> QFrame.Shadow: ...
        def __xor__(self, other: typing.SupportsInt) -> QFrame.Shadow: ...

    class Shape:
        Box: typing.ClassVar[QFrame.Shape] = ...
        HLine: typing.ClassVar[QFrame.Shape] = ...
        NoFrame: typing.ClassVar[QFrame.Shape] = ...
        Panel: typing.ClassVar[QFrame.Shape] = ...
        StyledPanel: typing.ClassVar[QFrame.Shape] = ...
        VLine: typing.ClassVar[QFrame.Shape] = ...
        WinPanel: typing.ClassVar[QFrame.Shape] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFrame.Shape: ...
        def __and__(self, other: typing.SupportsInt) -> QFrame.Shape: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFrame.Shape: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFrame.Shape: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFrame.Shape: ...
        def __rand__(self, other: typing.SupportsInt) -> QFrame.Shape: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFrame.Shape: ...
        def __ror__(self, other: typing.SupportsInt) -> QFrame.Shape: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFrame.Shape: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFrame.Shape: ...
        def __sub__(self, other: typing.SupportsInt) -> QFrame.Shape: ...
        def __xor__(self, other: typing.SupportsInt) -> QFrame.Shape: ...

    class StyleMask:
        Shadow_Mask: typing.ClassVar[QFrame.StyleMask] = ...
        Shape_Mask: typing.ClassVar[QFrame.StyleMask] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFrame.StyleMask: ...
        def __and__(self, other: typing.SupportsInt) -> QFrame.StyleMask: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFrame.StyleMask: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFrame.StyleMask: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFrame.StyleMask: ...
        def __rand__(self, other: typing.SupportsInt) -> QFrame.StyleMask: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFrame.StyleMask: ...
        def __ror__(self, other: typing.SupportsInt) -> QFrame.StyleMask: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFrame.StyleMask: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFrame.StyleMask: ...
        def __sub__(self, other: typing.SupportsInt) -> QFrame.StyleMask: ...
        def __xor__(self, other: typing.SupportsInt) -> QFrame.StyleMask: ...
    Box: typing.ClassVar[QFrame.Shape] = ...
    HLine: typing.ClassVar[QFrame.Shape] = ...
    NoFrame: typing.ClassVar[QFrame.Shape] = ...
    Panel: typing.ClassVar[QFrame.Shape] = ...
    Plain: typing.ClassVar[QFrame.Shadow] = ...
    Raised: typing.ClassVar[QFrame.Shadow] = ...
    Shadow_Mask: typing.ClassVar[QFrame.StyleMask] = ...
    Shape_Mask: typing.ClassVar[QFrame.StyleMask] = ...
    StyledPanel: typing.ClassVar[QFrame.Shape] = ...
    Sunken: typing.ClassVar[QFrame.Shadow] = ...
    VLine: typing.ClassVar[QFrame.Shape] = ...
    WinPanel: typing.ClassVar[QFrame.Shape] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., f: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QFrame.Shadow = ..., frameShape: QFrame.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def drawFrame(self, arg__1: PySide2.QtGui.QPainter) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def frameRect(self) -> PySide2.QtCore.QRect: ...
    def frameShadow(self) -> QFrame.Shadow: ...
    def frameShape(self) -> QFrame.Shape: ...
    def frameStyle(self) -> int: ...
    def frameWidth(self) -> int: ...
    def initStyleOption(self, option: QStyleOptionFrame) -> None: ...
    def lineWidth(self) -> int: ...
    def midLineWidth(self) -> int: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def setFrameRect(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    def setFrameShadow(self, arg__1: QFrame.Shadow) -> None: ...
    def setFrameShape(self, arg__1: QFrame.Shape) -> None: ...
    def setFrameStyle(self, arg__1: typing.Union[QFrame.Shape,QFrame.Shadow,typing.SupportsInt]) -> None: ...
    def setLineWidth(self, arg__1: int) -> None: ...
    def setMidLineWidth(self, arg__1: int) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...

class QGesture(PySide2.QtCore.QObject):
    class GestureCancelPolicy:
        CancelAllInContext: typing.ClassVar[QGesture.GestureCancelPolicy] = ...
        CancelNone: typing.ClassVar[QGesture.GestureCancelPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGesture.GestureCancelPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QGesture.GestureCancelPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGesture.GestureCancelPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGesture.GestureCancelPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGesture.GestureCancelPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QGesture.GestureCancelPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGesture.GestureCancelPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QGesture.GestureCancelPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGesture.GestureCancelPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGesture.GestureCancelPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QGesture.GestureCancelPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QGesture.GestureCancelPolicy: ...
    CancelAllInContext: typing.ClassVar[QGesture.GestureCancelPolicy] = ...
    CancelNone: typing.ClassVar[QGesture.GestureCancelPolicy] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., gestureCancelPolicy: typing.Any = ..., gestureType: PySide2.QtCore.Qt.GestureType = ..., hasHotSpot: bool = ..., hotSpot: PySide2.QtCore.QPointF = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., state: PySide2.QtCore.Qt.GestureState = ...) -> None: ...
    def gestureCancelPolicy(self) -> QGesture.GestureCancelPolicy: ...
    def gestureType(self) -> PySide2.QtCore.Qt.GestureType: ...
    def hasHotSpot(self) -> bool: ...
    def hotSpot(self) -> PySide2.QtCore.QPointF: ...
    def setGestureCancelPolicy(self, policy: QGesture.GestureCancelPolicy) -> None: ...
    def setHotSpot(self, value: PySide2.QtCore.QPointF) -> None: ...
    def state(self) -> PySide2.QtCore.Qt.GestureState: ...
    def unsetHotSpot(self) -> None: ...

class QGestureEvent(PySide2.QtCore.QEvent):
    def __init__(self, gestures: typing.Iterable[QGesture]) -> None: ...
    @overload
    def accept(self, arg__1: PySide2.QtCore.Qt.GestureType) -> None: ...
    @overload
    def accept(self, arg__1: QGesture) -> None: ...
    @overload
    def accept(self) -> None: ...
    def activeGestures(self) -> typing.List[QGesture]: ...
    def canceledGestures(self) -> typing.List[QGesture]: ...
    def gesture(self, type: PySide2.QtCore.Qt.GestureType) -> QGesture: ...
    def gestures(self) -> typing.List[QGesture]: ...
    @overload
    def ignore(self, arg__1: PySide2.QtCore.Qt.GestureType) -> None: ...
    @overload
    def ignore(self, arg__1: QGesture) -> None: ...
    @overload
    def ignore(self) -> None: ...
    @overload
    def isAccepted(self, arg__1: PySide2.QtCore.Qt.GestureType) -> bool: ...
    @overload
    def isAccepted(self, arg__1: QGesture) -> bool: ...
    @overload
    def isAccepted(self) -> bool: ...
    def mapToGraphicsScene(self, gesturePoint: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @overload
    def setAccepted(self, arg__1: PySide2.QtCore.Qt.GestureType, arg__2: bool) -> None: ...
    @overload
    def setAccepted(self, arg__1: QGesture, arg__2: bool) -> None: ...
    @overload
    def setAccepted(self, accepted: bool) -> None: ...
    def setWidget(self, widget: QWidget) -> None: ...
    def widget(self) -> QWidget: ...

class QGestureRecognizer(shiboken2.Object):
    class Result:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGestureRecognizer.Result: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGestureRecognizer.Result: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGestureRecognizer.Result: ...
        def __rand__(self, other: typing.SupportsInt) -> QGestureRecognizer.Result: ...
        def __ror__(self, other: typing.SupportsInt) -> QGestureRecognizer.Result: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGestureRecognizer.Result: ...
        def __xor__(self, other: typing.SupportsInt) -> QGestureRecognizer.Result: ...

    class ResultFlag:
        CancelGesture: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
        ConsumeEventHint: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
        FinishGesture: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
        Ignore: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
        MayBeGesture: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
        ResultHint_Mask: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
        ResultState_Mask: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
        TriggerGesture: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGestureRecognizer.Result: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGestureRecognizer.Result: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGestureRecognizer.Result: ...
        def __rand__(self, other: typing.SupportsInt) -> QGestureRecognizer.Result: ...
        def __ror__(self, other: typing.SupportsInt) -> QGestureRecognizer.Result: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGestureRecognizer.Result: ...
        def __xor__(self, other: typing.SupportsInt) -> QGestureRecognizer.Result: ...
    CancelGesture: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
    ConsumeEventHint: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
    FinishGesture: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
    Ignore: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
    MayBeGesture: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
    ResultHint_Mask: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
    ResultState_Mask: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
    TriggerGesture: typing.ClassVar[QGestureRecognizer.ResultFlag] = ...
    def __init__(self) -> None: ...
    def create(self, target: PySide2.QtCore.QObject) -> QGesture: ...
    def recognize(self, state: QGesture, watched: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> typing.Union[QGestureRecognizer.Result,QGestureRecognizer.ResultFlag]: ...
    @classmethod
    def registerRecognizer(cls, recognizer: QGestureRecognizer) -> PySide2.QtCore.Qt.GestureType: ...
    def reset(self, state: QGesture) -> None: ...
    @classmethod
    def unregisterRecognizer(cls, type: PySide2.QtCore.Qt.GestureType) -> None: ...

class QGraphicsAnchor(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def setSizePolicy(self, policy: QSizePolicy.Policy) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def sizePolicy(self) -> QSizePolicy.Policy: ...
    def spacing(self) -> float: ...
    def unsetSpacing(self) -> None: ...

class QGraphicsAnchorLayout(QGraphicsLayout):
    def __init__(self, parent: typing.Union[QGraphicsLayoutItem,None] = ...) -> None: ...
    def addAnchor(self, firstItem: QGraphicsLayoutItem, firstEdge: PySide2.QtCore.Qt.AnchorPoint, secondItem: QGraphicsLayoutItem, secondEdge: PySide2.QtCore.Qt.AnchorPoint) -> QGraphicsAnchor: ...
    def addAnchors(self, firstItem: QGraphicsLayoutItem, secondItem: QGraphicsLayoutItem, orientations: typing.Union[PySide2.QtCore.Qt.Orientations,PySide2.QtCore.Qt.Orientation] = ...) -> None: ...
    def addCornerAnchors(self, firstItem: QGraphicsLayoutItem, firstCorner: PySide2.QtCore.Qt.Corner, secondItem: QGraphicsLayoutItem, secondCorner: PySide2.QtCore.Qt.Corner) -> None: ...
    def anchor(self, firstItem: QGraphicsLayoutItem, firstEdge: PySide2.QtCore.Qt.AnchorPoint, secondItem: QGraphicsLayoutItem, secondEdge: PySide2.QtCore.Qt.AnchorPoint) -> QGraphicsAnchor: ...
    def count(self) -> int: ...
    def horizontalSpacing(self) -> float: ...
    def invalidate(self) -> None: ...
    def itemAt(self, index: int) -> QGraphicsLayoutItem: ...
    def removeAt(self, index: int) -> None: ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setHorizontalSpacing(self, spacing: float) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def setVerticalSpacing(self, spacing: float) -> None: ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def verticalSpacing(self) -> float: ...

class QGraphicsBlurEffect(QGraphicsEffect):
    class BlurHint:
        AnimationHint: typing.ClassVar[QGraphicsBlurEffect.BlurHint] = ...
        PerformanceHint: typing.ClassVar[QGraphicsBlurEffect.BlurHint] = ...
        QualityHint: typing.ClassVar[QGraphicsBlurEffect.BlurHint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsBlurEffect.BlurHints: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGraphicsBlurEffect.BlurHints: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsBlurEffect.BlurHints: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsBlurEffect.BlurHints: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsBlurEffect.BlurHints: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsBlurEffect.BlurHints: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsBlurEffect.BlurHints: ...

    class BlurHints:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsBlurEffect.BlurHints: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGraphicsBlurEffect.BlurHints: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsBlurEffect.BlurHints: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsBlurEffect.BlurHints: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsBlurEffect.BlurHints: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsBlurEffect.BlurHints: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsBlurEffect.BlurHints: ...
    AnimationHint: typing.ClassVar[QGraphicsBlurEffect.BlurHint] = ...
    PerformanceHint: typing.ClassVar[QGraphicsBlurEffect.BlurHint] = ...
    QualityHint: typing.ClassVar[QGraphicsBlurEffect.BlurHint] = ...
    blurHintsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    blurRadiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., blurHints: typing.Union[QGraphicsBlurEffect.BlurHints,QGraphicsBlurEffect.BlurHint] = ..., blurHintsChanged: typing.Callable = ..., blurRadius: float = ..., blurRadiusChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def blurHints(self) -> typing.Union[QGraphicsBlurEffect.BlurHints,QGraphicsBlurEffect.BlurHint]: ...
    def blurRadius(self) -> float: ...
    def boundingRectFor(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def draw(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def setBlurHints(self, hints: typing.Union[QGraphicsBlurEffect.BlurHints,QGraphicsBlurEffect.BlurHint]) -> None: ...
    def setBlurRadius(self, blurRadius: float) -> None: ...

class QGraphicsColorizeEffect(QGraphicsEffect):
    colorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    strengthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., colorChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., strength: float = ..., strengthChanged: typing.Callable = ...) -> None: ...
    def color(self) -> PySide2.QtGui.QColor: ...
    def draw(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def setColor(self, c: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setStrength(self, strength: float) -> None: ...
    def strength(self) -> float: ...

class QGraphicsDropShadowEffect(QGraphicsEffect):
    blurRadiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    colorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    offsetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., blurRadius: float = ..., blurRadiusChanged: typing.Callable = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., colorChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., offset: PySide2.QtCore.QPointF = ..., offsetChanged: typing.Callable = ..., xOffset: float = ..., yOffset: float = ...) -> None: ...
    def blurRadius(self) -> float: ...
    def boundingRectFor(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def color(self) -> PySide2.QtGui.QColor: ...
    def draw(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def offset(self) -> PySide2.QtCore.QPointF: ...
    def setBlurRadius(self, blurRadius: float) -> None: ...
    def setColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def setOffset(self, dx: float, dy: float) -> None: ...
    @overload
    def setOffset(self, d: float) -> None: ...
    @overload
    def setOffset(self, ofs: PySide2.QtCore.QPointF) -> None: ...
    def setXOffset(self, dx: float) -> None: ...
    def setYOffset(self, dy: float) -> None: ...
    def xOffset(self) -> float: ...
    def yOffset(self) -> float: ...

class QGraphicsEffect(PySide2.QtCore.QObject):
    class ChangeFlag:
        SourceAttached: typing.ClassVar[QGraphicsEffect.ChangeFlag] = ...
        SourceBoundingRectChanged: typing.ClassVar[QGraphicsEffect.ChangeFlag] = ...
        SourceDetached: typing.ClassVar[QGraphicsEffect.ChangeFlag] = ...
        SourceInvalidated: typing.ClassVar[QGraphicsEffect.ChangeFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsEffect.ChangeFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGraphicsEffect.ChangeFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsEffect.ChangeFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsEffect.ChangeFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsEffect.ChangeFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsEffect.ChangeFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsEffect.ChangeFlags: ...

    class ChangeFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsEffect.ChangeFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGraphicsEffect.ChangeFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsEffect.ChangeFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsEffect.ChangeFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsEffect.ChangeFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsEffect.ChangeFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsEffect.ChangeFlags: ...

    class PixmapPadMode:
        NoPad: typing.ClassVar[QGraphicsEffect.PixmapPadMode] = ...
        PadToEffectiveBoundingRect: typing.ClassVar[QGraphicsEffect.PixmapPadMode] = ...
        PadToTransparentBorder: typing.ClassVar[QGraphicsEffect.PixmapPadMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGraphicsEffect.PixmapPadMode: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsEffect.PixmapPadMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGraphicsEffect.PixmapPadMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsEffect.PixmapPadMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGraphicsEffect.PixmapPadMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsEffect.PixmapPadMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGraphicsEffect.PixmapPadMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsEffect.PixmapPadMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGraphicsEffect.PixmapPadMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsEffect.PixmapPadMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QGraphicsEffect.PixmapPadMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsEffect.PixmapPadMode: ...
    NoPad: typing.ClassVar[QGraphicsEffect.PixmapPadMode] = ...
    PadToEffectiveBoundingRect: typing.ClassVar[QGraphicsEffect.PixmapPadMode] = ...
    PadToTransparentBorder: typing.ClassVar[QGraphicsEffect.PixmapPadMode] = ...
    SourceAttached: typing.ClassVar[QGraphicsEffect.ChangeFlag] = ...
    SourceBoundingRectChanged: typing.ClassVar[QGraphicsEffect.ChangeFlag] = ...
    SourceDetached: typing.ClassVar[QGraphicsEffect.ChangeFlag] = ...
    SourceInvalidated: typing.ClassVar[QGraphicsEffect.ChangeFlag] = ...
    enabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def boundingRectFor(self, sourceRect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def draw(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def drawSource(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, enable: bool) -> None: ...
    def sourceBoundingRect(self, system: PySide2.QtCore.Qt.CoordinateSystem = ...) -> PySide2.QtCore.QRectF: ...
    def sourceChanged(self, flags: typing.Union[QGraphicsEffect.ChangeFlags,QGraphicsEffect.ChangeFlag]) -> None: ...
    def sourceIsPixmap(self) -> bool: ...
    def sourcePixmap(self, system: PySide2.QtCore.Qt.CoordinateSystem = ..., offset: typing.Union[PySide2.QtCore.QPoint,None] = ..., mode: QGraphicsEffect.PixmapPadMode = ...) -> PySide2.QtGui.QPixmap: ...
    def update(self) -> None: ...
    def updateBoundingRect(self) -> None: ...

class QGraphicsEllipseItem(QAbstractGraphicsShapeItem):
    @overload
    def __init__(self, x: float, y: float, w: float, h: float, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    @overload
    def __init__(self, rect: PySide2.QtCore.QRectF, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Union[QWidget,None] = ...) -> None: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    @overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...
    @overload
    def setRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setSpanAngle(self, angle: int) -> None: ...
    def setStartAngle(self, angle: int) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def spanAngle(self) -> int: ...
    def startAngle(self) -> int: ...
    def type(self) -> int: ...

class QGraphicsGridLayout(QGraphicsLayout):
    def __init__(self, parent: typing.Union[QGraphicsLayoutItem,None] = ...) -> None: ...
    @overload
    def addItem(self, item: QGraphicsLayoutItem, row: int, column: int, rowSpan: int, columnSpan: int, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    @overload
    def addItem(self, item: QGraphicsLayoutItem, row: int, column: int, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    def alignment(self, item: QGraphicsLayoutItem) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def columnAlignment(self, column: int) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def columnCount(self) -> int: ...
    def columnMaximumWidth(self, column: int) -> float: ...
    def columnMinimumWidth(self, column: int) -> float: ...
    def columnPreferredWidth(self, column: int) -> float: ...
    def columnSpacing(self, column: int) -> float: ...
    def columnStretchFactor(self, column: int) -> int: ...
    def count(self) -> int: ...
    def horizontalSpacing(self) -> float: ...
    def invalidate(self) -> None: ...
    @overload
    def itemAt(self, row: int, column: int) -> QGraphicsLayoutItem: ...
    @overload
    def itemAt(self, index: int) -> QGraphicsLayoutItem: ...
    def removeAt(self, index: int) -> None: ...
    def removeItem(self, item: QGraphicsLayoutItem) -> None: ...
    def rowAlignment(self, row: int) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def rowCount(self) -> int: ...
    def rowMaximumHeight(self, row: int) -> float: ...
    def rowMinimumHeight(self, row: int) -> float: ...
    def rowPreferredHeight(self, row: int) -> float: ...
    def rowSpacing(self, row: int) -> float: ...
    def rowStretchFactor(self, row: int) -> int: ...
    def setAlignment(self, item: QGraphicsLayoutItem, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setColumnAlignment(self, column: int, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setColumnFixedWidth(self, column: int, width: float) -> None: ...
    def setColumnMaximumWidth(self, column: int, width: float) -> None: ...
    def setColumnMinimumWidth(self, column: int, width: float) -> None: ...
    def setColumnPreferredWidth(self, column: int, width: float) -> None: ...
    def setColumnSpacing(self, column: int, spacing: float) -> None: ...
    def setColumnStretchFactor(self, column: int, stretch: int) -> None: ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setHorizontalSpacing(self, spacing: float) -> None: ...
    def setRowAlignment(self, row: int, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setRowFixedHeight(self, row: int, height: float) -> None: ...
    def setRowMaximumHeight(self, row: int, height: float) -> None: ...
    def setRowMinimumHeight(self, row: int, height: float) -> None: ...
    def setRowPreferredHeight(self, row: int, height: float) -> None: ...
    def setRowSpacing(self, row: int, spacing: float) -> None: ...
    def setRowStretchFactor(self, row: int, stretch: int) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def setVerticalSpacing(self, spacing: float) -> None: ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def verticalSpacing(self) -> float: ...

class QGraphicsItem(shiboken2.Object):
    class CacheMode:
        DeviceCoordinateCache: typing.ClassVar[QGraphicsItem.CacheMode] = ...
        ItemCoordinateCache: typing.ClassVar[QGraphicsItem.CacheMode] = ...
        NoCache: typing.ClassVar[QGraphicsItem.CacheMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGraphicsItem.CacheMode: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsItem.CacheMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGraphicsItem.CacheMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsItem.CacheMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGraphicsItem.CacheMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsItem.CacheMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGraphicsItem.CacheMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsItem.CacheMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGraphicsItem.CacheMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsItem.CacheMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QGraphicsItem.CacheMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsItem.CacheMode: ...

    class Extension:
        UserExtension: typing.ClassVar[QGraphicsItem.Extension] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGraphicsItem.Extension: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsItem.Extension: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGraphicsItem.Extension: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsItem.Extension: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGraphicsItem.Extension: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsItem.Extension: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGraphicsItem.Extension: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsItem.Extension: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGraphicsItem.Extension: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsItem.Extension: ...
        def __sub__(self, other: typing.SupportsInt) -> QGraphicsItem.Extension: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsItem.Extension: ...

    class GraphicsItemChange:
        ItemChildAddedChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemChildRemovedChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemCursorChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemCursorHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemEnabledChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemEnabledHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemFlagsChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemFlagsHaveChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemMatrixChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemOpacityChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemOpacityHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemParentChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemParentHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemPositionChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemPositionHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemRotationChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemRotationHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemScaleChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemScaleHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemSceneChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemSceneHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemScenePositionHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemSelectedChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemSelectedHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemToolTipChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemToolTipHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemTransformChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemTransformHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemTransformOriginPointChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemTransformOriginPointHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemVisibleChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemVisibleHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemZValueChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        ItemZValueHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemChange: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemChange: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemChange: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemChange: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemChange: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemChange: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemChange: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemChange: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemChange: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemChange: ...
        def __sub__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemChange: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemChange: ...

    class GraphicsItemFlag:
        ItemAcceptsInputMethod: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemClipsChildrenToShape: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemClipsToShape: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemContainsChildrenInShape: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemDoesntPropagateOpacityToChildren: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemHasNoContents: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemIgnoresParentOpacity: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemIgnoresTransformations: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemIsFocusScope: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemIsFocusable: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemIsMovable: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemIsPanel: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemIsSelectable: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemNegativeZStacksBehindParent: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemSendsGeometryChanges: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemSendsScenePositionChanges: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemStacksBehindParent: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemStopsClickFocusPropagation: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemStopsFocusHandling: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        ItemUsesExtendedStyleOption: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGraphicsItem.GraphicsItemFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemFlags: ...

    class GraphicsItemFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGraphicsItem.GraphicsItemFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsItem.GraphicsItemFlags: ...

    class PanelModality:
        NonModal: typing.ClassVar[QGraphicsItem.PanelModality] = ...
        PanelModal: typing.ClassVar[QGraphicsItem.PanelModality] = ...
        SceneModal: typing.ClassVar[QGraphicsItem.PanelModality] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGraphicsItem.PanelModality: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsItem.PanelModality: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGraphicsItem.PanelModality: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsItem.PanelModality: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGraphicsItem.PanelModality: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsItem.PanelModality: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGraphicsItem.PanelModality: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsItem.PanelModality: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGraphicsItem.PanelModality: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsItem.PanelModality: ...
        def __sub__(self, other: typing.SupportsInt) -> QGraphicsItem.PanelModality: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsItem.PanelModality: ...
    DeviceCoordinateCache: typing.ClassVar[QGraphicsItem.CacheMode] = ...
    ItemAcceptsInputMethod: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemChildAddedChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemChildRemovedChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemClipsChildrenToShape: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemClipsToShape: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemContainsChildrenInShape: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemCoordinateCache: typing.ClassVar[QGraphicsItem.CacheMode] = ...
    ItemCursorChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemCursorHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemDoesntPropagateOpacityToChildren: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemEnabledChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemEnabledHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemFlagsChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemFlagsHaveChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemHasNoContents: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemIgnoresParentOpacity: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemIgnoresTransformations: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemIsFocusScope: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemIsFocusable: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemIsMovable: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemIsPanel: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemIsSelectable: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemMatrixChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemNegativeZStacksBehindParent: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemOpacityChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemOpacityHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemParentChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemParentHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemPositionChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemPositionHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemRotationChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemRotationHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemScaleChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemScaleHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemSceneChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemSceneHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemScenePositionHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemSelectedChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemSelectedHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemSendsGeometryChanges: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemSendsScenePositionChanges: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemStacksBehindParent: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemStopsClickFocusPropagation: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemStopsFocusHandling: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemToolTipChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemToolTipHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemTransformChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemTransformHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemTransformOriginPointChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemTransformOriginPointHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemUsesExtendedStyleOption: typing.ClassVar[QGraphicsItem.GraphicsItemFlag] = ...
    ItemVisibleChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemVisibleHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemZValueChange: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    ItemZValueHasChanged: typing.ClassVar[QGraphicsItem.GraphicsItemChange] = ...
    NoCache: typing.ClassVar[QGraphicsItem.CacheMode] = ...
    NonModal: typing.ClassVar[QGraphicsItem.PanelModality] = ...
    PanelModal: typing.ClassVar[QGraphicsItem.PanelModality] = ...
    SceneModal: typing.ClassVar[QGraphicsItem.PanelModality] = ...
    UserExtension: typing.ClassVar[QGraphicsItem.Extension] = ...
    UserType: typing.ClassVar[int] = ...
    def __init__(self, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    def acceptDrops(self) -> bool: ...
    def acceptHoverEvents(self) -> bool: ...
    def acceptTouchEvents(self) -> bool: ...
    def acceptedMouseButtons(self) -> typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton]: ...
    def addToIndex(self) -> None: ...
    def advance(self, phase: int) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def boundingRegion(self, itemToDeviceTransform: PySide2.QtGui.QTransform) -> PySide2.QtGui.QRegion: ...
    def boundingRegionGranularity(self) -> float: ...
    def cacheMode(self) -> QGraphicsItem.CacheMode: ...
    def childItems(self) -> typing.List[QGraphicsItem]: ...
    def childrenBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def clearFocus(self) -> None: ...
    def clipPath(self) -> PySide2.QtGui.QPainterPath: ...
    def collidesWithItem(self, other: QGraphicsItem, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> bool: ...
    def collidesWithPath(self, path: PySide2.QtGui.QPainterPath, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> bool: ...
    def collidingItems(self, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    def commonAncestorItem(self, other: QGraphicsItem) -> QGraphicsItem: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def contextMenuEvent(self, event: QGraphicsSceneContextMenuEvent) -> None: ...
    def cursor(self) -> PySide2.QtGui.QCursor: ...
    def data(self, key: int) -> typing.Any: ...
    def deviceTransform(self, viewportTransform: PySide2.QtGui.QTransform) -> PySide2.QtGui.QTransform: ...
    def dragEnterEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dropEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def effectiveOpacity(self) -> float: ...
    @overload
    def ensureVisible(self, x: float, y: float, w: float, h: float, xmargin: int = ..., ymargin: int = ...) -> None: ...
    @overload
    def ensureVisible(self, rect: PySide2.QtCore.QRectF = ..., xmargin: int = ..., ymargin: int = ...) -> None: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def filtersChildEvents(self) -> bool: ...
    def flags(self) -> typing.Union[QGraphicsItem.GraphicsItemFlags,QGraphicsItem.GraphicsItemFlag]: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusItem(self) -> QGraphicsItem: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusProxy(self) -> QGraphicsItem: ...
    def focusScopeItem(self) -> QGraphicsItem: ...
    def grabKeyboard(self) -> None: ...
    def grabMouse(self) -> None: ...
    def graphicsEffect(self) -> QGraphicsEffect: ...
    def group(self) -> QGraphicsItemGroup: ...
    def handlesChildEvents(self) -> bool: ...
    def hasCursor(self) -> bool: ...
    def hasFocus(self) -> bool: ...
    def hide(self) -> None: ...
    def hoverEnterEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodHints(self) -> typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint]: ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def installSceneEventFilter(self, filterItem: QGraphicsItem) -> None: ...
    def isActive(self) -> bool: ...
    def isAncestorOf(self, child: QGraphicsItem) -> bool: ...
    def isBlockedByModalPanel(self, blockingPanel: typing.Union[QGraphicsItem,None] = ...) -> bool: ...
    def isClipped(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    @overload
    def isObscured(self, x: float, y: float, w: float, h: float) -> bool: ...
    @overload
    def isObscured(self, rect: PySide2.QtCore.QRectF = ...) -> bool: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def isPanel(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def isUnderMouse(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def isVisibleTo(self, parent: QGraphicsItem) -> bool: ...
    def isWidget(self) -> bool: ...
    def isWindow(self) -> bool: ...
    def itemChange(self, change: QGraphicsItem.GraphicsItemChange, value: typing.Any) -> typing.Any: ...
    def itemTransform(self, other: QGraphicsItem) -> typing.Tuple[PySide2.QtGui.QTransform,bool]: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    @overload
    def mapFromItem(self, item: QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapFromItem(self, item: QGraphicsItem, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @overload
    def mapFromItem(self, item: QGraphicsItem, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @overload
    def mapFromItem(self, item: QGraphicsItem, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @overload
    def mapFromItem(self, item: QGraphicsItem, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapFromItem(self, item: QGraphicsItem, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapFromParent(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapFromParent(self, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @overload
    def mapFromParent(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @overload
    def mapFromParent(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @overload
    def mapFromParent(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapFromParent(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapFromScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapFromScene(self, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @overload
    def mapFromScene(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @overload
    def mapFromScene(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @overload
    def mapFromScene(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapFromScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapRectFromItem(self, item: QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @overload
    def mapRectFromItem(self, item: QGraphicsItem, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @overload
    def mapRectFromParent(self, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @overload
    def mapRectFromParent(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @overload
    def mapRectFromScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @overload
    def mapRectFromScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @overload
    def mapRectToItem(self, item: QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @overload
    def mapRectToItem(self, item: QGraphicsItem, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @overload
    def mapRectToParent(self, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @overload
    def mapRectToParent(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @overload
    def mapRectToScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @overload
    def mapRectToScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @overload
    def mapToItem(self, item: QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapToItem(self, item: QGraphicsItem, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @overload
    def mapToItem(self, item: QGraphicsItem, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @overload
    def mapToItem(self, item: QGraphicsItem, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @overload
    def mapToItem(self, item: QGraphicsItem, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapToItem(self, item: QGraphicsItem, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapToParent(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapToParent(self, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @overload
    def mapToParent(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @overload
    def mapToParent(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @overload
    def mapToParent(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapToParent(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @overload
    def mapToScene(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @overload
    def mapToScene(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @overload
    def mapToScene(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    def matrix(self) -> PySide2.QtGui.QMatrix: ...
    def mouseDoubleClickEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def moveBy(self, dx: float, dy: float) -> None: ...
    def opacity(self) -> float: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Union[QWidget,None] = ...) -> None: ...
    def panel(self) -> QGraphicsItem: ...
    def panelModality(self) -> QGraphicsItem.PanelModality: ...
    def parentItem(self) -> QGraphicsItem: ...
    def parentObject(self) -> QGraphicsObject: ...
    def parentWidget(self) -> QGraphicsWidget: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def prepareGeometryChange(self) -> None: ...
    def removeFromIndex(self) -> None: ...
    def removeSceneEventFilter(self, filterItem: QGraphicsItem) -> None: ...
    def resetMatrix(self) -> None: ...
    def resetTransform(self) -> None: ...
    def rotation(self) -> float: ...
    def scale(self) -> float: ...
    def scene(self) -> QGraphicsScene: ...
    def sceneBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def sceneEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def sceneEventFilter(self, watched: QGraphicsItem, event: PySide2.QtCore.QEvent) -> bool: ...
    def sceneMatrix(self) -> PySide2.QtGui.QMatrix: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def sceneTransform(self) -> PySide2.QtGui.QTransform: ...
    def scroll(self, dx: float, dy: float, rect: PySide2.QtCore.QRectF = ...) -> None: ...
    def setAcceptDrops(self, on: bool) -> None: ...
    def setAcceptHoverEvents(self, enabled: bool) -> None: ...
    def setAcceptTouchEvents(self, enabled: bool) -> None: ...
    def setAcceptedMouseButtons(self, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton]) -> None: ...
    def setActive(self, active: bool) -> None: ...
    def setBoundingRegionGranularity(self, granularity: float) -> None: ...
    def setCacheMode(self, mode: QGraphicsItem.CacheMode, cacheSize: PySide2.QtCore.QSize = ...) -> None: ...
    def setCursor(self, cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape]) -> None: ...
    def setData(self, key: int, value: typing.Any) -> None: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def setFiltersChildEvents(self, enabled: bool) -> None: ...
    def setFlag(self, flag: QGraphicsItem.GraphicsItemFlag, enabled: bool = ...) -> None: ...
    def setFlags(self, flags: typing.Union[QGraphicsItem.GraphicsItemFlags,QGraphicsItem.GraphicsItemFlag]) -> None: ...
    def setFocus(self, focusReason: PySide2.QtCore.Qt.FocusReason = ...) -> None: ...
    def setFocusProxy(self, item: QGraphicsItem) -> None: ...
    def setGraphicsEffect(self, effect: QGraphicsEffect) -> None: ...
    def setGroup(self, group: QGraphicsItemGroup) -> None: ...
    def setHandlesChildEvents(self, enabled: bool) -> None: ...
    def setInputMethodHints(self, hints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint]) -> None: ...
    def setMatrix(self, matrix: PySide2.QtGui.QMatrix, combine: bool = ...) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    def setPanelModality(self, panelModality: QGraphicsItem.PanelModality) -> None: ...
    def setParentItem(self, parent: QGraphicsItem) -> None: ...
    @overload
    def setPos(self, x: float, y: float) -> None: ...
    @overload
    def setPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setRotation(self, angle: float) -> None: ...
    def setScale(self, scale: float) -> None: ...
    def setSelected(self, selected: bool) -> None: ...
    def setToolTip(self, toolTip: str) -> None: ...
    def setTransform(self, matrix: PySide2.QtGui.QTransform, combine: bool = ...) -> None: ...
    @overload
    def setTransformOriginPoint(self, ax: float, ay: float) -> None: ...
    @overload
    def setTransformOriginPoint(self, origin: PySide2.QtCore.QPointF) -> None: ...
    def setTransformations(self, transformations: typing.Iterable[QGraphicsTransform]) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZValue(self, z: float) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def show(self) -> None: ...
    def stackBefore(self, sibling: QGraphicsItem) -> None: ...
    def toGraphicsObject(self) -> QGraphicsObject: ...
    def toolTip(self) -> str: ...
    def topLevelItem(self) -> QGraphicsItem: ...
    def topLevelWidget(self) -> QGraphicsWidget: ...
    def transform(self) -> PySide2.QtGui.QTransform: ...
    def transformOriginPoint(self) -> PySide2.QtCore.QPointF: ...
    def transformations(self) -> typing.List[QGraphicsTransform]: ...
    def type(self) -> int: ...
    def ungrabKeyboard(self) -> None: ...
    def ungrabMouse(self) -> None: ...
    def unsetCursor(self) -> None: ...
    @overload
    def update(self, x: float, y: float, width: float, height: float) -> None: ...
    @overload
    def update(self, rect: PySide2.QtCore.QRectF = ...) -> None: ...
    def updateMicroFocus(self) -> None: ...
    def wheelEvent(self, event: QGraphicsSceneWheelEvent) -> None: ...
    def window(self) -> QGraphicsWidget: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def zValue(self) -> float: ...

class QGraphicsItemAnimation(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def afterAnimationStep(self, step: float) -> None: ...
    def beforeAnimationStep(self, step: float) -> None: ...
    def clear(self) -> None: ...
    def horizontalScaleAt(self, step: float) -> float: ...
    def horizontalShearAt(self, step: float) -> float: ...
    def item(self) -> QGraphicsItem: ...
    def matrixAt(self, step: float) -> PySide2.QtGui.QMatrix: ...
    def posAt(self, step: float) -> PySide2.QtCore.QPointF: ...
    def posList(self) -> typing.List[typing.Tuple[float,PySide2.QtCore.QPointF]]: ...
    def reset(self) -> None: ...
    def rotationAt(self, step: float) -> float: ...
    def rotationList(self) -> typing.List[typing.Tuple[float,float]]: ...
    def scaleList(self) -> typing.List[typing.Tuple[float,PySide2.QtCore.QPointF]]: ...
    def setItem(self, item: QGraphicsItem) -> None: ...
    def setPosAt(self, step: float, pos: PySide2.QtCore.QPointF) -> None: ...
    def setRotationAt(self, step: float, angle: float) -> None: ...
    def setScaleAt(self, step: float, sx: float, sy: float) -> None: ...
    def setShearAt(self, step: float, sh: float, sv: float) -> None: ...
    def setStep(self, x: float) -> None: ...
    def setTimeLine(self, timeLine: PySide2.QtCore.QTimeLine) -> None: ...
    def setTranslationAt(self, step: float, dx: float, dy: float) -> None: ...
    def shearList(self) -> typing.List[typing.Tuple[float,PySide2.QtCore.QPointF]]: ...
    def timeLine(self) -> PySide2.QtCore.QTimeLine: ...
    def transformAt(self, step: float) -> PySide2.QtGui.QTransform: ...
    def translationList(self) -> typing.List[typing.Tuple[float,PySide2.QtCore.QPointF]]: ...
    def verticalScaleAt(self, step: float) -> float: ...
    def verticalShearAt(self, step: float) -> float: ...
    def xTranslationAt(self, step: float) -> float: ...
    def yTranslationAt(self, step: float) -> float: ...

class QGraphicsItemGroup(QGraphicsItem):
    def __init__(self, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    def addToGroup(self, item: QGraphicsItem) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Union[QWidget,None] = ...) -> None: ...
    def removeFromGroup(self, item: QGraphicsItem) -> None: ...
    def type(self) -> int: ...

class QGraphicsLayout(QGraphicsLayoutItem):
    def __init__(self, parent: typing.Union[QGraphicsLayoutItem,None] = ...) -> None: ...
    def activate(self) -> None: ...
    def addChildLayoutItem(self, layoutItem: QGraphicsLayoutItem) -> None: ...
    def count(self) -> int: ...
    def getContentsMargins(self) -> typing.Tuple[float,float,float,float]: ...
    @classmethod
    def instantInvalidatePropagation(cls) -> bool: ...
    def invalidate(self) -> None: ...
    def isActivated(self) -> bool: ...
    def itemAt(self, i: int) -> QGraphicsLayoutItem: ...
    def removeAt(self, index: int) -> None: ...
    def setContentsMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...
    @classmethod
    def setInstantInvalidatePropagation(cls, enable: bool) -> None: ...
    def updateGeometry(self) -> None: ...
    def widgetEvent(self, e: PySide2.QtCore.QEvent) -> None: ...

class QGraphicsLayoutItem(shiboken2.Object):
    def __init__(self, parent: typing.Union[QGraphicsLayoutItem,None] = ..., isLayout: bool = ...) -> None: ...
    def contentsRect(self) -> PySide2.QtCore.QRectF: ...
    def effectiveSizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def geometry(self) -> PySide2.QtCore.QRectF: ...
    def getContentsMargins(self) -> typing.Tuple[float,float,float,float]: ...
    def graphicsItem(self) -> QGraphicsItem: ...
    def isLayout(self) -> bool: ...
    def maximumHeight(self) -> float: ...
    def maximumSize(self) -> PySide2.QtCore.QSizeF: ...
    def maximumWidth(self) -> float: ...
    def minimumHeight(self) -> float: ...
    def minimumSize(self) -> PySide2.QtCore.QSizeF: ...
    def minimumWidth(self) -> float: ...
    def ownedByLayout(self) -> bool: ...
    def parentLayoutItem(self) -> QGraphicsLayoutItem: ...
    def preferredHeight(self) -> float: ...
    def preferredSize(self) -> PySide2.QtCore.QSizeF: ...
    def preferredWidth(self) -> float: ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setGraphicsItem(self, item: QGraphicsItem) -> None: ...
    def setMaximumHeight(self, height: float) -> None: ...
    @overload
    def setMaximumSize(self, w: float, h: float) -> None: ...
    @overload
    def setMaximumSize(self, size: PySide2.QtCore.QSizeF) -> None: ...
    def setMaximumWidth(self, width: float) -> None: ...
    def setMinimumHeight(self, height: float) -> None: ...
    @overload
    def setMinimumSize(self, w: float, h: float) -> None: ...
    @overload
    def setMinimumSize(self, size: PySide2.QtCore.QSizeF) -> None: ...
    def setMinimumWidth(self, width: float) -> None: ...
    def setOwnedByLayout(self, ownedByLayout: bool) -> None: ...
    def setParentLayoutItem(self, parent: QGraphicsLayoutItem) -> None: ...
    def setPreferredHeight(self, height: float) -> None: ...
    @overload
    def setPreferredSize(self, w: float, h: float) -> None: ...
    @overload
    def setPreferredSize(self, size: PySide2.QtCore.QSizeF) -> None: ...
    def setPreferredWidth(self, width: float) -> None: ...
    @overload
    def setSizePolicy(self, hPolicy: QSizePolicy.Policy, vPolicy: QSizePolicy.Policy, controlType: QSizePolicy.ControlType = ...) -> None: ...
    @overload
    def setSizePolicy(self, policy: QSizePolicy) -> None: ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def sizePolicy(self) -> QSizePolicy: ...
    def updateGeometry(self) -> None: ...

class QGraphicsLineItem(QGraphicsItem):
    @overload
    def __init__(self, x1: float, y1: float, x2: float, y2: float, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    @overload
    def __init__(self, line: PySide2.QtCore.QLineF, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def line(self) -> PySide2.QtCore.QLineF: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Union[QWidget,None] = ...) -> None: ...
    def pen(self) -> PySide2.QtGui.QPen: ...
    @overload
    def setLine(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    @overload
    def setLine(self, line: PySide2.QtCore.QLineF) -> None: ...
    def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...

class QGraphicsLinearLayout(QGraphicsLayout):
    @overload
    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Union[QGraphicsLayoutItem,None] = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QGraphicsLayoutItem,None] = ...) -> None: ...
    def addItem(self, item: QGraphicsLayoutItem) -> None: ...
    def addStretch(self, stretch: int = ...) -> None: ...
    def alignment(self, item: QGraphicsLayoutItem) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def count(self) -> int: ...
    def dump(self, indent: int = ...) -> None: ...
    def insertItem(self, index: int, item: QGraphicsLayoutItem) -> None: ...
    def insertStretch(self, index: int, stretch: int = ...) -> None: ...
    def invalidate(self) -> None: ...
    def itemAt(self, index: int) -> QGraphicsLayoutItem: ...
    def itemSpacing(self, index: int) -> float: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def removeAt(self, index: int) -> None: ...
    def removeItem(self, item: QGraphicsLayoutItem) -> None: ...
    def setAlignment(self, item: QGraphicsLayoutItem, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setItemSpacing(self, index: int, spacing: float) -> None: ...
    def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def setStretchFactor(self, item: QGraphicsLayoutItem, stretch: int) -> None: ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def spacing(self) -> float: ...
    def stretchFactor(self, item: QGraphicsLayoutItem) -> int: ...

class QGraphicsObject(QGraphicsItem, PySide2.QtCore.QObject):
    childrenChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    enabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    heightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    opacityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    parentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    rotationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    scaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    visibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    widthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    xChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    yChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    zChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    def event(self, ev: PySide2.QtCore.QEvent) -> bool: ...
    def grabGesture(self, type: PySide2.QtCore.Qt.GestureType, flags: typing.Union[PySide2.QtCore.Qt.GestureFlags,PySide2.QtCore.Qt.GestureFlag] = ...) -> None: ...
    def ungrabGesture(self, type: PySide2.QtCore.Qt.GestureType) -> None: ...
    def updateMicroFocus(self) -> None: ...

class QGraphicsOpacityEffect(QGraphicsEffect):
    opacityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    opacityMaskChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., opacityMask: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., opacityMaskChanged: typing.Callable = ...) -> None: ...
    def draw(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def opacity(self) -> float: ...
    def opacityMask(self) -> PySide2.QtGui.QBrush: ...
    def setOpacity(self, opacity: float) -> None: ...
    def setOpacityMask(self, mask: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...

class QGraphicsPathItem(QAbstractGraphicsShapeItem):
    @overload
    def __init__(self, path: PySide2.QtGui.QPainterPath, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Union[QWidget,None] = ...) -> None: ...
    def path(self) -> PySide2.QtGui.QPainterPath: ...
    def setPath(self, path: PySide2.QtGui.QPainterPath) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...

class QGraphicsPixmapItem(QGraphicsItem):
    class ShapeMode:
        BoundingRectShape: typing.ClassVar[QGraphicsPixmapItem.ShapeMode] = ...
        HeuristicMaskShape: typing.ClassVar[QGraphicsPixmapItem.ShapeMode] = ...
        MaskShape: typing.ClassVar[QGraphicsPixmapItem.ShapeMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGraphicsPixmapItem.ShapeMode: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsPixmapItem.ShapeMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGraphicsPixmapItem.ShapeMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsPixmapItem.ShapeMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGraphicsPixmapItem.ShapeMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsPixmapItem.ShapeMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGraphicsPixmapItem.ShapeMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsPixmapItem.ShapeMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGraphicsPixmapItem.ShapeMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsPixmapItem.ShapeMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QGraphicsPixmapItem.ShapeMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsPixmapItem.ShapeMode: ...
    BoundingRectShape: typing.ClassVar[QGraphicsPixmapItem.ShapeMode] = ...
    HeuristicMaskShape: typing.ClassVar[QGraphicsPixmapItem.ShapeMode] = ...
    MaskShape: typing.ClassVar[QGraphicsPixmapItem.ShapeMode] = ...
    @overload
    def __init__(self, pixmap: PySide2.QtGui.QPixmap, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def offset(self) -> PySide2.QtCore.QPointF: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: QWidget) -> None: ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    @overload
    def setOffset(self, x: float, y: float) -> None: ...
    @overload
    def setOffset(self, offset: PySide2.QtCore.QPointF) -> None: ...
    def setPixmap(self, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    def setShapeMode(self, mode: QGraphicsPixmapItem.ShapeMode) -> None: ...
    def setTransformationMode(self, mode: PySide2.QtCore.Qt.TransformationMode) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def shapeMode(self) -> QGraphicsPixmapItem.ShapeMode: ...
    def transformationMode(self) -> PySide2.QtCore.Qt.TransformationMode: ...
    def type(self) -> int: ...

class QGraphicsPolygonItem(QAbstractGraphicsShapeItem):
    @overload
    def __init__(self, polygon: PySide2.QtGui.QPolygonF, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def fillRule(self) -> PySide2.QtCore.Qt.FillRule: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Union[QWidget,None] = ...) -> None: ...
    def polygon(self) -> PySide2.QtGui.QPolygonF: ...
    def setFillRule(self, rule: PySide2.QtCore.Qt.FillRule) -> None: ...
    def setPolygon(self, polygon: PySide2.QtGui.QPolygonF) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...

class QGraphicsProxyWidget(QGraphicsWidget):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QGraphicsItem,None] = ..., wFlags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., autoFillBackground: bool = ..., children: typing.Any = ..., childrenChanged: typing.Callable = ..., destroyed: typing.Callable = ..., effect: typing.Any = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., geometry: PySide2.QtCore.QRectF = ..., geometryChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., layout: typing.Any = ..., layoutChanged: typing.Callable = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., maximumSize: PySide2.QtCore.QSizeF = ..., minimumSize: PySide2.QtCore.QSizeF = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., parentChanged: typing.Callable = ..., pos: PySide2.QtCore.QPointF = ..., preferredSize: PySide2.QtCore.QSizeF = ..., rotation: float = ..., rotationChanged: typing.Callable = ..., scale: float = ..., scaleChanged: typing.Callable = ..., size: PySide2.QtCore.QSizeF = ..., sizePolicy: QSizePolicy = ..., transformOriginPoint: PySide2.QtCore.QPointF = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: float = ..., widthChanged: typing.Callable = ..., windowFlags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., windowTitle: str = ..., x: float = ..., xChanged: typing.Callable = ..., y: float = ..., yChanged: typing.Callable = ..., z: float = ..., zChanged: typing.Callable = ...) -> None: ...
    def contextMenuEvent(self, event: QGraphicsSceneContextMenuEvent) -> None: ...
    def createProxyForChildWidget(self, child: QWidget) -> QGraphicsProxyWidget: ...
    def dragEnterEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dropEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def grabMouseEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def hideEvent(self, event: PySide2.QtGui.QHideEvent) -> None: ...
    def hoverEnterEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def itemChange(self, change: QGraphicsItem.GraphicsItemChange, value: typing.Any) -> typing.Any: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def newProxyWidget(self, arg__1: QWidget) -> QGraphicsProxyWidget: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: QWidget) -> None: ...
    def resizeEvent(self, event: QGraphicsSceneResizeEvent) -> None: ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setWidget(self, widget: QWidget) -> None: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def subWidgetRect(self, widget: QWidget) -> PySide2.QtCore.QRectF: ...
    def type(self) -> int: ...
    def ungrabMouseEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def wheelEvent(self, event: QGraphicsSceneWheelEvent) -> None: ...
    def widget(self) -> QWidget: ...

class QGraphicsRectItem(QAbstractGraphicsShapeItem):
    @overload
    def __init__(self, x: float, y: float, w: float, h: float, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    @overload
    def __init__(self, rect: PySide2.QtCore.QRectF, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Union[QWidget,None] = ...) -> None: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    @overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...
    @overload
    def setRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...

class QGraphicsRotation(QGraphicsTransform):
    angleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    axisChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    originChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., angle: float = ..., angleChanged: typing.Callable = ..., axis: PySide2.QtGui.QVector3D = ..., axisChanged: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., origin: PySide2.QtGui.QVector3D = ..., originChanged: typing.Callable = ...) -> None: ...
    def angle(self) -> float: ...
    def applyTo(self, matrix: PySide2.QtGui.QMatrix4x4) -> None: ...
    def axis(self) -> PySide2.QtGui.QVector3D: ...
    def origin(self) -> PySide2.QtGui.QVector3D: ...
    def setAngle(self, arg__1: float) -> None: ...
    @overload
    def setAxis(self, axis: PySide2.QtCore.Qt.Axis) -> None: ...
    @overload
    def setAxis(self, axis: PySide2.QtGui.QVector3D) -> None: ...
    def setOrigin(self, point: PySide2.QtGui.QVector3D) -> None: ...

class QGraphicsScale(QGraphicsTransform):
    originChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    scaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    xScaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    yScaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    zScaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., origin: PySide2.QtGui.QVector3D = ..., originChanged: typing.Callable = ..., scaleChanged: typing.Callable = ..., xScale: float = ..., xScaleChanged: typing.Callable = ..., yScale: float = ..., yScaleChanged: typing.Callable = ..., zScale: float = ..., zScaleChanged: typing.Callable = ...) -> None: ...
    def applyTo(self, matrix: PySide2.QtGui.QMatrix4x4) -> None: ...
    def origin(self) -> PySide2.QtGui.QVector3D: ...
    def setOrigin(self, point: PySide2.QtGui.QVector3D) -> None: ...
    def setXScale(self, arg__1: float) -> None: ...
    def setYScale(self, arg__1: float) -> None: ...
    def setZScale(self, arg__1: float) -> None: ...
    def xScale(self) -> float: ...
    def yScale(self) -> float: ...
    def zScale(self) -> float: ...

class QGraphicsScene(PySide2.QtCore.QObject):
    class ItemIndexMethod:
        BspTreeIndex: typing.ClassVar[QGraphicsScene.ItemIndexMethod] = ...
        NoIndex: typing.ClassVar[QGraphicsScene.ItemIndexMethod] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGraphicsScene.ItemIndexMethod: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsScene.ItemIndexMethod: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGraphicsScene.ItemIndexMethod: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsScene.ItemIndexMethod: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGraphicsScene.ItemIndexMethod: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsScene.ItemIndexMethod: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGraphicsScene.ItemIndexMethod: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsScene.ItemIndexMethod: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGraphicsScene.ItemIndexMethod: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsScene.ItemIndexMethod: ...
        def __sub__(self, other: typing.SupportsInt) -> QGraphicsScene.ItemIndexMethod: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsScene.ItemIndexMethod: ...

    class SceneLayer:
        AllLayers: typing.ClassVar[QGraphicsScene.SceneLayer] = ...
        BackgroundLayer: typing.ClassVar[QGraphicsScene.SceneLayer] = ...
        ForegroundLayer: typing.ClassVar[QGraphicsScene.SceneLayer] = ...
        ItemLayer: typing.ClassVar[QGraphicsScene.SceneLayer] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsScene.SceneLayers: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGraphicsScene.SceneLayers: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsScene.SceneLayers: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsScene.SceneLayers: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsScene.SceneLayers: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsScene.SceneLayers: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsScene.SceneLayers: ...

    class SceneLayers:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsScene.SceneLayers: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGraphicsScene.SceneLayers: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsScene.SceneLayers: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsScene.SceneLayers: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsScene.SceneLayers: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsScene.SceneLayers: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsScene.SceneLayers: ...
    AllLayers: typing.ClassVar[QGraphicsScene.SceneLayer] = ...
    BackgroundLayer: typing.ClassVar[QGraphicsScene.SceneLayer] = ...
    BspTreeIndex: typing.ClassVar[QGraphicsScene.ItemIndexMethod] = ...
    ForegroundLayer: typing.ClassVar[QGraphicsScene.SceneLayer] = ...
    ItemLayer: typing.ClassVar[QGraphicsScene.SceneLayer] = ...
    NoIndex: typing.ClassVar[QGraphicsScene.ItemIndexMethod] = ...
    changed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    focusItemChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sceneRectChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    selectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, x: float, y: float, width: float, height: float, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., backgroundBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., bspTreeDepth: int = ..., changed: typing.Callable = ..., destroyed: typing.Callable = ..., focusItemChanged: typing.Callable = ..., focusOnTouch: bool = ..., font: PySide2.QtGui.QFont = ..., foregroundBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., itemIndexMethod: QGraphicsScene.ItemIndexMethod = ..., minimumRenderSize: float = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., sceneRect: PySide2.QtCore.QRectF = ..., sceneRectChanged: typing.Callable = ..., selectionChanged: typing.Callable = ..., sortCacheEnabled: bool = ..., stickyFocus: bool = ...) -> None: ...
    @overload
    def __init__(self, sceneRect: PySide2.QtCore.QRectF, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., backgroundBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., bspTreeDepth: int = ..., changed: typing.Callable = ..., destroyed: typing.Callable = ..., focusItemChanged: typing.Callable = ..., focusOnTouch: bool = ..., font: PySide2.QtGui.QFont = ..., foregroundBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., itemIndexMethod: QGraphicsScene.ItemIndexMethod = ..., minimumRenderSize: float = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., sceneRectChanged: typing.Callable = ..., selectionChanged: typing.Callable = ..., sortCacheEnabled: bool = ..., stickyFocus: bool = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., backgroundBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., bspTreeDepth: int = ..., changed: typing.Callable = ..., destroyed: typing.Callable = ..., focusItemChanged: typing.Callable = ..., focusOnTouch: bool = ..., font: PySide2.QtGui.QFont = ..., foregroundBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., itemIndexMethod: QGraphicsScene.ItemIndexMethod = ..., minimumRenderSize: float = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., sceneRect: PySide2.QtCore.QRectF = ..., sceneRectChanged: typing.Callable = ..., selectionChanged: typing.Callable = ..., sortCacheEnabled: bool = ..., stickyFocus: bool = ...) -> None: ...
    def activePanel(self) -> QGraphicsItem: ...
    def activeWindow(self) -> QGraphicsWidget: ...
    @overload
    def addEllipse(self, x: float, y: float, w: float, h: float, pen: PySide2.QtGui.QPen = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ...) -> QGraphicsEllipseItem: ...
    @overload
    def addEllipse(self, rect: PySide2.QtCore.QRectF, pen: PySide2.QtGui.QPen = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ...) -> QGraphicsEllipseItem: ...
    def addItem(self, item: QGraphicsItem) -> None: ...
    @overload
    def addLine(self, x1: float, y1: float, x2: float, y2: float, pen: PySide2.QtGui.QPen = ...) -> QGraphicsLineItem: ...
    @overload
    def addLine(self, line: PySide2.QtCore.QLineF, pen: PySide2.QtGui.QPen = ...) -> QGraphicsLineItem: ...
    def addPath(self, path: PySide2.QtGui.QPainterPath, pen: PySide2.QtGui.QPen = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ...) -> QGraphicsPathItem: ...
    def addPixmap(self, pixmap: PySide2.QtGui.QPixmap) -> QGraphicsPixmapItem: ...
    def addPolygon(self, polygon: PySide2.QtGui.QPolygonF, pen: PySide2.QtGui.QPen = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ...) -> QGraphicsPolygonItem: ...
    @overload
    def addRect(self, x: float, y: float, w: float, h: float, pen: PySide2.QtGui.QPen = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ...) -> QGraphicsRectItem: ...
    @overload
    def addRect(self, rect: PySide2.QtCore.QRectF, pen: PySide2.QtGui.QPen = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ...) -> QGraphicsRectItem: ...
    def addSimpleText(self, text: str, font: PySide2.QtGui.QFont = ...) -> QGraphicsSimpleTextItem: ...
    def addText(self, text: str, font: PySide2.QtGui.QFont = ...) -> QGraphicsTextItem: ...
    def addWidget(self, widget: QWidget, wFlags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ...) -> QGraphicsProxyWidget: ...
    def advance(self) -> None: ...
    def backgroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def bspTreeDepth(self) -> int: ...
    def clear(self) -> None: ...
    def clearFocus(self) -> None: ...
    def clearSelection(self) -> None: ...
    def collidingItems(self, item: QGraphicsItem, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    def contextMenuEvent(self, event: QGraphicsSceneContextMenuEvent) -> None: ...
    def createItemGroup(self, items: typing.Iterable[QGraphicsItem]) -> QGraphicsItemGroup: ...
    def destroyItemGroup(self, group: QGraphicsItemGroup) -> None: ...
    def dragEnterEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def drawBackground(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF) -> None: ...
    def drawForeground(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF) -> None: ...
    def dropEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, watched: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusItem(self) -> QGraphicsItem: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOnTouch(self) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def foregroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def hasFocus(self) -> bool: ...
    def height(self) -> float: ...
    def helpEvent(self, event: QGraphicsSceneHelpEvent) -> None: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @overload
    def invalidate(self, x: float, y: float, w: float, h: float, layers: typing.Union[QGraphicsScene.SceneLayers,QGraphicsScene.SceneLayer] = ...) -> None: ...
    @overload
    def invalidate(self, rect: PySide2.QtCore.QRectF = ..., layers: typing.Union[QGraphicsScene.SceneLayers,QGraphicsScene.SceneLayer] = ...) -> None: ...
    def isActive(self) -> bool: ...
    def isSortCacheEnabled(self) -> bool: ...
    @overload
    def itemAt(self, x: float, y: float, deviceTransform: PySide2.QtGui.QTransform) -> QGraphicsItem: ...
    @overload
    def itemAt(self, pos: PySide2.QtCore.QPointF, deviceTransform: PySide2.QtGui.QTransform) -> QGraphicsItem: ...
    def itemIndexMethod(self) -> QGraphicsScene.ItemIndexMethod: ...
    @overload
    def items(self, x: float, y: float, w: float, h: float, mode: PySide2.QtCore.Qt.ItemSelectionMode, order: PySide2.QtCore.Qt.SortOrder, deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, path: PySide2.QtGui.QPainterPath, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., order: PySide2.QtCore.Qt.SortOrder = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, polygon: PySide2.QtGui.QPolygonF, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., order: PySide2.QtCore.Qt.SortOrder = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, pos: PySide2.QtCore.QPointF, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., order: PySide2.QtCore.Qt.SortOrder = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, rect: PySide2.QtCore.QRectF, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., order: PySide2.QtCore.Qt.SortOrder = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, order: PySide2.QtCore.Qt.SortOrder = ...) -> typing.List[QGraphicsItem]: ...
    def itemsBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def minimumRenderSize(self) -> float: ...
    def mouseDoubleClickEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseGrabberItem(self) -> QGraphicsItem: ...
    def mouseMoveEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def palette(self) -> PySide2.QtGui.QPalette: ...
    def removeItem(self, item: QGraphicsItem) -> None: ...
    def render(self, painter: PySide2.QtGui.QPainter, target: PySide2.QtCore.QRectF = ..., source: PySide2.QtCore.QRectF = ..., aspectRatioMode: PySide2.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    def sceneRect(self) -> PySide2.QtCore.QRectF: ...
    def selectedItems(self) -> typing.List[QGraphicsItem]: ...
    def selectionArea(self) -> PySide2.QtGui.QPainterPath: ...
    def sendEvent(self, item: QGraphicsItem, event: PySide2.QtCore.QEvent) -> bool: ...
    def setActivePanel(self, item: QGraphicsItem) -> None: ...
    def setActiveWindow(self, widget: QGraphicsWidget) -> None: ...
    def setBackgroundBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
    def setBspTreeDepth(self, depth: int) -> None: ...
    def setFocus(self, focusReason: PySide2.QtCore.Qt.FocusReason = ...) -> None: ...
    def setFocusItem(self, item: QGraphicsItem, focusReason: PySide2.QtCore.Qt.FocusReason = ...) -> None: ...
    def setFocusOnTouch(self, enabled: bool) -> None: ...
    def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
    def setForegroundBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
    def setItemIndexMethod(self, method: QGraphicsScene.ItemIndexMethod) -> None: ...
    def setMinimumRenderSize(self, minSize: float) -> None: ...
    def setPalette(self, palette: PySide2.QtGui.QPalette) -> None: ...
    @overload
    def setSceneRect(self, x: float, y: float, w: float, h: float) -> None: ...
    @overload
    def setSceneRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
    @overload
    def setSelectionArea(self, path: PySide2.QtGui.QPainterPath, selectionOperation: PySide2.QtCore.Qt.ItemSelectionOperation, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> None: ...
    @overload
    def setSelectionArea(self, path: PySide2.QtGui.QPainterPath, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> None: ...
    @overload
    def setSelectionArea(self, path: PySide2.QtGui.QPainterPath, deviceTransform: PySide2.QtGui.QTransform) -> None: ...
    def setSortCacheEnabled(self, enabled: bool) -> None: ...
    def setStickyFocus(self, enabled: bool) -> None: ...
    def setStyle(self, style: QStyle) -> None: ...
    def stickyFocus(self) -> bool: ...
    def style(self) -> QStyle: ...
    @overload
    def update(self, x: float, y: float, w: float, h: float) -> None: ...
    @overload
    def update(self, rect: PySide2.QtCore.QRectF = ...) -> None: ...
    def views(self) -> typing.List[QGraphicsView]: ...
    def wheelEvent(self, event: QGraphicsSceneWheelEvent) -> None: ...
    def width(self) -> float: ...

class QGraphicsSceneContextMenuEvent(QGraphicsSceneEvent):
    class Reason:
        Keyboard: typing.ClassVar[QGraphicsSceneContextMenuEvent.Reason] = ...
        Mouse: typing.ClassVar[QGraphicsSceneContextMenuEvent.Reason] = ...
        Other: typing.ClassVar[QGraphicsSceneContextMenuEvent.Reason] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGraphicsSceneContextMenuEvent.Reason: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsSceneContextMenuEvent.Reason: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGraphicsSceneContextMenuEvent.Reason: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsSceneContextMenuEvent.Reason: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGraphicsSceneContextMenuEvent.Reason: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsSceneContextMenuEvent.Reason: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGraphicsSceneContextMenuEvent.Reason: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsSceneContextMenuEvent.Reason: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGraphicsSceneContextMenuEvent.Reason: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsSceneContextMenuEvent.Reason: ...
        def __sub__(self, other: typing.SupportsInt) -> QGraphicsSceneContextMenuEvent.Reason: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsSceneContextMenuEvent.Reason: ...
    Keyboard: typing.ClassVar[QGraphicsSceneContextMenuEvent.Reason] = ...
    Mouse: typing.ClassVar[QGraphicsSceneContextMenuEvent.Reason] = ...
    Other: typing.ClassVar[QGraphicsSceneContextMenuEvent.Reason] = ...
    def __init__(self, type: typing.Union[PySide2.QtCore.QEvent.Type,None] = ...) -> None: ...
    def modifiers(self) -> typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def reason(self) -> QGraphicsSceneContextMenuEvent.Reason: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setModifiers(self, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> None: ...
    def setPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setReason(self, reason: QGraphicsSceneContextMenuEvent.Reason) -> None: ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...

class QGraphicsSceneDragDropEvent(QGraphicsSceneEvent):
    def __init__(self, type: typing.Union[PySide2.QtCore.QEvent.Type,None] = ...) -> None: ...
    def acceptProposedAction(self) -> None: ...
    def buttons(self) -> typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton]: ...
    def dropAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def mimeData(self) -> PySide2.QtCore.QMimeData: ...
    def modifiers(self) -> typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def possibleActions(self) -> typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction]: ...
    def proposedAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setButtons(self, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton]) -> None: ...
    def setDropAction(self, action: PySide2.QtCore.Qt.DropAction) -> None: ...
    def setModifiers(self, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> None: ...
    def setPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setPossibleActions(self, actions: typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction]) -> None: ...
    def setProposedAction(self, action: PySide2.QtCore.Qt.DropAction) -> None: ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...
    def source(self) -> QWidget: ...

class QGraphicsSceneEvent(PySide2.QtCore.QEvent):
    def __init__(self, type: PySide2.QtCore.QEvent.Type) -> None: ...
    def widget(self) -> QWidget: ...

class QGraphicsSceneHelpEvent(QGraphicsSceneEvent):
    def __init__(self, type: typing.Union[PySide2.QtCore.QEvent.Type,None] = ...) -> None: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...

class QGraphicsSceneHoverEvent(QGraphicsSceneEvent):
    def __init__(self, type: typing.Union[PySide2.QtCore.QEvent.Type,None] = ...) -> None: ...
    def lastPos(self) -> PySide2.QtCore.QPointF: ...
    def lastScenePos(self) -> PySide2.QtCore.QPointF: ...
    def lastScreenPos(self) -> PySide2.QtCore.QPoint: ...
    def modifiers(self) -> typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setLastPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setLastScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setLastScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...
    def setModifiers(self, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> None: ...
    def setPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...

class QGraphicsSceneMouseEvent(QGraphicsSceneEvent):
    def __init__(self, type: typing.Union[PySide2.QtCore.QEvent.Type,None] = ...) -> None: ...
    def button(self) -> PySide2.QtCore.Qt.MouseButton: ...
    def buttonDownPos(self, button: PySide2.QtCore.Qt.MouseButton) -> PySide2.QtCore.QPointF: ...
    def buttonDownScenePos(self, button: PySide2.QtCore.Qt.MouseButton) -> PySide2.QtCore.QPointF: ...
    def buttonDownScreenPos(self, button: PySide2.QtCore.Qt.MouseButton) -> PySide2.QtCore.QPoint: ...
    def buttons(self) -> typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton]: ...
    def flags(self) -> typing.Union[PySide2.QtCore.Qt.MouseEventFlags,PySide2.QtCore.Qt.MouseEventFlag]: ...
    def lastPos(self) -> PySide2.QtCore.QPointF: ...
    def lastScenePos(self) -> PySide2.QtCore.QPointF: ...
    def lastScreenPos(self) -> PySide2.QtCore.QPoint: ...
    def modifiers(self) -> typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setButton(self, button: PySide2.QtCore.Qt.MouseButton) -> None: ...
    def setButtonDownPos(self, button: PySide2.QtCore.Qt.MouseButton, pos: PySide2.QtCore.QPointF) -> None: ...
    def setButtonDownScenePos(self, button: PySide2.QtCore.Qt.MouseButton, pos: PySide2.QtCore.QPointF) -> None: ...
    def setButtonDownScreenPos(self, button: PySide2.QtCore.Qt.MouseButton, pos: PySide2.QtCore.QPoint) -> None: ...
    def setButtons(self, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton]) -> None: ...
    def setFlags(self, arg__1: typing.Union[PySide2.QtCore.Qt.MouseEventFlags,PySide2.QtCore.Qt.MouseEventFlag]) -> None: ...
    def setLastPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setLastScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setLastScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...
    def setModifiers(self, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> None: ...
    def setPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...
    def setSource(self, source: PySide2.QtCore.Qt.MouseEventSource) -> None: ...
    def source(self) -> PySide2.QtCore.Qt.MouseEventSource: ...

class QGraphicsSceneMoveEvent(QGraphicsSceneEvent):
    def __init__(self) -> None: ...
    def newPos(self) -> PySide2.QtCore.QPointF: ...
    def oldPos(self) -> PySide2.QtCore.QPointF: ...
    def setNewPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setOldPos(self, pos: PySide2.QtCore.QPointF) -> None: ...

class QGraphicsSceneResizeEvent(QGraphicsSceneEvent):
    def __init__(self) -> None: ...
    def newSize(self) -> PySide2.QtCore.QSizeF: ...
    def oldSize(self) -> PySide2.QtCore.QSizeF: ...
    def setNewSize(self, size: PySide2.QtCore.QSizeF) -> None: ...
    def setOldSize(self, size: PySide2.QtCore.QSizeF) -> None: ...

class QGraphicsSceneWheelEvent(QGraphicsSceneEvent):
    def __init__(self, type: typing.Union[PySide2.QtCore.QEvent.Type,None] = ...) -> None: ...
    def buttons(self) -> typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton]: ...
    def delta(self) -> int: ...
    def modifiers(self) -> typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setButtons(self, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton]) -> None: ...
    def setDelta(self, delta: int) -> None: ...
    def setModifiers(self, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> None: ...
    def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...

class QGraphicsSimpleTextItem(QAbstractGraphicsShapeItem):
    @overload
    def __init__(self, text: str, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QGraphicsItem,None] = ...) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: QWidget) -> None: ...
    def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
    def setText(self, text: str) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def text(self) -> str: ...
    def type(self) -> int: ...

class QGraphicsTextItem(QGraphicsObject):
    linkActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    linkHovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, text: str, parent: typing.Union[QGraphicsItem,None] = ..., children: typing.Any = ..., childrenChanged: typing.Callable = ..., destroyed: typing.Callable = ..., effect: typing.Any = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., linkActivated: typing.Callable = ..., linkHovered: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., pos: PySide2.QtCore.QPointF = ..., rotation: float = ..., rotationChanged: typing.Callable = ..., scale: float = ..., scaleChanged: typing.Callable = ..., transformOriginPoint: PySide2.QtCore.QPointF = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: float = ..., widthChanged: typing.Callable = ..., x: float = ..., xChanged: typing.Callable = ..., y: float = ..., yChanged: typing.Callable = ..., z: float = ..., zChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QGraphicsItem,None] = ..., children: typing.Any = ..., childrenChanged: typing.Callable = ..., destroyed: typing.Callable = ..., effect: typing.Any = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., linkActivated: typing.Callable = ..., linkHovered: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., pos: PySide2.QtCore.QPointF = ..., rotation: float = ..., rotationChanged: typing.Callable = ..., scale: float = ..., scaleChanged: typing.Callable = ..., transformOriginPoint: PySide2.QtCore.QPointF = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: float = ..., widthChanged: typing.Callable = ..., x: float = ..., xChanged: typing.Callable = ..., y: float = ..., yChanged: typing.Callable = ..., z: float = ..., zChanged: typing.Callable = ...) -> None: ...
    def adjustSize(self) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def contextMenuEvent(self, event: QGraphicsSceneContextMenuEvent) -> None: ...
    def defaultTextColor(self) -> PySide2.QtGui.QColor: ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def dragEnterEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dropEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def hoverEnterEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def openExternalLinks(self) -> bool: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: QWidget) -> None: ...
    def sceneEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def setDefaultTextColor(self, c: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setDocument(self, document: PySide2.QtGui.QTextDocument) -> None: ...
    def setExtension(self, extension: QGraphicsItem.Extension, variant: typing.Any) -> None: ...
    def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
    def setHtml(self, html: str) -> None: ...
    def setOpenExternalLinks(self, open: bool) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def setTabChangesFocus(self, b: bool) -> None: ...
    def setTextCursor(self, cursor: PySide2.QtGui.QTextCursor) -> None: ...
    def setTextInteractionFlags(self, flags: typing.Union[PySide2.QtCore.Qt.TextInteractionFlags,PySide2.QtCore.Qt.TextInteractionFlag]) -> None: ...
    def setTextWidth(self, width: float) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def supportsExtension(self, extension: QGraphicsItem.Extension) -> bool: ...
    def tabChangesFocus(self) -> bool: ...
    def textCursor(self) -> PySide2.QtGui.QTextCursor: ...
    def textInteractionFlags(self) -> typing.Union[PySide2.QtCore.Qt.TextInteractionFlags,PySide2.QtCore.Qt.TextInteractionFlag]: ...
    def textWidth(self) -> float: ...
    def toHtml(self) -> str: ...
    def toPlainText(self) -> str: ...
    def type(self) -> int: ...

class QGraphicsTransform(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def applyTo(self, matrix: PySide2.QtGui.QMatrix4x4) -> None: ...
    def update(self) -> None: ...

class QGraphicsView(QAbstractScrollArea):
    class CacheMode:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsView.CacheMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGraphicsView.CacheMode: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsView.CacheMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsView.CacheMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsView.CacheMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsView.CacheMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsView.CacheMode: ...

    class CacheModeFlag:
        CacheBackground: typing.ClassVar[QGraphicsView.CacheModeFlag] = ...
        CacheNone: typing.ClassVar[QGraphicsView.CacheModeFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsView.CacheMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGraphicsView.CacheMode: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsView.CacheMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsView.CacheMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsView.CacheMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsView.CacheMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsView.CacheMode: ...

    class DragMode:
        NoDrag: typing.ClassVar[QGraphicsView.DragMode] = ...
        RubberBandDrag: typing.ClassVar[QGraphicsView.DragMode] = ...
        ScrollHandDrag: typing.ClassVar[QGraphicsView.DragMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGraphicsView.DragMode: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsView.DragMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGraphicsView.DragMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsView.DragMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGraphicsView.DragMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsView.DragMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGraphicsView.DragMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsView.DragMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGraphicsView.DragMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsView.DragMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QGraphicsView.DragMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsView.DragMode: ...

    class OptimizationFlag:
        DontAdjustForAntialiasing: typing.ClassVar[QGraphicsView.OptimizationFlag] = ...
        DontClipPainter: typing.ClassVar[QGraphicsView.OptimizationFlag] = ...
        DontSavePainterState: typing.ClassVar[QGraphicsView.OptimizationFlag] = ...
        IndirectPainting: typing.ClassVar[QGraphicsView.OptimizationFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsView.OptimizationFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGraphicsView.OptimizationFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsView.OptimizationFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsView.OptimizationFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsView.OptimizationFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsView.OptimizationFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsView.OptimizationFlags: ...

    class OptimizationFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsView.OptimizationFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGraphicsView.OptimizationFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsView.OptimizationFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsView.OptimizationFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsView.OptimizationFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsView.OptimizationFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsView.OptimizationFlags: ...

    class ViewportAnchor:
        AnchorUnderMouse: typing.ClassVar[QGraphicsView.ViewportAnchor] = ...
        AnchorViewCenter: typing.ClassVar[QGraphicsView.ViewportAnchor] = ...
        NoAnchor: typing.ClassVar[QGraphicsView.ViewportAnchor] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportAnchor: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportAnchor: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportAnchor: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportAnchor: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportAnchor: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportAnchor: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportAnchor: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportAnchor: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportAnchor: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportAnchor: ...
        def __sub__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportAnchor: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportAnchor: ...

    class ViewportUpdateMode:
        BoundingRectViewportUpdate: typing.ClassVar[QGraphicsView.ViewportUpdateMode] = ...
        FullViewportUpdate: typing.ClassVar[QGraphicsView.ViewportUpdateMode] = ...
        MinimalViewportUpdate: typing.ClassVar[QGraphicsView.ViewportUpdateMode] = ...
        NoViewportUpdate: typing.ClassVar[QGraphicsView.ViewportUpdateMode] = ...
        SmartViewportUpdate: typing.ClassVar[QGraphicsView.ViewportUpdateMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportUpdateMode: ...
        def __and__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportUpdateMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportUpdateMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportUpdateMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportUpdateMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportUpdateMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportUpdateMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportUpdateMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportUpdateMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportUpdateMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportUpdateMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QGraphicsView.ViewportUpdateMode: ...
    AnchorUnderMouse: typing.ClassVar[QGraphicsView.ViewportAnchor] = ...
    AnchorViewCenter: typing.ClassVar[QGraphicsView.ViewportAnchor] = ...
    BoundingRectViewportUpdate: typing.ClassVar[QGraphicsView.ViewportUpdateMode] = ...
    CacheBackground: typing.ClassVar[QGraphicsView.CacheModeFlag] = ...
    CacheNone: typing.ClassVar[QGraphicsView.CacheModeFlag] = ...
    DontAdjustForAntialiasing: typing.ClassVar[QGraphicsView.OptimizationFlag] = ...
    DontClipPainter: typing.ClassVar[QGraphicsView.OptimizationFlag] = ...
    DontSavePainterState: typing.ClassVar[QGraphicsView.OptimizationFlag] = ...
    FullViewportUpdate: typing.ClassVar[QGraphicsView.ViewportUpdateMode] = ...
    IndirectPainting: typing.ClassVar[QGraphicsView.OptimizationFlag] = ...
    MinimalViewportUpdate: typing.ClassVar[QGraphicsView.ViewportUpdateMode] = ...
    NoAnchor: typing.ClassVar[QGraphicsView.ViewportAnchor] = ...
    NoDrag: typing.ClassVar[QGraphicsView.DragMode] = ...
    NoViewportUpdate: typing.ClassVar[QGraphicsView.ViewportUpdateMode] = ...
    RubberBandDrag: typing.ClassVar[QGraphicsView.DragMode] = ...
    ScrollHandDrag: typing.ClassVar[QGraphicsView.DragMode] = ...
    SmartViewportUpdate: typing.ClassVar[QGraphicsView.ViewportUpdateMode] = ...
    rubberBandChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, scene: QGraphicsScene, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., backgroundBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., baseSize: PySide2.QtCore.QSize = ..., cacheMode: typing.Union[QGraphicsView.CacheMode,QGraphicsView.CacheModeFlag] = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., dragMode: QGraphicsView.DragMode = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., foregroundBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QGraphicsView.Shadow = ..., frameShape: QGraphicsView.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., interactive: bool = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., optimizationFlags: typing.Union[QGraphicsView.OptimizationFlags,QGraphicsView.OptimizationFlag] = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., renderHints: typing.Union[PySide2.QtGui.QPainter.RenderHints,PySide2.QtGui.QPainter.RenderHint] = ..., resizeAnchor: QGraphicsView.ViewportAnchor = ..., rubberBandChanged: typing.Callable = ..., rubberBandSelectionMode: PySide2.QtCore.Qt.ItemSelectionMode = ..., sceneRect: PySide2.QtCore.QRectF = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QGraphicsView.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., transformationAnchor: QGraphicsView.ViewportAnchor = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., viewportUpdateMode: QGraphicsView.ViewportUpdateMode = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., backgroundBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., baseSize: PySide2.QtCore.QSize = ..., cacheMode: typing.Union[QGraphicsView.CacheMode,QGraphicsView.CacheModeFlag] = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., dragMode: QGraphicsView.DragMode = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., foregroundBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QGraphicsView.Shadow = ..., frameShape: QGraphicsView.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., interactive: bool = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., optimizationFlags: typing.Union[QGraphicsView.OptimizationFlags,QGraphicsView.OptimizationFlag] = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., renderHints: typing.Union[PySide2.QtGui.QPainter.RenderHints,PySide2.QtGui.QPainter.RenderHint] = ..., resizeAnchor: QGraphicsView.ViewportAnchor = ..., rubberBandChanged: typing.Callable = ..., rubberBandSelectionMode: PySide2.QtCore.Qt.ItemSelectionMode = ..., sceneRect: PySide2.QtCore.QRectF = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QGraphicsView.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., transformationAnchor: QGraphicsView.ViewportAnchor = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., viewportUpdateMode: QGraphicsView.ViewportUpdateMode = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def alignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def backgroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def cacheMode(self) -> typing.Union[QGraphicsView.CacheMode,QGraphicsView.CacheModeFlag]: ...
    @overload
    def centerOn(self, x: float, y: float) -> None: ...
    @overload
    def centerOn(self, item: QGraphicsItem) -> None: ...
    @overload
    def centerOn(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def contextMenuEvent(self, event: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def dragEnterEvent(self, event: PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMode(self) -> QGraphicsView.DragMode: ...
    def dragMoveEvent(self, event: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def drawBackground(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF) -> None: ...
    def drawForeground(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF) -> None: ...
    def drawItems(self, painter: PySide2.QtGui.QPainter, numItems: int, items: typing.Iterable[QGraphicsItem], options: typing.Iterable[QStyleOptionGraphicsItem]) -> None: ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent) -> None: ...
    @overload
    def ensureVisible(self, x: float, y: float, w: float, h: float, xmargin: int = ..., ymargin: int = ...) -> None: ...
    @overload
    def ensureVisible(self, item: QGraphicsItem, xmargin: int = ..., ymargin: int = ...) -> None: ...
    @overload
    def ensureVisible(self, rect: PySide2.QtCore.QRectF, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    @overload
    def fitInView(self, x: float, y: float, w: float, h: float, aspectRadioMode: PySide2.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @overload
    def fitInView(self, item: QGraphicsItem, aspectRadioMode: PySide2.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @overload
    def fitInView(self, rect: PySide2.QtCore.QRectF, aspectRadioMode: PySide2.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def foregroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def invalidateScene(self, rect: PySide2.QtCore.QRectF = ..., layers: typing.Union[QGraphicsScene.SceneLayers,QGraphicsScene.SceneLayer] = ...) -> None: ...
    def isInteractive(self) -> bool: ...
    def isTransformed(self) -> bool: ...
    @overload
    def itemAt(self, x: int, y: int) -> QGraphicsItem: ...
    @overload
    def itemAt(self, pos: PySide2.QtCore.QPoint) -> QGraphicsItem: ...
    @overload
    def items(self, x: int, y: int, w: int, h: int, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, path: PySide2.QtGui.QPainterPath, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, polygon: PySide2.QtGui.QPolygon, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, rect: PySide2.QtCore.QRect, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, x: int, y: int) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, pos: PySide2.QtCore.QPoint) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self) -> typing.List[QGraphicsItem]: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    @overload
    def mapFromScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygon: ...
    @overload
    def mapFromScene(self, x: float, y: float) -> PySide2.QtCore.QPoint: ...
    @overload
    def mapFromScene(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @overload
    def mapFromScene(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPoint: ...
    @overload
    def mapFromScene(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygon: ...
    @overload
    def mapFromScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygon: ...
    @overload
    def mapToScene(self, x: int, y: int, w: int, h: int) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, x: int, y: int) -> PySide2.QtCore.QPointF: ...
    @overload
    def mapToScene(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @overload
    def mapToScene(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPointF: ...
    @overload
    def mapToScene(self, polygon: PySide2.QtGui.QPolygon) -> PySide2.QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, rect: PySide2.QtCore.QRect) -> PySide2.QtGui.QPolygonF: ...
    def matrix(self) -> PySide2.QtGui.QMatrix: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def optimizationFlags(self) -> typing.Union[QGraphicsView.OptimizationFlags,QGraphicsView.OptimizationFlag]: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    @overload
    def render(self, painter: PySide2.QtGui.QPainter, target: PySide2.QtCore.QRectF = ..., source: PySide2.QtCore.QRect = ..., aspectRatioMode: PySide2.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @overload
    def render(self, target: PySide2.QtGui.QPaintDevice, targetOffset: PySide2.QtCore.QPoint = ..., sourceRegion: PySide2.QtGui.QRegion = ..., renderFlags: typing.Union[QWidget.RenderFlags,QWidget.RenderFlag] = ...) -> None: ...
    def renderHints(self) -> typing.Union[PySide2.QtGui.QPainter.RenderHints,PySide2.QtGui.QPainter.RenderHint]: ...
    def resetCachedContent(self) -> None: ...
    def resetMatrix(self) -> None: ...
    def resetTransform(self) -> None: ...
    def resizeAnchor(self) -> QGraphicsView.ViewportAnchor: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def rotate(self, angle: float) -> None: ...
    def rubberBandRect(self) -> PySide2.QtCore.QRect: ...
    def rubberBandSelectionMode(self) -> PySide2.QtCore.Qt.ItemSelectionMode: ...
    def scale(self, sx: float, sy: float) -> None: ...
    def scene(self) -> QGraphicsScene: ...
    def sceneRect(self) -> PySide2.QtCore.QRectF: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def setAlignment(self, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setBackgroundBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
    def setCacheMode(self, mode: typing.Union[QGraphicsView.CacheMode,QGraphicsView.CacheModeFlag]) -> None: ...
    def setDragMode(self, mode: QGraphicsView.DragMode) -> None: ...
    def setForegroundBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
    def setInteractive(self, allowed: bool) -> None: ...
    def setMatrix(self, matrix: PySide2.QtGui.QMatrix, combine: bool = ...) -> None: ...
    def setOptimizationFlag(self, flag: QGraphicsView.OptimizationFlag, enabled: bool = ...) -> None: ...
    def setOptimizationFlags(self, flags: typing.Union[QGraphicsView.OptimizationFlags,QGraphicsView.OptimizationFlag]) -> None: ...
    def setRenderHint(self, hint: PySide2.QtGui.QPainter.RenderHint, enabled: bool = ...) -> None: ...
    def setRenderHints(self, hints: typing.Union[PySide2.QtGui.QPainter.RenderHints,PySide2.QtGui.QPainter.RenderHint]) -> None: ...
    def setResizeAnchor(self, anchor: QGraphicsView.ViewportAnchor) -> None: ...
    def setRubberBandSelectionMode(self, mode: PySide2.QtCore.Qt.ItemSelectionMode) -> None: ...
    def setScene(self, scene: QGraphicsScene) -> None: ...
    @overload
    def setSceneRect(self, x: float, y: float, w: float, h: float) -> None: ...
    @overload
    def setSceneRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setTransform(self, matrix: PySide2.QtGui.QTransform, combine: bool = ...) -> None: ...
    def setTransformationAnchor(self, anchor: QGraphicsView.ViewportAnchor) -> None: ...
    def setViewportUpdateMode(self, mode: QGraphicsView.ViewportUpdateMode) -> None: ...
    def setupViewport(self, widget: QWidget) -> None: ...
    def shear(self, sh: float, sv: float) -> None: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def transform(self) -> PySide2.QtGui.QTransform: ...
    def transformationAnchor(self) -> QGraphicsView.ViewportAnchor: ...
    def translate(self, dx: float, dy: float) -> None: ...
    def updateScene(self, rects: typing.Iterable[PySide2.QtCore.QRectF]) -> None: ...
    def updateSceneRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def viewportEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def viewportTransform(self) -> PySide2.QtGui.QTransform: ...
    def viewportUpdateMode(self) -> QGraphicsView.ViewportUpdateMode: ...
    def wheelEvent(self, event: PySide2.QtGui.QWheelEvent) -> None: ...

class QGraphicsWidget(QGraphicsObject, QGraphicsLayoutItem):
    geometryChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    layoutChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QGraphicsItem,None] = ..., wFlags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., autoFillBackground: bool = ..., children: typing.Any = ..., childrenChanged: typing.Callable = ..., destroyed: typing.Callable = ..., effect: typing.Any = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., geometry: PySide2.QtCore.QRectF = ..., geometryChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., layout: QGraphicsLayout = ..., layoutChanged: typing.Callable = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., maximumSize: PySide2.QtCore.QSizeF = ..., minimumSize: PySide2.QtCore.QSizeF = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., parentChanged: typing.Callable = ..., pos: PySide2.QtCore.QPointF = ..., preferredSize: PySide2.QtCore.QSizeF = ..., rotation: float = ..., rotationChanged: typing.Callable = ..., scale: float = ..., scaleChanged: typing.Callable = ..., size: PySide2.QtCore.QSizeF = ..., sizePolicy: QSizePolicy = ..., transformOriginPoint: PySide2.QtCore.QPointF = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: float = ..., widthChanged: typing.Callable = ..., windowFlags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., windowTitle: str = ..., x: float = ..., xChanged: typing.Callable = ..., y: float = ..., yChanged: typing.Callable = ..., z: float = ..., zChanged: typing.Callable = ...) -> None: ...
    def actions(self) -> typing.List[QAction]: ...
    def addAction(self, action: QAction) -> None: ...
    def addActions(self, actions: typing.Iterable[QAction]) -> None: ...
    def adjustSize(self) -> None: ...
    def autoFillBackground(self) -> bool: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def close(self) -> bool: ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusPolicy(self) -> PySide2.QtCore.Qt.FocusPolicy: ...
    def focusWidget(self) -> QGraphicsWidget: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def getContentsMargins(self) -> typing.Tuple[float,float,float,float]: ...
    def getWindowFrameMargins(self) -> typing.Tuple[float,float,float,float]: ...
    def grabKeyboardEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def grabMouseEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def grabShortcut(self, sequence: typing.Union[PySide2.QtGui.QKeySequence,str], context: PySide2.QtCore.Qt.ShortcutContext = ...) -> int: ...
    def hideEvent(self, event: PySide2.QtGui.QHideEvent) -> None: ...
    def hoverLeaveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def initStyleOption(self, option: QStyleOption) -> None: ...
    def insertAction(self, before: QAction, action: QAction) -> None: ...
    def insertActions(self, before: QAction, actions: typing.Iterable[QAction]) -> None: ...
    def isActiveWindow(self) -> bool: ...
    def itemChange(self, change: QGraphicsItem.GraphicsItemChange, value: typing.Any) -> typing.Any: ...
    def layout(self) -> QGraphicsLayout: ...
    def layoutDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def moveEvent(self, event: QGraphicsSceneMoveEvent) -> None: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Union[QWidget,None] = ...) -> None: ...
    def paintWindowFrame(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Union[QWidget,None] = ...) -> None: ...
    def palette(self) -> PySide2.QtGui.QPalette: ...
    def polishEvent(self) -> None: ...
    def propertyChange(self, propertyName: str, value: typing.Any) -> typing.Any: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    def releaseShortcut(self, id: int) -> None: ...
    def removeAction(self, action: QAction) -> None: ...
    @overload
    def resize(self, w: float, h: float) -> None: ...
    @overload
    def resize(self, size: PySide2.QtCore.QSizeF) -> None: ...
    def resizeEvent(self, event: QGraphicsSceneResizeEvent) -> None: ...
    def sceneEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def setAttribute(self, attribute: PySide2.QtCore.Qt.WidgetAttribute, on: bool = ...) -> None: ...
    def setAutoFillBackground(self, enabled: bool) -> None: ...
    @overload
    def setContentsMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...
    @overload
    def setContentsMargins(self, margins: PySide2.QtCore.QMarginsF) -> None: ...
    def setFocusPolicy(self, policy: PySide2.QtCore.Qt.FocusPolicy) -> None: ...
    def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
    @overload
    def setGeometry(self, x: float, y: float, w: float, h: float) -> None: ...
    @overload
    def setGeometry(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setLayout(self, layout: QGraphicsLayout) -> None: ...
    def setLayoutDirection(self, direction: PySide2.QtCore.Qt.LayoutDirection) -> None: ...
    def setPalette(self, palette: PySide2.QtGui.QPalette) -> None: ...
    def setShortcutAutoRepeat(self, id: int, enabled: bool = ...) -> None: ...
    def setShortcutEnabled(self, id: int, enabled: bool = ...) -> None: ...
    def setStyle(self, style: QStyle) -> None: ...
    @classmethod
    def setTabOrder(cls, first: QGraphicsWidget, second: QGraphicsWidget) -> None: ...
    def setWindowFlags(self, wFlags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType]) -> None: ...
    @overload
    def setWindowFrameMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...
    @overload
    def setWindowFrameMargins(self, margins: PySide2.QtCore.QMarginsF) -> None: ...
    def setWindowTitle(self, title: str) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def style(self) -> QStyle: ...
    def testAttribute(self, attribute: PySide2.QtCore.Qt.WidgetAttribute) -> bool: ...
    def type(self) -> int: ...
    def ungrabKeyboardEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def ungrabMouseEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def unsetLayoutDirection(self) -> None: ...
    def unsetWindowFrameMargins(self) -> None: ...
    def updateGeometry(self) -> None: ...
    def windowFlags(self) -> typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType]: ...
    def windowFrameEvent(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def windowFrameGeometry(self) -> PySide2.QtCore.QRectF: ...
    def windowFrameRect(self) -> PySide2.QtCore.QRectF: ...
    def windowFrameSectionAt(self, pos: PySide2.QtCore.QPointF) -> PySide2.QtCore.Qt.WindowFrameSection: ...
    def windowTitle(self) -> str: ...
    def windowType(self) -> PySide2.QtCore.Qt.WindowType: ...

class QGridLayout(QLayout):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None], destroyed: typing.Callable = ..., margin: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., sizeConstraint: QGridLayout.SizeConstraint = ..., spacing: int = ...) -> None: ...
    @overload
    def __init__(self, destroyed: typing.Callable = ..., margin: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., sizeConstraint: QGridLayout.SizeConstraint = ..., spacing: int = ...) -> None: ...
    @overload
    def addItem(self, item: QLayoutItem, row: int, column: int, rowSpan: int = ..., columnSpan: int = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    @overload
    def addItem(self, arg__1: QLayoutItem) -> None: ...
    @overload
    def addLayout(self, arg__1: QLayout, row: int, column: int, rowSpan: int, columnSpan: int, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    @overload
    def addLayout(self, arg__1: QLayout, row: int, column: int, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    @overload
    def addWidget(self, arg__1: QWidget, row: int, column: int, rowSpan: int, columnSpan: int, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    @overload
    def addWidget(self, arg__1: QWidget, row: int, column: int, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    @overload
    def addWidget(self, w: QWidget) -> None: ...
    def cellRect(self, row: int, column: int) -> PySide2.QtCore.QRect: ...
    def columnCount(self) -> int: ...
    def columnMinimumWidth(self, column: int) -> int: ...
    def columnStretch(self, column: int) -> int: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> typing.Union[PySide2.QtCore.Qt.Orientations,PySide2.QtCore.Qt.Orientation]: ...
    def getItemPosition(self, idx: int) -> typing.Tuple[int,int,int,int]: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def horizontalSpacing(self) -> int: ...
    def invalidate(self) -> None: ...
    def itemAt(self, index: int) -> QLayoutItem: ...
    def itemAtPosition(self, row: int, column: int) -> QLayoutItem: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def originCorner(self) -> PySide2.QtCore.Qt.Corner: ...
    def rowCount(self) -> int: ...
    def rowMinimumHeight(self, row: int) -> int: ...
    def rowStretch(self, row: int) -> int: ...
    def setColumnMinimumWidth(self, column: int, minSize: int) -> None: ...
    def setColumnStretch(self, column: int, stretch: int) -> None: ...
    def setDefaultPositioning(self, n: int, orient: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    def setHorizontalSpacing(self, spacing: int) -> None: ...
    def setOriginCorner(self, arg__1: PySide2.QtCore.Qt.Corner) -> None: ...
    def setRowMinimumHeight(self, row: int, minSize: int) -> None: ...
    def setRowStretch(self, row: int, stretch: int) -> None: ...
    def setSpacing(self, spacing: int) -> None: ...
    def setVerticalSpacing(self, spacing: int) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def takeAt(self, index: int) -> QLayoutItem: ...
    def verticalSpacing(self) -> int: ...

class QGroupBox(QWidget):
    clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    toggled: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, title: str, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., checkable: bool = ..., checked: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., flat: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toggled: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., checkable: bool = ..., checked: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., flat: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., title: str = ..., toggled: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def alignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def childEvent(self, event: PySide2.QtCore.QChildEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def initStyleOption(self, option: QStyleOptionGroupBox) -> None: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isFlat(self) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def setAlignment(self, alignment: int) -> None: ...
    def setCheckable(self, checkable: bool) -> None: ...
    def setChecked(self, checked: bool) -> None: ...
    def setFlat(self, flat: bool) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...

class QHBoxLayout(QBoxLayout):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None], destroyed: typing.Callable = ..., margin: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., sizeConstraint: QHBoxLayout.SizeConstraint = ..., spacing: int = ...) -> None: ...
    @overload
    def __init__(self, destroyed: typing.Callable = ..., margin: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., sizeConstraint: QHBoxLayout.SizeConstraint = ..., spacing: int = ...) -> None: ...

class QHeaderView(QAbstractItemView):
    class ResizeMode:
        Custom: typing.ClassVar[QHeaderView.ResizeMode] = ...
        Fixed: typing.ClassVar[QHeaderView.ResizeMode] = ...
        Interactive: typing.ClassVar[QHeaderView.ResizeMode] = ...
        ResizeToContents: typing.ClassVar[QHeaderView.ResizeMode] = ...
        Stretch: typing.ClassVar[QHeaderView.ResizeMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QHeaderView.ResizeMode: ...
        def __and__(self, other: typing.SupportsInt) -> QHeaderView.ResizeMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QHeaderView.ResizeMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QHeaderView.ResizeMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QHeaderView.ResizeMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QHeaderView.ResizeMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QHeaderView.ResizeMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QHeaderView.ResizeMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QHeaderView.ResizeMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QHeaderView.ResizeMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QHeaderView.ResizeMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QHeaderView.ResizeMode: ...
    Custom: typing.ClassVar[QHeaderView.ResizeMode] = ...
    Fixed: typing.ClassVar[QHeaderView.ResizeMode] = ...
    Interactive: typing.ClassVar[QHeaderView.ResizeMode] = ...
    ResizeToContents: typing.ClassVar[QHeaderView.ResizeMode] = ...
    Stretch: typing.ClassVar[QHeaderView.ResizeMode] = ...
    geometriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sectionClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sectionCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sectionDoubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sectionEntered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sectionHandleDoubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sectionMoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sectionPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sectionResized: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sortIndicatorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QAbstractScrollArea.Shadow = ..., frameShape: QAbstractScrollArea.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QAbstractScrollArea.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def cascadingSectionResizes(self) -> bool: ...
    def count(self) -> int: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, old: PySide2.QtCore.QModelIndex) -> None: ...
    def dataChanged(self, topLeft: PySide2.QtCore.QModelIndex, bottomRight: PySide2.QtCore.QModelIndex, roles: typing.List[int] = ...) -> None: ...
    def defaultAlignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def defaultSectionSize(self) -> int: ...
    def doItemsLayout(self) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def headerDataChanged(self, orientation: PySide2.QtCore.Qt.Orientation, logicalFirst: int, logicalLast: int) -> None: ...
    def hiddenSectionCount(self) -> int: ...
    def hideSection(self, logicalIndex: int) -> None: ...
    def highlightSections(self) -> bool: ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    @overload
    def initStyleOption(self, option: QStyleOptionFrame) -> None: ...
    @overload
    def initStyleOption(self, option: QStyleOptionHeader) -> None: ...
    def initialize(self) -> None: ...
    @overload
    def initializeSections(self, start: int, end: int) -> None: ...
    @overload
    def initializeSections(self) -> None: ...
    def isFirstSectionMovable(self) -> bool: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isSectionHidden(self, logicalIndex: int) -> bool: ...
    def isSortIndicatorShown(self) -> bool: ...
    def length(self) -> int: ...
    def logicalIndex(self, visualIndex: int) -> int: ...
    @overload
    def logicalIndexAt(self, x: int, y: int) -> int: ...
    @overload
    def logicalIndexAt(self, pos: PySide2.QtCore.QPoint) -> int: ...
    @overload
    def logicalIndexAt(self, position: int) -> int: ...
    def maximumSectionSize(self) -> int: ...
    def minimumSectionSize(self) -> int: ...
    def mouseDoubleClickEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, arg__1: QAbstractItemView.CursorAction, arg__2: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> PySide2.QtCore.QModelIndex: ...
    def moveSection(self, from_: int, to: int) -> None: ...
    def offset(self) -> int: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def paintSection(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, logicalIndex: int) -> None: ...
    def reset(self) -> None: ...
    def resetDefaultSectionSize(self) -> None: ...
    def resizeContentsPrecision(self) -> int: ...
    def resizeSection(self, logicalIndex: int, size: int) -> None: ...
    @overload
    def resizeSections(self, mode: QHeaderView.ResizeMode) -> None: ...
    @overload
    def resizeSections(self) -> None: ...
    def restoreState(self, state: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> bool: ...
    def rowsInserted(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int) -> None: ...
    def saveState(self) -> PySide2.QtCore.QByteArray: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: QAbstractItemView.ScrollHint) -> None: ...
    def sectionPosition(self, logicalIndex: int) -> int: ...
    def sectionResizeMode(self, logicalIndex: int) -> QHeaderView.ResizeMode: ...
    def sectionSize(self, logicalIndex: int) -> int: ...
    def sectionSizeFromContents(self, logicalIndex: int) -> PySide2.QtCore.QSize: ...
    def sectionSizeHint(self, logicalIndex: int) -> int: ...
    def sectionViewportPosition(self, logicalIndex: int) -> int: ...
    def sectionsAboutToBeRemoved(self, parent: PySide2.QtCore.QModelIndex, logicalFirst: int, logicalLast: int) -> None: ...
    def sectionsClickable(self) -> bool: ...
    def sectionsHidden(self) -> bool: ...
    def sectionsInserted(self, parent: PySide2.QtCore.QModelIndex, logicalFirst: int, logicalLast: int) -> None: ...
    def sectionsMovable(self) -> bool: ...
    def sectionsMoved(self) -> bool: ...
    def setCascadingSectionResizes(self, enable: bool) -> None: ...
    def setDefaultAlignment(self, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setDefaultSectionSize(self, size: int) -> None: ...
    def setFirstSectionMovable(self, movable: bool) -> None: ...
    def setHighlightSections(self, highlight: bool) -> None: ...
    def setMaximumSectionSize(self, size: int) -> None: ...
    def setMinimumSectionSize(self, size: int) -> None: ...
    def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
    def setOffset(self, offset: int) -> None: ...
    def setOffsetToLastSection(self) -> None: ...
    def setOffsetToSectionPosition(self, visualIndex: int) -> None: ...
    def setResizeContentsPrecision(self, precision: int) -> None: ...
    def setSectionHidden(self, logicalIndex: int, hide: bool) -> None: ...
    @overload
    def setSectionResizeMode(self, logicalIndex: int, mode: QHeaderView.ResizeMode) -> None: ...
    @overload
    def setSectionResizeMode(self, mode: QHeaderView.ResizeMode) -> None: ...
    def setSectionsClickable(self, clickable: bool) -> None: ...
    def setSectionsMovable(self, movable: bool) -> None: ...
    def setSelection(self, rect: PySide2.QtCore.QRect, flags: typing.Union[PySide2.QtCore.QItemSelectionModel.SelectionFlags,PySide2.QtCore.QItemSelectionModel.SelectionFlag]) -> None: ...
    def setSortIndicator(self, logicalIndex: int, order: PySide2.QtCore.Qt.SortOrder) -> None: ...
    def setSortIndicatorShown(self, show: bool) -> None: ...
    def setStretchLastSection(self, stretch: bool) -> None: ...
    def setVisible(self, v: bool) -> None: ...
    def showSection(self, logicalIndex: int) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sortIndicatorOrder(self) -> PySide2.QtCore.Qt.SortOrder: ...
    def sortIndicatorSection(self) -> int: ...
    def stretchLastSection(self) -> bool: ...
    def stretchSectionCount(self) -> int: ...
    def swapSections(self, first: int, second: int) -> None: ...
    def updateGeometries(self) -> None: ...
    def updateSection(self, logicalIndex: int) -> None: ...
    def verticalOffset(self) -> int: ...
    def viewportEvent(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def visualIndex(self, logicalIndex: int) -> int: ...
    def visualIndexAt(self, position: int) -> int: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...

class QInputDialog(QDialog):
    class InputDialogOption:
        NoButtons: typing.ClassVar[QInputDialog.InputDialogOption] = ...
        UseListViewForComboBoxItems: typing.ClassVar[QInputDialog.InputDialogOption] = ...
        UsePlainTextEditForTextInput: typing.ClassVar[QInputDialog.InputDialogOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QInputDialog.InputDialogOption: ...
        def __and__(self, other: typing.SupportsInt) -> QInputDialog.InputDialogOption: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QInputDialog.InputDialogOption: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QInputDialog.InputDialogOption: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QInputDialog.InputDialogOption: ...
        def __rand__(self, other: typing.SupportsInt) -> QInputDialog.InputDialogOption: ...
        def __rmul__(self, other: typing.SupportsInt) -> QInputDialog.InputDialogOption: ...
        def __ror__(self, other: typing.SupportsInt) -> QInputDialog.InputDialogOption: ...
        def __rsub__(self, other: typing.SupportsInt) -> QInputDialog.InputDialogOption: ...
        def __rxor__(self, other: typing.SupportsInt) -> QInputDialog.InputDialogOption: ...
        def __sub__(self, other: typing.SupportsInt) -> QInputDialog.InputDialogOption: ...
        def __xor__(self, other: typing.SupportsInt) -> QInputDialog.InputDialogOption: ...

    class InputMode:
        DoubleInput: typing.ClassVar[QInputDialog.InputMode] = ...
        IntInput: typing.ClassVar[QInputDialog.InputMode] = ...
        TextInput: typing.ClassVar[QInputDialog.InputMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QInputDialog.InputMode: ...
        def __and__(self, other: typing.SupportsInt) -> QInputDialog.InputMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QInputDialog.InputMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QInputDialog.InputMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QInputDialog.InputMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QInputDialog.InputMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QInputDialog.InputMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QInputDialog.InputMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QInputDialog.InputMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QInputDialog.InputMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QInputDialog.InputMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QInputDialog.InputMode: ...
    DoubleInput: typing.ClassVar[QInputDialog.InputMode] = ...
    IntInput: typing.ClassVar[QInputDialog.InputMode] = ...
    NoButtons: typing.ClassVar[QInputDialog.InputDialogOption] = ...
    TextInput: typing.ClassVar[QInputDialog.InputMode] = ...
    UseListViewForComboBoxItems: typing.ClassVar[QInputDialog.InputDialogOption] = ...
    UsePlainTextEditForTextInput: typing.ClassVar[QInputDialog.InputDialogOption] = ...
    doubleValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    doubleValueSelected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    intValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    intValueSelected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    textValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    textValueSelected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., doubleValueChanged: typing.Callable = ..., doubleValueSelected: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., intValueChanged: typing.Callable = ..., intValueSelected: typing.Callable = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., textValueChanged: typing.Callable = ..., textValueSelected: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def cancelButtonText(self) -> str: ...
    def comboBoxItems(self) -> typing.List[str]: ...
    def done(self, result: int) -> None: ...
    def doubleDecimals(self) -> int: ...
    def doubleMaximum(self) -> float: ...
    def doubleMinimum(self) -> float: ...
    def doubleStep(self) -> float: ...
    def doubleValue(self) -> float: ...
    @overload
    @classmethod
    def getDouble(cls, parent: typing.Union[QWidget,None], title: str, label: str, value: float, minValue: float, maxValue: float, decimals: int, flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType], step: float) -> typing.Tuple[float,bool]: ...
    @overload
    @classmethod
    def getDouble(cls, parent: typing.Union[QWidget,None], title: str, label: str, value: float, minValue: float = ..., maxValue: float = ..., decimals: int = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ...) -> typing.Tuple[float,bool]: ...
    @classmethod
    def getInt(cls, parent: typing.Union[QWidget,None], title: str, label: str, value: int, minValue: int = ..., maxValue: int = ..., step: int = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ...) -> typing.Tuple[int,bool]: ...
    @classmethod
    def getItem(cls, parent: typing.Union[QWidget,None], title: str, label: str, items: typing.Iterable[str], current: int, editable: bool = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ...) -> typing.Tuple[str,bool]: ...
    @classmethod
    def getMultiLineText(cls, parent: typing.Union[QWidget,None], title: str, label: str, text: str, flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ...) -> typing.Tuple[str,bool]: ...
    @classmethod
    def getText(cls, parent: typing.Union[QWidget,None], title: str, label: str, echo: QLineEdit.EchoMode = ..., text: str = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ...) -> typing.Tuple[str,bool]: ...
    def inputMode(self) -> QInputDialog.InputMode: ...
    def intMaximum(self) -> int: ...
    def intMinimum(self) -> int: ...
    def intStep(self) -> int: ...
    def intValue(self) -> int: ...
    def isComboBoxEditable(self) -> bool: ...
    def labelText(self) -> str: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def okButtonText(self) -> str: ...
    @overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    @overload
    def open(self) -> None: ...
    def setCancelButtonText(self, text: str) -> None: ...
    def setComboBoxEditable(self, editable: bool) -> None: ...
    def setComboBoxItems(self, items: typing.Iterable[str]) -> None: ...
    def setDoubleDecimals(self, decimals: int) -> None: ...
    def setDoubleMaximum(self, max: float) -> None: ...
    def setDoubleMinimum(self, min: float) -> None: ...
    def setDoubleRange(self, min: float, max: float) -> None: ...
    def setDoubleStep(self, step: float) -> None: ...
    def setDoubleValue(self, value: float) -> None: ...
    def setInputMode(self, mode: QInputDialog.InputMode) -> None: ...
    def setIntMaximum(self, max: int) -> None: ...
    def setIntMinimum(self, min: int) -> None: ...
    def setIntRange(self, min: int, max: int) -> None: ...
    def setIntStep(self, step: int) -> None: ...
    def setIntValue(self, value: int) -> None: ...
    def setLabelText(self, text: str) -> None: ...
    def setOkButtonText(self, text: str) -> None: ...
    def setOption(self, option: QInputDialog.InputDialogOption, on: bool = ...) -> None: ...
    def setTextEchoMode(self, mode: QLineEdit.EchoMode) -> None: ...
    def setTextValue(self, text: str) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def testOption(self, option: QInputDialog.InputDialogOption) -> bool: ...
    def textEchoMode(self) -> QLineEdit.EchoMode: ...
    def textValue(self) -> str: ...

class QItemDelegate(QAbstractItemDelegate):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., clipping: bool = ..., closeEditor: typing.Callable = ..., commitData: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., sizeHintChanged: typing.Callable = ...) -> None: ...
    def createEditor(self, parent: typing.Union[QWidget,None], option: QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> QWidget: ...
    def decoration(self, option: QStyleOptionViewItem, variant: typing.Any) -> PySide2.QtGui.QPixmap: ...
    def doCheck(self, option: QStyleOptionViewItem, bounding: PySide2.QtCore.QRect, variant: typing.Any) -> PySide2.QtCore.QRect: ...
    def drawBackground(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> None: ...
    def drawCheck(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionViewItem, rect: PySide2.QtCore.QRect, state: PySide2.QtCore.Qt.CheckState) -> None: ...
    def drawDecoration(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionViewItem, rect: PySide2.QtCore.QRect, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    def drawDisplay(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionViewItem, rect: PySide2.QtCore.QRect, text: str) -> None: ...
    def drawFocus(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionViewItem, rect: PySide2.QtCore.QRect) -> None: ...
    def editorEvent(self, event: PySide2.QtCore.QEvent, model: PySide2.QtCore.QAbstractItemModel, option: QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def hasClipping(self) -> bool: ...
    def itemEditorFactory(self) -> QItemEditorFactory: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> None: ...
    def rect(self, option: QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex, role: PySide2.QtCore.Qt.ItemDataRole) -> PySide2.QtCore.QRect: ...
    @classmethod
    def selectedPixmap(cls, pixmap: PySide2.QtGui.QPixmap, palette: PySide2.QtGui.QPalette, enabled: bool) -> PySide2.QtGui.QPixmap: ...
    def setClipping(self, clip: bool) -> None: ...
    def setEditorData(self, editor: QWidget, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setItemEditorFactory(self, factory: QItemEditorFactory) -> None: ...
    def setModelData(self, editor: QWidget, model: PySide2.QtCore.QAbstractItemModel, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setOptions(self, index: PySide2.QtCore.QModelIndex, option: QStyleOptionViewItem) -> QStyleOptionViewItem: ...
    def sizeHint(self, option: QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def textRectangle(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, font: PySide2.QtGui.QFont, text: str) -> PySide2.QtCore.QRect: ...
    def updateEditorGeometry(self, editor: QWidget, option: QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> None: ...

class QItemEditorCreatorBase(shiboken2.Object):
    def __init__(self) -> None: ...
    def createWidget(self, parent: typing.Union[QWidget,None]) -> QWidget: ...
    def valuePropertyName(self) -> PySide2.QtCore.QByteArray: ...

class QItemEditorFactory(shiboken2.Object):
    def __init__(self) -> None: ...
    def createEditor(self, userType: int, parent: typing.Union[QWidget,None]) -> QWidget: ...
    @classmethod
    def defaultFactory(cls) -> QItemEditorFactory: ...
    def registerEditor(self, userType: int, creator: QItemEditorCreatorBase) -> None: ...
    @classmethod
    def setDefaultFactory(cls, factory: QItemEditorFactory) -> None: ...
    def valuePropertyName(self, userType: int) -> PySide2.QtCore.QByteArray: ...

class QKeyEventTransition(PySide2.QtCore.QEventTransition):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, object: PySide2.QtCore.QObject, type: PySide2.QtCore.QEvent.Type, key: int, sourceState: typing.Union[PySide2.QtCore.QState,None] = ..., destroyed: typing.Callable = ..., eventSource: PySide2.QtCore.QObject = ..., eventType: typing.Any = ..., modifierMask: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier] = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., targetState: typing.Any = ..., targetStateChanged: typing.Callable = ..., targetStates: typing.Any = ..., targetStatesChanged: typing.Callable = ..., transitionType: QKeyEventTransition.TransitionType = ..., triggered: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, sourceState: typing.Union[PySide2.QtCore.QState,None] = ..., destroyed: typing.Callable = ..., eventSource: PySide2.QtCore.QObject = ..., eventType: typing.Any = ..., key: int = ..., modifierMask: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier] = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., targetState: typing.Any = ..., targetStateChanged: typing.Callable = ..., targetStates: typing.Any = ..., targetStatesChanged: typing.Callable = ..., transitionType: QKeyEventTransition.TransitionType = ..., triggered: typing.Callable = ...) -> None: ...
    def eventTest(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def key(self) -> int: ...
    def modifierMask(self) -> typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]: ...
    def onTransition(self, event: PySide2.QtCore.QEvent) -> None: ...
    def setKey(self, key: int) -> None: ...
    def setModifierMask(self, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> None: ...

class QKeySequenceEdit(QWidget):
    editingFinished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    keySequenceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, keySequence: typing.Union[PySide2.QtGui.QKeySequence,str], parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., editingFinished: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., keySequenceChanged: typing.Callable = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., editingFinished: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., keySequence: typing.Union[PySide2.QtGui.QKeySequence,str] = ..., keySequenceChanged: typing.Callable = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def clear(self) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def keySequence(self) -> PySide2.QtGui.QKeySequence: ...
    def setKeySequence(self, keySequence: typing.Union[PySide2.QtGui.QKeySequence,str]) -> None: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent) -> None: ...

class QLCDNumber(QFrame):
    class Mode:
        Bin: typing.ClassVar[QLCDNumber.Mode] = ...
        Dec: typing.ClassVar[QLCDNumber.Mode] = ...
        Hex: typing.ClassVar[QLCDNumber.Mode] = ...
        Oct: typing.ClassVar[QLCDNumber.Mode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLCDNumber.Mode: ...
        def __and__(self, other: typing.SupportsInt) -> QLCDNumber.Mode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLCDNumber.Mode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLCDNumber.Mode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLCDNumber.Mode: ...
        def __rand__(self, other: typing.SupportsInt) -> QLCDNumber.Mode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLCDNumber.Mode: ...
        def __ror__(self, other: typing.SupportsInt) -> QLCDNumber.Mode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLCDNumber.Mode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLCDNumber.Mode: ...
        def __sub__(self, other: typing.SupportsInt) -> QLCDNumber.Mode: ...
        def __xor__(self, other: typing.SupportsInt) -> QLCDNumber.Mode: ...

    class SegmentStyle:
        Filled: typing.ClassVar[QLCDNumber.SegmentStyle] = ...
        Flat: typing.ClassVar[QLCDNumber.SegmentStyle] = ...
        Outline: typing.ClassVar[QLCDNumber.SegmentStyle] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLCDNumber.SegmentStyle: ...
        def __and__(self, other: typing.SupportsInt) -> QLCDNumber.SegmentStyle: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLCDNumber.SegmentStyle: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLCDNumber.SegmentStyle: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLCDNumber.SegmentStyle: ...
        def __rand__(self, other: typing.SupportsInt) -> QLCDNumber.SegmentStyle: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLCDNumber.SegmentStyle: ...
        def __ror__(self, other: typing.SupportsInt) -> QLCDNumber.SegmentStyle: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLCDNumber.SegmentStyle: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLCDNumber.SegmentStyle: ...
        def __sub__(self, other: typing.SupportsInt) -> QLCDNumber.SegmentStyle: ...
        def __xor__(self, other: typing.SupportsInt) -> QLCDNumber.SegmentStyle: ...
    Bin: typing.ClassVar[QLCDNumber.Mode] = ...
    Dec: typing.ClassVar[QLCDNumber.Mode] = ...
    Filled: typing.ClassVar[QLCDNumber.SegmentStyle] = ...
    Flat: typing.ClassVar[QLCDNumber.SegmentStyle] = ...
    Hex: typing.ClassVar[QLCDNumber.Mode] = ...
    Oct: typing.ClassVar[QLCDNumber.Mode] = ...
    Outline: typing.ClassVar[QLCDNumber.SegmentStyle] = ...
    overflow: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, numDigits: int, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., digitCount: int = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QLCDNumber.Shadow = ..., frameShape: QLCDNumber.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., intValue: int = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mode: QLCDNumber.Mode = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., overflow: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., segmentStyle: QLCDNumber.SegmentStyle = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., smallDecimalPoint: bool = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., value: float = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., digitCount: int = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QLCDNumber.Shadow = ..., frameShape: QLCDNumber.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., intValue: int = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mode: QLCDNumber.Mode = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., overflow: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., segmentStyle: QLCDNumber.SegmentStyle = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., smallDecimalPoint: bool = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., value: float = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def checkOverflow(self, num: float) -> bool: ...
    @overload
    def checkOverflow(self, num: int) -> bool: ...
    def digitCount(self) -> int: ...
    @overload
    def display(self, num: float) -> None: ...
    @overload
    def display(self, num: int) -> None: ...
    @overload
    def display(self, str: str) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def intValue(self) -> int: ...
    def mode(self) -> QLCDNumber.Mode: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def segmentStyle(self) -> QLCDNumber.SegmentStyle: ...
    def setBinMode(self) -> None: ...
    def setDecMode(self) -> None: ...
    def setDigitCount(self, nDigits: int) -> None: ...
    def setHexMode(self) -> None: ...
    def setMode(self, arg__1: QLCDNumber.Mode) -> None: ...
    def setOctMode(self) -> None: ...
    def setSegmentStyle(self, arg__1: QLCDNumber.SegmentStyle) -> None: ...
    def setSmallDecimalPoint(self, arg__1: bool) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def smallDecimalPoint(self) -> bool: ...
    def value(self) -> float: ...

class QLabel(QFrame):
    linkActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    linkHovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, text: str, parent: typing.Union[QWidget,None] = ..., f: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QLabel.Shadow = ..., frameShape: QLabel.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., hasSelectedText: bool = ..., height: int = ..., indent: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., linkActivated: typing.Callable = ..., linkHovered: typing.Callable = ..., locale: PySide2.QtCore.QLocale = ..., margin: int = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., openExternalLinks: bool = ..., palette: PySide2.QtGui.QPalette = ..., pixmap: PySide2.QtGui.QPixmap = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., scaledContents: bool = ..., selectedText: str = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., textFormat: PySide2.QtCore.Qt.TextFormat = ..., textInteractionFlags: typing.Union[PySide2.QtCore.Qt.TextInteractionFlags,PySide2.QtCore.Qt.TextInteractionFlag] = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wordWrap: bool = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., f: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QLabel.Shadow = ..., frameShape: QLabel.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., hasSelectedText: bool = ..., height: int = ..., indent: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., linkActivated: typing.Callable = ..., linkHovered: typing.Callable = ..., locale: PySide2.QtCore.QLocale = ..., margin: int = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., openExternalLinks: bool = ..., palette: PySide2.QtGui.QPalette = ..., pixmap: PySide2.QtGui.QPixmap = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., scaledContents: bool = ..., selectedText: str = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., textFormat: PySide2.QtCore.Qt.TextFormat = ..., textInteractionFlags: typing.Union[PySide2.QtCore.Qt.TextInteractionFlags,PySide2.QtCore.Qt.TextInteractionFlag] = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wordWrap: bool = ..., x: int = ..., y: int = ...) -> None: ...
    def alignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def buddy(self) -> QWidget: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def contextMenuEvent(self, ev: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, ev: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, ev: PySide2.QtGui.QFocusEvent) -> None: ...
    def hasScaledContents(self) -> bool: ...
    def hasSelectedText(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def indent(self) -> int: ...
    def keyPressEvent(self, ev: PySide2.QtGui.QKeyEvent) -> None: ...
    def margin(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def movie(self) -> PySide2.QtGui.QMovie: ...
    def openExternalLinks(self) -> bool: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def picture(self) -> PySide2.QtGui.QPicture: ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    def selectedText(self) -> str: ...
    def selectionStart(self) -> int: ...
    def setAlignment(self, arg__1: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setBuddy(self, arg__1: QWidget) -> None: ...
    def setIndent(self, arg__1: int) -> None: ...
    def setMargin(self, arg__1: int) -> None: ...
    def setMovie(self, movie: PySide2.QtGui.QMovie) -> None: ...
    @overload
    def setNum(self, arg__1: float) -> None: ...
    @overload
    def setNum(self, arg__1: int) -> None: ...
    def setOpenExternalLinks(self, open: bool) -> None: ...
    def setPicture(self, arg__1: PySide2.QtGui.QPicture) -> None: ...
    def setPixmap(self, arg__1: typing.Union[PySide2.QtGui.QPixmap,None]) -> None: ...
    def setScaledContents(self, arg__1: bool) -> None: ...
    def setSelection(self, arg__1: int, arg__2: int) -> None: ...
    def setText(self, arg__1: str) -> None: ...
    def setTextFormat(self, arg__1: PySide2.QtCore.Qt.TextFormat) -> None: ...
    def setTextInteractionFlags(self, flags: typing.Union[PySide2.QtCore.Qt.TextInteractionFlags,PySide2.QtCore.Qt.TextInteractionFlag]) -> None: ...
    def setWordWrap(self, on: bool) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def textInteractionFlags(self) -> typing.Union[PySide2.QtCore.Qt.TextInteractionFlags,PySide2.QtCore.Qt.TextInteractionFlag]: ...
    def wordWrap(self) -> bool: ...

class QLayout(PySide2.QtCore.QObject, QLayoutItem):
    class SizeConstraint:
        SetDefaultConstraint: typing.ClassVar[QLayout.SizeConstraint] = ...
        SetFixedSize: typing.ClassVar[QLayout.SizeConstraint] = ...
        SetMaximumSize: typing.ClassVar[QLayout.SizeConstraint] = ...
        SetMinAndMaxSize: typing.ClassVar[QLayout.SizeConstraint] = ...
        SetMinimumSize: typing.ClassVar[QLayout.SizeConstraint] = ...
        SetNoConstraint: typing.ClassVar[QLayout.SizeConstraint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLayout.SizeConstraint: ...
        def __and__(self, other: typing.SupportsInt) -> QLayout.SizeConstraint: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLayout.SizeConstraint: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLayout.SizeConstraint: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLayout.SizeConstraint: ...
        def __rand__(self, other: typing.SupportsInt) -> QLayout.SizeConstraint: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLayout.SizeConstraint: ...
        def __ror__(self, other: typing.SupportsInt) -> QLayout.SizeConstraint: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLayout.SizeConstraint: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLayout.SizeConstraint: ...
        def __sub__(self, other: typing.SupportsInt) -> QLayout.SizeConstraint: ...
        def __xor__(self, other: typing.SupportsInt) -> QLayout.SizeConstraint: ...
    SetDefaultConstraint: typing.ClassVar[QLayout.SizeConstraint] = ...
    SetFixedSize: typing.ClassVar[QLayout.SizeConstraint] = ...
    SetMaximumSize: typing.ClassVar[QLayout.SizeConstraint] = ...
    SetMinAndMaxSize: typing.ClassVar[QLayout.SizeConstraint] = ...
    SetMinimumSize: typing.ClassVar[QLayout.SizeConstraint] = ...
    SetNoConstraint: typing.ClassVar[QLayout.SizeConstraint] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None], destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def activate(self) -> bool: ...
    def addChildLayout(self, l: QLayout) -> None: ...
    def addChildWidget(self, w: QWidget) -> None: ...
    def addItem(self, arg__1: QLayoutItem) -> None: ...
    def addWidget(self, w: QWidget) -> None: ...
    def adoptLayout(self, layout: QLayout) -> bool: ...
    def alignmentRect(self, arg__1: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def childEvent(self, e: PySide2.QtCore.QChildEvent) -> None: ...
    @classmethod
    def closestAcceptableSize(cls, w: QWidget, s: PySide2.QtCore.QSize) -> PySide2.QtCore.QSize: ...
    def contentsMargins(self) -> PySide2.QtCore.QMargins: ...
    def contentsRect(self) -> PySide2.QtCore.QRect: ...
    def controlTypes(self) -> typing.Union[QSizePolicy.ControlTypes,QSizePolicy.ControlType]: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> typing.Union[PySide2.QtCore.Qt.Orientations,PySide2.QtCore.Qt.Orientation]: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def getContentsMargins(self) -> typing.Tuple[int,int,int,int]: ...
    @overload
    def indexOf(self, arg__1: QLayoutItem) -> int: ...
    @overload
    def indexOf(self, arg__1: QWidget) -> int: ...
    def invalidate(self) -> None: ...
    def isEmpty(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def itemAt(self, index: int) -> typing.Optional[QLayoutItem]: ...
    def layout(self) -> QLayout: ...
    def margin(self) -> int: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def menuBar(self) -> QWidget: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def parentWidget(self) -> QWidget: ...
    def removeItem(self, arg__1: QLayoutItem) -> None: ...
    def removeWidget(self, w: QWidget) -> None: ...
    def replaceWidget(self, from_: QWidget, to: QWidget, options: typing.Union[PySide2.QtCore.Qt.FindChildOptions,PySide2.QtCore.Qt.FindChildOption] = ...) -> QLayoutItem: ...
    @overload
    def setAlignment(self, l: QLayout, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> bool: ...
    @overload
    def setAlignment(self, w: QWidget, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> bool: ...
    @overload
    def setAlignment(self, arg__1: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    @overload
    def setContentsMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @overload
    def setContentsMargins(self, margins: PySide2.QtCore.QMargins) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    def setMargin(self, arg__1: int) -> None: ...
    def setMenuBar(self, w: QWidget) -> None: ...
    def setSizeConstraint(self, arg__1: QLayout.SizeConstraint) -> None: ...
    def setSpacing(self, arg__1: int) -> None: ...
    def sizeConstraint(self) -> QLayout.SizeConstraint: ...
    def spacing(self) -> int: ...
    def takeAt(self, index: int) -> typing.Optional[QLayoutItem]: ...
    def totalHeightForWidth(self, w: int) -> int: ...
    def totalMaximumSize(self) -> PySide2.QtCore.QSize: ...
    def totalMinimumSize(self) -> PySide2.QtCore.QSize: ...
    def totalSizeHint(self) -> PySide2.QtCore.QSize: ...
    def update(self) -> None: ...
    def widgetEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...

class QLayoutItem(shiboken2.Object):
    align: typing.Any
    def __init__(self, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    def alignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def controlTypes(self) -> typing.Union[QSizePolicy.ControlTypes,QSizePolicy.ControlType]: ...
    def expandingDirections(self) -> typing.Union[PySide2.QtCore.Qt.Orientations,PySide2.QtCore.Qt.Orientation]: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def invalidate(self) -> None: ...
    def isEmpty(self) -> bool: ...
    def layout(self) -> QLayout: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setAlignment(self, a: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacerItem(self) -> QSpacerItem: ...
    def widget(self) -> QWidget: ...

class QLineEdit(QWidget):
    class ActionPosition:
        LeadingPosition: typing.ClassVar[QLineEdit.ActionPosition] = ...
        TrailingPosition: typing.ClassVar[QLineEdit.ActionPosition] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLineEdit.ActionPosition: ...
        def __and__(self, other: typing.SupportsInt) -> QLineEdit.ActionPosition: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLineEdit.ActionPosition: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLineEdit.ActionPosition: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLineEdit.ActionPosition: ...
        def __rand__(self, other: typing.SupportsInt) -> QLineEdit.ActionPosition: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLineEdit.ActionPosition: ...
        def __ror__(self, other: typing.SupportsInt) -> QLineEdit.ActionPosition: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLineEdit.ActionPosition: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLineEdit.ActionPosition: ...
        def __sub__(self, other: typing.SupportsInt) -> QLineEdit.ActionPosition: ...
        def __xor__(self, other: typing.SupportsInt) -> QLineEdit.ActionPosition: ...

    class EchoMode:
        NoEcho: typing.ClassVar[QLineEdit.EchoMode] = ...
        Normal: typing.ClassVar[QLineEdit.EchoMode] = ...
        Password: typing.ClassVar[QLineEdit.EchoMode] = ...
        PasswordEchoOnEdit: typing.ClassVar[QLineEdit.EchoMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLineEdit.EchoMode: ...
        def __and__(self, other: typing.SupportsInt) -> QLineEdit.EchoMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLineEdit.EchoMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLineEdit.EchoMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLineEdit.EchoMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QLineEdit.EchoMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLineEdit.EchoMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QLineEdit.EchoMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLineEdit.EchoMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLineEdit.EchoMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QLineEdit.EchoMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QLineEdit.EchoMode: ...
    LeadingPosition: typing.ClassVar[QLineEdit.ActionPosition] = ...
    NoEcho: typing.ClassVar[QLineEdit.EchoMode] = ...
    Normal: typing.ClassVar[QLineEdit.EchoMode] = ...
    Password: typing.ClassVar[QLineEdit.EchoMode] = ...
    PasswordEchoOnEdit: typing.ClassVar[QLineEdit.EchoMode] = ...
    TrailingPosition: typing.ClassVar[QLineEdit.ActionPosition] = ...
    cursorPositionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    editingFinished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    inputRejected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    returnPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    selectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    textChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    textEdited: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, arg__1: str, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., acceptableInput: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clearButtonEnabled: bool = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., cursorMoveStyle: PySide2.QtCore.Qt.CursorMoveStyle = ..., cursorPosition: int = ..., cursorPositionChanged: typing.Callable = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., displayText: str = ..., dragEnabled: bool = ..., echoMode: QLineEdit.EchoMode = ..., editingFinished: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frame: bool = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., hasSelectedText: bool = ..., height: int = ..., inputMask: str = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., inputRejected: typing.Callable = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maxLength: int = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., modified: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., placeholderText: str = ..., pos: PySide2.QtCore.QPoint = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., redoAvailable: bool = ..., returnPressed: typing.Callable = ..., selectedText: str = ..., selectionChanged: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., textChanged: typing.Callable = ..., textEdited: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., undoAvailable: bool = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., acceptableInput: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clearButtonEnabled: bool = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., cursorMoveStyle: PySide2.QtCore.Qt.CursorMoveStyle = ..., cursorPosition: int = ..., cursorPositionChanged: typing.Callable = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., displayText: str = ..., dragEnabled: bool = ..., echoMode: QLineEdit.EchoMode = ..., editingFinished: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frame: bool = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., hasSelectedText: bool = ..., height: int = ..., inputMask: str = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., inputRejected: typing.Callable = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maxLength: int = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., modified: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., placeholderText: str = ..., pos: PySide2.QtCore.QPoint = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., redoAvailable: bool = ..., returnPressed: typing.Callable = ..., selectedText: str = ..., selectionChanged: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., textChanged: typing.Callable = ..., textEdited: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., undoAvailable: bool = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def addAction(self, action: QAction, position: QLineEdit.ActionPosition) -> None: ...
    @overload
    def addAction(self, icon: PySide2.QtGui.QIcon, position: QLineEdit.ActionPosition) -> QAction: ...
    @overload
    def addAction(self, action: QAction) -> None: ...
    @overload
    def addAction(self, arg__1: QAction) -> None: ...
    def alignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def backspace(self) -> None: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def completer(self) -> QCompleter: ...
    def contextMenuEvent(self, arg__1: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def copy(self) -> None: ...
    def createStandardContextMenu(self) -> QMenu: ...
    def cursorBackward(self, mark: bool, steps: int = ...) -> None: ...
    def cursorForward(self, mark: bool, steps: int = ...) -> None: ...
    def cursorMoveStyle(self) -> PySide2.QtCore.Qt.CursorMoveStyle: ...
    def cursorPosition(self) -> int: ...
    def cursorPositionAt(self, pos: PySide2.QtCore.QPoint) -> int: ...
    def cursorRect(self) -> PySide2.QtCore.QRect: ...
    def cursorWordBackward(self, mark: bool) -> None: ...
    def cursorWordForward(self, mark: bool) -> None: ...
    def cut(self) -> None: ...
    def del_(self) -> None: ...
    def deselect(self) -> None: ...
    def displayText(self) -> str: ...
    def dragEnabled(self) -> bool: ...
    def dragEnterEvent(self, arg__1: PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, e: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, arg__1: PySide2.QtGui.QDropEvent) -> None: ...
    def echoMode(self) -> QLineEdit.EchoMode: ...
    def end(self, mark: bool) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def getTextMargins(self) -> typing.Tuple[int,int,int,int]: ...
    def hasAcceptableInput(self) -> bool: ...
    def hasFrame(self) -> bool: ...
    def hasSelectedText(self) -> bool: ...
    def home(self, mark: bool) -> None: ...
    def initStyleOption(self, option: QStyleOptionFrame) -> None: ...
    def inputMask(self) -> str: ...
    def inputMethodEvent(self, arg__1: PySide2.QtGui.QInputMethodEvent) -> None: ...
    @overload
    def inputMethodQuery(self, property: PySide2.QtCore.Qt.InputMethodQuery, argument: typing.Any) -> typing.Any: ...
    @overload
    def inputMethodQuery(self, arg__1: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def insert(self, arg__1: str) -> None: ...
    def isClearButtonEnabled(self) -> bool: ...
    def isModified(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def isRedoAvailable(self) -> bool: ...
    def isUndoAvailable(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def maxLength(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def paste(self) -> None: ...
    def placeholderText(self) -> str: ...
    def redo(self) -> None: ...
    def selectAll(self) -> None: ...
    def selectedText(self) -> str: ...
    def selectionEnd(self) -> int: ...
    def selectionLength(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setAlignment(self, flag: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setClearButtonEnabled(self, enable: bool) -> None: ...
    def setCompleter(self, completer: QCompleter) -> None: ...
    def setCursorMoveStyle(self, style: PySide2.QtCore.Qt.CursorMoveStyle) -> None: ...
    def setCursorPosition(self, arg__1: int) -> None: ...
    def setDragEnabled(self, b: bool) -> None: ...
    def setEchoMode(self, arg__1: QLineEdit.EchoMode) -> None: ...
    def setFrame(self, arg__1: bool) -> None: ...
    def setInputMask(self, inputMask: str) -> None: ...
    def setMaxLength(self, arg__1: int) -> None: ...
    def setModified(self, arg__1: bool) -> None: ...
    def setPlaceholderText(self, arg__1: str) -> None: ...
    def setReadOnly(self, arg__1: bool) -> None: ...
    def setSelection(self, arg__1: int, arg__2: int) -> None: ...
    def setText(self, arg__1: str) -> None: ...
    @overload
    def setTextMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @overload
    def setTextMargins(self, margins: PySide2.QtCore.QMargins) -> None: ...
    def setValidator(self, arg__1: PySide2.QtGui.QValidator) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def text(self) -> str: ...
    def textMargins(self) -> PySide2.QtCore.QMargins: ...
    def undo(self) -> None: ...
    def validator(self) -> PySide2.QtGui.QValidator: ...

class QListView(QAbstractItemView):
    class Flow:
        LeftToRight: typing.ClassVar[QListView.Flow] = ...
        TopToBottom: typing.ClassVar[QListView.Flow] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QListView.Flow: ...
        def __and__(self, other: typing.SupportsInt) -> QListView.Flow: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QListView.Flow: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QListView.Flow: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QListView.Flow: ...
        def __rand__(self, other: typing.SupportsInt) -> QListView.Flow: ...
        def __rmul__(self, other: typing.SupportsInt) -> QListView.Flow: ...
        def __ror__(self, other: typing.SupportsInt) -> QListView.Flow: ...
        def __rsub__(self, other: typing.SupportsInt) -> QListView.Flow: ...
        def __rxor__(self, other: typing.SupportsInt) -> QListView.Flow: ...
        def __sub__(self, other: typing.SupportsInt) -> QListView.Flow: ...
        def __xor__(self, other: typing.SupportsInt) -> QListView.Flow: ...

    class LayoutMode:
        Batched: typing.ClassVar[QListView.LayoutMode] = ...
        SinglePass: typing.ClassVar[QListView.LayoutMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QListView.LayoutMode: ...
        def __and__(self, other: typing.SupportsInt) -> QListView.LayoutMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QListView.LayoutMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QListView.LayoutMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QListView.LayoutMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QListView.LayoutMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QListView.LayoutMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QListView.LayoutMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QListView.LayoutMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QListView.LayoutMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QListView.LayoutMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QListView.LayoutMode: ...

    class Movement:
        Free: typing.ClassVar[QListView.Movement] = ...
        Snap: typing.ClassVar[QListView.Movement] = ...
        Static: typing.ClassVar[QListView.Movement] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QListView.Movement: ...
        def __and__(self, other: typing.SupportsInt) -> QListView.Movement: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QListView.Movement: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QListView.Movement: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QListView.Movement: ...
        def __rand__(self, other: typing.SupportsInt) -> QListView.Movement: ...
        def __rmul__(self, other: typing.SupportsInt) -> QListView.Movement: ...
        def __ror__(self, other: typing.SupportsInt) -> QListView.Movement: ...
        def __rsub__(self, other: typing.SupportsInt) -> QListView.Movement: ...
        def __rxor__(self, other: typing.SupportsInt) -> QListView.Movement: ...
        def __sub__(self, other: typing.SupportsInt) -> QListView.Movement: ...
        def __xor__(self, other: typing.SupportsInt) -> QListView.Movement: ...

    class ResizeMode:
        Adjust: typing.ClassVar[QListView.ResizeMode] = ...
        Fixed: typing.ClassVar[QListView.ResizeMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QListView.ResizeMode: ...
        def __and__(self, other: typing.SupportsInt) -> QListView.ResizeMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QListView.ResizeMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QListView.ResizeMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QListView.ResizeMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QListView.ResizeMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QListView.ResizeMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QListView.ResizeMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QListView.ResizeMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QListView.ResizeMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QListView.ResizeMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QListView.ResizeMode: ...

    class ViewMode:
        IconMode: typing.ClassVar[QListView.ViewMode] = ...
        ListMode: typing.ClassVar[QListView.ViewMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QListView.ViewMode: ...
        def __and__(self, other: typing.SupportsInt) -> QListView.ViewMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QListView.ViewMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QListView.ViewMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QListView.ViewMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QListView.ViewMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QListView.ViewMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QListView.ViewMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QListView.ViewMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QListView.ViewMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QListView.ViewMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QListView.ViewMode: ...
    Adjust: typing.ClassVar[QListView.ResizeMode] = ...
    Batched: typing.ClassVar[QListView.LayoutMode] = ...
    Fixed: typing.ClassVar[QListView.ResizeMode] = ...
    Free: typing.ClassVar[QListView.Movement] = ...
    IconMode: typing.ClassVar[QListView.ViewMode] = ...
    LeftToRight: typing.ClassVar[QListView.Flow] = ...
    ListMode: typing.ClassVar[QListView.ViewMode] = ...
    SinglePass: typing.ClassVar[QListView.LayoutMode] = ...
    Snap: typing.ClassVar[QListView.Movement] = ...
    Static: typing.ClassVar[QListView.Movement] = ...
    TopToBottom: typing.ClassVar[QListView.Flow] = ...
    indexesMoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., activated: typing.Callable = ..., alternatingRowColors: bool = ..., autoFillBackground: bool = ..., autoScroll: bool = ..., autoScrollMargin: int = ..., baseSize: PySide2.QtCore.QSize = ..., batchSize: int = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., defaultDropAction: PySide2.QtCore.Qt.DropAction = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., dragDropMode: QListView.DragDropMode = ..., dragDropOverwriteMode: bool = ..., dragEnabled: bool = ..., editTriggers: QListView.EditTriggers = ..., enabled: bool = ..., entered: typing.Callable = ..., flow: QListView.Flow = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QListView.Shadow = ..., frameShape: QListView.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., gridSize: PySide2.QtCore.QSize = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., horizontalScrollMode: QListView.ScrollMode = ..., iconSize: PySide2.QtCore.QSize = ..., iconSizeChanged: typing.Callable = ..., indexesMoved: typing.Callable = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., isWrapping: bool = ..., itemAlignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., layoutMode: QListView.LayoutMode = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., modelColumn: int = ..., mouseTracking: bool = ..., movement: QListView.Movement = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., resizeMode: QListView.ResizeMode = ..., selectionBehavior: QListView.SelectionBehavior = ..., selectionMode: QListView.SelectionMode = ..., selectionRectVisible: bool = ..., showDropIndicator: bool = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QListView.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., spacing: int = ..., statusTip: str = ..., styleSheet: str = ..., tabKeyNavigation: bool = ..., tabletTracking: bool = ..., textElideMode: PySide2.QtCore.Qt.TextElideMode = ..., toolTip: str = ..., toolTipDuration: int = ..., uniformItemSizes: bool = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., verticalScrollMode: QListView.ScrollMode = ..., viewMode: QListView.ViewMode = ..., viewportEntered: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wordWrap: bool = ..., x: int = ..., y: int = ...) -> None: ...
    def batchSize(self) -> int: ...
    def clearPropertyFlags(self) -> None: ...
    def contentsSize(self) -> PySide2.QtCore.QSize: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, previous: PySide2.QtCore.QModelIndex) -> None: ...
    def dataChanged(self, topLeft: PySide2.QtCore.QModelIndex, bottomRight: PySide2.QtCore.QModelIndex, roles: typing.List[int] = ...) -> None: ...
    def doItemsLayout(self) -> None: ...
    def dragLeaveEvent(self, e: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, e: PySide2.QtGui.QDropEvent) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def flow(self) -> QListView.Flow: ...
    def gridSize(self) -> PySide2.QtCore.QSize: ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isRowHidden(self, row: int) -> bool: ...
    def isSelectionRectVisible(self) -> bool: ...
    def isWrapping(self) -> bool: ...
    def itemAlignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def layoutMode(self) -> QListView.LayoutMode: ...
    def modelColumn(self) -> int: ...
    def mouseMoveEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, cursorAction: QAbstractItemView.CursorAction, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> PySide2.QtCore.QModelIndex: ...
    def movement(self) -> QListView.Movement: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def rectForIndex(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def reset(self) -> None: ...
    def resizeContents(self, width: int, height: int) -> None: ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent) -> None: ...
    def resizeMode(self) -> QListView.ResizeMode: ...
    def rowsAboutToBeRemoved(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int) -> None: ...
    def rowsInserted(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectedIndexes(self) -> typing.List[PySide2.QtCore.QModelIndex]: ...
    def selectionChanged(self, selected: PySide2.QtCore.QItemSelection, deselected: PySide2.QtCore.QItemSelection) -> None: ...
    def setBatchSize(self, batchSize: int) -> None: ...
    def setFlow(self, flow: QListView.Flow) -> None: ...
    def setGridSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setItemAlignment(self, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setLayoutMode(self, mode: QListView.LayoutMode) -> None: ...
    def setModelColumn(self, column: int) -> None: ...
    def setMovement(self, movement: QListView.Movement) -> None: ...
    def setPositionForIndex(self, position: PySide2.QtCore.QPoint, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setResizeMode(self, mode: QListView.ResizeMode) -> None: ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setRowHidden(self, row: int, hide: bool) -> None: ...
    def setSelection(self, rect: PySide2.QtCore.QRect, command: typing.Union[PySide2.QtCore.QItemSelectionModel.SelectionFlags,PySide2.QtCore.QItemSelectionModel.SelectionFlag]) -> None: ...
    def setSelectionRectVisible(self, show: bool) -> None: ...
    def setSpacing(self, space: int) -> None: ...
    def setUniformItemSizes(self, enable: bool) -> None: ...
    def setViewMode(self, mode: QListView.ViewMode) -> None: ...
    def setWordWrap(self, on: bool) -> None: ...
    def setWrapping(self, enable: bool) -> None: ...
    def spacing(self) -> int: ...
    def startDrag(self, supportedActions: typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction]) -> None: ...
    def timerEvent(self, e: PySide2.QtCore.QTimerEvent) -> None: ...
    def uniformItemSizes(self) -> bool: ...
    def updateGeometries(self) -> None: ...
    def verticalOffset(self) -> int: ...
    def viewMode(self) -> QListView.ViewMode: ...
    def viewOptions(self) -> QStyleOptionViewItem: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...
    def wheelEvent(self, e: PySide2.QtGui.QWheelEvent) -> None: ...
    def wordWrap(self) -> bool: ...

class QListWidget(QListView):
    currentItemChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    currentRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    currentTextChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    itemActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    itemChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    itemClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    itemDoubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    itemEntered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    itemPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    itemSelectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., activated: typing.Callable = ..., alternatingRowColors: bool = ..., autoFillBackground: bool = ..., autoScroll: bool = ..., autoScrollMargin: int = ..., baseSize: PySide2.QtCore.QSize = ..., batchSize: int = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., count: int = ..., currentItemChanged: typing.Callable = ..., currentRow: int = ..., currentRowChanged: typing.Callable = ..., currentTextChanged: typing.Callable = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., defaultDropAction: PySide2.QtCore.Qt.DropAction = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., dragDropMode: QListWidget.DragDropMode = ..., dragDropOverwriteMode: bool = ..., dragEnabled: bool = ..., editTriggers: QListWidget.EditTriggers = ..., enabled: bool = ..., entered: typing.Callable = ..., flow: QListWidget.Flow = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QListWidget.Shadow = ..., frameShape: QListWidget.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., gridSize: PySide2.QtCore.QSize = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., horizontalScrollMode: QListWidget.ScrollMode = ..., iconSize: PySide2.QtCore.QSize = ..., iconSizeChanged: typing.Callable = ..., indexesMoved: typing.Callable = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., isWrapping: bool = ..., itemActivated: typing.Callable = ..., itemAlignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., itemChanged: typing.Callable = ..., itemClicked: typing.Callable = ..., itemDoubleClicked: typing.Callable = ..., itemEntered: typing.Callable = ..., itemPressed: typing.Callable = ..., itemSelectionChanged: typing.Callable = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., layoutMode: QListWidget.LayoutMode = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., modelColumn: int = ..., mouseTracking: bool = ..., movement: QListWidget.Movement = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., resizeMode: QListWidget.ResizeMode = ..., selectionBehavior: QListWidget.SelectionBehavior = ..., selectionMode: QListWidget.SelectionMode = ..., selectionRectVisible: bool = ..., showDropIndicator: bool = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QListWidget.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., sortingEnabled: bool = ..., spacing: int = ..., statusTip: str = ..., styleSheet: str = ..., tabKeyNavigation: bool = ..., tabletTracking: bool = ..., textElideMode: PySide2.QtCore.Qt.TextElideMode = ..., toolTip: str = ..., toolTipDuration: int = ..., uniformItemSizes: bool = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., verticalScrollMode: QListWidget.ScrollMode = ..., viewMode: QListWidget.ViewMode = ..., viewportEntered: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wordWrap: bool = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def addItem(self, item: QListWidgetItem) -> None: ...
    @overload
    def addItem(self, label: str) -> None: ...
    def addItems(self, labels: typing.Iterable[str]) -> None: ...
    def clear(self) -> None: ...
    @overload
    def closePersistentEditor(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    @overload
    def closePersistentEditor(self, item: QListWidgetItem) -> None: ...
    def count(self) -> int: ...
    def currentItem(self) -> QListWidgetItem: ...
    def currentRow(self) -> int: ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent) -> None: ...
    def dropMimeData(self, index: int, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction) -> bool: ...
    def editItem(self, item: QListWidgetItem) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def findItems(self, text: str, flags: typing.Union[PySide2.QtCore.Qt.MatchFlags,PySide2.QtCore.Qt.MatchFlag]) -> typing.List[QListWidgetItem]: ...
    def indexFromItem(self, item: QListWidgetItem) -> PySide2.QtCore.QModelIndex: ...
    @overload
    def insertItem(self, row: int, item: QListWidgetItem) -> None: ...
    @overload
    def insertItem(self, row: int, label: str) -> None: ...
    def insertItems(self, row: int, labels: typing.Iterable[str]) -> None: ...
    def isItemHidden(self, item: QListWidgetItem) -> bool: ...
    def isItemSelected(self, item: QListWidgetItem) -> bool: ...
    @overload
    def isPersistentEditorOpen(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @overload
    def isPersistentEditorOpen(self, item: QListWidgetItem) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def item(self, row: int) -> QListWidgetItem: ...
    @overload
    def itemAt(self, x: int, y: int) -> QListWidgetItem: ...
    @overload
    def itemAt(self, p: PySide2.QtCore.QPoint) -> QListWidgetItem: ...
    def itemFromIndex(self, index: PySide2.QtCore.QModelIndex) -> QListWidgetItem: ...
    def itemWidget(self, item: QListWidgetItem) -> QWidget: ...
    def items(self, data: PySide2.QtCore.QMimeData) -> typing.List[QListWidgetItem]: ...
    def mimeData(self, items: typing.Iterable[QListWidgetItem]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    @overload
    def openPersistentEditor(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    @overload
    def openPersistentEditor(self, item: QListWidgetItem) -> None: ...
    def removeItemWidget(self, item: QListWidgetItem) -> None: ...
    def row(self, item: QListWidgetItem) -> int: ...
    def scrollToItem(self, item: QListWidgetItem, hint: QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectedItems(self) -> typing.List[QListWidgetItem]: ...
    @overload
    def setCurrentItem(self, item: QListWidgetItem, command: typing.Union[PySide2.QtCore.QItemSelectionModel.SelectionFlags,PySide2.QtCore.QItemSelectionModel.SelectionFlag]) -> None: ...
    @overload
    def setCurrentItem(self, item: QListWidgetItem) -> None: ...
    @overload
    def setCurrentRow(self, row: int, command: typing.Union[PySide2.QtCore.QItemSelectionModel.SelectionFlags,PySide2.QtCore.QItemSelectionModel.SelectionFlag]) -> None: ...
    @overload
    def setCurrentRow(self, row: int) -> None: ...
    def setItemHidden(self, item: QListWidgetItem, hide: bool) -> None: ...
    def setItemSelected(self, item: QListWidgetItem, select: bool) -> None: ...
    def setItemWidget(self, item: QListWidgetItem, widget: QWidget) -> None: ...
    def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel) -> None: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def sortItems(self, order: PySide2.QtCore.Qt.SortOrder = ...) -> None: ...
    def supportedDropActions(self) -> typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction]: ...
    def takeItem(self, row: int) -> QListWidgetItem: ...
    def visualItemRect(self, item: QListWidgetItem) -> PySide2.QtCore.QRect: ...

class QListWidgetItem(shiboken2.Object):
    class ItemType:
        Type: typing.ClassVar[QListWidgetItem.ItemType] = ...
        UserType: typing.ClassVar[QListWidgetItem.ItemType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QListWidgetItem.ItemType: ...
        def __and__(self, other: typing.SupportsInt) -> QListWidgetItem.ItemType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QListWidgetItem.ItemType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QListWidgetItem.ItemType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QListWidgetItem.ItemType: ...
        def __rand__(self, other: typing.SupportsInt) -> QListWidgetItem.ItemType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QListWidgetItem.ItemType: ...
        def __ror__(self, other: typing.SupportsInt) -> QListWidgetItem.ItemType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QListWidgetItem.ItemType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QListWidgetItem.ItemType: ...
        def __sub__(self, other: typing.SupportsInt) -> QListWidgetItem.ItemType: ...
        def __xor__(self, other: typing.SupportsInt) -> QListWidgetItem.ItemType: ...
    Type: typing.ClassVar[QListWidgetItem.ItemType] = ...
    UserType: typing.ClassVar[QListWidgetItem.ItemType] = ...
    @overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, listview: typing.Union[QListWidget,None] = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, text: str, listview: typing.Union[QListWidget,None] = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, listview: typing.Union[QListWidget,None] = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, other: QListWidgetItem) -> None: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def checkState(self) -> PySide2.QtCore.Qt.CheckState: ...
    def clone(self) -> QListWidgetItem: ...
    def data(self, role: PySide2.QtCore.Qt.ItemDataRole) -> typing.Any: ...
    def flags(self) -> typing.Union[PySide2.QtCore.Qt.ItemFlags,PySide2.QtCore.Qt.ItemFlag]: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def foreground(self) -> PySide2.QtGui.QBrush: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def isHidden(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def listWidget(self) -> QListWidget: ...
    def read(self, in_: PySide2.QtCore.QDataStream) -> None: ...
    def setBackground(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
    def setBackgroundColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setCheckState(self, state: PySide2.QtCore.Qt.CheckState) -> None: ...
    def setData(self, role: PySide2.QtCore.Qt.ItemDataRole, value: typing.Any) -> None: ...
    def setFlags(self, flags: typing.Union[PySide2.QtCore.Qt.ItemFlags,PySide2.QtCore.Qt.ItemFlag]) -> None: ...
    def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
    def setForeground(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
    def setHidden(self, hide: bool) -> None: ...
    def setIcon(self, icon: PySide2.QtGui.QIcon) -> None: ...
    def setSelected(self, select: bool) -> None: ...
    def setSizeHint(self, size: PySide2.QtCore.QSize) -> None: ...
    def setStatusTip(self, statusTip: str) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextAlignment(self, alignment: int) -> None: ...
    def setTextColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setToolTip(self, toolTip: str) -> None: ...
    def setWhatsThis(self, whatsThis: str) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def statusTip(self) -> str: ...
    def text(self) -> str: ...
    def textAlignment(self) -> int: ...
    def textColor(self) -> PySide2.QtGui.QColor: ...
    def toolTip(self) -> str: ...
    def type(self) -> int: ...
    def whatsThis(self) -> str: ...
    def write(self, out: PySide2.QtCore.QDataStream) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, out: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, in_: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QMainWindow(QWidget):
    class DockOption:
        AllowNestedDocks: typing.ClassVar[QMainWindow.DockOption] = ...
        AllowTabbedDocks: typing.ClassVar[QMainWindow.DockOption] = ...
        AnimatedDocks: typing.ClassVar[QMainWindow.DockOption] = ...
        ForceTabbedDocks: typing.ClassVar[QMainWindow.DockOption] = ...
        GroupedDragging: typing.ClassVar[QMainWindow.DockOption] = ...
        VerticalTabs: typing.ClassVar[QMainWindow.DockOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QMainWindow.DockOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QMainWindow.DockOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMainWindow.DockOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QMainWindow.DockOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QMainWindow.DockOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMainWindow.DockOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QMainWindow.DockOptions: ...

    class DockOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QMainWindow.DockOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QMainWindow.DockOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMainWindow.DockOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QMainWindow.DockOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QMainWindow.DockOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMainWindow.DockOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QMainWindow.DockOptions: ...
    AllowNestedDocks: typing.ClassVar[QMainWindow.DockOption] = ...
    AllowTabbedDocks: typing.ClassVar[QMainWindow.DockOption] = ...
    AnimatedDocks: typing.ClassVar[QMainWindow.DockOption] = ...
    ForceTabbedDocks: typing.ClassVar[QMainWindow.DockOption] = ...
    GroupedDragging: typing.ClassVar[QMainWindow.DockOption] = ...
    VerticalTabs: typing.ClassVar[QMainWindow.DockOption] = ...
    iconSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    tabifiedDockWidgetActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    toolButtonStyleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., animated: bool = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., dockNestingEnabled: bool = ..., dockOptions: typing.Union[QMainWindow.DockOptions,QMainWindow.DockOption] = ..., documentMode: bool = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., iconSize: PySide2.QtCore.QSize = ..., iconSizeChanged: typing.Callable = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabShape: typing.Any = ..., tabifiedDockWidgetActivated: typing.Callable = ..., tabletTracking: bool = ..., toolButtonStyle: PySide2.QtCore.Qt.ToolButtonStyle = ..., toolButtonStyleChanged: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., unifiedTitleAndToolBarOnMac: bool = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def addDockWidget(self, area: PySide2.QtCore.Qt.DockWidgetArea, dockwidget: QDockWidget, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    @overload
    def addDockWidget(self, area: PySide2.QtCore.Qt.DockWidgetArea, dockwidget: QDockWidget) -> None: ...
    @overload
    def addToolBar(self, area: PySide2.QtCore.Qt.ToolBarArea, toolbar: QToolBar) -> None: ...
    @overload
    def addToolBar(self, title: str) -> QToolBar: ...
    @overload
    def addToolBar(self, toolbar: QToolBar) -> None: ...
    def addToolBarBreak(self, area: PySide2.QtCore.Qt.ToolBarArea = ...) -> None: ...
    def centralWidget(self) -> QWidget: ...
    def contextMenuEvent(self, event: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def corner(self, corner: PySide2.QtCore.Qt.Corner) -> PySide2.QtCore.Qt.DockWidgetArea: ...
    def createPopupMenu(self) -> QMenu: ...
    def dockOptions(self) -> typing.Union[QMainWindow.DockOptions,QMainWindow.DockOption]: ...
    def dockWidgetArea(self, dockwidget: QDockWidget) -> PySide2.QtCore.Qt.DockWidgetArea: ...
    def documentMode(self) -> bool: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def insertToolBar(self, before: QToolBar, toolbar: QToolBar) -> None: ...
    def insertToolBarBreak(self, before: QToolBar) -> None: ...
    def isAnimated(self) -> bool: ...
    def isDockNestingEnabled(self) -> bool: ...
    def isSeparator(self, pos: PySide2.QtCore.QPoint) -> bool: ...
    def menuBar(self) -> QMenuBar: ...
    def menuWidget(self) -> QWidget: ...
    def removeDockWidget(self, dockwidget: QDockWidget) -> None: ...
    def removeToolBar(self, toolbar: QToolBar) -> None: ...
    def removeToolBarBreak(self, before: QToolBar) -> None: ...
    def resizeDocks(self, docks: typing.Iterable[QDockWidget], sizes: typing.Iterable[int], orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def restoreDockWidget(self, dockwidget: QDockWidget) -> bool: ...
    def restoreState(self, state: typing.Union[PySide2.QtCore.QByteArray,bytes], version: int = ...) -> bool: ...
    def saveState(self, version: int = ...) -> PySide2.QtCore.QByteArray: ...
    def setAnimated(self, enabled: bool) -> None: ...
    def setCentralWidget(self, widget: QWidget) -> None: ...
    def setCorner(self, corner: PySide2.QtCore.Qt.Corner, area: PySide2.QtCore.Qt.DockWidgetArea) -> None: ...
    def setDockNestingEnabled(self, enabled: bool) -> None: ...
    def setDockOptions(self, options: typing.Union[QMainWindow.DockOptions,QMainWindow.DockOption]) -> None: ...
    def setDocumentMode(self, enabled: bool) -> None: ...
    def setIconSize(self, iconSize: PySide2.QtCore.QSize) -> None: ...
    def setMenuBar(self, menubar: QMenuBar) -> None: ...
    def setMenuWidget(self, menubar: QWidget) -> None: ...
    def setStatusBar(self, statusbar: QStatusBar) -> None: ...
    def setTabPosition(self, areas: typing.Union[PySide2.QtCore.Qt.DockWidgetAreas,PySide2.QtCore.Qt.DockWidgetArea], tabPosition: QTabWidget.TabPosition) -> None: ...
    def setTabShape(self, tabShape: QTabWidget.TabShape) -> None: ...
    def setToolButtonStyle(self, toolButtonStyle: PySide2.QtCore.Qt.ToolButtonStyle) -> None: ...
    def setUnifiedTitleAndToolBarOnMac(self, set: bool) -> None: ...
    def splitDockWidget(self, after: QDockWidget, dockwidget: QDockWidget, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def statusBar(self) -> QStatusBar: ...
    def tabPosition(self, area: PySide2.QtCore.Qt.DockWidgetArea) -> QTabWidget.TabPosition: ...
    def tabShape(self) -> QTabWidget.TabShape: ...
    def tabifiedDockWidgets(self, dockwidget: QDockWidget) -> typing.List[QDockWidget]: ...
    def tabifyDockWidget(self, first: QDockWidget, second: QDockWidget) -> None: ...
    def takeCentralWidget(self) -> QWidget: ...
    def toolBarArea(self, toolbar: QToolBar) -> PySide2.QtCore.Qt.ToolBarArea: ...
    def toolBarBreak(self, toolbar: QToolBar) -> bool: ...
    def toolButtonStyle(self) -> PySide2.QtCore.Qt.ToolButtonStyle: ...
    def unifiedTitleAndToolBarOnMac(self) -> bool: ...

class QMdiArea(QAbstractScrollArea):
    class AreaOption:
        DontMaximizeSubWindowOnActivation: typing.ClassVar[QMdiArea.AreaOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QMdiArea.AreaOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QMdiArea.AreaOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMdiArea.AreaOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QMdiArea.AreaOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QMdiArea.AreaOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMdiArea.AreaOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QMdiArea.AreaOptions: ...

    class AreaOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QMdiArea.AreaOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QMdiArea.AreaOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMdiArea.AreaOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QMdiArea.AreaOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QMdiArea.AreaOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMdiArea.AreaOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QMdiArea.AreaOptions: ...

    class ViewMode:
        SubWindowView: typing.ClassVar[QMdiArea.ViewMode] = ...
        TabbedView: typing.ClassVar[QMdiArea.ViewMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMdiArea.ViewMode: ...
        def __and__(self, other: typing.SupportsInt) -> QMdiArea.ViewMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMdiArea.ViewMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMdiArea.ViewMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QMdiArea.ViewMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QMdiArea.ViewMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMdiArea.ViewMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QMdiArea.ViewMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMdiArea.ViewMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMdiArea.ViewMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QMdiArea.ViewMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QMdiArea.ViewMode: ...

    class WindowOrder:
        ActivationHistoryOrder: typing.ClassVar[QMdiArea.WindowOrder] = ...
        CreationOrder: typing.ClassVar[QMdiArea.WindowOrder] = ...
        StackingOrder: typing.ClassVar[QMdiArea.WindowOrder] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMdiArea.WindowOrder: ...
        def __and__(self, other: typing.SupportsInt) -> QMdiArea.WindowOrder: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMdiArea.WindowOrder: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMdiArea.WindowOrder: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QMdiArea.WindowOrder: ...
        def __rand__(self, other: typing.SupportsInt) -> QMdiArea.WindowOrder: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMdiArea.WindowOrder: ...
        def __ror__(self, other: typing.SupportsInt) -> QMdiArea.WindowOrder: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMdiArea.WindowOrder: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMdiArea.WindowOrder: ...
        def __sub__(self, other: typing.SupportsInt) -> QMdiArea.WindowOrder: ...
        def __xor__(self, other: typing.SupportsInt) -> QMdiArea.WindowOrder: ...
    ActivationHistoryOrder: typing.ClassVar[QMdiArea.WindowOrder] = ...
    CreationOrder: typing.ClassVar[QMdiArea.WindowOrder] = ...
    DontMaximizeSubWindowOnActivation: typing.ClassVar[QMdiArea.AreaOption] = ...
    StackingOrder: typing.ClassVar[QMdiArea.WindowOrder] = ...
    SubWindowView: typing.ClassVar[QMdiArea.ViewMode] = ...
    TabbedView: typing.ClassVar[QMdiArea.ViewMode] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    subWindowActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., activationOrder: QMdiArea.WindowOrder = ..., autoFillBackground: bool = ..., background: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., documentMode: bool = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QMdiArea.Shadow = ..., frameShape: QMdiArea.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QMdiArea.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., subWindowActivated: typing.Callable = ..., tabPosition: typing.Any = ..., tabShape: typing.Any = ..., tabletTracking: bool = ..., tabsClosable: bool = ..., tabsMovable: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., viewMode: QMdiArea.ViewMode = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def activateNextSubWindow(self) -> None: ...
    def activatePreviousSubWindow(self) -> None: ...
    def activationOrder(self) -> QMdiArea.WindowOrder: ...
    def activeSubWindow(self) -> QMdiSubWindow: ...
    def addSubWindow(self, widget: QWidget, flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ...) -> QMdiSubWindow: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def cascadeSubWindows(self) -> None: ...
    def childEvent(self, childEvent: PySide2.QtCore.QChildEvent) -> None: ...
    def closeActiveSubWindow(self) -> None: ...
    def closeAllSubWindows(self) -> None: ...
    def currentSubWindow(self) -> QMdiSubWindow: ...
    def documentMode(self) -> bool: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, paintEvent: PySide2.QtGui.QPaintEvent) -> None: ...
    def removeSubWindow(self, widget: QWidget) -> None: ...
    def resizeEvent(self, resizeEvent: PySide2.QtGui.QResizeEvent) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def setActivationOrder(self, order: QMdiArea.WindowOrder) -> None: ...
    def setActiveSubWindow(self, window: QMdiSubWindow) -> None: ...
    def setBackground(self, background: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
    def setDocumentMode(self, enabled: bool) -> None: ...
    def setOption(self, option: QMdiArea.AreaOption, on: bool = ...) -> None: ...
    def setTabPosition(self, position: QTabWidget.TabPosition) -> None: ...
    def setTabShape(self, shape: QTabWidget.TabShape) -> None: ...
    def setTabsClosable(self, closable: bool) -> None: ...
    def setTabsMovable(self, movable: bool) -> None: ...
    def setViewMode(self, mode: QMdiArea.ViewMode) -> None: ...
    def setupViewport(self, viewport: QWidget) -> None: ...
    def showEvent(self, showEvent: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def subWindowList(self, order: QMdiArea.WindowOrder = ...) -> typing.List[QMdiSubWindow]: ...
    def tabPosition(self) -> QTabWidget.TabPosition: ...
    def tabShape(self) -> QTabWidget.TabShape: ...
    def tabsClosable(self) -> bool: ...
    def tabsMovable(self) -> bool: ...
    def testOption(self, opton: QMdiArea.AreaOption) -> bool: ...
    def tileSubWindows(self) -> None: ...
    def timerEvent(self, timerEvent: PySide2.QtCore.QTimerEvent) -> None: ...
    def viewMode(self) -> QMdiArea.ViewMode: ...
    def viewportEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...

class QMdiSubWindow(QWidget):
    class SubWindowOption:
        AllowOutsideAreaHorizontally: typing.ClassVar[QMdiSubWindow.SubWindowOption] = ...
        AllowOutsideAreaVertically: typing.ClassVar[QMdiSubWindow.SubWindowOption] = ...
        RubberBandMove: typing.ClassVar[QMdiSubWindow.SubWindowOption] = ...
        RubberBandResize: typing.ClassVar[QMdiSubWindow.SubWindowOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QMdiSubWindow.SubWindowOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QMdiSubWindow.SubWindowOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMdiSubWindow.SubWindowOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QMdiSubWindow.SubWindowOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QMdiSubWindow.SubWindowOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMdiSubWindow.SubWindowOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QMdiSubWindow.SubWindowOptions: ...

    class SubWindowOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QMdiSubWindow.SubWindowOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QMdiSubWindow.SubWindowOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMdiSubWindow.SubWindowOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QMdiSubWindow.SubWindowOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QMdiSubWindow.SubWindowOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMdiSubWindow.SubWindowOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QMdiSubWindow.SubWindowOptions: ...
    AllowOutsideAreaHorizontally: typing.ClassVar[QMdiSubWindow.SubWindowOption] = ...
    AllowOutsideAreaVertically: typing.ClassVar[QMdiSubWindow.SubWindowOption] = ...
    RubberBandMove: typing.ClassVar[QMdiSubWindow.SubWindowOption] = ...
    RubberBandResize: typing.ClassVar[QMdiSubWindow.SubWindowOption] = ...
    aboutToActivate: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    windowStateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., aboutToActivate: typing.Callable = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., keyboardPageStep: int = ..., keyboardSingleStep: int = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowStateChanged: typing.Callable = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def changeEvent(self, changeEvent: PySide2.QtCore.QEvent) -> None: ...
    def childEvent(self, childEvent: PySide2.QtCore.QChildEvent) -> None: ...
    def closeEvent(self, closeEvent: PySide2.QtGui.QCloseEvent) -> None: ...
    def contextMenuEvent(self, contextMenuEvent: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, focusInEvent: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, focusOutEvent: PySide2.QtGui.QFocusEvent) -> None: ...
    def hideEvent(self, hideEvent: PySide2.QtGui.QHideEvent) -> None: ...
    def isShaded(self) -> bool: ...
    def keyPressEvent(self, keyEvent: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyboardPageStep(self) -> int: ...
    def keyboardSingleStep(self) -> int: ...
    def leaveEvent(self, leaveEvent: PySide2.QtCore.QEvent) -> None: ...
    def maximizedButtonsWidget(self) -> QWidget: ...
    def maximizedSystemMenuIconWidget(self) -> QWidget: ...
    def mdiArea(self) -> QMdiArea: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveEvent(self, moveEvent: PySide2.QtGui.QMoveEvent) -> None: ...
    def paintEvent(self, paintEvent: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, resizeEvent: PySide2.QtGui.QResizeEvent) -> None: ...
    def setKeyboardPageStep(self, step: int) -> None: ...
    def setKeyboardSingleStep(self, step: int) -> None: ...
    def setOption(self, option: QMdiSubWindow.SubWindowOption, on: bool = ...) -> None: ...
    def setSystemMenu(self, systemMenu: QMenu) -> None: ...
    def setWidget(self, widget: QWidget) -> None: ...
    def showEvent(self, showEvent: PySide2.QtGui.QShowEvent) -> None: ...
    def showShaded(self) -> None: ...
    def showSystemMenu(self) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def systemMenu(self) -> QMenu: ...
    def testOption(self, arg__1: QMdiSubWindow.SubWindowOption) -> bool: ...
    def timerEvent(self, timerEvent: PySide2.QtCore.QTimerEvent) -> None: ...
    def widget(self) -> QWidget: ...

class QMenu(QWidget):
    aboutToHide: typing.ClassVar[PySide2.QtCore.Signal] = ...
    aboutToShow: typing.ClassVar[PySide2.QtCore.Signal] = ...
    hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    triggered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, title: str, parent: typing.Union[QWidget,None] = ..., aboutToHide: typing.Callable = ..., aboutToShow: typing.Callable = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., hovered: typing.Callable = ..., icon: PySide2.QtGui.QIcon = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., separatorsCollapsible: bool = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., tearOffEnabled: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., toolTipsVisible: bool = ..., triggered: typing.Callable = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., aboutToHide: typing.Callable = ..., aboutToShow: typing.Callable = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., hovered: typing.Callable = ..., icon: PySide2.QtGui.QIcon = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., separatorsCollapsible: bool = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., tearOffEnabled: bool = ..., title: str = ..., toolTip: str = ..., toolTipDuration: int = ..., toolTipsVisible: bool = ..., triggered: typing.Callable = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def actionAt(self, arg__1: PySide2.QtCore.QPoint) -> QAction: ...
    def actionEvent(self, arg__1: PySide2.QtGui.QActionEvent) -> None: ...
    def actionGeometry(self, arg__1: QAction) -> PySide2.QtCore.QRect: ...
    def activeAction(self) -> QAction: ...
    @overload
    def addAction(self, icon: PySide2.QtGui.QIcon, text: str, receiver: PySide2.QtCore.QObject, member: bytes, shortcut: typing.Union[PySide2.QtGui.QKeySequence,str,None] = ...) -> QAction: ...
    @overload
    def addAction(self, arg__1: PySide2.QtGui.QIcon, arg__2: str, arg__3: typing.Callable[[],typing.Any], arg__4: typing.Union[PySide2.QtGui.QKeySequence,str,None] = ...) -> None: ...
    @overload
    def addAction(self, text: str, receiver: PySide2.QtCore.QObject, member: bytes, shortcut: typing.Union[PySide2.QtGui.QKeySequence,str,None] = ...) -> QAction: ...
    @overload
    def addAction(self, arg__1: str, arg__2: typing.Callable[[],typing.Any], arg__3: typing.Union[PySide2.QtGui.QKeySequence,str,None] = ...) -> None: ...
    @overload
    def addAction(self, icon: PySide2.QtGui.QIcon, text: str) -> QAction: ...
    @overload
    def addAction(self, arg__1: QAction) -> None: ...
    @overload
    def addAction(self, text: str) -> QAction: ...
    @overload
    def addMenu(self, icon: PySide2.QtGui.QIcon, title: str) -> QMenu: ...
    @overload
    def addMenu(self, menu: QMenu) -> QAction: ...
    @overload
    def addMenu(self, title: str) -> QMenu: ...
    @overload
    def addSection(self, icon: PySide2.QtGui.QIcon, text: str) -> QAction: ...
    @overload
    def addSection(self, text: str) -> QAction: ...
    def addSeparator(self) -> QAction: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def columnCount(self) -> int: ...
    def defaultAction(self) -> QAction: ...
    def enterEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    @overload
    def exec_(self, pos: PySide2.QtCore.QPoint, at: typing.Union[QAction,None] = ...) -> QAction: ...
    @overload
    def exec_(self) -> QAction: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def hideEvent(self, arg__1: PySide2.QtGui.QHideEvent) -> None: ...
    def hideTearOffMenu(self) -> None: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def initStyleOption(self, option: QStyleOptionMenuItem, action: QAction) -> None: ...
    def insertMenu(self, before: QAction, menu: QMenu) -> QAction: ...
    @overload
    def insertSection(self, before: QAction, icon: PySide2.QtGui.QIcon, text: str) -> QAction: ...
    @overload
    def insertSection(self, before: QAction, text: str) -> QAction: ...
    def insertSeparator(self, before: QAction) -> QAction: ...
    def isEmpty(self) -> bool: ...
    def isTearOffEnabled(self) -> bool: ...
    def isTearOffMenuVisible(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def leaveEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def menuAction(self) -> QAction: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def popup(self, pos: PySide2.QtCore.QPoint, at: typing.Union[QAction,None] = ...) -> None: ...
    def separatorsCollapsible(self) -> bool: ...
    def setActiveAction(self, act: QAction) -> None: ...
    def setAsDockMenu(self) -> None: ...
    def setDefaultAction(self, arg__1: QAction) -> None: ...
    def setIcon(self, icon: PySide2.QtGui.QIcon) -> None: ...
    def setSeparatorsCollapsible(self, collapse: bool) -> None: ...
    def setTearOffEnabled(self, arg__1: bool) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def setToolTipsVisible(self, visible: bool) -> None: ...
    @overload
    def showTearOffMenu(self, pos: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def showTearOffMenu(self) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent) -> None: ...
    def title(self) -> str: ...
    def toolTipsVisible(self) -> bool: ...
    def wheelEvent(self, arg__1: PySide2.QtGui.QWheelEvent) -> None: ...

class QMenuBar(QWidget):
    hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    triggered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., defaultUp: bool = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., hovered: typing.Callable = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., nativeMenuBar: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., triggered: typing.Callable = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def actionAt(self, arg__1: PySide2.QtCore.QPoint) -> QAction: ...
    def actionEvent(self, arg__1: PySide2.QtGui.QActionEvent) -> None: ...
    def actionGeometry(self, arg__1: QAction) -> PySide2.QtCore.QRect: ...
    def activeAction(self) -> QAction: ...
    @overload
    def addAction(self, text: str, receiver: PySide2.QtCore.QObject, member: bytes) -> QAction: ...
    @overload
    def addAction(self, arg__1: str, arg__2: typing.Callable[[],typing.Any]) -> None: ...
    @overload
    def addAction(self, arg__1: QAction) -> None: ...
    @overload
    def addAction(self, text: str) -> QAction: ...
    @overload
    def addMenu(self, icon: PySide2.QtGui.QIcon, title: str) -> QMenu: ...
    @overload
    def addMenu(self, menu: QMenu) -> QAction: ...
    @overload
    def addMenu(self, title: str) -> QMenu: ...
    def addSeparator(self) -> QAction: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def cornerWidget(self, corner: PySide2.QtCore.Qt.Corner = ...) -> QWidget: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def initStyleOption(self, option: QStyleOptionMenuItem, action: QAction) -> None: ...
    def insertMenu(self, before: QAction, menu: QMenu) -> QAction: ...
    def insertSeparator(self, before: QAction) -> QAction: ...
    def isDefaultUp(self) -> bool: ...
    def isNativeMenuBar(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def leaveEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def setActiveAction(self, action: QAction) -> None: ...
    def setCornerWidget(self, w: QWidget, corner: PySide2.QtCore.Qt.Corner = ...) -> None: ...
    def setDefaultUp(self, arg__1: bool) -> None: ...
    def setNativeMenuBar(self, nativeMenuBar: bool) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent) -> None: ...

class QMessageBox(QDialog):
    class ButtonRole:
        AcceptRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
        ActionRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
        ApplyRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
        DestructiveRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
        HelpRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
        InvalidRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
        NRoles: typing.ClassVar[QMessageBox.ButtonRole] = ...
        NoRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
        RejectRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
        ResetRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
        YesRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMessageBox.ButtonRole: ...
        def __and__(self, other: typing.SupportsInt) -> QMessageBox.ButtonRole: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMessageBox.ButtonRole: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMessageBox.ButtonRole: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QMessageBox.ButtonRole: ...
        def __rand__(self, other: typing.SupportsInt) -> QMessageBox.ButtonRole: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMessageBox.ButtonRole: ...
        def __ror__(self, other: typing.SupportsInt) -> QMessageBox.ButtonRole: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMessageBox.ButtonRole: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMessageBox.ButtonRole: ...
        def __sub__(self, other: typing.SupportsInt) -> QMessageBox.ButtonRole: ...
        def __xor__(self, other: typing.SupportsInt) -> QMessageBox.ButtonRole: ...

    class Icon:
        Critical: typing.ClassVar[QMessageBox.Icon] = ...
        Information: typing.ClassVar[QMessageBox.Icon] = ...
        NoIcon: typing.ClassVar[QMessageBox.Icon] = ...
        Question: typing.ClassVar[QMessageBox.Icon] = ...
        Warning: typing.ClassVar[QMessageBox.Icon] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMessageBox.Icon: ...
        def __and__(self, other: typing.SupportsInt) -> QMessageBox.Icon: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMessageBox.Icon: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMessageBox.Icon: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QMessageBox.Icon: ...
        def __rand__(self, other: typing.SupportsInt) -> QMessageBox.Icon: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMessageBox.Icon: ...
        def __ror__(self, other: typing.SupportsInt) -> QMessageBox.Icon: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMessageBox.Icon: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMessageBox.Icon: ...
        def __sub__(self, other: typing.SupportsInt) -> QMessageBox.Icon: ...
        def __xor__(self, other: typing.SupportsInt) -> QMessageBox.Icon: ...

    class StandardButton:
        Abort: typing.ClassVar[QMessageBox.StandardButton] = ...
        Apply: typing.ClassVar[QMessageBox.StandardButton] = ...
        ButtonMask: typing.ClassVar[QMessageBox.StandardButton] = ...
        Cancel: typing.ClassVar[QMessageBox.StandardButton] = ...
        Close: typing.ClassVar[QMessageBox.StandardButton] = ...
        Default: typing.ClassVar[QMessageBox.StandardButton] = ...
        Discard: typing.ClassVar[QMessageBox.StandardButton] = ...
        Escape: typing.ClassVar[QMessageBox.StandardButton] = ...
        FirstButton: typing.ClassVar[QMessageBox.StandardButton] = ...
        FlagMask: typing.ClassVar[QMessageBox.StandardButton] = ...
        Help: typing.ClassVar[QMessageBox.StandardButton] = ...
        Ignore: typing.ClassVar[QMessageBox.StandardButton] = ...
        LastButton: typing.ClassVar[QMessageBox.StandardButton] = ...
        No: typing.ClassVar[QMessageBox.StandardButton] = ...
        NoAll: typing.ClassVar[QMessageBox.StandardButton] = ...
        NoButton: typing.ClassVar[QMessageBox.StandardButton] = ...
        NoToAll: typing.ClassVar[QMessageBox.StandardButton] = ...
        Ok: typing.ClassVar[QMessageBox.StandardButton] = ...
        Open: typing.ClassVar[QMessageBox.StandardButton] = ...
        Reset: typing.ClassVar[QMessageBox.StandardButton] = ...
        RestoreDefaults: typing.ClassVar[QMessageBox.StandardButton] = ...
        Retry: typing.ClassVar[QMessageBox.StandardButton] = ...
        Save: typing.ClassVar[QMessageBox.StandardButton] = ...
        SaveAll: typing.ClassVar[QMessageBox.StandardButton] = ...
        Yes: typing.ClassVar[QMessageBox.StandardButton] = ...
        YesAll: typing.ClassVar[QMessageBox.StandardButton] = ...
        YesToAll: typing.ClassVar[QMessageBox.StandardButton] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QMessageBox.StandardButtons: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QMessageBox.StandardButtons: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMessageBox.StandardButtons: ...
        def __rand__(self, other: typing.SupportsInt) -> QMessageBox.StandardButtons: ...
        def __ror__(self, other: typing.SupportsInt) -> QMessageBox.StandardButtons: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMessageBox.StandardButtons: ...
        def __xor__(self, other: typing.SupportsInt) -> QMessageBox.StandardButtons: ...

    class StandardButtons:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QMessageBox.StandardButtons: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QMessageBox.StandardButtons: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMessageBox.StandardButtons: ...
        def __rand__(self, other: typing.SupportsInt) -> QMessageBox.StandardButtons: ...
        def __ror__(self, other: typing.SupportsInt) -> QMessageBox.StandardButtons: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMessageBox.StandardButtons: ...
        def __xor__(self, other: typing.SupportsInt) -> QMessageBox.StandardButtons: ...
    Abort: typing.ClassVar[QMessageBox.StandardButton] = ...
    AcceptRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
    ActionRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
    Apply: typing.ClassVar[QMessageBox.StandardButton] = ...
    ApplyRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
    ButtonMask: typing.ClassVar[QMessageBox.StandardButton] = ...
    Cancel: typing.ClassVar[QMessageBox.StandardButton] = ...
    Close: typing.ClassVar[QMessageBox.StandardButton] = ...
    Critical: typing.ClassVar[QMessageBox.Icon] = ...
    Default: typing.ClassVar[QMessageBox.StandardButton] = ...
    DestructiveRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
    Discard: typing.ClassVar[QMessageBox.StandardButton] = ...
    Escape: typing.ClassVar[QMessageBox.StandardButton] = ...
    FirstButton: typing.ClassVar[QMessageBox.StandardButton] = ...
    FlagMask: typing.ClassVar[QMessageBox.StandardButton] = ...
    Help: typing.ClassVar[QMessageBox.StandardButton] = ...
    HelpRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
    Ignore: typing.ClassVar[QMessageBox.StandardButton] = ...
    Information: typing.ClassVar[QMessageBox.Icon] = ...
    InvalidRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
    LastButton: typing.ClassVar[QMessageBox.StandardButton] = ...
    NRoles: typing.ClassVar[QMessageBox.ButtonRole] = ...
    No: typing.ClassVar[QMessageBox.StandardButton] = ...
    NoAll: typing.ClassVar[QMessageBox.StandardButton] = ...
    NoButton: typing.ClassVar[QMessageBox.StandardButton] = ...
    NoIcon: typing.ClassVar[QMessageBox.Icon] = ...
    NoRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
    NoToAll: typing.ClassVar[QMessageBox.StandardButton] = ...
    Ok: typing.ClassVar[QMessageBox.StandardButton] = ...
    Open: typing.ClassVar[QMessageBox.StandardButton] = ...
    Question: typing.ClassVar[QMessageBox.Icon] = ...
    RejectRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
    Reset: typing.ClassVar[QMessageBox.StandardButton] = ...
    ResetRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
    RestoreDefaults: typing.ClassVar[QMessageBox.StandardButton] = ...
    Retry: typing.ClassVar[QMessageBox.StandardButton] = ...
    Save: typing.ClassVar[QMessageBox.StandardButton] = ...
    SaveAll: typing.ClassVar[QMessageBox.StandardButton] = ...
    Warning: typing.ClassVar[QMessageBox.Icon] = ...
    Yes: typing.ClassVar[QMessageBox.StandardButton] = ...
    YesAll: typing.ClassVar[QMessageBox.StandardButton] = ...
    YesRole: typing.ClassVar[QMessageBox.ButtonRole] = ...
    YesToAll: typing.ClassVar[QMessageBox.StandardButton] = ...
    buttonClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, icon: QMessageBox.Icon, title: str, text: str, buttons: typing.Union[QMessageBox.StandardButtons,QMessageBox.StandardButton] = ..., parent: typing.Union[QWidget,None] = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., buttonClicked: typing.Callable = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., detailedText: str = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., iconPixmap: PySide2.QtGui.QPixmap = ..., informativeText: str = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., standardButtons: typing.Union[QMessageBox.StandardButtons,QMessageBox.StandardButton] = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., textFormat: PySide2.QtCore.Qt.TextFormat = ..., textInteractionFlags: typing.Union[PySide2.QtCore.Qt.TextInteractionFlags,PySide2.QtCore.Qt.TextInteractionFlag] = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., buttonClicked: typing.Callable = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., detailedText: str = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., icon: QMessageBox.Icon = ..., iconPixmap: PySide2.QtGui.QPixmap = ..., informativeText: str = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., standardButtons: typing.Union[QMessageBox.StandardButtons,QMessageBox.StandardButton] = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., textFormat: PySide2.QtCore.Qt.TextFormat = ..., textInteractionFlags: typing.Union[PySide2.QtCore.Qt.TextInteractionFlags,PySide2.QtCore.Qt.TextInteractionFlag] = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @classmethod
    def about(cls, parent: typing.Union[QWidget,None], title: str, text: str) -> None: ...
    @classmethod
    def aboutQt(cls, parent: typing.Union[QWidget,None], title: str = ...) -> None: ...
    @overload
    def addButton(self, button: QAbstractButton, role: QMessageBox.ButtonRole) -> None: ...
    @overload
    def addButton(self, text: str, role: QMessageBox.ButtonRole) -> QPushButton: ...
    @overload
    def addButton(self, button: QMessageBox.StandardButton) -> QPushButton: ...
    def button(self, which: QMessageBox.StandardButton) -> QAbstractButton: ...
    def buttonRole(self, button: QAbstractButton) -> QMessageBox.ButtonRole: ...
    def buttonText(self, button: int) -> str: ...
    def buttons(self) -> typing.List[QAbstractButton]: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def checkBox(self) -> QCheckBox: ...
    def clickedButton(self) -> QAbstractButton: ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent) -> None: ...
    @overload
    @classmethod
    def critical(cls, parent: typing.Union[QWidget,None], title: str, text: str, button0: QMessageBox.StandardButton, button1: QMessageBox.StandardButton) -> int: ...
    @overload
    @classmethod
    def critical(cls, parent: typing.Union[QWidget,None], title: str, text: str, buttons: typing.Union[QMessageBox.StandardButtons,QMessageBox.StandardButton] = ..., defaultButton: QMessageBox.StandardButton = ...) -> QMessageBox.StandardButton: ...
    def defaultButton(self) -> QPushButton: ...
    def detailedText(self) -> str: ...
    def escapeButton(self) -> QAbstractButton: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def icon(self) -> QMessageBox.Icon: ...
    def iconPixmap(self) -> PySide2.QtGui.QPixmap: ...
    @overload
    @classmethod
    def information(cls, parent: typing.Union[QWidget,None], title: str, text: str, button0: QMessageBox.StandardButton, button1: QMessageBox.StandardButton = ...) -> QMessageBox.StandardButton: ...
    @overload
    @classmethod
    def information(cls, parent: typing.Union[QWidget,None], title: str, text: str, buttons: typing.Union[QMessageBox.StandardButtons,QMessageBox.StandardButton] = ..., defaultButton: QMessageBox.StandardButton = ...) -> QMessageBox.StandardButton: ...
    def informativeText(self) -> str: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    @overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    @overload
    def open(self) -> None: ...
    @overload
    @classmethod
    def question(cls, parent: typing.Union[QWidget,None], title: str, text: str, button0: QMessageBox.StandardButton, button1: QMessageBox.StandardButton) -> int: ...
    @overload
    @classmethod
    def question(cls, parent: typing.Union[QWidget,None], title: str, text: str, buttons: typing.Union[QMessageBox.StandardButtons,QMessageBox.StandardButton] = ..., defaultButton: QMessageBox.StandardButton = ...) -> QMessageBox.StandardButton: ...
    def removeButton(self, button: QAbstractButton) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def setButtonText(self, button: int, text: str) -> None: ...
    def setCheckBox(self, cb: QCheckBox) -> None: ...
    @overload
    def setDefaultButton(self, button: QMessageBox.StandardButton) -> None: ...
    @overload
    def setDefaultButton(self, button: QPushButton) -> None: ...
    def setDetailedText(self, text: str) -> None: ...
    @overload
    def setEscapeButton(self, button: QAbstractButton) -> None: ...
    @overload
    def setEscapeButton(self, button: QMessageBox.StandardButton) -> None: ...
    def setIcon(self, arg__1: QMessageBox.Icon) -> None: ...
    def setIconPixmap(self, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    def setInformativeText(self, text: str) -> None: ...
    def setStandardButtons(self, buttons: typing.Union[QMessageBox.StandardButtons,QMessageBox.StandardButton]) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextFormat(self, format: PySide2.QtCore.Qt.TextFormat) -> None: ...
    def setTextInteractionFlags(self, flags: typing.Union[PySide2.QtCore.Qt.TextInteractionFlags,PySide2.QtCore.Qt.TextInteractionFlag]) -> None: ...
    def setWindowModality(self, windowModality: PySide2.QtCore.Qt.WindowModality) -> None: ...
    def setWindowTitle(self, title: str) -> None: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
    def standardButton(self, button: QAbstractButton) -> QMessageBox.StandardButton: ...
    def standardButtons(self) -> typing.Union[QMessageBox.StandardButtons,QMessageBox.StandardButton]: ...
    @classmethod
    def standardIcon(cls, icon: QMessageBox.Icon) -> PySide2.QtGui.QPixmap: ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def textInteractionFlags(self) -> typing.Union[PySide2.QtCore.Qt.TextInteractionFlags,PySide2.QtCore.Qt.TextInteractionFlag]: ...
    @overload
    @classmethod
    def warning(cls, parent: typing.Union[QWidget,None], title: str, text: str, button0: QMessageBox.StandardButton, button1: QMessageBox.StandardButton) -> int: ...
    @overload
    @classmethod
    def warning(cls, parent: typing.Union[QWidget,None], title: str, text: str, buttons: typing.Union[QMessageBox.StandardButtons,QMessageBox.StandardButton] = ..., defaultButton: QMessageBox.StandardButton = ...) -> QMessageBox.StandardButton: ...

class QMouseEventTransition(PySide2.QtCore.QEventTransition):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, object: PySide2.QtCore.QObject, type: PySide2.QtCore.QEvent.Type, button: PySide2.QtCore.Qt.MouseButton, sourceState: typing.Union[PySide2.QtCore.QState,None] = ..., destroyed: typing.Callable = ..., eventSource: PySide2.QtCore.QObject = ..., eventType: typing.Any = ..., modifierMask: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier] = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., targetState: typing.Any = ..., targetStateChanged: typing.Callable = ..., targetStates: typing.Any = ..., targetStatesChanged: typing.Callable = ..., transitionType: QMouseEventTransition.TransitionType = ..., triggered: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, sourceState: typing.Union[PySide2.QtCore.QState,None] = ..., button: PySide2.QtCore.Qt.MouseButton = ..., destroyed: typing.Callable = ..., eventSource: PySide2.QtCore.QObject = ..., eventType: typing.Any = ..., modifierMask: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier] = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., targetState: typing.Any = ..., targetStateChanged: typing.Callable = ..., targetStates: typing.Any = ..., targetStatesChanged: typing.Callable = ..., transitionType: QMouseEventTransition.TransitionType = ..., triggered: typing.Callable = ...) -> None: ...
    def button(self) -> PySide2.QtCore.Qt.MouseButton: ...
    def eventTest(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def hitTestPath(self) -> PySide2.QtGui.QPainterPath: ...
    def modifierMask(self) -> typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]: ...
    def onTransition(self, event: PySide2.QtCore.QEvent) -> None: ...
    def setButton(self, button: PySide2.QtCore.Qt.MouseButton) -> None: ...
    def setHitTestPath(self, path: PySide2.QtGui.QPainterPath) -> None: ...
    def setModifierMask(self, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> None: ...

class QOpenGLWidget(QWidget):
    class UpdateBehavior:
        NoPartialUpdate: typing.ClassVar[QOpenGLWidget.UpdateBehavior] = ...
        PartialUpdate: typing.ClassVar[QOpenGLWidget.UpdateBehavior] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLWidget.UpdateBehavior: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLWidget.UpdateBehavior: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLWidget.UpdateBehavior: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLWidget.UpdateBehavior: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLWidget.UpdateBehavior: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLWidget.UpdateBehavior: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLWidget.UpdateBehavior: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLWidget.UpdateBehavior: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLWidget.UpdateBehavior: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLWidget.UpdateBehavior: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLWidget.UpdateBehavior: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLWidget.UpdateBehavior: ...
    NoPartialUpdate: typing.ClassVar[QOpenGLWidget.UpdateBehavior] = ...
    PartialUpdate: typing.ClassVar[QOpenGLWidget.UpdateBehavior] = ...
    aboutToCompose: typing.ClassVar[PySide2.QtCore.Signal] = ...
    aboutToResize: typing.ClassVar[PySide2.QtCore.Signal] = ...
    frameSwapped: typing.ClassVar[PySide2.QtCore.Signal] = ...
    resized: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., f: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., aboutToCompose: typing.Callable = ..., aboutToResize: typing.Callable = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., frameSwapped: typing.Callable = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., resized: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def context(self) -> PySide2.QtGui.QOpenGLContext: ...
    def defaultFramebufferObject(self) -> int: ...
    def doneCurrent(self) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def format(self) -> PySide2.QtGui.QSurfaceFormat: ...
    def grabFramebuffer(self) -> PySide2.QtGui.QImage: ...
    def initializeGL(self) -> None: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self) -> None: ...
    def metric(self, metric: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def paintGL(self) -> None: ...
    def redirected(self, p: PySide2.QtCore.QPoint) -> PySide2.QtGui.QPaintDevice: ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent) -> None: ...
    def resizeGL(self, w: int, h: int) -> None: ...
    def setFormat(self, format: PySide2.QtGui.QSurfaceFormat) -> None: ...
    def setTextureFormat(self, texFormat: int) -> None: ...
    def setUpdateBehavior(self, updateBehavior: QOpenGLWidget.UpdateBehavior) -> None: ...
    def textureFormat(self) -> int: ...
    def updateBehavior(self) -> QOpenGLWidget.UpdateBehavior: ...

class QPanGesture(QGesture):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., acceleration: float = ..., delta: PySide2.QtCore.QPointF = ..., destroyed: typing.Callable = ..., gestureCancelPolicy: typing.Any = ..., gestureType: PySide2.QtCore.Qt.GestureType = ..., hasHotSpot: bool = ..., horizontalVelocity: float = ..., hotSpot: PySide2.QtCore.QPointF = ..., lastOffset: PySide2.QtCore.QPointF = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., offset: PySide2.QtCore.QPointF = ..., state: PySide2.QtCore.Qt.GestureState = ..., verticalVelocity: float = ...) -> None: ...
    def acceleration(self) -> float: ...
    def delta(self) -> PySide2.QtCore.QPointF: ...
    def lastOffset(self) -> PySide2.QtCore.QPointF: ...
    def offset(self) -> PySide2.QtCore.QPointF: ...
    def setAcceleration(self, value: float) -> None: ...
    def setLastOffset(self, value: PySide2.QtCore.QPointF) -> None: ...
    def setOffset(self, value: PySide2.QtCore.QPointF) -> None: ...

class QPinchGesture(QGesture):
    class ChangeFlag:
        CenterPointChanged: typing.ClassVar[QPinchGesture.ChangeFlag] = ...
        RotationAngleChanged: typing.ClassVar[QPinchGesture.ChangeFlag] = ...
        ScaleFactorChanged: typing.ClassVar[QPinchGesture.ChangeFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QPinchGesture.ChangeFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QPinchGesture.ChangeFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPinchGesture.ChangeFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QPinchGesture.ChangeFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QPinchGesture.ChangeFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPinchGesture.ChangeFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QPinchGesture.ChangeFlags: ...

    class ChangeFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QPinchGesture.ChangeFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QPinchGesture.ChangeFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPinchGesture.ChangeFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QPinchGesture.ChangeFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QPinchGesture.ChangeFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPinchGesture.ChangeFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QPinchGesture.ChangeFlags: ...
    CenterPointChanged: typing.ClassVar[QPinchGesture.ChangeFlag] = ...
    RotationAngleChanged: typing.ClassVar[QPinchGesture.ChangeFlag] = ...
    ScaleFactorChanged: typing.ClassVar[QPinchGesture.ChangeFlag] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., centerPoint: PySide2.QtCore.QPointF = ..., changeFlags: typing.Union[QPinchGesture.ChangeFlags,QPinchGesture.ChangeFlag] = ..., destroyed: typing.Callable = ..., gestureCancelPolicy: typing.Any = ..., gestureType: PySide2.QtCore.Qt.GestureType = ..., hasHotSpot: bool = ..., hotSpot: PySide2.QtCore.QPointF = ..., lastCenterPoint: PySide2.QtCore.QPointF = ..., lastRotationAngle: float = ..., lastScaleFactor: float = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rotationAngle: float = ..., scaleFactor: float = ..., startCenterPoint: PySide2.QtCore.QPointF = ..., state: PySide2.QtCore.Qt.GestureState = ..., totalChangeFlags: typing.Union[QPinchGesture.ChangeFlags,QPinchGesture.ChangeFlag] = ..., totalRotationAngle: float = ..., totalScaleFactor: float = ...) -> None: ...
    def centerPoint(self) -> PySide2.QtCore.QPointF: ...
    def changeFlags(self) -> typing.Union[QPinchGesture.ChangeFlags,QPinchGesture.ChangeFlag]: ...
    def lastCenterPoint(self) -> PySide2.QtCore.QPointF: ...
    def lastRotationAngle(self) -> float: ...
    def lastScaleFactor(self) -> float: ...
    def rotationAngle(self) -> float: ...
    def scaleFactor(self) -> float: ...
    def setCenterPoint(self, value: PySide2.QtCore.QPointF) -> None: ...
    def setChangeFlags(self, value: typing.Union[QPinchGesture.ChangeFlags,QPinchGesture.ChangeFlag]) -> None: ...
    def setLastCenterPoint(self, value: PySide2.QtCore.QPointF) -> None: ...
    def setLastRotationAngle(self, value: float) -> None: ...
    def setLastScaleFactor(self, value: float) -> None: ...
    def setRotationAngle(self, value: float) -> None: ...
    def setScaleFactor(self, value: float) -> None: ...
    def setStartCenterPoint(self, value: PySide2.QtCore.QPointF) -> None: ...
    def setTotalChangeFlags(self, value: typing.Union[QPinchGesture.ChangeFlags,QPinchGesture.ChangeFlag]) -> None: ...
    def setTotalRotationAngle(self, value: float) -> None: ...
    def setTotalScaleFactor(self, value: float) -> None: ...
    def startCenterPoint(self) -> PySide2.QtCore.QPointF: ...
    def totalChangeFlags(self) -> typing.Union[QPinchGesture.ChangeFlags,QPinchGesture.ChangeFlag]: ...
    def totalRotationAngle(self) -> float: ...
    def totalScaleFactor(self) -> float: ...

class QPlainTextDocumentLayout(PySide2.QtGui.QAbstractTextDocumentLayout):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, document: PySide2.QtGui.QTextDocument, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def blockBoundingRect(self, block: PySide2.QtGui.QTextBlock) -> PySide2.QtCore.QRectF: ...
    def cursorWidth(self) -> int: ...
    def documentChanged(self, from_: int, arg__2: int, charsAdded: int) -> None: ...
    def documentSize(self) -> PySide2.QtCore.QSizeF: ...
    def draw(self, arg__1: PySide2.QtGui.QPainter, arg__2: PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext) -> None: ...
    def ensureBlockLayout(self, block: PySide2.QtGui.QTextBlock) -> None: ...
    def frameBoundingRect(self, arg__1: PySide2.QtGui.QTextFrame) -> PySide2.QtCore.QRectF: ...
    def hitTest(self, arg__1: PySide2.QtCore.QPointF, arg__2: PySide2.QtCore.Qt.HitTestAccuracy) -> int: ...
    def pageCount(self) -> int: ...
    def requestUpdate(self) -> None: ...
    def setCursorWidth(self, width: int) -> None: ...

class QPlainTextEdit(QAbstractScrollArea):
    class LineWrapMode:
        NoWrap: typing.ClassVar[QPlainTextEdit.LineWrapMode] = ...
        WidgetWidth: typing.ClassVar[QPlainTextEdit.LineWrapMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPlainTextEdit.LineWrapMode: ...
        def __and__(self, other: typing.SupportsInt) -> QPlainTextEdit.LineWrapMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPlainTextEdit.LineWrapMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPlainTextEdit.LineWrapMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPlainTextEdit.LineWrapMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QPlainTextEdit.LineWrapMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPlainTextEdit.LineWrapMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QPlainTextEdit.LineWrapMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPlainTextEdit.LineWrapMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPlainTextEdit.LineWrapMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QPlainTextEdit.LineWrapMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QPlainTextEdit.LineWrapMode: ...
    NoWrap: typing.ClassVar[QPlainTextEdit.LineWrapMode] = ...
    WidgetWidth: typing.ClassVar[QPlainTextEdit.LineWrapMode] = ...
    blockCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    copyAvailable: typing.ClassVar[PySide2.QtCore.Signal] = ...
    cursorPositionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    modificationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    redoAvailable: typing.ClassVar[PySide2.QtCore.Signal] = ...
    selectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    textChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    undoAvailable: typing.ClassVar[PySide2.QtCore.Signal] = ...
    updateRequest: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, text: str, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., backgroundVisible: bool = ..., baseSize: PySide2.QtCore.QSize = ..., blockCount: int = ..., blockCountChanged: typing.Callable = ..., centerOnScroll: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., copyAvailable: typing.Callable = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., cursorPositionChanged: typing.Callable = ..., cursorWidth: int = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., documentTitle: str = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QPlainTextEdit.Shadow = ..., frameShape: QPlainTextEdit.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., lineWrapMode: QPlainTextEdit.LineWrapMode = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumBlockCount: int = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., modificationChanged: typing.Callable = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., overwriteMode: bool = ..., palette: PySide2.QtGui.QPalette = ..., placeholderText: str = ..., plainText: str = ..., pos: PySide2.QtCore.QPoint = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., redoAvailable: typing.Callable = ..., selectionChanged: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QPlainTextEdit.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabChangesFocus: bool = ..., tabStopDistance: float = ..., tabStopWidth: int = ..., tabletTracking: bool = ..., textChanged: typing.Callable = ..., textInteractionFlags: typing.Union[PySide2.QtCore.Qt.TextInteractionFlags,PySide2.QtCore.Qt.TextInteractionFlag] = ..., toolTip: str = ..., toolTipDuration: int = ..., undoAvailable: typing.Callable = ..., undoRedoEnabled: bool = ..., updateRequest: typing.Callable = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., backgroundVisible: bool = ..., baseSize: PySide2.QtCore.QSize = ..., blockCount: int = ..., blockCountChanged: typing.Callable = ..., centerOnScroll: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., copyAvailable: typing.Callable = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., cursorPositionChanged: typing.Callable = ..., cursorWidth: int = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., documentTitle: str = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QPlainTextEdit.Shadow = ..., frameShape: QPlainTextEdit.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., lineWrapMode: QPlainTextEdit.LineWrapMode = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumBlockCount: int = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., modificationChanged: typing.Callable = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., overwriteMode: bool = ..., palette: PySide2.QtGui.QPalette = ..., placeholderText: str = ..., plainText: str = ..., pos: PySide2.QtCore.QPoint = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., redoAvailable: typing.Callable = ..., selectionChanged: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QPlainTextEdit.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabChangesFocus: bool = ..., tabStopDistance: float = ..., tabStopWidth: int = ..., tabletTracking: bool = ..., textChanged: typing.Callable = ..., textInteractionFlags: typing.Union[PySide2.QtCore.Qt.TextInteractionFlags,PySide2.QtCore.Qt.TextInteractionFlag] = ..., toolTip: str = ..., toolTipDuration: int = ..., undoAvailable: typing.Callable = ..., undoRedoEnabled: bool = ..., updateRequest: typing.Callable = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def anchorAt(self, pos: PySide2.QtCore.QPoint) -> str: ...
    def appendHtml(self, html: str) -> None: ...
    def appendPlainText(self, text: str) -> None: ...
    def backgroundVisible(self) -> bool: ...
    def blockBoundingGeometry(self, block: PySide2.QtGui.QTextBlock) -> PySide2.QtCore.QRectF: ...
    def blockBoundingRect(self, block: PySide2.QtGui.QTextBlock) -> PySide2.QtCore.QRectF: ...
    def blockCount(self) -> int: ...
    def canInsertFromMimeData(self, source: PySide2.QtCore.QMimeData) -> bool: ...
    def canPaste(self) -> bool: ...
    def centerCursor(self) -> None: ...
    def centerOnScroll(self) -> bool: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def contentOffset(self) -> PySide2.QtCore.QPointF: ...
    def contextMenuEvent(self, e: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def copy(self) -> None: ...
    def createMimeDataFromSelection(self) -> PySide2.QtCore.QMimeData: ...
    @overload
    def createStandardContextMenu(self, position: PySide2.QtCore.QPoint) -> QMenu: ...
    @overload
    def createStandardContextMenu(self) -> QMenu: ...
    def currentCharFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def cursorForPosition(self, pos: PySide2.QtCore.QPoint) -> PySide2.QtGui.QTextCursor: ...
    @overload
    def cursorRect(self, cursor: PySide2.QtGui.QTextCursor) -> PySide2.QtCore.QRect: ...
    @overload
    def cursorRect(self) -> PySide2.QtCore.QRect: ...
    def cursorWidth(self) -> int: ...
    def cut(self) -> None: ...
    def doSetTextCursor(self, cursor: PySide2.QtGui.QTextCursor) -> None: ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def documentTitle(self) -> str: ...
    def dragEnterEvent(self, e: PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, e: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, e: PySide2.QtGui.QDropEvent) -> None: ...
    def ensureCursorVisible(self) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def extraSelections(self) -> typing.List[QTextEdit.ExtraSelection]: ...
    @overload
    def find(self, exp: PySide2.QtCore.QRegExp, options: typing.Union[PySide2.QtGui.QTextDocument.FindFlags,PySide2.QtGui.QTextDocument.FindFlag] = ...) -> bool: ...
    @overload
    def find(self, exp: PySide2.QtCore.QRegularExpression, options: typing.Union[PySide2.QtGui.QTextDocument.FindFlags,PySide2.QtGui.QTextDocument.FindFlag] = ...) -> bool: ...
    @overload
    def find(self, exp: str, options: typing.Union[PySide2.QtGui.QTextDocument.FindFlags,PySide2.QtGui.QTextDocument.FindFlag] = ...) -> bool: ...
    def firstVisibleBlock(self) -> PySide2.QtGui.QTextBlock: ...
    def focusInEvent(self, e: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, e: PySide2.QtGui.QFocusEvent) -> None: ...
    def getPaintContext(self) -> PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext: ...
    def inputMethodEvent(self, arg__1: PySide2.QtGui.QInputMethodEvent) -> None: ...
    @overload
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery, argument: typing.Any) -> typing.Any: ...
    @overload
    def inputMethodQuery(self, property: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def insertFromMimeData(self, source: PySide2.QtCore.QMimeData) -> None: ...
    def insertPlainText(self, text: str) -> None: ...
    def isReadOnly(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def keyPressEvent(self, e: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, e: PySide2.QtGui.QKeyEvent) -> None: ...
    def lineWrapMode(self) -> QPlainTextEdit.LineWrapMode: ...
    def loadResource(self, type: int, name: PySide2.QtCore.QUrl) -> typing.Any: ...
    def maximumBlockCount(self) -> int: ...
    def mergeCurrentCharFormat(self, modifier: PySide2.QtGui.QTextCharFormat) -> None: ...
    def mouseDoubleClickEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, operation: PySide2.QtGui.QTextCursor.MoveOperation, mode: PySide2.QtGui.QTextCursor.MoveMode = ...) -> None: ...
    def overwriteMode(self) -> bool: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def paste(self) -> None: ...
    def placeholderText(self) -> str: ...
    def print_(self, printer: PySide2.QtGui.QPagedPaintDevice) -> None: ...
    def redo(self) -> None: ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def selectAll(self) -> None: ...
    def setBackgroundVisible(self, visible: bool) -> None: ...
    def setCenterOnScroll(self, enabled: bool) -> None: ...
    def setCurrentCharFormat(self, format: PySide2.QtGui.QTextCharFormat) -> None: ...
    def setCursorWidth(self, width: int) -> None: ...
    def setDocument(self, document: PySide2.QtGui.QTextDocument) -> None: ...
    def setDocumentTitle(self, title: str) -> None: ...
    def setExtraSelections(self, selections: typing.Iterable[QTextEdit.ExtraSelection]) -> None: ...
    def setLineWrapMode(self, mode: QPlainTextEdit.LineWrapMode) -> None: ...
    def setMaximumBlockCount(self, maximum: int) -> None: ...
    def setOverwriteMode(self, overwrite: bool) -> None: ...
    def setPlaceholderText(self, placeholderText: str) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def setReadOnly(self, ro: bool) -> None: ...
    def setTabChangesFocus(self, b: bool) -> None: ...
    def setTabStopDistance(self, distance: float) -> None: ...
    def setTabStopWidth(self, width: int) -> None: ...
    def setTextCursor(self, cursor: PySide2.QtGui.QTextCursor) -> None: ...
    def setTextInteractionFlags(self, flags: typing.Union[PySide2.QtCore.Qt.TextInteractionFlags,PySide2.QtCore.Qt.TextInteractionFlag]) -> None: ...
    def setUndoRedoEnabled(self, enable: bool) -> None: ...
    def setWordWrapMode(self, policy: PySide2.QtGui.QTextOption.WrapMode) -> None: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent) -> None: ...
    def tabChangesFocus(self) -> bool: ...
    def tabStopDistance(self) -> float: ...
    def tabStopWidth(self) -> int: ...
    def textCursor(self) -> PySide2.QtGui.QTextCursor: ...
    def textInteractionFlags(self) -> typing.Union[PySide2.QtCore.Qt.TextInteractionFlags,PySide2.QtCore.Qt.TextInteractionFlag]: ...
    def timerEvent(self, e: PySide2.QtCore.QTimerEvent) -> None: ...
    def toPlainText(self) -> str: ...
    def undo(self) -> None: ...
    def wheelEvent(self, e: PySide2.QtGui.QWheelEvent) -> None: ...
    def wordWrapMode(self) -> PySide2.QtGui.QTextOption.WrapMode: ...
    def zoomIn(self, range: int = ...) -> None: ...
    def zoomInF(self, range: float) -> None: ...
    def zoomOut(self, range: int = ...) -> None: ...

class QProgressBar(QWidget):
    class Direction:
        BottomToTop: typing.ClassVar[QProgressBar.Direction] = ...
        TopToBottom: typing.ClassVar[QProgressBar.Direction] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QProgressBar.Direction: ...
        def __and__(self, other: typing.SupportsInt) -> QProgressBar.Direction: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QProgressBar.Direction: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QProgressBar.Direction: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QProgressBar.Direction: ...
        def __rand__(self, other: typing.SupportsInt) -> QProgressBar.Direction: ...
        def __rmul__(self, other: typing.SupportsInt) -> QProgressBar.Direction: ...
        def __ror__(self, other: typing.SupportsInt) -> QProgressBar.Direction: ...
        def __rsub__(self, other: typing.SupportsInt) -> QProgressBar.Direction: ...
        def __rxor__(self, other: typing.SupportsInt) -> QProgressBar.Direction: ...
        def __sub__(self, other: typing.SupportsInt) -> QProgressBar.Direction: ...
        def __xor__(self, other: typing.SupportsInt) -> QProgressBar.Direction: ...
    BottomToTop: typing.ClassVar[QProgressBar.Direction] = ...
    TopToBottom: typing.ClassVar[QProgressBar.Direction] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., format: str = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., invertedAppearance: bool = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximum: int = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimum: int = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., textDirection: QProgressBar.Direction = ..., textVisible: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., value: int = ..., valueChanged: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def alignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def format(self) -> str: ...
    def initStyleOption(self, option: QStyleOptionProgressBar) -> None: ...
    def invertedAppearance(self) -> bool: ...
    def isTextVisible(self) -> bool: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def reset(self) -> None: ...
    def resetFormat(self) -> None: ...
    def setAlignment(self, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setFormat(self, format: str) -> None: ...
    def setInvertedAppearance(self, invert: bool) -> None: ...
    def setMaximum(self, maximum: int) -> None: ...
    def setMinimum(self, minimum: int) -> None: ...
    def setOrientation(self, arg__1: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setRange(self, minimum: int, maximum: int) -> None: ...
    def setTextDirection(self, textDirection: QProgressBar.Direction) -> None: ...
    def setTextVisible(self, visible: bool) -> None: ...
    def setValue(self, value: int) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def text(self) -> str: ...
    def textDirection(self) -> QProgressBar.Direction: ...
    def value(self) -> int: ...

class QProgressDialog(QDialog):
    canceled: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, labelText: str, cancelButtonText: str, minimum: int, maximum: int, parent: typing.Union[QWidget,None] = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoClose: bool = ..., autoFillBackground: bool = ..., autoReset: bool = ..., baseSize: PySide2.QtCore.QSize = ..., canceled: typing.Callable = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumDuration: int = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., value: int = ..., visible: bool = ..., wasCanceled: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoClose: bool = ..., autoFillBackground: bool = ..., autoReset: bool = ..., baseSize: PySide2.QtCore.QSize = ..., canceled: typing.Callable = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., labelText: str = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximum: int = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimum: int = ..., minimumDuration: int = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., value: int = ..., visible: bool = ..., wasCanceled: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def autoClose(self) -> bool: ...
    def autoReset(self) -> bool: ...
    def cancel(self) -> None: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent) -> None: ...
    def forceShow(self) -> None: ...
    def labelText(self) -> str: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def minimumDuration(self) -> int: ...
    @overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    @overload
    def open(self) -> None: ...
    def reset(self) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def setAutoClose(self, close: bool) -> None: ...
    def setAutoReset(self, reset: bool) -> None: ...
    def setBar(self, bar: QProgressBar) -> None: ...
    def setCancelButton(self, button: typing.Union[QPushButton,None]) -> None: ...
    def setCancelButtonText(self, text: str) -> None: ...
    def setLabel(self, label: QLabel) -> None: ...
    def setLabelText(self, text: str) -> None: ...
    def setMaximum(self, maximum: int) -> None: ...
    def setMinimum(self, minimum: int) -> None: ...
    def setMinimumDuration(self, ms: int) -> None: ...
    def setRange(self, minimum: int, maximum: int) -> None: ...
    def setValue(self, progress: int) -> None: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def value(self) -> int: ...
    def wasCanceled(self) -> bool: ...

class QProxyStyle(QCommonStyle):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, key: str, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, style: typing.Union[QStyle,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def baseStyle(self) -> QStyle: ...
    def drawComplexControl(self, control: QStyle.ComplexControl, option: QStyleOptionComplex, painter: PySide2.QtGui.QPainter, widget: typing.Union[QWidget,None] = ...) -> None: ...
    def drawControl(self, element: QStyle.ControlElement, option: QStyleOption, painter: PySide2.QtGui.QPainter, widget: typing.Union[QWidget,None] = ...) -> None: ...
    def drawItemPixmap(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, alignment: int, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    def drawItemText(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, flags: typing.SupportsInt, pal: PySide2.QtGui.QPalette, enabled: bool, text: str, textRole: PySide2.QtGui.QPalette.ColorRole = ...) -> None: ...
    def drawPrimitive(self, element: QStyle.PrimitiveElement, option: QStyleOption, painter: PySide2.QtGui.QPainter, widget: typing.Union[QWidget,None] = ...) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def generatedIconPixmap(self, iconMode: PySide2.QtGui.QIcon.Mode, pixmap: PySide2.QtGui.QPixmap, opt: QStyleOption) -> PySide2.QtGui.QPixmap: ...
    def hitTestComplexControl(self, control: QStyle.ComplexControl, option: QStyleOptionComplex, pos: PySide2.QtCore.QPoint, widget: typing.Union[QWidget,None] = ...) -> QStyle.SubControl: ...
    def itemPixmapRect(self, r: PySide2.QtCore.QRect, flags: typing.SupportsInt, pixmap: PySide2.QtGui.QPixmap) -> PySide2.QtCore.QRect: ...
    def itemTextRect(self, fm: PySide2.QtGui.QFontMetrics, r: PySide2.QtCore.QRect, flags: typing.SupportsInt, enabled: bool, text: str) -> PySide2.QtCore.QRect: ...
    def layoutSpacing(self, control1: QSizePolicy.ControlType, control2: QSizePolicy.ControlType, orientation: PySide2.QtCore.Qt.Orientation, option: typing.Union[QStyleOption,None] = ..., widget: typing.Union[QWidget,None] = ...) -> int: ...
    def pixelMetric(self, metric: QStyle.PixelMetric, option: typing.Union[QStyleOption,None] = ..., widget: typing.Union[QWidget,None] = ...) -> int: ...
    @overload
    def polish(self, app: QApplication) -> None: ...
    @overload
    def polish(self, pal: PySide2.QtGui.QPalette) -> None: ...
    @overload
    def polish(self, widget: QWidget) -> None: ...
    def setBaseStyle(self, style: QStyle) -> None: ...
    def sizeFromContents(self, type: QStyle.ContentsType, option: QStyleOption, size: PySide2.QtCore.QSize, widget: QWidget) -> PySide2.QtCore.QSize: ...
    def standardIcon(self, standardIcon: QStyle.StandardPixmap, option: typing.Union[QStyleOption,None] = ..., widget: typing.Union[QWidget,None] = ...) -> PySide2.QtGui.QIcon: ...
    def standardPalette(self) -> PySide2.QtGui.QPalette: ...
    def standardPixmap(self, standardPixmap: QStyle.StandardPixmap, opt: QStyleOption, widget: typing.Union[QWidget,None] = ...) -> PySide2.QtGui.QPixmap: ...
    def styleHint(self, hint: QStyle.StyleHint, option: typing.Union[QStyleOption,None] = ..., widget: typing.Union[QWidget,None] = ..., returnData: typing.Union[QStyleHintReturn,None] = ...) -> int: ...
    def subControlRect(self, cc: QStyle.ComplexControl, opt: QStyleOptionComplex, sc: QStyle.SubControl, widget: QWidget) -> PySide2.QtCore.QRect: ...
    def subElementRect(self, element: QStyle.SubElement, option: QStyleOption, widget: QWidget) -> PySide2.QtCore.QRect: ...
    @overload
    def unpolish(self, app: QApplication) -> None: ...
    @overload
    def unpolish(self, application: QApplication) -> None: ...
    @overload
    def unpolish(self, widget: QWidget) -> None: ...

class QPushButton(QAbstractButton):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoDefault: bool = ..., autoExclusive: bool = ..., autoFillBackground: bool = ..., autoRepeat: bool = ..., autoRepeatDelay: int = ..., autoRepeatInterval: int = ..., baseSize: PySide2.QtCore.QSize = ..., checkable: bool = ..., checked: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., default: bool = ..., destroyed: typing.Callable = ..., down: bool = ..., enabled: bool = ..., flat: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., iconSize: PySide2.QtCore.QSize = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., released: typing.Callable = ..., shortcut: typing.Union[PySide2.QtGui.QKeySequence,str] = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toggled: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoDefault: bool = ..., autoExclusive: bool = ..., autoFillBackground: bool = ..., autoRepeat: bool = ..., autoRepeatDelay: int = ..., autoRepeatInterval: int = ..., baseSize: PySide2.QtCore.QSize = ..., checkable: bool = ..., checked: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., default: bool = ..., destroyed: typing.Callable = ..., down: bool = ..., enabled: bool = ..., flat: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., icon: PySide2.QtGui.QIcon = ..., iconSize: PySide2.QtCore.QSize = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., released: typing.Callable = ..., shortcut: typing.Union[PySide2.QtGui.QKeySequence,str] = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toggled: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoDefault: bool = ..., autoExclusive: bool = ..., autoFillBackground: bool = ..., autoRepeat: bool = ..., autoRepeatDelay: int = ..., autoRepeatInterval: int = ..., baseSize: PySide2.QtCore.QSize = ..., checkable: bool = ..., checked: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., default: bool = ..., destroyed: typing.Callable = ..., down: bool = ..., enabled: bool = ..., flat: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., icon: PySide2.QtGui.QIcon = ..., iconSize: PySide2.QtCore.QSize = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., released: typing.Callable = ..., shortcut: typing.Union[PySide2.QtGui.QKeySequence,str] = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., toggled: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def autoDefault(self) -> bool: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def hitButton(self, pos: PySide2.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, option: QStyleOptionButton) -> None: ...
    def isDefault(self) -> bool: ...
    def isFlat(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def menu(self) -> QMenu: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def setAutoDefault(self, arg__1: bool) -> None: ...
    def setDefault(self, arg__1: bool) -> None: ...
    def setFlat(self, arg__1: bool) -> None: ...
    def setMenu(self, menu: QMenu) -> None: ...
    def showMenu(self) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...

class QRadioButton(QAbstractButton):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, text: str, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoExclusive: bool = ..., autoFillBackground: bool = ..., autoRepeat: bool = ..., autoRepeatDelay: int = ..., autoRepeatInterval: int = ..., baseSize: PySide2.QtCore.QSize = ..., checkable: bool = ..., checked: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., down: bool = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., icon: PySide2.QtGui.QIcon = ..., iconSize: PySide2.QtCore.QSize = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., released: typing.Callable = ..., shortcut: typing.Union[PySide2.QtGui.QKeySequence,str] = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toggled: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoExclusive: bool = ..., autoFillBackground: bool = ..., autoRepeat: bool = ..., autoRepeatDelay: int = ..., autoRepeatInterval: int = ..., baseSize: PySide2.QtCore.QSize = ..., checkable: bool = ..., checked: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., down: bool = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., icon: PySide2.QtGui.QIcon = ..., iconSize: PySide2.QtCore.QSize = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., released: typing.Callable = ..., shortcut: typing.Union[PySide2.QtGui.QKeySequence,str] = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., text: str = ..., toggled: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def hitButton(self, arg__1: PySide2.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, button: QStyleOptionButton) -> None: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...

class QRubberBand(QWidget):
    class Shape:
        Line: typing.ClassVar[QRubberBand.Shape] = ...
        Rectangle: typing.ClassVar[QRubberBand.Shape] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRubberBand.Shape: ...
        def __and__(self, other: typing.SupportsInt) -> QRubberBand.Shape: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRubberBand.Shape: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRubberBand.Shape: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QRubberBand.Shape: ...
        def __rand__(self, other: typing.SupportsInt) -> QRubberBand.Shape: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRubberBand.Shape: ...
        def __ror__(self, other: typing.SupportsInt) -> QRubberBand.Shape: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRubberBand.Shape: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRubberBand.Shape: ...
        def __sub__(self, other: typing.SupportsInt) -> QRubberBand.Shape: ...
        def __xor__(self, other: typing.SupportsInt) -> QRubberBand.Shape: ...
    Line: typing.ClassVar[QRubberBand.Shape] = ...
    Rectangle: typing.ClassVar[QRubberBand.Shape] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, arg__1: QRubberBand.Shape, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: QStyleOptionRubberBand) -> None: ...
    @overload
    def move(self, x: int, y: int) -> None: ...
    @overload
    def move(self, p: PySide2.QtCore.QPoint) -> None: ...
    def moveEvent(self, arg__1: PySide2.QtGui.QMoveEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    @overload
    def resize(self, w: int, h: int) -> None: ...
    @overload
    def resize(self, s: PySide2.QtCore.QSize) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    @overload
    def setGeometry(self, x: int, y: int, w: int, h: int) -> None: ...
    @overload
    def setGeometry(self, r: PySide2.QtCore.QRect) -> None: ...
    def shape(self) -> QRubberBand.Shape: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent) -> None: ...

class QScrollArea(QAbstractScrollArea):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QScrollArea.Shadow = ..., frameShape: QScrollArea.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QScrollArea.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., visible: bool = ..., whatsThis: str = ..., widgetResizable: bool = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def alignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def ensureVisible(self, x: int, y: int, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def ensureWidgetVisible(self, childWidget: QWidget, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def setAlignment(self, arg__1: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setWidget(self, widget: QWidget) -> None: ...
    def setWidgetResizable(self, resizable: bool) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def takeWidget(self) -> QWidget: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def widget(self) -> QWidget: ...
    def widgetResizable(self) -> bool: ...

class QScrollBar(QAbstractSlider):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, arg__1: PySide2.QtCore.Qt.Orientation, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., actionTriggered: typing.Callable = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., invertedAppearance: bool = ..., invertedControls: bool = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximum: int = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimum: int = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., pageStep: int = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rangeChanged: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., singleStep: int = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., sliderDown: bool = ..., sliderMoved: typing.Callable = ..., sliderPosition: int = ..., sliderPressed: typing.Callable = ..., sliderReleased: typing.Callable = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., tracking: bool = ..., updatesEnabled: bool = ..., value: int = ..., valueChanged: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., actionTriggered: typing.Callable = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., invertedAppearance: bool = ..., invertedControls: bool = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximum: int = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimum: int = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., pageStep: int = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rangeChanged: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., singleStep: int = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., sliderDown: bool = ..., sliderMoved: typing.Callable = ..., sliderPosition: int = ..., sliderPressed: typing.Callable = ..., sliderReleased: typing.Callable = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., tracking: bool = ..., updatesEnabled: bool = ..., value: int = ..., valueChanged: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def contextMenuEvent(self, arg__1: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def hideEvent(self, arg__1: PySide2.QtGui.QHideEvent) -> None: ...
    def initStyleOption(self, option: QStyleOptionSlider) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sliderChange(self, change: QAbstractSlider.SliderChange) -> None: ...
    def wheelEvent(self, arg__1: PySide2.QtGui.QWheelEvent) -> None: ...

class QScroller(PySide2.QtCore.QObject):
    class Input:
        InputMove: typing.ClassVar[QScroller.Input] = ...
        InputPress: typing.ClassVar[QScroller.Input] = ...
        InputRelease: typing.ClassVar[QScroller.Input] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QScroller.Input: ...
        def __and__(self, other: typing.SupportsInt) -> QScroller.Input: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QScroller.Input: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QScroller.Input: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QScroller.Input: ...
        def __rand__(self, other: typing.SupportsInt) -> QScroller.Input: ...
        def __rmul__(self, other: typing.SupportsInt) -> QScroller.Input: ...
        def __ror__(self, other: typing.SupportsInt) -> QScroller.Input: ...
        def __rsub__(self, other: typing.SupportsInt) -> QScroller.Input: ...
        def __rxor__(self, other: typing.SupportsInt) -> QScroller.Input: ...
        def __sub__(self, other: typing.SupportsInt) -> QScroller.Input: ...
        def __xor__(self, other: typing.SupportsInt) -> QScroller.Input: ...

    class ScrollerGestureType:
        LeftMouseButtonGesture: typing.ClassVar[QScroller.ScrollerGestureType] = ...
        MiddleMouseButtonGesture: typing.ClassVar[QScroller.ScrollerGestureType] = ...
        RightMouseButtonGesture: typing.ClassVar[QScroller.ScrollerGestureType] = ...
        TouchGesture: typing.ClassVar[QScroller.ScrollerGestureType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QScroller.ScrollerGestureType: ...
        def __and__(self, other: typing.SupportsInt) -> QScroller.ScrollerGestureType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QScroller.ScrollerGestureType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QScroller.ScrollerGestureType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QScroller.ScrollerGestureType: ...
        def __rand__(self, other: typing.SupportsInt) -> QScroller.ScrollerGestureType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QScroller.ScrollerGestureType: ...
        def __ror__(self, other: typing.SupportsInt) -> QScroller.ScrollerGestureType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QScroller.ScrollerGestureType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QScroller.ScrollerGestureType: ...
        def __sub__(self, other: typing.SupportsInt) -> QScroller.ScrollerGestureType: ...
        def __xor__(self, other: typing.SupportsInt) -> QScroller.ScrollerGestureType: ...

    class State:
        Dragging: typing.ClassVar[QScroller.State] = ...
        Inactive: typing.ClassVar[QScroller.State] = ...
        Pressed: typing.ClassVar[QScroller.State] = ...
        Scrolling: typing.ClassVar[QScroller.State] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QScroller.State: ...
        def __and__(self, other: typing.SupportsInt) -> QScroller.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QScroller.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QScroller.State: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QScroller.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QScroller.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QScroller.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QScroller.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QScroller.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QScroller.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QScroller.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QScroller.State: ...
    Dragging: typing.ClassVar[QScroller.State] = ...
    Inactive: typing.ClassVar[QScroller.State] = ...
    InputMove: typing.ClassVar[QScroller.Input] = ...
    InputPress: typing.ClassVar[QScroller.Input] = ...
    InputRelease: typing.ClassVar[QScroller.Input] = ...
    LeftMouseButtonGesture: typing.ClassVar[QScroller.ScrollerGestureType] = ...
    MiddleMouseButtonGesture: typing.ClassVar[QScroller.ScrollerGestureType] = ...
    Pressed: typing.ClassVar[QScroller.State] = ...
    RightMouseButtonGesture: typing.ClassVar[QScroller.ScrollerGestureType] = ...
    Scrolling: typing.ClassVar[QScroller.State] = ...
    TouchGesture: typing.ClassVar[QScroller.ScrollerGestureType] = ...
    scrollerPropertiesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def activeScrollers(cls) -> typing.List[QScroller]: ...
    @overload
    def ensureVisible(self, rect: PySide2.QtCore.QRectF, xmargin: float, ymargin: float, scrollTime: int) -> None: ...
    @overload
    def ensureVisible(self, rect: PySide2.QtCore.QRectF, xmargin: float, ymargin: float) -> None: ...
    def finalPosition(self) -> PySide2.QtCore.QPointF: ...
    @classmethod
    def grabGesture(cls, target: PySide2.QtCore.QObject, gestureType: QScroller.ScrollerGestureType = ...) -> PySide2.QtCore.Qt.GestureType: ...
    @classmethod
    def grabbedGesture(cls, target: PySide2.QtCore.QObject) -> PySide2.QtCore.Qt.GestureType: ...
    def handleInput(self, input: QScroller.Input, position: PySide2.QtCore.QPointF, timestamp: int = ...) -> bool: ...
    @classmethod
    def hasScroller(cls, target: PySide2.QtCore.QObject) -> bool: ...
    def pixelPerMeter(self) -> PySide2.QtCore.QPointF: ...
    def resendPrepareEvent(self) -> None: ...
    @overload
    def scrollTo(self, pos: PySide2.QtCore.QPointF, scrollTime: int) -> None: ...
    @overload
    def scrollTo(self, pos: PySide2.QtCore.QPointF) -> None: ...
    @classmethod
    def scroller(cls, target: PySide2.QtCore.QObject) -> QScroller: ...
    def scrollerProperties(self) -> QScrollerProperties: ...
    def setScrollerProperties(self, prop: QScrollerProperties) -> None: ...
    @overload
    def setSnapPositionsX(self, first: float, interval: float) -> None: ...
    @overload
    def setSnapPositionsX(self, positions: typing.Iterable[float]) -> None: ...
    @overload
    def setSnapPositionsY(self, first: float, interval: float) -> None: ...
    @overload
    def setSnapPositionsY(self, positions: typing.Iterable[float]) -> None: ...
    def state(self) -> QScroller.State: ...
    def stop(self) -> None: ...
    def target(self) -> PySide2.QtCore.QObject: ...
    @classmethod
    def ungrabGesture(cls, target: PySide2.QtCore.QObject) -> None: ...
    def velocity(self) -> PySide2.QtCore.QPointF: ...

class QScrollerProperties(shiboken2.Object):
    class FrameRates:
        Fps20: typing.ClassVar[QScrollerProperties.FrameRates] = ...
        Fps30: typing.ClassVar[QScrollerProperties.FrameRates] = ...
        Fps60: typing.ClassVar[QScrollerProperties.FrameRates] = ...
        Standard: typing.ClassVar[QScrollerProperties.FrameRates] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QScrollerProperties.FrameRates: ...
        def __and__(self, other: typing.SupportsInt) -> QScrollerProperties.FrameRates: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QScrollerProperties.FrameRates: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QScrollerProperties.FrameRates: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QScrollerProperties.FrameRates: ...
        def __rand__(self, other: typing.SupportsInt) -> QScrollerProperties.FrameRates: ...
        def __rmul__(self, other: typing.SupportsInt) -> QScrollerProperties.FrameRates: ...
        def __ror__(self, other: typing.SupportsInt) -> QScrollerProperties.FrameRates: ...
        def __rsub__(self, other: typing.SupportsInt) -> QScrollerProperties.FrameRates: ...
        def __rxor__(self, other: typing.SupportsInt) -> QScrollerProperties.FrameRates: ...
        def __sub__(self, other: typing.SupportsInt) -> QScrollerProperties.FrameRates: ...
        def __xor__(self, other: typing.SupportsInt) -> QScrollerProperties.FrameRates: ...

    class OvershootPolicy:
        OvershootAlwaysOff: typing.ClassVar[QScrollerProperties.OvershootPolicy] = ...
        OvershootAlwaysOn: typing.ClassVar[QScrollerProperties.OvershootPolicy] = ...
        OvershootWhenScrollable: typing.ClassVar[QScrollerProperties.OvershootPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QScrollerProperties.OvershootPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QScrollerProperties.OvershootPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QScrollerProperties.OvershootPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QScrollerProperties.OvershootPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QScrollerProperties.OvershootPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QScrollerProperties.OvershootPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QScrollerProperties.OvershootPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QScrollerProperties.OvershootPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QScrollerProperties.OvershootPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QScrollerProperties.OvershootPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QScrollerProperties.OvershootPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QScrollerProperties.OvershootPolicy: ...

    class ScrollMetric:
        AcceleratingFlickMaximumTime: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        AcceleratingFlickSpeedupFactor: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        AxisLockThreshold: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        DecelerationFactor: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        DragStartDistance: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        DragVelocitySmoothingFactor: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        FrameRate: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        HorizontalOvershootPolicy: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        MaximumClickThroughVelocity: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        MaximumVelocity: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        MinimumVelocity: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        MousePressEventDelay: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        OvershootDragDistanceFactor: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        OvershootDragResistanceFactor: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        OvershootScrollDistanceFactor: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        OvershootScrollTime: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        ScrollMetricCount: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        ScrollingCurve: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        SnapPositionRatio: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        SnapTime: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        VerticalOvershootPolicy: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QScrollerProperties.ScrollMetric: ...
        def __and__(self, other: typing.SupportsInt) -> QScrollerProperties.ScrollMetric: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QScrollerProperties.ScrollMetric: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QScrollerProperties.ScrollMetric: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QScrollerProperties.ScrollMetric: ...
        def __rand__(self, other: typing.SupportsInt) -> QScrollerProperties.ScrollMetric: ...
        def __rmul__(self, other: typing.SupportsInt) -> QScrollerProperties.ScrollMetric: ...
        def __ror__(self, other: typing.SupportsInt) -> QScrollerProperties.ScrollMetric: ...
        def __rsub__(self, other: typing.SupportsInt) -> QScrollerProperties.ScrollMetric: ...
        def __rxor__(self, other: typing.SupportsInt) -> QScrollerProperties.ScrollMetric: ...
        def __sub__(self, other: typing.SupportsInt) -> QScrollerProperties.ScrollMetric: ...
        def __xor__(self, other: typing.SupportsInt) -> QScrollerProperties.ScrollMetric: ...
    AcceleratingFlickMaximumTime: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    AcceleratingFlickSpeedupFactor: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    AxisLockThreshold: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    DecelerationFactor: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    DragStartDistance: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    DragVelocitySmoothingFactor: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    Fps20: typing.ClassVar[QScrollerProperties.FrameRates] = ...
    Fps30: typing.ClassVar[QScrollerProperties.FrameRates] = ...
    Fps60: typing.ClassVar[QScrollerProperties.FrameRates] = ...
    FrameRate: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    HorizontalOvershootPolicy: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    MaximumClickThroughVelocity: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    MaximumVelocity: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    MinimumVelocity: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    MousePressEventDelay: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    OvershootAlwaysOff: typing.ClassVar[QScrollerProperties.OvershootPolicy] = ...
    OvershootAlwaysOn: typing.ClassVar[QScrollerProperties.OvershootPolicy] = ...
    OvershootDragDistanceFactor: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    OvershootDragResistanceFactor: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    OvershootScrollDistanceFactor: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    OvershootScrollTime: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    OvershootWhenScrollable: typing.ClassVar[QScrollerProperties.OvershootPolicy] = ...
    ScrollMetricCount: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    ScrollingCurve: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    SnapPositionRatio: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    SnapTime: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    Standard: typing.ClassVar[QScrollerProperties.FrameRates] = ...
    VerticalOvershootPolicy: typing.ClassVar[QScrollerProperties.ScrollMetric] = ...
    @overload
    def __init__(self, sp: QScrollerProperties) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def scrollMetric(self, metric: QScrollerProperties.ScrollMetric) -> typing.Any: ...
    @classmethod
    def setDefaultScrollerProperties(cls, sp: QScrollerProperties) -> None: ...
    def setScrollMetric(self, metric: QScrollerProperties.ScrollMetric, value: typing.Any) -> None: ...
    @classmethod
    def unsetDefaultScrollerProperties(cls) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QShortcut(PySide2.QtCore.QObject):
    activated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    activatedAmbiguously: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, key: typing.Union[PySide2.QtGui.QKeySequence,str], parent: typing.Union[QWidget,None], member: typing.Union[bytes,None] = ..., ambiguousMember: typing.Union[bytes,None] = ..., shortcutContext: PySide2.QtCore.Qt.ShortcutContext = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, arg__1: typing.Union[PySide2.QtGui.QKeySequence,str], arg__2: QWidget, arg__3: typing.Callable, arg__4: PySide2.QtCore.Qt.ShortcutContext = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None], destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def autoRepeat(self) -> bool: ...
    def context(self) -> PySide2.QtCore.Qt.ShortcutContext: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def id(self) -> int: ...
    def isEnabled(self) -> bool: ...
    def key(self) -> PySide2.QtGui.QKeySequence: ...
    def parentWidget(self) -> QWidget: ...
    def setAutoRepeat(self, on: bool) -> None: ...
    def setContext(self, context: PySide2.QtCore.Qt.ShortcutContext) -> None: ...
    def setEnabled(self, enable: bool) -> None: ...
    def setKey(self, key: typing.Union[PySide2.QtGui.QKeySequence,str]) -> None: ...
    def setWhatsThis(self, text: str) -> None: ...
    def whatsThis(self) -> str: ...

class QSizeGrip(QWidget):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None], acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def hideEvent(self, hideEvent: PySide2.QtGui.QHideEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveEvent(self, moveEvent: PySide2.QtGui.QMoveEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def setVisible(self, arg__1: bool) -> None: ...
    def showEvent(self, showEvent: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...

class QSizePolicy(shiboken2.Object):
    class ControlType:
        ButtonBox: typing.ClassVar[QSizePolicy.ControlType] = ...
        CheckBox: typing.ClassVar[QSizePolicy.ControlType] = ...
        ComboBox: typing.ClassVar[QSizePolicy.ControlType] = ...
        DefaultType: typing.ClassVar[QSizePolicy.ControlType] = ...
        Frame: typing.ClassVar[QSizePolicy.ControlType] = ...
        GroupBox: typing.ClassVar[QSizePolicy.ControlType] = ...
        Label: typing.ClassVar[QSizePolicy.ControlType] = ...
        Line: typing.ClassVar[QSizePolicy.ControlType] = ...
        LineEdit: typing.ClassVar[QSizePolicy.ControlType] = ...
        PushButton: typing.ClassVar[QSizePolicy.ControlType] = ...
        RadioButton: typing.ClassVar[QSizePolicy.ControlType] = ...
        Slider: typing.ClassVar[QSizePolicy.ControlType] = ...
        SpinBox: typing.ClassVar[QSizePolicy.ControlType] = ...
        TabWidget: typing.ClassVar[QSizePolicy.ControlType] = ...
        ToolButton: typing.ClassVar[QSizePolicy.ControlType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSizePolicy.ControlTypes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSizePolicy.ControlTypes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSizePolicy.ControlTypes: ...
        def __rand__(self, other: typing.SupportsInt) -> QSizePolicy.ControlTypes: ...
        def __ror__(self, other: typing.SupportsInt) -> QSizePolicy.ControlTypes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSizePolicy.ControlTypes: ...
        def __xor__(self, other: typing.SupportsInt) -> QSizePolicy.ControlTypes: ...

    class ControlTypes:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSizePolicy.ControlTypes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSizePolicy.ControlTypes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSizePolicy.ControlTypes: ...
        def __rand__(self, other: typing.SupportsInt) -> QSizePolicy.ControlTypes: ...
        def __ror__(self, other: typing.SupportsInt) -> QSizePolicy.ControlTypes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSizePolicy.ControlTypes: ...
        def __xor__(self, other: typing.SupportsInt) -> QSizePolicy.ControlTypes: ...

    class Policy:
        Expanding: typing.ClassVar[QSizePolicy.Policy] = ...
        Fixed: typing.ClassVar[QSizePolicy.Policy] = ...
        Ignored: typing.ClassVar[QSizePolicy.Policy] = ...
        Maximum: typing.ClassVar[QSizePolicy.Policy] = ...
        Minimum: typing.ClassVar[QSizePolicy.Policy] = ...
        MinimumExpanding: typing.ClassVar[QSizePolicy.Policy] = ...
        Preferred: typing.ClassVar[QSizePolicy.Policy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSizePolicy.Policy: ...
        def __and__(self, other: typing.SupportsInt) -> QSizePolicy.Policy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSizePolicy.Policy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSizePolicy.Policy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSizePolicy.Policy: ...
        def __rand__(self, other: typing.SupportsInt) -> QSizePolicy.Policy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSizePolicy.Policy: ...
        def __ror__(self, other: typing.SupportsInt) -> QSizePolicy.Policy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSizePolicy.Policy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSizePolicy.Policy: ...
        def __sub__(self, other: typing.SupportsInt) -> QSizePolicy.Policy: ...
        def __xor__(self, other: typing.SupportsInt) -> QSizePolicy.Policy: ...

    class PolicyFlag:
        ExpandFlag: typing.ClassVar[QSizePolicy.PolicyFlag] = ...
        GrowFlag: typing.ClassVar[QSizePolicy.PolicyFlag] = ...
        IgnoreFlag: typing.ClassVar[QSizePolicy.PolicyFlag] = ...
        ShrinkFlag: typing.ClassVar[QSizePolicy.PolicyFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSizePolicy.PolicyFlag: ...
        def __and__(self, other: typing.SupportsInt) -> QSizePolicy.PolicyFlag: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSizePolicy.PolicyFlag: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSizePolicy.PolicyFlag: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSizePolicy.PolicyFlag: ...
        def __rand__(self, other: typing.SupportsInt) -> QSizePolicy.PolicyFlag: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSizePolicy.PolicyFlag: ...
        def __ror__(self, other: typing.SupportsInt) -> QSizePolicy.PolicyFlag: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSizePolicy.PolicyFlag: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSizePolicy.PolicyFlag: ...
        def __sub__(self, other: typing.SupportsInt) -> QSizePolicy.PolicyFlag: ...
        def __xor__(self, other: typing.SupportsInt) -> QSizePolicy.PolicyFlag: ...
    ButtonBox: typing.ClassVar[QSizePolicy.ControlType] = ...
    CheckBox: typing.ClassVar[QSizePolicy.ControlType] = ...
    ComboBox: typing.ClassVar[QSizePolicy.ControlType] = ...
    DefaultType: typing.ClassVar[QSizePolicy.ControlType] = ...
    ExpandFlag: typing.ClassVar[QSizePolicy.PolicyFlag] = ...
    Expanding: typing.ClassVar[QSizePolicy.Policy] = ...
    Fixed: typing.ClassVar[QSizePolicy.Policy] = ...
    Frame: typing.ClassVar[QSizePolicy.ControlType] = ...
    GroupBox: typing.ClassVar[QSizePolicy.ControlType] = ...
    GrowFlag: typing.ClassVar[QSizePolicy.PolicyFlag] = ...
    IgnoreFlag: typing.ClassVar[QSizePolicy.PolicyFlag] = ...
    Ignored: typing.ClassVar[QSizePolicy.Policy] = ...
    Label: typing.ClassVar[QSizePolicy.ControlType] = ...
    Line: typing.ClassVar[QSizePolicy.ControlType] = ...
    LineEdit: typing.ClassVar[QSizePolicy.ControlType] = ...
    Maximum: typing.ClassVar[QSizePolicy.Policy] = ...
    Minimum: typing.ClassVar[QSizePolicy.Policy] = ...
    MinimumExpanding: typing.ClassVar[QSizePolicy.Policy] = ...
    Preferred: typing.ClassVar[QSizePolicy.Policy] = ...
    PushButton: typing.ClassVar[QSizePolicy.ControlType] = ...
    RadioButton: typing.ClassVar[QSizePolicy.ControlType] = ...
    ShrinkFlag: typing.ClassVar[QSizePolicy.PolicyFlag] = ...
    Slider: typing.ClassVar[QSizePolicy.ControlType] = ...
    SpinBox: typing.ClassVar[QSizePolicy.ControlType] = ...
    TabWidget: typing.ClassVar[QSizePolicy.ControlType] = ...
    ToolButton: typing.ClassVar[QSizePolicy.ControlType] = ...
    @overload
    def __init__(self, horizontal: QSizePolicy.Policy, vertical: QSizePolicy.Policy, type: QSizePolicy.ControlType = ...) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def controlType(self) -> QSizePolicy.ControlType: ...
    def expandingDirections(self) -> typing.Union[PySide2.QtCore.Qt.Orientations,PySide2.QtCore.Qt.Orientation]: ...
    def hasHeightForWidth(self) -> bool: ...
    def hasWidthForHeight(self) -> bool: ...
    def horizontalPolicy(self) -> QSizePolicy.Policy: ...
    def horizontalStretch(self) -> int: ...
    def retainSizeWhenHidden(self) -> bool: ...
    def setControlType(self, type: QSizePolicy.ControlType) -> None: ...
    def setHeightForWidth(self, b: bool) -> None: ...
    def setHorizontalPolicy(self, d: QSizePolicy.Policy) -> None: ...
    def setHorizontalStretch(self, stretchFactor: int) -> None: ...
    def setRetainSizeWhenHidden(self, retainSize: bool) -> None: ...
    def setVerticalPolicy(self, d: QSizePolicy.Policy) -> None: ...
    def setVerticalStretch(self, stretchFactor: int) -> None: ...
    def setWidthForHeight(self, b: bool) -> None: ...
    def transpose(self) -> None: ...
    def transposed(self) -> QSizePolicy: ...
    def verticalPolicy(self) -> QSizePolicy.Policy: ...
    def verticalStretch(self) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QSlider(QAbstractSlider):
    class TickPosition:
        NoTicks: typing.ClassVar[QSlider.TickPosition] = ...
        TicksAbove: typing.ClassVar[QSlider.TickPosition] = ...
        TicksBelow: typing.ClassVar[QSlider.TickPosition] = ...
        TicksBothSides: typing.ClassVar[QSlider.TickPosition] = ...
        TicksLeft: typing.ClassVar[QSlider.TickPosition] = ...
        TicksRight: typing.ClassVar[QSlider.TickPosition] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSlider.TickPosition: ...
        def __and__(self, other: typing.SupportsInt) -> QSlider.TickPosition: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSlider.TickPosition: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSlider.TickPosition: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSlider.TickPosition: ...
        def __rand__(self, other: typing.SupportsInt) -> QSlider.TickPosition: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSlider.TickPosition: ...
        def __ror__(self, other: typing.SupportsInt) -> QSlider.TickPosition: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSlider.TickPosition: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSlider.TickPosition: ...
        def __sub__(self, other: typing.SupportsInt) -> QSlider.TickPosition: ...
        def __xor__(self, other: typing.SupportsInt) -> QSlider.TickPosition: ...
    NoTicks: typing.ClassVar[QSlider.TickPosition] = ...
    TicksAbove: typing.ClassVar[QSlider.TickPosition] = ...
    TicksBelow: typing.ClassVar[QSlider.TickPosition] = ...
    TicksBothSides: typing.ClassVar[QSlider.TickPosition] = ...
    TicksLeft: typing.ClassVar[QSlider.TickPosition] = ...
    TicksRight: typing.ClassVar[QSlider.TickPosition] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., actionTriggered: typing.Callable = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., invertedAppearance: bool = ..., invertedControls: bool = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximum: int = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimum: int = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pageStep: int = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rangeChanged: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., singleStep: int = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., sliderDown: bool = ..., sliderMoved: typing.Callable = ..., sliderPosition: int = ..., sliderPressed: typing.Callable = ..., sliderReleased: typing.Callable = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., tickInterval: int = ..., tickPosition: QSlider.TickPosition = ..., toolTip: str = ..., toolTipDuration: int = ..., tracking: bool = ..., updatesEnabled: bool = ..., value: int = ..., valueChanged: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., actionTriggered: typing.Callable = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., invertedAppearance: bool = ..., invertedControls: bool = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximum: int = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimum: int = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., pageStep: int = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rangeChanged: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., singleStep: int = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., sliderDown: bool = ..., sliderMoved: typing.Callable = ..., sliderPosition: int = ..., sliderPressed: typing.Callable = ..., sliderReleased: typing.Callable = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., tickInterval: int = ..., tickPosition: QSlider.TickPosition = ..., toolTip: str = ..., toolTipDuration: int = ..., tracking: bool = ..., updatesEnabled: bool = ..., value: int = ..., valueChanged: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: QStyleOptionSlider) -> None: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, ev: PySide2.QtGui.QPaintEvent) -> None: ...
    def setTickInterval(self, ti: int) -> None: ...
    def setTickPosition(self, position: QSlider.TickPosition) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def tickInterval(self) -> int: ...
    def tickPosition(self) -> QSlider.TickPosition: ...

class QSpacerItem(QLayoutItem):
    def __init__(self, w: int, h: int, hData: QSizePolicy.Policy = ..., vData: QSizePolicy.Policy = ...) -> None: ...
    def changeSize(self, w: int, h: int, hData: QSizePolicy.Policy = ..., vData: QSizePolicy.Policy = ...) -> None: ...
    def expandingDirections(self) -> typing.Union[PySide2.QtCore.Qt.Orientations,PySide2.QtCore.Qt.Orientation]: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def isEmpty(self) -> bool: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sizePolicy(self) -> QSizePolicy: ...
    def spacerItem(self) -> QSpacerItem: ...

class QSpinBox(QAbstractSpinBox):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    textChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., accelerated: bool = ..., acceptDrops: bool = ..., acceptableInput: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., buttonSymbols: QSpinBox.ButtonSymbols = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., cleanText: str = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., correctionMode: QSpinBox.CorrectionMode = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., displayIntegerBase: int = ..., editingFinished: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frame: bool = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., keyboardTracking: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximum: int = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimum: int = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., prefix: str = ..., readOnly: bool = ..., rect: PySide2.QtCore.QRect = ..., showGroupSeparator: bool = ..., singleStep: int = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., specialValueText: str = ..., statusTip: str = ..., stepType: QSpinBox.StepType = ..., styleSheet: str = ..., suffix: str = ..., tabletTracking: bool = ..., text: str = ..., textChanged: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., value: int = ..., valueChanged: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wrapping: bool = ..., x: int = ..., y: int = ...) -> None: ...
    def cleanText(self) -> str: ...
    def displayIntegerBase(self) -> int: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def fixup(self, str: str) -> None: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def prefix(self) -> str: ...
    def setDisplayIntegerBase(self, base: int) -> None: ...
    def setMaximum(self, max: int) -> None: ...
    def setMinimum(self, min: int) -> None: ...
    def setPrefix(self, prefix: str) -> None: ...
    def setRange(self, min: int, max: int) -> None: ...
    def setSingleStep(self, val: int) -> None: ...
    def setStepType(self, stepType: QAbstractSpinBox.StepType) -> None: ...
    def setSuffix(self, suffix: str) -> None: ...
    def setValue(self, val: int) -> None: ...
    def singleStep(self) -> int: ...
    def stepType(self) -> QAbstractSpinBox.StepType: ...
    def suffix(self) -> str: ...
    def textFromValue(self, val: int) -> str: ...
    def validate(self, input: str, pos: int) -> PySide2.QtGui.QValidator.State: ...
    def value(self) -> int: ...
    def valueFromText(self, text: str) -> int: ...

class QSplashScreen(QWidget):
    messageChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None], pixmap: PySide2.QtGui.QPixmap = ..., f: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., messageChanged: typing.Callable = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, screen: PySide2.QtGui.QScreen, pixmap: PySide2.QtGui.QPixmap = ..., f: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., messageChanged: typing.Callable = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, pixmap: PySide2.QtGui.QPixmap = ..., f: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., messageChanged: typing.Callable = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def clearMessage(self) -> None: ...
    def drawContents(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def finish(self, w: QWidget) -> None: ...
    def message(self) -> str: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    def setPixmap(self, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    def showMessage(self, message: str, alignment: int = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ...) -> None: ...

class QSplitter(QFrame):
    splitterMoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, arg__1: PySide2.QtCore.Qt.Orientation, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenCollapsible: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QSplitter.Shadow = ..., frameShape: QSplitter.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., handleWidth: int = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opaqueResize: bool = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., splitterMoved: typing.Callable = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenCollapsible: bool = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QSplitter.Shadow = ..., frameShape: QSplitter.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., handleWidth: int = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opaqueResize: bool = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., splitterMoved: typing.Callable = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def addWidget(self, widget: QWidget) -> None: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def childEvent(self, arg__1: PySide2.QtCore.QChildEvent) -> None: ...
    def childrenCollapsible(self) -> bool: ...
    def closestLegalPosition(self, arg__1: int, arg__2: int) -> int: ...
    def count(self) -> int: ...
    def createHandle(self) -> QSplitterHandle: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def getRange(self, index: int) -> typing.Tuple[int,int]: ...
    def handle(self, index: int) -> QSplitterHandle: ...
    def handleWidth(self) -> int: ...
    def indexOf(self, w: QWidget) -> int: ...
    def insertWidget(self, index: int, widget: QWidget) -> None: ...
    def isCollapsible(self, index: int) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def moveSplitter(self, pos: int, index: int) -> None: ...
    def opaqueResize(self) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def refresh(self) -> None: ...
    def replaceWidget(self, index: int, widget: QWidget) -> QWidget: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def restoreState(self, state: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> bool: ...
    def saveState(self) -> PySide2.QtCore.QByteArray: ...
    def setChildrenCollapsible(self, arg__1: bool) -> None: ...
    def setCollapsible(self, index: int, arg__2: bool) -> None: ...
    def setHandleWidth(self, arg__1: int) -> None: ...
    def setOpaqueResize(self, opaque: bool = ...) -> None: ...
    def setOrientation(self, arg__1: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setRubberBand(self, position: int) -> None: ...
    def setSizes(self, list: typing.Iterable[int]) -> None: ...
    def setStretchFactor(self, index: int, stretch: int) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sizes(self) -> typing.List[int]: ...
    def widget(self, index: int) -> QWidget: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QTextStream) -> PySide2.QtCore.QTextStream: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QTextStream) -> PySide2.QtCore.QTextStream: ...

class QSplitterHandle(QWidget):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, o: PySide2.QtCore.Qt.Orientation, parent: QSplitter, acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def closestLegalPosition(self, p: int) -> int: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveSplitter(self, p: int) -> None: ...
    def opaqueResize(self) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def setOrientation(self, o: PySide2.QtCore.Qt.Orientation) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def splitter(self) -> QSplitter: ...

class QStackedLayout(QLayout):
    class StackingMode:
        StackAll: typing.ClassVar[QStackedLayout.StackingMode] = ...
        StackOne: typing.ClassVar[QStackedLayout.StackingMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStackedLayout.StackingMode: ...
        def __and__(self, other: typing.SupportsInt) -> QStackedLayout.StackingMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStackedLayout.StackingMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStackedLayout.StackingMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStackedLayout.StackingMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QStackedLayout.StackingMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStackedLayout.StackingMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QStackedLayout.StackingMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStackedLayout.StackingMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStackedLayout.StackingMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QStackedLayout.StackingMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QStackedLayout.StackingMode: ...
    StackAll: typing.ClassVar[QStackedLayout.StackingMode] = ...
    StackOne: typing.ClassVar[QStackedLayout.StackingMode] = ...
    currentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    widgetRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, parent: typing.Union[QWidget,None], currentChanged: typing.Callable = ..., currentIndex: int = ..., destroyed: typing.Callable = ..., margin: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., sizeConstraint: QStackedLayout.SizeConstraint = ..., spacing: int = ..., stackingMode: QStackedLayout.StackingMode = ..., widgetRemoved: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parentLayout: QLayout, currentChanged: typing.Callable = ..., currentIndex: int = ..., destroyed: typing.Callable = ..., margin: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., sizeConstraint: QStackedLayout.SizeConstraint = ..., spacing: int = ..., stackingMode: QStackedLayout.StackingMode = ..., widgetRemoved: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, currentChanged: typing.Callable = ..., currentIndex: int = ..., destroyed: typing.Callable = ..., margin: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., sizeConstraint: QStackedLayout.SizeConstraint = ..., spacing: int = ..., stackingMode: QStackedLayout.StackingMode = ..., widgetRemoved: typing.Callable = ...) -> None: ...
    def addItem(self, item: QLayoutItem) -> None: ...
    def addWidget(self, w: QWidget) -> int: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> QWidget: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width: int) -> int: ...
    def insertWidget(self, index: int, w: QWidget) -> int: ...
    def itemAt(self, arg__1: int) -> QLayoutItem: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentWidget(self, w: QWidget) -> None: ...
    def setGeometry(self, rect: PySide2.QtCore.QRect) -> None: ...
    def setStackingMode(self, stackingMode: QStackedLayout.StackingMode) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def stackingMode(self) -> QStackedLayout.StackingMode: ...
    def takeAt(self, arg__1: int) -> QLayoutItem: ...
    @overload
    def widget(self, arg__1: int) -> QWidget: ...
    @overload
    def widget(self) -> QWidget: ...

class QStackedWidget(QFrame):
    currentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    widgetRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., count: int = ..., currentChanged: typing.Callable = ..., currentIndex: int = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QStackedWidget.Shadow = ..., frameShape: QStackedWidget.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., widgetRemoved: typing.Callable = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def addWidget(self, w: QWidget) -> int: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> QWidget: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def indexOf(self, arg__1: QWidget) -> int: ...
    def insertWidget(self, index: int, w: QWidget) -> int: ...
    def removeWidget(self, w: QWidget) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentWidget(self, w: QWidget) -> None: ...
    def widget(self, arg__1: int) -> QWidget: ...

class QStatusBar(QWidget):
    messageChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., messageChanged: typing.Callable = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def addPermanentWidget(self, widget: QWidget, stretch: int = ...) -> None: ...
    def addWidget(self, widget: QWidget, stretch: int = ...) -> None: ...
    def clearMessage(self) -> None: ...
    def currentMessage(self) -> str: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def hideOrShow(self) -> None: ...
    def insertPermanentWidget(self, index: int, widget: QWidget, stretch: int = ...) -> int: ...
    def insertWidget(self, index: int, widget: QWidget, stretch: int = ...) -> int: ...
    def isSizeGripEnabled(self) -> bool: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def reformat(self) -> None: ...
    def removeWidget(self, widget: QWidget) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def setSizeGripEnabled(self, arg__1: bool) -> None: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent) -> None: ...
    def showMessage(self, text: str, timeout: int = ...) -> None: ...

class QStyle(PySide2.QtCore.QObject):
    class ComplexControl:
        CC_ComboBox: typing.ClassVar[QStyle.ComplexControl] = ...
        CC_CustomBase: typing.ClassVar[QStyle.ComplexControl] = ...
        CC_Dial: typing.ClassVar[QStyle.ComplexControl] = ...
        CC_GroupBox: typing.ClassVar[QStyle.ComplexControl] = ...
        CC_MdiControls: typing.ClassVar[QStyle.ComplexControl] = ...
        CC_ScrollBar: typing.ClassVar[QStyle.ComplexControl] = ...
        CC_Slider: typing.ClassVar[QStyle.ComplexControl] = ...
        CC_SpinBox: typing.ClassVar[QStyle.ComplexControl] = ...
        CC_TitleBar: typing.ClassVar[QStyle.ComplexControl] = ...
        CC_ToolButton: typing.ClassVar[QStyle.ComplexControl] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStyle.ComplexControl: ...
        def __and__(self, other: typing.SupportsInt) -> QStyle.ComplexControl: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStyle.ComplexControl: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStyle.ComplexControl: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStyle.ComplexControl: ...
        def __rand__(self, other: typing.SupportsInt) -> QStyle.ComplexControl: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStyle.ComplexControl: ...
        def __ror__(self, other: typing.SupportsInt) -> QStyle.ComplexControl: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStyle.ComplexControl: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStyle.ComplexControl: ...
        def __sub__(self, other: typing.SupportsInt) -> QStyle.ComplexControl: ...
        def __xor__(self, other: typing.SupportsInt) -> QStyle.ComplexControl: ...

    class ContentsType:
        CT_CheckBox: typing.ClassVar[QStyle.ContentsType] = ...
        CT_ComboBox: typing.ClassVar[QStyle.ContentsType] = ...
        CT_CustomBase: typing.ClassVar[QStyle.ContentsType] = ...
        CT_DialogButtons: typing.ClassVar[QStyle.ContentsType] = ...
        CT_GroupBox: typing.ClassVar[QStyle.ContentsType] = ...
        CT_HeaderSection: typing.ClassVar[QStyle.ContentsType] = ...
        CT_ItemViewItem: typing.ClassVar[QStyle.ContentsType] = ...
        CT_LineEdit: typing.ClassVar[QStyle.ContentsType] = ...
        CT_MdiControls: typing.ClassVar[QStyle.ContentsType] = ...
        CT_Menu: typing.ClassVar[QStyle.ContentsType] = ...
        CT_MenuBar: typing.ClassVar[QStyle.ContentsType] = ...
        CT_MenuBarItem: typing.ClassVar[QStyle.ContentsType] = ...
        CT_MenuItem: typing.ClassVar[QStyle.ContentsType] = ...
        CT_ProgressBar: typing.ClassVar[QStyle.ContentsType] = ...
        CT_PushButton: typing.ClassVar[QStyle.ContentsType] = ...
        CT_RadioButton: typing.ClassVar[QStyle.ContentsType] = ...
        CT_ScrollBar: typing.ClassVar[QStyle.ContentsType] = ...
        CT_SizeGrip: typing.ClassVar[QStyle.ContentsType] = ...
        CT_Slider: typing.ClassVar[QStyle.ContentsType] = ...
        CT_SpinBox: typing.ClassVar[QStyle.ContentsType] = ...
        CT_Splitter: typing.ClassVar[QStyle.ContentsType] = ...
        CT_TabBarTab: typing.ClassVar[QStyle.ContentsType] = ...
        CT_TabWidget: typing.ClassVar[QStyle.ContentsType] = ...
        CT_ToolButton: typing.ClassVar[QStyle.ContentsType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStyle.ContentsType: ...
        def __and__(self, other: typing.SupportsInt) -> QStyle.ContentsType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStyle.ContentsType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStyle.ContentsType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStyle.ContentsType: ...
        def __rand__(self, other: typing.SupportsInt) -> QStyle.ContentsType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStyle.ContentsType: ...
        def __ror__(self, other: typing.SupportsInt) -> QStyle.ContentsType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStyle.ContentsType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStyle.ContentsType: ...
        def __sub__(self, other: typing.SupportsInt) -> QStyle.ContentsType: ...
        def __xor__(self, other: typing.SupportsInt) -> QStyle.ContentsType: ...

    class ControlElement:
        CE_CheckBox: typing.ClassVar[QStyle.ControlElement] = ...
        CE_CheckBoxLabel: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ColumnViewGrip: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ComboBoxLabel: typing.ClassVar[QStyle.ControlElement] = ...
        CE_CustomBase: typing.ClassVar[QStyle.ControlElement] = ...
        CE_DockWidgetTitle: typing.ClassVar[QStyle.ControlElement] = ...
        CE_FocusFrame: typing.ClassVar[QStyle.ControlElement] = ...
        CE_Header: typing.ClassVar[QStyle.ControlElement] = ...
        CE_HeaderEmptyArea: typing.ClassVar[QStyle.ControlElement] = ...
        CE_HeaderLabel: typing.ClassVar[QStyle.ControlElement] = ...
        CE_HeaderSection: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ItemViewItem: typing.ClassVar[QStyle.ControlElement] = ...
        CE_MenuBarEmptyArea: typing.ClassVar[QStyle.ControlElement] = ...
        CE_MenuBarItem: typing.ClassVar[QStyle.ControlElement] = ...
        CE_MenuEmptyArea: typing.ClassVar[QStyle.ControlElement] = ...
        CE_MenuHMargin: typing.ClassVar[QStyle.ControlElement] = ...
        CE_MenuItem: typing.ClassVar[QStyle.ControlElement] = ...
        CE_MenuScroller: typing.ClassVar[QStyle.ControlElement] = ...
        CE_MenuTearoff: typing.ClassVar[QStyle.ControlElement] = ...
        CE_MenuVMargin: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ProgressBar: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ProgressBarContents: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ProgressBarGroove: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ProgressBarLabel: typing.ClassVar[QStyle.ControlElement] = ...
        CE_PushButton: typing.ClassVar[QStyle.ControlElement] = ...
        CE_PushButtonBevel: typing.ClassVar[QStyle.ControlElement] = ...
        CE_PushButtonLabel: typing.ClassVar[QStyle.ControlElement] = ...
        CE_RadioButton: typing.ClassVar[QStyle.ControlElement] = ...
        CE_RadioButtonLabel: typing.ClassVar[QStyle.ControlElement] = ...
        CE_RubberBand: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ScrollBarAddLine: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ScrollBarAddPage: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ScrollBarFirst: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ScrollBarLast: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ScrollBarSlider: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ScrollBarSubLine: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ScrollBarSubPage: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ShapedFrame: typing.ClassVar[QStyle.ControlElement] = ...
        CE_SizeGrip: typing.ClassVar[QStyle.ControlElement] = ...
        CE_Splitter: typing.ClassVar[QStyle.ControlElement] = ...
        CE_TabBarTab: typing.ClassVar[QStyle.ControlElement] = ...
        CE_TabBarTabLabel: typing.ClassVar[QStyle.ControlElement] = ...
        CE_TabBarTabShape: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ToolBar: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ToolBoxTab: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ToolBoxTabLabel: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ToolBoxTabShape: typing.ClassVar[QStyle.ControlElement] = ...
        CE_ToolButtonLabel: typing.ClassVar[QStyle.ControlElement] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStyle.ControlElement: ...
        def __and__(self, other: typing.SupportsInt) -> QStyle.ControlElement: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStyle.ControlElement: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStyle.ControlElement: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStyle.ControlElement: ...
        def __rand__(self, other: typing.SupportsInt) -> QStyle.ControlElement: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStyle.ControlElement: ...
        def __ror__(self, other: typing.SupportsInt) -> QStyle.ControlElement: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStyle.ControlElement: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStyle.ControlElement: ...
        def __sub__(self, other: typing.SupportsInt) -> QStyle.ControlElement: ...
        def __xor__(self, other: typing.SupportsInt) -> QStyle.ControlElement: ...

    class PixelMetric:
        PM_ButtonDefaultIndicator: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ButtonIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ButtonMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ButtonShiftHorizontal: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ButtonShiftVertical: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_CheckBoxLabelSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ComboBoxFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_CustomBase: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_DefaultChildMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_DefaultFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_DefaultLayoutSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_DefaultTopLevelMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_DialogButtonsButtonHeight: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_DialogButtonsButtonWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_DialogButtonsSeparator: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_DockWidgetFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_DockWidgetHandleExtent: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_DockWidgetSeparatorExtent: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_DockWidgetTitleBarButtonMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_DockWidgetTitleMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ExclusiveIndicatorHeight: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ExclusiveIndicatorWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_FocusFrameHMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_FocusFrameVMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_HeaderDefaultSectionSizeHorizontal: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_HeaderDefaultSectionSizeVertical: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_HeaderGripMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_HeaderMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_HeaderMarkSize: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_IconViewIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_IndicatorHeight: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_IndicatorWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_LargeIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_LayoutBottomMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_LayoutHorizontalSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_LayoutLeftMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_LayoutRightMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_LayoutTopMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_LayoutVerticalSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ListViewIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MDIFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MDIMinimizedWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MaximumDragDistance: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MdiSubWindowFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MdiSubWindowMinimizedWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MenuBarHMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MenuBarItemSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MenuBarPanelWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MenuBarVMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MenuButtonIndicator: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MenuDesktopFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MenuHMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MenuPanelWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MenuScrollerHeight: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MenuTearoffHeight: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MenuVMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_MessageBoxIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ProgressBarChunkWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_RadioButtonLabelSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ScrollBarExtent: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ScrollBarSliderMin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ScrollView_ScrollBarOverlap: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ScrollView_ScrollBarSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_SizeGripSize: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_SliderControlThickness: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_SliderLength: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_SliderSpaceAvailable: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_SliderThickness: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_SliderTickmarkOffset: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_SmallIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_SpinBoxFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_SpinBoxSliderHeight: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_SplitterWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_SubMenuOverlap: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TabBarBaseHeight: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TabBarBaseOverlap: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TabBarIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TabBarScrollButtonWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TabBarTabHSpace: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TabBarTabOverlap: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TabBarTabShiftHorizontal: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TabBarTabShiftVertical: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TabBarTabVSpace: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TabBar_ScrollButtonOverlap: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TabCloseIndicatorHeight: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TabCloseIndicatorWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TextCursorWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TitleBarButtonIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TitleBarButtonSize: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TitleBarHeight: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ToolBarExtensionExtent: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ToolBarFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ToolBarHandleExtent: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ToolBarIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ToolBarItemMargin: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ToolBarItemSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ToolBarSeparatorExtent: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_ToolTipLabelFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
        PM_TreeViewIndentation: typing.ClassVar[QStyle.PixelMetric] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStyle.PixelMetric: ...
        def __and__(self, other: typing.SupportsInt) -> QStyle.PixelMetric: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStyle.PixelMetric: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStyle.PixelMetric: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStyle.PixelMetric: ...
        def __rand__(self, other: typing.SupportsInt) -> QStyle.PixelMetric: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStyle.PixelMetric: ...
        def __ror__(self, other: typing.SupportsInt) -> QStyle.PixelMetric: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStyle.PixelMetric: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStyle.PixelMetric: ...
        def __sub__(self, other: typing.SupportsInt) -> QStyle.PixelMetric: ...
        def __xor__(self, other: typing.SupportsInt) -> QStyle.PixelMetric: ...

    class PrimitiveElement:
        PE_CustomBase: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_Frame: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_FrameButtonBevel: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_FrameButtonTool: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_FrameDefaultButton: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_FrameDockWidget: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_FrameFocusRect: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_FrameGroupBox: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_FrameLineEdit: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_FrameMenu: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_FrameStatusBar: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_FrameStatusBarItem: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_FrameTabBarBase: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_FrameTabWidget: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_FrameWindow: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorArrowDown: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorArrowLeft: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorArrowRight: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorArrowUp: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorBranch: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorButtonDropDown: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorCheckBox: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorColumnViewArrow: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorDockWidgetResizeHandle: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorHeaderArrow: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorItemViewItemCheck: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorItemViewItemDrop: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorMenuCheckMark: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorProgressChunk: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorRadioButton: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorSpinDown: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorSpinMinus: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorSpinPlus: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorSpinUp: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorTabClose: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorTabTear: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorTabTearLeft: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorTabTearRight: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorToolBarHandle: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorToolBarSeparator: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_IndicatorViewItemCheck: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_PanelButtonBevel: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_PanelButtonCommand: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_PanelButtonTool: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_PanelItemViewItem: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_PanelItemViewRow: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_PanelLineEdit: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_PanelMenu: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_PanelMenuBar: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_PanelScrollAreaCorner: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_PanelStatusBar: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_PanelTipLabel: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_PanelToolBar: typing.ClassVar[QStyle.PrimitiveElement] = ...
        PE_Widget: typing.ClassVar[QStyle.PrimitiveElement] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStyle.PrimitiveElement: ...
        def __and__(self, other: typing.SupportsInt) -> QStyle.PrimitiveElement: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStyle.PrimitiveElement: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStyle.PrimitiveElement: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStyle.PrimitiveElement: ...
        def __rand__(self, other: typing.SupportsInt) -> QStyle.PrimitiveElement: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStyle.PrimitiveElement: ...
        def __ror__(self, other: typing.SupportsInt) -> QStyle.PrimitiveElement: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStyle.PrimitiveElement: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStyle.PrimitiveElement: ...
        def __sub__(self, other: typing.SupportsInt) -> QStyle.PrimitiveElement: ...
        def __xor__(self, other: typing.SupportsInt) -> QStyle.PrimitiveElement: ...

    class RequestSoftwareInputPanel:
        RSIP_OnMouseClick: typing.ClassVar[QStyle.RequestSoftwareInputPanel] = ...
        RSIP_OnMouseClickAndAlreadyFocused: typing.ClassVar[QStyle.RequestSoftwareInputPanel] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStyle.RequestSoftwareInputPanel: ...
        def __and__(self, other: typing.SupportsInt) -> QStyle.RequestSoftwareInputPanel: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStyle.RequestSoftwareInputPanel: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStyle.RequestSoftwareInputPanel: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStyle.RequestSoftwareInputPanel: ...
        def __rand__(self, other: typing.SupportsInt) -> QStyle.RequestSoftwareInputPanel: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStyle.RequestSoftwareInputPanel: ...
        def __ror__(self, other: typing.SupportsInt) -> QStyle.RequestSoftwareInputPanel: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStyle.RequestSoftwareInputPanel: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStyle.RequestSoftwareInputPanel: ...
        def __sub__(self, other: typing.SupportsInt) -> QStyle.RequestSoftwareInputPanel: ...
        def __xor__(self, other: typing.SupportsInt) -> QStyle.RequestSoftwareInputPanel: ...

    class StandardPixmap:
        SP_ArrowBack: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_ArrowDown: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_ArrowForward: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_ArrowLeft: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_ArrowRight: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_ArrowUp: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_BrowserReload: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_BrowserStop: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_CommandLink: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_ComputerIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_CustomBase: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DesktopIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogAbortButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogApplyButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogCancelButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogCloseButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogDiscardButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogHelpButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogIgnoreButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogNoButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogNoToAllButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogOkButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogOpenButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogResetButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogRetryButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogSaveAllButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogSaveButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogYesButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DialogYesToAllButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DirClosedIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DirHomeIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DirIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DirLinkIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DirLinkOpenIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DirOpenIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DockWidgetCloseButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DriveCDIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DriveDVDIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DriveFDIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DriveHDIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_DriveNetIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_FileDialogBack: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_FileDialogContentsView: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_FileDialogDetailedView: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_FileDialogEnd: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_FileDialogInfoView: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_FileDialogListView: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_FileDialogNewFolder: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_FileDialogStart: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_FileDialogToParent: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_FileIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_FileLinkIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_LineEditClearButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_MediaPause: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_MediaPlay: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_MediaSeekBackward: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_MediaSeekForward: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_MediaSkipBackward: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_MediaSkipForward: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_MediaStop: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_MediaVolume: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_MediaVolumeMuted: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_MessageBoxCritical: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_MessageBoxInformation: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_MessageBoxQuestion: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_MessageBoxWarning: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_RestoreDefaultsButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_TitleBarCloseButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_TitleBarContextHelpButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_TitleBarMaxButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_TitleBarMenuButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_TitleBarMinButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_TitleBarNormalButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_TitleBarShadeButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_TitleBarUnshadeButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_ToolBarHorizontalExtensionButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_ToolBarVerticalExtensionButton: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_TrashIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
        SP_VistaShield: typing.ClassVar[QStyle.StandardPixmap] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStyle.StandardPixmap: ...
        def __and__(self, other: typing.SupportsInt) -> QStyle.StandardPixmap: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStyle.StandardPixmap: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStyle.StandardPixmap: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStyle.StandardPixmap: ...
        def __rand__(self, other: typing.SupportsInt) -> QStyle.StandardPixmap: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStyle.StandardPixmap: ...
        def __ror__(self, other: typing.SupportsInt) -> QStyle.StandardPixmap: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStyle.StandardPixmap: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStyle.StandardPixmap: ...
        def __sub__(self, other: typing.SupportsInt) -> QStyle.StandardPixmap: ...
        def __xor__(self, other: typing.SupportsInt) -> QStyle.StandardPixmap: ...

    class State:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QStyle.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QStyle.State: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStyle.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QStyle.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QStyle.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStyle.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QStyle.State: ...

    class StateFlag:
        State_Active: typing.ClassVar[QStyle.StateFlag] = ...
        State_AutoRaise: typing.ClassVar[QStyle.StateFlag] = ...
        State_Bottom: typing.ClassVar[QStyle.StateFlag] = ...
        State_Children: typing.ClassVar[QStyle.StateFlag] = ...
        State_DownArrow: typing.ClassVar[QStyle.StateFlag] = ...
        State_Editing: typing.ClassVar[QStyle.StateFlag] = ...
        State_Enabled: typing.ClassVar[QStyle.StateFlag] = ...
        State_FocusAtBorder: typing.ClassVar[QStyle.StateFlag] = ...
        State_HasFocus: typing.ClassVar[QStyle.StateFlag] = ...
        State_Horizontal: typing.ClassVar[QStyle.StateFlag] = ...
        State_Item: typing.ClassVar[QStyle.StateFlag] = ...
        State_KeyboardFocusChange: typing.ClassVar[QStyle.StateFlag] = ...
        State_Mini: typing.ClassVar[QStyle.StateFlag] = ...
        State_MouseOver: typing.ClassVar[QStyle.StateFlag] = ...
        State_NoChange: typing.ClassVar[QStyle.StateFlag] = ...
        State_None: typing.ClassVar[QStyle.StateFlag] = ...
        State_Off: typing.ClassVar[QStyle.StateFlag] = ...
        State_On: typing.ClassVar[QStyle.StateFlag] = ...
        State_Open: typing.ClassVar[QStyle.StateFlag] = ...
        State_Raised: typing.ClassVar[QStyle.StateFlag] = ...
        State_ReadOnly: typing.ClassVar[QStyle.StateFlag] = ...
        State_Selected: typing.ClassVar[QStyle.StateFlag] = ...
        State_Sibling: typing.ClassVar[QStyle.StateFlag] = ...
        State_Small: typing.ClassVar[QStyle.StateFlag] = ...
        State_Sunken: typing.ClassVar[QStyle.StateFlag] = ...
        State_Top: typing.ClassVar[QStyle.StateFlag] = ...
        State_UpArrow: typing.ClassVar[QStyle.StateFlag] = ...
        State_Window: typing.ClassVar[QStyle.StateFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QStyle.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QStyle.State: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStyle.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QStyle.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QStyle.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStyle.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QStyle.State: ...

    class StyleHint:
        SH_BlinkCursorWhenTextSelected: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Button_FocusPolicy: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ComboBox_AllowWheelScrolling: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ComboBox_LayoutDirection: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ComboBox_ListMouseTracking: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ComboBox_Popup: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ComboBox_PopupFrameStyle: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ComboBox_UseNativePopup: typing.ClassVar[QStyle.StyleHint] = ...
        SH_CustomBase: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Dial_BackgroundRole: typing.ClassVar[QStyle.StyleHint] = ...
        SH_DialogButtonBox_ButtonsHaveIcons: typing.ClassVar[QStyle.StyleHint] = ...
        SH_DialogButtonLayout: typing.ClassVar[QStyle.StyleHint] = ...
        SH_DialogButtons_DefaultButton: typing.ClassVar[QStyle.StyleHint] = ...
        SH_DitherDisabledText: typing.ClassVar[QStyle.StyleHint] = ...
        SH_DockWidget_ButtonsHaveFrame: typing.ClassVar[QStyle.StyleHint] = ...
        SH_DrawMenuBarSeparator: typing.ClassVar[QStyle.StyleHint] = ...
        SH_EtchDisabledText: typing.ClassVar[QStyle.StyleHint] = ...
        SH_FocusFrame_AboveWidget: typing.ClassVar[QStyle.StyleHint] = ...
        SH_FocusFrame_Mask: typing.ClassVar[QStyle.StyleHint] = ...
        SH_FontDialog_SelectAssociatedText: typing.ClassVar[QStyle.StyleHint] = ...
        SH_FormLayoutFieldGrowthPolicy: typing.ClassVar[QStyle.StyleHint] = ...
        SH_FormLayoutFormAlignment: typing.ClassVar[QStyle.StyleHint] = ...
        SH_FormLayoutLabelAlignment: typing.ClassVar[QStyle.StyleHint] = ...
        SH_FormLayoutWrapPolicy: typing.ClassVar[QStyle.StyleHint] = ...
        SH_GroupBox_TextLabelColor: typing.ClassVar[QStyle.StyleHint] = ...
        SH_GroupBox_TextLabelVerticalAlignment: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Header_ArrowAlignment: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ItemView_ActivateItemOnSingleClick: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ItemView_ArrowKeysNavigateIntoChildren: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ItemView_ChangeHighlightOnFocus: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ItemView_DrawDelegateFrame: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ItemView_EllipsisLocation: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ItemView_MovementWithoutUpdatingSelection: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ItemView_PaintAlternatingRowColorsForEmptyArea: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ItemView_ScrollMode: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ItemView_ShowDecorationSelected: typing.ClassVar[QStyle.StyleHint] = ...
        SH_LineEdit_PasswordCharacter: typing.ClassVar[QStyle.StyleHint] = ...
        SH_LineEdit_PasswordMaskDelay: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ListViewExpand_SelectMouseType: typing.ClassVar[QStyle.StyleHint] = ...
        SH_MainWindow_SpaceBelowMenuBar: typing.ClassVar[QStyle.StyleHint] = ...
        SH_MenuBar_AltKeyNavigation: typing.ClassVar[QStyle.StyleHint] = ...
        SH_MenuBar_MouseTracking: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_AllowActiveAndDisabled: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_FadeOutOnHide: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_FillScreenWithScroll: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_FlashTriggeredItem: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_KeyboardSearch: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_Mask: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_MouseTracking: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_Scrollable: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_SelectionWrap: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_SloppySubMenus: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_SpaceActivatesItem: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_SubMenuDontStartSloppyOnLeave: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_SubMenuPopupDelay: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_SubMenuResetWhenReenteringParent: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_SubMenuSloppyCloseTimeout: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_SubMenuSloppySelectOtherActions: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_SubMenuUniDirection: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_SubMenuUniDirectionFailCount: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Menu_SupportsSections: typing.ClassVar[QStyle.StyleHint] = ...
        SH_MessageBox_CenterButtons: typing.ClassVar[QStyle.StyleHint] = ...
        SH_MessageBox_TextInteractionFlags: typing.ClassVar[QStyle.StyleHint] = ...
        SH_MessageBox_UseBorderForButtonSpacing: typing.ClassVar[QStyle.StyleHint] = ...
        SH_PrintDialog_RightAlignButtons: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ProgressDialog_CenterCancelButton: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ProgressDialog_TextLabelAlignment: typing.ClassVar[QStyle.StyleHint] = ...
        SH_RequestSoftwareInputPanel: typing.ClassVar[QStyle.StyleHint] = ...
        SH_RichText_FullWidthSelection: typing.ClassVar[QStyle.StyleHint] = ...
        SH_RubberBand_Mask: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ScrollBar_ContextMenu: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ScrollBar_LeftClickAbsolutePosition: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ScrollBar_MiddleClickAbsolutePosition: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ScrollBar_RollBetweenButtons: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ScrollBar_ScrollWhenPointerLeavesControl: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ScrollBar_StopMouseOverSlider: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ScrollBar_Transient: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ScrollView_FrameOnlyAroundContents: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Slider_AbsoluteSetButtons: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Slider_PageSetButtons: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Slider_SloppyKeyEvents: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Slider_SnapToValue: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Slider_StopMouseOverSlider: typing.ClassVar[QStyle.StyleHint] = ...
        SH_SpellCheckUnderlineStyle: typing.ClassVar[QStyle.StyleHint] = ...
        SH_SpinBox_AnimateButton: typing.ClassVar[QStyle.StyleHint] = ...
        SH_SpinBox_ButtonsInsideFrame: typing.ClassVar[QStyle.StyleHint] = ...
        SH_SpinBox_ClickAutoRepeatRate: typing.ClassVar[QStyle.StyleHint] = ...
        SH_SpinBox_ClickAutoRepeatThreshold: typing.ClassVar[QStyle.StyleHint] = ...
        SH_SpinBox_KeyPressAutoRepeatRate: typing.ClassVar[QStyle.StyleHint] = ...
        SH_SpinBox_StepModifier: typing.ClassVar[QStyle.StyleHint] = ...
        SH_SpinControls_DisableOnBounds: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Splitter_OpaqueResize: typing.ClassVar[QStyle.StyleHint] = ...
        SH_TabBar_Alignment: typing.ClassVar[QStyle.StyleHint] = ...
        SH_TabBar_ChangeCurrentDelay: typing.ClassVar[QStyle.StyleHint] = ...
        SH_TabBar_CloseButtonPosition: typing.ClassVar[QStyle.StyleHint] = ...
        SH_TabBar_ElideMode: typing.ClassVar[QStyle.StyleHint] = ...
        SH_TabBar_PreferNoArrows: typing.ClassVar[QStyle.StyleHint] = ...
        SH_TabBar_SelectMouseType: typing.ClassVar[QStyle.StyleHint] = ...
        SH_TabWidget_DefaultTabPosition: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Table_GridLineColor: typing.ClassVar[QStyle.StyleHint] = ...
        SH_TextControl_FocusIndicatorTextCharFormat: typing.ClassVar[QStyle.StyleHint] = ...
        SH_TitleBar_AutoRaise: typing.ClassVar[QStyle.StyleHint] = ...
        SH_TitleBar_ModifyNotification: typing.ClassVar[QStyle.StyleHint] = ...
        SH_TitleBar_NoBorder: typing.ClassVar[QStyle.StyleHint] = ...
        SH_TitleBar_ShowToolTipsOnButtons: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ToolBar_Movable: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ToolBox_SelectedPageTitleBold: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ToolButtonStyle: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ToolButton_PopupDelay: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ToolTipLabel_Opacity: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ToolTip_FallAsleepDelay: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ToolTip_Mask: typing.ClassVar[QStyle.StyleHint] = ...
        SH_ToolTip_WakeUpDelay: typing.ClassVar[QStyle.StyleHint] = ...
        SH_UnderlineShortcut: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Widget_Animate: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Widget_Animation_Duration: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Widget_ShareActivation: typing.ClassVar[QStyle.StyleHint] = ...
        SH_WindowFrame_Mask: typing.ClassVar[QStyle.StyleHint] = ...
        SH_WizardStyle: typing.ClassVar[QStyle.StyleHint] = ...
        SH_Workspace_FillSpaceOnMaximize: typing.ClassVar[QStyle.StyleHint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStyle.StyleHint: ...
        def __and__(self, other: typing.SupportsInt) -> QStyle.StyleHint: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStyle.StyleHint: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStyle.StyleHint: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStyle.StyleHint: ...
        def __rand__(self, other: typing.SupportsInt) -> QStyle.StyleHint: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStyle.StyleHint: ...
        def __ror__(self, other: typing.SupportsInt) -> QStyle.StyleHint: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStyle.StyleHint: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStyle.StyleHint: ...
        def __sub__(self, other: typing.SupportsInt) -> QStyle.StyleHint: ...
        def __xor__(self, other: typing.SupportsInt) -> QStyle.StyleHint: ...

    class SubControl:
        SC_All: typing.ClassVar[QStyle.SubControl] = ...
        SC_ComboBoxArrow: typing.ClassVar[QStyle.SubControl] = ...
        SC_ComboBoxEditField: typing.ClassVar[QStyle.SubControl] = ...
        SC_ComboBoxFrame: typing.ClassVar[QStyle.SubControl] = ...
        SC_ComboBoxListBoxPopup: typing.ClassVar[QStyle.SubControl] = ...
        SC_CustomBase: typing.ClassVar[QStyle.SubControl] = ...
        SC_DialGroove: typing.ClassVar[QStyle.SubControl] = ...
        SC_DialHandle: typing.ClassVar[QStyle.SubControl] = ...
        SC_DialTickmarks: typing.ClassVar[QStyle.SubControl] = ...
        SC_GroupBoxCheckBox: typing.ClassVar[QStyle.SubControl] = ...
        SC_GroupBoxContents: typing.ClassVar[QStyle.SubControl] = ...
        SC_GroupBoxFrame: typing.ClassVar[QStyle.SubControl] = ...
        SC_GroupBoxLabel: typing.ClassVar[QStyle.SubControl] = ...
        SC_MdiCloseButton: typing.ClassVar[QStyle.SubControl] = ...
        SC_MdiMinButton: typing.ClassVar[QStyle.SubControl] = ...
        SC_MdiNormalButton: typing.ClassVar[QStyle.SubControl] = ...
        SC_None: typing.ClassVar[QStyle.SubControl] = ...
        SC_ScrollBarAddLine: typing.ClassVar[QStyle.SubControl] = ...
        SC_ScrollBarAddPage: typing.ClassVar[QStyle.SubControl] = ...
        SC_ScrollBarFirst: typing.ClassVar[QStyle.SubControl] = ...
        SC_ScrollBarGroove: typing.ClassVar[QStyle.SubControl] = ...
        SC_ScrollBarLast: typing.ClassVar[QStyle.SubControl] = ...
        SC_ScrollBarSlider: typing.ClassVar[QStyle.SubControl] = ...
        SC_ScrollBarSubLine: typing.ClassVar[QStyle.SubControl] = ...
        SC_ScrollBarSubPage: typing.ClassVar[QStyle.SubControl] = ...
        SC_SliderGroove: typing.ClassVar[QStyle.SubControl] = ...
        SC_SliderHandle: typing.ClassVar[QStyle.SubControl] = ...
        SC_SliderTickmarks: typing.ClassVar[QStyle.SubControl] = ...
        SC_SpinBoxDown: typing.ClassVar[QStyle.SubControl] = ...
        SC_SpinBoxEditField: typing.ClassVar[QStyle.SubControl] = ...
        SC_SpinBoxFrame: typing.ClassVar[QStyle.SubControl] = ...
        SC_SpinBoxUp: typing.ClassVar[QStyle.SubControl] = ...
        SC_TitleBarCloseButton: typing.ClassVar[QStyle.SubControl] = ...
        SC_TitleBarContextHelpButton: typing.ClassVar[QStyle.SubControl] = ...
        SC_TitleBarLabel: typing.ClassVar[QStyle.SubControl] = ...
        SC_TitleBarMaxButton: typing.ClassVar[QStyle.SubControl] = ...
        SC_TitleBarMinButton: typing.ClassVar[QStyle.SubControl] = ...
        SC_TitleBarNormalButton: typing.ClassVar[QStyle.SubControl] = ...
        SC_TitleBarShadeButton: typing.ClassVar[QStyle.SubControl] = ...
        SC_TitleBarSysMenu: typing.ClassVar[QStyle.SubControl] = ...
        SC_TitleBarUnshadeButton: typing.ClassVar[QStyle.SubControl] = ...
        SC_ToolButton: typing.ClassVar[QStyle.SubControl] = ...
        SC_ToolButtonMenu: typing.ClassVar[QStyle.SubControl] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QStyle.SubControls: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QStyle.SubControls: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStyle.SubControls: ...
        def __rand__(self, other: typing.SupportsInt) -> QStyle.SubControls: ...
        def __ror__(self, other: typing.SupportsInt) -> QStyle.SubControls: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStyle.SubControls: ...
        def __xor__(self, other: typing.SupportsInt) -> QStyle.SubControls: ...

    class SubControls:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QStyle.SubControls: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QStyle.SubControls: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStyle.SubControls: ...
        def __rand__(self, other: typing.SupportsInt) -> QStyle.SubControls: ...
        def __ror__(self, other: typing.SupportsInt) -> QStyle.SubControls: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStyle.SubControls: ...
        def __xor__(self, other: typing.SupportsInt) -> QStyle.SubControls: ...

    class SubElement:
        SE_CheckBoxClickRect: typing.ClassVar[QStyle.SubElement] = ...
        SE_CheckBoxContents: typing.ClassVar[QStyle.SubElement] = ...
        SE_CheckBoxFocusRect: typing.ClassVar[QStyle.SubElement] = ...
        SE_CheckBoxIndicator: typing.ClassVar[QStyle.SubElement] = ...
        SE_CheckBoxLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_ComboBoxFocusRect: typing.ClassVar[QStyle.SubElement] = ...
        SE_ComboBoxLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_CustomBase: typing.ClassVar[QStyle.SubElement] = ...
        SE_DateTimeEditLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_DialogButtonBoxLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_DockWidgetCloseButton: typing.ClassVar[QStyle.SubElement] = ...
        SE_DockWidgetFloatButton: typing.ClassVar[QStyle.SubElement] = ...
        SE_DockWidgetIcon: typing.ClassVar[QStyle.SubElement] = ...
        SE_DockWidgetTitleBarText: typing.ClassVar[QStyle.SubElement] = ...
        SE_FrameContents: typing.ClassVar[QStyle.SubElement] = ...
        SE_FrameLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_GroupBoxLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_HeaderArrow: typing.ClassVar[QStyle.SubElement] = ...
        SE_HeaderLabel: typing.ClassVar[QStyle.SubElement] = ...
        SE_ItemViewItemCheckIndicator: typing.ClassVar[QStyle.SubElement] = ...
        SE_ItemViewItemDecoration: typing.ClassVar[QStyle.SubElement] = ...
        SE_ItemViewItemFocusRect: typing.ClassVar[QStyle.SubElement] = ...
        SE_ItemViewItemText: typing.ClassVar[QStyle.SubElement] = ...
        SE_LabelLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_LineEditContents: typing.ClassVar[QStyle.SubElement] = ...
        SE_ProgressBarContents: typing.ClassVar[QStyle.SubElement] = ...
        SE_ProgressBarGroove: typing.ClassVar[QStyle.SubElement] = ...
        SE_ProgressBarLabel: typing.ClassVar[QStyle.SubElement] = ...
        SE_ProgressBarLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_PushButtonBevel: typing.ClassVar[QStyle.SubElement] = ...
        SE_PushButtonContents: typing.ClassVar[QStyle.SubElement] = ...
        SE_PushButtonFocusRect: typing.ClassVar[QStyle.SubElement] = ...
        SE_PushButtonLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_RadioButtonClickRect: typing.ClassVar[QStyle.SubElement] = ...
        SE_RadioButtonContents: typing.ClassVar[QStyle.SubElement] = ...
        SE_RadioButtonFocusRect: typing.ClassVar[QStyle.SubElement] = ...
        SE_RadioButtonIndicator: typing.ClassVar[QStyle.SubElement] = ...
        SE_RadioButtonLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_ShapedFrameContents: typing.ClassVar[QStyle.SubElement] = ...
        SE_SliderFocusRect: typing.ClassVar[QStyle.SubElement] = ...
        SE_SliderLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_SpinBoxLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_TabBarScrollLeftButton: typing.ClassVar[QStyle.SubElement] = ...
        SE_TabBarScrollRightButton: typing.ClassVar[QStyle.SubElement] = ...
        SE_TabBarTabLeftButton: typing.ClassVar[QStyle.SubElement] = ...
        SE_TabBarTabRightButton: typing.ClassVar[QStyle.SubElement] = ...
        SE_TabBarTabText: typing.ClassVar[QStyle.SubElement] = ...
        SE_TabBarTearIndicator: typing.ClassVar[QStyle.SubElement] = ...
        SE_TabBarTearIndicatorLeft: typing.ClassVar[QStyle.SubElement] = ...
        SE_TabBarTearIndicatorRight: typing.ClassVar[QStyle.SubElement] = ...
        SE_TabWidgetLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_TabWidgetLeftCorner: typing.ClassVar[QStyle.SubElement] = ...
        SE_TabWidgetRightCorner: typing.ClassVar[QStyle.SubElement] = ...
        SE_TabWidgetTabBar: typing.ClassVar[QStyle.SubElement] = ...
        SE_TabWidgetTabContents: typing.ClassVar[QStyle.SubElement] = ...
        SE_TabWidgetTabPane: typing.ClassVar[QStyle.SubElement] = ...
        SE_ToolBarHandle: typing.ClassVar[QStyle.SubElement] = ...
        SE_ToolBoxTabContents: typing.ClassVar[QStyle.SubElement] = ...
        SE_ToolButtonLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_TreeViewDisclosureItem: typing.ClassVar[QStyle.SubElement] = ...
        SE_ViewItemCheckIndicator: typing.ClassVar[QStyle.SubElement] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStyle.SubElement: ...
        def __and__(self, other: typing.SupportsInt) -> QStyle.SubElement: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStyle.SubElement: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStyle.SubElement: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStyle.SubElement: ...
        def __rand__(self, other: typing.SupportsInt) -> QStyle.SubElement: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStyle.SubElement: ...
        def __ror__(self, other: typing.SupportsInt) -> QStyle.SubElement: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStyle.SubElement: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStyle.SubElement: ...
        def __sub__(self, other: typing.SupportsInt) -> QStyle.SubElement: ...
        def __xor__(self, other: typing.SupportsInt) -> QStyle.SubElement: ...
    CC_ComboBox: typing.ClassVar[QStyle.ComplexControl] = ...
    CC_CustomBase: typing.ClassVar[QStyle.ComplexControl] = ...
    CC_Dial: typing.ClassVar[QStyle.ComplexControl] = ...
    CC_GroupBox: typing.ClassVar[QStyle.ComplexControl] = ...
    CC_MdiControls: typing.ClassVar[QStyle.ComplexControl] = ...
    CC_ScrollBar: typing.ClassVar[QStyle.ComplexControl] = ...
    CC_Slider: typing.ClassVar[QStyle.ComplexControl] = ...
    CC_SpinBox: typing.ClassVar[QStyle.ComplexControl] = ...
    CC_TitleBar: typing.ClassVar[QStyle.ComplexControl] = ...
    CC_ToolButton: typing.ClassVar[QStyle.ComplexControl] = ...
    CE_CheckBox: typing.ClassVar[QStyle.ControlElement] = ...
    CE_CheckBoxLabel: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ColumnViewGrip: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ComboBoxLabel: typing.ClassVar[QStyle.ControlElement] = ...
    CE_CustomBase: typing.ClassVar[QStyle.ControlElement] = ...
    CE_DockWidgetTitle: typing.ClassVar[QStyle.ControlElement] = ...
    CE_FocusFrame: typing.ClassVar[QStyle.ControlElement] = ...
    CE_Header: typing.ClassVar[QStyle.ControlElement] = ...
    CE_HeaderEmptyArea: typing.ClassVar[QStyle.ControlElement] = ...
    CE_HeaderLabel: typing.ClassVar[QStyle.ControlElement] = ...
    CE_HeaderSection: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ItemViewItem: typing.ClassVar[QStyle.ControlElement] = ...
    CE_MenuBarEmptyArea: typing.ClassVar[QStyle.ControlElement] = ...
    CE_MenuBarItem: typing.ClassVar[QStyle.ControlElement] = ...
    CE_MenuEmptyArea: typing.ClassVar[QStyle.ControlElement] = ...
    CE_MenuHMargin: typing.ClassVar[QStyle.ControlElement] = ...
    CE_MenuItem: typing.ClassVar[QStyle.ControlElement] = ...
    CE_MenuScroller: typing.ClassVar[QStyle.ControlElement] = ...
    CE_MenuTearoff: typing.ClassVar[QStyle.ControlElement] = ...
    CE_MenuVMargin: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ProgressBar: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ProgressBarContents: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ProgressBarGroove: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ProgressBarLabel: typing.ClassVar[QStyle.ControlElement] = ...
    CE_PushButton: typing.ClassVar[QStyle.ControlElement] = ...
    CE_PushButtonBevel: typing.ClassVar[QStyle.ControlElement] = ...
    CE_PushButtonLabel: typing.ClassVar[QStyle.ControlElement] = ...
    CE_RadioButton: typing.ClassVar[QStyle.ControlElement] = ...
    CE_RadioButtonLabel: typing.ClassVar[QStyle.ControlElement] = ...
    CE_RubberBand: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ScrollBarAddLine: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ScrollBarAddPage: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ScrollBarFirst: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ScrollBarLast: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ScrollBarSlider: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ScrollBarSubLine: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ScrollBarSubPage: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ShapedFrame: typing.ClassVar[QStyle.ControlElement] = ...
    CE_SizeGrip: typing.ClassVar[QStyle.ControlElement] = ...
    CE_Splitter: typing.ClassVar[QStyle.ControlElement] = ...
    CE_TabBarTab: typing.ClassVar[QStyle.ControlElement] = ...
    CE_TabBarTabLabel: typing.ClassVar[QStyle.ControlElement] = ...
    CE_TabBarTabShape: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ToolBar: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ToolBoxTab: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ToolBoxTabLabel: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ToolBoxTabShape: typing.ClassVar[QStyle.ControlElement] = ...
    CE_ToolButtonLabel: typing.ClassVar[QStyle.ControlElement] = ...
    CT_CheckBox: typing.ClassVar[QStyle.ContentsType] = ...
    CT_ComboBox: typing.ClassVar[QStyle.ContentsType] = ...
    CT_CustomBase: typing.ClassVar[QStyle.ContentsType] = ...
    CT_DialogButtons: typing.ClassVar[QStyle.ContentsType] = ...
    CT_GroupBox: typing.ClassVar[QStyle.ContentsType] = ...
    CT_HeaderSection: typing.ClassVar[QStyle.ContentsType] = ...
    CT_ItemViewItem: typing.ClassVar[QStyle.ContentsType] = ...
    CT_LineEdit: typing.ClassVar[QStyle.ContentsType] = ...
    CT_MdiControls: typing.ClassVar[QStyle.ContentsType] = ...
    CT_Menu: typing.ClassVar[QStyle.ContentsType] = ...
    CT_MenuBar: typing.ClassVar[QStyle.ContentsType] = ...
    CT_MenuBarItem: typing.ClassVar[QStyle.ContentsType] = ...
    CT_MenuItem: typing.ClassVar[QStyle.ContentsType] = ...
    CT_ProgressBar: typing.ClassVar[QStyle.ContentsType] = ...
    CT_PushButton: typing.ClassVar[QStyle.ContentsType] = ...
    CT_RadioButton: typing.ClassVar[QStyle.ContentsType] = ...
    CT_ScrollBar: typing.ClassVar[QStyle.ContentsType] = ...
    CT_SizeGrip: typing.ClassVar[QStyle.ContentsType] = ...
    CT_Slider: typing.ClassVar[QStyle.ContentsType] = ...
    CT_SpinBox: typing.ClassVar[QStyle.ContentsType] = ...
    CT_Splitter: typing.ClassVar[QStyle.ContentsType] = ...
    CT_TabBarTab: typing.ClassVar[QStyle.ContentsType] = ...
    CT_TabWidget: typing.ClassVar[QStyle.ContentsType] = ...
    CT_ToolButton: typing.ClassVar[QStyle.ContentsType] = ...
    PE_CustomBase: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_Frame: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_FrameButtonBevel: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_FrameButtonTool: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_FrameDefaultButton: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_FrameDockWidget: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_FrameFocusRect: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_FrameGroupBox: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_FrameLineEdit: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_FrameMenu: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_FrameStatusBar: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_FrameStatusBarItem: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_FrameTabBarBase: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_FrameTabWidget: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_FrameWindow: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorArrowDown: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorArrowLeft: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorArrowRight: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorArrowUp: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorBranch: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorButtonDropDown: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorCheckBox: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorColumnViewArrow: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorDockWidgetResizeHandle: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorHeaderArrow: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorItemViewItemCheck: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorItemViewItemDrop: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorMenuCheckMark: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorProgressChunk: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorRadioButton: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorSpinDown: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorSpinMinus: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorSpinPlus: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorSpinUp: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorTabClose: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorTabTear: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorTabTearLeft: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorTabTearRight: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorToolBarHandle: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorToolBarSeparator: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_IndicatorViewItemCheck: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_PanelButtonBevel: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_PanelButtonCommand: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_PanelButtonTool: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_PanelItemViewItem: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_PanelItemViewRow: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_PanelLineEdit: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_PanelMenu: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_PanelMenuBar: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_PanelScrollAreaCorner: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_PanelStatusBar: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_PanelTipLabel: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_PanelToolBar: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PE_Widget: typing.ClassVar[QStyle.PrimitiveElement] = ...
    PM_ButtonDefaultIndicator: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ButtonIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ButtonMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ButtonShiftHorizontal: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ButtonShiftVertical: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_CheckBoxLabelSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ComboBoxFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_CustomBase: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_DefaultChildMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_DefaultFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_DefaultLayoutSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_DefaultTopLevelMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_DialogButtonsButtonHeight: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_DialogButtonsButtonWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_DialogButtonsSeparator: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_DockWidgetFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_DockWidgetHandleExtent: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_DockWidgetSeparatorExtent: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_DockWidgetTitleBarButtonMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_DockWidgetTitleMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ExclusiveIndicatorHeight: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ExclusiveIndicatorWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_FocusFrameHMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_FocusFrameVMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_HeaderDefaultSectionSizeHorizontal: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_HeaderDefaultSectionSizeVertical: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_HeaderGripMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_HeaderMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_HeaderMarkSize: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_IconViewIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_IndicatorHeight: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_IndicatorWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_LargeIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_LayoutBottomMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_LayoutHorizontalSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_LayoutLeftMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_LayoutRightMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_LayoutTopMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_LayoutVerticalSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ListViewIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MDIFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MDIMinimizedWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MaximumDragDistance: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MdiSubWindowFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MdiSubWindowMinimizedWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MenuBarHMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MenuBarItemSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MenuBarPanelWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MenuBarVMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MenuButtonIndicator: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MenuDesktopFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MenuHMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MenuPanelWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MenuScrollerHeight: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MenuTearoffHeight: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MenuVMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_MessageBoxIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ProgressBarChunkWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_RadioButtonLabelSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ScrollBarExtent: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ScrollBarSliderMin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ScrollView_ScrollBarOverlap: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ScrollView_ScrollBarSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_SizeGripSize: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_SliderControlThickness: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_SliderLength: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_SliderSpaceAvailable: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_SliderThickness: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_SliderTickmarkOffset: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_SmallIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_SpinBoxFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_SpinBoxSliderHeight: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_SplitterWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_SubMenuOverlap: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TabBarBaseHeight: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TabBarBaseOverlap: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TabBarIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TabBarScrollButtonWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TabBarTabHSpace: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TabBarTabOverlap: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TabBarTabShiftHorizontal: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TabBarTabShiftVertical: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TabBarTabVSpace: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TabBar_ScrollButtonOverlap: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TabCloseIndicatorHeight: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TabCloseIndicatorWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TextCursorWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TitleBarButtonIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TitleBarButtonSize: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TitleBarHeight: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ToolBarExtensionExtent: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ToolBarFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ToolBarHandleExtent: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ToolBarIconSize: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ToolBarItemMargin: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ToolBarItemSpacing: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ToolBarSeparatorExtent: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_ToolTipLabelFrameWidth: typing.ClassVar[QStyle.PixelMetric] = ...
    PM_TreeViewIndentation: typing.ClassVar[QStyle.PixelMetric] = ...
    RSIP_OnMouseClick: typing.ClassVar[QStyle.RequestSoftwareInputPanel] = ...
    RSIP_OnMouseClickAndAlreadyFocused: typing.ClassVar[QStyle.RequestSoftwareInputPanel] = ...
    SC_All: typing.ClassVar[QStyle.SubControl] = ...
    SC_ComboBoxArrow: typing.ClassVar[QStyle.SubControl] = ...
    SC_ComboBoxEditField: typing.ClassVar[QStyle.SubControl] = ...
    SC_ComboBoxFrame: typing.ClassVar[QStyle.SubControl] = ...
    SC_ComboBoxListBoxPopup: typing.ClassVar[QStyle.SubControl] = ...
    SC_CustomBase: typing.ClassVar[QStyle.SubControl] = ...
    SC_DialGroove: typing.ClassVar[QStyle.SubControl] = ...
    SC_DialHandle: typing.ClassVar[QStyle.SubControl] = ...
    SC_DialTickmarks: typing.ClassVar[QStyle.SubControl] = ...
    SC_GroupBoxCheckBox: typing.ClassVar[QStyle.SubControl] = ...
    SC_GroupBoxContents: typing.ClassVar[QStyle.SubControl] = ...
    SC_GroupBoxFrame: typing.ClassVar[QStyle.SubControl] = ...
    SC_GroupBoxLabel: typing.ClassVar[QStyle.SubControl] = ...
    SC_MdiCloseButton: typing.ClassVar[QStyle.SubControl] = ...
    SC_MdiMinButton: typing.ClassVar[QStyle.SubControl] = ...
    SC_MdiNormalButton: typing.ClassVar[QStyle.SubControl] = ...
    SC_None: typing.ClassVar[QStyle.SubControl] = ...
    SC_ScrollBarAddLine: typing.ClassVar[QStyle.SubControl] = ...
    SC_ScrollBarAddPage: typing.ClassVar[QStyle.SubControl] = ...
    SC_ScrollBarFirst: typing.ClassVar[QStyle.SubControl] = ...
    SC_ScrollBarGroove: typing.ClassVar[QStyle.SubControl] = ...
    SC_ScrollBarLast: typing.ClassVar[QStyle.SubControl] = ...
    SC_ScrollBarSlider: typing.ClassVar[QStyle.SubControl] = ...
    SC_ScrollBarSubLine: typing.ClassVar[QStyle.SubControl] = ...
    SC_ScrollBarSubPage: typing.ClassVar[QStyle.SubControl] = ...
    SC_SliderGroove: typing.ClassVar[QStyle.SubControl] = ...
    SC_SliderHandle: typing.ClassVar[QStyle.SubControl] = ...
    SC_SliderTickmarks: typing.ClassVar[QStyle.SubControl] = ...
    SC_SpinBoxDown: typing.ClassVar[QStyle.SubControl] = ...
    SC_SpinBoxEditField: typing.ClassVar[QStyle.SubControl] = ...
    SC_SpinBoxFrame: typing.ClassVar[QStyle.SubControl] = ...
    SC_SpinBoxUp: typing.ClassVar[QStyle.SubControl] = ...
    SC_TitleBarCloseButton: typing.ClassVar[QStyle.SubControl] = ...
    SC_TitleBarContextHelpButton: typing.ClassVar[QStyle.SubControl] = ...
    SC_TitleBarLabel: typing.ClassVar[QStyle.SubControl] = ...
    SC_TitleBarMaxButton: typing.ClassVar[QStyle.SubControl] = ...
    SC_TitleBarMinButton: typing.ClassVar[QStyle.SubControl] = ...
    SC_TitleBarNormalButton: typing.ClassVar[QStyle.SubControl] = ...
    SC_TitleBarShadeButton: typing.ClassVar[QStyle.SubControl] = ...
    SC_TitleBarSysMenu: typing.ClassVar[QStyle.SubControl] = ...
    SC_TitleBarUnshadeButton: typing.ClassVar[QStyle.SubControl] = ...
    SC_ToolButton: typing.ClassVar[QStyle.SubControl] = ...
    SC_ToolButtonMenu: typing.ClassVar[QStyle.SubControl] = ...
    SE_CheckBoxClickRect: typing.ClassVar[QStyle.SubElement] = ...
    SE_CheckBoxContents: typing.ClassVar[QStyle.SubElement] = ...
    SE_CheckBoxFocusRect: typing.ClassVar[QStyle.SubElement] = ...
    SE_CheckBoxIndicator: typing.ClassVar[QStyle.SubElement] = ...
    SE_CheckBoxLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_ComboBoxFocusRect: typing.ClassVar[QStyle.SubElement] = ...
    SE_ComboBoxLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_CustomBase: typing.ClassVar[QStyle.SubElement] = ...
    SE_DateTimeEditLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_DialogButtonBoxLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_DockWidgetCloseButton: typing.ClassVar[QStyle.SubElement] = ...
    SE_DockWidgetFloatButton: typing.ClassVar[QStyle.SubElement] = ...
    SE_DockWidgetIcon: typing.ClassVar[QStyle.SubElement] = ...
    SE_DockWidgetTitleBarText: typing.ClassVar[QStyle.SubElement] = ...
    SE_FrameContents: typing.ClassVar[QStyle.SubElement] = ...
    SE_FrameLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_GroupBoxLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_HeaderArrow: typing.ClassVar[QStyle.SubElement] = ...
    SE_HeaderLabel: typing.ClassVar[QStyle.SubElement] = ...
    SE_ItemViewItemCheckIndicator: typing.ClassVar[QStyle.SubElement] = ...
    SE_ItemViewItemDecoration: typing.ClassVar[QStyle.SubElement] = ...
    SE_ItemViewItemFocusRect: typing.ClassVar[QStyle.SubElement] = ...
    SE_ItemViewItemText: typing.ClassVar[QStyle.SubElement] = ...
    SE_LabelLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_LineEditContents: typing.ClassVar[QStyle.SubElement] = ...
    SE_ProgressBarContents: typing.ClassVar[QStyle.SubElement] = ...
    SE_ProgressBarGroove: typing.ClassVar[QStyle.SubElement] = ...
    SE_ProgressBarLabel: typing.ClassVar[QStyle.SubElement] = ...
    SE_ProgressBarLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_PushButtonBevel: typing.ClassVar[QStyle.SubElement] = ...
    SE_PushButtonContents: typing.ClassVar[QStyle.SubElement] = ...
    SE_PushButtonFocusRect: typing.ClassVar[QStyle.SubElement] = ...
    SE_PushButtonLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_RadioButtonClickRect: typing.ClassVar[QStyle.SubElement] = ...
    SE_RadioButtonContents: typing.ClassVar[QStyle.SubElement] = ...
    SE_RadioButtonFocusRect: typing.ClassVar[QStyle.SubElement] = ...
    SE_RadioButtonIndicator: typing.ClassVar[QStyle.SubElement] = ...
    SE_RadioButtonLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_ShapedFrameContents: typing.ClassVar[QStyle.SubElement] = ...
    SE_SliderFocusRect: typing.ClassVar[QStyle.SubElement] = ...
    SE_SliderLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_SpinBoxLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_TabBarScrollLeftButton: typing.ClassVar[QStyle.SubElement] = ...
    SE_TabBarScrollRightButton: typing.ClassVar[QStyle.SubElement] = ...
    SE_TabBarTabLeftButton: typing.ClassVar[QStyle.SubElement] = ...
    SE_TabBarTabRightButton: typing.ClassVar[QStyle.SubElement] = ...
    SE_TabBarTabText: typing.ClassVar[QStyle.SubElement] = ...
    SE_TabBarTearIndicator: typing.ClassVar[QStyle.SubElement] = ...
    SE_TabBarTearIndicatorLeft: typing.ClassVar[QStyle.SubElement] = ...
    SE_TabBarTearIndicatorRight: typing.ClassVar[QStyle.SubElement] = ...
    SE_TabWidgetLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_TabWidgetLeftCorner: typing.ClassVar[QStyle.SubElement] = ...
    SE_TabWidgetRightCorner: typing.ClassVar[QStyle.SubElement] = ...
    SE_TabWidgetTabBar: typing.ClassVar[QStyle.SubElement] = ...
    SE_TabWidgetTabContents: typing.ClassVar[QStyle.SubElement] = ...
    SE_TabWidgetTabPane: typing.ClassVar[QStyle.SubElement] = ...
    SE_ToolBarHandle: typing.ClassVar[QStyle.SubElement] = ...
    SE_ToolBoxTabContents: typing.ClassVar[QStyle.SubElement] = ...
    SE_ToolButtonLayoutItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_TreeViewDisclosureItem: typing.ClassVar[QStyle.SubElement] = ...
    SE_ViewItemCheckIndicator: typing.ClassVar[QStyle.SubElement] = ...
    SH_BlinkCursorWhenTextSelected: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Button_FocusPolicy: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ComboBox_AllowWheelScrolling: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ComboBox_LayoutDirection: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ComboBox_ListMouseTracking: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ComboBox_Popup: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ComboBox_PopupFrameStyle: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ComboBox_UseNativePopup: typing.ClassVar[QStyle.StyleHint] = ...
    SH_CustomBase: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Dial_BackgroundRole: typing.ClassVar[QStyle.StyleHint] = ...
    SH_DialogButtonBox_ButtonsHaveIcons: typing.ClassVar[QStyle.StyleHint] = ...
    SH_DialogButtonLayout: typing.ClassVar[QStyle.StyleHint] = ...
    SH_DialogButtons_DefaultButton: typing.ClassVar[QStyle.StyleHint] = ...
    SH_DitherDisabledText: typing.ClassVar[QStyle.StyleHint] = ...
    SH_DockWidget_ButtonsHaveFrame: typing.ClassVar[QStyle.StyleHint] = ...
    SH_DrawMenuBarSeparator: typing.ClassVar[QStyle.StyleHint] = ...
    SH_EtchDisabledText: typing.ClassVar[QStyle.StyleHint] = ...
    SH_FocusFrame_AboveWidget: typing.ClassVar[QStyle.StyleHint] = ...
    SH_FocusFrame_Mask: typing.ClassVar[QStyle.StyleHint] = ...
    SH_FontDialog_SelectAssociatedText: typing.ClassVar[QStyle.StyleHint] = ...
    SH_FormLayoutFieldGrowthPolicy: typing.ClassVar[QStyle.StyleHint] = ...
    SH_FormLayoutFormAlignment: typing.ClassVar[QStyle.StyleHint] = ...
    SH_FormLayoutLabelAlignment: typing.ClassVar[QStyle.StyleHint] = ...
    SH_FormLayoutWrapPolicy: typing.ClassVar[QStyle.StyleHint] = ...
    SH_GroupBox_TextLabelColor: typing.ClassVar[QStyle.StyleHint] = ...
    SH_GroupBox_TextLabelVerticalAlignment: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Header_ArrowAlignment: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ItemView_ActivateItemOnSingleClick: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ItemView_ArrowKeysNavigateIntoChildren: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ItemView_ChangeHighlightOnFocus: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ItemView_DrawDelegateFrame: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ItemView_EllipsisLocation: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ItemView_MovementWithoutUpdatingSelection: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ItemView_PaintAlternatingRowColorsForEmptyArea: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ItemView_ScrollMode: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ItemView_ShowDecorationSelected: typing.ClassVar[QStyle.StyleHint] = ...
    SH_LineEdit_PasswordCharacter: typing.ClassVar[QStyle.StyleHint] = ...
    SH_LineEdit_PasswordMaskDelay: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ListViewExpand_SelectMouseType: typing.ClassVar[QStyle.StyleHint] = ...
    SH_MainWindow_SpaceBelowMenuBar: typing.ClassVar[QStyle.StyleHint] = ...
    SH_MenuBar_AltKeyNavigation: typing.ClassVar[QStyle.StyleHint] = ...
    SH_MenuBar_MouseTracking: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_AllowActiveAndDisabled: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_FadeOutOnHide: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_FillScreenWithScroll: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_FlashTriggeredItem: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_KeyboardSearch: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_Mask: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_MouseTracking: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_Scrollable: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_SelectionWrap: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_SloppySubMenus: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_SpaceActivatesItem: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_SubMenuDontStartSloppyOnLeave: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_SubMenuPopupDelay: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_SubMenuResetWhenReenteringParent: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_SubMenuSloppyCloseTimeout: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_SubMenuSloppySelectOtherActions: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_SubMenuUniDirection: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_SubMenuUniDirectionFailCount: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Menu_SupportsSections: typing.ClassVar[QStyle.StyleHint] = ...
    SH_MessageBox_CenterButtons: typing.ClassVar[QStyle.StyleHint] = ...
    SH_MessageBox_TextInteractionFlags: typing.ClassVar[QStyle.StyleHint] = ...
    SH_MessageBox_UseBorderForButtonSpacing: typing.ClassVar[QStyle.StyleHint] = ...
    SH_PrintDialog_RightAlignButtons: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ProgressDialog_CenterCancelButton: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ProgressDialog_TextLabelAlignment: typing.ClassVar[QStyle.StyleHint] = ...
    SH_RequestSoftwareInputPanel: typing.ClassVar[QStyle.StyleHint] = ...
    SH_RichText_FullWidthSelection: typing.ClassVar[QStyle.StyleHint] = ...
    SH_RubberBand_Mask: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ScrollBar_ContextMenu: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ScrollBar_LeftClickAbsolutePosition: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ScrollBar_MiddleClickAbsolutePosition: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ScrollBar_RollBetweenButtons: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ScrollBar_ScrollWhenPointerLeavesControl: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ScrollBar_StopMouseOverSlider: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ScrollBar_Transient: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ScrollView_FrameOnlyAroundContents: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Slider_AbsoluteSetButtons: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Slider_PageSetButtons: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Slider_SloppyKeyEvents: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Slider_SnapToValue: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Slider_StopMouseOverSlider: typing.ClassVar[QStyle.StyleHint] = ...
    SH_SpellCheckUnderlineStyle: typing.ClassVar[QStyle.StyleHint] = ...
    SH_SpinBox_AnimateButton: typing.ClassVar[QStyle.StyleHint] = ...
    SH_SpinBox_ButtonsInsideFrame: typing.ClassVar[QStyle.StyleHint] = ...
    SH_SpinBox_ClickAutoRepeatRate: typing.ClassVar[QStyle.StyleHint] = ...
    SH_SpinBox_ClickAutoRepeatThreshold: typing.ClassVar[QStyle.StyleHint] = ...
    SH_SpinBox_KeyPressAutoRepeatRate: typing.ClassVar[QStyle.StyleHint] = ...
    SH_SpinBox_StepModifier: typing.ClassVar[QStyle.StyleHint] = ...
    SH_SpinControls_DisableOnBounds: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Splitter_OpaqueResize: typing.ClassVar[QStyle.StyleHint] = ...
    SH_TabBar_Alignment: typing.ClassVar[QStyle.StyleHint] = ...
    SH_TabBar_ChangeCurrentDelay: typing.ClassVar[QStyle.StyleHint] = ...
    SH_TabBar_CloseButtonPosition: typing.ClassVar[QStyle.StyleHint] = ...
    SH_TabBar_ElideMode: typing.ClassVar[QStyle.StyleHint] = ...
    SH_TabBar_PreferNoArrows: typing.ClassVar[QStyle.StyleHint] = ...
    SH_TabBar_SelectMouseType: typing.ClassVar[QStyle.StyleHint] = ...
    SH_TabWidget_DefaultTabPosition: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Table_GridLineColor: typing.ClassVar[QStyle.StyleHint] = ...
    SH_TextControl_FocusIndicatorTextCharFormat: typing.ClassVar[QStyle.StyleHint] = ...
    SH_TitleBar_AutoRaise: typing.ClassVar[QStyle.StyleHint] = ...
    SH_TitleBar_ModifyNotification: typing.ClassVar[QStyle.StyleHint] = ...
    SH_TitleBar_NoBorder: typing.ClassVar[QStyle.StyleHint] = ...
    SH_TitleBar_ShowToolTipsOnButtons: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ToolBar_Movable: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ToolBox_SelectedPageTitleBold: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ToolButtonStyle: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ToolButton_PopupDelay: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ToolTipLabel_Opacity: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ToolTip_FallAsleepDelay: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ToolTip_Mask: typing.ClassVar[QStyle.StyleHint] = ...
    SH_ToolTip_WakeUpDelay: typing.ClassVar[QStyle.StyleHint] = ...
    SH_UnderlineShortcut: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Widget_Animate: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Widget_Animation_Duration: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Widget_ShareActivation: typing.ClassVar[QStyle.StyleHint] = ...
    SH_WindowFrame_Mask: typing.ClassVar[QStyle.StyleHint] = ...
    SH_WizardStyle: typing.ClassVar[QStyle.StyleHint] = ...
    SH_Workspace_FillSpaceOnMaximize: typing.ClassVar[QStyle.StyleHint] = ...
    SP_ArrowBack: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_ArrowDown: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_ArrowForward: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_ArrowLeft: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_ArrowRight: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_ArrowUp: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_BrowserReload: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_BrowserStop: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_CommandLink: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_ComputerIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_CustomBase: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DesktopIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogAbortButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogApplyButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogCancelButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogCloseButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogDiscardButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogHelpButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogIgnoreButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogNoButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogNoToAllButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogOkButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogOpenButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogResetButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogRetryButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogSaveAllButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogSaveButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogYesButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DialogYesToAllButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DirClosedIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DirHomeIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DirIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DirLinkIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DirLinkOpenIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DirOpenIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DockWidgetCloseButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DriveCDIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DriveDVDIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DriveFDIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DriveHDIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_DriveNetIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_FileDialogBack: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_FileDialogContentsView: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_FileDialogDetailedView: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_FileDialogEnd: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_FileDialogInfoView: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_FileDialogListView: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_FileDialogNewFolder: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_FileDialogStart: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_FileDialogToParent: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_FileIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_FileLinkIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_LineEditClearButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_MediaPause: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_MediaPlay: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_MediaSeekBackward: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_MediaSeekForward: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_MediaSkipBackward: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_MediaSkipForward: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_MediaStop: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_MediaVolume: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_MediaVolumeMuted: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_MessageBoxCritical: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_MessageBoxInformation: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_MessageBoxQuestion: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_MessageBoxWarning: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_RestoreDefaultsButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_TitleBarCloseButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_TitleBarContextHelpButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_TitleBarMaxButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_TitleBarMenuButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_TitleBarMinButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_TitleBarNormalButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_TitleBarShadeButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_TitleBarUnshadeButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_ToolBarHorizontalExtensionButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_ToolBarVerticalExtensionButton: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_TrashIcon: typing.ClassVar[QStyle.StandardPixmap] = ...
    SP_VistaShield: typing.ClassVar[QStyle.StandardPixmap] = ...
    State_Active: typing.ClassVar[QStyle.StateFlag] = ...
    State_AutoRaise: typing.ClassVar[QStyle.StateFlag] = ...
    State_Bottom: typing.ClassVar[QStyle.StateFlag] = ...
    State_Children: typing.ClassVar[QStyle.StateFlag] = ...
    State_DownArrow: typing.ClassVar[QStyle.StateFlag] = ...
    State_Editing: typing.ClassVar[QStyle.StateFlag] = ...
    State_Enabled: typing.ClassVar[QStyle.StateFlag] = ...
    State_FocusAtBorder: typing.ClassVar[QStyle.StateFlag] = ...
    State_HasFocus: typing.ClassVar[QStyle.StateFlag] = ...
    State_Horizontal: typing.ClassVar[QStyle.StateFlag] = ...
    State_Item: typing.ClassVar[QStyle.StateFlag] = ...
    State_KeyboardFocusChange: typing.ClassVar[QStyle.StateFlag] = ...
    State_Mini: typing.ClassVar[QStyle.StateFlag] = ...
    State_MouseOver: typing.ClassVar[QStyle.StateFlag] = ...
    State_NoChange: typing.ClassVar[QStyle.StateFlag] = ...
    State_None: typing.ClassVar[QStyle.StateFlag] = ...
    State_Off: typing.ClassVar[QStyle.StateFlag] = ...
    State_On: typing.ClassVar[QStyle.StateFlag] = ...
    State_Open: typing.ClassVar[QStyle.StateFlag] = ...
    State_Raised: typing.ClassVar[QStyle.StateFlag] = ...
    State_ReadOnly: typing.ClassVar[QStyle.StateFlag] = ...
    State_Selected: typing.ClassVar[QStyle.StateFlag] = ...
    State_Sibling: typing.ClassVar[QStyle.StateFlag] = ...
    State_Small: typing.ClassVar[QStyle.StateFlag] = ...
    State_Sunken: typing.ClassVar[QStyle.StateFlag] = ...
    State_Top: typing.ClassVar[QStyle.StateFlag] = ...
    State_UpArrow: typing.ClassVar[QStyle.StateFlag] = ...
    State_Window: typing.ClassVar[QStyle.StateFlag] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @classmethod
    def alignedRect(cls, direction: PySide2.QtCore.Qt.LayoutDirection, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag], size: PySide2.QtCore.QSize, rectangle: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def combinedLayoutSpacing(self, controls1: typing.Union[QSizePolicy.ControlTypes,QSizePolicy.ControlType], controls2: typing.Union[QSizePolicy.ControlTypes,QSizePolicy.ControlType], orientation: PySide2.QtCore.Qt.Orientation, option: typing.Union[QStyleOption,None] = ..., widget: typing.Union[QWidget,None] = ...) -> int: ...
    def drawComplexControl(self, cc: QStyle.ComplexControl, opt: QStyleOptionComplex, p: PySide2.Q