from typing import overload
import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets
import shiboken2
import typing
T = typing.TypeVar('T')

class QtCharts(shiboken2.Object):
    class QAbstractAxis(PySide2.QtCore.QObject):
        class AxisType:
            AxisTypeBarCategory: typing.ClassVar[QtCharts.QAbstractAxis.AxisType] = ...
            AxisTypeCategory: typing.ClassVar[QtCharts.QAbstractAxis.AxisType] = ...
            AxisTypeDateTime: typing.ClassVar[QtCharts.QAbstractAxis.AxisType] = ...
            AxisTypeLogValue: typing.ClassVar[QtCharts.QAbstractAxis.AxisType] = ...
            AxisTypeNoAxis: typing.ClassVar[QtCharts.QAbstractAxis.AxisType] = ...
            AxisTypeValue: typing.ClassVar[QtCharts.QAbstractAxis.AxisType] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtCharts.QAbstractAxis.AxisType: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QAbstractAxis.AxisType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtCharts.QAbstractAxis.AxisType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QAbstractAxis.AxisType: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> QtCharts.QAbstractAxis.AxisType: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QAbstractAxis.AxisType: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtCharts.QAbstractAxis.AxisType: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QAbstractAxis.AxisType: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtCharts.QAbstractAxis.AxisType: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QAbstractAxis.AxisType: ...
            def __sub__(self, other: typing.SupportsInt) -> QtCharts.QAbstractAxis.AxisType: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QAbstractAxis.AxisType: ...
        AxisTypeBarCategory: typing.ClassVar[QtCharts.QAbstractAxis.AxisType] = ...
        AxisTypeCategory: typing.ClassVar[QtCharts.QAbstractAxis.AxisType] = ...
        AxisTypeDateTime: typing.ClassVar[QtCharts.QAbstractAxis.AxisType] = ...
        AxisTypeLogValue: typing.ClassVar[QtCharts.QAbstractAxis.AxisType] = ...
        AxisTypeNoAxis: typing.ClassVar[QtCharts.QAbstractAxis.AxisType] = ...
        AxisTypeValue: typing.ClassVar[QtCharts.QAbstractAxis.AxisType] = ...
        colorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        gridLineColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        gridLinePenChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        gridVisibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsAngleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsBrushChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsEditableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsFontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsVisibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        linePenChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lineVisibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minorGridLineColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minorGridLinePenChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minorGridVisibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        reverseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shadesBorderColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shadesBrushChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shadesColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shadesPenChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shadesVisibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        titleBrushChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        titleFontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        titleTextChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        titleVisibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        visibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def alignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
        def gridLineColor(self) -> PySide2.QtGui.QColor: ...
        def gridLinePen(self) -> PySide2.QtGui.QPen: ...
        def hide(self) -> None: ...
        def isGridLineVisible(self) -> bool: ...
        def isLineVisible(self) -> bool: ...
        def isMinorGridLineVisible(self) -> bool: ...
        def isReverse(self) -> bool: ...
        def isTitleVisible(self) -> bool: ...
        def isVisible(self) -> bool: ...
        def labelsAngle(self) -> int: ...
        def labelsBrush(self) -> PySide2.QtGui.QBrush: ...
        def labelsColor(self) -> PySide2.QtGui.QColor: ...
        def labelsEditable(self) -> bool: ...
        def labelsFont(self) -> PySide2.QtGui.QFont: ...
        def labelsVisible(self) -> bool: ...
        def linePen(self) -> PySide2.QtGui.QPen: ...
        def linePenColor(self) -> PySide2.QtGui.QColor: ...
        def minorGridLineColor(self) -> PySide2.QtGui.QColor: ...
        def minorGridLinePen(self) -> PySide2.QtGui.QPen: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def setGridLineColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setGridLinePen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def setGridLineVisible(self, visible: bool = ...) -> None: ...
        def setLabelsAngle(self, angle: int) -> None: ...
        def setLabelsBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setLabelsColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setLabelsEditable(self, editable: bool = ...) -> None: ...
        def setLabelsFont(self, font: PySide2.QtGui.QFont) -> None: ...
        def setLabelsVisible(self, visible: bool = ...) -> None: ...
        def setLinePen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def setLinePenColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setLineVisible(self, visible: bool = ...) -> None: ...
        def setMax(self, max: typing.Any) -> None: ...
        def setMin(self, min: typing.Any) -> None: ...
        def setMinorGridLineColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setMinorGridLinePen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def setMinorGridLineVisible(self, visible: bool = ...) -> None: ...
        def setRange(self, min: typing.Any, max: typing.Any) -> None: ...
        def setReverse(self, reverse: bool = ...) -> None: ...
        def setShadesBorderColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setShadesBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setShadesColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setShadesPen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def setShadesVisible(self, visible: bool = ...) -> None: ...
        def setTitleBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setTitleFont(self, font: PySide2.QtGui.QFont) -> None: ...
        def setTitleText(self, title: str) -> None: ...
        def setTitleVisible(self, visible: bool = ...) -> None: ...
        def setVisible(self, visible: bool = ...) -> None: ...
        def shadesBorderColor(self) -> PySide2.QtGui.QColor: ...
        def shadesBrush(self) -> PySide2.QtGui.QBrush: ...
        def shadesColor(self) -> PySide2.QtGui.QColor: ...
        def shadesPen(self) -> PySide2.QtGui.QPen: ...
        def shadesVisible(self) -> bool: ...
        def show(self) -> None: ...
        def titleBrush(self) -> PySide2.QtGui.QBrush: ...
        def titleFont(self) -> PySide2.QtGui.QFont: ...
        def titleText(self) -> str: ...
        def type(self) -> QtCharts.QAbstractAxis.AxisType: ...

    class QAbstractBarSeries(QtCharts.QAbstractSeries):
        class LabelsPosition:
            LabelsCenter: typing.ClassVar[QtCharts.QAbstractBarSeries.LabelsPosition] = ...
            LabelsInsideBase: typing.ClassVar[QtCharts.QAbstractBarSeries.LabelsPosition] = ...
            LabelsInsideEnd: typing.ClassVar[QtCharts.QAbstractBarSeries.LabelsPosition] = ...
            LabelsOutsideEnd: typing.ClassVar[QtCharts.QAbstractBarSeries.LabelsPosition] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtCharts.QAbstractBarSeries.LabelsPosition: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QAbstractBarSeries.LabelsPosition: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtCharts.QAbstractBarSeries.LabelsPosition: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QAbstractBarSeries.LabelsPosition: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> QtCharts.QAbstractBarSeries.LabelsPosition: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QAbstractBarSeries.LabelsPosition: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtCharts.QAbstractBarSeries.LabelsPosition: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QAbstractBarSeries.LabelsPosition: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtCharts.QAbstractBarSeries.LabelsPosition: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QAbstractBarSeries.LabelsPosition: ...
            def __sub__(self, other: typing.SupportsInt) -> QtCharts.QAbstractBarSeries.LabelsPosition: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QAbstractBarSeries.LabelsPosition: ...
        LabelsCenter: typing.ClassVar[QtCharts.QAbstractBarSeries.LabelsPosition] = ...
        LabelsInsideBase: typing.ClassVar[QtCharts.QAbstractBarSeries.LabelsPosition] = ...
        LabelsInsideEnd: typing.ClassVar[QtCharts.QAbstractBarSeries.LabelsPosition] = ...
        LabelsOutsideEnd: typing.ClassVar[QtCharts.QAbstractBarSeries.LabelsPosition] = ...
        barsetsAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
        barsetsRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        countChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        doubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsAngleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsFormatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsPositionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsPrecisionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsVisibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        released: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        @overload
        def append(self, set: QtCharts.QBarSet) -> bool: ...
        @overload
        def append(self, sets: typing.Iterable[QtCharts.QBarSet]) -> bool: ...
        def barSets(self) -> typing.List[QtCharts.QBarSet]: ...
        def barWidth(self) -> float: ...
        def clear(self) -> None: ...
        def count(self) -> int: ...
        def insert(self, index: int, set: QtCharts.QBarSet) -> bool: ...
        def isLabelsVisible(self) -> bool: ...
        def labelsAngle(self) -> float: ...
        def labelsFormat(self) -> str: ...
        def labelsPosition(self) -> QtCharts.QAbstractBarSeries.LabelsPosition: ...
        def labelsPrecision(self) -> int: ...
        def remove(self, set: QtCharts.QBarSet) -> bool: ...
        def setBarWidth(self, width: float) -> None: ...
        def setLabelsAngle(self, angle: float) -> None: ...
        def setLabelsFormat(self, format: str) -> None: ...
        def setLabelsPosition(self, position: QtCharts.QAbstractBarSeries.LabelsPosition) -> None: ...
        def setLabelsPrecision(self, precision: int) -> None: ...
        def setLabelsVisible(self, visible: bool = ...) -> None: ...
        def take(self, set: QtCharts.QBarSet) -> bool: ...

    class QAbstractSeries(PySide2.QtCore.QObject):
        class SeriesType:
            SeriesTypeArea: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
            SeriesTypeBar: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
            SeriesTypeBoxPlot: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
            SeriesTypeCandlestick: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
            SeriesTypeHorizontalBar: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
            SeriesTypeHorizontalPercentBar: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
            SeriesTypeHorizontalStackedBar: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
            SeriesTypeLine: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
            SeriesTypePercentBar: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
            SeriesTypePie: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
            SeriesTypeScatter: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
            SeriesTypeSpline: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
            SeriesTypeStackedBar: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtCharts.QAbstractSeries.SeriesType: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QAbstractSeries.SeriesType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtCharts.QAbstractSeries.SeriesType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QAbstractSeries.SeriesType: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> QtCharts.QAbstractSeries.SeriesType: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QAbstractSeries.SeriesType: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtCharts.QAbstractSeries.SeriesType: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QAbstractSeries.SeriesType: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtCharts.QAbstractSeries.SeriesType: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QAbstractSeries.SeriesType: ...
            def __sub__(self, other: typing.SupportsInt) -> QtCharts.QAbstractSeries.SeriesType: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QAbstractSeries.SeriesType: ...
        SeriesTypeArea: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
        SeriesTypeBar: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
        SeriesTypeBoxPlot: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
        SeriesTypeCandlestick: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
        SeriesTypeHorizontalBar: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
        SeriesTypeHorizontalPercentBar: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
        SeriesTypeHorizontalStackedBar: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
        SeriesTypeLine: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
        SeriesTypePercentBar: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
        SeriesTypePie: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
        SeriesTypeScatter: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
        SeriesTypeSpline: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
        SeriesTypeStackedBar: typing.ClassVar[QtCharts.QAbstractSeries.SeriesType] = ...
        nameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        opacityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        useOpenGLChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        visibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def attachAxis(self, axis: QtCharts.QAbstractAxis) -> bool: ...
        def attachedAxes(self) -> typing.List[QtCharts.QAbstractAxis]: ...
        def chart(self) -> QtCharts.QChart: ...
        def detachAxis(self, axis: QtCharts.QAbstractAxis) -> bool: ...
        def hide(self) -> None: ...
        def isVisible(self) -> bool: ...
        def name(self) -> str: ...
        def opacity(self) -> float: ...
        def setName(self, name: str) -> None: ...
        def setOpacity(self, opacity: float) -> None: ...
        def setUseOpenGL(self, enable: bool = ...) -> None: ...
        def setVisible(self, visible: bool = ...) -> None: ...
        def show(self) -> None: ...
        def type(self) -> QtCharts.QAbstractSeries.SeriesType: ...
        def useOpenGL(self) -> bool: ...

    class QAreaLegendMarker(QtCharts.QLegendMarker):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, series: QtCharts.QAreaSeries, legend: QtCharts.QLegend, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., brushChanged: typing.Callable = ..., clicked: typing.Callable = ..., destroyed: typing.Callable = ..., font: PySide2.QtGui.QFont = ..., fontChanged: typing.Callable = ..., hovered: typing.Callable = ..., label: str = ..., labelBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., labelBrushChanged: typing.Callable = ..., labelChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pen: PySide2.QtGui.QPen = ..., penChanged: typing.Callable = ..., shape: typing.Any = ..., shapeChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def series(self) -> QtCharts.QAreaSeries: ...
        def type(self) -> QtCharts.QLegendMarker.LegendMarkerType: ...

    class QAreaSeries(QtCharts.QAbstractSeries):
        borderColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        colorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        doubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointLabelsClippingChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointLabelsColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointLabelsFontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointLabelsFormatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointLabelsVisibilityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        released: typing.ClassVar[PySide2.QtCore.Signal] = ...
        selected: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @overload
        def __init__(self, upperSeries: QtCharts.QLineSeries, lowerSeries: typing.Union[QtCharts.QLineSeries,None] = ..., borderColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., borderColorChanged: typing.Callable = ..., clicked: typing.Callable = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., colorChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., pointLabelsClipping: bool = ..., pointLabelsClippingChanged: typing.Callable = ..., pointLabelsColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., pointLabelsColorChanged: typing.Callable = ..., pointLabelsFont: PySide2.QtGui.QFont = ..., pointLabelsFontChanged: typing.Callable = ..., pointLabelsFormat: str = ..., pointLabelsFormatChanged: typing.Callable = ..., pointLabelsVisibilityChanged: typing.Callable = ..., pointLabelsVisible: bool = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., selected: typing.Callable = ..., type: QtCharts.QAreaSeries.SeriesType = ..., useOpenGL: bool = ..., useOpenGLChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        @overload
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., borderColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., borderColorChanged: typing.Callable = ..., clicked: typing.Callable = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., colorChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., lowerSeries: QtCharts.QLineSeries = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., pointLabelsClipping: bool = ..., pointLabelsClippingChanged: typing.Callable = ..., pointLabelsColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., pointLabelsColorChanged: typing.Callable = ..., pointLabelsFont: PySide2.QtGui.QFont = ..., pointLabelsFontChanged: typing.Callable = ..., pointLabelsFormat: str = ..., pointLabelsFormatChanged: typing.Callable = ..., pointLabelsVisibilityChanged: typing.Callable = ..., pointLabelsVisible: bool = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., selected: typing.Callable = ..., type: QtCharts.QAreaSeries.SeriesType = ..., upperSeries: QtCharts.QLineSeries = ..., useOpenGL: bool = ..., useOpenGLChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def borderColor(self) -> PySide2.QtGui.QColor: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def color(self) -> PySide2.QtGui.QColor: ...
        def lowerSeries(self) -> QtCharts.QLineSeries: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def pointLabelsClipping(self) -> bool: ...
        def pointLabelsColor(self) -> PySide2.QtGui.QColor: ...
        def pointLabelsFont(self) -> PySide2.QtGui.QFont: ...
        def pointLabelsFormat(self) -> str: ...
        def pointLabelsVisible(self) -> bool: ...
        def pointsVisible(self) -> bool: ...
        def setBorderColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setLowerSeries(self, series: QtCharts.QLineSeries) -> None: ...
        def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def setPointLabelsClipping(self, enabled: bool = ...) -> None: ...
        def setPointLabelsColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setPointLabelsFont(self, font: PySide2.QtGui.QFont) -> None: ...
        def setPointLabelsFormat(self, format: str) -> None: ...
        def setPointLabelsVisible(self, visible: bool = ...) -> None: ...
        def setPointsVisible(self, visible: bool = ...) -> None: ...
        def setUpperSeries(self, series: QtCharts.QLineSeries) -> None: ...
        def type(self) -> QtCharts.QAbstractSeries.SeriesType: ...
        def upperSeries(self) -> QtCharts.QLineSeries: ...

    class QBarCategoryAxis(QtCharts.QAbstractAxis):
        categoriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        countChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        maxChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rangeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., categories: None = ..., categoriesChanged: typing.Callable = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., colorChanged: typing.Callable = ..., count: int = ..., countChanged: typing.Callable = ..., destroyed: typing.Callable = ..., gridLineColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., gridLineColorChanged: typing.Callable = ..., gridLinePen: PySide2.QtGui.QPen = ..., gridLinePenChanged: typing.Callable = ..., gridVisible: bool = ..., gridVisibleChanged: typing.Callable = ..., labelsAngle: int = ..., labelsAngleChanged: typing.Callable = ..., labelsBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., labelsBrushChanged: typing.Callable = ..., labelsColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., labelsColorChanged: typing.Callable = ..., labelsEditableChanged: typing.Callable = ..., labelsFont: PySide2.QtGui.QFont = ..., labelsFontChanged: typing.Callable = ..., labelsVisible: bool = ..., labelsVisibleChanged: typing.Callable = ..., linePen: PySide2.QtGui.QPen = ..., linePenChanged: typing.Callable = ..., lineVisible: bool = ..., lineVisibleChanged: typing.Callable = ..., max: str = ..., maxChanged: typing.Callable = ..., min: str = ..., minChanged: typing.Callable = ..., minorGridLineColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., minorGridLineColorChanged: typing.Callable = ..., minorGridLinePen: PySide2.QtGui.QPen = ..., minorGridLinePenChanged: typing.Callable = ..., minorGridVisible: bool = ..., minorGridVisibleChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., rangeChanged: typing.Callable = ..., reverse: bool = ..., reverseChanged: typing.Callable = ..., shadesBorderColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., shadesBorderColorChanged: typing.Callable = ..., shadesBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., shadesBrushChanged: typing.Callable = ..., shadesColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., shadesColorChanged: typing.Callable = ..., shadesPen: PySide2.QtGui.QPen = ..., shadesPenChanged: typing.Callable = ..., shadesVisible: bool = ..., shadesVisibleChanged: typing.Callable = ..., titleBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., titleBrushChanged: typing.Callable = ..., titleFont: PySide2.QtGui.QFont = ..., titleFontChanged: typing.Callable = ..., titleText: str = ..., titleTextChanged: typing.Callable = ..., titleVisible: bool = ..., titleVisibleChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        @overload
        def append(self, categories: typing.Iterable[str]) -> None: ...
        @overload
        def append(self, category: str) -> None: ...
        def at(self, index: int) -> str: ...
        def categories(self) -> typing.List[str]: ...
        def clear(self) -> None: ...
        def count(self) -> int: ...
        def insert(self, index: int, category: str) -> None: ...
        def max(self) -> str: ...
        def min(self) -> str: ...
        def remove(self, category: str) -> None: ...
        def replace(self, oldCategory: str, newCategory: str) -> None: ...
        def setCategories(self, categories: typing.Iterable[str]) -> None: ...
        @overload
        def setMax(self, max: typing.Any) -> None: ...
        @overload
        def setMax(self, maxCategory: str) -> None: ...
        @overload
        def setMin(self, min: typing.Any) -> None: ...
        @overload
        def setMin(self, minCategory: str) -> None: ...
        @overload
        def setRange(self, min: typing.Any, max: typing.Any) -> None: ...
        @overload
        def setRange(self, minCategory: str, maxCategory: str) -> None: ...
        def type(self) -> QtCharts.QAbstractAxis.AxisType: ...

    class QBarLegendMarker(QtCharts.QLegendMarker):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, series: QtCharts.QAbstractBarSeries, barset: QtCharts.QBarSet, legend: QtCharts.QLegend, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., brushChanged: typing.Callable = ..., clicked: typing.Callable = ..., destroyed: typing.Callable = ..., font: PySide2.QtGui.QFont = ..., fontChanged: typing.Callable = ..., hovered: typing.Callable = ..., label: str = ..., labelBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., labelBrushChanged: typing.Callable = ..., labelChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pen: PySide2.QtGui.QPen = ..., penChanged: typing.Callable = ..., shape: typing.Any = ..., shapeChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def barset(self) -> QtCharts.QBarSet: ...
        def series(self) -> QtCharts.QAbstractBarSeries: ...
        def type(self) -> QtCharts.QLegendMarker.LegendMarkerType: ...

    class QBarModelMapper(PySide2.QtCore.QObject):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
        def count(self) -> int: ...
        def first(self) -> int: ...
        def firstBarSetSection(self) -> int: ...
        def lastBarSetSection(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def series(self) -> QtCharts.QAbstractBarSeries: ...
        def setCount(self, count: int) -> None: ...
        def setFirst(self, first: int) -> None: ...
        def setFirstBarSetSection(self, firstBarSetSection: int) -> None: ...
        def setLastBarSetSection(self, lastBarSetSection: int) -> None: ...
        def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
        def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
        def setSeries(self, series: QtCharts.QAbstractBarSeries) -> None: ...

    class QBarSeries(QtCharts.QAbstractBarSeries):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., barWidth: float = ..., barsetsAdded: typing.Callable = ..., barsetsRemoved: typing.Callable = ..., clicked: typing.Callable = ..., count: int = ..., countChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., labelsAngle: float = ..., labelsAngleChanged: typing.Callable = ..., labelsFormat: str = ..., labelsFormatChanged: typing.Callable = ..., labelsPosition: QtCharts.QBarSeries.LabelsPosition = ..., labelsPositionChanged: typing.Callable = ..., labelsPrecision: int = ..., labelsPrecisionChanged: typing.Callable = ..., labelsVisible: bool = ..., labelsVisibleChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., type: QtCharts.QBarSeries.SeriesType = ..., useOpenGL: bool = ..., useOpenGLChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def type(self) -> QtCharts.QAbstractSeries.SeriesType: ...

    class QBarSet(PySide2.QtCore.QObject):
        borderColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        brushChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        colorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        doubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelBrushChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelFontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        penChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        released: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        valuesAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
        valuesRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, label: str, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
        @overload
        def append(self, value: float) -> None: ...
        @overload
        def append(self, values: typing.Iterable[float]) -> None: ...
        def at(self, index: int) -> float: ...
        def borderColor(self) -> PySide2.QtGui.QColor: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def color(self) -> PySide2.QtGui.QColor: ...
        def count(self) -> int: ...
        def insert(self, index: int, value: float) -> None: ...
        def label(self) -> str: ...
        def labelBrush(self) -> PySide2.QtGui.QBrush: ...
        def labelColor(self) -> PySide2.QtGui.QColor: ...
        def labelFont(self) -> PySide2.QtGui.QFont: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def remove(self, index: int, count: int = ...) -> None: ...
        def replace(self, index: int, value: float) -> None: ...
        def setBorderColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setLabel(self, label: str) -> None: ...
        def setLabelBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setLabelColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setLabelFont(self, font: PySide2.QtGui.QFont) -> None: ...
        def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def sum(self) -> float: ...
        def __lshift__(self, value: float) -> QtCharts.QBarSet: ...
        def __rlshift__(self, other) -> typing.Any: ...

    class QBoxPlotLegendMarker(QtCharts.QLegendMarker):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, series: QtCharts.QBoxPlotSeries, legend: QtCharts.QLegend, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., brushChanged: typing.Callable = ..., clicked: typing.Callable = ..., destroyed: typing.Callable = ..., font: PySide2.QtGui.QFont = ..., fontChanged: typing.Callable = ..., hovered: typing.Callable = ..., label: str = ..., labelBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., labelBrushChanged: typing.Callable = ..., labelChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pen: PySide2.QtGui.QPen = ..., penChanged: typing.Callable = ..., shape: typing.Any = ..., shapeChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def series(self) -> QtCharts.QBoxPlotSeries: ...
        def type(self) -> QtCharts.QLegendMarker.LegendMarkerType: ...

    class QBoxPlotModelMapper(PySide2.QtCore.QObject):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
        def count(self) -> int: ...
        def first(self) -> int: ...
        def firstBoxSetSection(self) -> int: ...
        def lastBoxSetSection(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def series(self) -> QtCharts.QBoxPlotSeries: ...
        def setCount(self, count: int) -> None: ...
        def setFirst(self, first: int) -> None: ...
        def setFirstBoxSetSection(self, firstBoxSetSection: int) -> None: ...
        def setLastBoxSetSection(self, lastBoxSetSection: int) -> None: ...
        def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
        def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
        def setSeries(self, series: QtCharts.QBoxPlotSeries) -> None: ...

    class QBoxPlotSeries(QtCharts.QAbstractSeries):
        boxOutlineVisibilityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        boxWidthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        boxsetsAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
        boxsetsRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
        brushChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        countChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        doubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
        penChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        released: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., boxOutlineVisibilityChanged: typing.Callable = ..., boxOutlineVisible: bool = ..., boxWidth: float = ..., boxWidthChanged: typing.Callable = ..., boxsetsAdded: typing.Callable = ..., boxsetsRemoved: typing.Callable = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., brushChanged: typing.Callable = ..., clicked: typing.Callable = ..., count: int = ..., countChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., pen: PySide2.QtGui.QPen = ..., penChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., type: QtCharts.QBoxPlotSeries.SeriesType = ..., useOpenGL: bool = ..., useOpenGLChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        @overload
        def append(self, box: QtCharts.QBoxSet) -> bool: ...
        @overload
        def append(self, boxes: typing.Iterable[QtCharts.QBoxSet]) -> bool: ...
        def boxOutlineVisible(self) -> bool: ...
        def boxSets(self) -> typing.List[QtCharts.QBoxSet]: ...
        def boxWidth(self) -> float: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def clear(self) -> None: ...
        def count(self) -> int: ...
        def insert(self, index: int, box: QtCharts.QBoxSet) -> bool: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def remove(self, box: QtCharts.QBoxSet) -> bool: ...
        def setBoxOutlineVisible(self, visible: bool) -> None: ...
        def setBoxWidth(self, width: float) -> None: ...
        def setBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def take(self, box: QtCharts.QBoxSet) -> bool: ...
        def type(self) -> QtCharts.QAbstractSeries.SeriesType: ...

    class QBoxSet(PySide2.QtCore.QObject):
        class ValuePositions:
            LowerExtreme: typing.ClassVar[QtCharts.QBoxSet.ValuePositions] = ...
            LowerQuartile: typing.ClassVar[QtCharts.QBoxSet.ValuePositions] = ...
            Median: typing.ClassVar[QtCharts.QBoxSet.ValuePositions] = ...
            UpperExtreme: typing.ClassVar[QtCharts.QBoxSet.ValuePositions] = ...
            UpperQuartile: typing.ClassVar[QtCharts.QBoxSet.ValuePositions] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtCharts.QBoxSet.ValuePositions: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QBoxSet.ValuePositions: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtCharts.QBoxSet.ValuePositions: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QBoxSet.ValuePositions: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> QtCharts.QBoxSet.ValuePositions: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QBoxSet.ValuePositions: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtCharts.QBoxSet.ValuePositions: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QBoxSet.ValuePositions: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtCharts.QBoxSet.ValuePositions: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QBoxSet.ValuePositions: ...
            def __sub__(self, other: typing.SupportsInt) -> QtCharts.QBoxSet.ValuePositions: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QBoxSet.ValuePositions: ...
        LowerExtreme: typing.ClassVar[QtCharts.QBoxSet.ValuePositions] = ...
        LowerQuartile: typing.ClassVar[QtCharts.QBoxSet.ValuePositions] = ...
        Median: typing.ClassVar[QtCharts.QBoxSet.ValuePositions] = ...
        UpperExtreme: typing.ClassVar[QtCharts.QBoxSet.ValuePositions] = ...
        UpperQuartile: typing.ClassVar[QtCharts.QBoxSet.ValuePositions] = ...
        brushChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        cleared: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        doubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
        penChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        released: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        valuesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @overload
        def __init__(self, le: float, lq: float, m: float, uq: float, ue: float, label: str = ..., parent: typing.Union[PySide2.QtCore.QObject,None] = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., brushChanged: typing.Callable = ..., cleared: typing.Callable = ..., clicked: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pen: PySide2.QtGui.QPen = ..., penChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., valueChanged: typing.Callable = ..., valuesChanged: typing.Callable = ...) -> None: ...
        @overload
        def __init__(self, label: str = ..., parent: typing.Union[PySide2.QtCore.QObject,None] = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., brushChanged: typing.Callable = ..., cleared: typing.Callable = ..., clicked: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pen: PySide2.QtGui.QPen = ..., penChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., valueChanged: typing.Callable = ..., valuesChanged: typing.Callable = ...) -> None: ...
        @overload
        def append(self, value: float) -> None: ...
        @overload
        def append(self, values: typing.Iterable[float]) -> None: ...
        def at(self, index: int) -> float: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def clear(self) -> None: ...
        def count(self) -> int: ...
        def label(self) -> str: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def setBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setLabel(self, label: str) -> None: ...
        def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def setValue(self, index: int, value: float) -> None: ...
        def __lshift__(self, value: float) -> QtCharts.QBoxSet: ...
        def __rlshift__(self, other) -> typing.Any: ...

    class QCandlestickLegendMarker(QtCharts.QLegendMarker):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, series: QtCharts.QCandlestickSeries, legend: QtCharts.QLegend, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., brushChanged: typing.Callable = ..., clicked: typing.Callable = ..., destroyed: typing.Callable = ..., font: PySide2.QtGui.QFont = ..., fontChanged: typing.Callable = ..., hovered: typing.Callable = ..., label: str = ..., labelBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., labelBrushChanged: typing.Callable = ..., labelChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pen: PySide2.QtGui.QPen = ..., penChanged: typing.Callable = ..., shape: typing.Any = ..., shapeChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def series(self) -> QtCharts.QCandlestickSeries: ...
        def type(self) -> QtCharts.QLegendMarker.LegendMarkerType: ...

    class QCandlestickModelMapper(PySide2.QtCore.QObject):
        modelReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        seriesReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
        def close(self) -> int: ...
        def firstSetSection(self) -> int: ...
        def high(self) -> int: ...
        def lastSetSection(self) -> int: ...
        def low(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def open(self) -> int: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def series(self) -> QtCharts.QCandlestickSeries: ...
        def setClose(self, close: int) -> None: ...
        def setFirstSetSection(self, firstSetSection: int) -> None: ...
        def setHigh(self, high: int) -> None: ...
        def setLastSetSection(self, lastSetSection: int) -> None: ...
        def setLow(self, low: int) -> None: ...
        def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
        def setOpen(self, open: int) -> None: ...
        def setSeries(self, series: QtCharts.QCandlestickSeries) -> None: ...
        def setTimestamp(self, timestamp: int) -> None: ...
        def timestamp(self) -> int: ...

    class QCandlestickSeries(QtCharts.QAbstractSeries):
        bodyOutlineVisibilityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        bodyWidthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        brushChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        candlestickSetsAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
        candlestickSetsRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
        capsVisibilityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        capsWidthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        countChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        decreasingColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        doubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
        increasingColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        maximumColumnWidthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minimumColumnWidthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        penChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        released: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., bodyOutlineVisibilityChanged: typing.Callable = ..., bodyOutlineVisible: bool = ..., bodyWidth: float = ..., bodyWidthChanged: typing.Callable = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., brushChanged: typing.Callable = ..., candlestickSetsAdded: typing.Callable = ..., candlestickSetsRemoved: typing.Callable = ..., capsVisibilityChanged: typing.Callable = ..., capsVisible: bool = ..., capsWidth: float = ..., capsWidthChanged: typing.Callable = ..., clicked: typing.Callable = ..., count: int = ..., countChanged: typing.Callable = ..., decreasingColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., decreasingColorChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., increasingColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., increasingColorChanged: typing.Callable = ..., maximumColumnWidth: float = ..., maximumColumnWidthChanged: typing.Callable = ..., minimumColumnWidth: float = ..., minimumColumnWidthChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., pen: PySide2.QtGui.QPen = ..., penChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., type: QtCharts.QCandlestickSeries.SeriesType = ..., useOpenGL: bool = ..., useOpenGLChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        @overload
        def append(self, set: QtCharts.QCandlestickSet) -> bool: ...
        @overload
        def append(self, sets: typing.Iterable[QtCharts.QCandlestickSet]) -> bool: ...
        def bodyOutlineVisible(self) -> bool: ...
        def bodyWidth(self) -> float: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def capsVisible(self) -> bool: ...
        def capsWidth(self) -> float: ...
        def clear(self) -> None: ...
        def count(self) -> int: ...
        def decreasingColor(self) -> PySide2.QtGui.QColor: ...
        def increasingColor(self) -> PySide2.QtGui.QColor: ...
        def insert(self, index: int, set: QtCharts.QCandlestickSet) -> bool: ...
        def maximumColumnWidth(self) -> float: ...
        def minimumColumnWidth(self) -> float: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        @overload
        def remove(self, set: QtCharts.QCandlestickSet) -> bool: ...
        @overload
        def remove(self, sets: typing.Iterable[QtCharts.QCandlestickSet]) -> bool: ...
        def setBodyOutlineVisible(self, bodyOutlineVisible: bool) -> None: ...
        def setBodyWidth(self, bodyWidth: float) -> None: ...
        def setBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setCapsVisible(self, capsVisible: bool) -> None: ...
        def setCapsWidth(self, capsWidth: float) -> None: ...
        def setDecreasingColor(self, decreasingColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setIncreasingColor(self, increasingColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setMaximumColumnWidth(self, maximumColumnWidth: float) -> None: ...
        def setMinimumColumnWidth(self, minimumColumnWidth: float) -> None: ...
        def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def sets(self) -> typing.List[QtCharts.QCandlestickSet]: ...
        def take(self, set: QtCharts.QCandlestickSet) -> bool: ...
        def type(self) -> QtCharts.QAbstractSeries.SeriesType: ...

    class QCandlestickSet(PySide2.QtCore.QObject):
        brushChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        closeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        doubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        highChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        openChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        penChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        released: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        timestampChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @overload
        def __init__(self, open: float, high: float, low: float, close: float, timestamp: float = ..., parent: typing.Union[PySide2.QtCore.QObject,None] = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., brushChanged: typing.Callable = ..., clicked: typing.Callable = ..., closeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., highChanged: typing.Callable = ..., hovered: typing.Callable = ..., lowChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., openChanged: typing.Callable = ..., pen: PySide2.QtGui.QPen = ..., penChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., timestampChanged: typing.Callable = ...) -> None: ...
        @overload
        def __init__(self, timestamp: float = ..., parent: typing.Union[PySide2.QtCore.QObject,None] = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., brushChanged: typing.Callable = ..., clicked: typing.Callable = ..., close: float = ..., closeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., high: float = ..., highChanged: typing.Callable = ..., hovered: typing.Callable = ..., low: float = ..., lowChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., open: float = ..., openChanged: typing.Callable = ..., pen: PySide2.QtGui.QPen = ..., penChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., timestampChanged: typing.Callable = ...) -> None: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def close(self) -> float: ...
        def high(self) -> float: ...
        def low(self) -> float: ...
        def open(self) -> float: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def setBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setClose(self, close: float) -> None: ...
        def setHigh(self, high: float) -> None: ...
        def setLow(self, low: float) -> None: ...
        def setOpen(self, open: float) -> None: ...
        def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def setTimestamp(self, timestamp: float) -> None: ...
        def timestamp(self) -> float: ...

    class QCategoryAxis(QtCharts.QValueAxis):
        class AxisLabelsPosition:
            AxisLabelsPositionCenter: typing.ClassVar[QtCharts.QCategoryAxis.AxisLabelsPosition] = ...
            AxisLabelsPositionOnValue: typing.ClassVar[QtCharts.QCategoryAxis.AxisLabelsPosition] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtCharts.QCategoryAxis.AxisLabelsPosition: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QCategoryAxis.AxisLabelsPosition: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtCharts.QCategoryAxis.AxisLabelsPosition: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QCategoryAxis.AxisLabelsPosition: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> QtCharts.QCategoryAxis.AxisLabelsPosition: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QCategoryAxis.AxisLabelsPosition: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtCharts.QCategoryAxis.AxisLabelsPosition: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QCategoryAxis.AxisLabelsPosition: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtCharts.QCategoryAxis.AxisLabelsPosition: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QCategoryAxis.AxisLabelsPosition: ...
            def __sub__(self, other: typing.SupportsInt) -> QtCharts.QCategoryAxis.AxisLabelsPosition: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QCategoryAxis.AxisLabelsPosition: ...
        AxisLabelsPositionCenter: typing.ClassVar[QtCharts.QCategoryAxis.AxisLabelsPosition] = ...
        AxisLabelsPositionOnValue: typing.ClassVar[QtCharts.QCategoryAxis.AxisLabelsPosition] = ...
        categoriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsPositionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., categoriesChanged: typing.Callable = ..., categoriesLabels: None = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., colorChanged: typing.Callable = ..., count: int = ..., destroyed: typing.Callable = ..., gridLineColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., gridLineColorChanged: typing.Callable = ..., gridLinePen: PySide2.QtGui.QPen = ..., gridLinePenChanged: typing.Callable = ..., gridVisible: bool = ..., gridVisibleChanged: typing.Callable = ..., labelFormat: str = ..., labelFormatChanged: typing.Callable = ..., labelsAngle: int = ..., labelsAngleChanged: typing.Callable = ..., labelsBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., labelsBrushChanged: typing.Callable = ..., labelsColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., labelsColorChanged: typing.Callable = ..., labelsEditableChanged: typing.Callable = ..., labelsFont: PySide2.QtGui.QFont = ..., labelsFontChanged: typing.Callable = ..., labelsPosition: QtCharts.QCategoryAxis.AxisLabelsPosition = ..., labelsPositionChanged: typing.Callable = ..., labelsVisible: bool = ..., labelsVisibleChanged: typing.Callable = ..., linePen: PySide2.QtGui.QPen = ..., linePenChanged: typing.Callable = ..., lineVisible: bool = ..., lineVisibleChanged: typing.Callable = ..., max: float = ..., maxChanged: typing.Callable = ..., min: float = ..., minChanged: typing.Callable = ..., minorGridLineColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., minorGridLineColorChanged: typing.Callable = ..., minorGridLinePen: PySide2.QtGui.QPen = ..., minorGridLinePenChanged: typing.Callable = ..., minorGridVisible: bool = ..., minorGridVisibleChanged: typing.Callable = ..., minorTickCount: int = ..., minorTickCountChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., rangeChanged: typing.Callable = ..., reverse: bool = ..., reverseChanged: typing.Callable = ..., shadesBorderColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., shadesBorderColorChanged: typing.Callable = ..., shadesBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., shadesBrushChanged: typing.Callable = ..., shadesColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., shadesColorChanged: typing.Callable = ..., shadesPen: PySide2.QtGui.QPen = ..., shadesPenChanged: typing.Callable = ..., shadesVisible: bool = ..., shadesVisibleChanged: typing.Callable = ..., startValue: float = ..., tickAnchor: float = ..., tickAnchorChanged: typing.Callable = ..., tickCount: int = ..., tickCountChanged: typing.Callable = ..., tickInterval: float = ..., tickIntervalChanged: typing.Callable = ..., tickType: QtCharts.QCategoryAxis.TickType = ..., tickTypeChanged: typing.Callable = ..., titleBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., titleBrushChanged: typing.Callable = ..., titleFont: PySide2.QtGui.QFont = ..., titleFontChanged: typing.Callable = ..., titleText: str = ..., titleTextChanged: typing.Callable = ..., titleVisible: bool = ..., titleVisibleChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def append(self, label: str, categoryEndValue: float) -> None: ...
        def categoriesLabels(self) -> typing.List[str]: ...
        def count(self) -> int: ...
        def endValue(self, categoryLabel: str) -> float: ...
        def labelsPosition(self) -> QtCharts.QCategoryAxis.AxisLabelsPosition: ...
        def remove(self, label: str) -> None: ...
        def replaceLabel(self, oldLabel: str, newLabel: str) -> None: ...
        def setLabelsPosition(self, position: QtCharts.QCategoryAxis.AxisLabelsPosition) -> None: ...
        def setStartValue(self, min: float) -> None: ...
        def startValue(self, categoryLabel: str = ...) -> float: ...
        def type(self) -> QtCharts.QAbstractAxis.AxisType: ...

    class QChart(PySide2.QtWidgets.QGraphicsWidget):
        class AnimationOption:
            AllAnimations: typing.ClassVar[QtCharts.QChart.AnimationOption] = ...
            GridAxisAnimations: typing.ClassVar[QtCharts.QChart.AnimationOption] = ...
            NoAnimation: typing.ClassVar[QtCharts.QChart.AnimationOption] = ...
            SeriesAnimations: typing.ClassVar[QtCharts.QChart.AnimationOption] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QChart.AnimationOptions: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> QtCharts.QChart.AnimationOptions: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QChart.AnimationOptions: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QChart.AnimationOptions: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QChart.AnimationOptions: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QChart.AnimationOptions: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QChart.AnimationOptions: ...
    
        class AnimationOptions:
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QChart.AnimationOptions: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> QtCharts.QChart.AnimationOptions: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QChart.AnimationOptions: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QChart.AnimationOptions: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QChart.AnimationOptions: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QChart.AnimationOptions: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QChart.AnimationOptions: ...
    
        class ChartTheme:
            ChartThemeBlueCerulean: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
            ChartThemeBlueIcy: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
            ChartThemeBlueNcs: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
            ChartThemeBrownSand: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
            ChartThemeDark: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
            ChartThemeHighContrast: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
            ChartThemeLight: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
            ChartThemeQt: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartTheme: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartTheme: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartTheme: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartTheme: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartTheme: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartTheme: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartTheme: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartTheme: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartTheme: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartTheme: ...
            def __sub__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartTheme: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartTheme: ...
    
        class ChartType:
            ChartTypeCartesian: typing.ClassVar[QtCharts.QChart.ChartType] = ...
            ChartTypePolar: typing.ClassVar[QtCharts.QChart.ChartType] = ...
            ChartTypeUndefined: typing.ClassVar[QtCharts.QChart.ChartType] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartType: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartType: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartType: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartType: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartType: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartType: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartType: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartType: ...
            def __sub__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartType: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QChart.ChartType: ...
        AllAnimations: typing.ClassVar[QtCharts.QChart.AnimationOption] = ...
        ChartThemeBlueCerulean: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
        ChartThemeBlueIcy: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
        ChartThemeBlueNcs: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
        ChartThemeBrownSand: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
        ChartThemeDark: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
        ChartThemeHighContrast: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
        ChartThemeLight: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
        ChartThemeQt: typing.ClassVar[QtCharts.QChart.ChartTheme] = ...
        ChartTypeCartesian: typing.ClassVar[QtCharts.QChart.ChartType] = ...
        ChartTypePolar: typing.ClassVar[QtCharts.QChart.ChartType] = ...
        ChartTypeUndefined: typing.ClassVar[QtCharts.QChart.ChartType] = ...
        GridAxisAnimations: typing.ClassVar[QtCharts.QChart.AnimationOption] = ...
        NoAnimation: typing.ClassVar[QtCharts.QChart.AnimationOption] = ...
        SeriesAnimations: typing.ClassVar[QtCharts.QChart.AnimationOption] = ...
        plotAreaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @overload
        def __init__(self, type: QtCharts.QChart.ChartType, parent: PySide2.QtWidgets.QGraphicsItem, wFlags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType], animationDuration: int = ..., animationEasingCurve: typing.Union[PySide2.QtCore.QEasingCurve,PySide2.QtCore.QEasingCurve.Type] = ..., animationOptions: typing.Union[QtCharts.QChart.AnimationOptions,QtCharts.QChart.AnimationOption] = ..., autoFillBackground: bool = ..., backgroundRoundness: float = ..., backgroundVisible: bool = ..., chartType: typing.Any = ..., children: typing.Any = ..., childrenChanged: typing.Callable = ..., destroyed: typing.Callable = ..., dropShadowEnabled: bool = ..., effect: typing.Any = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., geometry: PySide2.QtCore.QRectF = ..., geometryChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., layout: typing.Any = ..., layoutChanged: typing.Callable = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., localizeNumbers: bool = ..., margins: PySide2.QtCore.QMargins = ..., maximumSize: PySide2.QtCore.QSizeF = ..., minimumSize: PySide2.QtCore.QSizeF = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., parentChanged: typing.Callable = ..., plotArea: PySide2.QtCore.QRectF = ..., plotAreaBackgroundVisible: bool = ..., plotAreaChanged: typing.Callable = ..., pos: PySide2.QtCore.QPointF = ..., preferredSize: PySide2.QtCore.QSizeF = ..., rotation: float = ..., rotationChanged: typing.Callable = ..., scale: float = ..., scaleChanged: typing.Callable = ..., size: PySide2.QtCore.QSizeF = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., theme: typing.Any = ..., title: str = ..., transformOriginPoint: PySide2.QtCore.QPointF = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: float = ..., widthChanged: typing.Callable = ..., windowFlags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., windowTitle: str = ..., x: float = ..., xChanged: typing.Callable = ..., y: float = ..., yChanged: typing.Callable = ..., z: float = ..., zChanged: typing.Callable = ...) -> None: ...
        @overload
        def __init__(self, parent: typing.Union[PySide2.QtWidgets.QGraphicsItem,None] = ..., wFlags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., animationDuration: int = ..., animationEasingCurve: typing.Union[PySide2.QtCore.QEasingCurve,PySide2.QtCore.QEasingCurve.Type] = ..., animationOptions: typing.Union[QtCharts.QChart.AnimationOptions,QtCharts.QChart.AnimationOption] = ..., autoFillBackground: bool = ..., backgroundRoundness: float = ..., backgroundVisible: bool = ..., chartType: typing.Any = ..., children: typing.Any = ..., childrenChanged: typing.Callable = ..., destroyed: typing.Callable = ..., dropShadowEnabled: bool = ..., effect: typing.Any = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., geometry: PySide2.QtCore.QRectF = ..., geometryChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., layout: typing.Any = ..., layoutChanged: typing.Callable = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., localizeNumbers: bool = ..., margins: PySide2.QtCore.QMargins = ..., maximumSize: PySide2.QtCore.QSizeF = ..., minimumSize: PySide2.QtCore.QSizeF = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., parentChanged: typing.Callable = ..., plotArea: PySide2.QtCore.QRectF = ..., plotAreaBackgroundVisible: bool = ..., plotAreaChanged: typing.Callable = ..., pos: PySide2.QtCore.QPointF = ..., preferredSize: PySide2.QtCore.QSizeF = ..., rotation: float = ..., rotationChanged: typing.Callable = ..., scale: float = ..., scaleChanged: typing.Callable = ..., size: PySide2.QtCore.QSizeF = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., theme: typing.Any = ..., title: str = ..., transformOriginPoint: PySide2.QtCore.QPointF = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: float = ..., widthChanged: typing.Callable = ..., windowFlags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., windowTitle: str = ..., x: float = ..., xChanged: typing.Callable = ..., y: float = ..., yChanged: typing.Callable = ..., z: float = ..., zChanged: typing.Callable = ...) -> None: ...
        def addAxis(self, axis: QtCharts.QAbstractAxis, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
        def addSeries(self, series: QtCharts.QAbstractSeries) -> None: ...
        def animationDuration(self) -> int: ...
        def animationEasingCurve(self) -> PySide2.QtCore.QEasingCurve: ...
        def animationOptions(self) -> typing.Union[QtCharts.QChart.AnimationOptions,QtCharts.QChart.AnimationOption]: ...
        def axes(self, orientation: typing.Union[PySide2.QtCore.Qt.Orientations,PySide2.QtCore.Qt.Orientation] = ..., series: typing.Union[QtCharts.QAbstractSeries,None] = ...) -> typing.List[QtCharts.QAbstractAxis]: ...
        def axisX(self, series: typing.Union[QtCharts.QAbstractSeries,None] = ...) -> QtCharts.QAbstractAxis: ...
        def axisY(self, series: typing.Union[QtCharts.QAbstractSeries,None] = ...) -> QtCharts.QAbstractAxis: ...
        def backgroundBrush(self) -> PySide2.QtGui.QBrush: ...
        def backgroundPen(self) -> PySide2.QtGui.QPen: ...
        def backgroundRoundness(self) -> float: ...
        def chartType(self) -> QtCharts.QChart.ChartType: ...
        def createDefaultAxes(self) -> None: ...
        def isBackgroundVisible(self) -> bool: ...
        def isDropShadowEnabled(self) -> bool: ...
        def isPlotAreaBackgroundVisible(self) -> bool: ...
        def isZoomed(self) -> bool: ...
        def legend(self) -> QtCharts.QLegend: ...
        def locale(self) -> PySide2.QtCore.QLocale: ...
        def localizeNumbers(self) -> bool: ...
        def mapToPosition(self, value: PySide2.QtCore.QPointF, series: typing.Union[QtCharts.QAbstractSeries,None] = ...) -> PySide2.QtCore.QPointF: ...
        def mapToValue(self, position: PySide2.QtCore.QPointF, series: typing.Union[QtCharts.QAbstractSeries,None] = ...) -> PySide2.QtCore.QPointF: ...
        def margins(self) -> PySide2.QtCore.QMargins: ...
        def plotArea(self) -> PySide2.QtCore.QRectF: ...
        def plotAreaBackgroundBrush(self) -> PySide2.QtGui.QBrush: ...
        def plotAreaBackgroundPen(self) -> PySide2.QtGui.QPen: ...
        def removeAllSeries(self) -> None: ...
        def removeAxis(self, axis: QtCharts.QAbstractAxis) -> None: ...
        def removeSeries(self, series: QtCharts.QAbstractSeries) -> None: ...
        def scroll(self, dx: float, dy: float) -> None: ...
        def series(self) -> typing.List[QtCharts.QAbstractSeries]: ...
        def setAnimationDuration(self, msecs: int) -> None: ...
        def setAnimationEasingCurve(self, curve: typing.Union[PySide2.QtCore.QEasingCurve,PySide2.QtCore.QEasingCurve.Type]) -> None: ...
        def setAnimationOptions(self, options: typing.Union[QtCharts.QChart.AnimationOptions,QtCharts.QChart.AnimationOption]) -> None: ...
        def setAxisX(self, axis: QtCharts.QAbstractAxis, series: typing.Union[QtCharts.QAbstractSeries,None] = ...) -> None: ...
        def setAxisY(self, axis: QtCharts.QAbstractAxis, series: typing.Union[QtCharts.QAbstractSeries,None] = ...) -> None: ...
        def setBackgroundBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setBackgroundPen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def setBackgroundRoundness(self, diameter: float) -> None: ...
        def setBackgroundVisible(self, visible: bool = ...) -> None: ...
        def setDropShadowEnabled(self, enabled: bool = ...) -> None: ...
        def setLocale(self, locale: PySide2.QtCore.QLocale) -> None: ...
        def setLocalizeNumbers(self, localize: bool) -> None: ...
        def setMargins(self, margins: PySide2.QtCore.QMargins) -> None: ...
        def setPlotArea(self, rect: PySide2.QtCore.QRectF) -> None: ...
        def setPlotAreaBackgroundBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setPlotAreaBackgroundPen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def setPlotAreaBackgroundVisible(self, visible: bool = ...) -> None: ...
        def setTheme(self, theme: QtCharts.QChart.ChartTheme) -> None: ...
        def setTitle(self, title: str) -> None: ...
        def setTitleBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setTitleFont(self, font: PySide2.QtGui.QFont) -> None: ...
        def theme(self) -> QtCharts.QChart.ChartTheme: ...
        def title(self) -> str: ...
        def titleBrush(self) -> PySide2.QtGui.QBrush: ...
        def titleFont(self) -> PySide2.QtGui.QFont: ...
        def zoom(self, factor: float) -> None: ...
        @overload
        def zoomIn(self, rect: PySide2.QtCore.QRectF) -> None: ...
        @overload
        def zoomIn(self) -> None: ...
        def zoomOut(self) -> None: ...
        def zoomReset(self) -> None: ...

    class QChartView(PySide2.QtWidgets.QGraphicsView):
        class RubberBand:
            HorizontalRubberBand: typing.ClassVar[QtCharts.QChartView.RubberBand] = ...
            NoRubberBand: typing.ClassVar[QtCharts.QChartView.RubberBand] = ...
            RectangleRubberBand: typing.ClassVar[QtCharts.QChartView.RubberBand] = ...
            VerticalRubberBand: typing.ClassVar[QtCharts.QChartView.RubberBand] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QChartView.RubberBands: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> QtCharts.QChartView.RubberBands: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QChartView.RubberBands: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QChartView.RubberBands: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QChartView.RubberBands: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QChartView.RubberBands: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QChartView.RubberBands: ...
    
        class RubberBands:
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QChartView.RubberBands: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> QtCharts.QChartView.RubberBands: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QChartView.RubberBands: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QChartView.RubberBands: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QChartView.RubberBands: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QChartView.RubberBands: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QChartView.RubberBands: ...
        HorizontalRubberBand: typing.ClassVar[QtCharts.QChartView.RubberBand] = ...
        NoRubberBand: typing.ClassVar[QtCharts.QChartView.RubberBand] = ...
        RectangleRubberBand: typing.ClassVar[QtCharts.QChartView.RubberBand] = ...
        VerticalRubberBand: typing.ClassVar[QtCharts.QChartView.RubberBand] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @overload
        def __init__(self, chart: QtCharts.QChart, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., backgroundBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., baseSize: PySide2.QtCore.QSize = ..., cacheMode: QtCharts.QChartView.CacheMode = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., dragMode: QtCharts.QChartView.DragMode = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., foregroundBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QtCharts.QChartView.Shadow = ..., frameShape: QtCharts.QChartView.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., interactive: bool = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., optimizationFlags: QtCharts.QChartView.OptimizationFlags = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., renderHints: typing.Any = ..., resizeAnchor: QtCharts.QChartView.ViewportAnchor = ..., rubberBandChanged: typing.Callable = ..., rubberBandSelectionMode: PySide2.QtCore.Qt.ItemSelectionMode = ..., sceneRect: PySide2.QtCore.QRectF = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QtCharts.QChartView.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., transformationAnchor: QtCharts.QChartView.ViewportAnchor = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., viewportUpdateMode: QtCharts.QChartView.ViewportUpdateMode = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
        @overload
        def __init__(self, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., autoFillBackground: bool = ..., backgroundBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., baseSize: PySide2.QtCore.QSize = ..., cacheMode: QtCharts.QChartView.CacheMode = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., dragMode: QtCharts.QChartView.DragMode = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., foregroundBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QtCharts.QChartView.Shadow = ..., frameShape: QtCharts.QChartView.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., interactive: bool = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., optimizationFlags: QtCharts.QChartView.OptimizationFlags = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., renderHints: typing.Any = ..., resizeAnchor: QtCharts.QChartView.ViewportAnchor = ..., rubberBandChanged: typing.Callable = ..., rubberBandSelectionMode: PySide2.QtCore.Qt.ItemSelectionMode = ..., sceneRect: PySide2.QtCore.QRectF = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QtCharts.QChartView.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., transformationAnchor: QtCharts.QChartView.ViewportAnchor = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., viewportUpdateMode: QtCharts.QChartView.ViewportUpdateMode = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
        def chart(self) -> QtCharts.QChart: ...
        def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
        def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
        def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
        def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
        def rubberBand(self) -> typing.Union[QtCharts.QChartView.RubberBands,QtCharts.QChartView.RubberBand]: ...
        def setChart(self, chart: QtCharts.QChart) -> None: ...
        def setRubberBand(self, rubberBands: typing.Union[QtCharts.QChartView.RubberBands,QtCharts.QChartView.RubberBand]) -> None: ...
        def wheelEvent(self, event: PySide2.QtGui.QWheelEvent) -> None: ...

    class QDateTimeAxis(QtCharts.QAbstractAxis):
        formatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        maxChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rangeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        tickCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., colorChanged: typing.Callable = ..., destroyed: typing.Callable = ..., format: str = ..., formatChanged: typing.Callable = ..., gridLineColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., gridLineColorChanged: typing.Callable = ..., gridLinePen: PySide2.QtGui.QPen = ..., gridLinePenChanged: typing.Callable = ..., gridVisible: bool = ..., gridVisibleChanged: typing.Callable = ..., labelsAngle: int = ..., labelsAngleChanged: typing.Callable = ..., labelsBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., labelsBrushChanged: typing.Callable = ..., labelsColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., labelsColorChanged: typing.Callable = ..., labelsEditableChanged: typing.Callable = ..., labelsFont: PySide2.QtGui.QFont = ..., labelsFontChanged: typing.Callable = ..., labelsVisible: bool = ..., labelsVisibleChanged: typing.Callable = ..., linePen: PySide2.QtGui.QPen = ..., linePenChanged: typing.Callable = ..., lineVisible: bool = ..., lineVisibleChanged: typing.Callable = ..., max: PySide2.QtCore.QDateTime = ..., maxChanged: typing.Callable = ..., min: PySide2.QtCore.QDateTime = ..., minChanged: typing.Callable = ..., minorGridLineColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., minorGridLineColorChanged: typing.Callable = ..., minorGridLinePen: PySide2.QtGui.QPen = ..., minorGridLinePenChanged: typing.Callable = ..., minorGridVisible: bool = ..., minorGridVisibleChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., rangeChanged: typing.Callable = ..., reverse: bool = ..., reverseChanged: typing.Callable = ..., shadesBorderColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., shadesBorderColorChanged: typing.Callable = ..., shadesBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., shadesBrushChanged: typing.Callable = ..., shadesColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., shadesColorChanged: typing.Callable = ..., shadesPen: PySide2.QtGui.QPen = ..., shadesPenChanged: typing.Callable = ..., shadesVisible: bool = ..., shadesVisibleChanged: typing.Callable = ..., tickCount: int = ..., tickCountChanged: typing.Callable = ..., titleBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., titleBrushChanged: typing.Callable = ..., titleFont: PySide2.QtGui.QFont = ..., titleFontChanged: typing.Callable = ..., titleText: str = ..., titleTextChanged: typing.Callable = ..., titleVisible: bool = ..., titleVisibleChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def format(self) -> str: ...
        def max(self) -> PySide2.QtCore.QDateTime: ...
        def min(self) -> PySide2.QtCore.QDateTime: ...
        def setFormat(self, format: str) -> None: ...
        @overload
        def setMax(self, max: PySide2.QtCore.QDateTime) -> None: ...
        @overload
        def setMax(self, max: typing.Any) -> None: ...
        @overload
        def setMin(self, min: PySide2.QtCore.QDateTime) -> None: ...
        @overload
        def setMin(self, min: typing.Any) -> None: ...
        @overload
        def setRange(self, min: PySide2.QtCore.QDateTime, max: PySide2.QtCore.QDateTime) -> None: ...
        @overload
        def setRange(self, min: typing.Any, max: typing.Any) -> None: ...
        def setTickCount(self, count: int) -> None: ...
        def tickCount(self) -> int: ...
        def type(self) -> QtCharts.QAbstractAxis.AxisType: ...

    class QHBarModelMapper(QtCharts.QBarModelMapper):
        columnCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        firstBarSetRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        firstColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lastBarSetRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        modelReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        seriesReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., destroyed: typing.Callable = ..., firstBarSetRow: int = ..., firstBarSetRowChanged: typing.Callable = ..., firstColumn: int = ..., firstColumnChanged: typing.Callable = ..., lastBarSetRow: int = ..., lastBarSetRowChanged: typing.Callable = ..., model: PySide2.QtCore.QAbstractItemModel = ..., modelReplaced: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., series: QtCharts.QAbstractBarSeries = ..., seriesReplaced: typing.Callable = ...) -> None: ...
        def columnCount(self) -> int: ...
        def firstBarSetRow(self) -> int: ...
        def firstColumn(self) -> int: ...
        def lastBarSetRow(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def series(self) -> QtCharts.QAbstractBarSeries: ...
        def setColumnCount(self, columnCount: int) -> None: ...
        def setFirstBarSetRow(self, firstBarSetRow: int) -> None: ...
        def setFirstColumn(self, firstColumn: int) -> None: ...
        def setLastBarSetRow(self, lastBarSetRow: int) -> None: ...
        def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
        def setSeries(self, series: QtCharts.QAbstractBarSeries) -> None: ...

    class QHBoxPlotModelMapper(QtCharts.QBoxPlotModelMapper):
        columnCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        firstBoxSetRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        firstColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lastBoxSetRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        modelReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        seriesReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., destroyed: typing.Callable = ..., firstBoxSetRow: int = ..., firstBoxSetRowChanged: typing.Callable = ..., firstColumn: int = ..., firstColumnChanged: typing.Callable = ..., lastBoxSetRow: int = ..., lastBoxSetRowChanged: typing.Callable = ..., model: PySide2.QtCore.QAbstractItemModel = ..., modelReplaced: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., series: QtCharts.QBoxPlotSeries = ..., seriesReplaced: typing.Callable = ...) -> None: ...
        def columnCount(self) -> int: ...
        def firstBoxSetRow(self) -> int: ...
        def firstColumn(self) -> int: ...
        def lastBoxSetRow(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def series(self) -> QtCharts.QBoxPlotSeries: ...
        def setColumnCount(self, rowCount: int) -> None: ...
        def setFirstBoxSetRow(self, firstBoxSetRow: int) -> None: ...
        def setFirstColumn(self, firstColumn: int) -> None: ...
        def setLastBoxSetRow(self, lastBoxSetRow: int) -> None: ...
        def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
        def setSeries(self, series: QtCharts.QBoxPlotSeries) -> None: ...

    class QHCandlestickModelMapper(QtCharts.QCandlestickModelMapper):
        closeColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        firstSetRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        highColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lastSetRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lowColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        openColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        timestampColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., closeColumn: int = ..., closeColumnChanged: typing.Callable = ..., destroyed: typing.Callable = ..., firstSetRow: int = ..., firstSetRowChanged: typing.Callable = ..., highColumn: int = ..., highColumnChanged: typing.Callable = ..., lastSetRow: int = ..., lastSetRowChanged: typing.Callable = ..., lowColumn: int = ..., lowColumnChanged: typing.Callable = ..., model: typing.Any = ..., modelReplaced: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., openColumn: int = ..., openColumnChanged: typing.Callable = ..., series: typing.Any = ..., seriesReplaced: typing.Callable = ..., timestampColumn: int = ..., timestampColumnChanged: typing.Callable = ...) -> None: ...
        def closeColumn(self) -> int: ...
        def firstSetRow(self) -> int: ...
        def highColumn(self) -> int: ...
        def lastSetRow(self) -> int: ...
        def lowColumn(self) -> int: ...
        def openColumn(self) -> int: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def setCloseColumn(self, closeColumn: int) -> None: ...
        def setFirstSetRow(self, firstSetRow: int) -> None: ...
        def setHighColumn(self, highColumn: int) -> None: ...
        def setLastSetRow(self, lastSetRow: int) -> None: ...
        def setLowColumn(self, lowColumn: int) -> None: ...
        def setOpenColumn(self, openColumn: int) -> None: ...
        def setTimestampColumn(self, timestampColumn: int) -> None: ...
        def timestampColumn(self) -> int: ...

    class QHPieModelMapper(QtCharts.QPieModelMapper):
        columnCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        firstColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        modelReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        seriesReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        valuesRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., destroyed: typing.Callable = ..., firstColumn: int = ..., firstColumnChanged: typing.Callable = ..., labelsRow: int = ..., labelsRowChanged: typing.Callable = ..., model: PySide2.QtCore.QAbstractItemModel = ..., modelReplaced: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., series: QtCharts.QPieSeries = ..., seriesReplaced: typing.Callable = ..., valuesRow: int = ..., valuesRowChanged: typing.Callable = ...) -> None: ...
        def columnCount(self) -> int: ...
        def firstColumn(self) -> int: ...
        def labelsRow(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def series(self) -> QtCharts.QPieSeries: ...
        def setColumnCount(self, columnCount: int) -> None: ...
        def setFirstColumn(self, firstColumn: int) -> None: ...
        def setLabelsRow(self, labelsRow: int) -> None: ...
        def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
        def setSeries(self, series: QtCharts.QPieSeries) -> None: ...
        def setValuesRow(self, valuesRow: int) -> None: ...
        def valuesRow(self) -> int: ...

    class QHXYModelMapper(QtCharts.QXYModelMapper):
        columnCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        firstColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        modelReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        seriesReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        xRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., destroyed: typing.Callable = ..., firstColumn: int = ..., firstColumnChanged: typing.Callable = ..., model: PySide2.QtCore.QAbstractItemModel = ..., modelReplaced: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., series: QtCharts.QXYSeries = ..., seriesReplaced: typing.Callable = ..., xRow: int = ..., xRowChanged: typing.Callable = ..., yRow: int = ..., yRowChanged: typing.Callable = ...) -> None: ...
        def columnCount(self) -> int: ...
        def firstColumn(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def series(self) -> QtCharts.QXYSeries: ...
        def setColumnCount(self, columnCount: int) -> None: ...
        def setFirstColumn(self, firstColumn: int) -> None: ...
        def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
        def setSeries(self, series: QtCharts.QXYSeries) -> None: ...
        def setXRow(self, xRow: int) -> None: ...
        def setYRow(self, yRow: int) -> None: ...
        def xRow(self) -> int: ...
        def yRow(self) -> int: ...

    class QHorizontalBarSeries(QtCharts.QAbstractBarSeries):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., barWidth: float = ..., barsetsAdded: typing.Callable = ..., barsetsRemoved: typing.Callable = ..., clicked: typing.Callable = ..., count: int = ..., countChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., labelsAngle: float = ..., labelsAngleChanged: typing.Callable = ..., labelsFormat: str = ..., labelsFormatChanged: typing.Callable = ..., labelsPosition: QtCharts.QHorizontalBarSeries.LabelsPosition = ..., labelsPositionChanged: typing.Callable = ..., labelsPrecision: int = ..., labelsPrecisionChanged: typing.Callable = ..., labelsVisible: bool = ..., labelsVisibleChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., type: QtCharts.QHorizontalBarSeries.SeriesType = ..., useOpenGL: bool = ..., useOpenGLChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def type(self) -> QtCharts.QAbstractSeries.SeriesType: ...

    class QHorizontalPercentBarSeries(QtCharts.QAbstractBarSeries):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., barWidth: float = ..., barsetsAdded: typing.Callable = ..., barsetsRemoved: typing.Callable = ..., clicked: typing.Callable = ..., count: int = ..., countChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., labelsAngle: float = ..., labelsAngleChanged: typing.Callable = ..., labelsFormat: str = ..., labelsFormatChanged: typing.Callable = ..., labelsPosition: QtCharts.QHorizontalPercentBarSeries.LabelsPosition = ..., labelsPositionChanged: typing.Callable = ..., labelsPrecision: int = ..., labelsPrecisionChanged: typing.Callable = ..., labelsVisible: bool = ..., labelsVisibleChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., type: QtCharts.QHorizontalPercentBarSeries.SeriesType = ..., useOpenGL: bool = ..., useOpenGLChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def type(self) -> QtCharts.QAbstractSeries.SeriesType: ...

    class QHorizontalStackedBarSeries(QtCharts.QAbstractBarSeries):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., barWidth: float = ..., barsetsAdded: typing.Callable = ..., barsetsRemoved: typing.Callable = ..., clicked: typing.Callable = ..., count: int = ..., countChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., labelsAngle: float = ..., labelsAngleChanged: typing.Callable = ..., labelsFormat: str = ..., labelsFormatChanged: typing.Callable = ..., labelsPosition: QtCharts.QHorizontalStackedBarSeries.LabelsPosition = ..., labelsPositionChanged: typing.Callable = ..., labelsPrecision: int = ..., labelsPrecisionChanged: typing.Callable = ..., labelsVisible: bool = ..., labelsVisibleChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., type: QtCharts.QHorizontalStackedBarSeries.SeriesType = ..., useOpenGL: bool = ..., useOpenGLChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def type(self) -> QtCharts.QAbstractSeries.SeriesType: ...

    class QLegend(PySide2.QtWidgets.QGraphicsWidget):
        class MarkerShape:
            MarkerShapeCircle: typing.ClassVar[QtCharts.QLegend.MarkerShape] = ...
            MarkerShapeDefault: typing.ClassVar[QtCharts.QLegend.MarkerShape] = ...
            MarkerShapeFromSeries: typing.ClassVar[QtCharts.QLegend.MarkerShape] = ...
            MarkerShapeRectangle: typing.ClassVar[QtCharts.QLegend.MarkerShape] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtCharts.QLegend.MarkerShape: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QLegend.MarkerShape: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtCharts.QLegend.MarkerShape: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QLegend.MarkerShape: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> QtCharts.QLegend.MarkerShape: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QLegend.MarkerShape: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtCharts.QLegend.MarkerShape: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QLegend.MarkerShape: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtCharts.QLegend.MarkerShape: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QLegend.MarkerShape: ...
            def __sub__(self, other: typing.SupportsInt) -> QtCharts.QLegend.MarkerShape: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QLegend.MarkerShape: ...
        MarkerShapeCircle: typing.ClassVar[QtCharts.QLegend.MarkerShape] = ...
        MarkerShapeDefault: typing.ClassVar[QtCharts.QLegend.MarkerShape] = ...
        MarkerShapeFromSeries: typing.ClassVar[QtCharts.QLegend.MarkerShape] = ...
        MarkerShapeRectangle: typing.ClassVar[QtCharts.QLegend.MarkerShape] = ...
        backgroundVisibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        borderColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        colorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        fontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        markerShapeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        reverseMarkersChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        showToolTipsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def alignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
        def attachToChart(self) -> None: ...
        def borderColor(self) -> PySide2.QtGui.QColor: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def color(self) -> PySide2.QtGui.QColor: ...
        def detachFromChart(self) -> None: ...
        def font(self) -> PySide2.QtGui.QFont: ...
        def hideEvent(self, event: PySide2.QtGui.QHideEvent) -> None: ...
        def isAttachedToChart(self) -> bool: ...
        def isBackgroundVisible(self) -> bool: ...
        def labelBrush(self) -> PySide2.QtGui.QBrush: ...
        def labelColor(self) -> PySide2.QtGui.QColor: ...
        def markerShape(self) -> QtCharts.QLegend.MarkerShape: ...
        def markers(self, series: typing.Union[QtCharts.QAbstractSeries,None] = ...) -> typing.List[QtCharts.QLegendMarker]: ...
        def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: typing.Union[PySide2.QtWidgets.QWidget,None] = ...) -> None: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def reverseMarkers(self) -> bool: ...
        def setAlignment(self, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
        def setBackgroundVisible(self, visible: bool = ...) -> None: ...
        def setBorderColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
        def setLabelBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setLabelColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setMarkerShape(self, shape: QtCharts.QLegend.MarkerShape) -> None: ...
        def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def setReverseMarkers(self, reverseMarkers: bool = ...) -> None: ...
        def setShowToolTips(self, show: bool) -> None: ...
        def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
        def showToolTips(self) -> bool: ...

    class QLegendMarker(PySide2.QtCore.QObject):
        class LegendMarkerType:
            LegendMarkerTypeArea: typing.ClassVar[QtCharts.QLegendMarker.LegendMarkerType] = ...
            LegendMarkerTypeBar: typing.ClassVar[QtCharts.QLegendMarker.LegendMarkerType] = ...
            LegendMarkerTypeBoxPlot: typing.ClassVar[QtCharts.QLegendMarker.LegendMarkerType] = ...
            LegendMarkerTypeCandlestick: typing.ClassVar[QtCharts.QLegendMarker.LegendMarkerType] = ...
            LegendMarkerTypePie: typing.ClassVar[QtCharts.QLegendMarker.LegendMarkerType] = ...
            LegendMarkerTypeXY: typing.ClassVar[QtCharts.QLegendMarker.LegendMarkerType] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtCharts.QLegendMarker.LegendMarkerType: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QLegendMarker.LegendMarkerType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtCharts.QLegendMarker.LegendMarkerType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QLegendMarker.LegendMarkerType: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> QtCharts.QLegendMarker.LegendMarkerType: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QLegendMarker.LegendMarkerType: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtCharts.QLegendMarker.LegendMarkerType: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QLegendMarker.LegendMarkerType: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtCharts.QLegendMarker.LegendMarkerType: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QLegendMarker.LegendMarkerType: ...
            def __sub__(self, other: typing.SupportsInt) -> QtCharts.QLegendMarker.LegendMarkerType: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QLegendMarker.LegendMarkerType: ...
        LegendMarkerTypeArea: typing.ClassVar[QtCharts.QLegendMarker.LegendMarkerType] = ...
        LegendMarkerTypeBar: typing.ClassVar[QtCharts.QLegendMarker.LegendMarkerType] = ...
        LegendMarkerTypeBoxPlot: typing.ClassVar[QtCharts.QLegendMarker.LegendMarkerType] = ...
        LegendMarkerTypeCandlestick: typing.ClassVar[QtCharts.QLegendMarker.LegendMarkerType] = ...
        LegendMarkerTypePie: typing.ClassVar[QtCharts.QLegendMarker.LegendMarkerType] = ...
        LegendMarkerTypeXY: typing.ClassVar[QtCharts.QLegendMarker.LegendMarkerType] = ...
        brushChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        fontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelBrushChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        penChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shapeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        visibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def font(self) -> PySide2.QtGui.QFont: ...
        def isVisible(self) -> bool: ...
        def label(self) -> str: ...
        def labelBrush(self) -> PySide2.QtGui.QBrush: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def series(self) -> QtCharts.QAbstractSeries: ...
        def setBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
        def setLabel(self, label: str) -> None: ...
        def setLabelBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def setShape(self, shape: QtCharts.QLegend.MarkerShape) -> None: ...
        def setVisible(self, visible: bool) -> None: ...
        def shape(self) -> QtCharts.QLegend.MarkerShape: ...
        def type(self) -> QtCharts.QLegendMarker.LegendMarkerType: ...

    class QLineSeries(QtCharts.QXYSeries):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., clicked: typing.Callable = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., colorChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., penChanged: typing.Callable = ..., pointAdded: typing.Callable = ..., pointLabelsClipping: bool = ..., pointLabelsClippingChanged: typing.Callable = ..., pointLabelsColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., pointLabelsColorChanged: typing.Callable = ..., pointLabelsFont: PySide2.QtGui.QFont = ..., pointLabelsFontChanged: typing.Callable = ..., pointLabelsFormat: str = ..., pointLabelsFormatChanged: typing.Callable = ..., pointLabelsVisibilityChanged: typing.Callable = ..., pointLabelsVisible: bool = ..., pointRemoved: typing.Callable = ..., pointReplaced: typing.Callable = ..., pointsRemoved: typing.Callable = ..., pointsReplaced: typing.Callable = ..., pointsVisible: bool = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., type: QtCharts.QLineSeries.SeriesType = ..., useOpenGL: bool = ..., useOpenGLChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def type(self) -> QtCharts.QAbstractSeries.SeriesType: ...

    class QLogValueAxis(QtCharts.QAbstractAxis):
        baseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelFormatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        maxChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minorTickCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rangeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        tickCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., base: float = ..., baseChanged: typing.Callable = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., colorChanged: typing.Callable = ..., destroyed: typing.Callable = ..., gridLineColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., gridLineColorChanged: typing.Callable = ..., gridLinePen: PySide2.QtGui.QPen = ..., gridLinePenChanged: typing.Callable = ..., gridVisible: bool = ..., gridVisibleChanged: typing.Callable = ..., labelFormat: str = ..., labelFormatChanged: typing.Callable = ..., labelsAngle: int = ..., labelsAngleChanged: typing.Callable = ..., labelsBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., labelsBrushChanged: typing.Callable = ..., labelsColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., labelsColorChanged: typing.Callable = ..., labelsEditableChanged: typing.Callable = ..., labelsFont: PySide2.QtGui.QFont = ..., labelsFontChanged: typing.Callable = ..., labelsVisible: bool = ..., labelsVisibleChanged: typing.Callable = ..., linePen: PySide2.QtGui.QPen = ..., linePenChanged: typing.Callable = ..., lineVisible: bool = ..., lineVisibleChanged: typing.Callable = ..., max: float = ..., maxChanged: typing.Callable = ..., min: float = ..., minChanged: typing.Callable = ..., minorGridLineColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., minorGridLineColorChanged: typing.Callable = ..., minorGridLinePen: PySide2.QtGui.QPen = ..., minorGridLinePenChanged: typing.Callable = ..., minorGridVisible: bool = ..., minorGridVisibleChanged: typing.Callable = ..., minorTickCount: int = ..., minorTickCountChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., rangeChanged: typing.Callable = ..., reverse: bool = ..., reverseChanged: typing.Callable = ..., shadesBorderColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., shadesBorderColorChanged: typing.Callable = ..., shadesBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., shadesBrushChanged: typing.Callable = ..., shadesColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., shadesColorChanged: typing.Callable = ..., shadesPen: PySide2.QtGui.QPen = ..., shadesPenChanged: typing.Callable = ..., shadesVisible: bool = ..., shadesVisibleChanged: typing.Callable = ..., tickCount: int = ..., tickCountChanged: typing.Callable = ..., titleBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., titleBrushChanged: typing.Callable = ..., titleFont: PySide2.QtGui.QFont = ..., titleFontChanged: typing.Callable = ..., titleText: str = ..., titleTextChanged: typing.Callable = ..., titleVisible: bool = ..., titleVisibleChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def base(self) -> float: ...
        def labelFormat(self) -> str: ...
        def max(self) -> float: ...
        def min(self) -> float: ...
        def minorTickCount(self) -> int: ...
        def setBase(self, base: float) -> None: ...
        def setLabelFormat(self, format: str) -> None: ...
        @overload
        def setMax(self, max: typing.Any) -> None: ...
        @overload
        def setMax(self, max: float) -> None: ...
        @overload
        def setMin(self, min: typing.Any) -> None: ...
        @overload
        def setMin(self, min: float) -> None: ...
        def setMinorTickCount(self, minorTickCount: int) -> None: ...
        @overload
        def setRange(self, min: typing.Any, max: typing.Any) -> None: ...
        @overload
        def setRange(self, min: float, max: float) -> None: ...
        def tickCount(self) -> int: ...
        def type(self) -> QtCharts.QAbstractAxis.AxisType: ...

    class QPercentBarSeries(QtCharts.QAbstractBarSeries):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., barWidth: float = ..., barsetsAdded: typing.Callable = ..., barsetsRemoved: typing.Callable = ..., clicked: typing.Callable = ..., count: int = ..., countChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., labelsAngle: float = ..., labelsAngleChanged: typing.Callable = ..., labelsFormat: str = ..., labelsFormatChanged: typing.Callable = ..., labelsPosition: QtCharts.QPercentBarSeries.LabelsPosition = ..., labelsPositionChanged: typing.Callable = ..., labelsPrecision: int = ..., labelsPrecisionChanged: typing.Callable = ..., labelsVisible: bool = ..., labelsVisibleChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., type: QtCharts.QPercentBarSeries.SeriesType = ..., useOpenGL: bool = ..., useOpenGLChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def type(self) -> QtCharts.QAbstractSeries.SeriesType: ...

    class QPieLegendMarker(QtCharts.QLegendMarker):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, series: QtCharts.QPieSeries, slice: QtCharts.QPieSlice, legend: QtCharts.QLegend, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., brushChanged: typing.Callable = ..., clicked: typing.Callable = ..., destroyed: typing.Callable = ..., font: PySide2.QtGui.QFont = ..., fontChanged: typing.Callable = ..., hovered: typing.Callable = ..., label: str = ..., labelBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., labelBrushChanged: typing.Callable = ..., labelChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pen: PySide2.QtGui.QPen = ..., penChanged: typing.Callable = ..., shape: typing.Any = ..., shapeChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def series(self) -> QtCharts.QPieSeries: ...
        def slice(self) -> QtCharts.QPieSlice: ...
        def type(self) -> QtCharts.QLegendMarker.LegendMarkerType: ...

    class QPieModelMapper(PySide2.QtCore.QObject):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
        def count(self) -> int: ...
        def first(self) -> int: ...
        def labelsSection(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def series(self) -> QtCharts.QPieSeries: ...
        def setCount(self, count: int) -> None: ...
        def setFirst(self, first: int) -> None: ...
        def setLabelsSection(self, labelsSection: int) -> None: ...
        def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
        def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
        def setSeries(self, series: QtCharts.QPieSeries) -> None: ...
        def setValuesSection(self, valuesSection: int) -> None: ...
        def valuesSection(self) -> int: ...

    class QPieSeries(QtCharts.QAbstractSeries):
        added: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        countChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        doubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        released: typing.ClassVar[PySide2.QtCore.Signal] = ...
        removed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        sumChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., added: typing.Callable = ..., clicked: typing.Callable = ..., count: int = ..., countChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., endAngle: float = ..., holeSize: float = ..., horizontalPosition: float = ..., hovered: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., removed: typing.Callable = ..., size: float = ..., startAngle: float = ..., sum: float = ..., sumChanged: typing.Callable = ..., type: QtCharts.QPieSeries.SeriesType = ..., useOpenGL: bool = ..., useOpenGLChanged: typing.Callable = ..., verticalPosition: float = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        @overload
        def append(self, label: str, value: float) -> QtCharts.QPieSlice: ...
        @overload
        def append(self, slice: QtCharts.QPieSlice) -> bool: ...
        @overload
        def append(self, slices: typing.Iterable[QtCharts.QPieSlice]) -> bool: ...
        def clear(self) -> None: ...
        def count(self) -> int: ...
        def holeSize(self) -> float: ...
        def horizontalPosition(self) -> float: ...
        def insert(self, index: int, slice: QtCharts.QPieSlice) -> bool: ...
        def isEmpty(self) -> bool: ...
        def pieEndAngle(self) -> float: ...
        def pieSize(self) -> float: ...
        def pieStartAngle(self) -> float: ...
        def remove(self, slice: QtCharts.QPieSlice) -> bool: ...
        def setHoleSize(self, holeSize: float) -> None: ...
        def setHorizontalPosition(self, relativePosition: float) -> None: ...
        def setLabelsPosition(self, position: QtCharts.QPieSlice.LabelPosition) -> None: ...
        def setLabelsVisible(self, visible: bool = ...) -> None: ...
        def setPieEndAngle(self, endAngle: float) -> None: ...
        def setPieSize(self, relativeSize: float) -> None: ...
        def setPieStartAngle(self, startAngle: float) -> None: ...
        def setVerticalPosition(self, relativePosition: float) -> None: ...
        def slices(self) -> typing.List[QtCharts.QPieSlice]: ...
        def sum(self) -> float: ...
        def take(self, slice: QtCharts.QPieSlice) -> bool: ...
        def type(self) -> QtCharts.QAbstractSeries.SeriesType: ...
        def verticalPosition(self) -> float: ...
        def __lshift__(self, slice: QtCharts.QPieSlice) -> QtCharts.QPieSeries: ...
        def __rlshift__(self, other) -> typing.Any: ...

    class QPieSlice(PySide2.QtCore.QObject):
        class LabelPosition:
            LabelInsideHorizontal: typing.ClassVar[QtCharts.QPieSlice.LabelPosition] = ...
            LabelInsideNormal: typing.ClassVar[QtCharts.QPieSlice.LabelPosition] = ...
            LabelInsideTangential: typing.ClassVar[QtCharts.QPieSlice.LabelPosition] = ...
            LabelOutside: typing.ClassVar[QtCharts.QPieSlice.LabelPosition] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtCharts.QPieSlice.LabelPosition: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QPieSlice.LabelPosition: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtCharts.QPieSlice.LabelPosition: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QPieSlice.LabelPosition: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> QtCharts.QPieSlice.LabelPosition: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QPieSlice.LabelPosition: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtCharts.QPieSlice.LabelPosition: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QPieSlice.LabelPosition: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtCharts.QPieSlice.LabelPosition: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QPieSlice.LabelPosition: ...
            def __sub__(self, other: typing.SupportsInt) -> QtCharts.QPieSlice.LabelPosition: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QPieSlice.LabelPosition: ...
        LabelInsideHorizontal: typing.ClassVar[QtCharts.QPieSlice.LabelPosition] = ...
        LabelInsideNormal: typing.ClassVar[QtCharts.QPieSlice.LabelPosition] = ...
        LabelInsideTangential: typing.ClassVar[QtCharts.QPieSlice.LabelPosition] = ...
        LabelOutside: typing.ClassVar[QtCharts.QPieSlice.LabelPosition] = ...
        angleSpanChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        borderColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        borderWidthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        brushChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        colorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        doubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelBrushChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelFontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelVisibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        penChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        percentageChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        released: typing.ClassVar[PySide2.QtCore.Signal] = ...
        startAngleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @overload
        def __init__(self, label: str, value: float, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., angleSpan: float = ..., angleSpanChanged: typing.Callable = ..., borderColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., borderColorChanged: typing.Callable = ..., borderWidth: int = ..., borderWidthChanged: typing.Callable = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., brushChanged: typing.Callable = ..., clicked: typing.Callable = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., colorChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., explodeDistanceFactor: float = ..., exploded: bool = ..., hovered: typing.Callable = ..., labelArmLengthFactor: float = ..., labelBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., labelBrushChanged: typing.Callable = ..., labelChanged: typing.Callable = ..., labelColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., labelColorChanged: typing.Callable = ..., labelFont: PySide2.QtGui.QFont = ..., labelFontChanged: typing.Callable = ..., labelPosition: QtCharts.QPieSlice.LabelPosition = ..., labelVisible: bool = ..., labelVisibleChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pen: PySide2.QtGui.QPen = ..., penChanged: typing.Callable = ..., percentage: float = ..., percentageChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., startAngle: float = ..., startAngleChanged: typing.Callable = ..., valueChanged: typing.Callable = ...) -> None: ...
        @overload
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., angleSpan: float = ..., angleSpanChanged: typing.Callable = ..., borderColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., borderColorChanged: typing.Callable = ..., borderWidth: int = ..., borderWidthChanged: typing.Callable = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., brushChanged: typing.Callable = ..., clicked: typing.Callable = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., colorChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., explodeDistanceFactor: float = ..., exploded: bool = ..., hovered: typing.Callable = ..., label: str = ..., labelArmLengthFactor: float = ..., labelBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., labelBrushChanged: typing.Callable = ..., labelChanged: typing.Callable = ..., labelColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., labelColorChanged: typing.Callable = ..., labelFont: PySide2.QtGui.QFont = ..., labelFontChanged: typing.Callable = ..., labelPosition: QtCharts.QPieSlice.LabelPosition = ..., labelVisible: bool = ..., labelVisibleChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pen: PySide2.QtGui.QPen = ..., penChanged: typing.Callable = ..., percentage: float = ..., percentageChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., startAngle: float = ..., startAngleChanged: typing.Callable = ..., value: float = ..., valueChanged: typing.Callable = ...) -> None: ...
        def angleSpan(self) -> float: ...
        def borderColor(self) -> PySide2.QtGui.QColor: ...
        def borderWidth(self) -> int: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def color(self) -> PySide2.QtGui.QColor: ...
        def explodeDistanceFactor(self) -> float: ...
        def isExploded(self) -> bool: ...
        def isLabelVisible(self) -> bool: ...
        def label(self) -> str: ...
        def labelArmLengthFactor(self) -> float: ...
        def labelBrush(self) -> PySide2.QtGui.QBrush: ...
        def labelColor(self) -> PySide2.QtGui.QColor: ...
        def labelFont(self) -> PySide2.QtGui.QFont: ...
        def labelPosition(self) -> QtCharts.QPieSlice.LabelPosition: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def percentage(self) -> float: ...
        def series(self) -> QtCharts.QPieSeries: ...
        def setBorderColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setBorderWidth(self, width: int) -> None: ...
        def setBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setExplodeDistanceFactor(self, factor: float) -> None: ...
        def setExploded(self, exploded: bool = ...) -> None: ...
        def setLabel(self, label: str) -> None: ...
        def setLabelArmLengthFactor(self, factor: float) -> None: ...
        def setLabelBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setLabelColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setLabelFont(self, font: PySide2.QtGui.QFont) -> None: ...
        def setLabelPosition(self, position: QtCharts.QPieSlice.LabelPosition) -> None: ...
        def setLabelVisible(self, visible: bool = ...) -> None: ...
        def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def setValue(self, value: float) -> None: ...
        def startAngle(self) -> float: ...
        def value(self) -> float: ...

    class QPolarChart(QtCharts.QChart):
        class PolarOrientation:
            PolarOrientationAngular: typing.ClassVar[QtCharts.QPolarChart.PolarOrientation] = ...
            PolarOrientationRadial: typing.ClassVar[QtCharts.QPolarChart.PolarOrientation] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QPolarChart.PolarOrientations: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> QtCharts.QPolarChart.PolarOrientations: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QPolarChart.PolarOrientations: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QPolarChart.PolarOrientations: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QPolarChart.PolarOrientations: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QPolarChart.PolarOrientations: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QPolarChart.PolarOrientations: ...
    
        class PolarOrientations:
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QPolarChart.PolarOrientations: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> QtCharts.QPolarChart.PolarOrientations: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QPolarChart.PolarOrientations: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QPolarChart.PolarOrientations: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QPolarChart.PolarOrientations: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QPolarChart.PolarOrientations: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QPolarChart.PolarOrientations: ...
        PolarOrientationAngular: typing.ClassVar[QtCharts.QPolarChart.PolarOrientation] = ...
        PolarOrientationRadial: typing.ClassVar[QtCharts.QPolarChart.PolarOrientation] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtWidgets.QGraphicsItem,None] = ..., wFlags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., animationDuration: int = ..., animationEasingCurve: typing.Union[PySide2.QtCore.QEasingCurve,PySide2.QtCore.QEasingCurve.Type] = ..., animationOptions: typing.Any = ..., autoFillBackground: bool = ..., backgroundRoundness: float = ..., backgroundVisible: bool = ..., chartType: typing.Any = ..., children: typing.Any = ..., childrenChanged: typing.Callable = ..., destroyed: typing.Callable = ..., dropShadowEnabled: bool = ..., effect: typing.Any = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., geometry: PySide2.QtCore.QRectF = ..., geometryChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., layout: typing.Any = ..., layoutChanged: typing.Callable = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., localizeNumbers: bool = ..., margins: typing.Any = ..., maximumSize: PySide2.QtCore.QSizeF = ..., minimumSize: PySide2.QtCore.QSizeF = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., parentChanged: typing.Callable = ..., plotArea: PySide2.QtCore.QRectF = ..., plotAreaBackgroundVisible: bool = ..., plotAreaChanged: typing.Callable = ..., pos: PySide2.QtCore.QPointF = ..., preferredSize: PySide2.QtCore.QSizeF = ..., rotation: float = ..., rotationChanged: typing.Callable = ..., scale: float = ..., scaleChanged: typing.Callable = ..., size: PySide2.QtCore.QSizeF = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., theme: typing.Any = ..., title: str = ..., transformOriginPoint: PySide2.QtCore.QPointF = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: float = ..., widthChanged: typing.Callable = ..., windowFlags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., windowTitle: str = ..., x: float = ..., xChanged: typing.Callable = ..., y: float = ..., yChanged: typing.Callable = ..., z: float = ..., zChanged: typing.Callable = ...) -> None: ...
        @overload
        def addAxis(self, axis: QtCharts.QAbstractAxis, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
        @overload
        def addAxis(self, axis: QtCharts.QAbstractAxis, polarOrientation: QtCharts.QPolarChart.PolarOrientation) -> None: ...
        @classmethod
        def axisPolarOrientation(cls, axis: QtCharts.QAbstractAxis) -> QtCharts.QPolarChart.PolarOrientation: ...

    class QScatterSeries(QtCharts.QXYSeries):
        class MarkerShape:
            MarkerShapeCircle: typing.ClassVar[QtCharts.QScatterSeries.MarkerShape] = ...
            MarkerShapeRectangle: typing.ClassVar[QtCharts.QScatterSeries.MarkerShape] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtCharts.QScatterSeries.MarkerShape: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QScatterSeries.MarkerShape: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtCharts.QScatterSeries.MarkerShape: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QScatterSeries.MarkerShape: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> QtCharts.QScatterSeries.MarkerShape: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QScatterSeries.MarkerShape: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtCharts.QScatterSeries.MarkerShape: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QScatterSeries.MarkerShape: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtCharts.QScatterSeries.MarkerShape: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QScatterSeries.MarkerShape: ...
            def __sub__(self, other: typing.SupportsInt) -> QtCharts.QScatterSeries.MarkerShape: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QScatterSeries.MarkerShape: ...
        MarkerShapeCircle: typing.ClassVar[QtCharts.QScatterSeries.MarkerShape] = ...
        MarkerShapeRectangle: typing.ClassVar[QtCharts.QScatterSeries.MarkerShape] = ...
        borderColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        colorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        markerShapeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        markerSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., borderColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., borderColorChanged: typing.Callable = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., clicked: typing.Callable = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., colorChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., markerShape: QtCharts.QScatterSeries.MarkerShape = ..., markerShapeChanged: typing.Callable = ..., markerSize: float = ..., markerSizeChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., penChanged: typing.Callable = ..., pointAdded: typing.Callable = ..., pointLabelsClipping: bool = ..., pointLabelsClippingChanged: typing.Callable = ..., pointLabelsColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., pointLabelsColorChanged: typing.Callable = ..., pointLabelsFont: PySide2.QtGui.QFont = ..., pointLabelsFontChanged: typing.Callable = ..., pointLabelsFormat: str = ..., pointLabelsFormatChanged: typing.Callable = ..., pointLabelsVisibilityChanged: typing.Callable = ..., pointLabelsVisible: bool = ..., pointRemoved: typing.Callable = ..., pointReplaced: typing.Callable = ..., pointsRemoved: typing.Callable = ..., pointsReplaced: typing.Callable = ..., pointsVisible: bool = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., type: QtCharts.QScatterSeries.SeriesType = ..., useOpenGL: bool = ..., useOpenGLChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def borderColor(self) -> PySide2.QtGui.QColor: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def color(self) -> PySide2.QtGui.QColor: ...
        def markerShape(self) -> QtCharts.QScatterSeries.MarkerShape: ...
        def markerSize(self) -> float: ...
        def setBorderColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setMarkerShape(self, shape: QtCharts.QScatterSeries.MarkerShape) -> None: ...
        def setMarkerSize(self, size: float) -> None: ...
        def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def type(self) -> QtCharts.QAbstractSeries.SeriesType: ...

    class QSplineSeries(QtCharts.QLineSeries):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., clicked: typing.Callable = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., colorChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., penChanged: typing.Callable = ..., pointAdded: typing.Callable = ..., pointLabelsClipping: bool = ..., pointLabelsClippingChanged: typing.Callable = ..., pointLabelsColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., pointLabelsColorChanged: typing.Callable = ..., pointLabelsFont: PySide2.QtGui.QFont = ..., pointLabelsFontChanged: typing.Callable = ..., pointLabelsFormat: str = ..., pointLabelsFormatChanged: typing.Callable = ..., pointLabelsVisibilityChanged: typing.Callable = ..., pointLabelsVisible: bool = ..., pointRemoved: typing.Callable = ..., pointReplaced: typing.Callable = ..., pointsRemoved: typing.Callable = ..., pointsReplaced: typing.Callable = ..., pointsVisible: bool = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., type: QtCharts.QSplineSeries.SeriesType = ..., useOpenGL: bool = ..., useOpenGLChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def type(self) -> QtCharts.QAbstractSeries.SeriesType: ...

    class QStackedBarSeries(QtCharts.QAbstractBarSeries):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., barWidth: float = ..., barsetsAdded: typing.Callable = ..., barsetsRemoved: typing.Callable = ..., clicked: typing.Callable = ..., count: int = ..., countChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., hovered: typing.Callable = ..., labelsAngle: float = ..., labelsAngleChanged: typing.Callable = ..., labelsFormat: str = ..., labelsFormatChanged: typing.Callable = ..., labelsPosition: QtCharts.QStackedBarSeries.LabelsPosition = ..., labelsPositionChanged: typing.Callable = ..., labelsPrecision: int = ..., labelsPrecisionChanged: typing.Callable = ..., labelsVisible: bool = ..., labelsVisibleChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., type: QtCharts.QStackedBarSeries.SeriesType = ..., useOpenGL: bool = ..., useOpenGLChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def type(self) -> QtCharts.QAbstractSeries.SeriesType: ...

    class QVBarModelMapper(QtCharts.QBarModelMapper):
        firstBarSetColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        firstRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lastBarSetColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        modelReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        seriesReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., firstBarSetColumn: int = ..., firstBarSetColumnChanged: typing.Callable = ..., firstRow: int = ..., firstRowChanged: typing.Callable = ..., lastBarSetColumn: int = ..., lastBarSetColumnChanged: typing.Callable = ..., model: PySide2.QtCore.QAbstractItemModel = ..., modelReplaced: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., series: QtCharts.QAbstractBarSeries = ..., seriesReplaced: typing.Callable = ...) -> None: ...
        def firstBarSetColumn(self) -> int: ...
        def firstRow(self) -> int: ...
        def lastBarSetColumn(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def rowCount(self) -> int: ...
        def series(self) -> QtCharts.QAbstractBarSeries: ...
        def setFirstBarSetColumn(self, firstBarSetColumn: int) -> None: ...
        def setFirstRow(self, firstRow: int) -> None: ...
        def setLastBarSetColumn(self, lastBarSetColumn: int) -> None: ...
        def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
        def setRowCount(self, rowCount: int) -> None: ...
        def setSeries(self, series: QtCharts.QAbstractBarSeries) -> None: ...

    class QVBoxPlotModelMapper(QtCharts.QBoxPlotModelMapper):
        firstBoxSetColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        firstRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lastBoxSetColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        modelReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        seriesReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., firstBoxSetColumn: int = ..., firstBoxSetColumnChanged: typing.Callable = ..., firstRow: int = ..., firstRowChanged: typing.Callable = ..., lastBoxSetColumn: int = ..., lastBoxSetColumnChanged: typing.Callable = ..., model: PySide2.QtCore.QAbstractItemModel = ..., modelReplaced: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., series: QtCharts.QBoxPlotSeries = ..., seriesReplaced: typing.Callable = ...) -> None: ...
        def firstBoxSetColumn(self) -> int: ...
        def firstRow(self) -> int: ...
        def lastBoxSetColumn(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def rowCount(self) -> int: ...
        def series(self) -> QtCharts.QBoxPlotSeries: ...
        def setFirstBoxSetColumn(self, firstBoxSetColumn: int) -> None: ...
        def setFirstRow(self, firstRow: int) -> None: ...
        def setLastBoxSetColumn(self, lastBoxSetColumn: int) -> None: ...
        def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
        def setRowCount(self, rowCount: int) -> None: ...
        def setSeries(self, series: QtCharts.QBoxPlotSeries) -> None: ...

    class QVCandlestickModelMapper(QtCharts.QCandlestickModelMapper):
        closeRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        firstSetColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        highRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lastSetColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lowRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        openRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        timestampRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., closeRow: int = ..., closeRowChanged: typing.Callable = ..., destroyed: typing.Callable = ..., firstSetColumn: int = ..., firstSetColumnChanged: typing.Callable = ..., highRow: int = ..., highRowChanged: typing.Callable = ..., lastSetColumn: int = ..., lastSetColumnChanged: typing.Callable = ..., lowRow: int = ..., lowRowChanged: typing.Callable = ..., model: typing.Any = ..., modelReplaced: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., openRow: int = ..., openRowChanged: typing.Callable = ..., series: typing.Any = ..., seriesReplaced: typing.Callable = ..., timestampRow: int = ..., timestampRowChanged: typing.Callable = ...) -> None: ...
        def closeRow(self) -> int: ...
        def firstSetColumn(self) -> int: ...
        def highRow(self) -> int: ...
        def lastSetColumn(self) -> int: ...
        def lowRow(self) -> int: ...
        def openRow(self) -> int: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def setCloseRow(self, closeRow: int) -> None: ...
        def setFirstSetColumn(self, firstSetColumn: int) -> None: ...
        def setHighRow(self, highRow: int) -> None: ...
        def setLastSetColumn(self, lastSetColumn: int) -> None: ...
        def setLowRow(self, lowRow: int) -> None: ...
        def setOpenRow(self, openRow: int) -> None: ...
        def setTimestampRow(self, timestampRow: int) -> None: ...
        def timestampRow(self) -> int: ...

    class QVPieModelMapper(QtCharts.QPieModelMapper):
        firstRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        modelReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        seriesReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        valuesColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., firstRow: int = ..., firstRowChanged: typing.Callable = ..., labelsColumn: int = ..., labelsColumnChanged: typing.Callable = ..., model: PySide2.QtCore.QAbstractItemModel = ..., modelReplaced: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., series: QtCharts.QPieSeries = ..., seriesReplaced: typing.Callable = ..., valuesColumn: int = ..., valuesColumnChanged: typing.Callable = ...) -> None: ...
        def firstRow(self) -> int: ...
        def labelsColumn(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def rowCount(self) -> int: ...
        def series(self) -> QtCharts.QPieSeries: ...
        def setFirstRow(self, firstRow: int) -> None: ...
        def setLabelsColumn(self, labelsColumn: int) -> None: ...
        def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
        def setRowCount(self, rowCount: int) -> None: ...
        def setSeries(self, series: QtCharts.QPieSeries) -> None: ...
        def setValuesColumn(self, valuesColumn: int) -> None: ...
        def valuesColumn(self) -> int: ...

    class QVXYModelMapper(QtCharts.QXYModelMapper):
        firstRowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        modelReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        seriesReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        xColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yColumnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., firstRow: int = ..., firstRowChanged: typing.Callable = ..., model: PySide2.QtCore.QAbstractItemModel = ..., modelReplaced: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., series: QtCharts.QXYSeries = ..., seriesReplaced: typing.Callable = ..., xColumn: int = ..., xColumnChanged: typing.Callable = ..., yColumn: int = ..., yColumnChanged: typing.Callable = ...) -> None: ...
        def firstRow(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def rowCount(self) -> int: ...
        def series(self) -> QtCharts.QXYSeries: ...
        def setFirstRow(self, firstRow: int) -> None: ...
        def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
        def setRowCount(self, rowCount: int) -> None: ...
        def setSeries(self, series: QtCharts.QXYSeries) -> None: ...
        def setXColumn(self, xColumn: int) -> None: ...
        def setYColumn(self, yColumn: int) -> None: ...
        def xColumn(self) -> int: ...
        def yColumn(self) -> int: ...

    class QValueAxis(QtCharts.QAbstractAxis):
        class TickType:
            TicksDynamic: typing.ClassVar[QtCharts.QValueAxis.TickType] = ...
            TicksFixed: typing.ClassVar[QtCharts.QValueAxis.TickType] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtCharts.QValueAxis.TickType: ...
            def __and__(self, other: typing.SupportsInt) -> QtCharts.QValueAxis.TickType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtCharts.QValueAxis.TickType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtCharts.QValueAxis.TickType: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> QtCharts.QValueAxis.TickType: ...
            def __rand__(self, other: typing.SupportsInt) -> QtCharts.QValueAxis.TickType: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtCharts.QValueAxis.TickType: ...
            def __ror__(self, other: typing.SupportsInt) -> QtCharts.QValueAxis.TickType: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtCharts.QValueAxis.TickType: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtCharts.QValueAxis.TickType: ...
            def __sub__(self, other: typing.SupportsInt) -> QtCharts.QValueAxis.TickType: ...
            def __xor__(self, other: typing.SupportsInt) -> QtCharts.QValueAxis.TickType: ...
        TicksDynamic: typing.ClassVar[QtCharts.QValueAxis.TickType] = ...
        TicksFixed: typing.ClassVar[QtCharts.QValueAxis.TickType] = ...
        labelFormatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        maxChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minorTickCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rangeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        tickAnchorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        tickCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        tickIntervalChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        tickTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., colorChanged: typing.Callable = ..., destroyed: typing.Callable = ..., gridLineColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., gridLineColorChanged: typing.Callable = ..., gridLinePen: PySide2.QtGui.QPen = ..., gridLinePenChanged: typing.Callable = ..., gridVisible: bool = ..., gridVisibleChanged: typing.Callable = ..., labelFormat: str = ..., labelFormatChanged: typing.Callable = ..., labelsAngle: int = ..., labelsAngleChanged: typing.Callable = ..., labelsBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., labelsBrushChanged: typing.Callable = ..., labelsColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., labelsColorChanged: typing.Callable = ..., labelsEditableChanged: typing.Callable = ..., labelsFont: PySide2.QtGui.QFont = ..., labelsFontChanged: typing.Callable = ..., labelsVisible: bool = ..., labelsVisibleChanged: typing.Callable = ..., linePen: PySide2.QtGui.QPen = ..., linePenChanged: typing.Callable = ..., lineVisible: bool = ..., lineVisibleChanged: typing.Callable = ..., max: float = ..., maxChanged: typing.Callable = ..., min: float = ..., minChanged: typing.Callable = ..., minorGridLineColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., minorGridLineColorChanged: typing.Callable = ..., minorGridLinePen: PySide2.QtGui.QPen = ..., minorGridLinePenChanged: typing.Callable = ..., minorGridVisible: bool = ..., minorGridVisibleChanged: typing.Callable = ..., minorTickCount: int = ..., minorTickCountChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: PySide2.QtCore.Qt.Orientation = ..., rangeChanged: typing.Callable = ..., reverse: bool = ..., reverseChanged: typing.Callable = ..., shadesBorderColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., shadesBorderColorChanged: typing.Callable = ..., shadesBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., shadesBrushChanged: typing.Callable = ..., shadesColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., shadesColorChanged: typing.Callable = ..., shadesPen: PySide2.QtGui.QPen = ..., shadesPenChanged: typing.Callable = ..., shadesVisible: bool = ..., shadesVisibleChanged: typing.Callable = ..., tickAnchor: float = ..., tickAnchorChanged: typing.Callable = ..., tickCount: int = ..., tickCountChanged: typing.Callable = ..., tickInterval: float = ..., tickIntervalChanged: typing.Callable = ..., tickType: QtCharts.QValueAxis.TickType = ..., tickTypeChanged: typing.Callable = ..., titleBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., titleBrushChanged: typing.Callable = ..., titleFont: PySide2.QtGui.QFont = ..., titleFontChanged: typing.Callable = ..., titleText: str = ..., titleTextChanged: typing.Callable = ..., titleVisible: bool = ..., titleVisibleChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def applyNiceNumbers(self) -> None: ...
        def labelFormat(self) -> str: ...
        def max(self) -> float: ...
        def min(self) -> float: ...
        def minorTickCount(self) -> int: ...
        def setLabelFormat(self, format: str) -> None: ...
        @overload
        def setMax(self, max: typing.Any) -> None: ...
        @overload
        def setMax(self, max: float) -> None: ...
        @overload
        def setMin(self, min: typing.Any) -> None: ...
        @overload
        def setMin(self, min: float) -> None: ...
        def setMinorTickCount(self, count: int) -> None: ...
        @overload
        def setRange(self, min: typing.Any, max: typing.Any) -> None: ...
        @overload
        def setRange(self, min: float, max: float) -> None: ...
        def setTickAnchor(self, anchor: float) -> None: ...
        def setTickCount(self, count: int) -> None: ...
        def setTickInterval(self, insterval: float) -> None: ...
        def setTickType(self, type: QtCharts.QValueAxis.TickType) -> None: ...
        def tickAnchor(self) -> float: ...
        def tickCount(self) -> int: ...
        def tickInterval(self) -> float: ...
        def tickType(self) -> QtCharts.QValueAxis.TickType: ...
        def type(self) -> QtCharts.QAbstractAxis.AxisType: ...

    class QXYLegendMarker(QtCharts.QLegendMarker):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, series: QtCharts.QXYSeries, legend: QtCharts.QLegend, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., brushChanged: typing.Callable = ..., clicked: typing.Callable = ..., destroyed: typing.Callable = ..., font: PySide2.QtGui.QFont = ..., fontChanged: typing.Callable = ..., hovered: typing.Callable = ..., label: str = ..., labelBrush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient] = ..., labelBrushChanged: typing.Callable = ..., labelChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pen: PySide2.QtGui.QPen = ..., penChanged: typing.Callable = ..., shape: typing.Any = ..., shapeChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def series(self) -> QtCharts.QXYSeries: ...
        def type(self) -> QtCharts.QLegendMarker.LegendMarkerType: ...

    class QXYModelMapper(PySide2.QtCore.QObject):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
        def count(self) -> int: ...
        def first(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def series(self) -> QtCharts.QXYSeries: ...
        def setCount(self, count: int) -> None: ...
        def setFirst(self, first: int) -> None: ...
        def setModel(self, model: typing.Union[PySide2.QtCore.QAbstractItemModel,None]) -> None: ...
        def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
        def setSeries(self, series: QtCharts.QXYSeries) -> None: ...
        def setXSection(self, xSection: int) -> None: ...
        def setYSection(self, ySection: int) -> None: ...
        def xSection(self) -> int: ...
        def ySection(self) -> int: ...

    class QXYSeries(QtCharts.QAbstractSeries):
        clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        colorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        doubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
        penChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointLabelsClippingChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointLabelsColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointLabelsFontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointLabelsFormatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointLabelsVisibilityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointsRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pointsReplaced: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        released: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        @overload
        def append(self, x: float, y: float) -> None: ...
        @overload
        def append(self, point: PySide2.QtCore.QPointF) -> None: ...
        @overload
        def append(self, points: typing.Iterable[PySide2.QtCore.QPointF]) -> None: ...
        def at(self, index: int) -> PySide2.QtCore.QPointF: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def clear(self) -> None: ...
        def color(self) -> PySide2.QtGui.QColor: ...
        def count(self) -> int: ...
        def insert(self, index: int, point: PySide2.QtCore.QPointF) -> None: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def pointLabelsClipping(self) -> bool: ...
        def pointLabelsColor(self) -> PySide2.QtGui.QColor: ...
        def pointLabelsFont(self) -> PySide2.QtGui.QFont: ...
        def pointLabelsFormat(self) -> str: ...
        def pointLabelsVisible(self) -> bool: ...
        def points(self) -> typing.List[PySide2.QtCore.QPointF]: ...
        def pointsVector(self) -> typing.List[PySide2.QtCore.QPointF]: ...
        def pointsVisible(self) -> bool: ...
        @overload
        def remove(self, x: float, y: float) -> None: ...
        @overload
        def remove(self, index: int) -> None: ...
        @overload
        def remove(self, point: PySide2.QtCore.QPointF) -> None: ...
        def removePoints(self, index: int, count: int) -> None: ...
        @overload
        def replace(self, oldX: float, oldY: float, newX: float, newY: float) -> None: ...
        @overload
        def replace(self, index: int, newX: float, newY: float) -> None: ...
        @overload
        def replace(self, index: int, newPoint: PySide2.QtCore.QPointF) -> None: ...
        @overload
        def replace(self, oldPoint: PySide2.QtCore.QPointF, newPoint: PySide2.QtCore.QPointF) -> None: ...
        @overload
        def replace(self, points: typing.Iterable[PySide2.QtCore.QPointF]) -> None: ...
        @overload
        def replace(self, points: typing.List[PySide2.QtCore.QPointF]) -> None: ...
        def setBrush(self, brush: typing.Union[PySide2.QtGui.QBrush,PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,PySide2.QtGui.QLinearGradient]) -> None: ...
        def setColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...
        def setPointLabelsClipping(self, enabled: bool = ...) -> None: ...
        def setPointLabelsColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
        def setPointLabelsFont(self, font: PySide2.QtGui.QFont) -> None: ...
        def setPointLabelsFormat(self, format: str) -> None: ...
        def setPointLabelsVisible(self, visible: bool = ...) -> None: ...
        def setPointsVisible(self, visible: bool = ...) -> None: ...
        @overload
        def __lshift__(self, point: PySide2.QtCore.QPointF) -> QtCharts.QXYSeries: ...
        @overload
        def __lshift__(self, points: typing.Iterable[PySide2.QtCore.QPointF]) -> QtCharts.QXYSeries: ...
        def __rlshift__(self, other) -> typing.Any: ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
