import axipy
from PySide2.QtGui import QIcon
from axipy._internal._menu_file_position import _MenuFilePosition
from .observer import QueryTablesObserver
from .worker import DialogTaskCustom


class CloseAllQueries(axipy.Plugin):

    def __init__(self) -> None:
        self._title = self.tr("Закрыть все запросы")

        self._observer = QueryTablesObserver()

        self._button = axipy.ActionButton(
            title=self._title,
            tooltip=self.tr("Закрытие всех таблиц с типом 'Запрос'"),
            on_click=self.on_click,
            enable_on=self._observer,
            icon=QIcon.fromTheme("close_query"),
        )

        menu = _MenuFilePosition()
        menu.insert_after(self._button, "CloseTable")

    # noinspection PyBroadException
    @staticmethod
    def on_click() -> None:
        dt = DialogTaskCustom(title="Закрытие таблиц запросов", cancelable=True)
        dt.run_and_get()

    def unload(self) -> None:
        self._observer.unload()
        self._button.remove()
