from typing import Union

import axipy

from .my_tool import MyMapTool, MyReportTool


class ExampleTool(axipy.Plugin):
    def __init__(self) -> None:
        self._tool = axipy.ToolButton(
            title="Пример инструмента",
            icon="://icons/share/32px/run3.png",
            on_create_tool=self.on_create_tool,
            enable_on=axipy.ObserverManager.ActiveView,
        )
        position = axipy.Position("Примеры модулей", "Инструмент")
        position.add(self._tool)
        self._tool.action.setToolTip("Щелкните мышью на интересующем объекте.\nПравая кнопка мыши - выбор атрибута.")

    def unload(self) -> None:
        self._tool.remove()

    def on_create_tool(self, view_type: axipy.ViewTool.ViewType) -> Union[MyMapTool, MyReportTool, None]:
        if view_type == axipy.ViewTool.ViewType.MAP_VIEW:
            return MyMapTool("Выберите номер атрибута:")
        elif view_type == axipy.ViewTool.ViewType.REPORT_VIEW:
            return MyReportTool()
        else:
            return None
