from PySide2.QtCore import QObject
from lxml import etree
from osgeo import ogr
from osgeo.osr import SpatialReference


from rosreestrXml.ui.tools.KPT.egrn_tool.add_helper.json_db_obj import ExistTable
from rosreestrXml.ui.tools.KPT.egrn_tool.egrn_generate_new import EgrnImport
from rosreestrXml.ui.tools.db_helper.dbRsc import DbRsc
from rosreestrXml.ui.tools.forest.GLR.add_helper import find_elemens, DataAllGlr, Contours


def ExistLayer(ds,name_layer):
    layer=ds.GetLayerByName(name_layer)
    if layer is None:
        return None

    return layer

class ObjStructGlr:
    def __init__(self):
        self.__defFeields=[]
        self.__create()
    def __create(self):
        date_regField = ogr.FieldDefn("date_registration", ogr.OFTString)
        date_regField.SetWidth(12)
        self.__defFeields.append(date_regField)
        numberDocField=ogr.FieldDefn("number_doc", ogr.OFTString)
        numberDocField.SetWidth(50)
        self.__defFeields.append(numberDocField)
        registrationNumberField = ogr.FieldDefn("registration_number", ogr.OFTString)
        registrationNumberField.SetWidth(20)
        self.__defFeields.append(registrationNumberField)
        documentationNumberField=ogr.FieldDefn("documentation_number", ogr.OFTInteger)
        #self.__defFeields.append(documentationNumberField)
        mi_styleField = ogr.FieldDefn("mi_style", ogr.OFTString)
        mi_styleField.SetWidth(255)
        self.__defFeields.append(mi_styleField)
    @property
    def fieldsDefinitions(self):
        return self.__defFeields


class GlrObj(EgrnImport):
    __name = 'forest_declaration_glr'
    __name_process ="Импорт выписки GLR"
    def __init__(self,xml_source,property):
        super().__init__(xml_source,property)
        self.__xml=xml_source
        self.__property=property
        self.__progress_counter=0
        self.__parent_cls=None
        self.__ds=None
        self.__xml_cs=None
        self.__isCancel=False
    def setPathOut(self,path_db):
        self.__path_db=path_db
    def setParentCls(self,parent_cls,curent_id):
        self.__parent_cls = parent_cls
        self.__curent_id_source=curent_id
    def setPathOut(self,path_db):
        self.__path_db=path_db
    def setParentCls(self,parent_cls,curent_id):
        self.__parent_cls = parent_cls
        self.__curent_id_source=curent_id
    def run(self):
        self.__ds=ogr.Open(self.__path_db,1)
        self.__layer_out = ExistLayer(self.__ds, self.__name)

        if self.__layer_out is None:
            isOk=self.__createLayer()
        root = etree.fromstring(self.__xml)
        elements_dataAll=find_elemens(root,"*",'dataAll')
        countrs_elements=[]
        result = root.xpath("*/*/*/*")
        for elem in result:
            if elem.tag.find('}contours') > 0:
                countrs_elements.append(elem)
        cls_dataAll = DataAllGlr(elements_dataAll[0])
        for contr_elem in countrs_elements:
            if self.__xml_cs is None:
                el_entitySpatial = find_elemens(contr_elem, "*/*", "entitySpatial")
                value_cs = find_elemens(el_entitySpatial[0], "*/*", "code")
                name_cs = value_cs[0].text
                self.__xml_cs=name_cs
                print("coordsystem in source:"+self.__xml_cs)
            cls_spatial=Contours(contr_elem,self.updateProgressBar,self.__property['reverseXY'])
            geometry_out=cls_spatial.geometry
            self.__addRecord(cls_dataAll,geometry_out)
        self.__layer_out=None

    @property
    def cs_in_xml(self):
        return self.__xml_cs
    @property
    def NameTable(self):
        return self.__name
    def __createLayer(self):
        srs=SpatialReference()
        srs.ImportFromWkt(self.__property['cs'])
        self.__layer_out=self.__ds.CreateLayer(self.__name, srs, ogr.wkbUnknown)
        cl_struct=ObjStructGlr()
        for field in cl_struct.fieldsDefinitions:
            self.__layer_out.CreateField(field)
        return
    def __addRecord(self,clsDataAll:DataAllGlr,geometry_out):
        feature = ogr.Feature(self.__layer_out.GetLayerDefn())
        feature.SetField("date_registration",clsDataAll.dataRegistration)
        feature.SetField("number_doc", clsDataAll.number)
        feature.SetField("registration_number", clsDataAll.registrationNumber)
        #feature.SetField("documentation_number",clsDataAll.documentationNumber)
        feature.SetField("mi_style",self.__property['forestDeclaration']['locations']['style'])
        feature.SetGeometry(geometry_out)
        self.__layer_out.CreateFeature(feature)
        geometry_out=None
        feature=None
    def setCancel(self):
        self.__isCancel=True
    def updateProgressBar(self):
        self.__progress_counter=self.__progress_counter+1
        if self.__progress_counter>=100:
            self.__progress_counter=0
        if self.__parent_cls is not None:
            self.__parent_cls.updateProcess.emit(self.__curent_id_source/100,self.__progress_counter)