import sqlite3
from pathlib import Path

from loguru import logger

class DbRscTableNames:
    NameDisplayParametrs="displayparams"
class DbRsc:
    def __init__(self,path_db):
        self.__path_db=path_db
        self.__connection = None
        if path_db is not None:
            self.connect(path_db)

    def connect(self,path_db=None):
        if path_db is not None:
            if self.__path_db==path_db and self.__connection is not None:
                return True
        path_db_connect=path_db
        if path_db_connect is None:
            path_db_connect=self.__path_db
        else:
            self.__path_db=path_db
        try:
            self.__connection=sqlite3.connect(path_db_connect)
        except  Exception as ex:
            logger.exception("Error connect db:"+path_db_connect)
            print(ex)
            return False
        return True
    @property
    def isConnect(self):
        if self.__connection is not None:
            return True
        return False
    @property
    def PathDb(self):
        return self.__path_db
    def runSqlScript(self,path_script_sql):
        retValue=False
        with open(path_script_sql, 'r') as sql_file:
            sql_script = sql_file.read()
        cursor=self.__connection.cursor()
        try:
            cursor.executescript(sql_script)
            retValue = True
        except Exception as ex:
            logger.exception("Error run_script "+path_script_sql)
            print(ex)
        finally:
            cursor.close()
        return retValue
    def insertMany(self,sql,records):
        cursor = self.__connection.cursor()
        try:
            cursor.executemany(sql, records)
            self.__connection.commit()
        except Exception as ex:
            print(ex)
        finally:
            cursor.close()
        return
    def insert(self,sql,values):
        cursor = self.__connection.cursor()
        try:
            cursor.execute(sql, values)
        except Exception as ex:
            logger.exception("Error insert: " + sql)
            print(ex)
        finally:
            cursor.close()
        return

    def runSqlNoResult(self,sql):
        cursor = self.__connection.cursor()
        try:
            cursor.execute(sql)
        except Exception as ex:
            print(ex)
        finally:
            cursor.close()
        return
    def select(self,sql):
        cursor = self.__connection.cursor()
        out_data=[]
        try:
            cursor.execute(sql)
            records = cursor.fetchall()
            for row in records:
                out_data.append(row)
        except Exception as ex:
            print(ex)
        finally:
            cursor.close()
        return out_data
    def getNameColumnQuery(self,sql):
        cursor = self.__connection.cursor()
        columns = []
        try:
            cursor.execute(sql)
            for name in cursor.description:
                columns.append(name[0])
        except Exception as ex:
            print(ex)
        finally:
            cursor.close()
        return columns

    def commit(self):
        self.__connection.commit()
    def close(self,commit=True):
        if self.__connection is not None:
            if commit:
                self.__connection.commit()

            self.__connection.close()
        self.__connection=None
    def insertGetAutoinriment(self,sql,values):
        cursor = self.__connection.cursor()
        okInsert=False
        row_id=None
        try:
            cursor.execute(sql, values)
            okInsert=True
            cursor.execute("select last_insert_rowid()")
            records = cursor.fetchall()
            row_id=records[0][0]

        except Exception as ex:
            logger.exception("Error insert: " + sql)
            print(ex)
        finally:
            cursor.close()
        return row_id

def factoryDb(path_db):
    list_sql_scripts=[]
    list_sql_scripts.append("create_tab_display_params.sql")
    list_sql_scripts.append("semantic_att.sql")

    list_sql_scripts.append("layer_and_att.sql")
    list_sql_scripts.append("table_objects.sql")
    list_sql_scripts.append("required_possible.sql")
    list_sql_scripts.append("create_full_names_tables.sql")
    dbCls = DbRsc(path_db)
    if not dbCls.connect():
        return
    path_base=Path(__file__)
    for script_sql in list_sql_scripts:
        path_script=str(path_base.parent.joinpath(script_sql))
        isOk=dbCls.runSqlScript(path_script)
    return dbCls




