from osgeo import ogr, osr

from rosreestrXml.ui.tools.KPT.kptTools.DbKptDirectory import KptСatalog
from rosreestrXml.ui.tools.KPT.kptTools.KPTXml import GeoPolygonFromEntitySpatial
from rosreestrXml.ui.tools.KPT.kptTools.KptZones import maxFIDLayer

def createDocumentsStruct():
    struct_doc=[]
    for i in range(5):
        struct_doc.append({'name': 'Док' + str(i + 1) + ":Наименование", 'type': ogr.OFTString, 'width': 500})
        struct_doc.append({'name': 'Док' + str(i + 1) + ":Код_документа", 'type': ogr.OFTString, 'width': 12})
        struct_doc.append({'name': 'Док' + str(i + 1) + ":Документ", 'type': ogr.OFTString, 'width': 500})
        struct_doc.append({'name': 'Док' + str(i + 1) + ":Серия_документа", 'type': ogr.OFTString, 'width': 50})
        struct_doc.append({'name': 'Док' + str(i + 1) + ":Дата_выдачи", 'type': ogr.OFTString, 'width': 25})
        struct_doc.append(
            {'name': 'Док' + str(i + 1) + ":Организация_выдавшая_документ", 'type': ogr.OFTString, 'width': 500})
        struct_doc.append(
            {'name': 'Док' + str(i + 1) + ":Особые_отметки", 'type': ogr.OFTString, 'width': 500})
    return struct_doc
def addAtributDocuments(objDocuments,dbDictionary: KptСatalog):
    att = []
    for i, doc in enumerate(objDocuments):
        att.append({'name': 'Док' + str(i + 1) + ":Наименование", 'value': doc.Name})
        att.append({'name': 'Док' + str(i + 1) + ":Код_документа", 'value': doc.CodeDocument})
        documentFromCode = dbDictionary.getDocument(doc.CodeDocument)
        att.append({'name': 'Док' + str(i + 1) + ":Документ", "value": documentFromCode[0]})
        docSeries = doc.Series
        if docSeries is not None:
            att.append({'name': 'Док' + str(i + 1) + ":Серия_документа", 'value': docSeries})
        strDate = doc.Date.strftime("%Y-%m-%d")
        att.append({'name': 'Док' + str(i + 1) + ":Дата_выдачи", 'value': strDate})
        att.append({'name': 'Док' + str(i + 1) + ":Организация_выдавшая_документ", 'value': doc.IssueOrgan})
        docDesc = doc.Desc
        if docDesc is not None:
            att.append({'name': 'Док' + str(i + 1) + ":Особые_отметки", 'value': docDesc})
    return att
class ObjBound:
    def __init__(self,tagBound,cadNumber,mi_style=None):
        self.__xmlObjBound=tagBound
        self.__str_styleMi=mi_style
        self.__CadastralNumber=cadNumber
    def setMiStyle(self,mi_style):
        self.__str_styleMi=mi_style
    @staticmethod
    def getStruct():
        struct = []

        struct.append({'name': 'Учётный_номер', 'type': ogr.OFTString, 'width': 255})
        struct.append({'name': 'Описание', 'type': ogr.OFTString, 'width': 1000})
        struct.append({'name': 'Содержание_ограничений', 'type': ogr.OFTString, 'width': 4000})
        struct.extend(createDocumentsStruct())

        struct.append(
            {'name': 'Граница_муниципального_образования ', 'type': ogr.OFTString, 'width': 500})
        # struct.append({'name': 'УчётныйНомер', 'type': ogr.OFTString, 'width': 254})
        # struct.extend(getStructDocuments(countDocs))
        struct.append({'name': 'MI_STYLE', 'type': ogr.OFTString, 'width': 128})
        return struct
    def Write(self, layer, dbDictionary: KptСatalog,dbDocuments):
        strDescription = self.__xmlObjBound.Description
        valAccountNumber = self.__xmlObjBound.AccountNumber
        geoObj = GeoPolygonFromEntitySpatial(self.__xmlObjBound.Boundaries.Boundary[0].EntitySpatial)
        att = []
        att.append({'name': 'Учётный_номер', 'value': valAccountNumber})
        att.append({'name': 'Описание', 'value': strDescription})
        objDocuments=self.__xmlObjBound.Documents.Document
        att.extend(addAtributDocuments(objDocuments,dbDictionary))
        '''
        for i,doc in enumerate(objDocuments):
            att.append({'name': 'Док'+str(i+1)+":Наименование",'value':doc.Name})
            att.append({'name': 'Док' + str(i + 1) + ":Код_документа",'value':doc.CodeDocument})
            documentFromCode=dbDictionary.getDocument(doc.CodeDocument)
            att.append({'name': 'Док' + str(i + 1) + ":Документ", "value":documentFromCode[0]})
            docSeries=doc.Series
            if docSeries is not None:
                att.append({'name': 'Док' + str(i + 1) + ":Серия_документа", 'value': docSeries})
            strDate=doc.Date.strftime("%Y-%m-%d")
            att.append({'name': 'Док' + str(i + 1) + ":Дата_выдачи", 'value':strDate})
            att.append({'name': 'Док' + str(i + 1) + ":Организация_выдавшая_документ", 'value': doc.IssueOrgan})
            docDesc=doc.Desc
            if docDesc is not None:
                att.append({'name': 'Док' + str(i + 1) + ":Особые_отметки", 'value': docDesc})
        '''
        feature = ogr.Feature(layer.GetLayerDefn())

        att.append({'name': 'MI_STYLE', 'value': self.__str_styleMi})
        for atr_item in att:
            # print(atr_item['name'])
            # print(atr_item['value'])
            try:
                feature.SetField(atr_item['name'], atr_item['value'])
            except Exception as ex:
                jkl=0

        if geoObj is not None:
            feature.SetGeometry(geoObj)

        layer.CreateFeature(feature)
        geoObj = None
        feature = None
        name_layer = layer.GetName()
        #max_fid = maxFIDLayer(dbDocuments.Connection, name_layer, "fid")
        #dbDocuments.Write(max_fid, self.__xmlObjBound.Documents)
        return
class ObjBounds:
    __xmlBounds = None
    __name = "участки_границы"
    __listBound = None
    __cs_prj4 = None
    __str_styleMi = None
    __reverseXY = True
    __CadastralNumber = None
    __nameProcess = "Импорт границ"
    def __init__(self,tagBounds,cadastralNumber):
        #super().__init__(0, 100)
        if tagBounds is None:
            return
        self.__xmlBounds=tagBounds
        self.__CadastralNumber=cadastralNumber
        self.__listBound=[]
        for itemtagBound in  self.__xmlBounds.Bound:
            self.__listBound.append(ObjBound(itemtagBound,self.__CadastralNumber,self.__str_styleMi))

    @property
    def NameLayer(self):
        return self.__name

    @property
    def NameProcess(self):
        return self.__nameProcess
    def setOutParams(self,cs_proj4,mi_style,reverseXY=True):
        self.__str_styleMi = mi_style
        self.__cs_prj4 = cs_proj4
        self.__reverseXY = reverseXY
    def setProperties(self,property):
        self.__property=property
        self.__cs_prj4=property['cs']
    def CreateLayer(self,ds,createNewLayer=True):

        layer = None
        if not createNewLayer:
            layer = ds.GetLayer(self.__name)
            if layer is not None:
                return layer
        srs = osr.SpatialReference()
        srs.ImportFromWkt(self.__cs_prj4)
        layer = ds.CreateLayer(self.__name, srs, geom_type=ogr.wkbUnknown)
        for fld in ObjBound.getStruct():
            # create fields
            field_cur = ogr.FieldDefn(fld['name'], fld['type'])
            type_field = fld['type']
            if fld['type'] == ogr.OFTString:
                field_cur.SetWidth(fld['width'])
            layer.CreateField(field_cur)
        return layer
    def Write(self,layer,dbDictionary:KptСatalog,mapCatalog=None):
        if self.__listBound is None:
            return
        #layer.StartTransaction()
        ''' Получаем стиль из базы'''
        mi_style = dbDictionary.GetStyle('kpt_10_style', 'Bounds')
        if mi_style[0] is None:
            print(mi_style[1])
            str_mi_style = 'Pen (2, 6, 16711680) Brush (1, 16777215, 16777215)'
        else:
            str_mi_style = mi_style[0]
        for bound in self.__listBound:
            bound.setMiStyle(str_mi_style)
            #if dbDoc is not None:
            #    if dbDoc.IsConnect is False:
            #        dbDoc.initDb()
            bound.Write(layer,dbDictionary,mapCatalog)
        mapCatalog.addLayerInfoInMapCataalog(layer, self.__property['cs_mi'])