import axipy
from PySide2.QtGui import QIcon
from axipy import AxiomaPlugin, local_file

from rosreestrXml.ui.MainForm import XmlImportMainForm
from rosreestrXml.ui.helper_docs.docWidget import AxiDocWidget, addDoc, existDocWidget, DelDocWidget


class Plugin(AxiomaPlugin):
    __name = 'Импорт xml'
    def load(self):
        self.__action = self.create_action('Импорт xml',
                icon=local_file('ui/icons', 'icons8-xml-32.png'), on_click=self.__run)
        position = self.get_position('Дополнительно', 'Действия')
        position.add(self.__action)
        self.__import_xml=None
        self.__docWidget=None

    def unload(self):
        if self.__docWidget is not None:
            self.__import_xml=None
            self.__removeWidget(self.__docWidget)
            self.__docWidget=None
        self.__action.remove()
    def __removeWidget(self,doc):
        if doc is None:
            return
        DelDocWidget(axipy.app.mainwindow.qt_object(),doc)
        doc=None
    def __run(self):
        print("click")
        if self.__import_xml is None:
            self.__import_xml=XmlImportMainForm()
        if self.__docWidget is None:
            self.__docWidget = AxiDocWidget(self.__import_xml.widget, "ImportXml", self.__name, QIcon(),
                                            axipy.app.mainwindow.qt_object())
            addDoc(axipy.app.mainwindow.qt_object(), self.__docWidget)
        else:
            isExist=existDocWidget(axipy.app.mainwindow.qt_object(),self.__docWidget)
            self.__docWidget.setVisible(True)
            self.__docWidget.setFocus()
            self.__docWidget.raise_()