import glob
import axipy
from rosreestrXml.ui.tools.OutDrv.DbDocuments import DocumentsDb
from rosreestrXml.ui.tools.OutDrv.ObjectToSave import DbGeoOgr, TypeGeometryProviderOgr
from rosreestrXml.ui.tools.kptTools.DbKptDirectory import KptСatalog
from rosreestrXml.ui.tools.kptTools.KptObjXml import FactoryKpt
from rosreestrXml.ui.tools.kptTools.kpt_10 import parse

path_source=r"E:\Download\RossRestr\63_21_Клявлинский 2020\63_21_Клявлинский 2020\*.xml"
list_files=glob.glob(path_source)
path_out_db=r"E:\Download\RossRestr\63_21_Клявлинский 2020\63_21.gpkg"
dbCatalog=KptСatalog()
dbDoc=None
dbDoc=DocumentsDb(path_out_db)
db=DbGeoOgr(dbCatalog)
db.Create(path_out_db,TypeGeometryProviderOgr.GPKG)
db.setDbDocuments(dbDoc)
cs_wkt='LOCAL_CS["NonEarth_Meter",UNIT["METER",1]]'
mi_style='Pen (3, 9, 255) Brush (18, 65280)'
mi_style='Pen (3, 9, 255) ,Pen (3, 9, 255) Brush (18, 65280)'
for i,path_xml in enumerate(list_files):
    if i>2:
        break
    ObjKpt = parse(path_xml, True)
    if ObjKpt is None:
        continue
    objXmlKpt = FactoryKpt(ObjKpt)
    objSpatial = objXmlKpt[0].SaveSpatialData(db, cs_wkt, mi_style)
    objXmlKpt[0].SaveParcels(db, cs_wkt, mi_style)
db.Close()
print(" End End")