import axipy
from axipy import Geometry, Pnt, LineString, Polygon, Table


def getPoints(geo:Geometry):
    if geo.type==axipy.GeometryType.Point:
        return [Pnt(geo.x,geo.y)]
    if geo.type == axipy.GeometryType.Line:
        return [Pnt(geo.begin.x,geo.begin.y),Pnt(geo.end.x,geo.end.y)]
    if geo.type == axipy.GeometryType.LineString:
        return geo.points
    return None
class FactoryGeometry:
    def __init__(self):
        self.__points=None
    #def builds(self,ft_list,type_out_obj,style='Pen (1, 2, 0) Brush (1, 16777215, 16777215)'):
    def prepare_points(self,geometry_list):
        self.__points = []
        if isinstance(geometry_list,Table):
            return self.__prepare_points_from_tab(geometry_list)

        for geo in geometry_list:
            points=getPoints(geo)
            if points is None:
                continue
            self.__points.extend(points)
        return len(self.__points)
    def __prepare_points_from_tab(self,tab:Table):
        for ft in tab.items():
            if ft.geometry is None:
                continue
            points = getPoints(ft.geometry)
            if points is None:
                continue
            self.__points.extend(points)
        return len(self.__points)
    @property
    def Points(self):
        return self.__points
    def createGeometry(self,type:axipy.GeometryType,cs):
        geometry=None
        if type==axipy.GeometryType.LineString:
            geometry=LineString(self.__points,cs)
        if type==axipy.GeometryType.Polygon:
            geometry=Polygon(self.__points,cs)
        if type.LineString:
            return geometry
        if geometry.is_valid:
            return geometry
        new_geometry=geometry.normalize()
        geometry=None
        return new_geometry






