import os
from pathlib import Path

import axipy
from PySide2 import QtCore
from PySide2.QtCore import QFile, QThread
from PySide2.QtGui import QIcon
from PySide2.QtUiTools import QUiLoader
from PySide2.QtWidgets import QDialog, QFileDialog, QApplication

from LoadMiWor.ui.processTool.LoadWor import ProcessLoadWor
from loguru import logger

class DlgFormWorOpen(QDialog):
    cancelProcess = QtCore.Signal()
    def __init__(self,parent=None):
        super(DlgFormWorOpen, self).__init__(parent)
        self.__parentWin=parent
        self.load_ui("DlgLoadWor.ui")
        self.window.setWindowFlags(self.window.windowFlags() & ~QtCore.Qt.WindowCloseButtonHint& ~QtCore.Qt.WindowContextHelpButtonHint)
        curent_path=str(Path(__file__).parent)
        path_icon=os.path.join(curent_path,"icons")
        path_add_png=os.path.join(path_icon,"open-32.png")
        self.window.pb_select_file.setIcon(QIcon(path_add_png))
        self.window.pb_cancel.clicked.connect(self.__cancel)
        self.window.pb_select_file.clicked.connect(self.__open_wor)
        self.window.ln_path_source.textChanged.connect(self.__change_path)
        self.window.pb_run.clicked.connect(self.__run)
        self.__dlgSelectFile=None
        self.__process=None
    def load_ui(self,name_resource):
        loader = QUiLoader()
        path = os.path.join(os.path.dirname(__file__),name_resource)
        ui_file = QFile(path)
        ui_file.open(QFile.ReadOnly)
        self.window  = loader.load(ui_file,self.__parentWin)
        ui_file.close()
    def exec_(self):
        self.window.progress_process.setValue(0)
        self.window.show()
        self.window.exec_()

    def __change_path(self,path_file_wor):
        if Path(path_file_wor).exists() :
            if Path(path_file_wor).is_file():
                self.window.pb_run.setEnabled(True)
            else:
                self.window.pb_run.setEnabled(False)
        else:
            self.window.pb_run.setEnabled(False)
    def show(self):
        self.window.progress_process.setValue(0)
        self.window.show()
    def __cancel(self):
        if self.__process is not None:
            self.__process_status = False
            self.cancelProcess.emit()
            self.__process.setCancel()
        else:
            self.window.close()
    def __open_wor(self):
        '''
        folder_source=None
        #path_appData=os.path.expanduser('~/Documents')
        if len(self.window.ln_path_source.text())==0 or folder_source is None:
            folder_source=os.path.expanduser('~/Documents')
        if not Path(self.window.ln_path_source.text()).parent.exists():
            folder_source=os.path.expanduser('~/Documents')
        '''
        '''
        if self.__dlgSelectFile is None:
            path_appData=os.path.expanduser('~/Documents')
            self.__dlgSelectFile=QFileDialog(self,"Открыть рабочий набор",path_appData, "Wor (*.wor)")
            filter = 'Wor (*.[wW][oO][rR])'
            self.__dlgSelectFile.setFilter(filter)
            self.__dlgSelectFile.setFileMode(QFileDialog.FileMode.ExistingFiles)
        if self.__dlgSelectFile.exec_():
            filenames = self.__dlgSelectFile.selectedFiles()
            file_wor=filenames[0]
            self.window.ln_path_source.setText(file_wor)
            self.__dlgSelectFile.setDirectory(str(Path(file_wor).parent))
            self.window.pb_run.setEnabled(True)
        '''
        filter = 'Wor (*.[wW][oO][rR])'
        filter = 'Wor (*.wor *.WOR)'
        #selected_filter = "Wor (*.wor)"
        selected_filter=filter
        path_wor=res = axipy.open_files_dialog(filter, "Открыть рабочий набор", None, selected_filter)
        if path_wor is not None:
            self.window.ln_path_source.setText(str(path_wor[0]))
            self.window.pb_run.setEnabled(True)
        else:
            self.window.pb_run.setEnabled(False)
    def __run(self):
        self.window.pb_run.setEnabled(False)
        self.__init_log(self.window.ln_path_source.text())
        logger.info("Загрузка рабочего набора:" + self.window.ln_path_source.text())
        self.__process=ProcessLoadWor("Загрузка рабочего набора",self)
        self.__process.setParams({'source':self.window.ln_path_source.text()})
        self.__process.updateProcess.connect(self.__update_progress)
        self.__process.finished.connect(self.__end_process)
        self.__process.updateFormatProgressBar.connect(self.__setFormatprogressBar)
        self.thread = QThread()
        self.__process.moveToThread(self.thread)
        self.__process.run()
    def __end_process(self, value):
        #self.window.pb_cancel.setEnabled(False)
        self.window.pb_run.setEnabled(True)
        if value == 100:
            pass
        else:
            '''
            if os.path.exists(self.__path_out_raster):
                os.remove(self.__path_out_raster)
            Notifications.push('Объединение растров', 'Было преррвано', Notifications.Information)
            '''
            pass
        self.__process=None
        logger.info("End load wor:" + self.window.ln_path_source.text())
        self.window.close()
        #logger.complete()
    def __update_progress(self, value):
        self.window.progress_process.setValue(value)

        # print(value)
        import time
        time.sleep(0.0001)
        QApplication.processEvents()
    def __setFormatprogressBar(self, str_format):
        self.window.progress_process.setFormat(str_format)
        import time
        time.sleep(0.0001)
        QApplication.processEvents()
    def __init_log(self,path_wor):
        path_w=Path(path_wor)
        from datetime import datetime

        now = datetime.now()  # current date and time
        date_time = now.strftime("%Y_%m_%d_%H_%M_%S")
        path_log_cls=path_w.parent.joinpath(str(path_w.stem)+"_"+date_time+".log")
        if path_log_cls.exists():
            os.remove(str(path_log_cls))
        self.__log_dev=logger.add(str(path_log_cls),format="{time:MMMM D, YYYY > HH:mm:ss} | {level} | {message} | {extra}")
        #self.__log_dev = logger.add(str(path_log_cls),level="DEBUG",format="{time:MMMM D, YYYY > HH:mm:ss} | {level} | {message} | {extra}")








