import os

import axipy
from PySide2.QtGui import QIcon
from axipy import AxiomaPlugin, Position

from CopyMws.ui.FormCopyMws import dlgFormCopyMws
from CopyMws.ui.processtool.addTools.docWidget import DelDocWidget, AxiDocWidget, addDoc, existDocWidget
from CopyMws.ui.CopyMwsPlugin import CopyMws


class Plugin(AxiomaPlugin):
    def load(self):

        self.__form_copy_mws = None
        self.__copy_mws_doc = None
        local_file_icon_correct = os.path.join(os.path.dirname(os.path.realpath(__file__)), 'ui/icons', 'copyMws.png')
        self.__action = self.create_action('Копирование mws',
                                           icon=local_file_icon_correct, on_click=self.__run_merge)
        position = self.get_position('Дополнительно', 'Инструменты')
        position.add(self.__action, size=2)
    def unload(self):
        self.__action.remove()
        self.__removeWidget()

    def __removeWidget(self):
        if self.__form_copy_mws is None:
            return
        DelDocWidget(axipy.app.mainwindow.qt_object(), self.__copy_mws_doc)
        self.__form_copy_mws = None
        self.__copy_mws_doc = None
    def __run_merge(self):
        mainwindowAxi=axipy.app.mainwindow.qt_object()
        if self.__form_copy_mws is None:
            self.__form_copy_mws=dlgFormCopyMws( mainwindowAxi)
        if self.__copy_mws_doc is None:
            self.__copy_mws_doc=AxiDocWidget(self.__form_copy_mws.widget,"CopyMws","Копирование рабочего набора",QIcon(),mainwindowAxi)
            addDoc(mainwindowAxi,self.__copy_mws_doc)
        else:
            isExist=existDocWidget(axipy.app.mainwindow.qt_object(),self.__copy_mws_doc)
            self.__copy_mws_doc.setVisible(True)
            self.__copy_mws_doc.setFocus()
            self.__copy_mws_doc.raise_()




