import os
from pathlib import PurePath, Path

from lxml import etree

from addTools.tabFiles import FileSourceMws


#from ui.processtool.addTools.tabFiles import FileSourceMws

def updateMwsLxml(tree_nodes,listTabUpdate,path_folder_dest,namespaces):
    nodes_TABFileDataSourceDefinition = tree_nodes.xpath(
        '//mxp:WorkSpace/mxp:DataSourceDefinitionSet/mxp:TABFileDataSourceDefinition', namespaces=namespaces)
    for node in nodes_TABFileDataSourceDefinition:
        id = node.attrib['id']
        items_list=list(filter(lambda tab_mws:  tab_mws.idSource ==id,listTabUpdate ))
        if len(items_list)==0:
            print("Not find ID:"+id)
            continue
        #node_file_name = node.find('{http://www.mapinfo.com/mxp}FileName')
        node_file_name = node.xpath('mxp:FileName',namespaces=namespaces)
        #test_path=items_list[0].setDestPath(node_file_name[0].text)
        #relative_path=os.path.relpath(items_list[0].destPath,path_folder_dest)
        node_file_name[0].text="Пример"

def getFileNameLxml(node,namespace)->str:
    node_file_name=node.xpath('mxp:FileName',namespaces=namespace)
    if node_file_name is None:
        return None,None
    id = node.attrib['id']
    filename=node_file_name[0].text
    return filename,id
def getListTabInMwsLxml(tree_nodes,path_folder_mws,namespaces):
    list_tab_in_wms=[]
    #nodes_TABFileDataSourceDefinition = tree_nodes.xpath('//mxp:WorkSpace/mxp:DataSourceDefinitionSet/mxp:TABFileDataSourceDefinition/*',namespaces=namespaces)
    nodes_TABFileDataSourceDefinition = tree_nodes.xpath(
        '//mxp:WorkSpace/mxp:DataSourceDefinitionSet/mxp:TABFileDataSourceDefinition', namespaces=namespaces)
    #    '//mxpDataSourceDefinitionSet/{http://www.mapinfo.com/mxp}TABFileDataSourceDefinition')
    for node in nodes_TABFileDataSourceDefinition:

        file_name,id = getFileNameLxml(node,namespaces)
        jkl=0
        file_source=FileSourceMws(file_name,id)
        full_path = str(path_folder_mws.joinpath(file_name))
        abs_path = PurePath(full_path)
        file_source.setParentFolder(path_folder_mws)
        list_tab_in_wms.append(file_source)
    return list_tab_in_wms
def findTabDef(root_etree):
    tags=root_etree.xpath('/WorkSpace/DataSourceDefinitionSet/TABFileDataSourceDefinition')
    jkl=0
name_file='E:\\Support\\Terix\\Repo\\Maps\\Russia.mws'
name_copy='E:\\Support\\Terix\\Repo\\Maps\\Russia_copy.mws'
tree = etree.parse(name_file,)
text_xml=etree.tostring(tree.getroot())
et = etree.ElementTree(tree.getroot())
ns1 = {"gml":"http://www.opengis.net/gml" ,"mxp":"http://www.mapinfo.com/mxp"}
ns=tree.getroot().nsmap
nodes=tree.xpath('//WorkSpace/*',namespaces=ns1 )
listTabUpdate=getListTabInMwsLxml(tree,Path(name_file).parent,ns1)
updateMwsLxml(tree,listTabUpdate,Path(name_copy).parent,ns1)
et.write(name_copy, pretty_print=True,xml_declaration=True, encoding='UTF-8')
jkl=0