from PySide2.QtCore import Qt
from PySide2.QtGui import QIcon
from PySide2.QtWidgets import QDockWidget, QWidget, QPushButton, QLineEdit, QVBoxLayout

from axipy import Position, tr, mainwindow, Notifications, Plugin, Separator
from axipy.menubar import SystemActionButton
from .helper import create_dialog


class ExamplePluginExtended(Plugin):
    def __init__(self) -> None:
        self._action = self.create_action(
            title=tr("Пример действия"),
            icon=str(self.plugin_dir / "ui" / "run.png"),
            on_click=self.add_dock_panel,
            doc_file="index.html"
        )
        position = Position(self.tr("Примеры модулей"), self.tr("Расширенный пример модуля"))
        position.add(self._action, size=2)
        self.__separator = Separator()
        position.add(self.__separator)
        # Показ диалога
        self.__action_custom = self.create_action(
            tr("Диалог"),
            icon=str(self.plugin_dir / "ui" / "dialog.png"),
            on_click=self.show_custom
        )
        position.add(self.__action_custom, size=2)
        # вызов системного действия
        self.__system_action = SystemActionButton("ManagePlugins")
        position.add(self.__system_action)

        self.dock = None

    def unload(self) -> None:
        # Выгрузка ресурсов
        self._action.remove()
        self.__separator.remove()
        self.__action_custom.remove()
        self.__system_action.remove()
        if self.dock is not None:
            mainwindow.remove_dock_widget(self.dock)
            self.dock = None

    def add_dock_panel(self) -> None:
        # Добавление пользовательской панели
        if self.dock is None:
            self.dock = QDockWidget(tr("Пример панели"))
            widget = QWidget()
            button = QPushButton("Кнопка", widget)
            button.clicked.connect(lambda: print('Реакция на кнопку'))
            edit = QLineEdit("текст")
            layout = QVBoxLayout()
            layout.addWidget(button)
            layout.addWidget(edit)
            layout.addStretch()
            widget.setLayout(layout)
            self.dock.setWidget(widget)
            mainwindow.add_dock_widget(self.dock, Qt.RightDockWidgetArea, QIcon("://icons/share/32px/logo.png"))
            edit.setFocus()
            # Уведомление
            Notifications.push(tr("Информация"), tr("Панель добавлена"), Notifications.Information)

    def show_custom(self) -> None:
        ui_file = str(self.plugin_dir / "ui" / "CustomDialog.ui")
        dialog = create_dialog(ui_file)

        def print_func() -> None:
            print(dialog.textEdit.toPlainText())

        dialog.btnPrint.clicked.connect(print_func)
        dialog.open()
