import os

from PySide2.QtCore import Qt
from PySide2.QtUiTools import QUiLoader
from PySide2.QtWidgets import QDialog, QFileDialog

from axipy import Settings, provider_manager, Layer, Map, view_manager, data_manager


class MyDialog(QDialog):
    def __init__(self, parent) -> None:
        super().__init__(parent)
        # Подробнее по созданию *.ui файла см. документацию. Раздел "Пользовательский интерфейс"
        ui_file = os.path.join(os.path.dirname(__file__), "mydialog.ui")
        self.ui = QUiLoader().load(ui_file, parent)
        # Реакция на нажатие кнопки
        self.ui.btnCallback.clicked.connect(self.button_clicked)
        self.__catched = False
        self.button_clicked()
        self.ui.pushButtonOpen.clicked.connect(self.button_clicked_open_file)
        self.ui.setWindowFlags(self.windowFlags() & ~Qt.WindowContextHelpButtonHint)  # Выключение значка "?"

    def button_clicked_open_file(self) -> None:
        last_path = Settings.value(Settings.LastOpenPath)
        file_name, _ = QFileDialog.getOpenFileName(
            self,
            "Выберите файл",
            last_path,
            "Файлы TAB (*.tab);;Все файлы (*.*)"
        )
        if file_name:
            table = provider_manager.openfile(file_name)
            layer = Layer.create(table)
            map_ = Map([layer])
            view_manager.create_mapview(map_)

    def __log_msg(self, msg: str) -> None:
        self.ui.textEdit.append(msg)

    # Перенаправление метода open на self.ui
    def open(self) -> None:
        self.ui.open()

    # Отслеживает открытие и закрытие данных в Аксиоме.
    # При активной кнопке self.ui.btnCallback режим включен. Иначе выключен.
    def button_clicked(self) -> None:
        if not self.__catched:
            data_manager.added[str].connect(lambda n: self.__log_msg(f'Таблица "{n}" добавлена в каталог.'))
            data_manager.removed[str].connect(lambda n: self.__log_msg(f'Таблица "{n}" удалена из каталога.'))
        else:
            data_manager.added[str].disconnect()
            data_manager.removed[str].disconnect()
        self.__catched = not self.__catched
