from axipy import Position, view_manager, Plugin
from .mydialog import MyDialog


# Пример диалогового окна
class DialogWindow(Plugin):

    def __init__(self) -> None:
        self._action = self.create_action(
            self.tr("Открыть форму"),
            icon="://icons/share/32px/run3.png", 
            on_click=self.show_dialog
        )
        position = Position(self.tr("Примеры модулей"), self.tr("Диалог"))
        position.add(self._action)

    def unload(self) -> None:
        self._action.remove()

    @staticmethod
    def show_dialog() -> None:
        dlg = MyDialog(view_manager.global_parent)
        dlg.open()
