from axipy.decorator import InitOnce
from PySide2.QtCore import QLocale
from axipy.cpp_core_core import ShadowFloatFormatter


class FloatFormatter:
    """Класс для преобразования чисел с плавающей точкой в текст"""

    @staticmethod
    def to_localized_string(value: float, locale: QLocale = QLocale()) -> str:
        """
        Возвращает число в виде строки форматированный с учетом переданной локали.

        Args:
            value: Значение которое нужно представить в виде стоки.
            precision: Необходимое число знаков после запятой.
            locale: Локаль в которой нужно вывести значение. По умолчанию текущая локаль.
        """
        return ShadowFloatFormatter.to_localized_string(value, locale)

    @staticmethod
    def to_localized_string_round(value: float, precision: int, \
        locale: QLocale = QLocale()) -> str:
        """
        Возвращает число в виде строки. Количество знаков после запятой задается
        параметром precision.

        Args:
            value: Значение которое нужно представить в виде стоки.
            precision: Необходимое число знаков после запятой.
            locale: Локаль в которой нужно вывести значение. По умолчанию текущая локаль.
        """
        return ShadowFloatFormatter.to_localized_string_round(value, precision, locale)

    @staticmethod
    def float_to_str(value: float, use_delimeter: bool = False, precision: int  = 15) -> str:
        """Представляет значение типа float в виде строки с заданными параметрами.
        
        Args:
            value: Входное значение
            use_delimeter: Если True, то использовать разделитель разрядов
            precision: Количество знаков после запятой, если необходимо округление

        .. literalinclude:: /../../tests/doc_examples/test_example_formatter.py
            :caption: Пример.
            :pyobject: test_run_example_float_formatter
            :lines: 2-
            :dedent: 4
        """
        return ShadowFloatFormatter.float_to_str(value, use_delimeter, precision)

    @staticmethod
    def float_round(value: float, precision: int) -> float:
        """Округляет число до заданной точности
        
        Args:
            value: Входное значение
            precision: Количество знаков после запятой

        .. literalinclude:: /../../tests/doc_examples/test_example_formatter.py
            :caption: Пример.
            :pyobject: test_run_example_float_round
            :lines: 2-6
            :dedent: 4
        """
        return ShadowFloatFormatter.float_round(value, precision)

    @staticmethod
    def float_round_signific(value: float, digits: int = 15) -> float:
        """Округляет число с указанием количества значащих цифр.
        
        Args:
            value: Входное значение
            digits: Количество значащих цифр

        .. literalinclude:: /../../tests/doc_examples/test_example_formatter.py
            :caption: Пример.
            :pyobject: test_run_example_float_round
            :lines: 2, 7-
            :dedent: 4
        """
        return ShadowFloatFormatter.float_round_signific(value, digits)

