# The PEP 484 type hints stub file for the _gui module.
#
# Generated by SIP 4.19.3.dev1705052245


import typing
import sip

from axioma_dynload import _render
from axioma_dynload import _core_plugin
from axioma_dynload import _common
from axioma_dynload import _core_serializable
from PyQt5 import QtWidgets

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], sip.Buffer, int, None]


class Gui(_render.Render):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def createMapView(self, map: _render.Map, parent: typing.Optional[QtWidgets.QWidget] = ...) -> 'MapView': ...
    def toolControllerManager(self) -> 'ToolControllerManager': ...
    def widgetManagerService(self) -> 'WidgetManagerService': ...
    def actionManager(self) -> 'ActionManager': ...
    def selectionManager(self) -> _core_dp.SelectionManager: ...
    def initialize(self) -> None: ...


class RibbonActionInfo(sip.wrapper):

    category = ... # type: str
    defaultGroupId = ... # type: str
    defaultTabId = ... # type: str

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, tab: str, group: str, cat: str) -> None: ...
    @typing.overload
    def __init__(self, cat: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'RibbonActionInfo') -> None: ...


class NativeActionExtension(_core_plugin.Extension):

    def __init__(self, actionId: str, ribbonInfo: RibbonActionInfo = ..., parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def createAction_impl(self, parent: QtCore.QObject) -> QtWidgets.QAction: ...
    def ribbonInfo(self) -> RibbonActionInfo: ...
    def ribbonGroupId(self) -> str: ...
    def ribbonTabId(self) -> str: ...
    def categoryId(self) -> str: ...
    def actionId(self) -> str: ...
    def customizeAction(self, action: QtWidgets.QAction) -> None: ...
    def createAction(self, parent: QtCore.QObject) -> QtWidgets.QAction: ...


class TableWindow(QtWidgets.QMainWindow):

    @typing.overload
    def __init__(self, sm: _core_dp.SelectionManager, table: _core_dp.Table, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, gui: Gui, table: typing.Any, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def pageUpdated(self) -> None: ...
    def schemaChanged(self) -> None: ...
    def editorEnabled(self, a0: bool) -> None: ...
    def rollForwardEnabled(self, a0: bool) -> None: ...
    def rollBackEnabled(self, a0: bool) -> None: ...
    def saveEnabled(self, a0: bool) -> None: ...
    def setBrowserFont(self, font: QtGui.QFont) -> None: ...
    def browserFont(self) -> QtGui.QFont: ...
    def table(self) -> _core_dp.Table: ...
    def browser(self) -> 'Browser': ...


class MapViewManager(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def editableChanged(self) -> None: ...
    def windowTitleChanged(self, a0: 'MapView', a1: str) -> None: ...
    def selectionChanged(self) -> None: ...
    def currentMapViewChanged(self) -> None: ...
    def mapContentsChanged(self) -> None: ...
    def mapCountChanged(self) -> None: ...
    def mapViewRemoved(self, mapView: 'MapView') -> None: ...
    def removeMapView(self, mapView: 'MapView') -> None: ...
    def currentMapView(self) -> 'MapView': ...
    def setCurrentMapView(self, mapView: 'MapView') -> None: ...
    def viewForMap(self, map: _render.Map) -> 'MapView': ...
    def mapViews(self) -> typing.Any: ...
    def mapViewCount(self) -> int: ...
    def appendMapView(self, mapView: 'MapView') -> None: ...


class Item(sip.wrapper):

    def updateOriginalGeometry(self, geom: _core_geometry.Geometry) -> None: ...
    def originalGeometry(self) -> _core_geometry.Geometry: ...
    def originalCentroid(self) -> QtCore.QPointF: ...
    def originalTransform(self, transform: QtGui.QTransform) -> None: ...
    def isEditable(self) -> bool: ...
    def geometry(self) -> _core_geometry.Geometry: ...
    def centroid(self) -> QtCore.QPointF: ...
    def equals(self, other: 'Item') -> bool: ...
    def canScale(self) -> bool: ...
    def canRotate(self) -> bool: ...
    def updateStyle(self, style: _render.Style) -> None: ...
    def style(self) -> typing.Any: ...
    def updateGeometry(self, geom: _core_geometry.Geometry) -> None: ...
    def transform(self, transform: QtGui.QTransform) -> None: ...
    def intersects(self, r: QtCore.QRectF) -> bool: ...
    def screenRect(self, viewport: _render.ViewportInterface) -> QtCore.QRectF: ...
    def rect(self) -> QtCore.QRectF: ...


class Browser(QtWidgets.QTableView):

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def aboutToBeDestroyed(self) -> None: ...
    def contextChanged(self) -> None: ...
    def setModel(self, m: QtCore.QAbstractItemModel) -> None: ...
    def resetModel(self, model: QtCore.QAbstractItemModel, schema: _core_dp.TableSchema) -> None: ...
    def name(self) -> str: ...
    def setName(self, name: str) -> None: ...


class MapFeatureItem(Item):

    def __init__(self, layer: _render.TableLayer, originalFeature: typing.Any, feature: typing.Any, viewport: _render.MapViewport) -> None: ...

    @staticmethod
    def repairFeatures(features: typing.Any, table: typing.Any) -> typing.Any: ...
    def screenGeometry(self) -> _core_geometry.Geometry: ...
    def updateFeature(self, feature: typing.Any) -> None: ...
    def isEditable(self) -> bool: ...
    def geometry(self) -> _core_geometry.Geometry: ...
    def centroid(self) -> QtCore.QPointF: ...
    def equals(self, other: Item) -> bool: ...
    def canScale(self) -> bool: ...
    def canRotate(self) -> bool: ...
    def style(self) -> _render.Style: ...
    def updateStyle(self, style: _render.Style) -> None: ...
    def updateGeometry(self, geom: _core_geometry.Geometry) -> None: ...
    def transform(self, transform: QtGui.QTransform) -> None: ...
    def intersects(self, rect: QtCore.QRectF) -> bool: ...
    def screenRect(self, viewport: _render.ViewportInterface) -> QtCore.QRectF: ...
    def rect(self) -> QtCore.QRectF: ...
    def originalFeature(self) -> typing.Any: ...
    def updateOriginalGeometry(self, geom: _core_geometry.Geometry) -> None: ...
    def originalGeometry(self) -> _core_geometry.Geometry: ...
    def originalCentroid(self) -> QtCore.QPointF: ...
    def originalTransform(self, transform: QtGui.QTransform) -> None: ...
    def renditionAttributeName(self) -> str: ...
    def geometryAttributeName(self) -> str: ...
    def feature(self) -> typing.Any: ...
    def table(self) -> typing.Any: ...
    def layer(self) -> _render.TableLayer: ...


class ReportViewItem(Item):

    def __init__(self, reportItem: _render.ReportItem) -> None: ...

    def isEditable(self) -> bool: ...
    def geometry(self) -> _core_geometry.Geometry: ...
    def item(self) -> _render.ReportItem: ...
    def equals(self, other: Item) -> bool: ...
    def canScale(self) -> bool: ...
    def canRotate(self) -> bool: ...
    def style(self) -> _render.Style: ...
    def updateStyle(self, style: _render.Style) -> None: ...
    def updateGeometry(self, geom: _core_geometry.Geometry) -> None: ...
    def transform(self, transform: QtGui.QTransform) -> None: ...
    def intersects(self, r: QtCore.QRectF) -> bool: ...
    def rect(self) -> QtCore.QRectF: ...


class GeometryReportViewItem(ReportViewItem):

    def __init__(self, reportItem: _render.GeometryReportItem) -> None: ...

    def geometry(self) -> _core_geometry.Geometry: ...
    def centroid(self) -> QtCore.QPointF: ...
    def canScale(self) -> bool: ...
    def canRotate(self) -> bool: ...
    def style(self) -> _render.Style: ...
    def updateStyle(self, style: _render.Style) -> None: ...
    def updateGeometry(self, geom: _core_geometry.Geometry) -> None: ...
    def intersects(self, r: QtCore.QRectF) -> bool: ...
    def screenRect(self, viewport: _render.ViewportInterface) -> QtCore.QRectF: ...
    def rect(self) -> QtCore.QRectF: ...


class LegendViewItem(Item):

    def __init__(self, item: _render.LegendItemPosition, index: int) -> None: ...

    def indexGroup(self) -> int: ...
    def isEditable(self) -> bool: ...
    def geometry(self) -> _core_geometry.Geometry: ...
    def item(self) -> Item: ...
    def equals(self, other: Item) -> bool: ...
    def canScale(self) -> bool: ...
    def canRotate(self) -> bool: ...
    def style(self) -> _render.Style: ...
    def updateStyle(self, style: _render.Style) -> None: ...
    def updateGeometry(self, geom: _core_geometry.Geometry) -> None: ...
    def transform(self, transform: QtGui.QTransform) -> None: ...
    def intersects(self, r: QtCore.QRectF) -> bool: ...
    def rect(self) -> QtCore.QRectF: ...


class ItemSelectionModel(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def selectionStateChanged(self) -> None: ...
    def selectionChanged(self) -> None: ...
    def hasSelection(self) -> bool: ...
    def clearSelection(self) -> None: ...
    @typing.overload
    def deselect(self, items: typing.Any) -> None: ...
    @typing.overload
    def deselect(self, item: typing.Any) -> None: ...
    @typing.overload
    def addToSelection(self, items: typing.Any) -> None: ...
    @typing.overload
    def addToSelection(self, item: typing.Any) -> None: ...
    @typing.overload
    def setSelection(self, items: typing.Any) -> None: ...
    @typing.overload
    def setSelection(self, item: typing.Any) -> None: ...
    def canAddToSelection(self, item: typing.Any) -> bool: ...
    def targetItems(self) -> typing.Any: ...
    def selectedItems(self) -> typing.Any: ...


class ItemView(QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def snapStatusChanged(self, a0: bool) -> None: ...
    def snappedCoordinate(self, src: QtCore.QPoint, result: typing.Union[QtCore.QPointF, QtCore.QPoint], succ: bool) -> None: ...
    def selectionChanged(self) -> None: ...
    def canEditChanged(self) -> None: ...
    def aboutToBeDestroyed(self) -> None: ...
    def scaleWithCenter(self, zoomCoef: float, center: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setSnapMode(self, mode: bool) -> None: ...
    def isSnapMode(self) -> bool: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setDescription(self, index: int, value: str) -> None: ...
    def description(self, index: int) -> str: ...
    def setCurrentChangeIndex(self, value: int) -> None: ...
    def currentChangeIndex(self) -> int: ...
    def historySize(self) -> int: ...
    def itemsIntersectRect(self, rect: QtCore.QRectF) -> typing.Any: ...
    def deleteItems(self, items: typing.Any) -> None: ...
    def updateItems(self, items: typing.Any) -> None: ...
    @typing.overload
    def insertItems(self, gslist: typing.Any) -> None: ...
    @typing.overload
    def insertItems(self, items: typing.Any) -> None: ...
    def insertItem(self, gs: _render.GeometryWithStyle) -> None: ...
    def canEdit(self) -> bool: ...
    def itemsViewport(self) -> _render.ViewportInterface: ...
    def selectionModel(self) -> ItemSelectionModel: ...


class ScrollItemView(ItemView):

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...


class MapView(ScrollItemView):

    @typing.overload
    def __init__(self, map: _render.Map, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, map: _render.Map, mapRect: _core_dp.GeoRect, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def clearCosmeticLayer(self) -> None: ...
    def setPreviousViewport(self) -> None: ...
    def setCoordSystem(self, newCoordSys: typing.Any) -> None: ...
    def showSelection(self) -> None: ...
    def tableDataChanged(self) -> None: ...
    def coordSystemChanged(self) -> None: ...
    def unitsChanged(self) -> None: ...
    def editableLayerChanged(self) -> None: ...
    def sceneChanged(self, sceneRectWidth: float) -> None: ...
    def scaleChanged(self, scale: float) -> None: ...
    def zoomChanged(self, zoom: float) -> None: ...
    def mouseMoved(self, mousePosition: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setSnapMode(self, mode: bool) -> None: ...
    def isSnapMode(self) -> bool: ...
    def itemFromFeature(self, layer: _render.Layer, feature: typing.Any) -> Item: ...
    def setName(self, newName: str) -> None: ...
    def name(self) -> str: ...
    def selectionAsCursor(self) -> typing.Any: ...
    def setDrawOldImageScaled(self, val: bool) -> None: ...
    @staticmethod
    def backgroundBrush() -> QtGui.QBrush: ...
    def setDescription(self, index: int, value: str) -> None: ...
    def description(self, index: int) -> str: ...
    def setCurrentChangeIndex(self, value: int) -> None: ...
    def currentChangeIndex(self) -> int: ...
    def historySize(self) -> int: ...
    def rollBack(self, steps: int) -> None: ...
    def canEdit(self) -> bool: ...
    def numStandardLayers(self) -> int: ...
    def scaleViewport(self, vp: _render.MapViewport, adjust: bool = ...) -> _render.MapViewport: ...
    @typing.overload
    @staticmethod
    def validCoordinateUnits(cs: _cs.CoordSystem) -> typing.List[_cs.LinearUnit]: ...
    @typing.overload
    def validCoordinateUnits(self) -> typing.List[_cs.LinearUnit]: ...
    def hasVisibleSelection(self) -> bool: ...
    def hasSelection(self) -> bool: ...
    def hasTarget(self) -> bool: ...
    def allLayersWithTarget(self) -> typing.List[_render.TableLayer]: ...
    def allLayersWithSelection(self) -> typing.List[_render.TableLayer]: ...
    def allTableLayersWithoutCosmetic(self) -> typing.List[_render.TableLayer]: ...
    def allTableLayers(self) -> typing.Any: ...
    def legendManager(self) -> 'LegendManager': ...
    def addLegend(self, group: _render.LegendItemGroup) -> None: ...
    def followSelection(self) -> bool: ...
    def setFollowSelection(self, val: bool) -> None: ...
    def mapUnits(self) -> _cs.MapUnits: ...
    def setMapUnits(self, unit: _cs.MapUnits) -> None: ...
    def areaUnit(self) -> _cs.LinearUnit: ...
    def setAreaUnit(self, areaUnit: _cs.LinearUnit) -> None: ...
    def distanceUnit(self) -> _cs.LinearUnit: ...
    def setDistanceUnit(self, distanceUnit: _cs.LinearUnit) -> None: ...
    def coordinateUnit(self) -> _cs.LinearUnit: ...
    def setCoordinateUnit(self, coordinateUnit: _cs.LinearUnit) -> None: ...
    def setViewportByRect(self, rect: QtCore.QRectF) -> None: ...
    def scaleWithCenter(self, zoomCoef: float, center: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setViewport(self, viewport: _render.MapViewport, ignoreOldYCoeff: bool = ...) -> None: ...
    def cosmeticLayer(self) -> _render.TableLayer: ...
    def editableLayer(self) -> _render.Layer: ...
    def rootLayerGroup(self) -> _render.RootLayerGroup: ...
    def viewport(self) -> _render.MapViewport: ...
    def map(self) -> _render.Map: ...
    def showAll(self) -> None: ...
    def itemsViewport(self) -> _render.ViewportInterface: ...
    def selectionModel(self) -> ItemSelectionModel: ...


class AlignedItemView(ScrollItemView):

    class TypeGuideline(int): ...
    Vertical = ... # type: 'AlignedItemView.TypeGuideline'
    Horizontal = ... # type: 'AlignedItemView.TypeGuideline'
    None = ... # type: 'AlignedItemView.TypeGuideline'
    Horisontal = ... # type: 'AlignedItemView.TypeGuideline'

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setSnapToGuidelines(self, snapToGuidelines: bool) -> None: ...
    def setSnapToMesh(self, snapToMesh: bool) -> None: ...
    def setMeshSize(self, meshSize: float) -> None: ...
    def setShowMesh(self, showLayoutMesh: bool) -> None: ...
    def snapToGuidelinesEvent(self, snap: bool) -> None: ...
    def snapToMeshEvent(self, snap: bool) -> None: ...
    def showMeshEvent(self, show: bool) -> None: ...
    def guidelinesChanged(self) -> None: ...
    def setViewport(self, viewport: _render.Viewport) -> None: ...
    def viewport(self) -> _render.Viewport: ...
    def guidelineSelection(self) -> 'GuidelineSelection': ...
    def snapToGuidelines(self) -> bool: ...
    def snapToMesh(self) -> bool: ...
    def meshSize(self) -> float: ...
    def showMesh(self) -> bool: ...
    def replaceGuideline(self, tp: 'AlignedItemView.TypeGuideline', ind: int, v: float) -> None: ...
    def yGuidelines(self) -> typing.List[float]: ...
    def xGuidelines(self) -> typing.List[float]: ...
    def hasGuidelines(self) -> bool: ...
    def removeSelectedGuideline(self) -> bool: ...
    def clearGuidelines(self) -> None: ...
    def addGuidelines(self, tp: 'AlignedItemView.TypeGuideline', values: typing.Iterable[float]) -> None: ...
    def addGuideline(self, tp: 'AlignedItemView.TypeGuideline', v: float) -> None: ...


class GuidelineSelection(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'GuidelineSelection') -> None: ...

    def clear(self) -> None: ...
    def hasSelection(self) -> bool: ...
    def horisontalIndex(self) -> int: ...
    def horizontalIndex(self) -> int: ...
    def verticalIndex(self) -> int: ...
    def setSelect(self, tp: AlignedItemView.TypeGuideline, ind: int) -> None: ...


class ReportView(AlignedItemView):

    def __init__(self, report: _render.Report, gui: Gui, parent: typing.Optional[QtWidgets.QWidget] = ..., f: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def activateSelection(self) -> None: ...
    def selectionProperty(self) -> None: ...
    def onMapViewRemoved(self, mapView: MapView) -> None: ...
    def print(self) -> None: ...
    def printPreview(self) -> None: ...
    def currentWidgetChanged(self, widget: QtWidgets.QWidget) -> None: ...
    def dataChanged(self) -> None: ...
    def scaleChanged(self, scale: float) -> None: ...
    def currentCoordReport(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint], a1: _render.Unit) -> None: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...
    def setSnapMode(self, mode: bool) -> None: ...
    def isSnapMode(self) -> bool: ...
    def isDepends(self, widget: QtWidgets.QWidget) -> bool: ...
    def editedWidget(self) -> QtWidgets.QWidget: ...
    def setDescription(self, index: int, value: str) -> None: ...
    def description(self, index: int) -> str: ...
    def setCurrentChangeIndex(self, value: int) -> None: ...
    def currentChangeIndex(self) -> int: ...
    def historySize(self) -> int: ...
    def printer(self) -> QtPrintSupport.QPrinter: ...
    def setViewportByRect(self, rect: QtCore.QRectF) -> None: ...
    def rectWithOffset(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    def scaleWithCenter(self, zoomCoef: float, center: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def report(self) -> _render.Report: ...
    def setViewport(self, viewport: _render.Viewport) -> None: ...
    def viewport(self) -> _render.Viewport: ...
    def setScale(self, v: float) -> None: ...
    def scale(self) -> float: ...
    def setShowLayoutRuler(self, v: bool) -> None: ...
    def showLayoutRuler(self) -> bool: ...
    def setShowLayoutBorders(self, v: bool) -> None: ...
    def showLayoutBorders(self) -> bool: ...
    def insertItem(self, item: _render.ReportItem) -> None: ...
    def itemsViewport(self) -> _render.ViewportInterface: ...
    def selectionModel(self) -> ItemSelectionModel: ...


class LegendView(AlignedItemView):

    def currentCoord(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def scaleChanged(self, scale: float) -> None: ...
    def updateAndArrange(self, needArrange: bool = ...) -> None: ...
    def scale(self) -> float: ...
    def mapView(self) -> MapView: ...
    def setViewport(self, viewport: _render.Viewport) -> None: ...
    def viewport(self) -> _render.Viewport: ...
    def legendItemGroup(self) -> _render.LegendItemGroup: ...
    def updateItem(self, index: int, value: _render.LegendItem) -> None: ...
    def itemsViewport(self) -> _render.ViewportInterface: ...
    def selectionModel(self) -> ItemSelectionModel: ...


class LegendManager(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def itemRemoved(self, legendGroup: _render.LegendItemGroup) -> None: ...
    def legends(self) -> typing.Any: ...
    def count(self) -> int: ...
    def size(self) -> int: ...
    def remove(self, legendGroup: _render.LegendItemGroup) -> None: ...
    def append(self, legendGroup: _render.LegendItemGroup) -> None: ...


class RibbonId(sip.wrapper):

    class Tab(sip.wrapper):

        General = ... # type: str
        Legend = ... # type: str
        Map = ... # type: str
        Report = ... # type: str
        Table = ... # type: str

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'RibbonId.Tab') -> None: ...

        @staticmethod
        def defaultName(id: str) -> str: ...

    class Group(sip.wrapper):

        Align = ... # type: str
        Clipboard = ... # type: str
        Close = ... # type: str
        Commands = ... # type: str
        Create = ... # type: str
        CreatePoints = ... # type: str
        DrawTools = ... # type: str
        Edit = ... # type: str
        Elements = ... # type: str
        MapTools = ... # type: str
        New = ... # type: str
        Object = ... # type: str
        Operations = ... # type: str
        Order = ... # type: str
        Print = ... # type: str
        Query = ... # type: str
        Raster = ... # type: str
        Scale = ... # type: str
        Settings = ... # type: str
        Style = ... # type: str
        Table = ... # type: str
        Tools = ... # type: str
        View = ... # type: str

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'RibbonId.Group') -> None: ...

        @staticmethod
        def defaultName(id: str) -> str: ...

    class Category(sip.wrapper):

        Align = ... # type: str
        Browser = ... # type: str
        Clipboard = ... # type: str
        Close = ... # type: str
        Command = ... # type: str
        Create = ... # type: str
        Drawing = ... # type: str
        Element = ... # type: str
        Export = ... # type: str
        File = ... # type: str
        Help = ... # type: str
        Maptool = ... # type: str
        Mode = ... # type: str
        Newwindow = ... # type: str
        Object = ... # type: str
        Operation = ... # type: str
        Order = ... # type: str
        Query = ... # type: str
        Raster = ... # type: str
        Style = ... # type: str
        Viewport = ... # type: str

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'RibbonId.Category') -> None: ...

        @staticmethod
        def defaultName(id: str) -> str: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'RibbonId') -> None: ...


class ChooseCoordSystemDialog(QtWidgets.QDialog):

    def __init__(self, cs: _cs.CoordSystem, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def chosenCoordSystem(self) -> _cs.CoordSystem: ...


class StyleEditDialog(QtWidgets.QDialog):

    @typing.overload
    def __init__(self, geomStyleClass: _render.GeometryStyleClass, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, geom: _core_geometry.Geometry, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def style(self) -> _render.Style: ...
    def setStyle(self, style: _render.Style) -> None: ...


class GeometryInformationDialog(QtWidgets.QDialog):

    @staticmethod
    def build(mapProperties: _render.MapProperties, gui: Gui, item: Item, parent: typing.Optional[QtWidgets.QWidget] = ...) -> 'GeometryInformationDialog': ...
    def resultStyle(self) -> _render.Style: ...
    def resultGeometry(self) -> _core_geometry.Geometry: ...
    def isGeometryChanged(self) -> bool: ...


class UnitComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def currentUnit(self) -> _cs.LinearUnit: ...
    @typing.overload
    def setCurrentUnit(self, name: str) -> None: ...
    @typing.overload
    def setCurrentUnit(self, unit: _cs.LinearUnit) -> None: ...
    def setUnits(self, units: typing.Iterable[_cs.LinearUnit]) -> None: ...


class StyledButton(QtWidgets.QPushButton):

    @typing.overload
    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ..., scaled: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, cl: _render.GeometryStyleClass, style: _render.Style, parent: typing.Optional[QtWidgets.QWidget] = ..., scaled: bool = ...) -> None: ...

    def changedStyle(self, cl: _render.GeometryStyleClass, style: _render.Style) -> None: ...
    def styleChanged(self) -> None: ...
    def setPropertyReadOnly(self, readOnly: bool) -> None: ...
    def style(self) -> _render.Style: ...
    def setStyleParameters(self, cl: _render.GeometryStyleClass, style: _render.Style) -> None: ...


class CharsetSelector(QtWidgets.QWidget):

    @typing.overload
    def __init__(self, orientation: QtCore.Qt.Orientation = ..., parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, charset: str, orientation: QtCore.Qt.Orientation = ..., parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setCharset(self, value: str) -> None: ...
    def charset(self) -> str: ...


class RibbonExtension(_core_plugin.Extension):

    def __init__(self) -> None: ...

    def addAction(self, id: str, tabId: str, groupId: str, rowSpan: int = ..., columnSpan: int = ..., row: int = ..., column: int = ...) -> None: ...
    def addCategory(self, id: str, text: str) -> None: ...
    def addGroup(self, tabId: str, id: str, text: str) -> None: ...
    def addTab(self, id: str, text: str) -> None: ...


class Workspace(sip.wrapper):

    def __init__(self) -> None: ...

    def saveFile(self, filename: str) -> None: ...
    def loadFile(self, filename: str) -> None: ...
    def clear(self) -> None: ...


class WindowParameters(sip.wrapper):

    class State(int): ...
    Normal = ... # type: 'WindowParameters.State'
    Minimized = ... # type: 'WindowParameters.State'
    Maximized = ... # type: 'WindowParameters.State'

    geometry = ... # type: QtCore.QRectF
    state = ... # type: 'WindowParameters.State'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'WindowParameters') -> None: ...


class WorkspaceLoadContextInterface(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'WorkspaceLoadContextInterface') -> None: ...

    def showWidget(self, widget: QtWidgets.QWidget, params: WindowParameters) -> None: ...
    def createLegendView(self, mapView: MapView) -> LegendView: ...
    def createMapView(self, map: _render.Map) -> MapView: ...
    def createLayout(self) -> ReportView: ...
    def createBrowser(self, dataObject: _core_dp.DataObject) -> TableWindow: ...
    def openQuery(self, query: str, queryDialect: str) -> _core_dp.DataObject: ...
    def openFile(self, filename: str, providerId: str = ...) -> _core_dp.DataObject: ...
    def gui(self) -> Gui: ...


class WorkspaceSaveContextInterface(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'WorkspaceSaveContextInterface') -> None: ...

    def windowParameters(self, widget: QtWidgets.QMdiSubWindow) -> WindowParameters: ...
    def subWindows(self) -> typing.List[QtWidgets.QMdiSubWindow]: ...
    def maps(self) -> typing.List[MapView]: ...
    def queryDialect(self, queryTable: _core_sql.QueryTable) -> str: ...
    def queryText(self, queryTable: _core_sql.QueryTable) -> str: ...
    def layouts(self) -> typing.Any: ...
    def browsers(self) -> typing.Any: ...
    def gui(self) -> Gui: ...
    def dataCatalog(self) -> _core_dp.DataCatalogInterface: ...


class WorkspaceLoader(QtCore.QObject):

    def __init__(self, workspacefilename: str, context: WorkspaceLoadContextInterface, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def error(self, message: str) -> None: ...
    def warning(self, message: str) -> None: ...
    def load(self, workspace: Workspace) -> None: ...


class WorkspaceSaver(QtCore.QObject):

    def __init__(self, workspacefile: str, context: WorkspaceSaveContextInterface, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def error(self, message: str) -> None: ...
    def warning(self, message: str) -> None: ...
    def prepareForSaving(self, dobj: typing.Any) -> None: ...
    def save(self) -> Workspace: ...


class WorkspaceLoadContext(WorkspaceLoadContextInterface):

    @typing.overload
    def __init__(self, gui: Gui, dataCatalog: _core_dp.DataCatalogInterface) -> None: ...
    @typing.overload
    def __init__(self, a0: 'WorkspaceLoadContext') -> None: ...

    def createMapView(self, map: _render.Map) -> MapView: ...
    def showWidget(self, widget: QtWidgets.QWidget, params: WindowParameters) -> None: ...
    def createLegendView(self, mapView: MapView, group: _render.LegendItemGroup) -> LegendView: ...
    def createLayout(self) -> ReportView: ...
    def createBrowser(self, dataObject: _core_dp.DataObject) -> TableWindow: ...
    def openQuery(self, query: str, queryDialect: str) -> _core_dp.DataObject: ...
    def openFile(self, filename: str, providerId: str = ...) -> _core_dp.DataObject: ...
    def gui(self) -> Gui: ...


class WorkspaceSaveContext(WorkspaceSaveContextInterface):

    @typing.overload
    def __init__(self, gui: Gui, dataCatalog: _core_dp.DataCatalogInterface) -> None: ...
    @typing.overload
    def __init__(self, a0: 'WorkspaceSaveContext') -> None: ...

    def windowParameters(self, widget: QtWidgets.QMdiSubWindow) -> WindowParameters: ...
    def subWindows(self) -> typing.List[QtWidgets.QMdiSubWindow]: ...
    def maps(self) -> typing.List[MapView]: ...
    def queryDialect(self, queryTable: _core_sql.QueryTable) -> str: ...
    def queryText(self, queryTable: _core_sql.QueryTable) -> str: ...
    def layouts(self) -> typing.List[ReportView]: ...
    def browsers(self) -> typing.List[TableWindow]: ...
    def gui(self) -> Gui: ...
    def dataCatalog(self) -> _core_dp.DataCatalogInterface: ...


class WidgetManagerService(QtCore.QObject):

    def __init__(self) -> None: ...

    def activateWidget(self, widget: QtWidgets.QWidget) -> None: ...
    def removeWidget(self, widget: QtWidgets.QWidget) -> None: ...
    def connectWidgetChanged(self, type: type, context: QtCore.QObject, callback: typing.Any) -> None: ...
    def connectWidgetCountChanged(self, type: type, context: QtCore.QObject, callback: typing.Any) -> None: ...
    @typing.overload
    def allWidgets(self) -> typing.Any: ...
    @typing.overload
    def allWidgets(self, type: QtCore.QMetaObject) -> typing.Any: ...
    @typing.overload
    def count(self) -> int: ...
    @typing.overload
    def count(self, type: QtCore.QMetaObject) -> int: ...
    def activeWidget_hidden(self, type: QtCore.QMetaObject) -> QtWidgets.QWidget: ...
    def registerWidget(self, widget: QtWidgets.QWidget) -> None: ...


class Tool(QtCore.QObject):

    class EventPolicy(int): ...
    PassEvent = ... # type: 'Tool.EventPolicy'
    BlockEvent = ... # type: 'Tool.EventPolicy'

    def __init__(self, widget: QtWidgets.QWidget) -> None: ...

    def wheelEvent(self, a0: QtGui.QWheelEvent) -> 'Tool.EventPolicy': ...
    def keyReleaseEvent(self, a0: QtGui.QKeyEvent) -> 'Tool.EventPolicy': ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> 'Tool.EventPolicy': ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> 'Tool.EventPolicy': ...
    def mouseDoubleClickEvent(self, a0: QtGui.QMouseEvent) -> 'Tool.EventPolicy': ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> 'Tool.EventPolicy': ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> 'Tool.EventPolicy': ...
    def handleEvent_impl(self, event: QtCore.QEvent) -> 'Tool.EventPolicy': ...
    def widget(self) -> QtWidgets.QWidget: ...
    def setWidget(self, widget: QtWidgets.QWidget) -> None: ...
    def paintEvent(self, event: QtGui.QPaintEvent, painter: QtGui.QPainter) -> None: ...


class ChainTool(Tool):

    def __init__(self, widget: QtWidgets.QWidget) -> None: ...

    def addSubtool(self, tool: Tool) -> None: ...


class ItemViewPressReleaseHandler(ChainTool):

    class Option(int): ...
    NoOptions = ... # type: 'ItemViewPressReleaseHandler.Option'
    SupportSnap = ... # type: 'ItemViewPressReleaseHandler.Option'
    AutoScroll = ... # type: 'ItemViewPressReleaseHandler.Option'

    class Options(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['ItemViewPressReleaseHandler.Options', 'ItemViewPressReleaseHandler.Option']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'ItemViewPressReleaseHandler.Options') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'ItemViewPressReleaseHandler.Options': ...
        def __int__(self) -> int: ...

    def __init__(self, itemView: ItemView, options: typing.Union['ItemViewPressReleaseHandler.Options', 'ItemViewPressReleaseHandler.Option'] = ...) -> None: ...

    def snapStatusChanged(self) -> None: ...
    def mouseReleased(self, start: typing.Union[QtCore.QPointF, QtCore.QPoint], end: typing.Union[QtCore.QPointF, QtCore.QPoint], modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    def mouseMoved(self, start: typing.Union[QtCore.QPointF, QtCore.QPoint], current: typing.Union[QtCore.QPointF, QtCore.QPoint], modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    def mousePressed(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    def activeChanged(self, active: bool) -> None: ...
    def cancelled(self) -> None: ...
    def setButton(self, button: QtCore.Qt.MouseButton) -> None: ...
    def button(self) -> QtCore.Qt.MouseButton: ...
    def rect(self) -> QtCore.QRectF: ...
    def isActive(self) -> bool: ...


class ItemViewPolygonHandler(Tool):

    class Option(int): ...
    NoOptions = ... # type: 'ItemViewPolygonHandler.Option'
    SupportSnap = ... # type: 'ItemViewPolygonHandler.Option'
    AutoScroll = ... # type: 'ItemViewPolygonHandler.Option'
    SupportTrace = ... # type: 'ItemViewPolygonHandler.Option'

    class Options(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['ItemViewPolygonHandler.Options', ItemViewPressReleaseHandler.Option]) -> None: ...
        @typing.overload
        def __init__(self, a0: 'ItemViewPolygonHandler.Options') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'ItemViewPolygonHandler.Options': ...
        def __int__(self) -> int: ...

    def __init__(self, itemView: ItemView, options: typing.Union['ItemViewPolygonHandler.Options', ItemViewPressReleaseHandler.Option] = ...) -> None: ...

    def cancel(self) -> None: ...
    def snapStatusChanged(self) -> None: ...
    def activeChanged(self, active: bool) -> None: ...
    def polygonFinished(self) -> None: ...
    def polygonUpdated(self) -> None: ...
    def polygonStarted(self) -> None: ...
    def mouseMoved(self) -> None: ...
    def cancelled(self) -> None: ...
    def setButton(self, button: QtCore.Qt.MouseButton) -> None: ...
    def button(self) -> QtCore.Qt.MouseButtons: ...
    def modifiers(self) -> QtCore.Qt.KeyboardModifiers: ...
    def deviceCurrentPoint(self) -> QtCore.QPointF: ...
    def currentPoint(self) -> QtCore.QPointF: ...
    def isActive(self) -> bool: ...
    def devicePolygon(self) -> QtGui.QPolygonF: ...
    def polygon(self) -> QtGui.QPolygonF: ...


class NativeActionController(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def onToggled(self, checked: bool) -> None: ...
    def onTriggered(self) -> None: ...
    def updateChecked(self) -> None: ...
    def updateEnabled(self) -> None: ...
    def checkedChanged(self, val: bool) -> None: ...
    def enableChanged(self, val: bool) -> None: ...
    def setCheckable(self, val: bool) -> None: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def connectAction(self, action: QtWidgets.QAction) -> None: ...


class ActionControllerWithDependencies(NativeActionController, _core_plugin.HasDependencies):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setup(self) -> None: ...
    def ready(self) -> None: ...


class NativeActionControllerExtension(NativeActionExtension):

    def __init__(self, controller: NativeActionController, actionId: str, ribbonInfo: RibbonActionInfo = ..., parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def createAction_impl(self, parent: QtCore.QObject) -> QtWidgets.QAction: ...
    def actionController(self) -> NativeActionController: ...
    def customizeAction(self, action: QtWidgets.QAction) -> None: ...


class ActionManager(QtCore.QObject):

    def __init__(self) -> None: ...

    def actionByName(self, actionObjectName: str) -> QtWidgets.QAction: ...
    def actions(self) -> typing.List[QtWidgets.QAction]: ...


class ToolFactory(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def createTool_impl(self, widget: QtWidgets.QWidget) -> Tool: ...
    def createTool(self, widget: QtWidgets.QWidget) -> typing.Any: ...


class NativeToolController(NativeActionController):

    def __init__(self, factory: ToolFactory, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def toolToggled(self, checked: bool) -> None: ...
    def toolFactory(self) -> ToolFactory: ...


class NativeToolControllerExtension(NativeActionControllerExtension):

    def __init__(self, controller: NativeToolController, actionId: str, ribbonInfo: RibbonActionInfo = ..., parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def createAction_impl(self, parent: QtCore.QObject) -> QtWidgets.QAction: ...
    def toolController(self) -> NativeToolController: ...


class ToolControllerTemplateBase(NativeToolController, _core_plugin.HasDependencies):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setup(self) -> None: ...
    def createTool(self, widget: QtWidgets.QWidget) -> Tool: ...
    def widgetManagerService(self) -> WidgetManagerService: ...
    def ready(self) -> None: ...


class ToolContollerTemplateUniversal(ToolControllerTemplateBase):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def createTool(self, widget: ItemView) -> Tool: ...
    def isEnabled(self, a0: ItemView) -> bool: ...
    def setup(self) -> None: ...
    def activeWidget(self) -> ItemView: ...


class NativeDrawingToolController(ToolContollerTemplateUniversal):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def styleService(self) -> _render.StyleService: ...
    def guiSettingsManager(self) -> _core.SettingsManager: ...


class ToolControllerChecker(sip.wrapper):

    def isChecked(self, a0: NativeToolController) -> bool: ...


class ToolControllerManager(QtCore.QObject, ToolControllerChecker):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def activeControllerChanged(self) -> None: ...
    def isChecked(self, tc: NativeToolController) -> bool: ...
    def registerExtension(self, ext: NativeToolControllerExtension) -> None: ...
    def setDefaultToolController(self, toolController: NativeToolController) -> None: ...
    def defaultToolController(self) -> NativeToolController: ...
    def setActiveToolController(self, tool: NativeToolController) -> None: ...
    def activeToolController(self) -> NativeToolController: ...
    def addToolController(self, toolController: NativeToolController) -> None: ...


class SnapTool(Tool):

    def __init__(self, view: ItemView) -> None: ...

    def handleEvent_impl(self, event: QtCore.QEvent) -> Tool.EventPolicy: ...
    def isSnapped(self) -> bool: ...
    def scenePoint(self) -> QtCore.QPointF: ...
    def snapPoint(self) -> QtCore.QPointF: ...


class SnapHandler(Tool):

    def __init__(self, widget: ItemView, currentPointSource: 'PointSource') -> None: ...

    def snappedCoordinate(self, src: QtCore.QPoint, result: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def snapStatusChanged(self) -> None: ...
    def isSnapped(self) -> bool: ...
    def snapPoint(self) -> QtCore.QPointF: ...
    def itemViewPoint(self) -> 'ItemViewPointSource': ...
    def itemView(self) -> ItemView: ...


class PointSource(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def toDeviceTransformChanged(self) -> None: ...
    def currentPointChanged(self) -> None: ...
    def currentDevicePoint(self) -> QtCore.QPointF: ...
    @typing.overload
    def mapRectToDevice(self, val: QtCore.QRect) -> QtCore.QRect: ...
    @typing.overload
    def mapRectToDevice(self, val: QtCore.QRectF) -> QtCore.QRectF: ...
    @typing.overload
    def mapToDevice(self, val: QtCore.QPoint) -> QtCore.QPoint: ...
    @typing.overload
    def mapToDevice(self, val: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    def toDeviceTransform(self) -> QtGui.QTransform: ...
    def currentPoint(self) -> QtCore.QPointF: ...


class ItemViewPointSource(PointSource):

    def __init__(self, itemView: ItemView, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def updateCurrentPointFromDevice(self, value: QtCore.QPoint) -> None: ...
    def updateCurrentPoint(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def toDeviceTransform(self) -> QtGui.QTransform: ...
    def currentPoint(self) -> QtCore.QPointF: ...
    def itemView(self) -> ItemView: ...


class DeviceToSceneHandler(Tool):

    def __init__(self, view: ItemView) -> None: ...

    def handleEvent_impl(self, event: QtCore.QEvent) -> Tool.EventPolicy: ...
    def itemViewPoint(self) -> ItemViewPointSource: ...


class ProgressSpec(sip.wrapper):

    class ProgressFlag(int): ...
    OnlyProgress = ... # type: 'ProgressSpec.ProgressFlag'
    Cancelable = ... # type: 'ProgressSpec.ProgressFlag'
    NoDelay = ... # type: 'ProgressSpec.ProgressFlag'
    ShowByRequest = ... # type: 'ProgressSpec.ProgressFlag'

    class ProgressFlags(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['ProgressSpec.ProgressFlags', 'ProgressSpec.ProgressFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'ProgressSpec.ProgressFlags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'ProgressSpec.ProgressFlags': ...
        def __int__(self) -> int: ...

    flags = ... # type: typing.Union['ProgressSpec.ProgressFlags', 'ProgressSpec.ProgressFlag']
    message = ... # type: str
    parent = ... # type: QtWidgets.QWidget
    windowTitle = ... # type: str

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str, parent: typing.Optional[QtWidgets.QWidget] = ..., flags: typing.Union['ProgressSpec.ProgressFlags', 'ProgressSpec.ProgressFlag'] = ..., windowTitle: str = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ProgressSpec') -> None: ...


def generateProgressDialog(handler: typing.Any, spec: ProgressSpec) -> QtWidgets.QDialog: ...
def downListSelectionForWidget(wi: QtWidgets.QListWidget) -> None: ...
def upListSelectionForWidget(wi: QtWidgets.QListWidget) -> None: ...
def exportToImage(mapView: MapView, width: int = ..., height: int = ..., dpi: int = ...) -> QtGui.QImage: ...
