from typing import Dict, NamedTuple

from axipy.da import GeometryType

SearchPatterns = Dict[str, bool]
SearchGeometries = Dict[GeometryType, bool]
SearchGroupPatterns = Dict[str, SearchPatterns]
FeatureId = int


class SearchSettings(NamedTuple):
    '''
    Все параметры для поиска геометрии по стилю. 

    geometries - список геометрий, стили которых будут рассматриваться для поиска

    groups - это словарь паттернов поиска. Например, для поиска по коллекциям
    в этом словаре могут быть настройки для полигона, для точек и т.д.
    '''
    groups: Dict[str, SearchPatterns] = {}
    geometries: SearchGeometries = {}

    def is_valid(self):
        return any(ok for _, ok in self.geometries.items())


class NamedSearchPatterns(NamedTuple):
    '''
    Для поиска по стилю коллекции названия свойств могут повторяться и 
    просто словаря недостаточно
    '''
    patterns: Dict[str, bool] = []
    name: str = ''
