from .data_provider import DataProvider, DataObject
from .source import Source, Destination, Schema
from typing import List, Optional


class WmtsSource(Source):
    pass


class WmtsDataProvider(DataProvider):
    """Провайдер для тайловых серверов.

    Note:
        Ссылку на провайдер можно получить через глобальную переменную :attr:`axipy.da.provider_manager.wmts`.
    """
    _identifier = 'WmtsDataProvider'

    def get_source(self, capabilitiesUrl: str, dataObject: str, alias: str = None) -> Source:
        """Создает источник данных.

        Args:
          capabilitiesUrl: URL запроса метаданных.
          dataObject: Наименование слоя.
        """
        return WmtsSource(
            Source._provider(self.id),
            Source._alias(alias),            
            {
                'src': capabilitiesUrl,
                'dataobject' : dataObject
            }
        )

    def open(self, capabilitiesUrl: str, dataObject: str, alias: str = None) -> DataObject:
        """Открывает объект данных.

        Args:
          capabilitiesUrl: URL запроса метаданных.
          dataObject: Наименование слоя.
          alias: Псевдоним для открываемого источника данных.
        """
        return self.get_source(capabilitiesUrl, dataObject, alias).open()

    def get_destination(self):
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError
    
    def create_open(self):
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError
