from .my_tool import MyTool
from axipy import AxiomaPlugin, Position

# Переопредаляем плагин
class Plugin(AxiomaPlugin):
    def load(self):
        # Если нет необходимости передавать в конструктор MyTool параметры, можно просто указать имя класса: on_click=MyTool
        self.__tool = self.create_tool('Пример инструмента',
                icon='://icons/share/32px/run3.png', on_click=lambda: MyTool('Выберите номер атрибута:'))

        position = Position('Основные', 'Команды')
        position.add(self.__tool)
        self.__tool.action.setToolTip('Щелкните мышью на интересующем объекте.\nПравая кнопка мыши - выбор атрибута.')

    def unload(self):
        self.__tool.remove()

