from axipy import *
from PySide2.QtWidgets import QDialog, QPushButton, QLineEdit, QVBoxLayout, QFileDialog
from PySide2.QtUiTools import QUiLoader
import os


class MyDialog(QDialog):
    def __init__(self , parent):
        super().__init__(parent)
        # Подробнее по созданию *.ui файла см. документацию. Раздел "Пользовательский интерфейс"
        uiFile = os.path.join(os.path.dirname(__file__), "mydialog.ui")
        self.ui = QUiLoader().load(uiFile, parent)
        # Реакция на нажатие кнопки
        self.ui.btnCallback.clicked.connect(self.button_clicked)
        self.__catched = False
        self.button_clicked()
        self.ui.pushButtonOpen.clicked.connect(self.button_clicked_open_file)

    def button_clicked_open_file(self):
        lastPath = Settings.value(Settings.LastOpenPath)
        file_name, _ = QFileDialog.getOpenFileName(self, 'Выберите файл', lastPath, 'Файлы TAB (*.tab);;Все файлы (*.*)')
        if file_name:
            table = provider_manager.openfile(file_name)
            layer = Layer.create(table)
            map_ = Map([ layer ])
            map_view = view_manager.create_mapview(map_)

    def __log_msg(self, msg):
        self.ui.textEdit.append(msg)

    # Перенаправим метод show на self.ui
    def show(self):
        return self.ui.show()

    # Отслеживает открытие и закрытие данных в Аксиоме
    # При утопленной кнопке self.ui.btnCallback режим включен. Отжатой - выключен.
    def button_clicked(self) :
        if not self.__catched:
            data_manager.added[str].connect(lambda n: self.__log_msg(f'Таблица "{n}" добавлена в каталог'))
            data_manager.removed[str].connect(lambda n: self.__log_msg(f'Таблица "{n}" удалена из каталога'))
        else:
            data_manager.added[str].disconnect()
            data_manager.removed[str].disconnect()
        self.__catched = not self.__catched


