"""Package for parsing axipy plugins' metadata.

Does not depend on axipy itself.
"""

import os
import os.path
import pathlib
from .parser import (Metadata, LocationPath, IParser, MANIFEST_FILE_NAME)
from .package_parser import PackageParser, ARCHIVE_EXTENSION
from .folder_parser import FolderParser


__all__ = [
    'read_metadata_params',
    'read_metadata',
    'install',
    'MANIFEST_FILE_NAME',
    'ARCHIVE_EXTENSION',
    'PackageParser',
    'FolderParser',
]


def read_metadata_params(plugin_path: LocationPath) -> dict:
    supports = lambda parser: parser.supports(plugin_path)
    known_parsers = [PackageParser, FolderParser]
    supported_parsers = filter(supports, known_parsers)
    supported_parser = next(supported_parsers, None)
    if supported_parser is None:
        raise RuntimeError(f'No known parser supports {plugin_path}')
    parser = supported_parser.create()
    return parser.parse(plugin_path)


def read_metadata(plugin_path: str) -> str:
    import json
    params = read_metadata_params(plugin_path)
    return json.dumps(params)


def install(package_file, destination):
    PackageParser.install(package_file, pathlib.Path(destination))
