from PySide2.QtWidgets import QDockWidget, QWidget, QPushButton, QLineEdit, QVBoxLayout
from PySide2.QtCore import Qt
from PySide2.QtGui import QIcon
from axipy import AxiomaPlugin, Position, tr
from axipy.app import mainwindow, Notifications

class Plugin(AxiomaPlugin):
    def load(self):
        self.__action = self.create_action(tr('Пример действия'),
               icon=self.local_file('ui', 'run.png'), on_click=self.add_dock_panel, doc_file='index.html')
        position = Position(tr('Основные'), tr('Команды'))
        position.add(self.__action, size=2)
        self.__separator = self.create_separator()
        position.add(self.__separator)
        self.__action_custom = self.create_action(tr('Диалог'),
                icon=self.local_file('ui', 'dialog.png'), on_click=self.show_custom)
        position.add(self.__action_custom, size=2)
        self.dock = None

    def unload(self):
        # Выгрузка ресурсов
        self.__action.remove()
        self.__separator.remove()
        self.__action_custom.remove()
        if self.dock != None:
            mainwindow.remove_dock_widget(self.dock)
            self.dock = None

    def add_dock_panel(self):
        # Добавление пользовательской панели
        if self.dock == None:
            self.dock =  QDockWidget(tr('Пример панели'))
            widget = QWidget()
            button = QPushButton("Кнопка", widget)
            button.clicked.connect(lambda: print('Реакция на кнопку'))
            edit = QLineEdit("текст")
            layout = QVBoxLayout()
            layout.addWidget(button)
            layout.addWidget(edit)
            layout.addStretch()
            widget.setLayout(layout)
            self.dock.setWidget(widget)
            mainwindow.add_dock_widget(self.dock, Qt.RightDockWidgetArea, QIcon("://icons/share/32px/logo.png"))
            edit.setFocus()
            # Уведомление
            Notifications.push(tr('Информация'), tr('Панель добавлена'), Notifications.Information)

    def show_custom(self):
        from .helper import create_dialog
        ui_file = self.local_file('ui', 'CustomDialog.ui')
        dialog = create_dialog(ui_file)
        def print_func(): print(dialog.textEdit.toPlainText())
        dialog.btnPrint.clicked.connect(print_func)
        dialog.exec()
