"""Модуль отрисовки.

Данный модуль содержит инструменты, предназначенные для отрисовки
геопространственных и прочих данных.
"""

from axipy.cpp_render import Render

from .context import Context
from .layer import Layer, VectorLayer, RasterLayer, ListThematic, ThematicLayer, CosmeticLayer
from .label import (Label, LabelOverlap, LabelBackgroundType, LabelLinePosition, LabelAreaPosition,
                    LabelAreaInterior, LabelLayout, LabelLayoutPosition, LabelHorizontalAlign)
from .thematic_layer import (RangeThematicLayer, create_range,
                             AllocationThematic,
                             OrientationThematic,
                             StyledByIndexThematic,
                             PieThematicLayer, create_pie,
                             BarThematicLayer,
                             SymbolThematicLayer,
                             IndividualThematicLayer,
                             DensityThematicLayer, 
                             ReallocateThematicColor)
from .map import Map, ListLayers
from .report import (Report, ReportItem,
                     GeometryReportItem, MapReportItem, RasterReportItem, TableReportItem,
                     LegendReportItem, ScaleBarReportItem, ReportItems)
from .legend import Legend, LegendItem, ListLegendItems
#from .layer_properties import *


# fix sphinx inheritance and typehints
from axipy._util import fixup_module_metadata
fixup_module_metadata(__name__, globals())
del fixup_module_metadata
