from .data_provider import DataProvider, DataObject
from .source import Source, Destination, Schema
from typing import List, Optional


class RestSource(Source):
    pass


class RestDataProvider(DataProvider):
    """Провайдер для ArcGIS REST.

    Note:
        Ссылку на провайдер можно получить через глобальную переменную :attr:`axipy.da.provider_manager.rest`.
    """
    _identifier = 'RestDataProvider'

    def get_source(self, url: str, fmt: str = 'png32', imageSR: str = 'imageSR', size: str = '1024*1024',
                   dpi: int = 96, transparent: str = 'true', layers: str = '', alias: str = None) -> Source:
        """Создает источник данных.

        Args:
          url: Базовый URL.
          fmt: Формат выходного растра.
          imageSR: Код EPSG для выходного растра.
          size: Размер тайлов.
          dpi: DPI.
          transparent: Прозрачность выходного растра.
          layers: Перечень слоев.
        """
        return RestSource(
            Source._provider(self.id),
            Source._alias(alias),
            {
                'src': url,
                'format': fmt,
                'imageSR' : imageSR,
                'size' : size,
                'dpi' : dpi,
                'transparent' : transparent,
                'layers' : layers
            }
        )

    def open(self, url: str, fmt: str = 'png32', imageSR: str = 'imageSR', size: str = '1024*1024',
                   dpi: int = 96, transparent: str = 'true', layers: str = '', alias: str = None) -> DataObject:
        """Открывает объект данных.

        Args:
          url: Базовый URL.
          fmt: Формат выходного растра.
          imageSR: Код EPSG для выходного растра.
          size: Размер тайлов.
          dpi: DPI.
          transparent: Прозрачность выходного растра.
          layers: Перечень слоев.
          alias: Псевдоним для открываемой таблицы.
        """
        return self.get_source(url, fmt, imageSR, size, dpi, transparent, layers, alias).open()

    def get_destination(self):
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError
    
    def create_open(self):
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError
