import axioma_dynload._engine
import axioma.core.dp
from axioma.core.dp import AttributeDefinition
import PyQt5.QtCore

def simpleAttribute(field):
    t = PyQt5.QtCore.QMetaType.Type(field.type())
    return axioma.core.dp.SimpleAttributeDefinition(field.name(), t, field.length(), field.precision())

def createFeature(schema, record, acceptableConversionError = AttributeDefinition.Norm_CouldNotConvert):
    feature = axioma.core.dp.Feature.createFeature(schema)
    for i in range(schema.numAttributes()):
        val = record.value(i)
        val = schema.at(i).normalizeValue(val, acceptableConversionError)
        feature.setAttribute(i, val)
    return feature;

Engine = axioma_dynload._engine.Engine.load(axioma.app.core)
engineDatabase = Engine.engineDatabase
translateSql = Engine.translate
