import os
from PySide2.QtWidgets import QDialog, QDialogButtonBox, QFileDialog
from PySide2.QtGui import QIcon
from PySide2.QtUiTools import QUiLoader
from PySide2.QtCore import Qt

from .CoordinateProcess import *
from axipy import *


class TypeResultAction(enum.Enum):
    current_layer = 0
    new_table = 1


class LoadPointsDialog(QDialog):

    NoneValue = ''
    __ResultAction = TypeResultAction.current_layer

    def __init__(self, iface, coordsystem) -> None:
        super().__init__(iface.window())
        self.__tr = iface.tr
        self._coordsystem = coordsystem
        uiFile = os.path.join(os.path.dirname(__file__), "LoadPointsDialog.ui")
        self.__ui = QUiLoader().load(uiFile, self)
        self.__load_ui()
        self.__ui.setParent(view_manager.global_parent)
        self.__update_button_text(coordsystem)
        self.__ui.setWindowFlags(self.windowFlags() & ~Qt.WindowContextHelpButtonHint)
        self.__out_filename = ''

    def __load_ui(self):
        for t in data_manager.tables:
            if len(t.schema) >= 2:
                self.__ui.cbTables.addItem(t.name)
        self.__ui.cbTables.currentIndexChanged.connect(self.__tablesIndexChanged)
        self.__ui.cbTypeData.currentIndexChanged.connect(self.__typeDataIndexChanged)
        self.__ui.pushButtonSK.clicked.connect(self.__chooseCoordSystem)
        if self.__ui.cbTables.count():
            self.__tablesIndexChanged(0)
        self.__typeDataIndexChanged(0)
        self.__ui.pbExport.clicked.connect(self.__export)
        self.__ui.pbExport.setEnabled( self.__ui.cbTables.count())
        self.__ui.pbInsert.clicked.connect(self.__insert)
        can_insert = isinstance(view_manager.active, MapView) and view_manager.active.map.editable_layer is not None
        self.__ResultAction = TypeResultAction.current_layer if can_insert else TypeResultAction.new_table
        self.__ui.pbInsert.setEnabled(can_insert and self.__ui.cbTables.count())
        self.__ui.pbClose.clicked.connect(self.__close)
    
    def __export(self):
        fn = QFileDialog.getSaveFileName(self, self.__tr('Имя выходного файла'), filter = "MapInfo TAB (*.tab);;")
        self.__ui.close()
        if fn is not None or len(fn[0]) > 0:
            self.__out_filename = fn[0]
            self.__ui.setResult(QDialog.Accepted)
            self.__ResultAction = TypeResultAction.new_table
        else:
            self.__ui.setResult(QDialog.Rejected)

    def __insert(self):
        self.__ui.close()
        self.__ResultAction = TypeResultAction.current_layer
        self.__ui.setResult(QDialog.Accepted)

    def __close(self):
        self.__ui.close()
        self.__ui.setResult(QDialog.Rejected)
    
    def __update_button_text(self, coordsystem):
        if coordsystem is not None:
            self.__ui.pushButtonSK.setText(coordsystem.description)

    def __chooseCoordSystem(self):
        dialog = ChooseCoordSystemDialog(self._coordsystem)
        if dialog.exec() == QDialog.Accepted:
            self._coordsystem = dialog.chosenCoordSystem()
            self.__update_button_text(self._coordsystem)


    def __typeDataIndexChanged(self, idx):
        if idx == 0:
            self.__ui.lblValue1.setText(self.__tr('Х координата:'))
            self.__ui.lblValue2.setText(self.__tr('Y координата:'))
        else:
            self.__ui.lblValue1.setText(self.__tr('Расстояние (м.):'))
            self.__ui.lblValue2.setText(self.__tr('Азимут (град.):'))

    def __set_items(self, cb, attrs, attr):
        cb.clear()
        cb.addItems(attrs)
        cb.setCurrentText(attr)

    def __tablesIndexChanged(self, idx):
        t = self.__result_table()
        if t is not None:
            attrs = t.schema.attribute_names
            self.__set_items(self.__ui.cbGeometryId, attrs, CoordinateProcess.IdFeatureField)
            self.__set_items(self.__ui.cbGeometryPartId, attrs, CoordinateProcess.IdGeometryField)
            self.__ui.cbGeometryPartId.insertItem(0, self.NoneValue)
            self.__set_items(self.__ui.cbPointNumber, attrs, CoordinateProcess.IdPointField)
            self.__ui.cbPointNumber.insertItem(0, self.NoneValue)
            self.__set_items(self.__ui.cbValue1, attrs, CoordinateProcess.ValueFirstField)
            self.__set_items(self.__ui.cbValue2, attrs, CoordinateProcess.ValueSecondField)

    def result_sql_text(self):
        # Результирующий SQL запрос
        def __ct( cb):
            return cb.currentText()
        
        sel = f'{__ct(self.__ui.cbGeometryId)}'
        order = sel
        if self.__ui.cbGeometryPartId.currentText() != self.NoneValue:
            p_id = __ct(self.__ui.cbGeometryPartId)
            sel = sel + f', {p_id}'
            order = order + f', abs({p_id})'
        if self.__ui.cbPointNumber.currentText() != self.NoneValue:
            p_num = f', {__ct(self.__ui.cbPointNumber)}'
            sel = sel + p_num
            order = order + p_num
        sel = sel + f', {__ct(self.__ui.cbValue1)}, {__ct(self.__ui.cbValue2)}'
        return f'select {sel} from {self.__result_table().name} order by {order}'

    def result_coordsystem(self):
        return self._coordsystem

    def __result_table(self):
        # Исходная таблица
        return data_manager.find(self.__ui.cbTables.currentText())

    def result_type_coordinates_index(self):
        return self.__ui.cbTypeData.currentIndex()

    def result_is_closed_polygon(self):
        return self.__ui.cbClosedAsPolygon.checkState() == Qt.Checked

    def result_type_action(self):
        return self.__ResultAction

    def result_filename(self):
        return self.__out_filename

    def result_has_part_number(self):
        return self.__ui.cbGeometryPartId.currentText() != self.NoneValue

    def result_has_point_number(self):
        return self.__ui.cbPointNumber.currentText() != self.NoneValue

    def exec(self):
        return self.__ui.exec()
        
