"""Helper functions."""


from functools import partial


class InitOnce:
    """Runs function once and then keeps returning the result."""

    def __init__(self, f):
        self.f = f
        self.result = None

    def __call__(self, *args, **kwargs):
        if self.result is None:
            self.result = self.f(*args, **kwargs)
        return self.result

    def __get__(self, instance, owner):
        return partial(self, instance)


def axi_deprecated(alternative):
  import logging
  from functools import wraps
  def factory(func):
      @wraps(func)
      def new_func(*args, **kwargs):
          logging.warning(f"Method or property '{func.__name__}' is deprecated. Instead use '{alternative}'.")
          return func(*args, **kwargs)
      return new_func
  return factory
