#!/usr/bin/python3
# -*- coding: utf-8 -*-

# Импорт
from axioma.cs import *
from axioma.render import *

from PyQt5.QtCore import  *
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *

import threading

'''
Пример отрисовки слоя в растр и отображение его в диалоговом окне.
Перед запуском скрипта необходимо открыть карту со слоем world.
'''

class MapDialog(QDialog):
    
    def __init__(self, parent, layer):
        QDialog.__init__(self, parent)
        self.layer = layer
        self.image = QImage()
        self.lock = threading.Lock()
        self.initUI()

    def initUI(self):      
        self.setGeometry(200, 200, 1200, 600)
        self.setWindowTitle(self.tr("Отрисовка карты со слоем World"))
    
    def renderMap(self): # Рисование карты
        try:
            br = self.layer.boundingRect() # rect слоя 
            imRect = QRect (0, 0, self.width(), self.width() * br.height() / br.width()) # размер растра
            self.image = QImage(imRect.size(), QImage.Format_ARGB32_Premultiplied) # Сам растр, куда будем рисовать
            self.image.fill(Qt.white)
            painter = QPainter(self.image)
            sceneRect = QRectF(br.left(), br.top(), br.width(), br.height())
            viewport = MapViewport(QRectF(imRect), sceneRect, self.layer.coordSystem())
            context = MapContext (painter,viewport) # контекст, куда рисуем
            #self.layer.render(context) # Если мы хотим просто отрисовать существующий слой, не создавая карты (Вместо следующих строчек с созданием карты)
            
            map = Map() # временная карта
            renderer = ConcurrentMapRenderer() # объект, занимающийся многопоточной отрисовкой
            lay = axioma.app.render.createLayerForDataObject(self.layer.table()) # временный слой
            
            props = lay.featureLayerProperties() #Свойства слоя
            
            #Если мы хотим управлять видимостью
            #constraints = props.visibilityConstraints() # Ограничение по видимости
            #print(constraints.zoomMin(), constraints.zoomMax()) # Текущие значения
            #constraints.setZoomMax(2) #
            #constraints.setEnabled(True) # Включаем
            #props.setVisibilityConstraints(constraints) # Подменяем
            
            props.setLabelingAttributeName(self.tr("Страна"))   # устанавливаем выражение для метки
            
            # Сделаем так, чтобы метки не перекрывали друг друга
            policy = props.labelPlacementPolicy()
            policy.labelingType = LabelPlacementPolicy.DisallowOverlap
            props.setLabelPlacementPolicy(policy)
            
            textRenderer = props.textRenderer() # Стиль текста. Поменяем цвет.
            textRenderer.setColor(Qt.gray)
            props.setTextRenderer(textRenderer)
            
            props.setShowLabels(True) # Показ меток
            props.setCentroidsVisible(True) # Показ центроидов
            lay.setProperties(props) # Устанавливаем новые свойства слоя
            
            map.rootLayerGroup().append(lay) # добавляем слой в карту

            renderer.blockingRender(map, context) # отрисовка
            #self.image.save("/tmp/out.png") # Если мы хотим сохранить как растр в файловой системе
            
        except Exception as ex:
            print(ex)

    def paintEvent(self, event): # событие по перерисовке окна
        painter = QPainter(self)
        painter.fillRect(event.rect(), Qt.lightGray)
        if not self.image.isNull():
            painter.drawImage(0,0, self.image)

    def resizeEvent(self, event):
        try:
            self.lock.acquire()
            self.renderMap()
        finally:
            self.lock.release()

# Создаем диалоговое окно
for mapview in axioma.app.mainWindow.mapViewManager().mapViews():
    layer = mapview.rootLayerGroup().findChildByName("world")
    if layer is not None:
        dlg = MapDialog(axioma.app.mainWindow, layer)
        dlg.exec()
