#!/usr/bin/python3
# -*- coding: utf-8 -*-

from axioma.cs import CoordSysFactory, CoordSystem
from axioma.core.geometry import *
from axioma.mapinfo import Rectangle, RoundRectangle, Ellipse, Arc, Text

from PyQt5.QtCore import QPointF, QLineF, QRectF, QObject
from PyQt5.QtGui import QPolygonF

from PyQt5.QtGui import QGuiApplication
import sys

'''
Пример работы с объектами типа геометрия
'''

a = QGuiApplication(sys.argv)
core = axioma.core.Core()
core.initialize()


# КС
csll = CoordSysFactory.defaultCoordSysFactory().createFromEpsg(4326)
csm = CoordSysFactory.defaultCoordSysFactory().createFromEpsg(41001)

# Вывод данных о координатной системе
def printProjection():
    print ("---CoordSystem---")
    if csll is not None:
       print (csll.prjStr())
    if csm is not None:
       print (csm.prjStr())

# Создание объекта типа точка
def createPoint():
    print ("---Point---")
    p = Point(csll, 20,40);
    print ("Point %.1f %.1f %s" % (p.pos().x(), p.pos().y(), p.coordSystem().prjStr()))
    pm = p.transformed(csm)
    p_ = p.translated(10,10)
    if p_ is not None:
       print ("Translated point %.1f %.1f %s" % (p_.pos().x(), p_.pos().y(), p_.coordSystem().prjStr()))
    print ("CS of new point is: %s" % (pm.coordSystem().prjStr()))
    print ("Point wkt: %s" % p.exportToWkt())
    wkb = p.exportToWkb()
    pp = Point(csll, 0, 0)
    pp.initCoordsFromWkb(wkb)
    print('Point coords from wkb data:', pp.exportToWkt())
    return p

# Возвращает массив точек
def createQPolygon():
    poly = QPolygonF();
    poly << QPointF(1,1) << QPointF(1,10) << QPointF(10,10) << QPointF(10,1) << QPointF(1,1)
    return poly

# Создание геометрии типа полигон
def createPolygon():
    print ("---Polygon---")
    poly = createQPolygon();
    polygon = Polygon(csm, poly)
    print("area=%f" % polygon.area(CartesianAreaCalculator()))
    print("perimeter=%f" % polygon.perimeter(CartesianDistanceCalculator()))
    print ("Points of polygon:")
    for p in poly:
       print("%f %f" % (p.x(), p.y()))
    print ("polygon wkt: %s" % polygon.exportToWkt())
    return polygon

# Создание внешнего кольца полигона
def createLinearRing():
    ring = LinearRing(csm, createQPolygon())
    return ring

# Создание внутреннего кольца полигона
def createLinearRingInterior():
    poly = QPolygonF();
    poly << QPointF(4,4) << QPointF(4,6) << QPointF(6,6) << QPointF(6,4) << QPointF(4,4)
    ring = LinearRing(csm, poly)
    return ring

# Создание полигона по его внешнему кольцу
def createPolygonViaLinearRing():
    print ("---Polygon via LinearRing---")
    polygon = Polygon(createLinearRing())
    print("Points %d" % polygon.exteriorRing().pointsCount());
    for p in polygon.exteriorRing().points():
       print("%f %f" % (p.x(), p.y()))
    rect = polygon.boundingRect()
    print ("Rect of polygon: (%.1f %.1f) (%.1f %.1f)" % (rect.left(), rect.top(), rect.right(), rect.bottom()))
    polygon.addInterior(createLinearRingInterior()) # Внутреннее кольцо
    print("area=%f" % polygon.area(CartesianAreaCalculator()))
    print("Interiors %d" % polygon.interiorsCount());
    for p in polygon.interiorAt(0).points():
       print("%f %f" % (p.x(), p.y()))

# Создание линии
def createLine():
    print ("---Line---")
    line = Line(csll, QLineF(QPointF(5,5), QPointF(10,10)))
    print("beginPoint (%f %f)" % (line.beginPoint().x(), line.beginPoint().y()))
    print("length (m)=%f" % line.length(SphericalDistanceCalculator(csll)))
    print ("Line wkt: %s" % line.exportToWkt())

# Создание полилинии
def createLineString():
    print ("---LineString---")
    ls = LineString(csm, createQPolygon())
    print("Points %d" % ls.pointsCount());
    print("length=%f" % ls.length(SphericalDistanceCalculator(csll)))
    print ("LineString wkt: %s" % ls.exportToWkt())

# Создание прямоугольника
def createRectangle():
    print ("---Rectangle---")
    rect = QRectF(2,2, 6,6)
    rectangle = Rectangle(csm, rect)
    print("area=%f" % rectangle.area(CartesianAreaCalculator()))
    r= rectangle.boundingRect()
    print ("Rect of rectangle: (%.1f %.1f) (%.1f %.1f)" % (r.left(), r.top(), r.right(), r.bottom()))

# Создание скругленного прямоугольника
def createRoundRectangle():
    print ("---RoundRectangle---")
    rect = QRectF(2,2, 6,6)
    rrectangle = RoundRectangle(csm, rect, 1,1 )

# Содание эллипса
def createEllipse():
    print ("---Ellipse---")
    rect = QRectF(2,2, 6,8)
    ellipse = Ellipse(csm, rect )
    print ("maior=%.1f minor=%.1f" % (ellipse.majorSemiAxis(), ellipse.minorSemiAxis()))
    return ellipse

# Создание дуги
def createArc():
    print ("---Arc---")
    arc = Arc(csm, QPointF(10,10), 6, 8, 90, 270  )
    print ("start=%.1f end=%.1f length=%.1f" % (arc.startAngle(), arc.endAngle(), arc.length(CartesianDistanceCalculator())))
    print ("Arc wkt: %s" % arc.exportToWkt())
    return arc
    
# Создание текстового объекта
def createText():
    print ("---Text---")
    text = Text(csm, "Sample text", QPointF(10,10) )
    text.setAngle(90)
    print ("text=%s angle=%f" % (text.text(), text.angle()))
    return text

# Создание коллекции точек
def createMultiPoint():
    print ("---MultiPoint---")
    list = (QPointF(1,2), QPointF(5,4));
    mp = MultiPoint(csll, list)
    mp.addPoint(Point(csll, 20,40))
    print ("Points=%d" % (mp.collectionSize()))
    p = mp.geometryAt(0) # Получение геометрии

# Создание коллекции полигонов
def createMultiPolygon():
    print ("---MultiPolygon---")
    mp = MultiPolygon(csm)
    polygon1 = Polygon(csm, createQPolygon())
    mp.addPolygon(polygon1)
    pnts = QPolygonF();
    pnts<< QPointF(11,11) << QPointF(11,101) << QPointF(101,101) << QPointF(101,11) << QPointF(11,11)
    mp.addPolygon(Polygon(csm, pnts))
    print ("Polygons=%d" % (mp.collectionSize()))

# Создание коллекции полилиний
def createMultiLineString():
    print ("---MultiLineString---")
    mls = MultiLineString(csm)
    mls.addLineString(LineString(csm, createQPolygon()))
    print ("Lines=%d" % (mls.collectionSize()))

# Создание смешанной коллекции
def createMultiGeometry():
    print ("---MultiGeometry---")
    mg = MultiGeometry(csm)
    mg.addGeometry(createPolygon())
    mg.addGeometry(createEllipse())
    mg.addGeometry(createArc())
    mg.addGeometry(createText())
    for i in range(0, mg.collectionSize()):
       print("%d -%s" % (i, mg.geometryAt(i).name()))

# Создание геометрии из Wkt
def createFromWkt():
    point_wkt = GeosSupport.convertFromWkt("POINT (20.0000000000000000 40.0000000000000000)", csll)
    if point_wkt is not None:
        print("Name wkt: %s" % point_wkt.name())
        print ("Wkt point %.1f %.1f " % (point_wkt.pos().x(), point_wkt.pos().y()))
    polygon_wkt = GeosSupport.convertFromWkt("POLYGON ((1. 1., 1. 10., 10. 10., 10. 1., 1. 1.))", csll)
    if polygon_wkt is not None:
       print("Name wkt: %s" % polygon_wkt.name())
       print("Wkt polygon points %d" % polygon_wkt.exteriorRing().pointsCount());
    g3 = GeosSupport.convertFromWkt("LINESTRING (1. 1., 1. 10., 10. 10., 10. 1., 1. 1.)", csll)
    if g3 is not None:
       print("Name wkt: %s" % g3.name())

# Преобразование в формат Json
def jsonSupport():
    p = Point(csll, 20,40)
    json = convertGeometryToJson(p)
    print("Json point: %s" % json)
# Проекция берется из строки
    pout = geometryFromJson(json)
    print ("Json point: %.1f %.1f %s" % (pout.pos().x(), pout.pos().y(), pout.coordSystem().prjStr()))
# Явно указываем КС
    cs4284 = CoordSysFactory.defaultCoordSysFactory().createFromEpsg(4284) 
    pout2 = geometryFromJson(json, cs4284)
    print ("Json point2: %.1f %.1f %s" % (pout2.pos().x(), pout2.pos().y(), pout2.coordSystem().prjStr()))

# Base
print ("---Начало`---")

printProjection ()
point = createPoint()
poly = createPolygon()
createLinearRing()
createPolygonViaLinearRing()
createLine()
createLineString()
createRectangle()
createRoundRectangle()
createEllipse()
createArc()
createText()
createMultiPoint()
createMultiPolygon()
createMultiLineString()
createMultiGeometry()
createFromWkt()
jsonSupport()

print ("---Все---")
