#dp Table DataObject TableSchema Features AttributeDefinition

import axioma.app
from axioma.core.dp import *
from axioma.core.geometry import GeometryInterface
from axioma.render import Style
import PyQt5.QtWidgets

'''
Пример получения информации из таблицы. Перед запуском необходимо, чтобы был открыт хотя-бы один источник данных
'''

def table_demonstrate():
    # Пример работы с таблицами
    if not len(tables):
        print("Ошибка. Нет открытых таблиц.")
        raise Exception()

    print("Информация о таблицах:")

    for table in tables:
        print("Таблица %s:" % table.name())
        print("Список атрибутов(%s)" % ", ".join(table.attributeNames()))
        print("Является пространственным? - %s" % table.isSpatial())
        print("Приоритет слоя - %s" % contentTypes[table.contentType()])
        print("============")

def get_style_geom_attributes():
    # Пример получения стилей и геомерий из атрибутов таблицы
    # Выведем стиль и геомениию первой записи из первой таблицы
    print("Стиль и геометрия первой записи (должна быть открыта хоть одна НЕ пустая таблица):")
    assert(len(tables))
    print("Table: %s" % tables[0].name())
    features = tables[0].allFeatures()
    assert(len(features))
    feature = features[0]
    print("All Attributes:")
    for i in range(feature.numAttributes()):
        attr = feature.getAttribute(i)
        print(str(attr))

    # Конкретно как можно отловить стили и геометрии
    print("===================")
    print("Стиль и геометрия первой записи: ")
    attrs = [feature.getAttribute(i) for i in range(feature.numAttributes())]
    print("\n".join([str(attr) for attr in attrs if isinstance(attr, (Style, GeometryInterface))]))

def get_table_projection(table):
    print("\n")
    print("==========%s===========" % "Get_Table_Projection")
    assert(isinstance(table, Table))
    print("Таблица: ", table.name())
    table_schema = table.tableSchema()
    geomAttr = table_schema.getByName("object")
    if not geomAttr:
        raise TypeError("Таблица не имеет аттрибута с геометрией") # или он с нестандартным именем?
    print(type(geomAttr))
    coordSys = geomAttr.coordSystem()
    print("Долгота Широта? - %s" % ("Да" if coordSys.isLatLong() else "Нет"))
    print("Проекция: ", coordSys.description())

def get_table_projection_directly(table):
    print("\n")
    print("==========Получаем координатрую систему таблицы напрямую===========")
    assert(isinstance(table, Table))
    coord_sys = table.coordSystem()
    print("Проекция: ", coord_sys.description())

window = axioma.app.mainWindow
contentKeys = [ContentType_Text, ContentType_Points, ContentType_Lines, ContentType_Polygons, ContentType_Unknown, ContentType_Basic, ContentType_Rasters, ContentType_Other]
contentValues = ["Text", "Points", "Lines", "Polygons", "Unknown", "Basic", "Rasters", "Other"]
contentTypes = dict(zip(contentKeys, contentValues))

tables = window.listTables()

table_demonstrate()
get_style_geom_attributes()
get_table_projection(tables[0])
get_table_projection_directly(tables[0])
