import axioma.gui
import PyQt5.QtGui
'''
NativeActionExtension используется для регистрации пользовательского действия в системе. При этом нет необходимости в изменении состояния в зависимости от окружения среды.
Другими словами если необходимо создать кнопку на панели инструментов, которая доступна всегда, необходимо использовать данный подход.
'''

# Объявляем свой класс расширения
class ExampleActionExtension(axioma.gui.NativeActionExtension):

# Необходимо переопределить метод customizeAction, задав параметры для создаваемого объекта QAction
    def customizeAction(self, action):
        action.setText("Пример действия")
        action.setIcon(PyQt5.QtGui.QIcon(":/icons/share/32px/run.png"))
        action.triggered.connect(self.slot);

# Действие по нажатию
    def slot(self):
        print('Нажали кнопку')

# Регистрация в системе на новой закладке
ribbonExt = axioma.gui.extension.RibbonExtension()
ribbonExt.addTab("ExamplePluginTab", "Пример модуля")
actionExt = ExampleActionExtension("ActionExtensionId", axioma.gui.RibbonActionInfo()) 
ribbonExt.addAction("ActionExtensionId", "ExamplePluginTab", "") # Добавление в интерфейс
axioma.app.gui.prependExtensions([ribbonExt, actionExt]) # Регистрация
