import sys
import axioma.gui.extension
import PyQt5.QtGui
import PyQt5.QtCore

'''
NativeActionControllerExtension используется для регистрации пользовательского действия в системе. При этом есть возможность изменении состояния в зависимости от окружения среды.
Другими словами если необходимо создать кнопку на панели инструментов, при этом реализовать возможность управления ее доступностью, необходимо использовать данный подход.
'''

# Объявим расширение для действия с возможностью управления доступностью и режима переключателя
class MyActionControllerExtension(axioma.gui.NativeActionControllerExtension):
    def __init__(self, actionControllerFactory, actionId, icon, text, slot, checkable = False):
         controller = actionControllerFactory()
         controller.setCheckable(checkable)
         super().__init__(controller, actionId, axioma.gui.RibbonActionInfo())
         self.__icon = icon
         self.__text = text
         self.__slot = slot

# Необходимо переопределить метод customizeAction, задав параметры для создаваемого объекта QAction
    def customizeAction(self, action):
          action.setText(self.__text)
          action.setIcon(self.__icon)
          action.triggered.connect(self.__slot)
         
# Доступность. Отправляется всем созданным в рамках данного расширения действиям. Вызов необходимо производить после регистрации расширения в системе посредством gui.prependExtension
    def setEnabled(self, v): 
        self.actionController().enableChanged.emit(v)

    def setChecked(self, v): # Утоплено
        self.actionController().checkedChanged.emit(v)

def myTriggered(): # внешний обработчик
        print ('Нажали кнопку')

# Добавляем action в систему в закладку карты и категорию инструментов
ribbonExt = axioma.gui.extension.RibbonExtension()

actionExt = MyActionControllerExtension(axioma.gui.NativeActionController, "ControllerActionId", PyQt5.QtGui.QIcon(":/icons/32px/run.png"), "Тестовое действие", myTriggered)
axioma.app.gui.prependExtension(actionExt)
ribbonExt.addAction("ControllerActionId", "map", "tools")
axioma.app.gui.prependExtension(ribbonExt)

# В качестве примера подключим контроллер к каталогу данных. Если в каталоге есть таблицы, действие доступно. Если он пуст - нет.
# Нужно отметить, что для более корректной работы для этих целей лучше использовать пользовательский контроллер на базе axioma.gui.NativeActionController
# (переопределить свой контроллер на базе axioma.gui.NativeActionController).
catalog = axioma.app.mainWindow.dataCatalog()

def onUpdatedCatalog():
    actionExt.setEnabled(len(catalog.allDataObjects()))

onUpdatedCatalog()

catalog.updated.connect(onUpdatedCatalog)
