import inspect, os
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QDialog, QFileDialog
from PyQt5.uic import loadUi
from axioma.app import *

'''
Пример реализации диалога открытия файлов в окне карты или показ списком.
'''

# Определяем пользовательское окно
class MainWindowSample(QDialog):

    def __init__(self, axiomaWindow):
        assert(type(axiomaWindow) is MainWindow)
        QDialog.__init__(self, axiomaWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
        # trick to get .ui file from dir w/ script
        cwd = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
        self.__ui = loadUi(os.path.join(cwd, "OpenFileSample.ui"), self)
        self.fileDialog = QFileDialog()
        self.fileDialog.setFileMode(3)
        self.fileDialog.setWindowTitle("Открыть файл")
        self.__axiomaWindow = axiomaWindow
        self.initUi()
        self.modes = (OpenMode_Undefined, OpenMode_CreateWindow, OpenMode_CurrentWindow, OpenMode_Browser, OpenMode_Hide)
        self.fileList = list()

    # Определяем реакцию на события
    def initUi(self):
        self.__ui.btnGetPaths.clicked.connect(self.fileDialog.open)
        self.fileDialog.accepted.connect(self.on_file_selected)
        self.__ui.btnOpen.clicked.connect(self.on_open_file)

    # Слот выбора файлов для открытия
    def on_file_selected(self):
        self.fileList = self.fileDialog.selectedFiles()
        self.__ui.tePaths.setText("\n".join(self.fileList))

    # Слот открытия файлов в соответсвие с установленным режимом
    def on_open_file(self):
        mode = self.modes[self.__ui.cbModes.currentIndex()]
        forAll = self.__ui.cbForAll.isChecked()
        if (forAll):
            mode |= OpenMode_ForAll
        for file in self.fileList:
            self.__axiomaWindow.openFile(file, mode)


window = MainWindowSample(mainWindow)
window.setWindowIcon(mainWindow.windowIcon())
window.show()
window.move(300, 200)
