# -*- coding: utf-8 -*-

import sys
import traceback
import imp
import os.path


def init_translation(path, filename_base):
    from PyQt5.QtCore import QTranslator, QCoreApplication
    import axioma
    translator=QTranslator()
    status=translator.load(axioma.app.core.translationLocale(), filename_base, "_", path)
    if not status:
        return
    if QCoreApplication.installTranslator(translator):
        translator.setParent(QCoreApplication.instance())


def loadPlugin(pluginWrapper, absolute_path):
    path, name = os.path.split(absolute_path)
    fp, pathname, description = imp.find_module(name,[path])
    try:
        module = imp.load_module(name, fp, pathname, description)
        module.plugin = pluginWrapper
        if hasattr(module, "init") and not module.init():
            return False
        init_translation(pathname, "translation")
        if hasattr(module, "createExtensions"):
            for ext in module.createExtensions():
                pluginWrapper.addExtension(ext)
        return True
    except:
        pluginWrapper.setErrorString(traceback.format_exc())
        return False
    finally:
        if fp:
            fp.close()
