# The PEP 484 type hints stub file for the _core_dp module.
#
# Generated by SIP 4.19.3.dev1705052245


import typing
import sip

from axioma_dynload import _core_geometry
from axioma_dynload import _core_plugin
from axioma_dynload import _core_serializable
from axioma_dynload import _common
from axioma_dynload import _cs
from PyQt5 import QtNetwork
from PyQt5 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], sip.Buffer, int, None]


class TypeOper(int): ...
OpReady = ... # type: TypeOper
OpInsert = ... # type: TypeOper
OpUpdate = ... # type: TypeOper
OpRemove = ... # type: TypeOper


class TabFieldType(int): ...
ftUnknown = ... # type: TabFieldType
ftString = ... # type: TabFieldType
ftInteger = ... # type: TabFieldType
ftSmallint = ... # type: TabFieldType
ftFloat = ... # type: TabFieldType
ftDecimal = ... # type: TabFieldType
ftDate = ... # type: TabFieldType
ftLogical = ... # type: TabFieldType
ftTime = ... # type: TabFieldType
ftDateTime = ... # type: TabFieldType
ftLargeInt = ... # type: TabFieldType


class ContentType(int): ...
ContentType_Text = ... # type: ContentType
ContentType_Points = ... # type: ContentType
ContentType_Lines = ... # type: ContentType
ContentType_Polygons = ... # type: ContentType
ContentType_Unknown = ... # type: ContentType
ContentType_Basic = ... # type: ContentType
ContentType_Rasters = ... # type: ContentType
ContentType_Other = ... # type: ContentType


class AccessMode(int): ...
Access_ReadOnly = ... # type: AccessMode
Access_ReadWrite = ... # type: AccessMode


class DataSourceDefinition(_core_serializable.axioma.serialization.Serializable):

    def isSameSource(self, other: 'DataSourceDefinition') -> bool: ...


class CatalogDefinition(DataSourceDefinition):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, dir: QtCore.QDir) -> None: ...
    @typing.overload
    def __init__(self, a0: 'CatalogDefinition') -> None: ...

    def isSameSource(self, other: DataSourceDefinition) -> bool: ...
    def setDir(self, value: QtCore.QDir) -> None: ...
    def dir(self) -> QtCore.QDir: ...


class OpenModeSelectable(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, mode: AccessMode) -> None: ...
    @typing.overload
    def __init__(self, a0: 'OpenModeSelectable') -> None: ...

    def setOpenMode(self, value: AccessMode) -> None: ...
    def openMode(self) -> AccessMode: ...
    def readOnly(self) -> bool: ...


class DatabaseDefinition(DataSourceDefinition, OpenModeSelectable):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, host: str, dbName: str, userName: str, password: str, port: int) -> None: ...
    @typing.overload
    def __init__(self, a0: 'DatabaseDefinition') -> None: ...

    def isSameSource(self, other: DataSourceDefinition) -> bool: ...
    def description(self) -> str: ...
    def setPort(self, port: int) -> None: ...
    def port(self) -> int: ...
    def password(self) -> str: ...
    def setPassword(self, password: str) -> None: ...
    def setUserName(self, name: str) -> None: ...
    def userName(self) -> str: ...
    def setDatabaseName(self, name: str) -> None: ...
    def databaseName(self) -> str: ...
    def setHostName(self, host: str) -> None: ...
    def hostName(self) -> str: ...


class UrlDefinition(DataSourceDefinition):

    def url(self) -> QtCore.QUrl: ...


class FileDefinition(UrlDefinition, OpenModeSelectable):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, filename: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'FileDefinition') -> None: ...

    def isEmpty(self) -> bool: ...
    def fileExists(self) -> bool: ...
    def ioDeviceOpenMode(self) -> QtCore.QIODevice.OpenMode: ...
    def openFile(self, parent: typing.Optional[QtCore.QObject] = ...) -> QtCore.QFile: ...
    def hasSuffix(self, str: str) -> bool: ...
    def suffix(self) -> str: ...
    def dir(self) -> QtCore.QDir: ...
    def fileInfo(self) -> QtCore.QFileInfo: ...
    def isSameSource(self, other: DataSourceDefinition) -> bool: ...
    def setFilename(self, filename: str) -> None: ...
    def url(self) -> QtCore.QUrl: ...
    def filename(self) -> str: ...


class DataObjectDefinition(_core_serializable.axioma.serialization.Serializable):

    def displayName(self) -> str: ...
    def isSame(self, other: 'DataObjectDefinition') -> bool: ...


class PointBinding(sip.wrapper):

    description = ... # type: str
    layerPoint = ... # type: typing.Union[QtCore.QPointF, QtCore.QPoint]
    worldPoint = ... # type: typing.Union[QtCore.QPointF, QtCore.QPoint]

    @typing.overload
    def __init__(self, layer: typing.Union[QtCore.QPointF, QtCore.QPoint], world: typing.Union[QtCore.QPointF, QtCore.QPoint], desc: str) -> None: ...
    @typing.overload
    def __init__(self, layer: typing.Union[QtCore.QPointF, QtCore.QPoint], world: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'PointBinding') -> None: ...


class BindingDefinition(DataObjectDefinition):

    @typing.overload
    def __init__(self, wrappedObjectDef: DataObjectDefinition = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'BindingDefinition') -> None: ...

    @staticmethod
    def isValidTransform(t: QtGui.QTransform) -> bool: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def setCoordSystem(self, cs: _cs.CoordSystem) -> None: ...
    def calculateWorldToLayerTransform(self) -> QtGui.QTransform: ...
    def calculateLayerToWorldTransform(self) -> QtGui.QTransform: ...
    def size(self) -> int: ...
    def allPoints(self) -> typing.Any: ...
    def setAllPoints(self, points: typing.Any) -> None: ...
    def isSame(self, other: DataObjectDefinition) -> bool: ...
    def internalName(self) -> str: ...
    def displayName(self) -> str: ...


class DataSource(QtCore.QObject):

    def __init__(self, provider: 'DataProvider') -> None: ...

    def canRemoveEmpty(self) -> bool: ...
    def provider(self) -> 'DataProvider': ...
    def createDataObject(self, name: str, value: typing.Union[QtCore.QJsonValue, QtCore.QJsonValue.Type, typing.Iterable[QtCore.QJsonValue], typing.Dict[str, QtCore.QJsonValue], bool, int, float, str]) -> 'DataObject': ...
    def openDataObject(self, dataObjectDef: typing.Optional[DataObjectDefinition] = ...) -> 'DataObject': ...
    def contents(self) -> list[DataObjectDefinition]: ...
    def accessMode(self) -> AccessMode: ...
    def dataSourceDefinition(self) -> typing.Any: ...
    def dataSourceId(self) -> int: ...


class DataObject(QtCore.QObject):

    def __init__(self) -> None: ...

    def beforeClose_impl(self) -> None: ...
    def releaseHeavyResources_impl(self) -> None: ...
    def defaultName_impl(self) -> str: ...
    def releaseHeavyResources(self) -> None: ...
    def closeRequest(self) -> None: ...
    def close(self) -> None: ...
    def closeRequested(self) -> None: ...
    def nameChanged(self) -> None: ...
    def setProperties(self, a0: 'DataObjectProperties') -> None: ...
    def properties(self) -> 'DataObjectProperties': ...
    def dependencies(self) -> list[DataObject]: ...
    def fullDataObjectTypeName(self) -> str: ...
    def originalProvider(self) -> 'DataProvider': ...
    def originalSource(self) -> typing.Any: ...
    def originalObject(self) -> 'DataObject': ...
    def definition(self) -> DataObjectDefinition: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...
    def dataObjectId(self) -> int: ...
    def isSpatial(self) -> bool: ...
    def accessMode(self) -> AccessMode: ...


class RasterDataObject(DataObject):

    def __init__(self) -> None: ...

    def baseRect(self) -> QtCore.QRect: ...
    def imageRect(self, source: QtCore.QRect, size: QtCore.QSize) -> QtGui.QImage: ...
    def setProperties(self, props: 'DataObjectProperties') -> None: ...
    def properties(self) -> 'DataObjectProperties': ...
    def setRasterProperties(self, value: typing.Any) -> None: ...
    def rasterProperties(self) -> 'RasterProperties': ...
    def accessMode(self) -> AccessMode: ...


class DataProvider(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def displayDescription(self) -> str: ...
    def canCreateDataSource(self) -> bool: ...
    def createDataSource(self, jsonDef: typing.Dict[str, QtCore.QJsonValue]) -> DataSource: ...
    def openDataSource(self, definition: typing.Any) -> DataSource: ...
    def class_id(self) -> str: ...


class FileCategory(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, aFileDefPrototype: FileDefinition) -> None: ...
    @typing.overload
    def __init__(self, aExtensions: typing.Iterable[str], aDescription: str, aFileDefPrototype: FileDefinition) -> None: ...
    @typing.overload
    def __init__(self, a0: 'FileCategory') -> None: ...

    def hasExtension(self, ext: str) -> bool: ...
    def setDescription(self, value: str) -> None: ...
    def setExtensions(self, value: typing.Iterable[str]) -> None: ...
    def fileDefPrototype(self) -> FileDefinition: ...
    def description(self) -> str: ...
    def extensions(self) -> typing.List[str]: ...


class FileCategoriesList(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, categories: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, a0: 'FileCategoriesList') -> None: ...

    def asList(self) -> typing.List[FileCategory]: ...
    def combinedDescription(self, stopLength: int, separator: str, etcText: str) -> str: ...
    def listAllExtensions(self) -> typing.List[str]: ...
    def categoriesForExtension(self, ext: str) -> typing.List[FileCategory]: ...


class GeoRect(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, rect: QtCore.QRectF, cs: _cs.CoordSystem) -> None: ...
    @typing.overload
    def __init__(self, cs: _cs.CoordSystem) -> None: ...
    @typing.overload
    def __init__(self, a0: 'GeoRect') -> None: ...

    def isNonEarthCs(self) -> bool: ...
    def isEqualCs(self, otherCs: _cs.CoordSystem) -> bool: ...
    @typing.overload
    @staticmethod
    def cropToCoordsysBounds(cs: _cs.CoordSystem, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @typing.overload
    def cropToCoordsysBounds(self) -> 'GeoRect': ...
    def united(self, other: 'GeoRect') -> 'GeoRect': ...
    def unite(self, other: 'GeoRect') -> 'GeoRect': ...
    def transformedToCoordSystem(self, cs: _cs.CoordSystem) -> 'GeoRect': ...
    def transformToCoordSystem(self, cs: _cs.CoordSystem) -> None: ...
    def setCoordSystem(self, cs: _cs.CoordSystem) -> None: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def size(self) -> QtCore.QSizeF: ...
    def center(self) -> QtCore.QPointF: ...
    def height(self) -> float: ...
    def width(self) -> float: ...
    def bottom(self) -> float: ...
    def right(self) -> float: ...
    def top(self) -> float: ...
    def left(self) -> float: ...
    def setRect(self, rect: QtCore.QRectF) -> None: ...
    def rect(self) -> QtCore.QRectF: ...
    def isValid(self) -> bool: ...
    def isDegenerated(self) -> bool: ...
    def isUnknown(self) -> bool: ...


class QuerySupport(sip.wrapper):

    def select(self, a0: 'TableQuery', page: 'PageRange' = ...) -> typing.Any: ...
    def count(self, a0: 'TableQuery' = ...) -> int: ...
    def checkQuery(self, a0: 'TableQuery') -> bool: ...


class Feature(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'Feature') -> None: ...

    def remap(self, requestedSchema: 'TableSchema') -> 'Feature': ...
    def copy(self, requestedSchema: 'ModifiedTableSchema') -> 'Feature': ...
    def copyResetId(self, requestedSchema: 'ModifiedTableSchema', newId: typing.Any) -> 'Feature': ...
    def schema(self) -> 'TableSchema': ...
    def isEmpty(self) -> bool: ...
    def setValuesFromText(self, text: str) -> None: ...
    def setValuesFromBinary(self, bytes: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def valuesToText(self, attributes: typing.Iterable[str] = ...) -> str: ...
    def valuesToBinary(self, attributes: typing.Iterable[str] = ...) -> QtCore.QByteArray: ...
    def name(self, index: int) -> str: ...
    def saveModificationsFromOther(self, feature: 'Feature') -> None: ...
    def setAllModified(self, value: bool) -> None: ...
    def modifiedStatus(self) -> QtCore.QBitArray: ...
    @typing.overload
    def setModified(self, index: int, value: bool = ...) -> None: ...
    @typing.overload
    def setModified(self, name: str, value: bool = ..., c: QtCore.Qt.CaseSensitivity = ...) -> None: ...
    @typing.overload
    def isModified(self, index: int) -> bool: ...
    @typing.overload
    def isModified(self, name: str, c: QtCore.Qt.CaseSensitivity = ...) -> bool: ...
    def trySetAttribute(self, name: str, value: typing.Any) -> bool: ...
    def tryGetAttribute(self, name: str, result: typing.Any) -> bool: ...
    @typing.overload
    def setGeoAttribute(self, index: int, value: _core_serializable.axioma.serialization.Serializable, transform: _core_geometry.Transform) -> None: ...
    @typing.overload
    def setGeoAttribute(self, index: int, value: typing.Any, transform: _core_geometry.Transform) -> None: ...
    @typing.overload
    def setAttribute(self, index: int, value: _core_serializable.axioma.serialization.Serializable) -> None: ...
    @typing.overload
    def setAttribute(self, index: int, value: typing.Any) -> None: ...
    @typing.overload
    def setAttribute(self, name: str, value: _core_serializable.axioma.serialization.Serializable, a2: QtCore.Qt.CaseSensitivity = ...) -> None: ...
    @typing.overload
    def setAttribute(self, name: str, value: typing.Any, c: QtCore.Qt.CaseSensitivity = ...) -> None: ...
    @typing.overload
    def getAttribute(self, index: int) -> typing.Any: ...
    @typing.overload
    def getAttribute(self, name: str, c: QtCore.Qt.CaseSensitivity = ...) -> typing.Any: ...
    def styleIndexes(self) -> typing.List[int]: ...
    def styleIndex(self) -> int: ...
    def geometryIndexes(self) -> typing.List[int]: ...
    def geometryIndex(self) -> int: ...
    def indexOf(self, name: str, c: QtCore.Qt.CaseSensitivity = ...) -> int: ...
    def id(self) -> typing.Any: ...
    def attributeNamesList(self) -> typing.List[str]: ...
    def numAttributes(self) -> int: ...
    @staticmethod
    def createFeature(schema: 'TableSchema') -> 'Feature': ...


class Cursor(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'Cursor') -> None: ...

    def __iter__(self) -> 'Cursor': ...
    def __next__(self) -> typing.Any: ...


class SignalingCursor(QtCore.QObject, Cursor):

    def __init__(self, cursor: Cursor, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def abort(self) -> None: ...
    def moved(self, count: int) -> None: ...


class HistorySnapshot(sip.wrapper):

    @typing.overload
    def __init__(self, idComparator: 'VariantComparator') -> None: ...
    @typing.overload
    def __init__(self, a0: 'HistorySnapshot') -> None: ...

    def numGoneFeatures(self) -> int: ...
    def numNewfoundIds(self) -> int: ...
    def numInsertedFeatures(self) -> int: ...
    def idComparator(self) -> 'VariantComparator': ...
    def isEmpty(self) -> bool: ...
    def clear(self) -> None: ...
    def storeGoneFeature(self, id: typing.Any) -> None: ...
    def storeUpdatedFeature(self, f: typing.Any) -> None: ...
    def storeNewfoundFeature(self, f: typing.Any) -> None: ...
    def newfoundIds(self) -> typing.List[typing.Any]: ...
    def inserted(self) -> typing.Any: ...
    def insertedFeatureSequence(self, range: 'PageRange' = ...) -> typing.Any: ...


class Table(DataObject, QuerySupport):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'Table') -> None: ...

    def schemaChanged(self) -> None: ...
    def dataReset(self) -> None: ...
    def contentTypes(self) -> list[ContentType]: ...
    def contentType(self) -> ContentType: ...
    def hasDataChangeConnection(self) -> bool: ...
    def setTableProperties(self, value: 'TableProperties') -> None: ...
    def tableProperties(self) -> 'TableProperties': ...
    def selectFeaturesById(self, ids: typing.List[typing.Any], attrNamesList: typing.Iterable[str] = ..., range: 'PageRange' = ...) -> list[Feature]: ...
    def selectFeaturesInMbr(self, rect: GeoRect, attrNamesList: typing.Iterable[str] = ..., geomAttrName: str = ..., range: 'PageRange' = ...) -> list[Feature]: ...
    def selectToFeatureList(self, query: 'TableQuery', range: 'PageRange' = ...) -> list[Feature]: ...
    def allFeatures(self) -> list[Feature]: ...
    def sourceTable(self) -> typing.Any: ...
    def featureIdComparator(self) -> 'VariantComparator': ...
    def sourceOfChanges(self) -> typing.Any: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def saveSchemaToJson(self) -> typing.List[QtCore.QJsonValue]: ...
    def tableSchema(self) -> 'TableSchema': ...
    def attributeNames(self) -> typing.List[str]: ...


class EditableTable(Table):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'EditableTable') -> None: ...

    def tableSaved(self) -> None: ...
    def modifyTableSchema(self, jsonAttributes: typing.Iterable[QtCore.QJsonValue]) -> bool: ...
    def save(self, snapshot: HistorySnapshot) -> None: ...


class HasHistory(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'HasHistory') -> None: ...

    def canRollForward(self, steps: int = ...) -> bool: ...
    def canRollBack(self, steps: int = ...) -> bool: ...
    def rollForward(self, steps: int = ...) -> None: ...
    def rollBack(self, steps: int) -> None: ...
    def hasModified(self) -> bool: ...
    def setDescription(self, index: int, value: str) -> None: ...
    def description(self, index: int) -> str: ...
    def setCurrentChangeIndex(self, value: int) -> None: ...
    def currentChangeIndex(self) -> int: ...
    def historySize(self) -> int: ...


class HasFeatureHistory(HasHistory):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'HasFeatureHistory') -> None: ...

    def remove(self, cursor: Cursor, description: str = ...) -> None: ...
    def update(self, cursor: Cursor, description: str = ...) -> None: ...
    def insert(self, cursor: Cursor, description: str = ...) -> None: ...


class TransactionalTable(EditableTable, HasFeatureHistory):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'TransactionalTable') -> None: ...

    def save(self, snapshot: HistorySnapshot) -> None: ...
    def useAutoRollback(self) -> bool: ...
    def setAutoRollback(self) -> None: ...
    def setAutoCommit(self) -> None: ...
    def restore(self) -> None: ...
    def commit(self) -> None: ...
    def setDescription(self, index: int, value: str) -> None: ...
    def description(self, index: int) -> str: ...
    def setCurrentChangeIndex(self, value: int) -> None: ...
    @typing.overload
    def update(self, cursor: Cursor, description: str = ...) -> None: ...
    @typing.overload
    def update(self, featureList: list[Feature], description: str = ...) -> None: ...
    @typing.overload
    def remove(self, cursor: Cursor, description: str = ...) -> None: ...
    @typing.overload
    def remove(self, featureList: list[Feature], description: str = ...) -> None: ...
    @typing.overload
    def insert(self, cursor: Cursor, description: str = ...) -> None: ...
    @typing.overload
    def insert(self, featureList: list[Feature], description: str = ...) -> None: ...


class SelectionTable(TransactionalTable):

    @typing.overload
    def __init__(self, other: 'SelectionTable') -> None: ...
    @typing.overload
    def __init__(self, sourceTable: typing.Any, idList: typing.Iterable[typing.Any]) -> None: ...

    def hasId(self, id: typing.Any) -> bool: ...
    def dependencies(self) -> list[DataObject]: ...
    def sourceTable(self) -> typing.Any: ...
    def sourceOfChanges(self) -> typing.Any: ...
    def tableSchema(self) -> 'TableSchema': ...
    def featureIdComparator(self) -> 'VariantComparator': ...
    def originalObject(self) -> typing.Any: ...
    def originalSource(self) -> typing.Any: ...
    def accessMode(self) -> AccessMode: ...
    def isSpatial(self) -> bool: ...


class Selection(sip.wrapper):

    table = ... # type: typing.Any

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, table: typing.Any, idList: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, a0: 'Selection') -> None: ...

    def size(self) -> int: ...
    def ids(self) -> typing.List[typing.Any]: ...
    def setIds(self, newIds: typing.Iterable[typing.Any]) -> None: ...


class SelectionChangeInfo(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, selected: Selection) -> None: ...
    @typing.overload
    def __init__(self, selected: Selection, deselected: Selection, source: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'SelectionChangeInfo') -> None: ...

    def source(self) -> QtCore.QObject: ...
    def deselected(self) -> Selection: ...
    def selected(self) -> Selection: ...


class SelectionManager(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def selectionChanged(self, selectionChange: SelectionChangeInfo) -> None: ...
    def currentTarget(self) -> Selection: ...
    @typing.overload
    def hasTarget(self) -> bool: ...
    @typing.overload
    def hasTarget(self, table: typing.Any) -> bool: ...
    def readSelectedFeaturesData(self) -> typing.Any: ...
    def currentSelection(self) -> Selection: ...
    def sourceTableWithSelection(self) -> typing.Any: ...
    @typing.overload
    def hasSelection(self) -> bool: ...
    @typing.overload
    def hasSelection(self, table: typing.Any) -> bool: ...
    def deselect(self, a0: typing.Any, a1: typing.List[typing.Any]) -> None: ...
    def setSelection(self, a0: typing.Any, a1: typing.List[typing.Any]) -> None: ...
    def addToSelection(self, a0: typing.Any, a1: typing.List[typing.Any]) -> None: ...


class DataObjectRef(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'DataObjectRef') -> None: ...

    def isSpatial(self) -> bool: ...
    def name(self) -> str: ...
    def close(self) -> None: ...
    def dataObject(self) -> DataObject: ...
    def detach(self) -> DataObject: ...


class TableSchema(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, attributeList: typing.Iterable['AttributeDefinition']) -> None: ...
    @typing.overload
    def __init__(self, a0: 'TableSchema') -> None: ...

    def styleIndexes(self) -> typing.List[int]: ...
    def styleIndex(self) -> int: ...
    def geometryIndexes(self) -> typing.List[int]: ...
    def geometryIndex(self) -> int: ...
    @staticmethod
    def emptyInstance() -> 'TableSchema': ...
    def allIndexesExcludingNames(self, names: typing.Iterable[str]) -> typing.List[int]: ...
    def tryIndexesOfNames(self, names: typing.Iterable[str]) -> typing.List[int]: ...
    def attributeNames(self) -> typing.List[str]: ...
    def getById(self, id: int) -> 'AttributeDefinition': ...
    def getByName(self, name: str, c: QtCore.Qt.CaseSensitivity = ...) -> 'AttributeDefinition': ...
    def get(self, index: int) -> 'AttributeDefinition': ...
    def at(self, index: int) -> 'AttributeDefinition': ...
    def name(self, index: int) -> str: ...
    def empty(self) -> bool: ...
    def numAttributes(self) -> int: ...
    def hasName(self, name: str) -> bool: ...
    @typing.overload
    def tryIndexOf(self, name: str, c: QtCore.Qt.CaseSensitivity = ...) -> int: ...
    @typing.overload
    def tryIndexOf(self, id: int) -> int: ...
    @typing.overload
    def indexOf(self, name: str, c: QtCore.Qt.CaseSensitivity = ...) -> int: ...
    @typing.overload
    def indexOf(self, id: int) -> int: ...


class ModifiedTableSchema(TableSchema):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, value: TableSchema) -> None: ...
    @typing.overload
    def __init__(self, source: TableSchema, requestedNames: typing.Iterable[str]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ModifiedTableSchema') -> None: ...

    def indexInSource(self, columnIndex: int) -> int: ...
    def indexesInSource(self) -> typing.List[int]: ...
    def reverseModificationFrom(self, originalSchema: TableSchema) -> 'ModifiedTableSchema': ...


class AttributeDefinition(sip.wrapper):

    class NormalizeResult(int): ...
    Norm_DirectUsage = ... # type: 'AttributeDefinition.NormalizeResult'
    Norm_LosslessConversion = ... # type: 'AttributeDefinition.NormalizeResult'
    Norm_MinorValueLoss = ... # type: 'AttributeDefinition.NormalizeResult'
    Norm_MajorValueLoss = ... # type: 'AttributeDefinition.NormalizeResult'
    Norm_CouldNotConvert = ... # type: 'AttributeDefinition.NormalizeResult'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'AttributeDefinition') -> None: ...

    def normalizeValue(self, value: typing.Any, acceptableError: 'AttributeDefinition.NormalizeResult' = ...) -> typing.Any: ...
    def getNormalizedValue(self, value: typing.Any) -> typing.Tuple[typing.Any, 'AttributeDefinition.NormalizeResult']: ...
    def type(self) -> QtCore.QMetaType.Type: ...
    def setAlias(self, value: str) -> bool: ...
    def alias(self) -> str: ...
    def setName(self, value: str) -> bool: ...
    def name(self) -> str: ...
    def displayDescription(self) -> str: ...
    def displayClassName(self) -> str: ...
    def toJson(self) -> typing.Dict[str, QtCore.QJsonValue]: ...
    def newId(self) -> None: ...
    def copyId(self, other: 'AttributeDefinition') -> None: ...
    def id(self) -> int: ...


class GeometryAttributeDefinitionInterface(AttributeDefinition):

    @staticmethod
    def staticName() -> str: ...
    def isCoordSysEqual(self, other: _cs.CoordSystem) -> bool: ...
    def boundingRect(self) -> GeoRect: ...
    def setBoundingRectF(self, a0: QtCore.QRectF) -> None: ...
    def boundingRectF(self) -> QtCore.QRectF: ...
    def coordSysFactory(self) -> typing.Any: ...
    def setCoordSystem(self, value: _cs.CoordSystem) -> None: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def canAssignValue(self, value: typing.Any) -> bool: ...
    def toJson(self) -> typing.Dict[str, QtCore.QJsonValue]: ...
    def displayClassName(self) -> str: ...


class GeometryAttributeDefinition(GeometryAttributeDefinitionInterface):

    @typing.overload
    def __init__(self, name: str) -> None: ...
    @typing.overload
    def __init__(self, base: GeometryAttributeDefinitionInterface) -> None: ...
    @typing.overload
    def __init__(self, name: str, cs: typing.Any) -> None: ...

    def setGeoRect(self, geoRect: GeoRect) -> None: ...
    def setBoundingRectF(self, value: QtCore.QRectF) -> None: ...
    def boundingRectF(self) -> QtCore.QRectF: ...
    def setCoordSystem(self, cs: _cs.CoordSystem) -> None: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def resetCoordSysFactory(self, value: typing.Any = ...) -> None: ...
    def coordSysFactory(self) -> typing.Any: ...
    def setName(self, value: str) -> bool: ...
    def name(self) -> str: ...


class RenditionAttributeDefinition(AttributeDefinition):

    def __init__(self) -> None: ...

    @staticmethod
    def staticName() -> str: ...
    def toJson(self) -> typing.Dict[str, QtCore.QJsonValue]: ...
    def name(self) -> str: ...
    def displayClassName(self) -> str: ...


class SimpleAttributeDefinitionInterface(AttributeDefinition):

    def setUnique(self, value: bool) -> None: ...
    def unique(self) -> bool: ...
    def setPrecision(self, value: int) -> None: ...
    def precision(self) -> int: ...
    def setLength(self, value: int) -> None: ...
    def length(self) -> int: ...
    def setType(self, value: QtCore.QMetaType.Type) -> None: ...
    def setName(self, name: str) -> bool: ...
    def canAssignValue(self, value: typing.Any) -> bool: ...
    def toJson(self) -> typing.Dict[str, QtCore.QJsonValue]: ...
    def normalizeValue_impl(self, value: typing.Any) -> AttributeDefinition.NormalizeResult: ...
    def displayDescription(self) -> str: ...
    def displayClassName(self) -> str: ...


class SimpleAttributeDefinition(SimpleAttributeDefinitionInterface):

    def __init__(self, name: str, type: QtCore.QMetaType.Type, length: int = ..., precision: int = ...) -> None: ...

    def setUnique(self, value: bool) -> None: ...
    def setPrecision(self, value: int) -> None: ...
    def setLength(self, value: int) -> None: ...
    def setType(self, value: QtCore.QMetaType.Type) -> None: ...
    def setName(self, value: str) -> bool: ...
    def unique(self) -> bool: ...
    def precision(self) -> int: ...
    def length(self) -> int: ...
    def type(self) -> QtCore.QMetaType.Type: ...
    def name(self) -> str: ...


class DataCatalogInterface(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def removeDataObject(self, object: DataObject) -> bool: ...
    def removeDataSource(self, source: typing.Any) -> bool: ...
    def addDataObject(self, object: typing.Any) -> bool: ...
    def addDataSource(self, source: typing.Any) -> bool: ...
    def dataObjectRemoved(self, a0: DataObject) -> None: ...
    def dataSourceRemoved(self, a0: DataSource) -> None: ...
    def dataObjectAdded(self, a0: DataObject) -> None: ...
    def dataSourceAdded(self, a0: DataSource) -> None: ...
    def updated(self) -> None: ...
    def allDataObjects(self) -> list[DataObject]: ...
    def allDataSources(self) -> list[DataSource]: ...
    def findDataObjectByName(self, name: str) -> typing.Any: ...
    def findDataObject(self, dsrcDef: DataSourceDefinition, dobjDef: DataObjectDefinition) -> typing.Any: ...
    def findDataSource(self, dsrcDef: DataSourceDefinition) -> typing.Any: ...
    def hasDataObject(self, dataObject: DataObject) -> bool: ...


class DataCatalog(DataCatalogInterface):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def removeDataObject(self, object: DataObject) -> bool: ...
    def removeDataSource(self, source: typing.Any) -> bool: ...
    def addDataObject(self, object: typing.Any) -> bool: ...
    def addDataSource(self, source: typing.Any) -> bool: ...
    def updated(self) -> None: ...
    def remakeDataObject(self, dataObject: DataObject) -> typing.Any: ...
    @staticmethod
    def makeValidObjectName(name: str) -> str: ...
    def findUnusedName(self, base: str) -> str: ...
    def allDataObjects(self) -> list[DataObject]: ...
    def allDataSources(self) -> list[DataSource]: ...
    @typing.overload
    def hasDataObject(self, source: typing.Any, dobjDef: DataObjectDefinition) -> bool: ...
    @typing.overload
    def hasDataObject(self, dsrcDef: DataSourceDefinition, dobjDef: DataObjectDefinition) -> bool: ...
    @typing.overload
    def hasDataObject(self, dataObject: DataObject) -> bool: ...
    def hasDataSource(self, dsrcDef: DataSourceDefinition) -> bool: ...
    def countChildrenDataObjects(self, source: typing.Any) -> int: ...
    def findChildrenDataObjects(self, source: typing.Any) -> list[DataObject]: ...
    def findDataObjectByName(self, name: str) -> typing.Any: ...
    @typing.overload
    def findDataObject(self, source: typing.Any, dobjDef: DataObjectDefinition) -> typing.Any: ...
    @typing.overload
    def findDataObject(self, dsrcDef: DataSourceDefinition, dobjDef: DataObjectDefinition) -> typing.Any: ...
    def findDataSource(self, dsrcDef: DataSourceDefinition) -> typing.Any: ...
    def blockSignals(self, b: bool) -> None: ...


class DataCatalogWithSelection(DataCatalogInterface):

    def tableSchemaChanged(self, table: Table) -> None: ...
    def tableSaved(self, table: Table) -> None: ...
    def tableChanged(self, table: Table) -> None: ...
    def updated(self) -> None: ...
    def addDataObject(self, object: typing.Any) -> bool: ...
    def addDataSource(self, source: typing.Any) -> bool: ...
    def selectionTable(self) -> typing.Any: ...
    def selectionManager(self) -> SelectionManager: ...
    @staticmethod
    def toDetachedDataObjectList(refList: typing.Iterable[DataObjectRef]) -> list[DataObject]: ...
    @staticmethod
    def toDataObjectList(refList: typing.Iterable[DataObjectRef]) -> list[DataObject]: ...
    def hasDataSource(self, dsrcDef: DataSourceDefinition) -> bool: ...
    def findDataObjectRef(self, name: str) -> DataObjectRef: ...
    def allDataObjects(self) -> list[DataObject]: ...
    def allDataSources(self) -> list[DataSource]: ...
    def findDataObjectByName(self, name: str) -> typing.Any: ...
    def findDataObject(self, dsrcDef: DataSourceDefinition, dobjDef: DataObjectDefinition) -> typing.Any: ...
    def findDataSource(self, dsrcDef: DataSourceDefinition) -> typing.Any: ...
    def hasDataObject(self, dataObject: DataObject) -> bool: ...
    def allDataObjectRefs(self) -> typing.Any: ...
    def subCatalog(self) -> DataCatalogInterface: ...
    @staticmethod
    def clonedSelectionTableBaseName() -> str: ...
    @staticmethod
    def selectionTableName() -> str: ...


class HotLink(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, expression: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'HotLink') -> None: ...

    def isActive(self) -> bool: ...
    def setExpression(self, value: str) -> None: ...
    def expression(self) -> str: ...


class TabMetadata(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'TabMetadata') -> None: ...

    def keys(self) -> typing.List[str]: ...
    def hasKey(self, keyName: str) -> bool: ...
    def value(self, key: str) -> str: ...
    def setValue(self, key: str, value: str) -> None: ...
    def setHotlinkString(self, expr: str) -> None: ...
    def hotlinkString(self) -> str: ...


class TabField(sip.wrapper):

    @typing.overload
    def __init__(self, n: str, t: TabFieldType) -> None: ...
    @typing.overload
    def __init__(self, n: str, t: QtCore.QMetaType.Type) -> None: ...
    @typing.overload
    def __init__(self, a0: 'TabField') -> None: ...

    def setPrecision(self, precision: int) -> None: ...
    def precision(self) -> int: ...
    def setLength(self, length: int) -> None: ...
    def length(self) -> int: ...
    def setFieldType(self, fieldType: TabFieldType) -> None: ...
    def fieldType(self) -> TabFieldType: ...
    def setName(self, n: str) -> None: ...
    def name(self) -> str: ...
    def toString(self) -> str: ...
    @staticmethod
    def fromAttribute(def_: SimpleAttributeDefinitionInterface) -> 'TabField': ...


class TabRasterCoordLink(sip.wrapper):

    description = ... # type: str
    mapPoint = ... # type: typing.Union[QtCore.QPointF, QtCore.QPoint]
    picturePoint = ... # type: typing.Union[QtCore.QPointF, QtCore.QPoint]

    @typing.overload
    def __init__(self, m: typing.Union[QtCore.QPointF, QtCore.QPoint], p: typing.Union[QtCore.QPointF, QtCore.QPoint], d: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'TabRasterCoordLink') -> None: ...

    def toString(self) -> str: ...


class TabRasterLayerProperties(sip.wrapper):

    brightness = ... # type: int
    grayscale = ... # type: bool
    opacity = ... # type: int
    transparentColor = ... # type: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    useTransparentColor = ... # type: bool

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'TabRasterLayerProperties') -> None: ...


class TabFileParser(sip.wrapper):

    class TypeSource(int): ...
    tsUnknown = ... # type: 'TabFileParser.TypeSource'
    tsNative = ... # type: 'TabFileParser.TypeSource'
    tsRaster = ... # type: 'TabFileParser.TypeSource'
    tsSHP = ... # type: 'TabFileParser.TypeSource'
    tsDBF = ... # type: 'TabFileParser.TypeSource'
    tsODBC = ... # type: 'TabFileParser.TypeSource'
    tsWMS = ... # type: 'TabFileParser.TypeSource'
    tsWFS = ... # type: 'TabFileParser.TypeSource'
    tsLinked = ... # type: 'TabFileParser.TypeSource'
    tsAscii = ... # type: 'TabFileParser.TypeSource'
    tsTileServer = ... # type: 'TabFileParser.TypeSource'
    tsXls = ... # type: 'TabFileParser.TypeSource'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, ts: 'TabFileParser.TypeSource') -> None: ...
    @typing.overload
    def __init__(self, a0: 'TabFileParser') -> None: ...

    def setTextCodecFile(self, codec: QtCore.QTextCodec) -> None: ...
    def rasterLayerProperties(self) -> TabRasterLayerProperties: ...
    def setExternalFile(self, fi: QtCore.QFileInfo) -> None: ...
    def externalFile(self) -> QtCore.QFileInfo: ...
    def rasterCoordLinkList(self) -> typing.Any: ...
    def tabFile(self) -> QtCore.QFileInfo: ...
    def hasGraphics(self) -> bool: ...
    def attributeList(self) -> typing.Any: ...
    def printRasterProperties(self, out: QtCore.QTextStream, props: TabRasterLayerProperties) -> None: ...
    @typing.overload
    def printMetadataBlock(self, out: QtCore.QTextStream) -> None: ...
    @typing.overload
    def printMetadataBlock(self, out: QtCore.QTextStream, meta: TabMetadata) -> None: ...
    def print(self, out: QtCore.QTextStream) -> None: ...
    def printHeaderBlock(self, out: QtCore.QTextStream) -> None: ...
    def setMetadata(self, value: TabMetadata) -> None: ...
    def metadata(self) -> TabMetadata: ...
    def readMetadata(self, key: str, result: str) -> bool: ...
    def tabTypeSource(self) -> str: ...
    def codecAttributes(self) -> QtCore.QTextCodec: ...
    def setTextCodecAttributes(self, codec: QtCore.QTextCodec) -> None: ...
    def coordSysString(self) -> str: ...
    def bounds(self) -> QtCore.QRectF: ...
    def readOnly(self) -> bool: ...
    def typeSource(self) -> 'TabFileParser.TypeSource': ...
    @typing.overload
    def parse(self, fileName: str) -> None: ...
    @typing.overload
    def parse(self, fileInfo: QtCore.QFileInfo) -> None: ...
    @typing.overload
    def setTabFile(self, value: str) -> None: ...
    @typing.overload
    def setTabFile(self, value: QtCore.QFileInfo) -> None: ...


class DataObjectProperties(sip.wrapper):

    @typing.overload
    def __init__(self, metadata: TabMetadata, tabFile: str) -> None: ...
    @typing.overload
    def __init__(self, parser: TabFileParser) -> None: ...

    def tabFile(self) -> str: ...
    def metadata(self) -> TabMetadata: ...


class TableProperties(DataObjectProperties):

    @typing.overload
    def __init__(self, metadata: TabMetadata, tabFile: str) -> None: ...
    @typing.overload
    def __init__(self, parser: TabFileParser) -> None: ...
    @typing.overload
    def __init__(self, a0: 'TableProperties') -> None: ...

    def hotLink(self) -> HotLink: ...


class RasterProperties(DataObjectProperties):

    @typing.overload
    def __init__(self, metadata: TabMetadata, tabFile: str, layerProperties: TabRasterLayerProperties) -> None: ...
    @typing.overload
    def __init__(self, parser: TabFileParser) -> None: ...

    def setRasterLayerProperties(self, value: TabRasterLayerProperties) -> None: ...
    def rasterLayerProperties(self) -> typing.Any: ...


class Raster(RasterDataObject):

    def bindingDefinition(self) -> BindingDefinition: ...
    def innerBindingDefinition(self) -> BindingDefinition: ...
    def canSaveRegistration(self) -> bool: ...
    def reprojectedImage(self, destRect: GeoRect, size: QtCore.QSize, pixelToSourceCs: QtGui.QTransform) -> QtGui.QImage: ...
    def canReproject(self, csTo: _cs.CoordSystem) -> bool: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def size(self) -> QtCore.QSize: ...
    def defaultTransform(self) -> QtGui.QTransform: ...
    def getTransform(self, a0: QtGui.QTransform) -> bool: ...
    def hasTransform(self) -> bool: ...
    def baseRect(self) -> QtCore.QRect: ...
    def boundingGeoRect(self) -> GeoRect: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def rect(self) -> QtCore.QRect: ...
    def isSpatial(self) -> bool: ...


class HeightDataObjectSupport(sip.wrapper):

    def getZcoord(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], cs: _cs.CoordSystem) -> typing.Tuple[float, bool]: ...
    def hasZCoord(self) -> bool: ...


class RasterWrapper(Raster, HeightDataObjectSupport):

    def __init__(self, raster: Raster, rasterDef: BindingDefinition) -> None: ...

    def bindingTransform(self) -> QtGui.QTransform: ...
    def getZcoord(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], cs: _cs.CoordSystem) -> typing.Tuple[float, bool]: ...
    def hasZCoord(self) -> bool: ...
    def bindingDefinition(self) -> BindingDefinition: ...
    def innerBindingDefinition(self) -> BindingDefinition: ...
    def setProperties(self, props: DataObjectProperties) -> None: ...
    def properties(self) -> DataObjectProperties: ...
    def dependencies(self) -> list[DataObject]: ...
    def originalSource(self) -> typing.Any: ...
    def canSaveRegistration(self) -> bool: ...
    def originalObject(self) -> typing.Any: ...
    def definition(self) -> DataObjectDefinition: ...
    def accessMode(self) -> AccessMode: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def reprojectedImage(self, destRect: GeoRect, size: QtCore.QSize, pixelToSourceCs: QtGui.QTransform) -> QtGui.QImage: ...
    def imageRect(self, source: QtCore.QRect, size: QtCore.QSize) -> QtGui.QImage: ...
    def size(self) -> QtCore.QSize: ...


class WebDefinition(UrlDefinition):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, url: QtCore.QUrl) -> None: ...
    @typing.overload
    def __init__(self, a0: 'WebDefinition') -> None: ...

    def setAuthenticator(self, value: QtNetwork.QAuthenticator) -> None: ...
    def authenticator(self) -> QtNetwork.QAuthenticator: ...
    def isSameSource(self, other: DataSourceDefinition) -> bool: ...
    def setUrl(self, value: QtCore.QUrl) -> None: ...
    def url(self) -> QtCore.QUrl: ...


class FileDataProvider(DataProvider):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    @typing.overload
    def quickOpenFile(self, fileName: str) -> typing.Any: ...
    @typing.overload
    def quickOpenFile(self, fileInfo: QtCore.QFileInfo) -> typing.Any: ...
    def displayDescription(self) -> str: ...
    def fileTypeCategories(self) -> FileCategoriesList: ...


class ProviderExportSupport(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ProviderExportSupport') -> None: ...

    def exportSupportId(self) -> str: ...
    def exportFeatures(self, cursor: Cursor, ctx: 'ProviderExportContext', jd: 'JsonDefinition') -> 'OpeningStatus': ...
    def adjustJsonDefinitionFromContext(self, ctx: 'ProviderExportContext', jd: 'JsonDefinition') -> None: ...
    def canAcceptDestination(self, jd: 'JsonDefinition') -> 'OpeningStatus': ...
    def canHaveGeometry(self) -> bool: ...


class FileDataProviderWithExportSupport(FileDataProvider, ProviderExportSupport):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...


class Query(_core_serializable.axioma.serialization.Serializable): ...


class TableQuery(Query):

    attributeNames = ... # type: typing.Iterable[str]

    @typing.overload
    def __init__(self, aAttributeNames: typing.Iterable[str] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'TableQuery') -> None: ...

    def setAttributeNames(self, value: typing.Iterable[str]) -> None: ...
    def attributeName(self, index: int) -> str: ...
    def numAttributeNames(self) -> int: ...


class QuerySelectAll(TableQuery):

    @typing.overload
    def __init__(self, attributeNames: typing.Iterable[str] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QuerySelectAll') -> None: ...


class QueryGeometric(TableQuery):

    @typing.overload
    def __init__(self, params: TableQuery, geomAttributeName: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QueryGeometric') -> None: ...

    def getGeomAttributeName(self) -> str: ...


class QuerySelectInMbr(QueryGeometric):

    @typing.overload
    def __init__(self, rect: GeoRect, params: TableQuery, geomAttributeName: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QuerySelectInMbr') -> None: ...

    def setGeoRect(self, value: GeoRect) -> None: ...
    def setBoundingRect(self, value: QtCore.QRectF) -> None: ...
    def setCoordSystem(self, value: _cs.CoordSystem) -> None: ...
    def geoRect(self) -> GeoRect: ...
    @typing.overload
    def boundingRect(self) -> QtCore.QRectF: ...
    @typing.overload
    def boundingRect(self, cs: _cs.CoordSystem) -> QtCore.QRectF: ...
    def coordSystem(self) -> _cs.CoordSystem: ...


class QuerySelectInObject(QueryGeometric):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QuerySelectInObject') -> None: ...

    def coordSystem(self) -> _cs.CoordSystem: ...


class QuerySelectWithFilter(TableQuery):

    @typing.overload
    def __init__(self, filterStr: str, params: TableQuery) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QuerySelectWithFilter') -> None: ...

    def filterString(self) -> str: ...


class QuerySelectById(TableQuery):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QuerySelectById') -> None: ...


class PageRange(sip.wrapper):

    count = ... # type: int
    offset = ... # type: int

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, aStart: int) -> None: ...
    @typing.overload
    def __init__(self, aStart: int, aCount: int) -> None: ...
    @typing.overload
    def __init__(self, a0: 'PageRange') -> None: ...

    def croppedToSize(self, size: int) -> 'PageRange': ...
    def cropToSize(self, size: int) -> None: ...
    def lastIndex(self) -> int: ...


class VariantComparator(sip.wrapper):

    def __init__(self) -> None: ...

    def __call__(self, first: typing.Any, second: typing.Any) -> bool: ...


class NamedObjectDefinition(DataObjectDefinition):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, name: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'NamedObjectDefinition') -> None: ...

    @staticmethod
    def emptyInstance() -> 'NamedObjectDefinition': ...
    def name(self) -> str: ...
    def displayName(self) -> str: ...
    def isSame(self, other: DataObjectDefinition) -> bool: ...


class SqlObjectDefinition(NamedObjectDefinition):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, sql: str, name: str = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'SqlObjectDefinition') -> None: ...

    def displayName(self) -> str: ...
    def isSame(self, other: DataObjectDefinition) -> bool: ...
    def sqlString(self) -> str: ...
    def setSqlString(self, sql: str) -> None: ...


class DatabaseProviderExportSupport(ProviderExportSupport):

    createIndexTag = ... # type: str
    dropTableTag = ... # type: str
    errorFileTag = ... # type: str
    fixGeometryTag = ... # type: str
    geometryAsTextTag = ... # type: str
    geometryColumnNameTag = ... # type: str
    logFileTag = ... # type: str
    mapCatalogTag = ... # type: str
    primaryKeyName = ... # type: str
    renditonColumnNameTag = ... # type: str
    sridTag = ... # type: str

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'DatabaseProviderExportSupport') -> None: ...


class DatabaseProvider(DataProvider, DatabaseProviderExportSupport):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def linkedProvider(self) -> DataProvider: ...
    @staticmethod
    def databaseDefinition(host: str, dbName: str, userName: str, password: str, port: int) -> DatabaseDefinition: ...
    def createDataSourceDefinition(self, typeId: str) -> DataSourceDefinition: ...
    def defaultPort(self) -> int: ...
    def createDatabaseDefinition(self, host: str, dbName: str, userName: str, password: str, port: int = ...) -> DatabaseDefinition: ...


class SqlObjectStyledDefinition(SqlObjectDefinition):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'SqlObjectStyledDefinition') -> None: ...

    def isSame(self, other: DataObjectDefinition) -> bool: ...
    def setStyleString(self, styleString: str) -> None: ...
    def styleString(self) -> str: ...
    def setStyleFieldName(self, styleFieldName: str) -> None: ...
    def styleFieldName(self) -> str: ...


class DbTableParam(sip.wrapper):

    class TypeObject(int): ...
    unknown = ... # type: 'DbTableParam.TypeObject'
    table = ... # type: 'DbTableParam.TypeObject'
    view = ... # type: 'DbTableParam.TypeObject'

    @typing.overload
    def __init__(self, owner: str, name: str, type: 'DbTableParam.TypeObject' = ...) -> None: ...
    @typing.overload
    def __init__(self, owner: str, name: str, type: str) -> None: ...

    def type(self) -> 'DbTableParam.TypeObject': ...
    def name(self) -> str: ...
    def owner(self) -> str: ...
    def fullName(self) -> str: ...


class DatabaseMetadata(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'DatabaseMetadata') -> None: ...

    def listOwners(self) -> typing.List[str]: ...
    def listTables(self) -> typing.Any: ...
    def currentSchema(self) -> str: ...
    def boundingRect(self, owner: str, table: str, field: str) -> QtCore.QRectF: ...
    def tableUniqueFields(self, owner: str, table: str) -> typing.Any: ...
    def tableAttributes(self, ownerName: str, tableName: str) -> typing.Any: ...
    def geometryParams(self, owner: str, table: str) -> typing.Any: ...


class DbTableName(sip.wrapper):

    ownerName = ... # type: str
    schemaName = ... # type: str
    tableName = ... # type: str

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'DbTableName') -> None: ...


class SqlMaker(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'SqlMaker') -> None: ...

    def quoteName(self, str: str) -> str: ...
    def unquoteSymbol(self) -> str: ...
    def quoteSymbol(self) -> str: ...
    def extractTableName(self, sqlBase: str, defaultOwner: str = ...) -> DbTableName: ...
    def insertSelectField(self, sqlBase: str, addedField: str, cs: QtCore.Qt.CaseSensitivity = ...) -> str: ...
    def insertCondition(self, sqlBase: str, condition: str) -> str: ...
    def makeRangeSql(self, sqlBase: str, pageRange: PageRange) -> str: ...


class DatabaseMapinfoMapcatalogSupport(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'DatabaseMapinfoMapcatalogSupport') -> None: ...

    def mapinfoMapcatalog(self) -> 'DatabaseMapinfoMapcatalog': ...


class DatabaseSource(DataSource, DatabaseMapinfoMapcatalogSupport):

    def __init__(self, provider: DatabaseProvider) -> None: ...

    def rollbackTransaction(self) -> None: ...
    def commitTransaction(self) -> None: ...
    def beginTransaction(self) -> bool: ...
    def metadata(self) -> DatabaseMetadata: ...
    def descriptionServer(self) -> str: ...
    def sqlMaker(self) -> SqlMaker: ...
    def executeCommand(self, command: str) -> None: ...
    def canRemoveEmpty(self) -> bool: ...
    def customObjectDefinition(self, sqlString: str) -> typing.Any: ...
    def tableAttributes(self, ownerName: str, tableName: str) -> typing.Any: ...


class DatabaseMapinfoMapcatalog(sip.wrapper):

    class TypeObject(int): ...
    Points = ... # type: 'DatabaseMapinfoMapcatalog.TypeObject'
    Lines = ... # type: 'DatabaseMapinfoMapcatalog.TypeObject'
    Regions = ... # type: 'DatabaseMapinfoMapcatalog.TypeObject'
    All = ... # type: 'DatabaseMapinfoMapcatalog.TypeObject'
    Text = ... # type: 'DatabaseMapinfoMapcatalog.TypeObject'

    class KindStyleStore(int): ...
    None = ... # type: 'DatabaseMapinfoMapcatalog.KindStyleStore'
    Table = ... # type: 'DatabaseMapinfoMapcatalog.KindStyleStore'
    Mapcatalog = ... # type: 'DatabaseMapinfoMapcatalog.KindStyleStore'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'DatabaseMapinfoMapcatalog') -> None: ...

    def unregisterTable(self, owner: str, table: str) -> None: ...
    def registerTable(self, owner: str, table: str, geomFieldName: str, objType: 'DatabaseMapinfoMapcatalog.TypeObject' = ...) -> None: ...
    def tableRegistered(self, owner: str, table: str) -> bool: ...
    def checkExist(self) -> bool: ...
    def setMapinfoStyleString(self, owner: str, table: str, str: str) -> None: ...
    def setStyleAttributeName(self, owner: str, table: str, nameColumn: str) -> None: ...
    def setCoordSystem(self, owner: str, table: str, cs: _cs.CoordSystem) -> None: ...
    def setXYColumnNames(self, owner: str, table: str, names: typing.Any) -> None: ...
    def setRect(self, owner: str, table: str, rect: QtCore.QRectF) -> None: ...
    def typeStoreObjects(self, owner: str, table: str) -> 'DatabaseMapinfoMapcatalog.TypeObject': ...
    def xyColumnNames(self, owner: str, table: str) -> typing.Any: ...
    def styleInColumnTable(self, owner: str, table: str) -> bool: ...
    def geometryAttributeName(self, owner: str, table: str) -> str: ...
    def styleAttributeName(self, owner: str, table: str) -> str: ...
    def mapinfoStyleString(self, owner: str, table: str) -> str: ...
    def coordSystem(self, owner: str, table: str) -> _cs.CoordSystem: ...
    def rect(self, owner: str, table: str) -> QtCore.QRectF: ...
    def setUpFromMetadata(self) -> None: ...
    def removeAll(self) -> None: ...
    def createStructure(self, fillData: bool = ...) -> None: ...


class MapinfoMapcatalogPointer(sip.wrapper):

    @typing.overload
    def __init__(self, catalog: DatabaseMapinfoMapcatalog, owner: str, table: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'MapinfoMapcatalogPointer') -> None: ...

    def typeStoreObjects(self) -> DatabaseMapinfoMapcatalog.TypeObject: ...
    def tableName(self) -> str: ...
    def ownerName(self) -> str: ...
    def xyColumnNames(self) -> typing.Any: ...
    def styleInColumnTable(self) -> bool: ...
    def geometryAttributeName(self) -> str: ...
    def styleAttributeName(self) -> str: ...
    def mapinfoStyleString(self) -> str: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def rect(self) -> QtCore.QRectF: ...


class axioma(sip.simplewrapper):

    class dp(sip.simplewrapper):

        class TransientInteger(sip.wrapper):

            @typing.overload
            def __init__(self, num: int = ...) -> None: ...
            @typing.overload
            def __init__(self, a0: 'axioma.dp.TransientInteger') -> None: ...

            def toString(self) -> str: ...
            def value(self) -> int: ...


class JsonDefinition(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, json: typing.Dict[str, QtCore.QJsonValue]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'JsonDefinition') -> None: ...


class JsonController(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'JsonController') -> None: ...

    @staticmethod
    def setCodec(m: JsonDefinition, value: QtCore.QTextCodec) -> None: ...
    @staticmethod
    def codec(m: JsonDefinition, ifNull: typing.Optional[str] = ...) -> QtCore.QTextCodec: ...
    @staticmethod
    def setPrj(m: JsonDefinition, value: typing.Any) -> None: ...
    @staticmethod
    def prj(m: JsonDefinition) -> typing.Any: ...
    @staticmethod
    def setObject(m: JsonDefinition, value: str) -> None: ...
    @staticmethod
    def object(m: JsonDefinition) -> str: ...
    @staticmethod
    def setSource(m: JsonDefinition, value: str) -> None: ...
    @staticmethod
    def source(m: JsonDefinition) -> str: ...
    @staticmethod
    def setAccessMode(m: JsonDefinition, value: AccessMode) -> None: ...
    @staticmethod
    def accessMode(m: JsonDefinition, ifNull: AccessMode = ...) -> AccessMode: ...
    @staticmethod
    def setOpenWith(m: JsonDefinition, value: str) -> None: ...
    @staticmethod
    def openWith(m: JsonDefinition) -> str: ...


class JsonDataCreationController(JsonController):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'JsonDataCreationController') -> None: ...

    @staticmethod
    def setSpec(m: JsonDefinition, value: typing.Union[QtCore.QJsonValue, QtCore.QJsonValue.Type, typing.Iterable[QtCore.QJsonValue], typing.Dict[str, QtCore.QJsonValue], bool, int, float, str]) -> None: ...
    @staticmethod
    def spec(jsonDef: JsonDefinition) -> QtCore.QJsonValue: ...
    @staticmethod
    def setCreate(m: JsonDefinition, value: bool) -> None: ...
    @staticmethod
    def create(m: JsonDefinition, ifNull: bool = ...) -> bool: ...


class JsonDBController(JsonController):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'JsonDBController') -> None: ...

    @staticmethod
    def setSql(def_: JsonDefinition, sql: str) -> None: ...
    @staticmethod
    def sql(def_: JsonDefinition) -> str: ...
    @staticmethod
    def setDbDef(def_: JsonDefinition, value: DatabaseDefinition) -> None: ...
    @staticmethod
    def dbDef(def_: JsonDefinition) -> DatabaseDefinition: ...


class JsonDBExportController(JsonDBController):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'JsonDBExportController') -> None: ...

    @staticmethod
    def setExportParams(def_: JsonDefinition, obj: typing.Dict[str, QtCore.QJsonValue]) -> None: ...
    @staticmethod
    def exportParams(def_: JsonDefinition) -> typing.Dict[str, QtCore.QJsonValue]: ...


class ProviderExportContext(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, schema: ModifiedTableSchema) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ProviderExportContext') -> None: ...

    def setDataCatalog(self, dataCatalog: DataCatalogInterface) -> None: ...
    def dataCatalog(self) -> DataCatalogInterface: ...
    def setTargetSchema(self, value: ModifiedTableSchema) -> None: ...
    def targetSchema(self) -> ModifiedTableSchema: ...


class OpeningStatus(sip.wrapper):

    class Value(int): ...
    Unknown = ... # type: 'OpeningStatus.Value'
    Aborted = ... # type: 'OpeningStatus.Value'
    Rejected = ... # type: 'OpeningStatus.Value'
    Accepted = ... # type: 'OpeningStatus.Value'
    WillAcceptWithMoreInfo = ... # type: 'OpeningStatus.Value'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'OpeningStatus') -> None: ...


class ForeignKey(QtCore.QObject):

    class FromTo(sip.wrapper):

        attributeKey = ... # type: str
        attributeKeyForeign = ... # type: str
        attributeNameForeign = ... # type: str

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'ForeignKey.FromTo') -> None: ...


class ForeignKeyManagerExtension(_core_plugin.Extension):

    def __init__(self) -> None: ...

    def count(self) -> int: ...
    def unregisterForeignKeyByData(self, defBase: JsonDefinition) -> bool: ...
    def registerForeignKeyByData(self, defBase: JsonDefinition, defForeign: JsonDefinition, keyData: ForeignKey.FromTo) -> None: ...


@typing.overload
def recoverHistory(dataObject: typing.Any, filePath: str) -> bool: ...
@typing.overload
def recoverHistory(dataObject: typing.Any) -> bool: ...
@typing.overload
def wrap(table: EditableTable, filePath: str) -> typing.Any: ...
@typing.overload
def wrap(table: EditableTable) -> typing.Any: ...
