import os
import os.path
import sys

# install custom exception hook
sys._excepthook = sys.excepthook

def axioma_excepthook(extype, value, traceback):
    print("Unhandled Python Exception:", file=sys.stderr)
    sys._excepthook(extype, value, traceback)

sys.excepthook = axioma_excepthook


try:
    import numpy
except:
    pass


def _contains_core_binary(path):
    """Possible values:
        core.dll libcore.so.* libcore.*.dylib
    """
    for filename in os.listdir(path):
        if filename.startswith('core.'):
            return True
        if filename.startswith('libcore.'):
            return True
    return False


def _isValidHome(path):
    return os.path.isdir(path) and _contains_core_binary(path)


def installPath():
    if os.name == 'nt':
        return os.path.normpath(os.path.join(os.path.dirname(__file__),'..','..','..','..'))
    elif sys.platform.startswith('darwin'):
        return os.path.normpath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..', '..', '..', '..', '..', 'Frameworks'))
    else:
        return os.path.normpath(os.path.join(os.path.dirname(__file__),'..','..','..','..','..','bin'))

def _setupEnvironment():
    devpath = os.path.normpath(os.path.join(os.path.dirname(__file__),'..', '..'))
    installpath = installPath()

    if _isValidHome(installpath):
        home = installpath
        dev = False
    elif _isValidHome(devpath):
        home = devpath
        dev = True
    else:
        try:
            from .dev_config import dev_home, is_distrib_install
            home=dev_home
            dev=not is_distrib_install
        except:
            raise RuntimeError("Can't find Axioma installation")
    if dev:
        os.environ['PATH'] = os.path.join(home, '..','..','third-party', 'out', 'bin') + os.pathsep + os.environ.get('PATH', '')
    os.environ['PATH'] = home + os.pathsep + os.environ['PATH']
    os.environ['AXIOMA_HOME'] = home
    if not dev:
        if sys.platform.startswith('darwin'):
            os.environ['QT_PLUGIN_PATH'] = os.path.join(home, '..', 'PlugIns')
        else:
            os.environ['QT_PLUGIN_PATH'] = os.path.join(home, 'qtplugins')

if not 'AXIOMA_HOME' in os.environ:
    _setupEnvironment()
