import os

from .pen.mipen2axioma import Utils
from .pen.mipen import MIPenParser


def convert(input_file, output_dir, ids=set()):
    pen_parser = MIPenParser(input_file)
    if not len(ids):
        # convert all pens
        count = len(pen_parser.pens)
        print("count {}".format(count))
        for i in range(1, count):
            save_pen(pen_parser, i, output_dir)
        print("save to {} is done".format(output_dir))
    else:
        # pens from ids set only
        for id in ids:
            save_pen(pen_parser, id, output_dir)
            print("file {} saved.. {}".format(id, fn))


def save_pen(pen_parser, index, output_dir):
    """
        сохранение файла trtp-pen в текстовый файл
        i - порядковый номер pen'а
    """
    file_name = "pen_{}.trtp".format('{:03d}'.format(index))
    file_path = os.path.join(output_dir, file_name)
    with open(file_path, 'w') as f:
        f.write(Utils.convert(pen_parser.pens[index]))
    return file_path
