import axioma.gui
import axioma.common
import PyQt5.QtCore
from PyQt5.QtCore import QMetaObject, Qt
from axioma.gui import ItemView, MapView
from PyQt5.QtWidgets import QWidget, QPushButton
import PyQt5.QtWidgets
import axioma.gui.WidgetManager

'''
Пример работы с менеджером окон. Рассматриваются обработка таких событий, как изменение количества окон (карт/всех)
а также изменение масштаба окна карты.
'''

wm = axioma.app.gui.widgetManager

# тесты
try:
	wm.connectWidgetCountChanged(None, None, 5)
except TypeError as e:
	print("test 1")
	print(e)

try:
	wm.connectWidgetCountChanged(MapView, None, 5)
except TypeError as e:
	print("test 2")
	print(e)
	
try:
	wm.connectWidgetCountChanged(MapView, None, lambda x, y: None)
except TypeError as e:
	print("test 3")
	print(e)


wm.connectWidgetCountChanged(PyQt5.QtCore.QObject, None, lambda:None)

# Событие изменения количества открытых окон
callbackMap = lambda: print("MapViews") # Карт
callbackItem = lambda x: print("ItemViews: ", x) # Всех окон менеджера
wm.connectWidgetCountChanged(MapView, None, callbackMap)
wm.connectWidgetCountChanged(ItemView, None, callbackItem)

# Изменение текущего окна (например, при добавлении окна карты)
callbackChanged = lambda w: print("WidgetChanged: ", w.windowTitle())
wm.connectWidgetChanged(QWidget, None, callbackChanged)

# Изменение масштаба окна карты
callbackChangedP = lambda zoom: print("zoom changed: ", zoom)

# Создается окно с кнопкой. По нажатию на кнопку обработчик событий отключается.
guard = QPushButton("Disconnect")
guard.setAttribute(Qt.WA_DeleteOnClose)
guard.clicked.connect(guard.close)
guard.show()

# Подключение к событию изменения масштаба карты
wm.connectCurrentWidget(MapView, MapView.zoomChanged, guard, callbackChangedP)



