from PyQt5.QtGui import QMouseEvent, QPainter, QPen, QIcon
from PyQt5.QtWidgets import *
from PyQt5.QtCore import Qt, QObject
from axioma.app import mainWindow
from axioma.gui import *
from axioma.cs import CoordTransform
import axioma.gui.extension
from axioma.core.plugin import *

'''
Пример создания пользовательского инструмента. По нажатию в окне карты или отчета красным цветом будет отрисована точка.
Также в окно консоли выводятся координаты точки.
'''


class MyRedPointsTool(Tool):
    """Инструмент, позволяющий указывать точки на карте.
       Точки хранятся в координатах карты.
       При смене проекции точки преобразуются в новую координатную систему карты
    """

    def __init__(self, parent=None):
        # инициализация
        super().__init__(parent)
        self.setObjectName("MyRedPointsTool")
        self.__points = []
        print("Tool '%s' is constructed" % self.objectName())

    def paintEvent(self, event, painter):
        # нарисовать точки
        painter.setPen(QPen(Qt.red, 5, Qt.SolidLine))
        for point in self.getDevicePoints():
            painter.drawPoint(point)
    
    def mouseDoubleClickEvent(self, event):
        # очистим список точек на двойной клик
        self.__points.clear()
        self.widget().update()
        return Tool.PassEvent

    def mousePressEvent(self, event):
        if event.button() != Qt.LeftButton:
            return
        self.addPoint(event.pos())
        self.widget().update()
        return Tool.PassEvent
        
    def addPoint(self, point):
        # добавить новую точку
        # преобразовать координату точки области рисования в координату на карте
        scene_point = self.widget().viewport().mapToScene(point)
        self.__points.append(scene_point)
        print(scene_point)
        
    def getDevicePoints(self):
        """Получить координаты точек области рисования"""
        return [self.widget().viewport().mapToDevice(point) for point in self.__points]
        
    def coordSysAboutToChange(self, cs):
        """Действия перед сменой проекции"""
        # сконвертируем точки в новую проекцию
        if not len(self.__points):
            return
        transform = CoordTransform(self.coordSystem(), cs)
        self.__points = transform.forward(self.__points)


# Регистрируем расширение в системе.
ext = axioma.gui.extension.BasicToolExtension(MyRedPointsTool, axioma.gui.MapView, "pluginMyRedPointsTool", icon=QIcon.fromTheme("add"), text="Красная точка")
axioma.app.gui.prependExtension(ext)

# Добавляем инструмент в закладку карты
ribbonExt = axioma.gui.extension.RibbonExtension()
ribbonExt.addAction("pluginMyRedPointsTool", "map", "operations")
axioma.app.gui.prependExtension(ribbonExt)
