'''

Пример показа информации о текушем выделении. 
При изменении выделения в окне карты показывает текущую сводную информацию о нем.
Загружается в виде Dock окна.

dependencies:
SelectionManager
MainWindow
'''

from PyQt5.QtWidgets import QDockWidget
from PyQt5.QtGui import QIcon
from PyQt5.QtCore import Qt
import axioma.app

def create_dock_widget(widget, obj_name, title, icon=QIcon(), parent=None):
    """Создает плавающую панель"""
    dock = QDockWidget(title, parent)
    dock.setObjectName(obj_name)
    dock.setWidget(widget)
    dock.toggleViewAction().setObjectName(obj_name + "Toggle")
    dock.toggleViewAction().setIcon(icon)
    return dock

class DockSelectionExtension(axioma.core.plugin.Extension):
    def __init__(self):
        super().__init__()
        self.mainWindow = self.createDependencyGetter(axioma.app.MainWindow)

    def onResolved(self):
        # создаем док область
        from .selection_widget import CurrentSeletionWidget
        selection_manager = axioma.app.gui.selectionManager()
        widget = CurrentSeletionWidget(selection_manager, self.mainWindow())
        dock = create_dock_widget(widget, "currentSelectionDock", "Выделение", QIcon.fromTheme("info_cursor"), parent=self.mainWindow())
        # добавляем в главное окно
        self.mainWindow().addDockWidget(Qt.RightDockWidgetArea, dock)
        self.mainWindow().addPanel(dock)

def createExtensions():
    return [DockSelectionExtension()]


