from .data_provider import DataProvider
from .source import Source, Destination, Schema
from typing import List


class ExcelSource(Source):
    pass


class ExcelDataProvider(DataProvider):
    """Провайдер чтения файлов Excel."""
    _identifier = 'XlsDataProvider'

    def get_source(self, filepath: str, page: str, with_header: bool = False,
                   encoding: str = 'utf8') -> Source:
        """Создает источник данных.

        Args:
            filepath: Путь к файлу.
            page: Имя страницы.
            with_header: Признак того, что в первой строке содержатся имена
                атрибутов таблицы.
            encoding: Кодировка.
        """
        return ExcelSource(
            Source._provider(self.id),
            Source._table_file(filepath),
            {
                'SheetName': page,
                'FirstRowAsFieldName': with_header,
                'charset': encoding
            }
        )

    def get_destination(self) -> Destination:
        """
        Attention:
            Не поддерживается.
        """
        raise NotImplementedError
