def fixup_module_metadata(module_name, namespace):
    seen_ids = set()

    def fix_one(qualname, name, obj):
        if id(obj) in seen_ids:
            return
        seen_ids.add(id(obj))

        mod = getattr(obj, '__module__', None)
        if mod is not None and mod.startswith('axipy.'):
            try:
                obj.__module__ = module_name
            except:
                pass
            if hasattr(obj, '__name__') and '.' not in obj.__name__:
                obj.__name__ = name
                obj.__qualname__ = qualname
            if isinstance(obj, type):
                for attr_name, attr_value in obj.__dict__.items():
                    fix_one(objname + '.' + attr_name, attr_name, attr_value)

    for objname, obj in namespace.items():
        if not objname.startswith('_'):
            fix_one(objname, objname, obj)
