from axioma.gui import *
from PyQt5.QtGui import QMouseEvent, QPainter, QPen, QIcon
from PyQt5.QtWidgets import *
from PyQt5.QtCore import Qt, QObject
from axioma.app import mainWindow
import axioma.gui.extension
from axioma.core.plugin import *

'''
Пример создания пользовательского инструмента. По нажатию в окне карты или отчета красным цветом будет отрисована точка.
Для простоты точки хранятся в экранных координатах и при изменении котеннта карты они остаются на месте.
Для изменения данного поведения см. toolsDotsOnMap.py
'''

class MyRedPointsTool(Tool):
    """Инструмент, позволяющий указывать точки на карте.
       Точки хранятся в экранных координатах.
    """

    def __init__(self, parent=None):
        super().__init__(parent)
        self.__points = []

    def paintEvent(self, event, painter):
        # нарисовать точки
        painter.setPen(QPen(Qt.red, 5, Qt.SolidLine))
        for point in self.__points:
            painter.drawPoint(point)

    def mouseDoubleClickEvent(self, event):
        self.__points.clear()
        self.widget().update()
        return Tool.PassEvent

    def mousePressEvent(self, event):
        try:
          if event.button() != Qt.LeftButton:
            return
          self.__points.append(event.pos())
          self.widget().update()
        except Exception as ex:
          print(ex)
        finally:
            return Tool.PassEvent

#Объявляем свой пользовательский контроллер
class MyToolController(axioma.gui.extension.ToolController):
    def __init__(self, widgetClass, toolClassName, parent = None):
        super().__init__(widgetClass, parent)
        self.__toolClassName = toolClassName

    def createTool(self, widget):
# Здесь создается инструмент. Можно вместо self.__toolFactory использовать явный вызов коструктора MyRedPointsTool
        widget.setCursor(Qt.PointingHandCursor) # Установка курсора, если это необходимо
        return self.__toolClassName(widget)

    def  isEnabled(self):
        return True

#Объявляем расширение, которое создает инструмент
class MyToolExtension(axioma.gui.extension.ToolControllerExtension):
    def __init__(self, toolClassName, widgetClass, actionId, category = "", tab = "", group = "", icon = None, text = None):
        controllerFactory = lambda: self.createToolController(widgetClass, toolClassName)
        super().__init__(controllerFactory, actionId, category=category, tab=tab, group=group, icon=icon, text=text)

    def createToolController(self, widgetClass, toolClassName):
        res = MyToolController(widgetClass, toolClassName)
#Здесь можно передать созданному контроллеру какие-то параметры, которые можно потом использовать для создания инструмента
        return res

# Регистрируем расширение в системе.
ext = MyToolExtension(MyRedPointsTool, axioma.gui.MapView, "pluginMyRedPointsTool", icon=QIcon.fromTheme("add"), text="Красная точка")
axioma.app.gui.prependExtension(ext)

# Добавляем инструмент в закладку карты
ribbonExt = axioma.gui.extension.RibbonExtension()
ribbonExt.addAction("pluginMyRedPointsTool", "map", "operations")
axioma.app.gui.prependExtension(ribbonExt)
