import os
from PyQt5.QtWidgets import QWidget
from axioma.core.dp import SelectionManager
from PyQt5.uic import loadUi

class CurrentSeletionWidget(QWidget):
    """
    Класс отображения информации о текущем выделении
    """
    
    def __init__(self, selection_manager, parent=None):
        super().__init__(parent)
        cwd = os.path.dirname(__file__)
        self.__ui = loadUi(os.path.join(cwd, "selection_widget.ui"), self)
        selection_manager.selectionChanged.connect(self.onSelectionChanged)

    #slot
    def onSelectionChanged(self, selection_info):
        # на изменение выделения
        selected = selection_info.selected()
        size = selected.size()
        self.__ui.lblCount.setNum(size)
        table_name = selected.table.name() if size and selected.table else ""
        self.__ui.lblTableName.setText(table_name)

