from axioma.render import *
from axioma.core.geometry import Point
from axioma.common import RuntimeException
from PyQt5.QtCore import  Qt

# Изменяем параметры подписывания. Перед запуском необходимо открыть карту.

# layer label properties; для всего слоя
mv_man = axioma.app.mainWindow.mapViewManager()
if not mv_man.mapViews():
    raise RuntimeException("Отсутствуют открытые карты")
mv = mv_man.mapViews()[0]
layer = mv.allTableLayersWithoutCosmetic()[0]
props = layer.featureLayerProperties()
props.setShowLabels(True)
lp = props.labelProperties()

lp.layout.setAlignment(Qt.BottomEdge | Qt.RightEdge)

# так как метод FeatureLayerProperties.labelProperties() возвращает копию LabelProperties,
# модифицированные настройки необходимо установить 
props.setLabelProperties(lp)

# feature label properties; для отдельных записей

# get feature
# берем запись, к которой будем добавлять выноску
table = layer.table()
feature = table.allFeatures()[0]

# prepare new LabelProperties with callout that points to (0, 0)
# создаем выноску
# для редактирования стиля используйте диалог axioma.gui.StyleEditDialog
lp.layout.setAlignment()
lp.position = Point(mv.viewport().coordSystem(), 0, 0)
lp.callout.setEndType(LabelCallout.Line)

feature_id = feature.id()
container = mv.map().labelContainer()

# apply changes; применить изменения
container.insert(layer, feature_id, lp)

#обновим слой на карте
layer.needRedraw.emit(layer)
